/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.managers;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.tr7zw.nbtapi.NBT;
import de.tr7zw.nbtapi.iface.ReadWriteItemNBT;
import de.tr7zw.nbtapi.iface.ReadWriteNBT;
import de.tr7zw.nbtapi.iface.ReadableNBT;
import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropItem;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.result.NBTApplyResult;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002\u00a8\u0006\u0012"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/NBTManager;", "", "<init>", "()V", "applyNBTDataItem", "Lio/github/arcaneplugins/levelledmobs/result/NBTApplyResult;", "item", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropItem;", "nbtStuff", "", "applyNBTDataMob", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "formulateChangedJson", "", "jsonBefore", "jsonAfter", "applyResult", "levelledmobs-plugin"})
public final class NBTManager {
    @NotNull
    public static final NBTManager INSTANCE = new NBTManager();

    private NBTManager() {
    }

    @NotNull
    public final NBTApplyResult applyNBTDataItem(@NotNull CustomDropItem item, @NotNull String nbtStuff) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(nbtStuff, "nbtStuff");
        NBTApplyResult result = new NBTApplyResult();
        ReadWriteNBT itemNbt = null;
        String jsonBefore = null;
        if (LevelledMobs.Companion.getInstance().getDebugManager().isDebugTypeEnabled(DebugType.NBT_APPLICATION)) {
            itemNbt = NBT.createNBTObject();
            NBT.get((ItemStack)item.getItemStack(), arg_0 -> ((ReadWriteNBT)itemNbt).mergeCompound(arg_0));
            jsonBefore = itemNbt.toString();
        }
        try {
            NBT.modify((ItemStack)item.getItemStack(), arg_0 -> NBTManager.applyNBTDataItem$lambda$0(nbtStuff, arg_0));
            if (LevelledMobs.Companion.getInstance().getDebugManager().isDebugTypeEnabled(DebugType.NBT_APPLICATION)) {
                ItemStack itemStack = item.getItemStack();
                ReadWriteNBT readWriteNBT = itemNbt;
                Intrinsics.checkNotNull(readWriteNBT);
                NBT.get((ItemStack)itemStack, arg_0 -> ((ReadWriteNBT)readWriteNBT).mergeCompound(arg_0));
                result.setItemStack(item.getItemStack());
                String jsonAfter = itemNbt.toString();
                String string = jsonBefore;
                Intrinsics.checkNotNull(string);
                this.formulateChangedJson(string, jsonAfter, result);
            }
        }
        catch (Exception e) {
            result.setExceptionMessage(e.getMessage());
        }
        return result;
    }

    @NotNull
    public final NBTApplyResult applyNBTDataMob(@NotNull LivingEntityWrapper lmEntity, @NotNull String nbtStuff) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(nbtStuff, "nbtStuff");
        NBTApplyResult result = new NBTApplyResult();
        String jsonBefore = null;
        ReadWriteNBT entityNbt = null;
        try {
            if (LevelledMobs.Companion.getInstance().getDebugManager().isDebugTypeEnabled(DebugType.NBT_APPLICATION)) {
                entityNbt = NBT.createNBTObject();
                NBT.get((Entity)((Entity)lmEntity.getLivingEntity()), arg_0 -> ((ReadWriteNBT)entityNbt).mergeCompound(arg_0));
                jsonBefore = entityNbt.toString();
            }
            NBT.modify((Entity)((Entity)lmEntity.getLivingEntity()), arg_0 -> NBTManager.applyNBTDataMob$lambda$0(nbtStuff, arg_0));
            if (LevelledMobs.Companion.getInstance().getDebugManager().isDebugTypeEnabled(DebugType.NBT_APPLICATION)) {
                Entity entity = (Entity)lmEntity.getLivingEntity();
                ReadWriteNBT readWriteNBT = entityNbt;
                Intrinsics.checkNotNull(readWriteNBT);
                NBT.get((Entity)entity, arg_0 -> ((ReadWriteNBT)readWriteNBT).mergeCompound(arg_0));
                String jsonAfter = entityNbt.toString();
                String string = jsonBefore;
                Intrinsics.checkNotNull(string);
                this.formulateChangedJson(string, jsonAfter, result);
                if (Intrinsics.areEqual(jsonBefore, jsonAfter)) {
                    result.setExceptionMessage("No NBT data changed.  Make sure you have used proper NBT strings");
                }
            }
        }
        catch (Exception e) {
            result.setExceptionMessage(e.getMessage());
        }
        return result;
    }

    private final void formulateChangedJson(String jsonBefore, String jsonAfter, NBTApplyResult applyResult) {
        Map objectsBefore = new LinkedHashMap();
        Map objectsAfter = new LinkedHashMap();
        JsonObject jsonObjectBefore = JsonParser.parseString((String)jsonBefore).getAsJsonObject();
        JsonObject jsonObjectAfter = JsonParser.parseString((String)jsonAfter).getAsJsonObject();
        try {
            for (String key : jsonObjectBefore.keySet()) {
                objectsBefore.put(key, jsonObjectBefore.get(key).toString());
            }
            for (String key : jsonObjectAfter.keySet()) {
                objectsAfter.put(key, jsonObjectAfter.get(key).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (String key : jsonObjectAfter.keySet()) {
            String value;
            Intrinsics.checkNotNullExpressionValue(jsonObjectAfter.get(key).toString(), "toString(...)");
            if (objectsBefore.containsKey(key) && objectsAfter.containsKey(key) && !Intrinsics.areEqual(objectsBefore.get(key), value)) {
                if (applyResult.getObjectsUpdated() == null) {
                    applyResult.setObjectsUpdated(new ArrayList());
                }
                List<String> list = applyResult.getObjectsUpdated();
                Intrinsics.checkNotNull(list);
                list.add(key + ":" + value);
                continue;
            }
            if (!objectsBefore.containsKey(key) && objectsAfter.containsKey(key)) {
                if (applyResult.getObjectsAdded() == null) {
                    applyResult.setObjectsAdded(new ArrayList());
                }
                List<String> list = applyResult.getObjectsAdded();
                Intrinsics.checkNotNull(list);
                list.add(key + ":" + value);
                continue;
            }
            if (!objectsBefore.containsKey(key) || objectsAfter.containsKey(key)) continue;
            if (applyResult.getObjectsRemoved() == null) {
                applyResult.setObjectsRemoved(new ArrayList());
            }
            List<String> list = applyResult.getObjectsRemoved();
            Intrinsics.checkNotNull(list);
            list.add(key + ":" + value);
        }
    }

    private static final void applyNBTDataItem$lambda$0(String $nbtStuff, ReadWriteItemNBT nbt) {
        nbt.mergeCompound((ReadableNBT)NBT.parseNBT((String)$nbtStuff));
    }

    private static final void applyNBTDataMob$lambda$0(String $nbtStuff, ReadWriteNBT nbt) {
        nbt.mergeCompound((ReadableNBT)NBT.parseNBT((String)$nbtStuff));
    }
}

