/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.managers;

import io.github.arcaneplugins.levelledmobs.LivingEntityInterface;
import io.github.arcaneplugins.levelledmobs.enums.ExternalCompatibility;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin._Assertions;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.JvmStatic;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.StringCompanionObject;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.managers.EssentialsIntegration;
import io.github.arcaneplugins.levelledmobs.managers.WorldGuardIntegration;
import io.github.arcaneplugins.levelledmobs.misc.ExternalPluginDetection;
import io.github.arcaneplugins.levelledmobs.misc.VersionInfo;
import io.github.arcaneplugins.levelledmobs.result.PlayerHomeCheckResult;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.io.InvalidObjectException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0006\u0010\u0015\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0005R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0018"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/ExternalCompatibilityManager;", "", "<init>", "()V", "lmiMeetsVersionRequirement", "", "Ljava/lang/Boolean;", "lmiMeetsVersionRequirement2", "externalPluginDefinitions", "", "", "Lio/github/arcaneplugins/levelledmobs/misc/ExternalPluginDetection;", "getExternalPluginDefinitions", "()Ljava/util/Map;", "externalPluginPlaceholders", "getExternalPluginPlaceholders", "parseMobPluginDetection", "", "cs", "Lorg/bukkit/configuration/file/YamlConfiguration;", "buildBuiltInCompatibilities", "doesLMIMeetVersionRequirement", "doesLMIMeetVersionRequirement2", "Companion", "levelledmobs-plugin"})
public final class ExternalCompatibilityManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Boolean lmiMeetsVersionRequirement;
    @Nullable
    private Boolean lmiMeetsVersionRequirement2;
    @NotNull
    private final Map<String, ExternalPluginDetection> externalPluginDefinitions = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
    @NotNull
    private final Map<String, ExternalPluginDetection> externalPluginPlaceholders = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
    private static ExternalCompatibilityManager instance;
    @Nullable
    private static Boolean useNewerEliteMobsKey;

    public ExternalCompatibilityManager() {
        instance = this;
    }

    @NotNull
    public final Map<String, ExternalPluginDetection> getExternalPluginDefinitions() {
        return this.externalPluginDefinitions;
    }

    @NotNull
    public final Map<String, ExternalPluginDetection> getExternalPluginPlaceholders() {
        return this.externalPluginPlaceholders;
    }

    public final void parseMobPluginDetection(@Nullable YamlConfiguration cs) {
        this.externalPluginDefinitions.clear();
        this.externalPluginPlaceholders.clear();
        this.buildBuiltInCompatibilities();
        if (cs == null) {
            return;
        }
        for (String key : cs.getKeys(false)) {
            Object csKey;
            if (cs.get(key) == null || !(csKey instanceof ConfigurationSection)) continue;
            ExternalPluginDetection.KeyTypes keyType = ExternalPluginDetection.KeyTypes.PDC;
            String friendlyName = ((ConfigurationSection)csKey).getString("friendly-name");
            String pluginName = ((ConfigurationSection)csKey).getString("plugin-name");
            String keyName = ((ConfigurationSection)csKey).getString("key-name");
            String keyValueType = ((ConfigurationSection)csKey).getString("key-valuetype", "string");
            if (StringsKt.equals("metadata", ((ConfigurationSection)csKey).getString("key-type"), true)) {
                keyType = ExternalPluginDetection.KeyTypes.METADATA;
            }
            String requirementStr = ((ConfigurationSection)csKey).getString("requirement");
            CharSequence charSequence = friendlyName;
            if (charSequence == null || charSequence.length() == 0) {
                friendlyName = pluginName;
            }
            if ((charSequence = (CharSequence)pluginName) == null || charSequence.length() == 0) continue;
            charSequence = keyName;
            if (charSequence == null || charSequence.length() == 0) {
                Log.INSTANCE.war("no key-name was supplied for " + pluginName);
                continue;
            }
            ExternalPluginDetection.RequirementTypes requirement = ExternalPluginDetection.RequirementTypes.EXISTS;
            CharSequence charSequence2 = requirementStr;
            if (!(charSequence2 == null || charSequence2.length() == 0)) {
                try {
                    String string = requirementStr.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                    requirement = ExternalPluginDetection.RequirementTypes.valueOf(string);
                }
                catch (Exception exception) {
                    Log.INSTANCE.war("Invalid value: " + requirementStr);
                }
            }
            String string = friendlyName;
            Intrinsics.checkNotNull(string);
            ExternalPluginDetection mpd = new ExternalPluginDetection(pluginName, string, keyName, requirement, keyType);
            mpd.setKeyValueType(keyValueType);
            mpd.setRequirementValue(((ConfigurationSection)csKey).getString("requirement-value"));
            mpd.setPlaceholderName(((ConfigurationSection)csKey).getString("placeholder-name"));
            this.externalPluginDefinitions.put(mpd.getFriendlyName(), mpd);
            CharSequence charSequence3 = mpd.getPlaceholderName();
            if (charSequence3 == null || charSequence3.length() == 0) continue;
            String string2 = mpd.getPlaceholderName();
            Intrinsics.checkNotNull(string2);
            this.externalPluginPlaceholders.put(string2, mpd);
        }
    }

    private final void buildBuiltInCompatibilities() {
        ExternalCompatibility[] externalCompatibilityArray = new ExternalCompatibility[]{ExternalCompatibility.MYTHIC_MOBS, ExternalCompatibility.SIMPLE_PETS, ExternalCompatibility.ELITE_BOSSES, ExternalCompatibility.ELITE_MOBS, ExternalCompatibility.CITIZENS};
        List<ExternalCompatibility> compats = CollectionsKt.mutableListOf(externalCompatibilityArray);
        for (ExternalCompatibility compat : compats) {
            ExternalPluginDetection mobPluginDetection = new ExternalPluginDetection(compat.toString(), StringsKt.replace$default(compat.toString(), "_", "-", false, 4, null), "(built-in)", ExternalPluginDetection.RequirementTypes.EXISTS, ExternalPluginDetection.KeyTypes.PDC);
            mobPluginDetection.setExternalCompatibility(compat);
            this.externalPluginDefinitions.put(mobPluginDetection.getFriendlyName(), mobPluginDetection);
        }
    }

    public final boolean doesLMIMeetVersionRequirement() {
        if (this.lmiMeetsVersionRequirement != null) {
            Boolean bl = this.lmiMeetsVersionRequirement;
            Intrinsics.checkNotNull(bl);
            return bl;
        }
        Plugin plugin = Bukkit.getPluginManager().getPlugin("LM_Items");
        if (plugin == null) {
            return false;
        }
        Plugin lmi = plugin;
        try {
            VersionInfo requiredVersion = new VersionInfo("1.1.0");
            String string = lmi.getDescription().getVersion();
            Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
            VersionInfo lmiVersion = new VersionInfo(string);
            this.lmiMeetsVersionRequirement = requiredVersion.compareTo(lmiVersion) <= 0;
        }
        catch (InvalidObjectException e) {
            e.printStackTrace();
            this.lmiMeetsVersionRequirement = false;
        }
        Boolean bl = this.lmiMeetsVersionRequirement;
        Intrinsics.checkNotNull(bl);
        return bl;
    }

    public final boolean doesLMIMeetVersionRequirement2() {
        if (this.lmiMeetsVersionRequirement2 != null) {
            Boolean bl = this.lmiMeetsVersionRequirement2;
            Intrinsics.checkNotNull(bl);
            return bl;
        }
        Plugin plugin = Bukkit.getPluginManager().getPlugin("LM_Items");
        if (plugin == null) {
            return false;
        }
        Plugin lmi = plugin;
        try {
            VersionInfo requiredVersion = new VersionInfo("1.3.0");
            String string = lmi.getDescription().getVersion();
            Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
            VersionInfo lmiVersion = new VersionInfo(string);
            this.lmiMeetsVersionRequirement2 = requiredVersion.compareTo(lmiVersion) <= 0;
        }
        catch (InvalidObjectException e) {
            e.printStackTrace();
            this.lmiMeetsVersionRequirement2 = false;
        }
        Boolean bl = this.lmiMeetsVersionRequirement2;
        Intrinsics.checkNotNull(bl);
        return bl;
    }

    @NotNull
    public static final ExternalCompatibilityManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010%\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$J\u000e\u0010&\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$J\u000e\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020$J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000f0/2\u0006\u00100\u001a\u000201J\u0016\u00102\u001a\u0002032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u000bJ\u0010\u00105\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u00106\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002R&\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058\u0006@BX\u0087.\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u001c\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010\u001e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012R\u0011\u0010 \u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0012\u00a8\u00067"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/ExternalCompatibilityManager$Companion;", "", "<init>", "()V", "value", "Lio/github/arcaneplugins/levelledmobs/managers/ExternalCompatibilityManager;", "instance", "getInstance$annotations", "getInstance", "()Lio/github/arcaneplugins/levelledmobs/managers/ExternalCompatibilityManager;", "useNewerEliteMobsKey", "", "Ljava/lang/Boolean;", "checkIfPluginIsInstalledAndEnabled", "pluginName", "", "hasLMItemsInstalled", "getHasLMItemsInstalled", "()Z", "hasPapiInstalled", "getHasPapiInstalled", "hasNbtApiInstalled", "getHasNbtApiInstalled", "getPapiPlaceholder", "player", "Lorg/bukkit/entity/Player;", "placeholder", "invalidPlaceholderReplacement", "hasMythicMobsInstalled", "getHasMythicMobsInstalled", "hasLibsDisguisesInstalled", "getHasLibsDisguisesInstalled", "hasWorldGuardInstalled", "getHasWorldGuardInstalled", "isMobOfSimplePets", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "isMythicMob", "getMythicMobInternalName", "updateAllExternalCompats", "", "isMobOfMythicMobs", "isMobOfEliteMobs", "isMobOfCitizens", "livingEntity", "Lorg/bukkit/entity/LivingEntity;", "getWGRegionsAtLocation", "", "lmInterface", "Lio/github/arcaneplugins/levelledmobs/LivingEntityInterface;", "getPlayerHomeLocation", "Lio/github/arcaneplugins/levelledmobs/result/PlayerHomeCheckResult;", "allowBed", "isSimplePets", "isMobOfEliteBosses", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExternalCompatibilityManager getInstance() {
            ExternalCompatibilityManager externalCompatibilityManager = instance;
            if (externalCompatibilityManager != null) {
                return externalCompatibilityManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        private final boolean checkIfPluginIsInstalledAndEnabled(String pluginName) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
            return plugin != null && plugin.isEnabled();
        }

        public final boolean getHasLMItemsInstalled() {
            return this.checkIfPluginIsInstalledAndEnabled("LM_Items");
        }

        public final boolean getHasPapiInstalled() {
            return this.checkIfPluginIsInstalledAndEnabled("PlaceholderAPI");
        }

        public final boolean getHasNbtApiInstalled() {
            return this.checkIfPluginIsInstalledAndEnabled("NBTAPI");
        }

        @NotNull
        public final String getPapiPlaceholder(@Nullable Player player, @NotNull String placeholder, @Nullable String invalidPlaceholderReplacement) {
            Intrinsics.checkNotNullParameter(placeholder, "placeholder");
            if (invalidPlaceholderReplacement != null) {
                boolean bl;
                Matcher matcher = PlaceholderAPI.getPlaceholderPattern().matcher(placeholder);
                List inputList = new ArrayList();
                while (matcher.find()) {
                    inputList.add("%" + matcher.group(matcher.groupCount()) + "%");
                }
                if (inputList.isEmpty()) {
                    String string = PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder);
                    Intrinsics.checkNotNullExpressionValue(string, "setPlaceholders(...)");
                    return string;
                }
                String results = placeholder;
                List list = PlaceholderAPI.setPlaceholders((Player)player, (List)inputList);
                Intrinsics.checkNotNullExpressionValue(list, "setPlaceholders(...)");
                List papiResults = list;
                boolean bl2 = bl = inputList.size() == papiResults.size();
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "getPapiPlaceholder: input size (" + inputList.size() + ") did not match results size (" + papiResults.size() + ")";
                    throw new AssertionError((Object)string);
                }
                int n = papiResults.size();
                for (int i = 0; i < n; ++i) {
                    String currentResult = (String)papiResults.get(i);
                    String currentInput = (String)inputList.get(i);
                    Intrinsics.checkNotNull(currentResult);
                    results = ((CharSequence)currentResult).length() == 0 || Intrinsics.areEqual(currentResult, currentInput) ? StringsKt.replace$default(results, currentInput, invalidPlaceholderReplacement, false, 4, null) : StringsKt.replace$default(results, currentInput, currentResult, false, 4, null);
                }
                return results;
            }
            String string = PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder);
            Intrinsics.checkNotNullExpressionValue(string, "setPlaceholders(...)");
            return string;
        }

        public final boolean getHasMythicMobsInstalled() {
            return this.checkIfPluginIsInstalledAndEnabled("MythicMobs");
        }

        public final boolean getHasLibsDisguisesInstalled() {
            return this.checkIfPluginIsInstalledAndEnabled("LibsDisguises");
        }

        public final boolean getHasWorldGuardInstalled() {
            return this.checkIfPluginIsInstalledAndEnabled("WorldGuard");
        }

        private final boolean isMobOfSimplePets(LivingEntityWrapper lmEntity) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin("SimplePets");
            if (plugin == null || !plugin.isEnabled()) {
                return false;
            }
            String string = plugin.getDescription().getVersion();
            Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
            if (StringsKt.startsWith$default(string, "4", false, 2, null)) {
                for (MetadataValue meta : lmEntity.getLivingEntity().getMetadata("pet")) {
                    String string2 = meta.asString();
                    Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                    if (!(((CharSequence)string2).length() > 0)) continue;
                    return true;
                }
                return false;
            }
            return this.isSimplePets(lmEntity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isMythicMob(@NotNull LivingEntityWrapper lmEntity) {
            Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
            Plugin p = Bukkit.getPluginManager().getPlugin("MythicMobs");
            if (p == null || !p.isEnabled()) {
                return false;
            }
            NamespacedKey mmKey = new NamespacedKey(p, "type");
            PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
            PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
            synchronized (persistentDataContainer2) {
                boolean bl = false;
                boolean bl2 = lmEntity.getPdc().has(mmKey, PersistentDataType.STRING);
                return bl2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String getMythicMobInternalName(@NotNull LivingEntityWrapper lmEntity) {
            Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
            if (!this.isMythicMob(lmEntity)) {
                return "";
            }
            Plugin p = Bukkit.getPluginManager().getPlugin("MythicMobs");
            if (p == null || !p.isEnabled()) {
                return "";
            }
            NamespacedKey mmKey = new NamespacedKey(p, "type");
            PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
            PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
            synchronized (persistentDataContainer2) {
                block7: {
                    boolean bl = false;
                    if (!lmEntity.getPdc().has(mmKey, PersistentDataType.STRING)) break block7;
                    String type = (String)lmEntity.getPdc().get(mmKey, PersistentDataType.STRING);
                    String string = type;
                    if (string == null) {
                        string = "";
                    }
                    String string2 = string;
                    return string2;
                }
                Unit unit = Unit.INSTANCE;
            }
            return "";
        }

        public final void updateAllExternalCompats(@NotNull LivingEntityWrapper lmEntity) {
            Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
            for (ExternalPluginDetection mobPlugin : this.getInstance().getExternalPluginDefinitions().values()) {
                if (mobPlugin.isBuiltIn()) continue;
                mobPlugin.isMobOfType(lmEntity);
            }
            this.isMobOfMythicMobs(lmEntity);
            this.isMobOfEliteMobs(lmEntity);
            this.isMobOfSimplePets(lmEntity);
            this.isMobOfCitizens(lmEntity);
            this.isMobOfEliteBosses(lmEntity);
        }

        private final boolean isMobOfMythicMobs(LivingEntityWrapper lmEntity) {
            if (!this.getHasMythicMobsInstalled()) {
                return false;
            }
            if (lmEntity.isMobOfExternalType()) {
                return true;
            }
            boolean isExternalType = this.isMythicMob(lmEntity);
            if (isExternalType) {
                lmEntity.setMobExternalType("MYTHIC-MOBS");
            }
            return isExternalType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean isMobOfEliteMobs(LivingEntityWrapper lmEntity) {
            Plugin p = Bukkit.getPluginManager().getPlugin("EliteMobs");
            if (p != null) {
                if (useNewerEliteMobsKey == null) {
                    String string;
                    String string2 = p.getDescription().getVersion();
                    Intrinsics.checkNotNullExpressionValue(string2, "getVersion(...)");
                    int theDash = StringsKt.indexOf$default((CharSequence)string2, '-', 0, false, 6, null);
                    if (theDash > 3) {
                        String string3 = p.getDescription().getVersion();
                        Intrinsics.checkNotNullExpressionValue(string3, "getVersion(...)");
                        String string4 = string3;
                        int n = 0;
                        String string5 = string4.substring(n, theDash);
                        string = string5;
                        Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                    } else {
                        String string6 = p.getDescription().getVersion();
                        string = string6;
                        Intrinsics.checkNotNullExpressionValue(string6, "getVersion(...)");
                    }
                    String version = string;
                    try {
                        VersionInfo pluginVer = new VersionInfo(version);
                        VersionInfo cutoverVersion = new VersionInfo("7.3.12");
                        useNewerEliteMobsKey = pluginVer.compareTo(cutoverVersion) >= 0;
                    }
                    catch (InvalidObjectException e) {
                        Log.INSTANCE.war("Got error comparing EliteMob versions: " + e.getMessage());
                        useNewerEliteMobsKey = true;
                    }
                }
                Boolean bl = useNewerEliteMobsKey;
                Intrinsics.checkNotNull(bl);
                String checkKey = bl != false ? "eliteentity" : "EliteMobsCullable";
                boolean isEliteMob = false;
                PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
                Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
                PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
                synchronized (persistentDataContainer2) {
                    boolean bl2 = false;
                    isEliteMob = lmEntity.getPdc().has(new NamespacedKey(p, checkKey), PersistentDataType.STRING);
                    Unit unit = Unit.INSTANCE;
                }
                if (isEliteMob) {
                    lmEntity.setMobExternalType("ELITE-MOBS");
                    return true;
                }
            }
            return false;
        }

        private final boolean isMobOfCitizens(LivingEntityWrapper lmEntity) {
            boolean isExternalType = this.isMobOfCitizens(lmEntity.getLivingEntity());
            if (isExternalType) {
                lmEntity.setMobExternalType(ExternalCompatibility.CITIZENS.toString());
            }
            return isExternalType;
        }

        public final boolean isMobOfCitizens(@NotNull LivingEntity livingEntity) {
            Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
            return livingEntity.hasMetadata("NPC");
        }

        @NotNull
        public final Set<String> getWGRegionsAtLocation(@NotNull LivingEntityInterface lmInterface) {
            Intrinsics.checkNotNullParameter(lmInterface, "lmInterface");
            return this.getHasWorldGuardInstalled() ? WorldGuardIntegration.INSTANCE.getWorldGuardRegionsForLocation(lmInterface) : (Set)new LinkedHashSet();
        }

        @NotNull
        public final PlayerHomeCheckResult getPlayerHomeLocation(@NotNull Player player, boolean allowBed) {
            Location bedLocation;
            Intrinsics.checkNotNullParameter(player, "player");
            if (allowBed && player.getWorld().getEnvironment() != World.Environment.NETHER && (bedLocation = player.getBedSpawnLocation()) != null) {
                return new PlayerHomeCheckResult(null, bedLocation, "bed");
            }
            return EssentialsIntegration.INSTANCE.getHomeLocation(player);
        }

        private final boolean isSimplePets(LivingEntityWrapper lmEntity) {
            try {
                Class<?> clazzPetCore = Class.forName("simplepets.brainsynder.api.plugin.SimplePets");
                Class<?> clazzIPetsPlugin = Class.forName("simplepets.brainsynder.api.plugin.IPetsPlugin");
                Method methodGetPlugin = clazzPetCore.getDeclaredMethod("getPlugin", new Class[0]);
                Object objIPetsPlugin = methodGetPlugin.invoke(null, new Object[0]);
                Class[] classArray = new Class[]{Entity.class};
                Method methodIsPetEntity = clazzIPetsPlugin.getDeclaredMethod("isPetEntity", classArray);
                Object[] objectArray = new Object[]{lmEntity.getLivingEntity()};
                Object object = methodIsPetEntity.invoke(objIPetsPlugin, objectArray);
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Boolean");
                return (Boolean)object;
            }
            catch (Exception e) {
                Log.INSTANCE.sev("Error checking if " + lmEntity.getNameIfBaby() + " is a SimplePet");
                e.printStackTrace();
                return false;
            }
        }

        private final boolean isMobOfEliteBosses(LivingEntityWrapper lmEntity) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin("EliteBosses");
            if (plugin == null || !plugin.isEnabled()) {
                return false;
            }
            for (MetadataValue meta : lmEntity.getLivingEntity().getMetadata("EliteBosses")) {
                if (meta.asInt() <= 0) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

