/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.InternalSpawnReason;
import io.github.arcaneplugins.levelledmobs.enums.LevellableState;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.SetsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.JvmStatic;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.managers.LevelManager;
import io.github.arcaneplugins.levelledmobs.misc.LMSpawnReason;
import io.github.arcaneplugins.levelledmobs.result.AdditionalLevelInformation;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntityTransformListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "damageMappings", "", "Ljava/util/UUID;", "Lorg/bukkit/entity/Player;", "getDamageMappings", "()Ljava/util/Map;", "lastPriority", "Lorg/bukkit/event/EventPriority;", "settingName", "", "load", "", "onTransform", "event", "Lorg/bukkit/event/entity/EntityTransformEvent;", "checkForSlimeSplit", "livingEntity", "Lorg/bukkit/entity/LivingEntity;", "transformedEntities", "", "Lorg/bukkit/entity/Entity;", "Companion", "levelledmobs-plugin"})
public final class EntityTransformListener
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UUID, Player> damageMappings = new LinkedHashMap();
    @Nullable
    private EventPriority lastPriority;
    @NotNull
    private final String settingName;
    private static EntityTransformListener instance;

    public EntityTransformListener() {
        this.settingName = "entity-transform-event";
        instance = this;
    }

    @NotNull
    public final Map<UUID, Player> getDamageMappings() {
        return this.damageMappings;
    }

    public final void load() {
        EventPriority priority = LevelledMobs.Companion.getInstance().getMainCompanion().getEventPriority(this.settingName, EventPriority.MONITOR);
        if (this.lastPriority != null) {
            if (priority == this.lastPriority) {
                return;
            }
            HandlerList.unregisterAll((Listener)this);
            Log.INSTANCE.inf("Changing event priority for " + this.settingName + " from " + this.lastPriority + " to " + priority);
        }
        Bukkit.getPluginManager().registerEvent(EntityTransformEvent.class, (Listener)this, priority, (arg_0, arg_1) -> EntityTransformListener.load$lambda$0(this, arg_0, arg_1), (Plugin)LevelledMobs.Companion.getInstance(), false);
        this.lastPriority = priority;
    }

    private final void onTransform(EntityTransformEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            DebugManager.Companion.log(DebugType.ENTITY_MISC, event.getEntity(), false, EntityTransformListener::onTransform$lambda$0);
            return;
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        LevelManager levelManager = main.getLevelManager();
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        if (!levelManager.isLevelled((LivingEntity)entity)) {
            DebugManager.Companion.log(DebugType.ENTITY_MISC, event.getEntity(), false, EntityTransformListener::onTransform$lambda$1);
            if (event.getTransformReason() == EntityTransformEvent.TransformReason.SPLIT) {
                Entity entity2 = event.getEntity();
                Intrinsics.checkNotNull(entity2, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
                LivingEntity livingEntity = (LivingEntity)entity2;
                List list = event.getTransformedEntities();
                Intrinsics.checkNotNullExpressionValue(list, "getTransformedEntities(...)");
                this.checkForSlimeSplit(livingEntity, list);
            }
            return;
        }
        Entity entity3 = event.getEntity();
        Intrinsics.checkNotNull(entity3, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity3);
        boolean useInheritance = false;
        int level = 1;
        if (main.getRulesManager().getRuleMobLevelInheritance(lmEntity)) {
            useInheritance = true;
            level = lmEntity.getGetMobLevel();
        }
        for (Object e : event.getTransformedEntities()) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Entity transformedEntity = (Entity)e;
            if (!(transformedEntity instanceof LivingEntity)) {
                DebugManager.Companion.log(DebugType.ENTITY_MISC, event.getEntity(), false, EntityTransformListener::onTransform$lambda$2);
                continue;
            }
            LivingEntityWrapper transformedLmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)transformedEntity);
            LevellableState levelledState = main.getLevelInterface().getLevellableState(transformedLmEntity);
            if (levelledState != LevellableState.ALLOWED) {
                DebugManager.Companion.log(DebugType.ENTITY_MISC, event.getEntity(), false, () -> EntityTransformListener.onTransform$lambda$3(levelledState));
                main.getLevelManager().updateNametagWithDelay(transformedLmEntity);
                transformedLmEntity.free();
                continue;
            }
            DebugManager.Companion.log(DebugType.ENTITY_MISC, transformedEntity, true, EntityTransformListener::onTransform$lambda$4);
            if (useInheritance) {
                InternalSpawnReason internalSpawnReason = lmEntity.getSpawnReason().getInternalSpawnReason(lmEntity);
                if (internalSpawnReason == InternalSpawnReason.LM_SPAWNER) {
                    LMSpawnReason.setMinecraftSpawnReason$default(transformedLmEntity.getSpawnReason(), lmEntity, CreatureSpawnEvent.SpawnReason.SPAWNER, false, 4, null);
                }
                AdditionalLevelInformation[] additionalLevelInformationArray = new AdditionalLevelInformation[]{AdditionalLevelInformation.FROM_TRANSFORM_LISTENER};
                main.getLevelInterface().applyLevelToMob(transformedLmEntity, level, false, false, SetsKt.mutableSetOf(additionalLevelInformationArray));
            } else {
                main.getLevelManager().getEntitySpawnListener().processMob(transformedLmEntity, (Event)new EntitySpawnEvent(transformedEntity));
            }
            main.getLevelManager().updateNametagWithDelay(lmEntity);
            transformedLmEntity.free();
        }
        lmEntity.free();
    }

    private final void checkForSlimeSplit(LivingEntity livingEntity, List<? extends Entity> transformedEntities) {
        LivingEntityWrapper parent = LivingEntityWrapper.Companion.getInstance(livingEntity);
        CreatureSpawnEvent.SpawnReason minecraftSpawnReason = parent.getSpawnReason().getMinecraftSpawnReason(parent);
        if (minecraftSpawnReason == CreatureSpawnEvent.SpawnReason.DEFAULT || minecraftSpawnReason == CreatureSpawnEvent.SpawnReason.SLIME_SPLIT) {
            parent.free();
            return;
        }
        Iterator<? extends Entity> iterator2 = transformedEntities.iterator();
        while (iterator2.hasNext()) {
            Entity transformedEntity;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (!(transformedEntity instanceof LivingEntity)) continue;
            LivingEntityWrapper lew = LivingEntityWrapper.Companion.getInstance((LivingEntity)transformedEntity);
            lew.getSpawnReason().setLMSpawnReason(parent);
            lew.free();
        }
        parent.free();
    }

    private static final void load$lambda$0(EntityTransformListener this$0, Listener listener, Event event) {
        Intrinsics.checkNotNullParameter(listener, "<unused var>");
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof EntityTransformEvent) {
            this$0.onTransform((EntityTransformEvent)event);
        }
    }

    private static final String onTransform$lambda$0() {
        return "entity was &bnot&7 an instance of LivingEntity";
    }

    private static final String onTransform$lambda$1() {
        return "original entity was &bnot&7 levelled";
    }

    private static final String onTransform$lambda$2() {
        return "entity was&b not&7 an instance of LivingEntity (loop)";
    }

    private static final String onTransform$lambda$3(LevellableState $levelledState) {
        return "transformed entity was &bnot&7 levellable, reason: &b" + $levelledState;
    }

    private static final String onTransform$lambda$4() {
        return "entity was transformed";
    }

    @NotNull
    public static final EntityTransformListener getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058\u0006@BX\u0087.\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntityTransformListener$Companion;", "", "<init>", "()V", "value", "Lio/github/arcaneplugins/levelledmobs/listeners/EntityTransformListener;", "instance", "getInstance$annotations", "getInstance", "()Lio/github/arcaneplugins/levelledmobs/listeners/EntityTransformListener;", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityTransformListener getInstance() {
            EntityTransformListener entityTransformListener = instance;
            if (entityTransformListener != null) {
                return entityTransformListener;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

