/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.InternalSpawnReason;
import io.github.arcaneplugins.levelledmobs.enums.LevellableState;
import io.github.arcaneplugins.levelledmobs.enums.NametagVisibilityEnum;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Pair;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.SetsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.comparisons.ComparisonsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.JvmStatic;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.SourceDebugExtension;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.ranges.RangesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.sequences.Sequence;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.sequences.SequencesKt;
import io.github.arcaneplugins.levelledmobs.listeners.EntitySpawnListener$Companion$getPlayersNearMob$;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.managers.LevelManager;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.misc.LMSpawnReason;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.result.AdditionalLevelInformation;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MiscUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.time.Instant;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J \u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J \u0010 \u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0018\u0010\"\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000bH\u0002J\u0018\u0010*\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0018\u001a\u0004\u0018\u00010!J\u0018\u0010+\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u000bH\u0002J\u001a\u0010-\u001a\u00020.2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0018\u001a\u0004\u0018\u00010!H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "processMobSpawns", "", "getProcessMobSpawns", "()Z", "setProcessMobSpawns", "(Z)V", "mobProcessDelay", "", "mobCheckDistance", "getMobCheckDistance", "()I", "setMobCheckDistance", "(I)V", "lastPriority", "Lorg/bukkit/event/EventPriority;", "settingName", "", "load", "", "onEntitySpawn", "event", "Lorg/bukkit/event/entity/EntitySpawnEvent;", "preProcessmob", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "delayedAmount", "delayedProcessMob", "delay", "delayedAddToQueue", "Lorg/bukkit/event/Event;", "lmSpawnerSpawn", "Lorg/bukkit/event/entity/SpawnerSpawnEvent;", "createParticleEffect", "location", "Lorg/bukkit/Location;", "particle", "Lorg/bukkit/Particle;", "count", "processMob", "shouldDenyLevel", "levelAssignment", "getLevellableState", "Lio/github/arcaneplugins/levelledmobs/enums/LevellableState;", "Companion", "levelledmobs-plugin"})
public final class EntitySpawnListener
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean processMobSpawns = true;
    private int mobProcessDelay;
    private int mobCheckDistance = 320;
    @Nullable
    private EventPriority lastPriority;
    @NotNull
    private final String settingName;
    private static EntitySpawnListener instance;

    public EntitySpawnListener() {
        this.settingName = "entity-spawn-event";
        instance = this;
    }

    public final boolean getProcessMobSpawns() {
        return this.processMobSpawns;
    }

    public final void setProcessMobSpawns(boolean bl) {
        this.processMobSpawns = bl;
    }

    public final int getMobCheckDistance() {
        return this.mobCheckDistance;
    }

    public final void setMobCheckDistance(int n) {
        this.mobCheckDistance = n;
    }

    public final void load() {
        this.mobProcessDelay = LevelledMobs.Companion.getInstance().getHelperSettings().getInt("mob-process-delay", 0);
        this.mobCheckDistance = LevelledMobs.Companion.getInstance().getHelperSettings().getInt("async-task-max-blocks-from-player", 320);
        EventPriority priority = LevelledMobs.Companion.getInstance().getMainCompanion().getEventPriority(this.settingName, EventPriority.MONITOR);
        if (this.lastPriority != null) {
            if (priority == this.lastPriority) {
                return;
            }
            HandlerList.unregisterAll((Listener)this);
            Log.INSTANCE.inf("Changing event priority for " + this.settingName + " from " + this.lastPriority + " to " + priority);
        }
        Bukkit.getPluginManager().registerEvent(EntitySpawnEvent.class, (Listener)this, priority, (arg_0, arg_1) -> EntitySpawnListener.load$lambda$0(this, arg_0, arg_1), (Plugin)LevelledMobs.Companion.getInstance(), false);
        this.lastPriority = priority;
    }

    private final void onEntitySpawn(EntitySpawnEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (LevelledMobs.Companion.getInstance().getLevelManager().getForcedBlockedEntityTypes().contains(event.getEntityType())) {
            return;
        }
        SchedulerWrapper scheduler = new SchedulerWrapper(event.getEntity(), () -> EntitySpawnListener.onEntitySpawn$lambda$0(event, this));
        scheduler.setRunDirectlyInBukkit(true);
        SchedulerWrapper.run$default(scheduler, false, 1, null);
    }

    private final void preProcessmob(LivingEntityWrapper lmEntity, EntitySpawnEvent event, int delayedAmount) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        lmEntity.setSkylightLevel(lmEntity.getCurrentSkyLightLevel());
        lmEntity.setNewlySpawned(true);
        lmEntity.populateShowShowLMNametag();
        boolean hasBuiltCache = false;
        if (event instanceof CreatureSpawnEvent) {
            CreatureSpawnEvent.SpawnReason spawnReason = ((CreatureSpawnEvent)event).getSpawnReason();
            Intrinsics.checkNotNullExpressionValue(spawnReason, "getSpawnReason(...)");
            CreatureSpawnEvent.SpawnReason spawnReason2 = spawnReason;
            LMSpawnReason.setMinecraftSpawnReason$default(lmEntity.getSpawnReason(), lmEntity, spawnReason2, false, 4, null);
            if (main.getRulesManager().isPlayerLevellingEnabled() && lmEntity.getAssociatedPlayer() == null) {
                Companion.updateMobForPlayerLevelling(lmEntity);
            }
            lmEntity.buildCacheIfNeeded();
            MobDataManager.Companion.populateAttributeCache(lmEntity, null);
            hasBuiltCache = true;
            if (!(spawnReason2 != CreatureSpawnEvent.SpawnReason.CUSTOM && spawnReason2 != CreatureSpawnEvent.SpawnReason.SPAWNER_EGG || lmEntity.isLevelled())) {
                int amountToDelay = RangesKt.coerceAtLeast(20 - delayedAmount, 0);
                if (amountToDelay == 0) {
                    main.getMobsQueueManager().addToQueue(new QueueItem(lmEntity, (Event)event));
                } else {
                    this.delayedAddToQueue(lmEntity, (Event)event, amountToDelay);
                }
                return;
            }
        } else if (event instanceof SpawnerSpawnEvent) {
            LMSpawnReason.setMinecraftSpawnReason$default(lmEntity.getSpawnReason(), lmEntity, CreatureSpawnEvent.SpawnReason.SPAWNER, false, 4, null);
            if (main.getRulesManager().isPlayerLevellingEnabled() && lmEntity.getAssociatedPlayer() == null) {
                Companion.updateMobForPlayerLevelling(lmEntity);
            }
        }
        if (!this.processMobSpawns) {
            return;
        }
        if (!hasBuiltCache) {
            lmEntity.buildCacheIfNeeded();
            MobDataManager.Companion.populateAttributeCache(lmEntity, null);
        }
        main.getMobsQueueManager().addToQueue(new QueueItem(lmEntity, (Event)event));
    }

    private final void delayedProcessMob(LivingEntityWrapper lmEntity, EntitySpawnEvent event, int delay) {
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> EntitySpawnListener.delayedProcessMob$lambda$0(this, lmEntity, event, delay));
        lmEntity.getInUseCount().getAndIncrement();
        scheduler.runDelayed(delay);
    }

    private final void delayedAddToQueue(LivingEntityWrapper lmEntity, Event event, int delay) {
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> EntitySpawnListener.delayedAddToQueue$lambda$0(lmEntity, event));
        lmEntity.getInUseCount().getAndIncrement();
        scheduler.setEntity((Entity)lmEntity.getLivingEntity());
        scheduler.runDelayed(delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void lmSpawnerSpawn(LivingEntityWrapper lmEntity, SpawnerSpawnEvent event) {
        AdditionalLevelInformation[] additionalLevelInformationArray;
        CharSequence charSequence;
        CreatureSpawner cs = event.getSpawner();
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (cs == null) {
            return;
        }
        Particle useParticle = main.getRulesManager().getSpawnerParticle(lmEntity);
        int particleCount = main.getRulesManager().getSpawnerParticleCount(lmEntity);
        if (useParticle != null && particleCount > 0) {
            Location location = cs.getLocation().add(0.5, 1.0, 0.5);
            Intrinsics.checkNotNullExpressionValue(location, "add(...)");
            this.createParticleEffect(location, useParticle, particleCount);
        }
        Integer minLevel = (Integer)cs.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getKeySpawnerMinLevel(), PersistentDataType.INTEGER);
        Integer maxLevel = (Integer)cs.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getKeySpawnerMaxLevel(), PersistentDataType.INTEGER);
        Integer n = minLevel;
        int useMinLevel = n != null ? n : -1;
        Integer n2 = maxLevel;
        int useMaxLevel = n2 != null ? n2 : -1;
        int generatedLevel = main.getLevelInterface().generateLevel(lmEntity, useMinLevel, useMaxLevel);
        String spawnerName = cs.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getKeySpawnerCustomName(), PersistentDataType.STRING) ? (String)cs.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getKeySpawnerCustomName(), PersistentDataType.STRING) : null;
        Object customDropId = null;
        if (cs.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), PersistentDataType.STRING) && !((charSequence = (CharSequence)(customDropId = cs.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), PersistentDataType.STRING))) == null || charSequence.length() == 0)) {
            AdditionalLevelInformation[] additionalLevelInformationArray2 = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(additionalLevelInformationArray2, "getPersistentDataContainer(...)");
            additionalLevelInformationArray = additionalLevelInformationArray2;
            synchronized (additionalLevelInformationArray) {
                boolean bl = false;
                lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), PersistentDataType.STRING, customDropId);
                Unit unit = Unit.INSTANCE;
            }
        }
        lmEntity.setSourceSpawnerName(spawnerName);
        lmEntity.getSpawnReason().setInternalSpawnReason(lmEntity, InternalSpawnReason.LM_SPAWNER, true);
        String customDropIdFinal = (String)customDropId;
        DebugManager.Companion.log(DebugType.LM_MOB_SPAWNER, lmEntity, () -> EntitySpawnListener.lmSpawnerSpawn$lambda$1(customDropIdFinal, useMinLevel, useMaxLevel, generatedLevel));
        additionalLevelInformationArray = new AdditionalLevelInformation[]{AdditionalLevelInformation.NOT_APPLICABLE};
        main.getLevelInterface().applyLevelToMob(lmEntity, generatedLevel, false, true, SetsKt.mutableSetOf(additionalLevelInformationArray));
    }

    private final void createParticleEffect(Location location, Particle particle, int count) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        World world2 = world;
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> EntitySpawnListener.createParticleEffect$lambda$0(count, world2, particle, location));
        SchedulerWrapper.run$default(scheduler, false, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processMob(@NotNull LivingEntityWrapper lmEntity, @Nullable Event event) {
        AdditionalLevelInformation[] additionalLevelInformationArray;
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (!lmEntity.getReEvaluateLevel() && lmEntity.isLevelled()) {
            return;
        }
        if (!lmEntity.isPopulated()) {
            return;
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        AdditionalLevelInformation additionalInfo = AdditionalLevelInformation.NOT_APPLICABLE;
        lmEntity.setSpawnedTimeOfDay((int)lmEntity.getWorld().getTime());
        if (event instanceof SpawnerSpawnEvent) {
            if (((SpawnerSpawnEvent)event).getSpawner() != null) {
                CreatureSpawner creatureSpawner = ((SpawnerSpawnEvent)event).getSpawner();
                Intrinsics.checkNotNull(creatureSpawner, "null cannot be cast to non-null type org.bukkit.block.CreatureSpawner");
                if (creatureSpawner.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getKeySpawner(), PersistentDataType.INTEGER)) {
                    lmEntity.getSpawnReason().setInternalSpawnReason(lmEntity, InternalSpawnReason.LM_SPAWNER, true);
                    this.lmSpawnerSpawn(lmEntity, (SpawnerSpawnEvent)event);
                    return;
                }
            }
            DebugManager.Companion.log(DebugType.LM_MOB_SPAWNER, lmEntity, EntitySpawnListener::processMob$lambda$0);
        } else if (event instanceof CreatureSpawnEvent) {
            if (((CreatureSpawnEvent)event).getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER || ((CreatureSpawnEvent)event).getSpawnReason() == CreatureSpawnEvent.SpawnReason.SLIME_SPLIT) {
                return;
            }
            if (((CreatureSpawnEvent)event).getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM || ((CreatureSpawnEvent)event).getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) {
                additionalLevelInformationArray = LevelManager.Companion.getSummonedOrSpawnEggs_Lock();
                synchronized (additionalLevelInformationArray) {
                    boolean bl = false;
                    if (main.getLevelManager().getSummonedOrSpawnEggs().containsKey(lmEntity.getLivingEntity())) {
                        return;
                    }
                    Unit $i$a$-synchronized-EntitySpawnListener$processMob$4 = Unit.INSTANCE;
                }
            }
            if (!lmEntity.getReEvaluateLevel()) {
                LMSpawnReason.setMinecraftSpawnReason$default(lmEntity.getSpawnReason(), lmEntity, ((CreatureSpawnEvent)event).getSpawnReason(), false, 4, null);
            }
        } else if (event instanceof ChunkLoadEvent) {
            additionalInfo = AdditionalLevelInformation.FROM_CHUNK_LISTENER;
        }
        if (lmEntity.getReEvaluateLevel() && main.getRulesManager().isPlayerLevellingEnabled() && lmEntity.isRulesForceAll()) {
            AdditionalLevelInformation[] additionalLevelInformationArray2 = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(additionalLevelInformationArray2, "getPersistentDataContainer(...)");
            additionalLevelInformationArray = additionalLevelInformationArray2;
            synchronized (additionalLevelInformationArray) {
                boolean $i$a$-synchronized-EntitySpawnListener$processMob$52 = false;
                if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getPlayerLevellingId(), PersistentDataType.STRING)) {
                    lmEntity.getPdc().remove(NamespacedKeys.INSTANCE.getPlayerLevellingId());
                }
                Unit $i$a$-synchronized-EntitySpawnListener$processMob$52 = Unit.INSTANCE;
            }
        }
        additionalLevelInformationArray = new AdditionalLevelInformation[]{additionalInfo};
        Set<AdditionalLevelInformation> additionalLevelInfo = SetsKt.mutableSetOf(additionalLevelInformationArray);
        LevellableState levellableState = this.getLevellableState(lmEntity, event);
        if (levellableState == LevellableState.ALLOWED) {
            int levelAssignment = main.getLevelInterface().generateLevel(lmEntity);
            if (this.shouldDenyLevel(lmEntity, levelAssignment)) {
                DebugManager.Companion.log(DebugType.PLAYER_LEVELLING, lmEntity, () -> EntitySpawnListener.processMob$lambda$3(levelAssignment));
            } else {
                if (lmEntity.getReEvaluateLevel() && main.getRulesManager().isPlayerLevellingEnabled()) {
                    SchedulerWrapper scheduler = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> EntitySpawnListener.processMob$lambda$4(lmEntity));
                    scheduler.setRunDirectlyInBukkit(true);
                    lmEntity.getInUseCount().getAndIncrement();
                    SchedulerWrapper.run$default(scheduler, false, 1, null);
                }
                main.getLevelInterface().applyLevelToMob(lmEntity, levelAssignment, false, false, additionalLevelInfo);
            }
        } else {
            DebugManager.Companion.log(DebugType.APPLY_LEVEL_RESULT, lmEntity, false, () -> EntitySpawnListener.processMob$lambda$5(lmEntity, levellableState));
            if (lmEntity.isLevelled()) {
                main.getLevelInterface().removeLevel(lmEntity);
            } else if (lmEntity.isBabyMob()) {
                PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
                Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
                PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
                synchronized (persistentDataContainer2) {
                    boolean bl = false;
                    lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getWasBabyMobKey(), PersistentDataType.INTEGER, (Object)1);
                    Unit unit = Unit.INSTANCE;
                }
            }
            if (lmEntity.getWasPreviouslyLevelled()) {
                main.getLevelManager().updateNametag(lmEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final boolean shouldDenyLevel(LivingEntityWrapper lmEntity, int levelAssignment) {
        result = false;
        if (!lmEntity.getReEvaluateLevel() || lmEntity.isRulesForceAll() || lmEntity.getPlayerLevellingAllowDecrease() == null) ** GOTO lbl-1000
        v0 = lmEntity.getPlayerLevellingAllowDecrease();
        Intrinsics.checkNotNull(v0);
        if (!v0.booleanValue() && lmEntity.isLevelled() && levelAssignment < lmEntity.getGetMobLevel()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = result = false;
        }
        if (result) {
            v2 = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(v2, "getPersistentDataContainer(...)");
            var4_4 = v2;
            synchronized (var4_4) {
                $i$a$-synchronized-EntitySpawnListener$shouldDenyLevel$1 = false;
                result = lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getPlayerLevellingId(), PersistentDataType.STRING);
                $i$a$-synchronized-EntitySpawnListener$shouldDenyLevel$1 = Unit.INSTANCE;
            }
        }
        if (!result && lmEntity.getPendingPlayerIdToSet() != null) {
            v3 = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(v3, "getPersistentDataContainer(...)");
            var4_4 = v3;
            synchronized (var4_4) {
                $i$a$-synchronized-EntitySpawnListener$shouldDenyLevel$2 = false;
                v4 = lmEntity.getPdc();
                v5 = NamespacedKeys.INSTANCE.getPlayerLevellingId();
                v6 = lmEntity.getPendingPlayerIdToSet();
                Intrinsics.checkNotNull(v6);
                v4.set(v5, PersistentDataType.STRING, (Object)v6);
                var5_8 = Unit.INSTANCE;
            }
        }
        return result;
    }

    private final LevellableState getLevellableState(LivingEntityWrapper lmEntity, Event event) {
        LevellableState levellableState = LevelledMobs.Companion.getInstance().getLevelInterface().getLevellableState(lmEntity);
        if (levellableState != LevellableState.ALLOWED) {
            return levellableState;
        }
        if (event instanceof CreatureSpawnEvent) {
            if (((CreatureSpawnEvent)event).getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
                return LevellableState.DENIED_OTHER;
            }
            DebugManager.Companion.log(DebugType.ENTITY_SPAWN, lmEntity, () -> EntitySpawnListener.getLevellableState$lambda$0(event));
        } else if (event instanceof EntitySpawnEvent) {
            DebugManager.Companion.log(DebugType.ENTITY_SPAWN, lmEntity, () -> EntitySpawnListener.getLevellableState$lambda$1(event));
        }
        return LevellableState.ALLOWED;
    }

    private static final void load$lambda$0(EntitySpawnListener this$0, Listener listener, Event event) {
        Intrinsics.checkNotNullParameter(listener, "<unused var>");
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof EntitySpawnEvent) {
            this$0.onEntitySpawn((EntitySpawnEvent)event);
        }
    }

    private static final void onEntitySpawn$lambda$0(EntitySpawnEvent $event, EntitySpawnListener this$0) {
        Entity entity = $event.getEntity();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
        if (this$0.mobProcessDelay > 0) {
            this$0.delayedProcessMob(lmEntity, $event, this$0.mobProcessDelay);
        } else {
            this$0.preProcessmob(lmEntity, $event, 0);
        }
        lmEntity.free();
    }

    private static final void delayedProcessMob$lambda$0(EntitySpawnListener this$0, LivingEntityWrapper $lmEntity, EntitySpawnEvent $event, int $delay) {
        this$0.preProcessmob($lmEntity, $event, $delay);
        $lmEntity.free();
    }

    private static final void delayedAddToQueue$lambda$0(LivingEntityWrapper $lmEntity, Event $event) {
        LevelledMobs.Companion.getInstance().getMobsQueueManager().addToQueue(new QueueItem($lmEntity, $event));
        $lmEntity.free();
    }

    private static final String lmSpawnerSpawn$lambda$1(String $customDropIdFinal, int $useMinLevel, int $useMaxLevel, int $generatedLevel) {
        String string = $customDropIdFinal;
        Object msg = string == null ? "" : ", dropid: " + string;
        return "Spawned mob from LM spawner: minLevel:&b " + $useMinLevel + "&7, maxLevel: &b" + $useMaxLevel + "&7, generatedLevel: &b" + $generatedLevel + "&b" + (String)msg;
    }

    private static final void createParticleEffect$lambda$0(int $count, World $world, Particle $particle, Location $location) {
        try {
            int n = 0;
            while (n < $count) {
                int it = n++;
                boolean bl = false;
                $world.spawnParticle($particle, $location, 20, 0.0, 0.0, 0.0, 0.1);
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static final String processMob$lambda$0() {
        return "Spawned mob from vanilla spawner";
    }

    private static final String processMob$lambda$3(int $levelAssignment) {
        return "denied relevelling to &b" + $levelAssignment + "&r due to decrease-level disabled";
    }

    private static final void processMob$lambda$4(LivingEntityWrapper $lmEntity) {
        Companion.updateMobForPlayerLevelling($lmEntity);
        $lmEntity.free();
    }

    private static final String processMob$lambda$5(LivingEntityWrapper $lmEntity, LevellableState $levellableState) {
        return "world: &b" + $lmEntity.getWorldName() + "&7 was not levelled -> levellable state: &b" + $levellableState;
    }

    private static final String getLevellableState$lambda$0(Event $event) {
        return "instanceof CreatureSpawnListener: &b" + ((CreatureSpawnEvent)$event).getEntityType() + "&7, with spawnReason &b" + ((CreatureSpawnEvent)$event).getSpawnReason() + "&7.";
    }

    private static final String getLevellableState$lambda$1(Event $event) {
        return "not instanceof CreatureSpawnListener: &b" + ((EntitySpawnEvent)$event).getEntityType();
    }

    @NotNull
    public static final EntitySpawnListener getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R&\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058\u0006@BX\u0087.\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener$Companion;", "", "<init>", "()V", "value", "Lio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener;", "instance", "getInstance$annotations", "getInstance", "()Lio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener;", "updateMobForPlayerLevelling", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "updateMobForPlayerLevellingNonAsync", "checkDistance", "", "onlinePlayerCount", "getPlayersOnServerNearMob", "", "Lorg/bukkit/entity/Player;", "mob", "Lorg/bukkit/entity/LivingEntity;", "getPlayersNearMob", "levelledmobs-plugin"})
    @SourceDebugExtension(value={"SMAP\nEntitySpawnListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntitySpawnListener.kt\nio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,534:1\n479#2:535\n614#2:536\n*S KotlinDebug\n*F\n+ 1 EntitySpawnListener.kt\nio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener$Companion\n*L\n522#1:535\n525#1:536\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntitySpawnListener getInstance() {
            EntitySpawnListener entitySpawnListener = instance;
            if (entitySpawnListener != null) {
                return entitySpawnListener;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public final void updateMobForPlayerLevelling(@NotNull LivingEntityWrapper lmEntity) {
            Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
            int onlinePlayerCount = lmEntity.getWorld().getPlayers().size();
            SchedulerWrapper wrapper = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> Companion.updateMobForPlayerLevelling$lambda$0(lmEntity, onlinePlayerCount));
            if (Bukkit.isPrimaryThread()) {
                wrapper.setRunDirectlyInBukkit(true);
            }
            lmEntity.getInUseCount().getAndIncrement();
            SchedulerWrapper.run$default(wrapper, false, 1, null);
        }

        private final void updateMobForPlayerLevellingNonAsync(LivingEntityWrapper lmEntity, int checkDistance, int onlinePlayerCount) {
            LevelledMobs main = LevelledMobs.Companion.getInstance();
            List<Player> playerList = onlinePlayerCount <= 10 ? this.getPlayersOnServerNearMob(lmEntity.getLivingEntity(), checkDistance) : this.getPlayersNearMob(lmEntity.getLivingEntity(), checkDistance);
            Player closestPlayer = null;
            Iterator<Player> iterator2 = playerList.iterator();
            while (iterator2.hasNext()) {
                Player player;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                if (ExternalCompatibilityManager.Companion.isMobOfCitizens((LivingEntity)player)) continue;
                closestPlayer = player;
                break;
            }
            if (closestPlayer == null) {
                return;
            }
            lmEntity.setAssociatedPlayer(closestPlayer);
            Instant logonTime = main.getMainCompanion().getRecentlyJoinedPlayerLogonTime(closestPlayer);
            if (logonTime != null) {
                if (Utils.INSTANCE.getMillisecondsFromInstant(logonTime) < 5000L) {
                    return;
                }
                main.getMainCompanion().removeRecentlyJoinedPlayer(closestPlayer);
            }
            lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getPlayerLevellingId(), PersistentDataType.STRING, (Object)closestPlayer.getUniqueId().toString());
            List<NametagVisibilityEnum> nametagVisibilityEnums = lmEntity.getNametagVisibilityEnum();
            if (nametagVisibilityEnums.contains((Object)NametagVisibilityEnum.TARGETED) && lmEntity.getLivingEntity().hasLineOfSight((Entity)closestPlayer)) {
                main.getLevelManager().updateNametag(lmEntity);
            }
        }

        private final List<Player> getPlayersOnServerNearMob(LivingEntity mob, int checkDistance) {
            List list = mob.getWorld().getPlayers();
            Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
            return Utils.INSTANCE.filterPlayersList(list, mob, Double.valueOf(checkDistance * 4));
        }

        /*
         * WARNING - void declaration
         */
        private final List<Player> getPlayersNearMob(LivingEntity mob, int checkDistance) {
            void $this$sortedBy$iv;
            Sequence<Pair> $this$filterIsInstance$iv;
            Location location = mob.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            double radius = MiscUtils.INSTANCE.retrieveLoadedChunkRadius(location, checkDistance);
            List list = mob.getNearbyEntities(radius, radius, radius);
            Intrinsics.checkNotNullExpressionValue(list, "getNearbyEntities(...)");
            Sequence sequence = CollectionsKt.asSequence(list);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, Companion$getPlayersNearMob$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = SequencesKt.map(SequencesKt.filter(sequence2, Companion::getPlayersNearMob$lambda$0), arg_0 -> Companion.getPlayersNearMob$lambda$1(mob, arg_0));
            boolean $i$f$sortedBy = false;
            Sequence<Player> temp = SequencesKt.map(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getFirst();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Double)it.getFirst()));
                }
            }), Companion::getPlayersNearMob$lambda$3);
            if (MainCompanion.Companion.getInstance().getExcludePlayersInCreative()) {
                temp = SequencesKt.filter(temp, Companion::getPlayersNearMob$lambda$4);
            }
            return SequencesKt.toMutableList(temp);
        }

        private static final void updateMobForPlayerLevelling$lambda$0(LivingEntityWrapper $lmEntity, int $onlinePlayerCount) {
            Companion.updateMobForPlayerLevellingNonAsync($lmEntity, $lmEntity.getMain().getLevelManager().getEntitySpawnListener().getMobCheckDistance(), $onlinePlayerCount);
            $lmEntity.free();
        }

        private static final boolean getPlayersNearMob$lambda$0(Entity e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return ((Player)e).getGameMode() != GameMode.SPECTATOR;
        }

        private static final Pair getPlayersNearMob$lambda$1(LivingEntity $mob, Entity e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return new Pair<Double, Player>($mob.getLocation().distanceSquared(e.getLocation()), (Player)e);
        }

        private static final Player getPlayersNearMob$lambda$3(Pair it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return (Player)it.getSecond();
        }

        private static final boolean getPlayersNearMob$lambda$4(Entity e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return ((Player)e).getGameMode() != GameMode.CREATIVE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

