/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.debug;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.io.CloseableKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.SourceDebugExtension;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.StringCompanionObject;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.CharsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lio/github/arcaneplugins/levelledmobs/debug/DebugCreator;", "", "<init>", "()V", "createDebug", "", "sender", "Lorg/bukkit/command/CommandSender;", "generateSystemInfo", "", "getFileChecksum", "digest", "Ljava/security/MessageDigest;", "file", "Ljava/io/File;", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nDebugCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugCreator.kt\nio/github/arcaneplugins/levelledmobs/debug/DebugCreator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class DebugCreator {
    @NotNull
    public static final DebugCreator INSTANCE = new DebugCreator();

    private DebugCreator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void createDebug(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        String pluginDir = LevelledMobs.Companion.getInstance().getDataFolder().getAbsolutePath();
        String[] stringArray = new String[6];
        stringArray[0] = "serverinfo.txt";
        stringArray[1] = "rules.yml";
        stringArray[2] = "settings.yml";
        stringArray[3] = "messages.yml";
        stringArray[4] = "customdrops.yml";
        String string = Bukkit.getWorldContainer().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
        String string2 = string;
        int n = 0;
        int n2 = Bukkit.getWorldContainer().getAbsolutePath().length() - 1;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        stringArray[5] = string3 + "logs" + File.separator + "latest.log";
        List<String> srcFiles = CollectionsKt.mutableListOf(stringArray);
        File serverInfoFile = new File(pluginDir, "serverinfo.txt");
        try {
            Files.writeString(serverInfoFile.toPath(), (CharSequence)this.generateSystemInfo(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileOutputStream fos = null;
        ZipOutputStream zipOut = null;
        FileInputStream fis = null;
        File zipFile = new File(pluginDir, "debug.zip");
        boolean result = false;
        try {
            fos = new FileOutputStream(zipFile);
            zipOut = new ZipOutputStream(fos);
            for (String srcFile : srcFiles) {
                CharSequence charSequence = srcFile;
                String string4 = File.separator;
                Intrinsics.checkNotNullExpressionValue(string4, "separator");
                File fileToZip = StringsKt.contains$default(charSequence, string4, false, 2, null) ? new File(srcFile) : new File(pluginDir, srcFile);
                fis = new FileInputStream(fileToZip);
                ZipEntry zipEntry = new ZipEntry(fileToZip.getName());
                zipOut.putNextEntry(zipEntry);
                byte[] bytes = new byte[1024];
                int length = 0;
                while (true) {
                    int n3;
                    int it = n3 = fis.read(bytes);
                    boolean bl = false;
                    length = it;
                    if (n3 < 0) break;
                    zipOut.write(bytes, 0, length);
                }
                fis.close();
                fis = null;
            }
            result = true;
            try {
                zipOut.close();
                fos.close();
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ZipOutputStream zipOutputStream = zipOut;
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                FileInputStream fileInputStream = fis;
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                FileOutputStream fileOutputStream = fos;
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        File serverInfo = new File(pluginDir, "serverinfo.txt");
        if (serverInfo.exists()) {
            serverInfo.delete();
        }
        if (!result) return;
        sender.sendMessage("Created file: " + zipFile.getAbsolutePath());
    }

    private final String generateSystemInfo() {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        String string = ((Object)((Object)main)).getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        File lmFile = new File(StringsKt.replace$default(string, "%20", " ", false, 4, null));
        MessageDigest shaDigest = null;
        StringBuilder sb = new StringBuilder();
        try {
            shaDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (Exception exception) {
            // empty catch block
        }
        sb.append(main.getDescription().getName()).append(" ");
        sb.append(main.getDescription().getVersion());
        sb.append(System.lineSeparator());
        StringBuilder stringBuilder = sb.append("file size: ");
        String string2 = "%,d";
        Object[] objectArray = new Object[]{lmFile.length()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        stringBuilder.append(string3);
        sb.append(System.lineSeparator());
        sb.append("sha256 hash: ");
        StringBuilder stringBuilder2 = shaDigest != null ? sb.append(this.getFileChecksum(shaDigest, lmFile)) : sb.append("(error)");
        sb.append(System.lineSeparator());
        sb.append("server build: ").append(Bukkit.getServer().getVersion());
        sb.append(System.lineSeparator());
        sb.append("bukkit version: ").append(Bukkit.getBukkitVersion());
        sb.append(System.lineSeparator());
        sb.append("player count: ").append(Bukkit.getOnlinePlayers().size());
        sb.append("/");
        sb.append(main.getMaxPlayersRecorded());
        sb.append(System.lineSeparator()).append(System.lineSeparator());
        sb.append("plugins:\n");
        List plugins = new ArrayList(Bukkit.getPluginManager().getPlugins().length);
        StringBuilder sbPlugins = new StringBuilder();
        Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
        Intrinsics.checkNotNullExpressionValue(pluginArray, "getPlugins(...)");
        for (Plugin plugin : pluginArray) {
            Intrinsics.checkNotNull(plugin);
            Plugin p = plugin;
            sbPlugins.setLength(0);
            if (!p.isEnabled()) {
                sbPlugins.append("(disabled) ");
            }
            sbPlugins.append(p.getName()).append(" ");
            sbPlugins.append(p.getDescription().getVersion());
            sbPlugins.append(" - ");
            sbPlugins.append(p.getDescription().getDescription());
            String string4 = sbPlugins.toString();
            Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
            plugins.add(string4);
        }
        CollectionsKt.sortWith(plugins, StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        for (String pluginInfo : plugins) {
            sb.append(pluginInfo);
            sb.append(System.lineSeparator());
        }
        String string5 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "toString(...)");
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFileChecksum(MessageDigest digest, File file) {
        byte[] byteArray = new byte[1024];
        int bytesCount = 0;
        try {
            Closeable closeable = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileInputStream fis = (FileInputStream)closeable;
                boolean bl = false;
                while (true) {
                    int n;
                    int it = n = fis.read(byteArray);
                    boolean bl2 = false;
                    bytesCount = it;
                    if (n == -1) break;
                    digest.update(byteArray, 0, bytesCount);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        Intrinsics.checkNotNull(bytes);
        for (Object aByte : (Unit)bytes) {
            String string = Integer.toString((aByte & 0xFF) + 256, CharsKt.checkRadix(16));
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String string2 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            sb.append(string2);
        }
        return sb.toString();
    }
}

