/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.customdrops;

import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropsDefaults;
import io.github.arcaneplugins.levelledmobs.customdrops.SlidingChance;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.StringCompanionObject;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.ranges.RangesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.misc.CachedModalList;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010^\u001a\u00020\u00162\b\u0010_\u001a\u0004\u0018\u00010?R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000f\"\u0004\b\u001c\u0010\u0011R\u001a\u0010\u001d\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u000f\"\u0004\b\u001f\u0010\u0011R\u001a\u0010 \u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000f\"\u0004\b\"\u0010\u0011R\u001a\u0010#\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u000f\"\u0004\b%\u0010\u0011R\u001a\u0010&\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u000f\"\u0004\b(\u0010\u0011R\u001a\u0010)\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u000f\"\u0004\b+\u0010\u0011R\u001a\u0010,\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0019\"\u0004\b.\u0010/R\u001c\u00100\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u0019\"\u0004\b8\u0010/R\u001a\u00109\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0019\"\u0004\b;\u0010/R\u001a\u0010<\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0019\"\u0004\b=\u0010/R\u001c\u0010>\u001a\u0004\u0018\u00010?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001c\u0010D\u001a\u0004\u0018\u00010?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010A\"\u0004\bF\u0010CR\u0017\u0010G\u001a\b\u0012\u0004\u0012\u00020?0H\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u0017\u0010K\u001a\b\u0012\u0004\u0012\u00020?0H\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010JR\u0017\u0010M\u001a\b\u0012\u0004\u0012\u00020?0N\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\"\u0010Q\u001a\n\u0012\u0004\u0012\u00020?\u0018\u00010RX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR$\u0010W\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010\u000f\"\u0004\bY\u0010\u0011R\u0011\u0010Z\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b[\u0010\u0019R\u0014\u0010\\\u001a\u00020?8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b]\u0010A\u00a8\u0006`"}, d2={"Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropBase;", "", "defaults", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsDefaults;", "<init>", "(Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsDefaults;)V", "getDefaults", "()Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsDefaults;", "uid", "Ljava/util/UUID;", "getUid", "()Ljava/util/UUID;", "amountRangeMin", "", "getAmountRangeMin", "()I", "setAmountRangeMin", "(I)V", "amountRangeMax", "getAmountRangeMax", "setAmountRangeMax", "value", "", "hasAmountRange", "getHasAmountRange", "()Z", "minLevel", "getMinLevel", "setMinLevel", "maxLevel", "getMaxLevel", "setMaxLevel", "priority", "getPriority", "setPriority", "maxDropGroup", "getMaxDropGroup", "setMaxDropGroup", "minPlayerLevel", "getMinPlayerLevel", "setMinPlayerLevel", "maxPlayerLevel", "getMaxPlayerLevel", "setMaxPlayerLevel", "useChunkKillMax", "getUseChunkKillMax", "setUseChunkKillMax", "(Z)V", "chance", "Lio/github/arcaneplugins/levelledmobs/customdrops/SlidingChance;", "getChance", "()Lio/github/arcaneplugins/levelledmobs/customdrops/SlidingChance;", "setChance", "(Lio/github/arcaneplugins/levelledmobs/customdrops/SlidingChance;)V", "playerCausedOnly", "getPlayerCausedOnly", "setPlayerCausedOnly", "noSpawner", "getNoSpawner", "setNoSpawner", "isDefaultDrop", "setDefaultDrop", "groupId", "", "getGroupId", "()Ljava/lang/String;", "setGroupId", "(Ljava/lang/String;)V", "playerLevelVariable", "getPlayerLevelVariable", "setPlayerLevelVariable", "permissions", "", "getPermissions", "()Ljava/util/List;", "playeerVariableMatches", "getPlayeerVariableMatches", "excludedMobs", "", "getExcludedMobs", "()Ljava/util/Set;", "causeOfDeathReqs", "Lio/github/arcaneplugins/levelledmobs/misc/CachedModalList;", "getCauseOfDeathReqs", "()Lio/github/arcaneplugins/levelledmobs/misc/CachedModalList;", "setCauseOfDeathReqs", "(Lio/github/arcaneplugins/levelledmobs/misc/CachedModalList;)V", "amount", "getAmount", "setAmount", "hasGroupId", "getHasGroupId", "amountAsString", "getAmountAsString", "setAmountRangeFromString", "numberOrNumberRange", "levelledmobs-plugin"})
public abstract class CustomDropBase {
    @NotNull
    private final CustomDropsDefaults defaults;
    @NotNull
    private final UUID uid;
    private int amountRangeMin;
    private int amountRangeMax;
    private boolean hasAmountRange;
    private int minLevel;
    private int maxLevel;
    private int priority;
    private int maxDropGroup;
    private int minPlayerLevel;
    private int maxPlayerLevel;
    private boolean useChunkKillMax;
    @Nullable
    private SlidingChance chance;
    private boolean playerCausedOnly;
    private boolean noSpawner;
    private boolean isDefaultDrop;
    @Nullable
    private String groupId;
    @Nullable
    private String playerLevelVariable;
    @NotNull
    private final List<String> permissions;
    @NotNull
    private final List<String> playeerVariableMatches;
    @NotNull
    private final Set<String> excludedMobs;
    @Nullable
    private CachedModalList<String> causeOfDeathReqs;
    private int amount;

    public CustomDropBase(@NotNull CustomDropsDefaults defaults) {
        Intrinsics.checkNotNullParameter(defaults, "defaults");
        this.defaults = defaults;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "randomUUID(...)");
        this.uid = uUID;
        this.permissions = new ArrayList();
        this.playeerVariableMatches = new ArrayList();
        this.excludedMobs = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        this.amount = 1;
    }

    @NotNull
    public final CustomDropsDefaults getDefaults() {
        return this.defaults;
    }

    @NotNull
    public final UUID getUid() {
        return this.uid;
    }

    public final int getAmountRangeMin() {
        return this.amountRangeMin;
    }

    public final void setAmountRangeMin(int n) {
        this.amountRangeMin = n;
    }

    public final int getAmountRangeMax() {
        return this.amountRangeMax;
    }

    public final void setAmountRangeMax(int n) {
        this.amountRangeMax = n;
    }

    public final boolean getHasAmountRange() {
        return this.hasAmountRange;
    }

    public final int getMinLevel() {
        return this.minLevel;
    }

    public final void setMinLevel(int n) {
        this.minLevel = n;
    }

    public final int getMaxLevel() {
        return this.maxLevel;
    }

    public final void setMaxLevel(int n) {
        this.maxLevel = n;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setPriority(int n) {
        this.priority = n;
    }

    public final int getMaxDropGroup() {
        return this.maxDropGroup;
    }

    public final void setMaxDropGroup(int n) {
        this.maxDropGroup = n;
    }

    public final int getMinPlayerLevel() {
        return this.minPlayerLevel;
    }

    public final void setMinPlayerLevel(int n) {
        this.minPlayerLevel = n;
    }

    public final int getMaxPlayerLevel() {
        return this.maxPlayerLevel;
    }

    public final void setMaxPlayerLevel(int n) {
        this.maxPlayerLevel = n;
    }

    public final boolean getUseChunkKillMax() {
        return this.useChunkKillMax;
    }

    public final void setUseChunkKillMax(boolean bl) {
        this.useChunkKillMax = bl;
    }

    @Nullable
    public final SlidingChance getChance() {
        return this.chance;
    }

    public final void setChance(@Nullable SlidingChance slidingChance) {
        this.chance = slidingChance;
    }

    public final boolean getPlayerCausedOnly() {
        return this.playerCausedOnly;
    }

    public final void setPlayerCausedOnly(boolean bl) {
        this.playerCausedOnly = bl;
    }

    public final boolean getNoSpawner() {
        return this.noSpawner;
    }

    public final void setNoSpawner(boolean bl) {
        this.noSpawner = bl;
    }

    public final boolean isDefaultDrop() {
        return this.isDefaultDrop;
    }

    public final void setDefaultDrop(boolean bl) {
        this.isDefaultDrop = bl;
    }

    @Nullable
    public final String getGroupId() {
        return this.groupId;
    }

    public final void setGroupId(@Nullable String string) {
        this.groupId = string;
    }

    @Nullable
    public final String getPlayerLevelVariable() {
        return this.playerLevelVariable;
    }

    public final void setPlayerLevelVariable(@Nullable String string) {
        this.playerLevelVariable = string;
    }

    @NotNull
    public final List<String> getPermissions() {
        return this.permissions;
    }

    @NotNull
    public final List<String> getPlayeerVariableMatches() {
        return this.playeerVariableMatches;
    }

    @NotNull
    public final Set<String> getExcludedMobs() {
        return this.excludedMobs;
    }

    @Nullable
    public final CachedModalList<String> getCauseOfDeathReqs() {
        return this.causeOfDeathReqs;
    }

    public final void setCauseOfDeathReqs(@Nullable CachedModalList<String> cachedModalList) {
        this.causeOfDeathReqs = cachedModalList;
    }

    public final int getAmount() {
        return this.amount;
    }

    public final void setAmount(int value) {
        this.amount = RangesKt.coerceAtMost(value, 64);
        this.amount = RangesKt.coerceAtLeast(this.amount, 1);
        this.hasAmountRange = false;
    }

    public final boolean getHasGroupId() {
        CharSequence charSequence = this.groupId;
        return !(charSequence == null || charSequence.length() == 0);
    }

    @NotNull
    public String getAmountAsString() {
        return this.hasAmountRange ? this.amountRangeMin + "-" + this.amountRangeMax : String.valueOf(this.amount);
    }

    public final boolean setAmountRangeFromString(@Nullable String numberOrNumberRange) {
        CharSequence charSequence = numberOrNumberRange;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        if (!StringsKt.contains$default((CharSequence)numberOrNumberRange, "-", false, 2, null)) {
            if (!Utils.INSTANCE.isDouble(numberOrNumberRange)) {
                return false;
            }
            this.setAmount((int)Double.parseDouble(numberOrNumberRange));
            this.hasAmountRange = false;
            return true;
        }
        String[] stringArray = new String[]{"-"};
        List nums = StringsKt.split$default((CharSequence)numberOrNumberRange, stringArray, false, 0, 6, null);
        if (nums.size() != 2) {
            return false;
        }
        if (!Utils.INSTANCE.isDouble(((Object)StringsKt.trim((CharSequence)((String)nums.get(0)))).toString()) || !Utils.INSTANCE.isDouble(((Object)StringsKt.trim((CharSequence)((String)nums.get(1)))).toString())) {
            return false;
        }
        this.amountRangeMin = (int)Double.parseDouble(((Object)StringsKt.trim((CharSequence)((String)nums.get(0)))).toString());
        this.amountRangeMax = (int)Double.parseDouble(((Object)StringsKt.trim((CharSequence)((String)nums.get(1)))).toString());
        this.hasAmountRange = true;
        return true;
    }
}

