/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands.subcommands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.commands.MessagesHelper;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.SpawnerBaseClass;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.NoWhenBranchMatchedException;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.enums.EnumEntries;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.enums.EnumEntriesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001 B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0016\u0010\u0014\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0002J\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerSubcommand;", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerBaseClass;", "<init>", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "buildCommand", "Lcom/mojang/brigadier/tree/LiteralCommandNode;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "processResults", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "operation", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerSubcommand$OperationEnum;", "parseInfoCommand", "allSpawnerOptions", "", "parseCopyCommand", "copyGotDisabled", "playerId", "Ljava/util/UUID;", "infoGotDisabled", "parseCreateCommand", "sender", "Lorg/bukkit/command/CommandSender;", "args", "generateSpawner", "info", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerBaseClass$CustomSpawnerInfo;", "OperationEnum", "levelledmobs-plugin"})
public final class SpawnerSubcommand
extends SpawnerBaseClass {
    @NotNull
    public static final SpawnerSubcommand INSTANCE = new SpawnerSubcommand();
    @NotNull
    private static final String description = "Various commands for creating spawner cubes.";
    @NotNull
    private static final List<String> allSpawnerOptions;

    private SpawnerSubcommand() {
        super("levelledmobs.command.spawner");
    }

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @NotNull
    public final LiteralCommandNode<CommandSourceStack> buildCommand() {
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("spawner").executes(SpawnerSubcommand::buildCommand$lambda$0)).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("create").then(this.createGreedyStringArgument$levelledmobs_plugin("values").suggests(SpawnerSubcommand::buildCommand$lambda$1).executes(SpawnerSubcommand::buildCommand$lambda$2))).executes(SpawnerSubcommand::buildCommand$lambda$3))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("copy").then(this.createStringArgument$levelledmobs_plugin("value").suggests(SpawnerSubcommand::buildCommand$lambda$4).executes(SpawnerSubcommand::buildCommand$lambda$5))).executes(SpawnerSubcommand::buildCommand$lambda$6))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("info").then(this.createStringArgument$levelledmobs_plugin("value").suggests(SpawnerSubcommand::buildCommand$lambda$7).executes(SpawnerSubcommand::buildCommand$lambda$8))).executes(SpawnerSubcommand::buildCommand$lambda$9))).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final void processResults(CommandContext<CommandSourceStack> ctx, OperationEnum operation) {
        this.setCommandSender(((CommandSourceStack)ctx.getSource()).getSender());
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        String string = ctx.getInput();
        Intrinsics.checkNotNullExpressionValue(string, "getInput(...)");
        List<String> args = this.splitStringWithQuotes(string, false);
        if (args.size() <= 2) {
            switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
                case 1: {
                    this.showMessage("command.levelledmobs.spawner.usage");
                    break;
                }
                case 2: {
                    UUID uUID = ((Player)sender).getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    UUID playerId = uUID;
                    this.showMessage(MainCompanion.Companion.getInstance().getSpawnerCopyIds().contains(playerId) ? "command.levelledmobs.spawner.copy.status-enabled" : "command.levelledmobs.spawner.copy.status-not-enabled");
                    break;
                }
                case 3: {
                    UUID uUID = ((Player)sender).getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    UUID playerId = uUID;
                    this.showMessage(MainCompanion.Companion.getInstance().getSpawnerInfoIds().contains(playerId) ? "command.levelledmobs.spawner.info.status-enabled" : "command.levelledmobs.spawner.info.status-not-enabled");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return;
        }
        boolean hasGivePlayer = false;
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            if (!StringsKt.equals("/giveplayer", args.get(i), true)) continue;
            hasGivePlayer = true;
            break;
        }
        if (!(hasGivePlayer && operation == OperationEnum.CREATE || sender instanceof Player)) {
            String messageName = operation != OperationEnum.CREATE ? "common.players-only" : "command.levelledmobs.spawner.no-player";
            MessagesHelper.INSTANCE.showMessage(sender, messageName);
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
            case 1: {
                this.parseCreateCommand(sender, args);
                break;
            }
            case 2: {
                this.parseCopyCommand(ctx);
                break;
            }
            case 3: {
                this.parseInfoCommand(ctx);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void parseInfoCommand(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        this.setCommandSender(sender);
        UUID uUID = ((Player)sender).getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        String value = this.getStringArgument$levelledmobs_plugin(ctx, "value");
        if (StringsKt.equals("on", value, true)) {
            if (main.getMainCompanion().getSpawnerCopyIds().contains(playerId)) {
                this.copyGotDisabled(playerId);
            }
            main.getMainCompanion().getSpawnerInfoIds().add(playerId);
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.info.enabled");
        } else if (StringsKt.equals("off", value, true)) {
            this.infoGotDisabled(playerId);
        }
    }

    private final void parseCopyCommand(CommandContext<CommandSourceStack> ctx) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        UUID uUID = ((Player)sender).getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        String value = this.getStringArgument$levelledmobs_plugin(ctx, "value");
        if (StringsKt.equals("on", value, true)) {
            if (main.getMainCompanion().getSpawnerInfoIds().contains(playerId)) {
                this.infoGotDisabled(playerId);
            }
            main.getMainCompanion().getSpawnerCopyIds().add(playerId);
            this.showMessage("command.levelledmobs.spawner.copy.enabled");
        } else if (StringsKt.equals("off", value, true)) {
            this.copyGotDisabled(playerId);
        }
    }

    private final void copyGotDisabled(UUID playerId) {
        MainCompanion.Companion.getInstance().getSpawnerCopyIds().remove(playerId);
        this.showMessage("command.levelledmobs.spawner.copy.disabled");
    }

    private final void infoGotDisabled(UUID playerId) {
        MainCompanion.Companion.getInstance().getSpawnerInfoIds().remove(playerId);
        this.showMessage("command.levelledmobs.spawner.info.disabled");
    }

    private final void parseCreateCommand(CommandSender sender, List<String> args) {
        int i;
        this.setHadInvalidArg(false);
        SpawnerBaseClass.CustomSpawnerInfo info = new SpawnerBaseClass.CustomSpawnerInfo(false);
        if (sender instanceof Player) {
            info.setPlayer((Player)sender);
        }
        int n = args.size();
        for (i = 1; i < n; ++i) {
            String arg = args.get(i);
            if (!StringsKt.equals("/nolore", arg, true)) continue;
            info.setNoLore(true);
            break;
        }
        n = allSpawnerOptions.size() - 1;
        block37: for (i = 0; i < n; ++i) {
            boolean mustBeANumber = i > 4;
            String command = allSpawnerOptions.get(i);
            String foundValue = this.getArgValue(command, args, mustBeANumber);
            if (this.getHadInvalidArg()) {
                return;
            }
            CharSequence charSequence = foundValue;
            if (charSequence == null || charSequence.length() == 0) continue;
            switch (command) {
                case "/name": {
                    info.setCustomName(foundValue);
                    continue block37;
                }
                case "/customdropid": {
                    info.setCustomDropId(foundValue);
                    continue block37;
                }
                case "/lore": {
                    info.setCustomLore(foundValue);
                    continue block37;
                }
                case "/spawntype": {
                    try {
                        String string = foundValue.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                        info.setSpawnType(EntityType.valueOf((String)string));
                        continue block37;
                    }
                    catch (Exception exception) {
                        sender.sendMessage("Invalid spawn type: " + foundValue);
                        return;
                    }
                }
                case "/minlevel": {
                    info.setMinLevel(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/maxlevel": {
                    info.setMaxLevel(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/delay": {
                    info.setDelay(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/maxnearbyentities": {
                    info.setMaxNearbyEntities(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/minspawndelay": {
                    info.setMinSpawnDelay(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/maxspawndelay": {
                    info.setMaxSpawnDelay(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/requiredplayerrange": {
                    info.setRequiredPlayerRange(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/spawncount": {
                    info.setSpawnCount(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/spawnrange": {
                    info.setSpawnRange(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/giveplayer": {
                    if (((CharSequence)foundValue).length() == 0) {
                        MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.no-player-specified");
                        return;
                    }
                    try {
                        info.setPlayer(Bukkit.getPlayer((String)foundValue));
                    }
                    catch (Exception exception) {
                        MessagesHelper.INSTANCE.showMessage(sender, "common.player-offline", "%player%", foundValue);
                        return;
                    }
                    if (info.getPlayer() != null) continue block37;
                    MessagesHelper.INSTANCE.showMessage(sender, "common.player-offline", "%player%", foundValue);
                    return;
                }
            }
        }
        if (info.getMinLevel() == -1 && info.getMaxLevel() == -1) {
            this.showMessage("command.levelledmobs.spawner.no-level-specified");
            return;
        }
        if (info.getPlayer() == null) {
            this.showMessage("command.levelledmobs.spawner.no-player-specified");
            return;
        }
        this.generateSpawner(info);
    }

    public final void generateSpawner(@NotNull SpawnerBaseClass.CustomSpawnerInfo info) {
        Intrinsics.checkNotNullParameter(info, "info");
        if (info.getCustomName() != null) {
            info.setCustomName(MessageUtils.INSTANCE.colorizeAll(info.getCustomName()));
        }
        ItemStack item = new ItemStack(Material.SPAWNER);
        ItemMeta meta = item.getItemMeta();
        String defaultName = "LM Spawner";
        this.setMetadata(item, info, defaultName);
        SpawnerBaseClass.Companion.setMetaItems(meta, info, defaultName);
        this.giveItemToPlayer$levelledmobs_plugin(item, info);
    }

    private static final int buildCommand$lambda$0(CommandContext ctx) {
        INSTANCE.setCommandSender(((CommandSourceStack)ctx.getSource()).getSender());
        INSTANCE.showMessage("command.levelledmobs.spawner.usage");
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$1(CommandContext ctx, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull(ctx);
        Intrinsics.checkNotNull(builder);
        return INSTANCE.buildTabSuggestions(allSpawnerOptions, (CommandContext<CommandSourceStack>)ctx, builder);
    }

    private static final int buildCommand$lambda$2(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processResults((CommandContext<CommandSourceStack>)ctx, OperationEnum.CREATE);
        return 1;
    }

    private static final int buildCommand$lambda$3(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processResults((CommandContext<CommandSourceStack>)ctx, OperationEnum.CREATE);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$4(CommandContext commandContext, SuggestionsBuilder builder) {
        return builder.suggest("on").suggest("off").buildFuture();
    }

    private static final int buildCommand$lambda$5(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processResults((CommandContext<CommandSourceStack>)ctx, OperationEnum.COPY);
        return 1;
    }

    private static final int buildCommand$lambda$6(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processResults((CommandContext<CommandSourceStack>)ctx, OperationEnum.COPY);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$7(CommandContext commandContext, SuggestionsBuilder builder) {
        return builder.suggest("on").suggest("off").buildFuture();
    }

    private static final int buildCommand$lambda$8(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processResults((CommandContext<CommandSourceStack>)ctx, OperationEnum.INFO);
        return 1;
    }

    private static final int buildCommand$lambda$9(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processResults((CommandContext<CommandSourceStack>)ctx, OperationEnum.INFO);
        return 1;
    }

    static {
        String[] stringArray = new String[]{"/name", "/customdropid", "/spawntype", "/giveplayer", "/lore", "/minlevel", "/maxlevel", "/delay", "/maxnearbyentities", "/minspawndelay", "/maxspawndelay", "/requiredplayerrange", "/spawncount", "/spawnrange", "/nolore"};
        allSpawnerOptions = CollectionsKt.mutableListOf(stringArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerSubcommand$OperationEnum;", "", "<init>", "(Ljava/lang/String;I)V", "CREATE", "COPY", "INFO", "levelledmobs-plugin"})
    private static final class OperationEnum
    extends Enum<OperationEnum> {
        public static final /* enum */ OperationEnum CREATE = new OperationEnum();
        public static final /* enum */ OperationEnum COPY = new OperationEnum();
        public static final /* enum */ OperationEnum INFO = new OperationEnum();
        private static final /* synthetic */ OperationEnum[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OperationEnum[] values() {
            return (OperationEnum[])$VALUES.clone();
        }

        public static OperationEnum valueOf(String value) {
            return Enum.valueOf(OperationEnum.class, value);
        }

        @NotNull
        public static EnumEntries<OperationEnum> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = operationEnumArray = new OperationEnum[]{OperationEnum.CREATE, OperationEnum.COPY, OperationEnum.INFO};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OperationEnum.values().length];
            try {
                nArray[OperationEnum.CREATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperationEnum.COPY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperationEnum.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

