/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands.subcommands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.commands.MessagesHelper;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.CommandBase;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.RulesSubcommand;
import io.github.arcaneplugins.levelledmobs.debug.DebugCreator;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.NoWhenBranchMatchedException;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.enums.EnumEntries;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.enums.EnumEntriesKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.SourceDebugExtension;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.StringCompanionObject;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.misc.ExternalPluginDetection;
import io.github.arcaneplugins.levelledmobs.rules.RuleInfo;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.MiscUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003KLMB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0016\u0010\"\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0010\u0010#\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010$\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0016\u0010%\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\"\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0005H\u0002J\u0016\u0010+\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0016\u0010,\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0010\u0010-\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010.\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020 H\u0002J\u0018\u00101\u001a\u00020 2\u0006\u00102\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u00103\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u00104\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u00105\u001a\u000206H\u0002J\u0016\u00107\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J&\u00108\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00109\u001a\u00020:H\u0002J\u0018\u0010;\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010<\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J.\u0010=\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010>\u001a\u00020 2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050@2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010A\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010B\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010C\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u001c\u0010D\u001a\u0004\u0018\u00010)2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010E\u001a\u0004\u0018\u00010FH\u0002J\u0010\u0010G\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J4\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020 H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006N"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/DebugSubcommand;", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/CommandBase;", "<init>", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "buildCommand", "Lcom/mojang/brigadier/tree/LiteralCommandNode;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "processDamageDebugOutput", "", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "createFilterResultsCommand", "createSetHeightCommands", "showYHeightSettings", "sender", "Lorg/bukkit/command/CommandSender;", "viewQueues", "getListenForValues", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "builder", "Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;", "buildGenericListTypes", "commandName", "listType", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/DebugSubcommand$ListTypes;", "showPDCKeys", "showOnConsole", "", "createZip", "chunkKillCount", "showPluginDefinitions", "nbtDump", "doNbtDump", "formatDumpMessage", "messageStart", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "values", "parseEnableTimer", "parseOutputTo", "showCustomDrops", "enableOrDisableDebug", "isEnable", "isEnableAll", "parseEnableDebugCategory", "debugCategory", "clearFilters", "parseNumberValue", "numberSetting", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/DebugSubcommand$NumberSettings;", "updateEvaluationType", "parseTypeValues", "operationType", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/DebugSubcommand$OperationType;", "viewList", "clearList", "addOrRemoveItemsToList", "isAdd", "items", "", "showLEWDebug", "clearLEWCache", "showSpawnDistance", "getNearbyMob", "optionalTarget", "Lorg/bukkit/entity/Player;", "showPlayerLocation", "getDebugTypes", "getOutputToTypes", "getUnusedListTypes", "OperationType", "NumberSettings", "ListTypes", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nDebugSubcommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugSubcommand.kt\nio/github/arcaneplugins/levelledmobs/commands/subcommands/DebugSubcommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1014:1\n1915#2,2:1015\n*S KotlinDebug\n*F\n+ 1 DebugSubcommand.kt\nio/github/arcaneplugins/levelledmobs/commands/subcommands/DebugSubcommand\n*L\n1011#1:1015,2\n*E\n"})
public final class DebugSubcommand
extends CommandBase {
    @NotNull
    public static final DebugSubcommand INSTANCE = new DebugSubcommand();
    @NotNull
    private static final String description = "Various commands for debugging.";

    private DebugSubcommand() {
        super("levelledmobs.command.debug");
    }

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @NotNull
    public final LiteralCommandNode<CommandSourceStack> buildCommand() {
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("debug").executes(DebugSubcommand::buildCommand$lambda$0)).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("create-zip").then(this.createStringArgument$levelledmobs_plugin("confirm").suggests(DebugSubcommand::buildCommand$lambda$1).executes(DebugSubcommand::buildCommand$lambda$2))).executes(DebugSubcommand::buildCommand$lambda$3))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("chunk-kill-count").then(this.createStringArgument$levelledmobs_plugin("reset").suggests(DebugSubcommand::buildCommand$lambda$4).executes(DebugSubcommand::buildCommand$lambda$5))).executes(DebugSubcommand::buildCommand$lambda$6))).then(this.createLiteralCommand$levelledmobs_plugin("view-queues").executes(DebugSubcommand::buildCommand$lambda$7))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("nbt-dump").then(this.createPlayerArgument$levelledmobs_plugin("target").executes(DebugSubcommand::buildCommand$lambda$8))).executes(DebugSubcommand::buildCommand$lambda$9))).then(this.createLiteralCommand$levelledmobs_plugin("my-location").executes(DebugSubcommand::buildCommand$lambda$10))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("spawn-distance").then(this.createPlayerArgument$levelledmobs_plugin("target").executes(DebugSubcommand::buildCommand$lambda$11))).executes(DebugSubcommand::buildCommand$lambda$12))).then(this.createLiteralCommand$levelledmobs_plugin("lew-debug").executes(DebugSubcommand::buildCommand$lambda$13))).then(this.createLiteralCommand$levelledmobs_plugin("lew-clear").executes(DebugSubcommand::buildCommand$lambda$14))).then(this.createLiteralCommand$levelledmobs_plugin("show-customdrops").executes(DebugSubcommand::buildCommand$lambda$15))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("show-pdc-keys").then(this.createStringArgument$levelledmobs_plugin("console").suggests(DebugSubcommand::buildCommand$lambda$16).executes(DebugSubcommand::buildCommand$lambda$17))).executes(DebugSubcommand::buildCommand$lambda$18))).then(this.createLiteralCommand$levelledmobs_plugin("show-plugin-definitions").executes(DebugSubcommand::buildCommand$lambda$19))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("enable").then(this.createStringArgument$levelledmobs_plugin("category").suggests(DebugSubcommand::buildCommand$lambda$20).executes(DebugSubcommand::buildCommand$lambda$21))).executes(DebugSubcommand::buildCommand$lambda$22))).then(this.createLiteralCommand$levelledmobs_plugin("enable-all").executes(DebugSubcommand::buildCommand$lambda$23))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("damage-debug-output").then(this.createStringArgument$levelledmobs_plugin("operation").suggests(DebugSubcommand::buildCommand$lambda$24).executes(DebugSubcommand::buildCommand$lambda$25))).executes(DebugSubcommand::buildCommand$lambda$26))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("enable-timer").then(((RequiredArgumentBuilder)this.createStringArgument$levelledmobs_plugin("time").then(this.createStringArgument$levelledmobs_plugin("category").suggests(DebugSubcommand::buildCommand$lambda$27).executes(DebugSubcommand::buildCommand$lambda$28))).executes(DebugSubcommand::buildCommand$lambda$29))).executes(DebugSubcommand::buildCommand$lambda$30))).then(this.createLiteralCommand$levelledmobs_plugin("disable").executes(DebugSubcommand::buildCommand$lambda$31))).then((CommandNode)this.createFilterResultsCommand())).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("output-debug").then(this.createStringArgument$levelledmobs_plugin("output").suggests(DebugSubcommand::buildCommand$lambda$32).executes(DebugSubcommand::buildCommand$lambda$33))).executes(DebugSubcommand::buildCommand$lambda$34))).then(this.createLiteralCommand$levelledmobs_plugin("view-debug-status").executes(DebugSubcommand::buildCommand$lambda$35))).then(this.createLiteralCommand$levelledmobs_plugin("view-queues").executes(DebugSubcommand::buildCommand$lambda$36))).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final void processDamageDebugOutput(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        String operation = this.getStringArgument$levelledmobs_plugin(ctx, "operation", null);
        DebugManager debugMgr = LevelledMobs.Companion.getInstance().getDebugManager();
        CharSequence charSequence = operation;
        if (charSequence == null || charSequence.length() == 0) {
            String status = debugMgr.getDamageDebugOutputIsEnabled() ? "enabled" : "disabled";
            sender.sendMessage("Damage Debug Output status: " + status);
            return;
        }
        if (StringsKt.equals("enable", operation, true)) {
            if (debugMgr.getDamageDebugOutputIsEnabled()) {
                sender.sendMessage("Damage Debug Output is enabled.");
            } else {
                debugMgr.toggleDamageDebugOutput(true);
                sender.sendMessage("Damage Debug Output is now enabled.");
            }
        } else if (StringsKt.equals("disable", operation, true)) {
            if (debugMgr.getDamageDebugOutputIsEnabled()) {
                debugMgr.toggleDamageDebugOutput(false);
                sender.sendMessage("Damage Debug Output is now disabled.");
            } else {
                sender.sendMessage("Damage Debug Output is disabled.");
            }
        } else {
            sender.sendMessage("Invalid option: " + operation);
        }
    }

    private final LiteralCommandNode<CommandSourceStack> createFilterResultsCommand() {
        String genericMessage = "Please select a filter option";
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("filter-results").then((CommandNode)this.buildGenericListTypes("set-debug", ListTypes.DEBUG))).executes(arg_0 -> DebugSubcommand.createFilterResultsCommand$lambda$0(genericMessage, arg_0))).then((CommandNode)this.buildGenericListTypes("set-entities", ListTypes.ENTITY))).executes(arg_0 -> DebugSubcommand.createFilterResultsCommand$lambda$1(genericMessage, arg_0))).then((CommandNode)this.buildGenericListTypes("set-rules", ListTypes.RULE_NAMES))).executes(arg_0 -> DebugSubcommand.createFilterResultsCommand$lambda$2(genericMessage, arg_0))).then((CommandNode)this.buildGenericListTypes("set-players", ListTypes.PLAYERS))).executes(arg_0 -> DebugSubcommand.createFilterResultsCommand$lambda$3(genericMessage, arg_0))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("listen-for").then(this.createStringArgument$levelledmobs_plugin("value").suggests(DebugSubcommand::createFilterResultsCommand$lambda$4).executes(DebugSubcommand::createFilterResultsCommand$lambda$5))).executes(DebugSubcommand::createFilterResultsCommand$lambda$6))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("set-distance-from-players").then(this.createStringArgument$levelledmobs_plugin("value").executes(DebugSubcommand::createFilterResultsCommand$lambda$7))).executes(DebugSubcommand::createFilterResultsCommand$lambda$8))).then((CommandNode)this.createSetHeightCommands())).then(this.createLiteralCommand$levelledmobs_plugin("clear-all-filters").executes(DebugSubcommand::createFilterResultsCommand$lambda$9))).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final LiteralCommandNode<CommandSourceStack> createSetHeightCommands() {
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("set-y-height").executes(DebugSubcommand::createSetHeightCommands$lambda$0)).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("min-y-height").then(this.createStringArgument$levelledmobs_plugin("value").executes(DebugSubcommand::createSetHeightCommands$lambda$1))).executes(DebugSubcommand::createSetHeightCommands$lambda$2))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("max-y-height").then(this.createStringArgument$levelledmobs_plugin("value").executes(DebugSubcommand::createSetHeightCommands$lambda$3))).executes(DebugSubcommand::createSetHeightCommands$lambda$4))).then(this.createLiteralCommand$levelledmobs_plugin("clear").executes(DebugSubcommand::createSetHeightCommands$lambda$5))).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final void showYHeightSettings(CommandSender sender) {
        sender.sendMessage("min-y-height: " + LevelledMobs.Companion.getInstance().getDebugManager().getMinYLevel() + ", max-y-height: " + LevelledMobs.Companion.getInstance().getDebugManager().getMaxYLevel());
    }

    private final void viewQueues(CommandSender sender) {
        int nametagQueueNum = LevelledMobs.Companion.getInstance().getNametagQueueManager().getNumberQueued();
        BukkitTask nametagQueueTask = LevelledMobs.Companion.getInstance().getNametagQueueManager().getQueueTask();
        int mobQueueNum = LevelledMobs.Companion.getInstance().getMobsQueueManager().getNumberQueued();
        boolean isNametagTaskRunning = nametagQueueTask != null ? Bukkit.getScheduler().isCurrentlyRunning(nametagQueueTask.getTaskId()) : false;
        BukkitTask bukkitTask = nametagQueueTask;
        String nametagtaskStatus = bukkitTask == null ? "(null)" : "id: " + bukkitTask.getTaskId() + ", is running: " + isNametagTaskRunning + ", is cancelled: " + nametagQueueTask.isCancelled();
        StringBuilder mobsTaskStatus = new StringBuilder();
        for (BukkitTask task : LevelledMobs.Companion.getInstance().getMobsQueueManager().getQueueTasks().values()) {
            boolean isRunning = Bukkit.getScheduler().isCurrentlyRunning(task.getTaskId());
            mobsTaskStatus.append("\n   ");
            mobsTaskStatus.append("id: " + task.getTaskId() + ", is running: " + isRunning + ", is cancelled: " + task.isCancelled());
        }
        sender.sendMessage("Nametag Manager items: " + nametagQueueNum + ", Mob Queue Manager items: " + mobQueueNum + "\nMobs queue statuses: " + mobsTaskStatus + "\nNametag task status: " + nametagtaskStatus);
    }

    private final CompletableFuture<Suggestions> getListenForValues(SuggestionsBuilder builder) {
        for (DebugManager.ListenFor evaluationType : DebugManager.ListenFor.getEntries()) {
            if (LevelledMobs.Companion.getInstance().getDebugManager().getListenFor() == evaluationType) continue;
            String string = evaluationType.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            builder.suggest(string);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    private final LiteralCommandNode<CommandSourceStack> buildGenericListTypes(String commandName, ListTypes listType) {
        LiteralCommandNode literalCommandNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin(commandName).executes(arg_0 -> DebugSubcommand.buildGenericListTypes$lambda$0(listType, arg_0))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("add").executes(arg_0 -> DebugSubcommand.buildGenericListTypes$lambda$1(listType, arg_0))).then(this.createGreedyStringArgument$levelledmobs_plugin("values").suggests((arg_0, arg_1) -> DebugSubcommand.buildGenericListTypes$lambda$2(listType, arg_0, arg_1)).executes(arg_0 -> DebugSubcommand.buildGenericListTypes$lambda$3(listType, arg_0))))).then(((LiteralArgumentBuilder)this.createLiteralCommand$levelledmobs_plugin("remove").executes(arg_0 -> DebugSubcommand.buildGenericListTypes$lambda$4(listType, arg_0))).then(this.createGreedyStringArgument$levelledmobs_plugin("values").suggests((arg_0, arg_1) -> DebugSubcommand.buildGenericListTypes$lambda$5(listType, arg_0, arg_1)).executes(arg_0 -> DebugSubcommand.buildGenericListTypes$lambda$6(listType, arg_0))))).then(this.createLiteralCommand$levelledmobs_plugin("clear").executes(arg_0 -> DebugSubcommand.buildGenericListTypes$lambda$7(listType, arg_0)))).build();
        Intrinsics.checkNotNullExpressionValue(literalCommandNode, "build(...)");
        return literalCommandNode;
    }

    private final void showPDCKeys(CommandContext<CommandSourceStack> ctx, boolean showOnConsole) {
        Player player;
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (player == null) {
            sender.sendMessage("This command must be run by a player");
            return;
        }
        boolean showOnConsole2 = showOnConsole;
        if (sender instanceof ConsoleCommandSender) {
            showOnConsole2 = true;
        }
        LivingEntityWrapper livingEntityWrapper = RulesSubcommand.INSTANCE.getMobBeingLookedAt(player, true, sender);
        if (livingEntityWrapper == null) {
            return;
        }
        LivingEntityWrapper lmEntity = livingEntityWrapper;
        Map<String, String> results = MiscUtils.INSTANCE.getPDCKeys(lmEntity.getLivingEntity());
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, String> items : results.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("\n");
            }
            sb.append("key: &b" + items.getKey() + "&r, " + items.getValue());
        }
        String message = results.isEmpty() ? this.formatDumpMessage("No PDC keys were found for", lmEntity, null) : this.formatDumpMessage("Showing PDC keys for", lmEntity, sb.toString());
        lmEntity.free();
        if (showOnConsole2 && !results.isEmpty()) {
            Log.INSTANCE.inf(message);
            sender.sendMessage("PDC keys have been printed in the console");
        } else {
            sender.sendMessage(MessageUtils.INSTANCE.colorizeAll(message));
        }
    }

    private final void createZip(CommandContext<CommandSourceStack> ctx) {
        if (this.getStringArgumentAsBool$levelledmobs_plugin(ctx, "confirm")) {
            CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            DebugCreator.INSTANCE.createDebug(commandSender);
        } else {
            CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
            Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
            MessagesHelper.INSTANCE.showMessage(commandSender, "other.create-debug");
        }
    }

    private final void chunkKillCount(CommandContext<CommandSourceStack> ctx) {
        List list = ctx.getNodes();
        Intrinsics.checkNotNullExpressionValue(list, "getNodes(...)");
        String lastNodeName = ((ParsedCommandNode)CollectionsKt.last(list)).getNode().getName();
        String name = "reset";
        if (Intrinsics.areEqual(lastNodeName, name) && StringsKt.equals(name, (String)ctx.getArgument(name, String.class), true)) {
            MainCompanion.Companion.getInstance().clearChunkKillCache();
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("cache has been cleared");
        } else {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("Options: reset");
        }
    }

    private final void showPluginDefinitions(CommandSender sender) {
        ExternalCompatibilityManager ext = ExternalCompatibilityManager.Companion.getInstance();
        if (ext.getExternalPluginDefinitions().isEmpty()) {
            sender.sendMessage("No external plugins defined");
        }
        StringBuilder sb = new StringBuilder("Currently defined plugins:");
        for (ExternalPluginDetection plugin : ext.getExternalPluginDefinitions().values()) {
            sb.append("\n    ");
            sb.append(plugin.toString());
        }
        sender.sendMessage(sb.toString());
    }

    private final void nbtDump(CommandContext<CommandSourceStack> ctx) {
        if (!LevelledMobs.Companion.getInstance().getVer().isNMSVersionValid()) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("Unable to dump, an unknown NMS version was detected");
            return;
        }
        this.doNbtDump(ctx);
        if (!(((CommandSourceStack)ctx.getSource()).getSender() instanceof ConsoleCommandSender)) {
            ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("NBT data has been written to the console");
        }
    }

    private final void doNbtDump(CommandContext<CommandSourceStack> ctx) {
        Player optionalTarget = this.getPlayerArgument$levelledmobs_plugin(ctx, "target");
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        LivingEntityWrapper livingEntityWrapper = this.getNearbyMob(sender, optionalTarget);
        if (livingEntityWrapper == null) {
            return;
        }
        LivingEntityWrapper lmEntity = livingEntityWrapper;
        String message = this.formatDumpMessage("Showing nbt dump for", lmEntity, MiscUtils.INSTANCE.getNBTDump(lmEntity.getLivingEntity()));
        lmEntity.free();
        Log.INSTANCE.inf(message);
    }

    private final String formatDumpMessage(String messageStart, LivingEntityWrapper lmEntity, String values) {
        String entityName = lmEntity.getNameIfBaby();
        if (ExternalCompatibilityManager.Companion.getHasMythicMobsInstalled() && ExternalCompatibilityManager.Companion.isMythicMob(lmEntity)) {
            entityName = ExternalCompatibilityManager.Companion.getMythicMobInternalName(lmEntity);
        } else if (lmEntity.getLivingEntity().getCustomName() != null) {
            String string = lmEntity.getLivingEntity().getCustomName();
            Intrinsics.checkNotNull(string);
            entityName = string;
        }
        String locationStr = lmEntity.getLivingEntity().getLocation().getBlockX() + ", " + lmEntity.getLivingEntity().getLocation().getBlockY() + ", " + lmEntity.getLivingEntity().getLocation().getBlockZ();
        String mobLevel = lmEntity.isLevelled() ? String.valueOf(lmEntity.getGetMobLevel()) : "0";
        String string = values;
        Object showValues = string != null ? "\n" + string : "";
        return StringsKt.equals(lmEntity.getNameIfBaby(), entityName, true) ? messageStart + ": " + entityName + " (lvl " + mobLevel + ") in " + lmEntity.getWorldName() + ", " + locationStr + "&r" + (String)showValues : messageStart + ": " + entityName + " (lvl " + mobLevel + " " + lmEntity.getTypeName() + ") in " + lmEntity.getWorldName() + ", " + locationStr + "&r" + (String)showValues;
    }

    private final void parseEnableTimer(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        String input = this.getStringArgument$levelledmobs_plugin(ctx, "time");
        if (((CharSequence)input).length() == 0) {
            sender.sendMessage("No value was specified");
            return;
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (Intrinsics.areEqual("0", input) || StringsKt.equals("none", input, true)) {
            main.getDebugManager().setDisableAfter(null);
            main.getDebugManager().setDisableAfterStr(null);
            main.getDebugManager().timerWasChanged(false);
            sender.sendMessage("Debug timer disabled");
            return;
        }
        Long disableAfter = Utils.INSTANCE.parseTimeUnit(input, null, true, sender);
        if (disableAfter != null) {
            String category = this.getStringArgument$levelledmobs_plugin(ctx, "category");
            if (((CharSequence)category).length() > 0 && !this.parseEnableDebugCategory(category, sender)) {
                return;
            }
            main.getDebugManager().setDisableAfter(disableAfter);
            main.getDebugManager().setDisableAfterStr(input);
            sender.sendMessage("Debug enabled for " + input);
            if (main.getDebugManager().isEnabled()) {
                main.getDebugManager().timerWasChanged(true);
            } else {
                main.getDebugManager().enableDebug(sender, true, false);
            }
        }
    }

    private final void parseOutputTo(CommandContext<CommandSourceStack> ctx) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        String output = this.getStringArgument$levelledmobs_plugin(ctx, "output");
        if (((CharSequence)output).length() == 0) {
            String string = main.getDebugManager().getOutputType().name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            sender.sendMessage("Current value: " + StringsKt.replace$default(string, "_", "-", false, 4, null));
            return;
        }
        boolean wasInvalid = false;
        String string = output.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "to-console": {
                main.getDebugManager().setOutputType(DebugManager.OutputTypes.TO_CONSOLE);
                break;
            }
            case "to-chat": {
                main.getDebugManager().setOutputType(DebugManager.OutputTypes.TO_CHAT);
                break;
            }
            case "to-both": {
                main.getDebugManager().setOutputType(DebugManager.OutputTypes.TO_BOTH);
                break;
            }
            default: {
                sender.sendMessage("Invalid option: " + output);
                wasInvalid = true;
            }
        }
        if (!wasInvalid) {
            String string2 = StringsKt.replace$default(main.getDebugManager().getOutputType().name(), "_", "-", false, 4, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            sender.sendMessage("Output-debug updated to " + string2);
        }
        if (main.getDebugManager().getOutputType() != DebugManager.OutputTypes.TO_CONSOLE) {
            sender.sendMessage("WARNING: sending debug messages to chat can cause huge chat spam.");
        }
    }

    private final void showCustomDrops(CommandSender sender) {
        LevelledMobs.Companion.getInstance().getCustomDropsHandler().getCustomDropsParser().showCustomDropsDebugInfo(sender);
    }

    private final void enableOrDisableDebug(CommandContext<CommandSourceStack> ctx, boolean isEnable, boolean isEnableAll) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        boolean wasEnabled = main.getDebugManager().isEnabled();
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        String debugCategory = this.getStringArgument$levelledmobs_plugin(ctx, "category");
        if (isEnable) {
            boolean wasTimerEnabled = main.getDebugManager().isTimerEnabled();
            boolean enableAllChanged = main.getDebugManager().getBypassAllFilters() != isEnableAll;
            if (((CharSequence)debugCategory).length() > 0 && !this.parseEnableDebugCategory(debugCategory, sender)) {
                return;
            }
            main.getDebugManager().enableDebug(sender, false, isEnableAll);
            if (wasEnabled && !enableAllChanged) {
                if (wasTimerEnabled) {
                    sender.sendMessage("Debugging is already enabled, disabled timer");
                } else {
                    sender.sendMessage("Debugging is already enabled");
                }
            } else if (isEnableAll) {
                sender.sendMessage("All debug options enabled");
            } else {
                sender.sendMessage("Debugging is now enabled");
            }
        } else {
            main.getDebugManager().disableDebug();
            if (wasEnabled) {
                sender.sendMessage("Debugging is now disabled");
            } else {
                sender.sendMessage("Debugging is already disabled");
            }
        }
    }

    private final boolean parseEnableDebugCategory(String debugCategory, CommandSender sender) {
        DebugType debugType = null;
        try {
            String string = debugCategory.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            debugType = DebugType.valueOf(string);
        }
        catch (Exception exception) {
            sender.sendMessage("Invalid debug type: " + debugCategory);
            return false;
        }
        LevelledMobs.Companion.getInstance().getDebugManager().getFilterDebugTypes().clear();
        LevelledMobs.Companion.getInstance().getDebugManager().getFilterDebugTypes().add(debugType);
        sender.sendMessage("Debug type set to " + debugCategory);
        return true;
    }

    private final void clearFilters(CommandSender sender) {
        LevelledMobs.Companion.getInstance().getDebugManager().resetFilters();
        sender.sendMessage("All filters have been cleared");
    }

    private final void parseNumberValue(CommandContext<CommandSourceStack> ctx, NumberSettings numberSetting) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        String numberStr = this.getStringArgument$levelledmobs_plugin(ctx, "value");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        boolean useNull = ((CharSequence)numberStr).length() == 0 || StringsKt.equals("none", numberStr, true);
        try {
            Integer value = useNull ? null : Integer.valueOf(Integer.parseInt(numberStr));
            switch (WhenMappings.$EnumSwitchMapping$0[numberSetting.ordinal()]) {
                case 1: {
                    if (((CharSequence)numberStr).length() == 0) {
                        sender.sendMessage("Distance from players current value: " + main.getDebugManager().getMaxPlayerDistance());
                    } else {
                        main.getDebugManager().setMaxPlayerDistance(value);
                        sender.sendMessage("Distance from players set to " + value);
                    }
                    break;
                }
                case 2: {
                    if (((CharSequence)numberStr).length() == 0) {
                        sender.sendMessage("Min y-height current value: " + main.getDebugManager().getMinYLevel());
                    } else {
                        main.getDebugManager().setMinYLevel(value);
                        sender.sendMessage("Min y-height set to " + value);
                    }
                    break;
                }
                case 3: {
                    if (((CharSequence)numberStr).length() == 0) {
                        sender.sendMessage("Max y-height current value: " + main.getDebugManager().getMaxYLevel());
                    } else {
                        main.getDebugManager().setMaxYLevel(value);
                        sender.sendMessage("Max y-height set to " + value);
                    }
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        catch (Exception exception) {
            sender.sendMessage("Invalid number: " + numberStr);
        }
    }

    private final void updateEvaluationType(CommandContext<CommandSourceStack> ctx) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        String value = this.getStringArgument$levelledmobs_plugin(ctx, "value");
        if (((CharSequence)value).length() == 0) {
            sender.sendMessage("Current value: " + main.getDebugManager().getListenFor());
            return;
        }
        try {
            DebugManager debugManager = main.getDebugManager();
            String string = value.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            debugManager.setListenFor(DebugManager.ListenFor.valueOf(string));
            switch (WhenMappings.$EnumSwitchMapping$1[main.getDebugManager().getListenFor().ordinal()]) {
                case 1: {
                    sender.sendMessage("Listening for all debug notice events");
                    break;
                }
                case 2: {
                    sender.sendMessage("Listening for failed debug notice events");
                    break;
                }
                case 3: {
                    sender.sendMessage("Listening for successful debug notice events");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        catch (Exception exception) {
            sender.sendMessage("Invalid listen-for type: " + value + ", valid options are: failure, success, both");
        }
    }

    private final void parseTypeValues(CommandContext<CommandSourceStack> ctx, ListTypes listType, OperationType operationType) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        if (operationType == OperationType.VIEW) {
            this.viewList(sender, listType);
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$3[operationType.ordinal()]) {
            case 1: {
                this.clearList(listType);
                String listTypeMsg = switch (WhenMappings.$EnumSwitchMapping$2[listType.ordinal()]) {
                    case 1 -> "Players";
                    case 2 -> "Rule names";
                    case 3 -> "Entity types";
                    case 4 -> "Debug types";
                    default -> throw new NoWhenBranchMatchedException();
                };
                sender.sendMessage("All filters cleared for " + listTypeMsg);
                break;
            }
            case 2: 
            case 3: {
                String input = this.getStringArgument$levelledmobs_plugin(ctx, "values");
                if (((CharSequence)input).length() == 0) {
                    sender.sendMessage("No value was specified");
                    return;
                }
                List<String> inputValue = this.splitStringWithQuotes(input, false);
                this.addOrRemoveItemsToList(sender, operationType == OperationType.ADD, inputValue, listType);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void viewList(CommandSender sender, ListTypes listType) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Set<Object> useList = switch (WhenMappings.$EnumSwitchMapping$2[listType.ordinal()]) {
            case 4 -> main.getDebugManager().getFilterDebugTypes();
            case 3 -> main.getDebugManager().getFilterEntityTypes();
            case 2 -> main.getDebugManager().getFilterRuleNames();
            case 1 -> main.getDebugManager().getFilterPlayerNames();
            default -> throw new NoWhenBranchMatchedException();
        };
        String msg = useList.isEmpty() ? "No values currently defined" : useList.toString();
        sender.sendMessage(msg);
    }

    private final void clearList(ListTypes listType) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        switch (WhenMappings.$EnumSwitchMapping$2[listType.ordinal()]) {
            case 4: {
                main.getDebugManager().getFilterDebugTypes().clear();
                break;
            }
            case 3: {
                main.getDebugManager().getFilterEntityTypes().clear();
                break;
            }
            case 2: {
                main.getDebugManager().getFilterRuleNames().clear();
                break;
            }
            case 1: {
                main.getDebugManager().getFilterPlayerNames().clear();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void addOrRemoveItemsToList(CommandSender sender, boolean isAdd, List<String> items, ListTypes listType) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        DebugManager dm = main.getDebugManager();
        List optionsAddedOrRemoved = new ArrayList();
        switch (WhenMappings.$EnumSwitchMapping$2[listType.ordinal()]) {
            case 4: {
                for (String debugTypeStr : items) {
                    try {
                        boolean bl;
                        String string = debugTypeStr.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                        DebugType debugType = DebugType.valueOf(string);
                        if (isAdd) {
                            dm.getFilterDebugTypes().add(debugType);
                            bl = optionsAddedOrRemoved.add(debugType.name());
                            continue;
                        }
                        dm.getFilterDebugTypes().remove((Object)debugType);
                        bl = optionsAddedOrRemoved.add(debugType.name());
                    }
                    catch (Exception exception) {
                        if (!isAdd) continue;
                        sender.sendMessage("Invalid debug type: " + debugTypeStr);
                    }
                }
                break;
            }
            case 3: {
                for (String entityTypeStr : items) {
                    try {
                        boolean bl;
                        String string = entityTypeStr.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                        EntityType entityType = EntityType.valueOf((String)string);
                        if (isAdd) {
                            dm.getFilterEntityTypes().add(entityType);
                            bl = optionsAddedOrRemoved.add(entityType.name());
                            continue;
                        }
                        dm.getFilterEntityTypes().remove(entityType);
                        bl = optionsAddedOrRemoved.add(entityType.name());
                    }
                    catch (Exception exception) {
                        if (!isAdd) continue;
                        sender.sendMessage("Invalid entity type: " + entityTypeStr);
                    }
                }
                break;
            }
            case 2: {
                Set allRuleNames = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
                for (RuleInfo ruleInfo : main.getRulesParsingManager().getAllRules(false)) {
                    allRuleNames.add(StringsKt.replace$default(ruleInfo.getRuleName$levelledmobs_plugin(), " ", "_", false, 4, null));
                }
                for (String ruleName : items) {
                    if (isAdd) {
                        String actualRuleName = null;
                        for (String foundRuleName : allRuleNames) {
                            if (!StringsKt.equals(foundRuleName, ruleName, true)) continue;
                            actualRuleName = foundRuleName;
                            break;
                        }
                        if (actualRuleName != null) {
                            dm.getFilterRuleNames().add(StringsKt.replace$default(actualRuleName, " ", "_", false, 4, null));
                            optionsAddedOrRemoved.add(actualRuleName);
                            continue;
                        }
                        sender.sendMessage("Invalid rule name: " + ruleName);
                        continue;
                    }
                    dm.getFilterRuleNames().remove(ruleName);
                    optionsAddedOrRemoved.add(ruleName);
                }
                break;
            }
            case 1: {
                if (isAdd) {
                    dm.getFilterPlayerNames().addAll((Collection<String>)items);
                    optionsAddedOrRemoved.addAll((Collection)items);
                    break;
                }
                for (String playerName : items) {
                    dm.getFilterPlayerNames().remove(playerName);
                    optionsAddedOrRemoved.add(playerName);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!((Collection)optionsAddedOrRemoved).isEmpty()) {
            String string = StringsKt.replace$default(listType.name(), "_", " ", false, 4, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            String useName = string;
            if (isAdd) {
                sender.sendMessage("Added values to " + useName + " : " + optionsAddedOrRemoved);
            } else {
                sender.sendMessage("Removed values from " + useName + ": " + optionsAddedOrRemoved);
            }
        }
    }

    private final void showLEWDebug(CommandSender sender) {
        if (!sender.hasPermission("levelledmobs.command.debug.lew_debug")) {
            LevelledMobs.Companion.getInstance().getConfigUtils().sendNoPermissionMsg(sender);
            return;
        }
        String result = LivingEntityWrapper.Companion.getLEWDebug();
        sender.sendMessage(result);
    }

    private final void clearLEWCache(CommandSender sender) {
        if (!sender.hasPermission("levelledmobs.command.debug.lew_clear")) {
            LevelledMobs.Companion.getInstance().getConfigUtils().sendNoPermissionMsg(sender);
            return;
        }
        LivingEntityWrapper.Companion.clearCache();
        sender.sendMessage("Cleared the LEW cache");
    }

    private final void showSpawnDistance(CommandContext<CommandSourceStack> ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        CommandSender sender = commandSender;
        Player optionalTarget = this.getPlayerArgument$levelledmobs_plugin(ctx, "target");
        LivingEntityWrapper livingEntityWrapper = this.getNearbyMob(sender, optionalTarget);
        if (livingEntityWrapper == null) {
            return;
        }
        LivingEntityWrapper lmEntity = livingEntityWrapper;
        double distance = lmEntity.getDistanceFromSpawn();
        String locationStr = lmEntity.getLivingEntity().getLocation().getBlockX() + ", " + lmEntity.getLivingEntity().getLocation().getBlockY() + ", " + lmEntity.getLivingEntity().getLocation().getBlockZ();
        String mobLevel = lmEntity.isLevelled() ? String.valueOf(lmEntity.getGetMobLevel()) : "0";
        String entityName = lmEntity.getTypeName();
        if (ExternalCompatibilityManager.Companion.getHasMythicMobsInstalled() && ExternalCompatibilityManager.Companion.isMythicMob(lmEntity)) {
            entityName = ExternalCompatibilityManager.Companion.getMythicMobInternalName(lmEntity);
        }
        String message = "Spawn distance is " + Utils.INSTANCE.round(distance, 1) + " for: " + entityName + " (lvl " + mobLevel + " " + lmEntity.getNameIfBaby() + ") in " + lmEntity.getWorldName() + ", " + locationStr;
        lmEntity.free();
        sender.sendMessage(message);
    }

    private final LivingEntityWrapper getNearbyMob(CommandSender sender, Player optionalTarget) {
        Player usePlayer;
        LivingEntityWrapper lmEntity;
        if (!(sender instanceof Player) && optionalTarget == null) {
            sender.sendMessage("Must specify a player when running this command from console");
            return null;
        }
        Player player = optionalTarget;
        if (player == null) {
            Intrinsics.checkNotNull(sender, "null cannot be cast to non-null type org.bukkit.entity.Player");
            player = (Player)sender;
        }
        if ((lmEntity = RulesSubcommand.INSTANCE.getMobBeingLookedAt(usePlayer = player, true, sender)) == null) {
            sender.sendMessage("Could not locate any mobs near player: " + usePlayer.getName());
            return null;
        }
        return lmEntity;
    }

    private final void showPlayerLocation(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("The command must be run by a player");
            return;
        }
        Location location = ((Player)sender).getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location l = location;
        String locationStr = "location is " + l.getBlockX() + ", " + l.getBlockY() + ", " + l.getBlockZ() + " in " + l.getWorld().getName();
        sender.sendMessage("Your location: " + locationStr);
    }

    private final CompletableFuture<Suggestions> getDebugTypes(SuggestionsBuilder builder) {
        for (DebugType debugType : DebugType.getEntries()) {
            String string = debugType.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            builder.suggest(string);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    private final CompletableFuture<Suggestions> getOutputToTypes(SuggestionsBuilder builder) {
        for (DebugManager.OutputTypes outputType : DebugManager.OutputTypes.getEntries()) {
            if (LevelledMobs.Companion.getInstance().getDebugManager().getOutputType() == outputType) continue;
            String string = StringsKt.replace$default(outputType.name(), "_", "-", false, 4, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            builder.suggest(string);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    private final CompletableFuture<Suggestions> getUnusedListTypes(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder, ListTypes listType, boolean isAdd) {
        Set result = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        String string = ctx.getInput();
        Intrinsics.checkNotNullExpressionValue(string, "getInput(...)");
        List<String> input = this.splitStringWithQuotes(string, false);
        StringBuilder prefix = new StringBuilder();
        List existingItems = new ArrayList();
        int n = input.size();
        for (int i = 5; i < n; ++i) {
            String string2 = input.get(i).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            existingItems.add(string2);
            if (((CharSequence)prefix).length() > 0) {
                prefix.append(' ');
            }
            prefix.append(input.get(i)).append(' ');
        }
        switch (WhenMappings.$EnumSwitchMapping$2[listType.ordinal()]) {
            case 4: {
                if (isAdd) {
                    for (DebugType debugType : DebugType.getEntries()) {
                        String debugName;
                        Intrinsics.checkNotNullExpressionValue(debugType.toString().toLowerCase(Locale.ROOT), "toLowerCase(...)");
                        if (existingItems.contains(debugName)) continue;
                        result.add(prefix.toString() + debugName);
                    }
                }
                for (DebugType debugType : LevelledMobs.Companion.getInstance().getDebugManager().getFilterDebugTypes()) {
                    boolean bl;
                    if (isAdd) {
                        String string3 = prefix.toString();
                        String string4 = debugType.toString().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                        bl = result.remove(string3 + string4);
                        continue;
                    }
                    String string5 = prefix.toString();
                    String string6 = debugType.toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string6, "toLowerCase(...)");
                    bl = result.add(string5 + string6);
                }
                break;
            }
            case 1: {
                if (isAdd) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        String string7 = player.getName();
                        Intrinsics.checkNotNullExpressionValue(string7, "getName(...)");
                        result.add(string7);
                    }
                }
                for (String playerName : LevelledMobs.Companion.getInstance().getDebugManager().getFilterPlayerNames()) {
                    boolean bl = isAdd ? result.remove(playerName) : result.add(playerName);
                }
                break;
            }
            case 3: {
                if (isAdd) {
                    for (EntityType entityType : EntriesMappings.entries$0) {
                        if (LevelledMobs.Companion.getInstance().getLevelManager().getForcedBlockedEntityTypes().contains(entityType)) continue;
                        String string8 = entityType.toString().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string8, "toLowerCase(...)");
                        result.add(string8);
                    }
                }
                for (EntityType entityType : LevelledMobs.Companion.getInstance().getDebugManager().getFilterEntityTypes()) {
                    boolean bl;
                    if (isAdd) {
                        String string9 = entityType.toString().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string9, "toLowerCase(...)");
                        bl = result.remove(string9);
                        continue;
                    }
                    String string10 = entityType.toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string10, "toLowerCase(...)");
                    bl = result.add(string10);
                }
                break;
            }
            case 2: {
                if (isAdd) {
                    for (RuleInfo ri : LevelledMobs.Companion.getInstance().getRulesParsingManager().getAllRules(false)) {
                        result.add(StringsKt.replace$default(ri.getRuleName$levelledmobs_plugin(), " ", "_", false, 4, null));
                    }
                }
                for (String ruleName : LevelledMobs.Companion.getInstance().getDebugManager().getFilterRuleNames()) {
                    boolean bl = isAdd ? result.remove(ruleName) : result.add(ruleName);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Iterable $this$forEach$iv = result;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String value = (String)element$iv;
            boolean bl = false;
            builder.suggest(value);
        }
        CompletableFuture completableFuture = builder.buildFuture();
        Intrinsics.checkNotNullExpressionValue(completableFuture, "buildFuture(...)");
        return completableFuture;
    }

    private static final int buildCommand$lambda$0(CommandContext ctx) {
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("Please enter a debug option.");
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$1(CommandContext commandContext, SuggestionsBuilder builder) {
        return builder.suggest("confirm").buildFuture();
    }

    private static final int buildCommand$lambda$2(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.createZip((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$3(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.createZip((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$4(CommandContext commandContext, SuggestionsBuilder builder) {
        return builder.suggest("reset").buildFuture();
    }

    private static final int buildCommand$lambda$5(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.chunkKillCount((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$6(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.chunkKillCount((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$7(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.viewQueues(commandSender);
        return 1;
    }

    private static final int buildCommand$lambda$8(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.nbtDump((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$9(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.nbtDump((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$10(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.showPlayerLocation(commandSender);
        return 1;
    }

    private static final int buildCommand$lambda$11(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.showSpawnDistance((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$12(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.showSpawnDistance((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$13(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.showLEWDebug(commandSender);
        return 1;
    }

    private static final int buildCommand$lambda$14(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.clearLEWCache(commandSender);
        return 1;
    }

    private static final int buildCommand$lambda$15(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.showCustomDrops(commandSender);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$16(CommandContext commandContext, SuggestionsBuilder builder) {
        return builder.suggest("console").buildFuture();
    }

    private static final int buildCommand$lambda$17(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.showPDCKeys((CommandContext<CommandSourceStack>)ctx, true);
        return 1;
    }

    private static final int buildCommand$lambda$18(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.showPDCKeys((CommandContext<CommandSourceStack>)ctx, false);
        return 1;
    }

    private static final int buildCommand$lambda$19(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.showPluginDefinitions(commandSender);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$20(CommandContext commandContext, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull(builder);
        return INSTANCE.getDebugTypes(builder);
    }

    private static final int buildCommand$lambda$21(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.enableOrDisableDebug((CommandContext<CommandSourceStack>)ctx, true, false);
        return 1;
    }

    private static final int buildCommand$lambda$22(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.enableOrDisableDebug((CommandContext<CommandSourceStack>)ctx, true, false);
        return 1;
    }

    private static final int buildCommand$lambda$23(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.enableOrDisableDebug((CommandContext<CommandSourceStack>)ctx, true, true);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$24(CommandContext commandContext, SuggestionsBuilder builder) {
        return builder.suggest("enable").suggest("disable").buildFuture();
    }

    private static final int buildCommand$lambda$25(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processDamageDebugOutput((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$26(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.processDamageDebugOutput((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$27(CommandContext commandContext, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull(builder);
        return INSTANCE.getDebugTypes(builder);
    }

    private static final int buildCommand$lambda$28(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseEnableTimer((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$29(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseEnableTimer((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$30(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseEnableTimer((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$31(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.enableOrDisableDebug((CommandContext<CommandSourceStack>)ctx, false, false);
        return 1;
    }

    private static final CompletableFuture buildCommand$lambda$32(CommandContext commandContext, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull(builder);
        return INSTANCE.getOutputToTypes(builder);
    }

    private static final int buildCommand$lambda$33(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseOutputTo((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$34(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseOutputTo((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int buildCommand$lambda$35(CommandContext ctx) {
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage(LevelledMobs.Companion.getInstance().getDebugManager().getDebugStatus());
        return 1;
    }

    private static final int buildCommand$lambda$36(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.viewQueues(commandSender);
        return 1;
    }

    private static final int createFilterResultsCommand$lambda$0(String $genericMessage, CommandContext ctx) {
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage($genericMessage);
        return 1;
    }

    private static final int createFilterResultsCommand$lambda$1(String $genericMessage, CommandContext ctx) {
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage($genericMessage);
        return 1;
    }

    private static final int createFilterResultsCommand$lambda$2(String $genericMessage, CommandContext ctx) {
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage($genericMessage);
        return 1;
    }

    private static final int createFilterResultsCommand$lambda$3(String $genericMessage, CommandContext ctx) {
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage($genericMessage);
        return 1;
    }

    private static final CompletableFuture createFilterResultsCommand$lambda$4(CommandContext commandContext, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull(builder);
        return INSTANCE.getListenForValues(builder);
    }

    private static final int createFilterResultsCommand$lambda$5(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.updateEvaluationType((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int createFilterResultsCommand$lambda$6(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.updateEvaluationType((CommandContext<CommandSourceStack>)ctx);
        return 1;
    }

    private static final int createFilterResultsCommand$lambda$7(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseNumberValue((CommandContext<CommandSourceStack>)ctx, NumberSettings.MAX_PLAYERS_DIST);
        return 1;
    }

    private static final int createFilterResultsCommand$lambda$8(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseNumberValue((CommandContext<CommandSourceStack>)ctx, NumberSettings.MAX_PLAYERS_DIST);
        return 1;
    }

    private static final int createFilterResultsCommand$lambda$9(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.clearFilters(commandSender);
        return 1;
    }

    private static final int createSetHeightCommands$lambda$0(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.showYHeightSettings(commandSender);
        return 1;
    }

    private static final int createSetHeightCommands$lambda$1(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseNumberValue((CommandContext<CommandSourceStack>)ctx, NumberSettings.MIN_Y_LEVEL);
        return 1;
    }

    private static final int createSetHeightCommands$lambda$2(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.showYHeightSettings(commandSender);
        return 1;
    }

    private static final int createSetHeightCommands$lambda$3(CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseNumberValue((CommandContext<CommandSourceStack>)ctx, NumberSettings.MAX_Y_LEVEL);
        return 1;
    }

    private static final int createSetHeightCommands$lambda$4(CommandContext ctx) {
        CommandSender commandSender = ((CommandSourceStack)ctx.getSource()).getSender();
        Intrinsics.checkNotNullExpressionValue(commandSender, "getSender(...)");
        INSTANCE.showYHeightSettings(commandSender);
        return 1;
    }

    private static final int createSetHeightCommands$lambda$5(CommandContext ctx) {
        LevelledMobs.Companion.getInstance().getDebugManager().setMinYLevel(null);
        LevelledMobs.Companion.getInstance().getDebugManager().setMaxYLevel(null);
        ((CommandSourceStack)ctx.getSource()).getSender().sendMessage("All y-height filters cleared");
        return 1;
    }

    private static final int buildGenericListTypes$lambda$0(ListTypes $listType, CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseTypeValues((CommandContext<CommandSourceStack>)ctx, $listType, OperationType.VIEW);
        return 1;
    }

    private static final int buildGenericListTypes$lambda$1(ListTypes $listType, CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseTypeValues((CommandContext<CommandSourceStack>)ctx, $listType, OperationType.ADD);
        return 1;
    }

    private static final CompletableFuture buildGenericListTypes$lambda$2(ListTypes $listType, CommandContext ctx, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull(ctx);
        Intrinsics.checkNotNull(builder);
        return INSTANCE.getUnusedListTypes((CommandContext<CommandSourceStack>)ctx, builder, $listType, true);
    }

    private static final int buildGenericListTypes$lambda$3(ListTypes $listType, CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseTypeValues((CommandContext<CommandSourceStack>)ctx, $listType, OperationType.ADD);
        return 1;
    }

    private static final int buildGenericListTypes$lambda$4(ListTypes $listType, CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseTypeValues((CommandContext<CommandSourceStack>)ctx, $listType, OperationType.REMOVE);
        return 1;
    }

    private static final CompletableFuture buildGenericListTypes$lambda$5(ListTypes $listType, CommandContext ctx, SuggestionsBuilder builder) {
        Intrinsics.checkNotNull(ctx);
        Intrinsics.checkNotNull(builder);
        return INSTANCE.getUnusedListTypes((CommandContext<CommandSourceStack>)ctx, builder, $listType, false);
    }

    private static final int buildGenericListTypes$lambda$6(ListTypes $listType, CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseTypeValues((CommandContext<CommandSourceStack>)ctx, $listType, OperationType.REMOVE);
        return 1;
    }

    private static final int buildGenericListTypes$lambda$7(ListTypes $listType, CommandContext ctx) {
        Intrinsics.checkNotNull(ctx);
        INSTANCE.parseTypeValues((CommandContext<CommandSourceStack>)ctx, $listType, OperationType.CLEAR);
        return 1;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EntityType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EntityType.values()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/DebugSubcommand$ListTypes;", "", "<init>", "(Ljava/lang/String;I)V", "DEBUG", "ENTITY", "RULE_NAMES", "PLAYERS", "levelledmobs-plugin"})
    private static final class ListTypes
    extends Enum<ListTypes> {
        public static final /* enum */ ListTypes DEBUG = new ListTypes();
        public static final /* enum */ ListTypes ENTITY = new ListTypes();
        public static final /* enum */ ListTypes RULE_NAMES = new ListTypes();
        public static final /* enum */ ListTypes PLAYERS = new ListTypes();
        private static final /* synthetic */ ListTypes[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ListTypes[] values() {
            return (ListTypes[])$VALUES.clone();
        }

        public static ListTypes valueOf(String value) {
            return Enum.valueOf(ListTypes.class, value);
        }

        @NotNull
        public static EnumEntries<ListTypes> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = listTypesArray = new ListTypes[]{ListTypes.DEBUG, ListTypes.ENTITY, ListTypes.RULE_NAMES, ListTypes.PLAYERS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/DebugSubcommand$NumberSettings;", "", "<init>", "(Ljava/lang/String;I)V", "MAX_PLAYERS_DIST", "MIN_Y_LEVEL", "MAX_Y_LEVEL", "levelledmobs-plugin"})
    private static final class NumberSettings
    extends Enum<NumberSettings> {
        public static final /* enum */ NumberSettings MAX_PLAYERS_DIST = new NumberSettings();
        public static final /* enum */ NumberSettings MIN_Y_LEVEL = new NumberSettings();
        public static final /* enum */ NumberSettings MAX_Y_LEVEL = new NumberSettings();
        private static final /* synthetic */ NumberSettings[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NumberSettings[] values() {
            return (NumberSettings[])$VALUES.clone();
        }

        public static NumberSettings valueOf(String value) {
            return Enum.valueOf(NumberSettings.class, value);
        }

        @NotNull
        public static EnumEntries<NumberSettings> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = numberSettingsArray = new NumberSettings[]{NumberSettings.MAX_PLAYERS_DIST, NumberSettings.MIN_Y_LEVEL, NumberSettings.MAX_Y_LEVEL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/DebugSubcommand$OperationType;", "", "<init>", "(Ljava/lang/String;I)V", "ADD", "REMOVE", "CLEAR", "VIEW", "levelledmobs-plugin"})
    private static final class OperationType
    extends Enum<OperationType> {
        public static final /* enum */ OperationType ADD = new OperationType();
        public static final /* enum */ OperationType REMOVE = new OperationType();
        public static final /* enum */ OperationType CLEAR = new OperationType();
        public static final /* enum */ OperationType VIEW = new OperationType();
        private static final /* synthetic */ OperationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OperationType[] values() {
            return (OperationType[])$VALUES.clone();
        }

        public static OperationType valueOf(String value) {
            return Enum.valueOf(OperationType.class, value);
        }

        @NotNull
        public static EnumEntries<OperationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = operationTypeArray = new OperationType[]{OperationType.ADD, OperationType.REMOVE, OperationType.CLEAR, OperationType.VIEW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[NumberSettings.values().length];
            try {
                nArray[NumberSettings.MAX_PLAYERS_DIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NumberSettings.MIN_Y_LEVEL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NumberSettings.MAX_Y_LEVEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DebugManager.ListenFor.values().length];
            try {
                nArray[DebugManager.ListenFor.BOTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DebugManager.ListenFor.FAILURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DebugManager.ListenFor.SUCCESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ListTypes.values().length];
            try {
                nArray[ListTypes.PLAYERS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ListTypes.RULE_NAMES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ListTypes.ENTITY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ListTypes.DEBUG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[OperationType.values().length];
            try {
                nArray[OperationType.CLEAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperationType.ADD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperationType.REMOVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

