/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands.subcommands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.arcaneplugins.levelledmobs.commands.MessagesBase;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u000eJ!\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\r\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0011J!\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\r\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0014J!\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\r\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0016J!\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00180\u00102\u0006\u0010\r\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0019J%\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\u0006\u0010\r\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u001eJ#\u0010\u001f\u001a\u00020 2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\u0006\u0010\r\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b!J#\u0010\"\u001a\u00020\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\u0006\u0010\r\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b#J/\u0010\"\u001a\u0004\u0018\u00010\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\u0006\u0010\r\u001a\u00020\u00032\b\u0010$\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\b#J'\u0010%\u001a\u0004\u0018\u00010\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\u0006\u0010\r\u001a\u00020\u0003H\u0000\u00a2\u0006\u0004\b&\u0010'J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030)2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020 J/\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030)2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001d2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030)H\u0000\u00a2\u0006\u0002\b.R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006/"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/CommandBase;", "Lio/github/arcaneplugins/levelledmobs/commands/MessagesBase;", "basePermission", "", "<init>", "(Ljava/lang/String;)V", "getBasePermission", "()Ljava/lang/String;", "description", "getDescription", "createLiteralCommand", "Lcom/mojang/brigadier/builder/LiteralArgumentBuilder;", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "name", "createLiteralCommand$levelledmobs_plugin", "createStringArgument", "Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;", "createStringArgument$levelledmobs_plugin", "createNumberArgument", "", "createNumberArgument$levelledmobs_plugin", "createGreedyStringArgument", "createGreedyStringArgument$levelledmobs_plugin", "createPlayerArgument", "Lio/papermc/paper/command/brigadier/argument/resolvers/selector/PlayerSelectorArgumentResolver;", "createPlayerArgument$levelledmobs_plugin", "getPlayerArgument", "Lorg/bukkit/entity/Player;", "ctx", "Lcom/mojang/brigadier/context/CommandContext;", "getPlayerArgument$levelledmobs_plugin", "getStringArgumentAsBool", "", "getStringArgumentAsBool$levelledmobs_plugin", "getStringArgument", "getStringArgument$levelledmobs_plugin", "defaultValue", "getIntegerArgument", "getIntegerArgument$levelledmobs_plugin", "(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)Ljava/lang/Integer;", "splitStringWithQuotes", "", "myString", "preserveQuotes", "getOptionalResults", "names", "getOptionalResults$levelledmobs_plugin", "levelledmobs-plugin"})
public abstract class CommandBase
extends MessagesBase {
    @NotNull
    private final String basePermission;

    public CommandBase(@NotNull String basePermission) {
        Intrinsics.checkNotNullParameter(basePermission, "basePermission");
        this.basePermission = basePermission;
    }

    @NotNull
    public final String getBasePermission() {
        return this.basePermission;
    }

    @NotNull
    public abstract String getDescription();

    @NotNull
    public final LiteralArgumentBuilder<CommandSourceStack> createLiteralCommand$levelledmobs_plugin(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        ArgumentBuilder argumentBuilder = Commands.literal((String)name).requires(arg_0 -> CommandBase.createLiteralCommand$lambda$0(this, name, arg_0));
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "requires(...)");
        return (LiteralArgumentBuilder)argumentBuilder;
    }

    @NotNull
    public final RequiredArgumentBuilder<CommandSourceStack, String> createStringArgument$levelledmobs_plugin(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        ArgumentBuilder argumentBuilder = Commands.argument((String)name, (ArgumentType)((ArgumentType)StringArgumentType.word())).requires(arg_0 -> CommandBase.createStringArgument$lambda$0(this, name, arg_0));
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "requires(...)");
        return (RequiredArgumentBuilder)argumentBuilder;
    }

    @NotNull
    public final RequiredArgumentBuilder<CommandSourceStack, Integer> createNumberArgument$levelledmobs_plugin(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        ArgumentBuilder argumentBuilder = Commands.argument((String)name, (ArgumentType)((ArgumentType)IntegerArgumentType.integer())).requires(arg_0 -> CommandBase.createNumberArgument$lambda$0(this, name, arg_0));
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "requires(...)");
        return (RequiredArgumentBuilder)argumentBuilder;
    }

    @NotNull
    public final RequiredArgumentBuilder<CommandSourceStack, String> createGreedyStringArgument$levelledmobs_plugin(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        ArgumentBuilder argumentBuilder = Commands.argument((String)name, (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).requires(arg_0 -> CommandBase.createGreedyStringArgument$lambda$0(this, name, arg_0));
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "requires(...)");
        return (RequiredArgumentBuilder)argumentBuilder;
    }

    @NotNull
    public final RequiredArgumentBuilder<CommandSourceStack, PlayerSelectorArgumentResolver> createPlayerArgument$levelledmobs_plugin(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        ArgumentBuilder argumentBuilder = Commands.argument((String)name, (ArgumentType)ArgumentTypes.player()).requires(arg_0 -> CommandBase.createPlayerArgument$lambda$0(this, name, arg_0));
        Intrinsics.checkNotNullExpressionValue(argumentBuilder, "requires(...)");
        return (RequiredArgumentBuilder)argumentBuilder;
    }

    @Nullable
    public final Player getPlayerArgument$levelledmobs_plugin(@NotNull CommandContext<CommandSourceStack> ctx, @NotNull String name) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(name, "name");
        try {
            PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)ctx.getArgument(name, PlayerSelectorArgumentResolver.class);
            Object object = targetResolver.resolve((CommandSourceStack)ctx.getSource());
            Intrinsics.checkNotNullExpressionValue(object, "resolve(...)");
            return (Player)CollectionsKt.first((List)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public final boolean getStringArgumentAsBool$levelledmobs_plugin(@NotNull CommandContext<CommandSourceStack> ctx, @NotNull String name) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(name, "name");
        String result = this.getStringArgument$levelledmobs_plugin(ctx, name);
        return StringsKt.equals(name, result, true);
    }

    @NotNull
    public final String getStringArgument$levelledmobs_plugin(@NotNull CommandContext<CommandSourceStack> ctx, @NotNull String name) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(name, "name");
        String result = this.getStringArgument$levelledmobs_plugin(ctx, name, null);
        String string = result;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public final String getStringArgument$levelledmobs_plugin(@NotNull CommandContext<CommandSourceStack> ctx, @NotNull String name, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(name, "name");
        try {
            return (String)ctx.getArgument(name, String.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultValue;
        }
    }

    @Nullable
    public final Integer getIntegerArgument$levelledmobs_plugin(@NotNull CommandContext<CommandSourceStack> ctx, @NotNull String name) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(name, "name");
        try {
            return (Integer)ctx.getArgument(name, Integer.TYPE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @NotNull
    public final List<String> splitStringWithQuotes(@NotNull String myString, boolean preserveQuotes) {
        Intrinsics.checkNotNullParameter(myString, "myString");
        List results = new ArrayList();
        Pattern pattern = Pattern.compile("[^\\s\"]+|\"([^\"]*)\"");
        Matcher match = pattern.matcher(myString);
        while (match.find()) {
            String string;
            String temp = match.group(0);
            if (!preserveQuotes) {
                string = temp;
                Intrinsics.checkNotNull(string);
                if (StringsKt.startsWith$default(string, "\"", false, 2, null)) {
                    string = temp;
                    Intrinsics.checkNotNull(string);
                    if (StringsKt.endsWith$default(string, "\"", false, 2, null)) {
                        string = temp;
                        Intrinsics.checkNotNull(string);
                        int n = 1;
                        int n2 = temp.length() - 1;
                        String string2 = string.substring(n, n2);
                        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                        temp = string2;
                    }
                }
            }
            string = temp;
            Intrinsics.checkNotNull(string);
            results.add(string);
        }
        return results;
    }

    @NotNull
    public final List<String> getOptionalResults$levelledmobs_plugin(@NotNull CommandContext<CommandSourceStack> ctx, @NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Intrinsics.checkNotNullParameter(names, "names");
        List results = new ArrayList();
        int n = names.size();
        for (int i = 0; i < n; ++i) {
            String temp = this.getStringArgument$levelledmobs_plugin(ctx, names.get(i));
            if (!(((CharSequence)temp).length() > 0)) continue;
            results.add(temp);
        }
        return results;
    }

    private static final boolean createLiteralCommand$lambda$0(CommandBase this$0, String $name, CommandSourceStack cmdSender) {
        return cmdSender.getSender().hasPermission(this$0.basePermission + "." + $name);
    }

    private static final boolean createStringArgument$lambda$0(CommandBase this$0, String $name, CommandSourceStack cmdSender) {
        return cmdSender.getSender().hasPermission(this$0.basePermission + "." + $name);
    }

    private static final boolean createNumberArgument$lambda$0(CommandBase this$0, String $name, CommandSourceStack cmdSender) {
        return cmdSender.getSender().hasPermission(this$0.basePermission + "." + $name);
    }

    private static final boolean createGreedyStringArgument$lambda$0(CommandBase this$0, String $name, CommandSourceStack cmdSender) {
        return cmdSender.getSender().hasPermission(this$0.basePermission + "." + $name);
    }

    private static final boolean createPlayerArgument$lambda$0(CommandBase this$0, String $name, CommandSourceStack cmdSender) {
        return cmdSender.getSender().hasPermission(this$0.basePermission + "." + $name);
    }
}

