/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.compatibility.Compat119;
import io.github.arcaneplugins.levelledmobs.compatibility.Compat120;
import io.github.arcaneplugins.levelledmobs.compatibility.Compat121;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.libs.bstats.bukkit.Metrics;
import io.github.arcaneplugins.levelledmobs.libs.bstats.charts.SimpleBarChart;
import io.github.arcaneplugins.levelledmobs.libs.bstats.charts.SimplePie;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Metadata;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.Unit;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.collections.CollectionsKt;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.JvmStatic;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.functions.Function0;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.functions.Function1;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.Intrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.PropertyReference0Impl;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.SourceDebugExtension;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.jvm.internal.TypeIntrinsics;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.reflect.KProperty0;
import io.github.arcaneplugins.levelledmobs.libs.kotlin.text.StringsKt;
import io.github.arcaneplugins.levelledmobs.listeners.CombustListener;
import io.github.arcaneplugins.levelledmobs.listeners.EntityDamageDebugListener;
import io.github.arcaneplugins.levelledmobs.listeners.EntityDamageListener;
import io.github.arcaneplugins.levelledmobs.listeners.EntityNametagListener;
import io.github.arcaneplugins.levelledmobs.listeners.EntityPickupItemListener;
import io.github.arcaneplugins.levelledmobs.listeners.EntityRegainHealthListener;
import io.github.arcaneplugins.levelledmobs.listeners.EntitySpawnListener;
import io.github.arcaneplugins.levelledmobs.listeners.EntityTameListener;
import io.github.arcaneplugins.levelledmobs.listeners.EntityTargetListener;
import io.github.arcaneplugins.levelledmobs.listeners.PlayerJoinListener;
import io.github.arcaneplugins.levelledmobs.listeners.PlayerPortalEventListener;
import io.github.arcaneplugins.levelledmobs.listeners.ServerLoadEvent;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.managers.PlaceholderApiIntegration;
import io.github.arcaneplugins.levelledmobs.misc.FileLoader;
import io.github.arcaneplugins.levelledmobs.misc.KillSkipConditions;
import io.github.arcaneplugins.levelledmobs.misc.OutdatedServerVersionException;
import io.github.arcaneplugins.levelledmobs.misc.VersionInfo;
import io.github.arcaneplugins.levelledmobs.misc.YmlParsingHelper;
import io.github.arcaneplugins.levelledmobs.nametag.ServerVersionInfo;
import io.github.arcaneplugins.levelledmobs.result.ChunkKillInfo;
import io.github.arcaneplugins.levelledmobs.rules.MetricsInfo;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.UpdateChecker;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerResult;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.io.File;
import java.io.InvalidObjectException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0013\u0018\u0000 z2\u00020\u0001:\u0001zB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010R\u001a\u00020SJ\b\u0010T\u001a\u00020UH\u0002J\u0006\u0010V\u001a\u00020\u001fJ\b\u0010W\u001a\u00020SH\u0002J\u0010\u0010X\u001a\u00020S2\b\b\u0002\u0010Y\u001a\u00020\u001fJ\u0006\u0010Z\u001a\u00020SJ\u0006\u0010[\u001a\u00020SJ\u0016\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020\u00132\u0006\u0010_\u001a\u00020]J\u0006\u0010`\u001a\u00020SJ\u0006\u0010a\u001a\u00020SJ\b\u0010b\u001a\u00020SH\u0002J\b\u0010c\u001a\u00020SH\u0002J\u001a\u0010d\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u000206042\u0006\u0010e\u001a\u000205J&\u0010f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002060h0g2\f\u0010i\u001a\b\u0012\u0004\u0012\u0002050gJ\u001c\u0010j\u001a\u00020\u001f2\f\u0010i\u001a\b\u0012\u0004\u0012\u0002050g2\u0006\u0010k\u001a\u000208J\u001c\u0010l\u001a\u00020S2\f\u0010i\u001a\b\u0012\u0004\u0012\u0002050\u00122\u0006\u0010k\u001a\u000208J\u0006\u0010m\u001a\u00020SJ\u0006\u0010n\u001a\u00020SJ\u0006\u0010o\u001a\u00020SJ\b\u0010p\u001a\u00020SH\u0002J\u0010\u0010q\u001a\u00020S2\b\u0010r\u001a\u0004\u0018\u00010\u0006J\u0012\u0010s\u001a\u0004\u0018\u00010\u00072\b\u0010r\u001a\u0004\u0018\u00010\u0006J\u0010\u0010t\u001a\u00020S2\b\u0010r\u001a\u0004\u0018\u00010\u0006J\u0010\u0010u\u001a\u0004\u0018\u00010:2\u0006\u0010r\u001a\u00020\u0006J\u0018\u0010v\u001a\u00020S2\u0006\u0010r\u001a\u00020\u00062\b\u0010w\u001a\u0004\u0018\u00010:J\u0010\u0010x\u001a\u0004\u0018\u00010:2\u0006\u0010r\u001a\u00020\u0006J\u0018\u0010y\u001a\u00020S2\u0006\u0010r\u001a\u00020\u00062\b\u0010w\u001a\u0004\u0018\u00010:R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\"\"\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\"\"\u0004\b/\u0010&R\u001a\u00100\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\"\"\u0004\b2\u0010&R&\u00103\u001a\u001a\u0012\u0004\u0012\u000205\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002060404X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u00107\u001a\u001a\u0012\u0004\u0012\u000205\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020\u00070404X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020:04X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020:04X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010<\u001a\b\u0012\u0004\u0012\u0002080\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u0015R\u0017\u0010>\u001a\b\u0012\u0004\u0012\u0002080\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\u0015R\u001a\u0010@\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\"\"\u0004\bB\u0010&R\u0013\u0010C\u001a\u00070D\u00a2\u0006\u0002\bEX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010H\u001a\u00020I\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u0010\u0010L\u001a\u0004\u0018\u00010MX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006{"}, d2={"Lio/github/arcaneplugins/levelledmobs/MainCompanion;", "", "<init>", "()V", "recentlyJoinedPlayers", "Ljava/util/WeakHashMap;", "Lorg/bukkit/entity/Player;", "Ljava/time/Instant;", "hostileMobsGroup", "", "Lorg/bukkit/entity/EntityType;", "getHostileMobsGroup", "()Ljava/util/Set;", "aquaticMobsGroup", "getAquaticMobsGroup", "passiveMobsGroup", "getPassiveMobsGroup", "updateResult", "", "", "getUpdateResult", "()Ljava/util/List;", "setUpdateResult", "(Ljava/util/List;)V", "killSkipConditions", "Lio/github/arcaneplugins/levelledmobs/misc/KillSkipConditions;", "getKillSkipConditions", "()Lio/github/arcaneplugins/levelledmobs/misc/KillSkipConditions;", "setKillSkipConditions", "(Lio/github/arcaneplugins/levelledmobs/misc/KillSkipConditions;)V", "value", "", "hadRulesLoadError", "getHadRulesLoadError", "()Z", "useAdventure", "getUseAdventure", "setUseAdventure", "(Z)V", "reloadSender", "Lorg/bukkit/command/CommandSender;", "getReloadSender", "()Lorg/bukkit/command/CommandSender;", "setReloadSender", "(Lorg/bukkit/command/CommandSender;)V", "hasFinishedLoading", "getHasFinishedLoading", "setHasFinishedLoading", "showCustomDrops", "getShowCustomDrops", "setShowCustomDrops", "entityDeathInChunkCounter", "", "", "Lio/github/arcaneplugins/levelledmobs/result/ChunkKillInfo;", "chunkKillNoticationTracker", "Ljava/util/UUID;", "playerNetherPortals", "Lorg/bukkit/Location;", "playerWorldPortals", "spawnerCopyIds", "getSpawnerCopyIds", "spawnerInfoIds", "getSpawnerInfoIds", "excludePlayersInCreative", "getExcludePlayersInCreative", "setExcludePlayersInCreative", "pluginManager", "Lorg/bukkit/plugin/PluginManager;", "Lio/github/arcaneplugins/levelledmobs/libs/jetbrains/annotations/NotNull;", "metricsInfo", "Lio/github/arcaneplugins/levelledmobs/rules/MetricsInfo;", "externalCompatibilityManager", "Lio/github/arcaneplugins/levelledmobs/managers/ExternalCompatibilityManager;", "getExternalCompatibilityManager", "()Lio/github/arcaneplugins/levelledmobs/managers/ExternalCompatibilityManager;", "hashMapCleanUp", "Lio/github/arcaneplugins/levelledmobs/wrappers/SchedulerResult;", "playerLogonTimesLock", "playerNetherPortalsLock", "entityDeathInChunkCounterLock", "entityDeathInChunkNotifierLock", "load", "", "getSettingsVersion", "", "loadFiles", "parseDebugsEnabled", "checkSettingsWithMaxPlayerOptions", "playerJustLeft", "registerListeners", "checkListenersWithVariablePriorities", "getEventPriority", "Lorg/bukkit/event/EventPriority;", "name", "defaultPriority", "setupMetrics", "startCleanupTask", "chunkKillLimitCleanup", "chunkKillNoticationCleanup", "getorAddPairForSpecifiedChunk", "chunkKey", "getorAddPairForSpecifiedChunks", "", "", "chunkKeys", "doesUserHaveCooldown", "userId", "addUserCooldown", "clearChunkKillCache", "checkUpdates", "shutDownAsyncTasks", "buildUniversalGroups", "addRecentlyJoinedPlayer", "player", "getRecentlyJoinedPlayerLogonTime", "removeRecentlyJoinedPlayer", "getPlayerNetherPortalLocation", "setPlayerNetherPortalLocation", "location", "getPlayerWorldPortalLocation", "setPlayerWorldPortalLocation", "Companion", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nMainCompanion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainCompanion.kt\nio/github/arcaneplugins/levelledmobs/MainCompanion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,654:1\n1915#2,2:655\n*S KotlinDebug\n*F\n+ 1 MainCompanion.kt\nio/github/arcaneplugins/levelledmobs/MainCompanion\n*L\n525#1:655,2\n*E\n"})
public final class MainCompanion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WeakHashMap<Player, Instant> recentlyJoinedPlayers = new WeakHashMap();
    @NotNull
    private final Set<EntityType> hostileMobsGroup = new LinkedHashSet();
    @NotNull
    private final Set<EntityType> aquaticMobsGroup = new LinkedHashSet();
    @NotNull
    private final Set<EntityType> passiveMobsGroup = new LinkedHashSet();
    @NotNull
    private List<String> updateResult = new ArrayList();
    @NotNull
    private KillSkipConditions killSkipConditions = new KillSkipConditions();
    private boolean hadRulesLoadError;
    private boolean useAdventure;
    @Nullable
    private CommandSender reloadSender;
    private boolean hasFinishedLoading;
    private boolean showCustomDrops;
    @NotNull
    private final Map<Long, Map<EntityType, ChunkKillInfo>> entityDeathInChunkCounter = new LinkedHashMap();
    @NotNull
    private final Map<Long, Map<UUID, Instant>> chunkKillNoticationTracker = new LinkedHashMap();
    @NotNull
    private final Map<Player, Location> playerNetherPortals = new LinkedHashMap();
    @NotNull
    private final Map<Player, Location> playerWorldPortals = new LinkedHashMap();
    @NotNull
    private final List<UUID> spawnerCopyIds = new ArrayList();
    @NotNull
    private final List<UUID> spawnerInfoIds = new ArrayList();
    private boolean excludePlayersInCreative;
    @NotNull
    private final PluginManager pluginManager;
    @NotNull
    private final MetricsInfo metricsInfo;
    @NotNull
    private final ExternalCompatibilityManager externalCompatibilityManager;
    @Nullable
    private SchedulerResult hashMapCleanUp;
    @NotNull
    private final Object playerLogonTimesLock;
    @NotNull
    private final Object playerNetherPortalsLock;
    @NotNull
    private final Object entityDeathInChunkCounterLock;
    @NotNull
    private final Object entityDeathInChunkNotifierLock;
    private static MainCompanion instance;

    public MainCompanion() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        Intrinsics.checkNotNullExpressionValue(pluginManager, "getPluginManager(...)");
        this.pluginManager = pluginManager;
        this.metricsInfo = new MetricsInfo();
        this.externalCompatibilityManager = new ExternalCompatibilityManager();
        this.playerLogonTimesLock = new Object();
        this.playerNetherPortalsLock = new Object();
        this.entityDeathInChunkCounterLock = new Object();
        this.entityDeathInChunkNotifierLock = new Object();
        instance = this;
    }

    @NotNull
    public final Set<EntityType> getHostileMobsGroup() {
        return this.hostileMobsGroup;
    }

    @NotNull
    public final Set<EntityType> getAquaticMobsGroup() {
        return this.aquaticMobsGroup;
    }

    @NotNull
    public final Set<EntityType> getPassiveMobsGroup() {
        return this.passiveMobsGroup;
    }

    @NotNull
    public final List<String> getUpdateResult() {
        return this.updateResult;
    }

    public final void setUpdateResult(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.updateResult = list;
    }

    @NotNull
    public final KillSkipConditions getKillSkipConditions() {
        return this.killSkipConditions;
    }

    public final void setKillSkipConditions(@NotNull KillSkipConditions killSkipConditions) {
        Intrinsics.checkNotNullParameter(killSkipConditions, "<set-?>");
        this.killSkipConditions = killSkipConditions;
    }

    public final boolean getHadRulesLoadError() {
        return this.hadRulesLoadError;
    }

    public final boolean getUseAdventure() {
        return this.useAdventure;
    }

    public final void setUseAdventure(boolean bl) {
        this.useAdventure = bl;
    }

    @Nullable
    public final CommandSender getReloadSender() {
        return this.reloadSender;
    }

    public final void setReloadSender(@Nullable CommandSender commandSender) {
        this.reloadSender = commandSender;
    }

    public final boolean getHasFinishedLoading() {
        return this.hasFinishedLoading;
    }

    public final void setHasFinishedLoading(boolean bl) {
        this.hasFinishedLoading = bl;
    }

    public final boolean getShowCustomDrops() {
        return this.showCustomDrops;
    }

    public final void setShowCustomDrops(boolean bl) {
        this.showCustomDrops = bl;
    }

    @NotNull
    public final List<UUID> getSpawnerCopyIds() {
        return this.spawnerCopyIds;
    }

    @NotNull
    public final List<UUID> getSpawnerInfoIds() {
        return this.spawnerInfoIds;
    }

    public final boolean getExcludePlayersInCreative() {
        return this.excludePlayersInCreative;
    }

    public final void setExcludePlayersInCreative(boolean bl) {
        this.excludePlayersInCreative = bl;
    }

    @NotNull
    public final ExternalCompatibilityManager getExternalCompatibilityManager() {
        return this.externalCompatibilityManager;
    }

    public final void load() {
        this.buildUniversalGroups();
    }

    private final int getSettingsVersion() {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        File file = new File(main.getDataFolder(), "settings.yml");
        if (!file.exists()) {
            return 0;
        }
        YmlParsingHelper ymlParsingHelper = main.getHelperSettings();
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        ymlParsingHelper.setCs((ConfigurationSection)yamlConfiguration);
        return main.getHelperSettings().getInt("file-version");
    }

    public final boolean loadFiles() {
        Log.INSTANCE.inf("&fFile Loader: &7Loading files...");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        YamlConfiguration configLoad = FileLoader.INSTANCE.loadFile((Plugin)main, "settings", 39);
        if (configLoad == null) {
            return false;
        }
        main.getHelperSettings().setCs((ConfigurationSection)configLoad);
        YamlConfiguration yamlConfiguration = FileLoader.INSTANCE.loadFile((Plugin)main, "messages", 9);
        Intrinsics.checkNotNull(yamlConfiguration);
        main.setMessagesCfg$levelledmobs_plugin(yamlConfiguration);
        ExternalCompatibilityManager.Companion.getInstance().parseMobPluginDetection(FileLoader.INSTANCE.loadFile((Plugin)main, "externalplugins", 1));
        YamlConfiguration rulesFile = FileLoader.INSTANCE.loadFile((Plugin)main, "rules", 5);
        this.hadRulesLoadError = rulesFile == null;
        main.getRulesParsingManager().parseRulesMain(rulesFile);
        main.getCustomDropsHandler().load();
        this.parseDebugsEnabled();
        main.getCustomDropsHandler().getCustomDropsParser().loadDrops(FileLoader.INSTANCE.loadFile((Plugin)main, "customdrops", 12));
        main.getMobsQueueManager().setIgnoreMobsWithNoPlayerContext(main.getHelperSettings().getBoolean("ignore-mobs-with-no-player-context", false));
        main.getConfigUtils().load();
        Long l = main.getHelperSettings().getIntTimeUnitMS("player-levelling-relevel-min-time", 5000L);
        Intrinsics.checkNotNull(l);
        main.setPlayerLevellingMinRelevelTime$levelledmobs_plugin(l);
        this.useAdventure = main.getHelperSettings().getBoolean("use-adventure", true);
        this.excludePlayersInCreative = main.getHelperSettings().getBoolean("exclude-players-in-creative");
        this.killSkipConditions = KillSkipConditions.Companion.parseConditions(main.getHelperSettings());
        return true;
    }

    private final void parseDebugsEnabled() {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        List list = main.getHelperSettings().getCs().getStringList("debug-misc");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List debugsEnabled = list;
        if (debugsEnabled.isEmpty()) {
            return;
        }
        boolean useAllDebugs = false;
        boolean addedDebugs = false;
        for (String debug : debugsEnabled) {
            CharSequence charSequence = debug;
            if (charSequence == null || charSequence.length() == 0) continue;
            if (StringsKt.equals("*", debug, true)) {
                useAllDebugs = true;
                continue;
            }
            try {
                String string = debug.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                DebugType debugType = DebugType.valueOf(string);
                main.getDebugManager().getFilterDebugTypes().add(debugType);
                addedDebugs = true;
            }
            catch (Exception exception) {
                Log.INSTANCE.war("Invalid value for debug-misc: " + debug);
            }
        }
        if (useAllDebugs) {
            main.getDebugManager().getFilterDebugTypes().clear();
        }
        if (addedDebugs && !main.getDebugManager().isEnabled()) {
            CommandSender useSender = this.reloadSender != null ? this.reloadSender : (CommandSender)Bukkit.getConsoleSender();
            DebugManager debugManager = main.getDebugManager();
            CommandSender commandSender = useSender;
            Intrinsics.checkNotNull(commandSender);
            debugManager.enableDebug(commandSender, false, false);
            useSender.sendMessage(main.getDebugManager().getDebugStatus());
        }
        this.showCustomDrops = main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS);
    }

    public final void checkSettingsWithMaxPlayerOptions(boolean playerJustLeft) {
        int levelMobsUponSpawnMaxPlayers = LevelledMobs.Companion.getInstance().getHelperSettings().getInt("level-mobs-upon-spawn-max-players", 10);
        int updateMobsUponNonplayerDamageMaxPlayers = LevelledMobs.Companion.getInstance().getHelperSettings().getInt("update-mobs-upon-nonplayer-damage-max-players", 5);
        int currentPlayerCount = Bukkit.getOnlinePlayers().size();
        if (playerJustLeft) {
            --currentPlayerCount;
        }
        EntitySpawnListener.Companion.getInstance().setProcessMobSpawns(currentPlayerCount <= levelMobsUponSpawnMaxPlayers);
        EntityDamageListener.Companion.getInstance().setUpdateMobsOnNonPlayerdamage(currentPlayerCount <= updateMobsUponNonplayerDamageMaxPlayers);
    }

    public static /* synthetic */ void checkSettingsWithMaxPlayerOptions$default(MainCompanion mainCompanion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        mainCompanion.checkSettingsWithMaxPlayerOptions(bl);
    }

    public final void registerListeners() {
        Log.INSTANCE.inf("&fListeners: &7Registering event listeners...");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        main.getLevelManager().load();
        main.getMobsQueueManager().start();
        main.getNametagQueueManager().start();
        main.setEntityDamageDebugListener(new EntityDamageDebugListener());
        main.getLevelManager().getEntitySpawnListener().load();
        main.getEntityDamageListener().load();
        main.getEntityDeathListener().load();
        this.pluginManager.registerEvents((Listener)new EntityRegainHealthListener(), (Plugin)main);
        main.getEntityTransformListener().load();
        this.pluginManager.registerEvents((Listener)new EntityNametagListener(), (Plugin)main);
        this.pluginManager.registerEvents((Listener)new EntityTargetListener(), (Plugin)main);
        this.pluginManager.registerEvents((Listener)new PlayerJoinListener(), (Plugin)main);
        this.pluginManager.registerEvents((Listener)new EntityTameListener(), (Plugin)main);
        main.getPlayerDeathListener().load();
        this.pluginManager.registerEvents((Listener)new CombustListener(), (Plugin)main);
        this.pluginManager.registerEvents((Listener)main.getBlockPlaceListener(), (Plugin)main);
        this.pluginManager.registerEvents((Listener)new PlayerPortalEventListener(), (Plugin)main);
        this.pluginManager.registerEvents((Listener)new EntityPickupItemListener(), (Plugin)main);
        this.pluginManager.registerEvents((Listener)new ServerLoadEvent(), (Plugin)main);
        this.pluginManager.registerEvents((Listener)main.getPlayerInteractEventListener(), (Plugin)main);
        this.pluginManager.registerEvents((Listener)main.getChunkLoadListener(), (Plugin)main);
        main.getChunkLoadListener().load();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            main.setPlaceholderApiIntegration$levelledmobs_plugin(new PlaceholderApiIntegration());
            PlaceholderApiIntegration placeholderApiIntegration = main.getPlaceholderApiIntegration();
            Intrinsics.checkNotNull((Object)placeholderApiIntegration);
            placeholderApiIntegration.register();
        }
    }

    public final void checkListenersWithVariablePriorities() {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        main.getLevelManager().getEntitySpawnListener().load();
        main.getEntityDeathListener().load();
        main.getPlayerDeathListener().load();
        EntityDamageListener.Companion.getInstance().load();
    }

    @NotNull
    public final EventPriority getEventPriority(@NotNull String name, @NotNull EventPriority defaultPriority) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(defaultPriority, "defaultPriority");
        String priorityName = LevelledMobs.Companion.getInstance().getHelperSettings().getString("event-priorities." + name);
        CharSequence charSequence = priorityName;
        if (charSequence == null || charSequence.length() == 0) {
            return defaultPriority;
        }
        String string = priorityName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return switch (string) {
            case "highest" -> EventPriority.HIGHEST;
            case "high" -> EventPriority.HIGH;
            case "normal" -> EventPriority.NORMAL;
            case "low" -> EventPriority.LOW;
            case "lowest" -> EventPriority.LOWEST;
            case "monitor" -> EventPriority.MONITOR;
            default -> {
                Log.INSTANCE.war("Invalid event priority for " + name + ": " + priorityName);
                yield defaultPriority;
            }
        };
    }

    public final void setupMetrics() {
        Metrics metrics = new Metrics((Plugin)LevelledMobs.Companion.getInstance(), 6269);
        metrics.addCustomChart(new SimplePie("maxlevel_used", () -> MainCompanion.setupMetrics$lambda$0(this)));
        metrics.addCustomChart(new SimplePie("custom_rules_used", () -> MainCompanion.setupMetrics$lambda$1(this)));
        metrics.addCustomChart(new SimplePie("custom_drops_enabled", () -> MainCompanion.setupMetrics$lambda$2(new PropertyReference0Impl(this.metricsInfo){

            public Object get() {
                return ((MetricsInfo)this.receiver).getGetUsesCustomDrops();
            }
        })));
        metrics.addCustomChart(new SimplePie("health_indicator_enabled", () -> MainCompanion.setupMetrics$lambda$3(this)));
        metrics.addCustomChart(new SimplePie("levelling_strategy", () -> MainCompanion.setupMetrics$lambda$4(this)));
        metrics.addCustomChart(new SimplePie("autoupdate_checker_enabled", () -> MainCompanion.setupMetrics$lambda$5(this)));
        metrics.addCustomChart(new SimplePie("level_mobs_upon_spawn", () -> MainCompanion.setupMetrics$lambda$6(this)));
        metrics.addCustomChart(new SimplePie("check_mobs_on_chunk_load", () -> MainCompanion.setupMetrics$lambda$7(this)));
        metrics.addCustomChart(new SimplePie("custom-entity-names", () -> MainCompanion.setupMetrics$lambda$8(this)));
        metrics.addCustomChart(new SimplePie("utilizes-nbtdata", () -> MainCompanion.setupMetrics$lambda$9(this)));
        metrics.addCustomChart(new SimplePie("utilizes_player_levelling", () -> MainCompanion.setupMetrics$lambda$10(this)));
        metrics.addCustomChart(new SimplePie("nametag_visibility", () -> MainCompanion.setupMetrics$lambda$11(this)));
        metrics.addCustomChart(new SimpleBarChart("enabled-compatibility", () -> MainCompanion.setupMetrics$lambda$12(this)));
    }

    public final void startCleanupTask() {
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> MainCompanion.startCleanupTask$lambda$0(this));
        this.hashMapCleanUp = scheduler.runTaskTimerAsynchronously(5000L, 2000L);
    }

    private final void chunkKillLimitCleanup() {
        long chunkKey;
        List chunkKeysToRemove = new ArrayList();
        Iterator<Long> iterator2 = this.entityDeathInChunkCounter.keySet().iterator();
        while (iterator2.hasNext()) {
            Map<EntityType, ChunkKillInfo> pairList;
            chunkKey = ((Number)iterator2.next()).longValue();
            if (this.entityDeathInChunkCounter.get(chunkKey) == null) continue;
            Instant now = Instant.now();
            for (EntityType entityType : pairList.keySet()) {
                ChunkKillInfo chunkKillInfo;
                ChunkKillInfo chunkKillInfo2 = chunkKillInfo = pairList.get(entityType);
                Intrinsics.checkNotNull(chunkKillInfo2);
                Set<Map.Entry<Instant, Integer>> set = chunkKillInfo2.getEntrySet();
                Intrinsics.checkNotNull(set, "null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.collections.Map.Entry<java.time.Instant, kotlin.Int>>");
                TypeIntrinsics.asMutableSet(set).removeIf(arg_0 -> MainCompanion.chunkKillLimitCleanup$lambda$1(arg_0 -> MainCompanion.chunkKillLimitCleanup$lambda$0(now, arg_0), arg_0));
            }
            pairList.entrySet().removeIf(arg_0 -> MainCompanion.chunkKillLimitCleanup$lambda$3(MainCompanion::chunkKillLimitCleanup$lambda$2, arg_0));
            if (!pairList.isEmpty()) continue;
            chunkKeysToRemove.add(chunkKey);
        }
        iterator2 = chunkKeysToRemove.iterator();
        while (iterator2.hasNext()) {
            chunkKey = ((Number)iterator2.next()).longValue();
            this.entityDeathInChunkCounter.remove(chunkKey);
        }
    }

    private final void chunkKillNoticationCleanup() {
        Iterator<Long> iterator2 = this.chunkKillNoticationTracker.keySet().iterator();
        while (iterator2.hasNext()) {
            Map<UUID, Instant> playerTimestamps;
            long chunkKey = ((Number)iterator2.next()).longValue();
            Intrinsics.checkNotNull(this.chunkKillNoticationTracker.get(chunkKey));
            playerTimestamps.entrySet().removeIf(arg_0 -> MainCompanion.chunkKillNoticationCleanup$lambda$1(MainCompanion::chunkKillNoticationCleanup$lambda$0, arg_0));
            if (!playerTimestamps.isEmpty()) continue;
            iterator2.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<EntityType, ChunkKillInfo> getorAddPairForSpecifiedChunk(long chunkKey) {
        Object object = this.entityDeathInChunkCounterLock;
        synchronized (object) {
            boolean bl = false;
            Map map = this.entityDeathInChunkCounter.computeIfAbsent(chunkKey, arg_0 -> MainCompanion.getorAddPairForSpecifiedChunk$lambda$0$1(MainCompanion::getorAddPairForSpecifiedChunk$lambda$0$0, arg_0));
            Intrinsics.checkNotNullExpressionValue(map, "computeIfAbsent(...)");
            Map map2 = map;
            return map2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Map<EntityType, ChunkKillInfo>> getorAddPairForSpecifiedChunks(@NotNull List<Long> chunkKeys) {
        Intrinsics.checkNotNullParameter(chunkKeys, "chunkKeys");
        List results = new ArrayList();
        Object object = this.entityDeathInChunkCounterLock;
        synchronized (object) {
            boolean bl = false;
            Iterator<Long> iterator2 = chunkKeys.iterator();
            while (iterator2.hasNext()) {
                long chunkKey = ((Number)iterator2.next()).longValue();
                Map map = this.entityDeathInChunkCounter.computeIfAbsent(chunkKey, arg_0 -> MainCompanion.getorAddPairForSpecifiedChunks$lambda$0$1(MainCompanion::getorAddPairForSpecifiedChunks$lambda$0$0, arg_0));
                Intrinsics.checkNotNullExpressionValue(map, "computeIfAbsent(...)");
                results.add(map);
            }
            Unit unit = Unit.INSTANCE;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doesUserHaveCooldown(@NotNull List<Long> chunkKeys, @NotNull UUID userId) {
        Intrinsics.checkNotNullParameter(chunkKeys, "chunkKeys");
        Intrinsics.checkNotNullParameter(userId, "userId");
        List chunkInfos = new ArrayList();
        Object object = this.entityDeathInChunkNotifierLock;
        synchronized (object) {
            boolean $i$a$-synchronized-MainCompanion$doesUserHaveCooldown$22 = false;
            Iterator<Long> iterator2 = chunkKeys.iterator();
            while (iterator2.hasNext()) {
                long chunkKey = ((Number)iterator2.next()).longValue();
                if (!this.chunkKillNoticationTracker.containsKey(chunkKey)) continue;
                Map<UUID, Instant> map = this.chunkKillNoticationTracker.get(chunkKey);
                Intrinsics.checkNotNull(map);
                chunkInfos.add(map);
            }
            Unit $i$a$-synchronized-MainCompanion$doesUserHaveCooldown$22 = Unit.INSTANCE;
        }
        if (chunkInfos.isEmpty()) {
            return false;
        }
        for (Map chunkInfo : chunkInfos) {
            Instant instant;
            if (!chunkInfo.containsKey(userId) || Duration.between(instant = (Instant)chunkInfo.get(userId), Instant.now()).toSeconds() > 30L) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addUserCooldown(@NotNull List<Long> chunkKeys, @NotNull UUID userId) {
        Intrinsics.checkNotNullParameter(chunkKeys, "chunkKeys");
        Intrinsics.checkNotNullParameter(userId, "userId");
        Object object = this.entityDeathInChunkNotifierLock;
        synchronized (object) {
            boolean bl = false;
            Iterator<Long> iterator2 = chunkKeys.iterator();
            while (iterator2.hasNext()) {
                Map entry;
                long chunkKey = ((Number)iterator2.next()).longValue();
                Intrinsics.checkNotNullExpressionValue(this.chunkKillNoticationTracker.computeIfAbsent(chunkKey, arg_0 -> MainCompanion.addUserCooldown$lambda$0$1(MainCompanion::addUserCooldown$lambda$0$0, arg_0)), "computeIfAbsent(...)");
                entry.put(userId, Instant.now());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearChunkKillCache() {
        Object object = this.entityDeathInChunkCounterLock;
        synchronized (object) {
            boolean $i$a$-synchronized-MainCompanion$clearChunkKillCache$32 = false;
            this.entityDeathInChunkCounter.clear();
            Unit $i$a$-synchronized-MainCompanion$clearChunkKillCache$32 = Unit.INSTANCE;
        }
        object = this.entityDeathInChunkNotifierLock;
        synchronized (object) {
            boolean bl = false;
            this.chunkKillNoticationTracker.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void checkUpdates() {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (main.getHelperSettings().getBoolean("use-update-checker", true)) {
            UpdateChecker updateChecker = new UpdateChecker(main, "LevelledMobs");
            try {
                updateChecker.getLatestVersion(arg_0 -> MainCompanion.checkUpdates$lambda$0(updateChecker, this, main, arg_0));
            }
            catch (OutdatedServerVersionException e) {
                e.printStackTrace();
            }
        }
    }

    public final void shutDownAsyncTasks() {
        Log.INSTANCE.inf("&fTasks: &7Shutting down other async tasks...");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        main.getMobsQueueManager().stop();
        main.getNametagQueueManager().stop();
        SchedulerResult schedulerResult = this.hashMapCleanUp;
        if (schedulerResult != null) {
            schedulerResult.cancelTask();
        }
        if (!main.getVer().isRunningFolia()) {
            Bukkit.getScheduler().cancelTasks((Plugin)main);
        }
    }

    private final void buildUniversalGroups() {
        ServerVersionInfo versionInfo = LevelledMobs.Companion.getInstance().getVer();
        EntityType[] entityTypeArray = new EntityType[]{EntityType.ENDER_DRAGON, EntityType.GHAST, EntityType.MAGMA_CUBE, EntityType.PHANTOM, EntityType.SHULKER, EntityType.SLIME};
        this.hostileMobsGroup.addAll((Collection<EntityType>)CollectionsKt.mutableListOf(entityTypeArray));
        entityTypeArray = new EntityType[]{EntityType.IRON_GOLEM};
        this.passiveMobsGroup.addAll((Collection<EntityType>)CollectionsKt.mutableListOf(entityTypeArray));
        EntityType snowGolem = versionInfo.getUseOldEnums() ? EntityType.valueOf((String)"SNOWMAN") : EntityType.valueOf((String)"SNOW_GOLEM");
        this.passiveMobsGroup.add(snowGolem);
        if (versionInfo.getMinorVersion() >= 19) {
            this.passiveMobsGroup.addAll((Collection<EntityType>)Compat119.INSTANCE.getPassiveMobs());
        }
        if (versionInfo.getMinorVersion() >= 20) {
            this.passiveMobsGroup.addAll((Collection<EntityType>)Compat120.INSTANCE.getPassiveMobs());
        }
        if (versionInfo.getMinorVersion() >= 21) {
            this.passiveMobsGroup.addAll((Collection<EntityType>)Compat121.INSTANCE.getPassiveMobs());
        }
        if (versionInfo.getMinorVersion() >= 19) {
            this.hostileMobsGroup.addAll((Collection<EntityType>)Compat119.INSTANCE.getHostileMobs());
        }
        EntityType[] entityTypeArray2 = new EntityType[]{EntityType.DROWNED, EntityType.ELDER_GUARDIAN, EntityType.GUARDIAN, EntityType.TURTLE};
        this.aquaticMobsGroup.addAll((Collection<EntityType>)CollectionsKt.mutableListOf(entityTypeArray2));
        if (versionInfo.getMinorVersion() >= 19) {
            this.aquaticMobsGroup.addAll((Collection<EntityType>)Compat119.INSTANCE.getAquaticMobs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addRecentlyJoinedPlayer(@Nullable Player player) {
        Object object = this.playerLogonTimesLock;
        synchronized (object) {
            boolean bl = false;
            Instant instant = this.recentlyJoinedPlayers.put(player, Instant.now());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Instant getRecentlyJoinedPlayerLogonTime(@Nullable Player player) {
        Object object = this.playerLogonTimesLock;
        synchronized (object) {
            boolean bl = false;
            Instant instant = this.recentlyJoinedPlayers.get(player);
            return instant;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeRecentlyJoinedPlayer(@Nullable Player player) {
        Object object = this.playerLogonTimesLock;
        synchronized (object) {
            boolean bl = false;
            Instant instant = this.recentlyJoinedPlayers.remove(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Location getPlayerNetherPortalLocation(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Object object = this.playerNetherPortalsLock;
        synchronized (object) {
            boolean bl = false;
            Location location = this.playerNetherPortals.get(player);
            return location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPlayerNetherPortalLocation(@NotNull Player player, @Nullable Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Object object = this.playerNetherPortalsLock;
        synchronized (object) {
            boolean bl = false;
            Location location2 = location;
            Intrinsics.checkNotNull(location2);
            Location location3 = this.playerNetherPortals.put(player, location2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Location getPlayerWorldPortalLocation(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Object object = this.playerNetherPortalsLock;
        synchronized (object) {
            boolean bl = false;
            Location location = this.playerWorldPortals.get(player);
            return location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPlayerWorldPortalLocation(@NotNull Player player, @Nullable Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Object object = this.playerNetherPortalsLock;
        synchronized (object) {
            boolean bl = false;
            Location location2 = location;
            Intrinsics.checkNotNull(location2);
            Location location3 = this.playerWorldPortals.put(player, location2);
        }
    }

    private static final String setupMetrics$lambda$0(MainCompanion this$0) {
        return this$0.metricsInfo.getMaxLevelRange();
    }

    private static final String setupMetrics$lambda$1(MainCompanion this$0) {
        return this$0.metricsInfo.getCustomRulesUsed();
    }

    private static final String setupMetrics$lambda$2(KProperty0 $tmp0) {
        return (String)((Function0)$tmp0).invoke();
    }

    private static final String setupMetrics$lambda$3(MainCompanion this$0) {
        return this$0.metricsInfo.getUsesHealthIndicator();
    }

    private static final String setupMetrics$lambda$4(MainCompanion this$0) {
        return this$0.metricsInfo.getLevellingStrategy();
    }

    private static final String setupMetrics$lambda$5(MainCompanion this$0) {
        return this$0.metricsInfo.usesAutoUpdateChecker();
    }

    private static final String setupMetrics$lambda$6(MainCompanion this$0) {
        return this$0.metricsInfo.levelMobsUponSpawn();
    }

    private static final String setupMetrics$lambda$7(MainCompanion this$0) {
        return this$0.metricsInfo.checkMobsOnChunkLoad();
    }

    private static final String setupMetrics$lambda$8(MainCompanion this$0) {
        return this$0.metricsInfo.customEntityNamesCount();
    }

    private static final String setupMetrics$lambda$9(MainCompanion this$0) {
        return this$0.metricsInfo.usesNbtData();
    }

    private static final String setupMetrics$lambda$10(MainCompanion this$0) {
        return this$0.metricsInfo.usesPlayerLevelling();
    }

    private static final String setupMetrics$lambda$11(MainCompanion this$0) {
        return this$0.metricsInfo.nametagVisibility();
    }

    private static final Map setupMetrics$lambda$12(MainCompanion this$0) {
        return this$0.metricsInfo.enabledCompats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void startCleanupTask$lambda$0(MainCompanion this$0) {
        Object object = this$0.entityDeathInChunkCounterLock;
        synchronized (object) {
            boolean $i$a$-synchronized-MainCompanion$startCleanupTask$scheduler$1$32 = false;
            this$0.chunkKillLimitCleanup();
            Unit $i$a$-synchronized-MainCompanion$startCleanupTask$scheduler$1$32 = Unit.INSTANCE;
        }
        object = this$0.entityDeathInChunkNotifierLock;
        synchronized (object) {
            boolean bl = false;
            this$0.chunkKillNoticationCleanup();
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final boolean chunkKillLimitCleanup$lambda$0(Instant $now, Map.Entry e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return ((Instant)e.getKey()).compareTo($now.minusSeconds(((Number)e.getValue()).intValue())) < 0;
    }

    private static final boolean chunkKillLimitCleanup$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean chunkKillLimitCleanup$lambda$2(Map.Entry e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return ((ChunkKillInfo)e.getValue()).isEmpty();
    }

    private static final boolean chunkKillLimitCleanup$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean chunkKillNoticationCleanup$lambda$0(Map.Entry e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return Duration.between((Temporal)e.getValue(), Instant.now()).toSeconds() > 30L;
    }

    private static final boolean chunkKillNoticationCleanup$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Map getorAddPairForSpecifiedChunk$lambda$0$0(Long it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new LinkedHashMap();
    }

    private static final Map getorAddPairForSpecifiedChunk$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map getorAddPairForSpecifiedChunks$lambda$0$0(Long it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new LinkedHashMap();
    }

    private static final Map getorAddPairForSpecifiedChunks$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map addUserCooldown$lambda$0$0(long l) {
        return new LinkedHashMap();
    }

    private static final Map addUserCooldown$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }

    private static final void checkUpdates$lambda$0$0(String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        Log.INSTANCE.war(message);
    }

    private static final void checkUpdates$lambda$0$1(String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        Log.INSTANCE.war(message);
    }

    private static final void checkUpdates$lambda$0(UpdateChecker $updateChecker, MainCompanion this$0, LevelledMobs $main, String latestVersionFull) {
        String[] stringArray = new String[]{" "};
        String currentVersion = (String)StringsKt.split$default((CharSequence)$updateChecker.getCurrentVersion(), stringArray, false, 0, 6, null).get(0);
        VersionInfo thisVersion = null;
        VersionInfo hangarVersion = null;
        boolean isOutOfDate = false;
        boolean isNewerVersion = false;
        if (latestVersionFull == null) {
            Log.INSTANCE.war("Unable to retreive latest version, string was null");
            return;
        }
        String[] stringArray2 = new String[]{"-"};
        String latestVersion = (String)StringsKt.split$default((CharSequence)latestVersionFull, stringArray2, false, 0, 6, null).get(0);
        try {
            thisVersion = new VersionInfo(currentVersion);
            hangarVersion = new VersionInfo(latestVersion);
            isOutOfDate = thisVersion.compareTo(hangarVersion) < 0;
            isNewerVersion = thisVersion.compareTo(hangarVersion) > 0;
        }
        catch (InvalidObjectException e) {
            Log.INSTANCE.war("Got exception creating version objects: " + e.getMessage());
            isOutOfDate = !Intrinsics.areEqual(currentVersion, latestVersion);
            isNewerVersion = StringsKt.contains$default((CharSequence)currentVersion, "indev", false, 2, null);
        }
        if (isNewerVersion) {
            e = new String[]{"Your LevelledMobs version is a pre-release. Latest release version is %latestVersion%. (You're running %currentVersion%)"};
            this$0.updateResult = CollectionsKt.mutableListOf(e);
            this$0.updateResult = Utils.INSTANCE.replaceAllInList(this$0.updateResult, "%currentVersion%", $updateChecker.getCurrentVersion());
            this$0.updateResult = Utils.INSTANCE.replaceAllInList(this$0.updateResult, "%latestVersion%", StringsKt.replace$default(latestVersionFull, "-", " ", false, 4, null));
            this$0.updateResult = Utils.INSTANCE.colorizeAllInList(this$0.updateResult);
            this$0.updateResult.forEach(MainCompanion::checkUpdates$lambda$0$0);
        } else if (isOutOfDate) {
            List<String> list;
            if ($main.getMessagesCfg().contains("other.update-notice.messages")) {
                List<String> list2 = $main.getMessagesCfg().getStringList("other.update-notice.messages");
                list = list2;
                Intrinsics.checkNotNullExpressionValue(list2, "getStringList(...)");
            } else {
                e = new String[]{"LevelledMobs Update Checker Notice:", "Your LevelledMobs version is outdated! Please update to%latestVersion% as soon as possible. (You''re running v%currentVersion%)"};
                list = CollectionsKt.mutableListOf(e);
            }
            this$0.updateResult = list;
            this$0.updateResult = Utils.INSTANCE.replaceAllInList(this$0.updateResult, "%currentVersion%", currentVersion);
            this$0.updateResult = Utils.INSTANCE.replaceAllInList(this$0.updateResult, "%latestVersion%", latestVersion);
            if ($main.getMessagesCfg().getBoolean("other.update-notice.send-in-console", true)) {
                this$0.updateResult.forEach(MainCompanion::checkUpdates$lambda$0$1);
            }
            if ($main.getMessagesCfg().getBoolean("other.update-notice.send-on-join", true)) {
                Collection collection = Bukkit.getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Player onlinePlayer = (Player)element$iv;
                    boolean bl = false;
                    Player player = onlinePlayer;
                    Intrinsics.checkNotNull(player);
                    if (!player.hasPermission("levelledmobs.receive-update-notifications")) continue;
                    for (String msg : this$0.updateResult) {
                        onlinePlayer.sendMessage(MessageUtils.INSTANCE.colorizeAll(msg));
                    }
                }
            }
        }
    }

    @NotNull
    public static final MainCompanion getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058\u0006@BX\u0087.\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/github/arcaneplugins/levelledmobs/MainCompanion$Companion;", "", "<init>", "()V", "value", "Lio/github/arcaneplugins/levelledmobs/MainCompanion;", "instance", "getInstance$annotations", "getInstance", "()Lio/github/arcaneplugins/levelledmobs/MainCompanion;", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MainCompanion getInstance() {
            MainCompanion mainCompanion = instance;
            if (mainCompanion != null) {
                return mainCompanion;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

