/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

public abstract class ConstantValue<T> {
    private final T value;

    public ConstantValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    @NotNull
    public abstract KotlinType getType(@NotNull ModuleDescriptor var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        ConstantValue constantValue = other instanceof ConstantValue ? (ConstantValue)other : null;
        if (!Intrinsics.areEqual(this.getValue(), constantValue != null ? constantValue.getValue() : null)) return false;
        return true;
    }

    public int hashCode() {
        T t = this.getValue();
        return t != null ? t.hashCode() : 0;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.getValue());
    }
}

