/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.wrappers;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerResult;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0013\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u001b\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\tJ\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(J\u000e\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020(R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0005R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\bR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010,\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0019\u00a8\u0006."}, d2={"Lio/github/arcaneplugins/levelledmobs/wrappers/SchedulerWrapper;", "", "runnable", "Ljava/lang/Runnable;", "<init>", "(Ljava/lang/Runnable;)V", "entity", "Lorg/bukkit/entity/Entity;", "(Lorg/bukkit/entity/Entity;)V", "(Lorg/bukkit/entity/Entity;Ljava/lang/Runnable;)V", "getRunnable", "()Ljava/lang/Runnable;", "setRunnable", "getEntity", "()Lorg/bukkit/entity/Entity;", "setEntity", "locationForRegionScheduler", "Lorg/bukkit/Location;", "getLocationForRegionScheduler", "()Lorg/bukkit/Location;", "setLocationForRegionScheduler", "(Lorg/bukkit/Location;)V", "runDirectlyInFolia", "", "getRunDirectlyInFolia", "()Z", "setRunDirectlyInFolia", "(Z)V", "runDirectlyInBukkit", "getRunDirectlyInBukkit", "setRunDirectlyInBukkit", "main", "Lio/github/arcaneplugins/levelledmobs/LevelledMobs;", "getMain", "()Lio/github/arcaneplugins/levelledmobs/LevelledMobs;", "run", "", "runTaskTimerAsynchronously", "Lio/github/arcaneplugins/levelledmobs/wrappers/SchedulerResult;", "initialDelayMS", "", "repeatPeriodMS", "runDelayed", "delayInTicks", "willRunDirectly", "getWillRunDirectly", "levelledmobs-plugin"})
public final class SchedulerWrapper {
    @Nullable
    private Runnable runnable;
    @Nullable
    private Entity entity;
    @Nullable
    private Location locationForRegionScheduler;
    private boolean runDirectlyInFolia;
    private boolean runDirectlyInBukkit;
    @NotNull
    private final LevelledMobs main;

    @Nullable
    public final Runnable getRunnable() {
        return this.runnable;
    }

    public final void setRunnable(@Nullable Runnable runnable2) {
        this.runnable = runnable2;
    }

    @Nullable
    public final Entity getEntity() {
        return this.entity;
    }

    public final void setEntity(@Nullable Entity entity) {
        this.entity = entity;
    }

    public SchedulerWrapper(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter(runnable2, "runnable");
        this.main = LevelledMobs.Companion.getInstance();
        this.runnable = runnable2;
    }

    public SchedulerWrapper(@Nullable Entity entity) {
        this.main = LevelledMobs.Companion.getInstance();
        this.entity = entity;
    }

    public SchedulerWrapper(@Nullable Entity entity, @NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter(runnable2, "runnable");
        this.main = LevelledMobs.Companion.getInstance();
        this.entity = entity;
        this.runnable = runnable2;
    }

    @Nullable
    public final Location getLocationForRegionScheduler() {
        return this.locationForRegionScheduler;
    }

    public final void setLocationForRegionScheduler(@Nullable Location location) {
        this.locationForRegionScheduler = location;
    }

    public final boolean getRunDirectlyInFolia() {
        return this.runDirectlyInFolia;
    }

    public final void setRunDirectlyInFolia(boolean bl) {
        this.runDirectlyInFolia = bl;
    }

    public final boolean getRunDirectlyInBukkit() {
        return this.runDirectlyInBukkit;
    }

    public final void setRunDirectlyInBukkit(boolean bl) {
        this.runDirectlyInBukkit = bl;
    }

    @NotNull
    public final LevelledMobs getMain() {
        return this.main;
    }

    public final void run() {
        if (this.main.getVer().isRunningFolia()) {
            if (this.runDirectlyInFolia) {
                Runnable runnable2 = this.runnable;
                Intrinsics.checkNotNull(runnable2);
                runnable2.run();
                return;
            }
            Consumer<ScheduledTask> task = arg_0 -> SchedulerWrapper.run$lambda$0(this, arg_0);
            if (this.entity != null) {
                Entity entity = this.entity;
                Intrinsics.checkNotNull(entity);
                v2 = entity.getScheduler().run((Plugin)this.main, task, null);
            } else if (this.locationForRegionScheduler != null) {
                RegionScheduler regionScheduler = Bukkit.getRegionScheduler();
                Plugin plugin = (Plugin)this.main;
                Location location = this.locationForRegionScheduler;
                Intrinsics.checkNotNull(location);
                v2 = regionScheduler.run(plugin, location, task);
            } else {
                v2 = Bukkit.getAsyncScheduler().runNow((Plugin)this.main, task);
            }
        } else {
            if (this.runDirectlyInBukkit) {
                Runnable runnable3 = this.runnable;
                Intrinsics.checkNotNull(runnable3);
                runnable3.run();
                return;
            }
            if (this.entity != null) {
                BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
                Plugin plugin = (Plugin)this.main;
                Runnable runnable4 = this.runnable;
                Intrinsics.checkNotNull(runnable4);
                v2 = bukkitScheduler.runTask(plugin, runnable4);
            } else {
                BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
                Plugin plugin = (Plugin)this.main;
                Runnable runnable5 = this.runnable;
                Intrinsics.checkNotNull(runnable5);
                v2 = bukkitScheduler.runTaskAsynchronously(plugin, runnable5);
            }
        }
    }

    @NotNull
    public final SchedulerResult runTaskTimerAsynchronously(long initialDelayMS, long repeatPeriodMS) {
        if (this.main.getVer().isRunningFolia()) {
            Consumer<ScheduledTask> task = arg_0 -> SchedulerWrapper.runTaskTimerAsynchronously$lambda$1(this, arg_0);
            ScheduledTask scheduledTask = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.main, task, initialDelayMS, repeatPeriodMS, TimeUnit.MILLISECONDS);
            Intrinsics.checkNotNullExpressionValue(scheduledTask, "runAtFixedRate(...)");
            ScheduledTask scheduledTask2 = scheduledTask;
            return new SchedulerResult(scheduledTask2);
        }
        long convertedDelay = initialDelayMS / 50L;
        long convertedPeriod = repeatPeriodMS / 50L;
        BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
        Plugin plugin = (Plugin)this.main;
        Runnable runnable2 = this.runnable;
        Intrinsics.checkNotNull(runnable2);
        BukkitTask bukkitTask = bukkitScheduler.runTaskTimerAsynchronously(plugin, runnable2, convertedDelay, convertedPeriod);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimerAsynchronously(...)");
        BukkitTask bukkitTask2 = bukkitTask;
        return new SchedulerResult(bukkitTask2);
    }

    @NotNull
    public final SchedulerResult runDelayed(long delayInTicks) {
        if (this.main.getVer().isRunningFolia()) {
            Consumer<ScheduledTask> task = arg_0 -> SchedulerWrapper.runDelayed$lambda$2(this, arg_0);
            ScheduledTask scheduledTask = null;
            if (this.entity != null) {
                Entity entity = this.entity;
                Intrinsics.checkNotNull(entity);
                scheduledTask = entity.getScheduler().runDelayed((Plugin)this.main, task, null, delayInTicks);
            } else {
                long milliseconds = delayInTicks * 50L;
                scheduledTask = Bukkit.getAsyncScheduler().runDelayed((Plugin)this.main, task, milliseconds, TimeUnit.MILLISECONDS);
            }
            return new SchedulerResult(scheduledTask);
        }
        BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
        Plugin plugin = (Plugin)this.main;
        Runnable runnable2 = this.runnable;
        Intrinsics.checkNotNull(runnable2);
        BukkitTask bukkitTask = bukkitScheduler.runTaskLater(plugin, runnable2, delayInTicks);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskLater(...)");
        BukkitTask bukkitTask2 = bukkitTask;
        return new SchedulerResult(bukkitTask2);
    }

    public final boolean getWillRunDirectly() {
        return this.main.getVer().isRunningFolia() ? this.runDirectlyInFolia : this.runDirectlyInBukkit;
    }

    private static final void run$lambda$0(SchedulerWrapper this$0, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(scheduledTask, "<unused var>");
        Runnable runnable2 = this$0.runnable;
        Intrinsics.checkNotNull(runnable2);
        runnable2.run();
    }

    private static final void runTaskTimerAsynchronously$lambda$1(SchedulerWrapper this$0, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(scheduledTask, "<unused var>");
        Runnable runnable2 = this$0.runnable;
        Intrinsics.checkNotNull(runnable2);
        runnable2.run();
    }

    private static final void runDelayed$lambda$2(SchedulerWrapper this$0, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Runnable runnable2 = this$0.runnable;
        Intrinsics.checkNotNull(runnable2);
        runnable2.run();
    }
}

