/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.wrappers;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.World;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0007H\u0004J\b\u0010#\u001a\u00020 H\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010$\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010!\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010\"\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapperBase;", "", "<init>", "()V", "_world", "Lorg/bukkit/World;", "_location", "Lorg/bukkit/Location;", "_distanceFromSpawn", "", "Ljava/lang/Double;", "main", "Lio/github/arcaneplugins/levelledmobs/LevelledMobs;", "getMain", "()Lio/github/arcaneplugins/levelledmobs/LevelledMobs;", "summonedLevel", "", "getSummonedLevel", "()Ljava/lang/Integer;", "setSummonedLevel", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "isPopulated", "", "()Z", "setPopulated", "(Z)V", "inUseCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "getInUseCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "populateData", "", "world", "location", "clearEntityData", "distanceFromSpawn", "getDistanceFromSpawn", "()D", "getWorld", "()Lorg/bukkit/World;", "getLocation", "()Lorg/bukkit/Location;", "worldName", "", "getWorldName", "()Ljava/lang/String;", "levelledmobs-plugin"})
public abstract class LivingEntityWrapperBase {
    @Nullable
    private World _world;
    @Nullable
    private Location _location;
    @Nullable
    private Double _distanceFromSpawn;
    @NotNull
    private final LevelledMobs main = LevelledMobs.Companion.getInstance();
    @Nullable
    private Integer summonedLevel;
    private boolean isPopulated;
    @NotNull
    private final AtomicInteger inUseCount = new AtomicInteger();

    @NotNull
    public final LevelledMobs getMain() {
        return this.main;
    }

    @Nullable
    public final Integer getSummonedLevel() {
        return this.summonedLevel;
    }

    public final void setSummonedLevel(@Nullable Integer n) {
        this.summonedLevel = n;
    }

    public final boolean isPopulated() {
        return this.isPopulated;
    }

    public final void setPopulated(boolean bl) {
        this.isPopulated = bl;
    }

    @NotNull
    public final AtomicInteger getInUseCount() {
        return this.inUseCount;
    }

    protected final void populateData(@NotNull World world, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(location, "location");
        this._world = world;
        this._location = location;
        this.isPopulated = true;
    }

    protected void clearEntityData() {
        this._world = null;
        this._location = null;
        this._distanceFromSpawn = null;
        this.inUseCount.set(0);
        this.isPopulated = false;
        this.summonedLevel = null;
    }

    public final double getDistanceFromSpawn() {
        if (this._distanceFromSpawn == null) {
            this._distanceFromSpawn = this.getWorld().getSpawnLocation().distance(this.getLocation());
        }
        Double d = this._distanceFromSpawn;
        Intrinsics.checkNotNull(d);
        return d;
    }

    @NotNull
    public final World getWorld() {
        World world = this._world;
        Intrinsics.checkNotNull(world);
        return world;
    }

    @NotNull
    public final Location getLocation() {
        Location location = this._location;
        Intrinsics.checkNotNull(location);
        return location;
    }

    @NotNull
    public final String getWorldName() {
        World world = this._world;
        Intrinsics.checkNotNull(world);
        String string = world.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }
}

