/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.util;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.DeathCause;
import io.github.arcaneplugins.levelledmobs.enums.LevelledMobSpawnReason;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Contract;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.misc.CachedModalList;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.result.PlayerNetherOrWorldSpawnResult;
import io.github.arcaneplugins.levelledmobs.rules.MinAndMax;
import io.github.arcaneplugins.levelledmobs.rules.RulesManager;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010&\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fJ\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u0013\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\fJ,\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\fJ\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u0015J\u000e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\fJ$\u0010\u001c\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0011J\u001c\u0010\"\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020#0\u001e2\u0006\u0010$\u001a\u00020\nJ$\u0010%\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020&0\u001e2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)J\u001c\u0010*\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020+0\u001e2\u0006\u0010,\u001a\u00020+J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020.2\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020:J5\u0010;\u001a\u000e\u0012\u0004\u0012\u0002H=\u0012\u0004\u0012\u0002H>0<\"\u0004\b\u0000\u0010=\"\u0004\b\u0001\u0010>2\u0006\u0010?\u001a\u0002H=2\u0006\u0010@\u001a\u0002H>H\u0007\u00a2\u0006\u0002\u0010AJ\u000e\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EJ\u0016\u0010F\u001a\u00020\u00112\u0006\u0010G\u001a\u00020\f2\u0006\u0010H\u001a\u00020\fJ\u000e\u0010I\u001a\u00020\f2\u0006\u0010G\u001a\u00020\fJ\u0010\u0010J\u001a\u00020\f2\u0006\u00109\u001a\u00020:H\u0002J\u000e\u0010K\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 J3\u0010L\u001a\u0004\u0018\u00010.2\b\u0010G\u001a\u0004\u0018\u00010\f2\b\u0010M\u001a\u0004\u0018\u00010.2\u0006\u0010N\u001a\u00020\u00112\b\u0010O\u001a\u0004\u0018\u00010P\u00a2\u0006\u0002\u0010QJ1\u0010R\u001a\b\u0012\u0004\u0012\u0002040\u00152\f\u0010S\u001a\b\u0012\u0004\u0012\u0002040\u00152\u0006\u0010T\u001a\u00020U2\b\u0010V\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010WJ\u0014\u0010X\u001a\b\u0012\u0004\u0012\u00020\f0\u00152\u0006\u0010Y\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006Z"}, d2={"Lio/github/arcaneplugins/levelledmobs/util/Utils;", "", "<init>", "()V", "timeUnitPattern", "Ljava/util/regex/Pattern;", "round", "", "value", "digits", "", "replaceEx", "", "message", "replaceWhat", "replaceTo", "isInteger", "", "str", "isDouble", "oneToNine", "", "getOneToNine", "()Ljava/util/List;", "replaceAllInList", "oldList", "colorizeAllInList", "capitalize", "isLivingEntityInModalList", "list", "Lio/github/arcaneplugins/levelledmobs/misc/CachedModalList;", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "checkBabyMobs", "isIntegerInModalList", "Lio/github/arcaneplugins/levelledmobs/rules/MinAndMax;", "checkNum", "isBiomeInModalList", "Lorg/bukkit/block/Biome;", "biome", "rulesManager", "Lio/github/arcaneplugins/levelledmobs/rules/RulesManager;", "isDamageCauseInModalList", "Lio/github/arcaneplugins/levelledmobs/enums/DeathCause;", "cause", "getMillisecondsFromInstant", "", "instant", "Ljava/time/Instant;", "getPortalOrWorldSpawn", "Lio/github/arcaneplugins/levelledmobs/result/PlayerNetherOrWorldSpawnResult;", "player", "Lorg/bukkit/entity/Player;", "getChunkKey", "chunk", "Lorg/bukkit/Chunk;", "displayChunkLocation", "location", "Lorg/bukkit/Location;", "getPair", "", "T", "U", "first", "second", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map$Entry;", "adaptVanillaSpawnReason", "Lio/github/arcaneplugins/levelledmobs/enums/LevelledMobSpawnReason;", "spawnReason", "Lorg/bukkit/event/entity/CreatureSpawnEvent$SpawnReason;", "matchWildcardString", "input", "match", "removeColorCodes", "showLocation", "checkIfMobHashChanged", "parseTimeUnit", "defaultTime", "useMS", "sender", "Lorg/bukkit/command/CommandSender;", "(Ljava/lang/String;Ljava/lang/Long;ZLorg/bukkit/command/CommandSender;)Ljava/lang/Long;", "filterPlayersList", "entities", "mob", "Lorg/bukkit/entity/LivingEntity;", "maxDistance", "(Ljava/util/List;Lorg/bukkit/entity/LivingEntity;Ljava/lang/Double;)Ljava/util/List;", "splitStringWithQuotes", "myString", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nio/github/arcaneplugins/levelledmobs/util/Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,604:1\n1#2:605\n739#3,9:606\n739#3,9:617\n739#3,9:628\n37#4,2:615\n37#4,2:626\n37#4,2:637\n607#5:639\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nio/github/arcaneplugins/levelledmobs/util/Utils\n*L\n170#1:606,9\n392#1:617,9\n504#1:628,9\n171#1:615,2\n392#1:626,2\n504#1:637,2\n579#1:639\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    private static final Pattern timeUnitPattern;
    @NotNull
    private static final List<String> oneToNine;

    private Utils() {
    }

    public final double round(double value) {
        return (double)Math.round(value * (double)100) / 100.0;
    }

    public final double round(double value, int digits) {
        double scale = Math.pow(10.0, digits);
        return (double)Math.round(value * scale) / scale;
    }

    @NotNull
    public final String replaceEx(@NotNull String message, @NotNull String replaceWhat, @NotNull String replaceTo) {
        int i;
        int n;
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(replaceWhat, "replaceWhat");
        Intrinsics.checkNotNullParameter(replaceTo, "replaceTo");
        int count = 0;
        int position0 = 0;
        int position1 = 0;
        String string = message;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        String upperString = string2;
        String string3 = replaceWhat;
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
        String string4 = string3.toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
        String upperPattern = string4;
        int inc = message.length() / replaceWhat.length() * (replaceTo.length() - replaceWhat.length());
        char[] chars = new char[(int)((double)message.length() + Math.max(0.0, (double)inc))];
        while (true) {
            int n2;
            int it = n2 = StringsKt.indexOf$default((CharSequence)upperString, upperPattern, position0, false, 4, null);
            boolean bl = false;
            position1 = it;
            if (n2 == -1) break;
            n = position1;
            for (i = position0; i < n; ++i) {
                chars[count++] = message.charAt(i);
            }
            n = replaceTo.length();
            for (i = 0; i < n; ++i) {
                char element = replaceTo.charAt(i);
                chars[count++] = element;
            }
            position0 = position1 + replaceWhat.length();
        }
        if (position0 == 0) {
            return message;
        }
        n = message.length();
        for (i = position0; i < n; ++i) {
            chars[count++] = message.charAt(i);
        }
        return new String(chars, 0, count);
    }

    public final boolean isInteger(@Nullable String str) {
        CharSequence charSequence = str;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public final boolean isDouble(@Nullable String str) {
        CharSequence charSequence = str;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    @NotNull
    public final List<String> getOneToNine() {
        return oneToNine;
    }

    @NotNull
    public final List<String> replaceAllInList(@NotNull List<String> oldList, @NotNull String replaceWhat, @Nullable String replaceTo) {
        Intrinsics.checkNotNullParameter(oldList, "oldList");
        Intrinsics.checkNotNullParameter(replaceWhat, "replaceWhat");
        String string = replaceTo;
        if (string == null) {
            string = "";
        }
        String useReplaceTo = string;
        List newList = new ArrayList();
        for (String string2 : oldList) {
            newList.add(StringsKt.replace$default(string2, replaceWhat, useReplaceTo, false, 4, null));
        }
        return newList;
    }

    @NotNull
    public final List<String> colorizeAllInList(@NotNull List<String> oldList) {
        Intrinsics.checkNotNullParameter(oldList, "oldList");
        List newList = new ArrayList();
        for (String string : oldList) {
            newList.add(MessageUtils.INSTANCE.colorizeAll(string));
        }
        return newList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String capitalize(@NotNull String str) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter(str, "str");
        StringBuilder builder = new StringBuilder();
        Object object = str;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        object = string;
        Regex regex = new Regex(" ");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] words = thisCollection$iv.toArray(new String[0]);
        int n2 = words.length;
        for (int i = 0; i < n2; ++i) {
            String word = words[i];
            if (((CharSequence)word).length() == 0) continue;
            String string2 = String.valueOf(word.charAt(0));
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
            String string3 = string2.toUpperCase(locale2);
            Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
            builder.append(string3);
            if (word.length() > 1) {
                String string4 = word.substring(1);
                Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                builder.append(string4);
            }
            if (i >= words.length - 1) continue;
            builder.append(" ");
        }
        String string5 = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "toString(...)");
        return string5;
    }

    public final boolean isLivingEntityInModalList(@NotNull CachedModalList<String> list, @NotNull LivingEntityWrapper lmEntity, boolean checkBabyMobs) {
        Intrinsics.checkNotNullParameter(list, "list");
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (list.getIncludeAll()) {
            return true;
        }
        if (list.getExcludeAll()) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        String checkName = checkBabyMobs ? lmEntity.getNameIfBaby() : lmEntity.getTypeName();
        for (String group : lmEntity.getApplicableGroups()) {
            if (!list.getExcludedGroups().contains(group)) continue;
            return false;
        }
        if (list.getExcludedList().contains(lmEntity.getTypeName()) || list.getExcludedList().contains(lmEntity.getNameIfBaby()) || lmEntity.isBabyMob() && list.getExcludedList().contains("baby_")) {
            return false;
        }
        for (String group : lmEntity.getApplicableGroups()) {
            if (!list.getIncludedGroups().contains(group)) continue;
            return true;
        }
        return list.isBlacklist() || list.getIncludedList().contains(checkName) || lmEntity.isBabyMob() && list.getIncludedList().contains("baby_");
    }

    public final boolean isIntegerInModalList(@NotNull CachedModalList<MinAndMax> list, int checkNum) {
        Intrinsics.checkNotNullParameter(list, "list");
        if (list.getIncludeAll()) {
            return true;
        }
        if (list.getExcludeAll()) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        for (MinAndMax exclude : list.getExcludedList()) {
            if (!((float)checkNum >= exclude.getMin()) || !((float)checkNum <= exclude.getMax())) continue;
            return false;
        }
        if (list.isBlacklist()) {
            return true;
        }
        for (MinAndMax include : list.getIncludedList()) {
            if (!((float)checkNum >= include.getMin()) || !((float)checkNum <= include.getMax())) continue;
            return true;
        }
        return false;
    }

    public final boolean isBiomeInModalList(@NotNull CachedModalList<Biome> list, @NotNull Biome biome, @NotNull RulesManager rulesManager) {
        Intrinsics.checkNotNullParameter(list, "list");
        Intrinsics.checkNotNullParameter(biome, "biome");
        Intrinsics.checkNotNullParameter(rulesManager, "rulesManager");
        if (list.getIncludeAll()) {
            return true;
        }
        if (list.getExcludeAll()) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        for (String group : list.getExcludedGroups()) {
            if (!rulesManager.getBiomeGroupMappings().containsKey(group)) continue;
            List<String> list2 = rulesManager.getBiomeGroupMappings().get(group);
            Intrinsics.checkNotNull(list2);
            if (!list2.contains(biome.toString())) continue;
            return false;
        }
        if (list.getExcludedList().contains(biome)) {
            return false;
        }
        for (String group : list.getIncludedGroups()) {
            if (!rulesManager.getBiomeGroupMappings().containsKey(group)) continue;
            List<String> list3 = rulesManager.getBiomeGroupMappings().get(group);
            Intrinsics.checkNotNull(list3);
            if (!list3.contains(biome.toString())) continue;
            return true;
        }
        return list.isBlacklist() || list.getIncludedList().contains(biome);
    }

    public final boolean isDamageCauseInModalList(@NotNull CachedModalList<DeathCause> list, @NotNull DeathCause cause) {
        Intrinsics.checkNotNullParameter(list, "list");
        Intrinsics.checkNotNullParameter((Object)cause, "cause");
        if (list.getIncludeAll()) {
            return true;
        }
        if (list.getExcludeAll()) {
            return false;
        }
        if (list.isEmpty()) {
            return true;
        }
        if (list.getExcludedList().contains((Object)cause)) {
            return false;
        }
        return list.isBlacklist() || list.getIncludedList().contains((Object)cause);
    }

    public final long getMillisecondsFromInstant(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter(instant, "instant");
        return Duration.between(instant, Instant.now()).toMillis();
    }

    @NotNull
    public final PlayerNetherOrWorldSpawnResult getPortalOrWorldSpawn(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Location location = null;
        boolean isNetherPortalCoord = false;
        boolean isWorldPortalCoord = false;
        if (player.getWorld().getEnvironment() == World.Environment.NETHER) {
            location = MainCompanion.Companion.getInstance().getPlayerNetherPortalLocation(player);
            isNetherPortalCoord = true;
        } else if (player.getWorld().getEnvironment() == World.Environment.NORMAL) {
            location = MainCompanion.Companion.getInstance().getPlayerWorldPortalLocation(player);
            isWorldPortalCoord = true;
        }
        if (location == null) {
            location = player.getWorld().getSpawnLocation();
            isNetherPortalCoord = false;
            isWorldPortalCoord = false;
        }
        return new PlayerNetherOrWorldSpawnResult(location, isNetherPortalCoord, isWorldPortalCoord);
    }

    public final long getChunkKey(@NotNull Chunk chunk) {
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        if (LevelledMobs.Companion.getInstance().getVer().isRunningPaper()) {
            return chunk.getChunkKey();
        }
        int x = chunk.getX() >> 4;
        int z = chunk.getZ() >> 4;
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }

    @NotNull
    public final String displayChunkLocation(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return location.getChunk().getX() + "," + location.getChunk().getZ();
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public final <T, U> Map.Entry<T, U> getPair(T first, U second) {
        return new AbstractMap.SimpleEntry<T, U>(first, second);
    }

    @NotNull
    public final LevelledMobSpawnReason adaptVanillaSpawnReason(@NotNull CreatureSpawnEvent.SpawnReason spawnReason) {
        Intrinsics.checkNotNullParameter(spawnReason, "spawnReason");
        return LevelledMobSpawnReason.valueOf(spawnReason.toString());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean matchWildcardString(@NotNull String input, @NotNull String match) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(match, "match");
        if (!StringsKt.contains$default((CharSequence)match, "*", false, 2, null)) {
            return StringsKt.equals(input, match, true);
        }
        Object object = match;
        Regex regex = new Regex("\\*");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray22 = false;
        String thisCollection$iv = $this$toTypedArray$iv;
        String[] chopped = thisCollection$iv.toArray(new String[0]);
        if (chopped.length > 3) {
            Log.INSTANCE.war("Invalid wildcard pattern: " + match);
            return StringsKt.equals(input, match, true);
        }
        String $i$f$toTypedArray22 = input;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string = $i$f$toTypedArray22.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String inputL = string;
        thisCollection$iv = match;
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
        String string2 = thisCollection$iv.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String matchL = string2;
        String useSearch = null;
        if (StringsKt.startsWith$default(matchL, "*", false, 2, null) && StringsKt.endsWith$default(matchL, "*", false, 2, null)) {
            String string3 = matchL.substring(1, matchL.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            useSearch = string3;
            return StringsKt.contains$default((CharSequence)inputL, useSearch, false, 2, null);
        }
        if (StringsKt.startsWith$default(matchL, "*", false, 2, null)) {
            String string4 = matchL.substring(1);
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            useSearch = string4;
            return StringsKt.endsWith$default(inputL, useSearch, false, 2, null);
        }
        String string5 = matchL.substring(0, matchL.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
        useSearch = string5;
        return StringsKt.startsWith$default(inputL, useSearch, false, 2, null);
    }

    @NotNull
    public final String removeColorCodes(@NotNull String input) {
        Intrinsics.checkNotNullParameter(input, "input");
        String formatted = StringsKt.replace$default(input, "\u00a7", "&", false, 4, null);
        if (StringsKt.contains$default((CharSequence)input, "&", false, 2, null)) {
            CharSequence charSequence = input;
            Regex regex = new Regex("&.");
            String string = "";
            formatted = regex.replace(charSequence, string);
        }
        return formatted;
    }

    private final String showLocation(Location location) {
        return location.getWorld().getName() + " at " + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
    }

    public final boolean checkIfMobHashChanged(@NotNull LivingEntityWrapper lmEntity) {
        boolean hashChanged;
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (!lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING)) {
            return true;
        }
        boolean hadHash = false;
        String mobHash = null;
        if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING)) {
            mobHash = (String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING);
            hadHash = true;
        }
        boolean bl = hashChanged = !Intrinsics.areEqual(main.getRulesManager().getCurrentRulesHash(), mobHash);
        if (hashChanged) {
            if (hadHash) {
                DebugManager.Companion.log(DebugType.MOB_HASH, lmEntity, false, () -> Utils.checkIfMobHashChanged$lambda$3(lmEntity));
            } else {
                DebugManager.Companion.log(DebugType.MOB_HASH, lmEntity, false, () -> Utils.checkIfMobHashChanged$lambda$4(lmEntity));
            }
            lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING, (Object)main.getRulesManager().getCurrentRulesHash());
        } else {
            DebugManager.Companion.log(DebugType.MOB_HASH, lmEntity, true, () -> Utils.checkIfMobHashChanged$lambda$5(lmEntity));
        }
        return hashChanged;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Long parseTimeUnit(@Nullable String input, @Nullable Long defaultTime, boolean useMS, @Nullable CommandSender sender) {
        String[] split;
        String unit;
        String string;
        Object numberPart;
        if (input == null) {
            return defaultTime;
        }
        if (Intrinsics.areEqual("0", input)) {
            return 0L;
        }
        Matcher match = timeUnitPattern.matcher(input);
        if (!match.matches() || match.groupCount() != 2) {
            CommandSender commandSender = sender;
            if (commandSender != null) {
                commandSender.sendMessage("Invalid time: " + input);
            } else {
                Log.INSTANCE.war("Invalid time: " + input);
            }
            return defaultTime;
        }
        long time = 0L;
        double remainder = 0.0;
        Object object = numberPart = match.group(1) != null ? match.group(1) : match.group(2);
        if (match.group(1) != null) {
            String string2 = match.group(2);
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            string = string2;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string3 = string.toLowerCase(locale);
            v5 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        } else {
            v5 = unit = "";
        }
        if (this.isInteger(input)) {
            numberPart = input;
            unit = "";
        }
        string = numberPart;
        Intrinsics.checkNotNull(string);
        if (StringsKt.contains$default((CharSequence)string, ".", false, 2, null)) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            Object object2 = numberPart;
            Intrinsics.checkNotNull(object2);
            object2 = (CharSequence)object2;
            Regex regex = new Regex("\\.");
            int n = 0;
            object2 = regex.split((CharSequence)object2, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            split = thisCollection$iv.toArray(new String[0]);
            try {
                remainder = 1.0 - Double.parseDouble("0." + split[1]);
                numberPart = split[0];
            }
            catch (Exception e) {
                CommandSender commandSender = sender;
                if (commandSender != null) {
                    commandSender.sendMessage("Invalid time: " + input);
                } else {
                    Log.INSTANCE.war("Invalid time: " + input);
                }
                return defaultTime;
            }
        }
        try {
            split = numberPart;
            Intrinsics.checkNotNull(split);
            time = Long.parseLong((String)split);
        }
        catch (Exception e) {
            CommandSender commandSender = sender;
            if (commandSender != null) {
                commandSender.sendMessage("Invalid time: " + input);
            } else {
                Log.INSTANCE.war("Invalid time: " + input);
            }
            return defaultTime;
        }
        Duration duration = null;
        switch (unit) {
            case "milliseconds": 
            case "ms": 
            case "millisecond": {
                duration = Duration.ofMillis(time);
                break;
            }
            case "second": 
            case "seconds": 
            case "s": {
                duration = Duration.ofSeconds(time);
                if (!(remainder > 0.0)) break;
                duration = duration.plusMillis((long)(1000.0 * remainder));
                break;
            }
            case "minutes": 
            case "m": 
            case "minute": {
                duration = Duration.ofMinutes(time);
                if (!(remainder > 0.0)) break;
                duration = duration.plusMillis((long)(60000.0 * remainder));
                break;
            }
            case "hours": 
            case "h": 
            case "hour": {
                duration = Duration.ofHours(time);
                if (!(remainder > 0.0)) break;
                duration = duration.plusMillis((long)(3600000.0 * remainder));
                break;
            }
            case "d": 
            case "days": 
            case "day": {
                duration = Duration.ofDays(time);
                if (!(remainder > 0.0)) break;
                duration = duration.plusSeconds((long)(86400.0 * remainder));
                break;
            }
            case "": {
                duration = useMS ? Duration.ofMillis(time) : Duration.ofSeconds(time);
                break;
            }
            default: {
                CommandSender commandSender = sender;
                if (commandSender != null) {
                    commandSender.sendMessage("Invalid time unit specified: " + input + " (" + unit + ")");
                    break;
                }
                Log.INSTANCE.war("Invalid time unit specified: " + input + " (" + unit + ")");
            }
        }
        if (duration != null) {
            return useMS ? Long.valueOf(duration.toMillis()) : Long.valueOf(duration.getSeconds());
        }
        return defaultTime;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Player> filterPlayersList(@NotNull List<Player> entities, @NotNull LivingEntity mob, @Nullable Double maxDistance) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(entities, "entities");
        Intrinsics.checkNotNullParameter(mob, "mob");
        Sequence<Pair> sequence = SequencesKt.filter(SequencesKt.map(SequencesKt.filter(SequencesKt.filter(CollectionsKt.asSequence((Iterable)entities), arg_0 -> Utils.filterPlayersList$lambda$7(mob, arg_0)), Utils::filterPlayersList$lambda$8), arg_0 -> Utils.filterPlayersList$lambda$9(mob, arg_0)), arg_0 -> Utils.filterPlayersList$lambda$10(maxDistance, arg_0));
        boolean $i$f$sortedBy = false;
        Sequence<Player> temp = SequencesKt.map(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Double)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Double)it.getFirst()));
            }
        }), Utils::filterPlayersList$lambda$12);
        if (MainCompanion.Companion.getInstance().getExcludePlayersInCreative()) {
            temp = SequencesKt.filter(temp, Utils::filterPlayersList$lambda$13);
        }
        return SequencesKt.toMutableList(temp);
    }

    @NotNull
    public final List<String> splitStringWithQuotes(@NotNull String myString) {
        Intrinsics.checkNotNullParameter(myString, "myString");
        List results = new ArrayList();
        Pattern pattern = Pattern.compile("[^\\s\"]+|\"([^\"]*)\"");
        Matcher match = pattern.matcher(myString);
        while (match.find()) {
            String temp;
            String string = temp = match.group(0);
            Intrinsics.checkNotNull(string);
            if (StringsKt.startsWith$default(string, "\"", false, 2, null)) {
                string = temp;
                Intrinsics.checkNotNull(string);
                if (StringsKt.endsWith$default(string, "\"", false, 2, null)) {
                    string = temp;
                    Intrinsics.checkNotNull(string);
                    int n = 1;
                    int n2 = temp.length() - 1;
                    String string2 = string.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                    temp = string2;
                }
            }
            string = temp;
            Intrinsics.checkNotNull(string);
            results.add(string);
        }
        return results;
    }

    private static final String checkIfMobHashChanged$lambda$3(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "Invalid hash, location: " + INSTANCE.showLocation($lmEntity.getLocation());
    }

    private static final String checkIfMobHashChanged$lambda$4(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "Hash missing, location: " + INSTANCE.showLocation($lmEntity.getLocation());
    }

    private static final String checkIfMobHashChanged$lambda$5(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "Hash missing, location: " + INSTANCE.showLocation($lmEntity.getLocation());
    }

    private static final boolean filterPlayersList$lambda$7(LivingEntity $mob, Player p) {
        Intrinsics.checkNotNullParameter($mob, "$mob");
        Intrinsics.checkNotNullParameter(p, "p");
        return Intrinsics.areEqual(p.getWorld(), $mob.getWorld());
    }

    private static final boolean filterPlayersList$lambda$8(Player p) {
        Intrinsics.checkNotNullParameter(p, "p");
        return p.getGameMode() != GameMode.SPECTATOR;
    }

    private static final Pair filterPlayersList$lambda$9(LivingEntity $mob, Player p) {
        Intrinsics.checkNotNullParameter($mob, "$mob");
        Intrinsics.checkNotNullParameter(p, "p");
        return new Pair<Double, Player>($mob.getLocation().distanceSquared(p.getLocation()), p);
    }

    private static final boolean filterPlayersList$lambda$10(Double $maxDistance, Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $maxDistance != null && ((Number)it.getFirst()).doubleValue() <= $maxDistance;
    }

    private static final Player filterPlayersList$lambda$12(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Player)it.getSecond();
    }

    private static final boolean filterPlayersList$lambda$13(Entity e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return ((Player)e).getGameMode() != GameMode.CREATIVE;
    }

    static {
        Pattern pattern = Pattern.compile("(\\d+\\.?\\d+|\\d+)?(\\w+)");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        timeUnitPattern = pattern;
        String[] stringArray = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
        oneToNine = CollectionsKt.mutableListOf(stringArray);
    }
}

