/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.util;

import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.plugin.java.JavaPlugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0016\u0010\r\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\u00020\f8F\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lio/github/arcaneplugins/levelledmobs/util/UpdateChecker;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "resourceId", "", "<init>", "(Lorg/bukkit/plugin/java/JavaPlugin;I)V", "getLatestVersion", "", "consumer", "Ljava/util/function/Consumer;", "", "checkVersion", "currentVersion", "getCurrentVersion$annotations", "()V", "getCurrentVersion", "()Ljava/lang/String;", "levelledmobs-plugin"})
public final class UpdateChecker {
    @NotNull
    private JavaPlugin plugin;
    private int resourceId;

    public UpdateChecker(@NotNull JavaPlugin plugin, int resourceId) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.resourceId = resourceId;
    }

    public final void getLatestVersion(@NotNull Consumer<String> consumer) {
        Intrinsics.checkNotNullParameter(consumer, "consumer");
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> UpdateChecker.getLatestVersion$lambda$0(this, consumer));
        scheduler.run();
    }

    private final void checkVersion(Consumer<String> consumer) {
        InputStream inputStream = null;
        try {
            inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Scanner scanner = new Scanner(inputStream);
        if (scanner.hasNext()) {
            consumer.accept(scanner.next());
        }
    }

    @NotNull
    public final String getCurrentVersion() {
        String string = this.plugin.getDescription().getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        return string;
    }

    public static /* synthetic */ void getCurrentVersion$annotations() {
    }

    private static final void getLatestVersion$lambda$0(UpdateChecker this$0, Consumer $consumer) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($consumer, "$consumer");
        this$0.checkVersion($consumer);
    }
}

