/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.util;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.managers.LevelManager;
import io.github.arcaneplugins.levelledmobs.result.NametagResult;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.meta.ItemMeta;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tJ\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lio/github/arcaneplugins/levelledmobs/util/SpigotUtils;", "", "<init>", "()V", "sendHyperlink", "", "sender", "Lorg/bukkit/command/CommandSender;", "message", "", "url", "updateItemMetaLore", "meta", "Lorg/bukkit/inventory/meta/ItemMeta;", "lore", "", "updateItemDisplayName", "displayName", "getPlayerDisplayName", "player", "Lorg/bukkit/entity/Player;", "getPlayersKiller", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "event", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "levelledmobs-plugin"})
public final class SpigotUtils {
    @NotNull
    public static final SpigotUtils INSTANCE = new SpigotUtils();

    private SpigotUtils() {
    }

    public final void sendHyperlink(@NotNull CommandSender sender, @Nullable String message, @Nullable String url) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        TextComponent component = new TextComponent(message);
        component.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        Content[] contentArray = new Content[]{new Text(url)};
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, contentArray));
        sender.sendMessage((BaseComponent)component);
    }

    public final void updateItemMetaLore(@NotNull ItemMeta meta, @Nullable List<String> lore) {
        Intrinsics.checkNotNullParameter(meta, "meta");
        if (lore == null) {
            meta.setLore(null);
        } else {
            meta.setLore(Utils.INSTANCE.colorizeAllInList(lore));
        }
    }

    public final void updateItemDisplayName(@NotNull ItemMeta meta, @Nullable String displayName) {
        Intrinsics.checkNotNullParameter(meta, "meta");
        meta.setDisplayName(displayName);
    }

    @NotNull
    public final String getPlayerDisplayName(@Nullable Player player) {
        if (player == null) {
            return "";
        }
        String string = player.getDisplayName();
        Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
        return string;
    }

    @Nullable
    public final LivingEntityWrapper getPlayersKiller(@NotNull PlayerDeathEvent event) {
        LivingEntity killer;
        block17: {
            block16: {
                Intrinsics.checkNotNullParameter(event, "event");
                if (event.getDeathMessage() == null) {
                    return null;
                }
                EntityDamageEvent entityDamageEvent = event.getEntity().getLastDamageCause();
                if (entityDamageEvent == null || entityDamageEvent.isCancelled() || !(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
                    return null;
                }
                Entity entity = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
                Intrinsics.checkNotNullExpressionValue(entity, "getDamager(...)");
                Entity damager = entity;
                killer = null;
                if (damager instanceof Projectile) {
                    if (((Projectile)damager).getShooter() instanceof LivingEntity) {
                        killer = (LivingEntity)((Projectile)damager).getShooter();
                    }
                } else if (damager instanceof LivingEntity) {
                    killer = (LivingEntity)damager;
                }
                if (killer == null) break block16;
                String string = killer.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                if (!(((CharSequence)string).length() == 0) && !(killer instanceof Player)) break block17;
            }
            return null;
        }
        LivingEntityWrapper lmKiller = LivingEntityWrapper.Companion.getInstance(killer);
        lmKiller.setAssociatedPlayer(event.getEntity());
        if (!lmKiller.isLevelled()) {
            return lmKiller;
        }
        NametagResult nametagResult = LevelledMobs.Companion.getInstance().getLevelManager().getNametag(lmKiller, true, true);
        String string = nametagResult.getNametagNonNull();
        String string2 = event.getEntity().getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        String deathMessage = StringsKt.replace$default(string, "%player%", string2, false, 4, null);
        if (((CharSequence)deathMessage).length() == 0 || StringsKt.equals("disabled", deathMessage, true)) {
            return lmKiller;
        }
        if (nametagResult.getHadCustomDeathMessage()) {
            String nametag = nametagResult.getNametagNonNull();
            if (StringsKt.contains$default((CharSequence)nametag, "{DisplayName}", false, 2, null)) {
                LevelManager levelManager = LevelledMobs.Companion.getInstance().getLevelManager();
                String string3 = nametagResult.getCustomDeathMessage();
                Intrinsics.checkNotNull(string3);
                nametag = StringsKt.replace$default(nametag, "{DisplayName}", levelManager.replaceStringPlaceholders(string3, lmKiller, false, null, false), false, 4, null);
            }
            String string4 = event.getEntity().getName();
            Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
            event.setDeathMessage(MessageUtils.INSTANCE.colorizeAll(StringsKt.replace$default(nametag, "%player%", string4, false, 4, null)));
        } else {
            if (StringsKt.contains$default((CharSequence)deathMessage, "{DisplayName}", false, 2, null)) {
                deathMessage = StringsKt.replace$default(deathMessage, "{DisplayName}", Utils.INSTANCE.capitalize(lmKiller.getNameIfBaby()), false, 4, null);
            }
            String string5 = event.getDeathMessage();
            Intrinsics.checkNotNull(string5);
            String string6 = killer.getName();
            Intrinsics.checkNotNullExpressionValue(string6, "getName(...)");
            event.setDeathMessage(MessageUtils.INSTANCE.colorizeAll(Utils.INSTANCE.replaceEx(string5, string6, deathMessage)));
        }
        return lmKiller;
    }
}

