/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.util;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.nametag.ServerVersionInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\n"}, d2={"Lio/github/arcaneplugins/levelledmobs/util/MessageUtils;", "", "<init>", "()V", "colorizeAll", "", "msg", "colorizeHexCodes", "message", "colorizeStandardCodes", "levelledmobs-plugin"})
public final class MessageUtils {
    @NotNull
    public static final MessageUtils INSTANCE = new MessageUtils();

    private MessageUtils() {
    }

    @NotNull
    public final String colorizeAll(@Nullable String msg) {
        if (msg == null) {
            return "";
        }
        return this.colorizeStandardCodes(this.colorizeHexCodes(msg));
    }

    private final String colorizeHexCodes(String message) {
        ServerVersionInfo ver = LevelledMobs.Companion.getInstance().getVer();
        String startTag = "&#";
        String endTag = "";
        if (ver.getMinecraftVersion() < 1.16 || !ver.isRunningSpigot()) {
            return message;
        }
        Pattern hexPattern = Pattern.compile(startTag + "([A-Fa-f0-9]{6})" + endTag);
        Matcher matcher = hexPattern.matcher(message);
        StringBuilder buffer = new StringBuilder(message.length() + 32);
        char colorChar = '\u00a7';
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, colorChar + "x" + colorChar + group.charAt(0) + colorChar + group.charAt(1) + colorChar + group.charAt(2) + colorChar + group.charAt(3) + colorChar + group.charAt(4) + colorChar + group.charAt(5));
        }
        String string = matcher.appendTail(buffer).toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public final String colorizeStandardCodes(@Nullable String msg) {
        String string;
        if (StringsKt.equals(Bukkit.getName(), "CraftBukkit", true)) {
            String string2 = msg;
            Intrinsics.checkNotNull(string2);
            String string3 = ChatColor.translateAlternateColorCodes((char)'&', (String)string2);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "translateAlternateColorCodes(...)");
        } else {
            String string4 = net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)msg);
            string = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "translateAlternateColorCodes(...)");
        }
        return string;
    }
}

