/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.rules.strategies;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.rules.strategies.LevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.StrategyType;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0000H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0006H\u0016J\u0018\u0010#\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u0000H\u0016R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\nR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/strategies/YDistanceStrategy;", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/LevellingStrategy;", "", "<init>", "()V", "startingYLevel", "", "getStartingYLevel", "()Ljava/lang/Integer;", "setStartingYLevel", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "endingYLevel", "getEndingYLevel", "setEndingYLevel", "yPeriod", "getYPeriod", "setYPeriod", "strategyType", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "getStrategyType", "()Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "mergeRule", "", "levellingStrategy", "mergeYDistanceStrategy", "yds", "toString", "", "generateNumber", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "minLevel", "maxLevel", "getVariance", "isAtMaxLevel", "", "cloneItem", "levelledmobs-plugin"})
public final class YDistanceStrategy
implements LevellingStrategy,
Cloneable {
    @Nullable
    private Integer startingYLevel;
    @Nullable
    private Integer endingYLevel;
    @Nullable
    private Integer yPeriod;
    @NotNull
    private final StrategyType strategyType = StrategyType.Y_COORDINATE;

    @Nullable
    public final Integer getStartingYLevel() {
        return this.startingYLevel;
    }

    public final void setStartingYLevel(@Nullable Integer n) {
        this.startingYLevel = n;
    }

    @Nullable
    public final Integer getEndingYLevel() {
        return this.endingYLevel;
    }

    public final void setEndingYLevel(@Nullable Integer n) {
        this.endingYLevel = n;
    }

    @Nullable
    public final Integer getYPeriod() {
        return this.yPeriod;
    }

    public final void setYPeriod(@Nullable Integer n) {
        this.yPeriod = n;
    }

    @Override
    @NotNull
    public StrategyType getStrategyType() {
        return this.strategyType;
    }

    @Override
    public void mergeRule(@Nullable LevellingStrategy levellingStrategy) {
        if (levellingStrategy instanceof YDistanceStrategy) {
            this.mergeYDistanceStrategy((YDistanceStrategy)levellingStrategy);
        }
    }

    private final void mergeYDistanceStrategy(YDistanceStrategy yds) {
        if (yds == null) {
            return;
        }
        if (yds.startingYLevel != null) {
            this.startingYLevel = yds.startingYLevel;
        }
        if (yds.endingYLevel != null) {
            this.endingYLevel = yds.endingYLevel;
        }
        if (yds.yPeriod != null) {
            this.yPeriod = yds.yPeriod;
        }
    }

    @NotNull
    public String toString() {
        String string = "y coord, start: %s, end: %s, yPeriod: %s";
        Object[] objectArray = new Object[]{this.startingYLevel == null ? Integer.valueOf(0) : this.startingYLevel, this.endingYLevel == null ? Integer.valueOf(0) : this.endingYLevel, this.yPeriod == null ? Integer.valueOf(0) : this.yPeriod};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    @Override
    public float generateNumber(@NotNull LivingEntityWrapper lmEntity, int minLevel, int maxLevel) {
        boolean isDecending;
        double d;
        int yEnd;
        int yStart;
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        int mobYLocation = lmEntity.getLivingEntity().getLocation().getBlockY();
        if (this.startingYLevel == null) {
            v0 = 0;
        } else {
            Integer n = this.startingYLevel;
            Intrinsics.checkNotNull(n);
            v0 = yStart = n.intValue();
        }
        if (this.endingYLevel == null) {
            v2 = 0;
        } else {
            Integer n = this.endingYLevel;
            Intrinsics.checkNotNull(n);
            v2 = yEnd = n.intValue();
        }
        if (this.yPeriod == null) {
            d = 0.0;
        } else {
            Integer n = this.yPeriod;
            Intrinsics.checkNotNull(n);
            d = n.intValue();
        }
        double yPeriod = d;
        float useLevel = 0.0f;
        double diff = yEnd - yStart;
        boolean bl = isDecending = yStart > yEnd;
        if (isDecending && mobYLocation < yEnd) {
            mobYLocation = yEnd;
        } else if (!isDecending && mobYLocation > yEnd) {
            mobYLocation = yStart;
        }
        if (!(yPeriod == 0.0)) {
            double lvlPerPeriod = (double)(maxLevel - minLevel) / (diff / yPeriod);
            useLevel = (float)Math.floor((double)minLevel + lvlPerPeriod * (double)(mobYLocation - yStart) / yPeriod);
        } else {
            double useMobYLocation = mobYLocation - yStart;
            double percent = useMobYLocation / diff;
            useLevel = (float)minLevel + (float)Math.ceil((double)(maxLevel - minLevel) * percent);
        }
        return useLevel;
    }

    private final int getVariance(LivingEntityWrapper lmEntity, boolean isAtMaxLevel) {
        Integer variance = LevelledMobs.Companion.getInstance().getRulesManager().getRuleMaxRandomVariance(lmEntity);
        if (variance == null || variance == 0) {
            return 0;
        }
        int change = ThreadLocalRandom.current().nextInt(0, variance + 1);
        return !isAtMaxLevel || ThreadLocalRandom.current().nextBoolean() ? change : -change;
    }

    @Override
    @NotNull
    public YDistanceStrategy cloneItem() {
        YDistanceStrategy copy = null;
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.strategies.YDistanceStrategy");
            copy = (YDistanceStrategy)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        YDistanceStrategy yDistanceStrategy = copy;
        Intrinsics.checkNotNull(yDistanceStrategy);
        return yDistanceStrategy;
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }
}

