/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.rules.strategies;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.rules.strategies.LevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.StrategyType;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.bukkit.Location;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0016J\u0012\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u00105\u001a\u0002032\b\u00106\u001a\u0004\u0018\u00010\u0000H\u0002J\b\u00107\u001a\u000208H\u0016J\u0018\u00109\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.2\u0006\u0010:\u001a\u00020\u0006H\u0002J\b\u0010;\u001a\u00020\u0000H\u0016R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\nR\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0013\u0010\b\"\u0004\b\u0014\u0010\nR\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u001d\u0010\b\"\u0004\b\u001e\u0010\nR\u001e\u0010\u001f\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b \u0010\b\"\u0004\b!\u0010\nR\u001e\u0010\"\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b#\u0010\b\"\u0004\b$\u0010\nR\u001e\u0010%\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b&\u0010\u0018\"\u0004\b'\u0010\u001aR\u0014\u0010(\u001a\u00020)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006<"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/strategies/SpawnDistanceStrategy;", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/LevellingStrategy;", "", "<init>", "()V", "startDistance", "", "getStartDistance", "()Ljava/lang/Float;", "setStartDistance", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "increaseLevelDistance", "getIncreaseLevelDistance", "setIncreaseLevelDistance", "spawnLocationX", "getSpawnLocationX", "setSpawnLocationX", "spawnLocationZ", "getSpawnLocationZ", "setSpawnLocationZ", "blendedLevellingEnabled", "", "getBlendedLevellingEnabled", "()Ljava/lang/Boolean;", "setBlendedLevellingEnabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "transitionYheight", "getTransitionYheight", "setTransitionYheight", "multiplierPeriod", "getMultiplierPeriod", "setMultiplierPeriod", "lvlMultiplier", "getLvlMultiplier", "setLvlMultiplier", "scaleDownward", "getScaleDownward", "setScaleDownward", "strategyType", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "getStrategyType", "()Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "generateNumber", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "minLevel", "", "maxLevel", "mergeRule", "", "levellingStrategy", "mergeSpawnDistanceStrategy", "sds", "toString", "", "generateBlendedLevel", "spawnDistanceLevelAssignment", "cloneItem", "levelledmobs-plugin"})
public final class SpawnDistanceStrategy
implements LevellingStrategy,
Cloneable {
    @Nullable
    private Float startDistance;
    @Nullable
    private Float increaseLevelDistance;
    @Nullable
    private Float spawnLocationX;
    @Nullable
    private Float spawnLocationZ;
    @Nullable
    private Boolean blendedLevellingEnabled;
    @Nullable
    private Float transitionYheight;
    @Nullable
    private Float multiplierPeriod;
    @Nullable
    private Float lvlMultiplier;
    @Nullable
    private Boolean scaleDownward;
    @NotNull
    private final StrategyType strategyType = StrategyType.SPAWN_DISTANCE;

    @Nullable
    public final Float getStartDistance() {
        return this.startDistance;
    }

    public final void setStartDistance(@Nullable Float f) {
        this.startDistance = f;
    }

    @Nullable
    public final Float getIncreaseLevelDistance() {
        return this.increaseLevelDistance;
    }

    public final void setIncreaseLevelDistance(@Nullable Float f) {
        this.increaseLevelDistance = f;
    }

    @Nullable
    public final Float getSpawnLocationX() {
        return this.spawnLocationX;
    }

    public final void setSpawnLocationX(@Nullable Float f) {
        this.spawnLocationX = f;
    }

    @Nullable
    public final Float getSpawnLocationZ() {
        return this.spawnLocationZ;
    }

    public final void setSpawnLocationZ(@Nullable Float f) {
        this.spawnLocationZ = f;
    }

    @Nullable
    public final Boolean getBlendedLevellingEnabled() {
        return this.blendedLevellingEnabled;
    }

    public final void setBlendedLevellingEnabled(@Nullable Boolean bl) {
        this.blendedLevellingEnabled = bl;
    }

    @Nullable
    public final Float getTransitionYheight() {
        return this.transitionYheight;
    }

    public final void setTransitionYheight(@Nullable Float f) {
        this.transitionYheight = f;
    }

    @Nullable
    public final Float getMultiplierPeriod() {
        return this.multiplierPeriod;
    }

    public final void setMultiplierPeriod(@Nullable Float f) {
        this.multiplierPeriod = f;
    }

    @Nullable
    public final Float getLvlMultiplier() {
        return this.lvlMultiplier;
    }

    public final void setLvlMultiplier(@Nullable Float f) {
        this.lvlMultiplier = f;
    }

    @Nullable
    public final Boolean getScaleDownward() {
        return this.scaleDownward;
    }

    public final void setScaleDownward(@Nullable Boolean bl) {
        this.scaleDownward = bl;
    }

    @Override
    @NotNull
    public StrategyType getStrategyType() {
        return this.strategyType;
    }

    @Override
    public float generateNumber(@NotNull LivingEntityWrapper lmEntity, int minLevel, int maxLevel) {
        float spawnDistanceAssignment;
        block15: {
            block14: {
                float increaseLevelDistance;
                float f;
                Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
                Location location = lmEntity.getWorld().getSpawnLocation();
                Intrinsics.checkNotNullExpressionValue(location, "getSpawnLocation(...)");
                Location spawnLocation = location;
                if (this.spawnLocationZ != null || this.spawnLocationX != null) {
                    double d;
                    double useX;
                    if (this.spawnLocationX == null) {
                        v1 = spawnLocation.getX();
                    } else {
                        Float f2 = this.spawnLocationX;
                        Intrinsics.checkNotNull(f2);
                        v1 = useX = (double)f2.floatValue();
                    }
                    if (this.spawnLocationZ == null) {
                        d = spawnLocation.getX();
                    } else {
                        Float f3 = this.spawnLocationZ;
                        Intrinsics.checkNotNull(f3);
                        d = f3.floatValue();
                    }
                    double useZ = d;
                    spawnLocation = new Location(lmEntity.getLivingEntity().getWorld(), useX, spawnLocation.getY(), useZ);
                }
                if (this.startDistance == null) {
                    f = 0.0f;
                } else {
                    Float f4 = this.startDistance;
                    Intrinsics.checkNotNull(f4);
                    f = f4.floatValue();
                }
                float startDistance = f;
                float distanceFromSpawn = (float)spawnLocation.distance(lmEntity.getLocation());
                float levelDistance = RangesKt.coerceAtLeast(distanceFromSpawn - startDistance, 0.0f);
                Integer variance = LevelledMobs.Companion.getInstance().getRulesManager().getRuleMaxRandomVariance(lmEntity);
                int varianceAdded = 0;
                if (variance != null) {
                    varianceAdded = ThreadLocalRandom.current().nextInt(0, variance + 1);
                }
                if (this.increaseLevelDistance == null) {
                    v7 = 1.0f;
                } else {
                    Float f5 = this.increaseLevelDistance;
                    Intrinsics.checkNotNull(f5);
                    v7 = increaseLevelDistance = f5.floatValue();
                }
                if (increaseLevelDistance == 0.0f) {
                    increaseLevelDistance = 1.0f;
                }
                spawnDistanceAssignment = levelDistance / increaseLevelDistance + (float)varianceAdded;
                if (this.blendedLevellingEnabled == null) break block14;
                Boolean bl = this.blendedLevellingEnabled;
                Intrinsics.checkNotNull(bl);
                if (bl.booleanValue()) break block15;
            }
            return spawnDistanceAssignment;
        }
        return this.generateBlendedLevel(lmEntity, spawnDistanceAssignment);
    }

    @Override
    public void mergeRule(@Nullable LevellingStrategy levellingStrategy) {
        if (levellingStrategy == null) {
            return;
        }
        if (levellingStrategy instanceof SpawnDistanceStrategy) {
            this.mergeSpawnDistanceStrategy((SpawnDistanceStrategy)levellingStrategy);
        }
    }

    private final void mergeSpawnDistanceStrategy(SpawnDistanceStrategy sds) {
        if (sds == null) {
            return;
        }
        try {
            Iterator<Field> iterator2 = ArrayIteratorKt.iterator(sds.getClass().getDeclaredFields());
            while (iterator2.hasNext()) {
                Field f = iterator2.next();
                if (!Modifier.isPublic(f.getModifiers()) || f.get(sds) == null) continue;
                this.getClass().getDeclaredField(f.getName()).set(this, f.get(sds));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public String toString() {
        block5: {
            block4: {
                sb = new StringBuilder();
                if (this.blendedLevellingEnabled == null) break block4;
                v0 = this.blendedLevellingEnabled;
                Intrinsics.checkNotNull(v0);
                if (!v0.booleanValue()) break block4;
                var2_2 = "blended, sd: %s, ild: %s, t_yHght: %s, mp: %s, lvlMlp: %s, scdown: %s";
                var3_4 = new Object[6];
                var3_4[0] = this.startDistance == null ? Integer.valueOf(0) : this.startDistance;
                var3_4[1] = this.increaseLevelDistance == null ? Integer.valueOf(0) : this.increaseLevelDistance;
                var3_4[2] = this.transitionYheight == null ? Integer.valueOf(0) : this.transitionYheight;
                var3_4[3] = this.multiplierPeriod == null ? Integer.valueOf(0) : this.multiplierPeriod;
                v1 = var3_4[4] = this.lvlMultiplier == null ? Double.valueOf(0.0) : this.lvlMultiplier;
                if (this.scaleDownward == null) ** GOTO lbl-1000
                v2 = this.scaleDownward;
                Intrinsics.checkNotNull(v2);
                if (v2.booleanValue()) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                var3_4[5] = v3;
                v4 = String.format(var2_2, Arrays.copyOf(var3_4, var3_4.length));
                Intrinsics.checkNotNullExpressionValue(v4, "format(...)");
                v5 = sb.append(v4);
                break block5;
            }
            var2_3 = "spawn distance, sd: %s, ild: %s";
            var3_5 = new Object[]{this.startDistance == null ? Integer.valueOf(0) : this.startDistance, this.increaseLevelDistance == null ? Integer.valueOf(0) : this.increaseLevelDistance};
            v6 = String.format(var2_3, Arrays.copyOf(var3_5, var3_5.length));
            Intrinsics.checkNotNullExpressionValue(v6, "format(...)");
            v5 = sb.append(v6);
        }
        if (this.spawnLocationX != null) {
            sb.append(" x: ");
            sb.append(this.spawnLocationX);
        }
        if (this.spawnLocationZ != null) {
            sb.append(" z: ");
            sb.append(this.spawnLocationZ);
        }
        v7 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(v7, "toString(...)");
        return v7;
    }

    /*
     * Unable to fully structure code
     */
    private final float generateBlendedLevel(LivingEntityWrapper lmEntity, float spawnDistanceLevelAssignment) {
        currentYPos = lmEntity.getLocation().getBlockY();
        result = 0.0f;
        if (this.transitionYheight == null) {
            v0 = 0.0f;
        } else {
            v1 = this.transitionYheight;
            Intrinsics.checkNotNull(v1);
            v0 = transitionYHeight = v1.floatValue();
        }
        if (this.multiplierPeriod == null) {
            v2 = 0.0f;
        } else {
            v3 = this.multiplierPeriod;
            Intrinsics.checkNotNull(v3);
            v2 = multiplierPeriod = v3.floatValue();
        }
        if (this.lvlMultiplier == null) {
            v4 = 0.0f;
        } else {
            v5 = this.lvlMultiplier;
            Intrinsics.checkNotNull(v5);
            v4 = lvlMultiplier = v5.floatValue();
        }
        if (this.scaleDownward == null) ** GOTO lbl-1000
        v6 = this.scaleDownward;
        Intrinsics.checkNotNull(v6);
        if (v6.booleanValue()) lbl-1000:
        // 2 sources

        {
            v7 = (transitionYHeight - currentYPos) / multiplierPeriod * lvlMultiplier * spawnDistanceLevelAssignment;
        } else {
            v7 = (transitionYHeight - currentYPos) / multiplierPeriod * (lvlMultiplier * -1.0f) * spawnDistanceLevelAssignment;
        }
        result = v7;
        result = (double)result < 0.0 ? (float)Math.ceil(result) + spawnDistanceLevelAssignment : (float)Math.floor(result) + spawnDistanceLevelAssignment;
        variance = LevelledMobs.Companion.getInstance().getRulesManager().getRuleMaxRandomVariance(lmEntity);
        if (variance != null && (float)variance.intValue() > 0.0f) {
            result += (float)ThreadLocalRandom.current().nextInt(0, variance + 1);
        }
        return result;
    }

    @Override
    @NotNull
    public SpawnDistanceStrategy cloneItem() {
        SpawnDistanceStrategy copy = null;
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.strategies.SpawnDistanceStrategy");
            copy = (SpawnDistanceStrategy)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SpawnDistanceStrategy spawnDistanceStrategy = copy;
        Intrinsics.checkNotNull(spawnDistanceStrategy);
        return spawnDistanceStrategy;
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }
}

