/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.rules.strategies;

import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.rules.strategies.LevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.StrategyType;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0016\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0007H\u0002J\u0018\u0010+\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0012\u0010,\u001a\u00020'2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010.\u001a\u00020\u0000H\u0016J\b\u0010/\u001a\u00020\u0007H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u001a\u0010\u0019\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000e\"\u0004\b\u001b\u0010\u0010R\u001a\u0010\u001c\u001a\u00020\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00060"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/strategies/RandomLevellingStrategy;", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/LevellingStrategy;", "", "<init>", "()V", "weightedRandom", "", "", "", "getWeightedRandom", "()Ljava/util/Map;", "doMerge", "", "getDoMerge", "()Z", "setDoMerge", "(Z)V", "randomArray", "", "[Ljava/lang/Integer;", "minLevel", "maxLevel", "autoGenerate", "getAutoGenerate", "setAutoGenerate", "enabled", "getEnabled", "setEnabled", "strategyType", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "getStrategyType", "()Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "setStrategyType", "(Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;)V", "generateNumber", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "populateWeightedRandom", "", "parseNumberRange", "", "range", "getRandomLevel", "mergeRule", "levellingStrategy", "cloneItem", "toString", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nRandomLevellingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RandomLevellingStrategy.kt\nio/github/arcaneplugins/levelledmobs/rules/strategies/RandomLevellingStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,206:1\n739#2,9:207\n37#3,2:216\n108#4:218\n80#4,22:219\n108#4:241\n80#4,22:242\n*S KotlinDebug\n*F\n+ 1 RandomLevellingStrategy.kt\nio/github/arcaneplugins/levelledmobs/rules/strategies/RandomLevellingStrategy\n*L\n148#1:207,9\n148#1:216,2\n153#1:218\n153#1:219,22\n154#1:241\n154#1:242,22\n*E\n"})
public final class RandomLevellingStrategy
implements LevellingStrategy,
Cloneable {
    @NotNull
    private final Map<String, Integer> weightedRandom = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
    private boolean doMerge;
    @Nullable
    private Integer[] randomArray;
    private int minLevel;
    private int maxLevel;
    private boolean autoGenerate;
    private boolean enabled = true;
    @NotNull
    private StrategyType strategyType = StrategyType.WEIGHTED_RANDOM;

    @NotNull
    public final Map<String, Integer> getWeightedRandom() {
        return this.weightedRandom;
    }

    public final boolean getDoMerge() {
        return this.doMerge;
    }

    public final void setDoMerge(boolean bl) {
        this.doMerge = bl;
    }

    public final boolean getAutoGenerate() {
        return this.autoGenerate;
    }

    public final void setAutoGenerate(boolean bl) {
        this.autoGenerate = bl;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    @NotNull
    public StrategyType getStrategyType() {
        return this.strategyType;
    }

    public void setStrategyType(@NotNull StrategyType strategyType) {
        Intrinsics.checkNotNullParameter((Object)strategyType, "<set-?>");
        this.strategyType = strategyType;
    }

    @Override
    public float generateNumber(@NotNull LivingEntityWrapper lmEntity, int minLevel, int maxLevel) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
                if (this.weightedRandom.isEmpty()) {
                    return this.getRandomLevel(minLevel, maxLevel);
                }
                if (this.randomArray == null || minLevel != this.minLevel || maxLevel != this.maxLevel) {
                    this.populateWeightedRandom(minLevel, maxLevel);
                }
                if (this.randomArray == null) {
                    return this.getRandomLevel(minLevel, maxLevel);
                }
                if (this.randomArray == null) break block6;
                Intrinsics.checkNotNull(this.randomArray);
                if (!(this.randomArray.length == 0)) break block7;
            }
            return 0.0f;
        }
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        Intrinsics.checkNotNull(this.randomArray);
        int useArrayNum = threadLocalRandom.nextInt(0, this.randomArray.length);
        Intrinsics.checkNotNull(this.randomArray);
        return this.randomArray[useArrayNum].intValue();
    }

    public final void populateWeightedRandom(int minLevel, int maxLevel) {
        int value;
        Integer[] range22;
        if (this.weightedRandom.isEmpty()) {
            Log.INSTANCE.inf("populateWeightedRandom weightedRandom was empty");
            this.autoGenerate = true;
            int i = minLevel;
            if (i <= maxLevel) {
                while (true) {
                    int test = maxLevel - i + 1;
                    Integer n = test;
                    this.weightedRandom.put(String.valueOf(i), n);
                    if (i == maxLevel) break;
                    ++i;
                }
            }
        }
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        int count = 0;
        List numbers = new ArrayList();
        List values2 = new ArrayList();
        List numbersUsed = new ArrayList();
        List origOverallNumberRange = new ArrayList();
        int i = minLevel;
        if (i <= maxLevel) {
            while (true) {
                origOverallNumberRange.add(i);
                if (i == maxLevel) break;
                ++i;
            }
        }
        List overallNumberRange = new LinkedList(origOverallNumberRange);
        block2: for (Map.Entry<String, Integer> entry : this.weightedRandom.entrySet()) {
            range22 = entry.getKey();
            value = ((Number)entry.getValue()).intValue();
            if (((CharSequence)range22).length() == 0) continue;
            int[] numRange = this.parseNumberRange((String)range22);
            if (numRange[0] == -1 && numRange[1] == -1) {
                Log.INSTANCE.war("Invalid number range for weighted random: " + (String)range22);
                continue;
            }
            int start = numRange[0] < 0 ? numRange[1] : numRange[0];
            int end = numRange[1] < 0 ? numRange[0] : numRange[1];
            int[] nArray = new int[]{start, end};
            numbers.add(nArray);
            values2.add(value);
            int i2 = start;
            if (i2 > end) continue;
            while (true) {
                if (origOverallNumberRange.contains(i2)) {
                    if (!numbersUsed.contains(i2)) {
                        numbersUsed.add(i2);
                    }
                    count += value;
                }
                if (i2 == end) continue block2;
                ++i2;
            }
        }
        count -= numbersUsed.size();
        int n = 0;
        int n2 = count += overallNumberRange.size();
        range22 = new Integer[n2];
        RandomLevellingStrategy randomLevellingStrategy = this;
        while (n < n2) {
            value = n++;
            range22[value] = 0;
        }
        randomLevellingStrategy.randomArray = range22;
        int newCount = 0;
        Iterator<Object> iterator2 = ((Iterable)numbers).iterator();
        int range22 = 0;
        block5: while (iterator2.hasNext()) {
            int n3;
            int valuesCount = range22++;
            int[] nums = (int[])iterator2.next();
            int i3 = nums[0];
            if (i3 > (n3 = nums[1])) continue;
            while (true) {
                if (origOverallNumberRange.contains(i3)) {
                    overallNumberRange.remove((Object)i3);
                    int n4 = ((Number)values2.get(valuesCount)).intValue();
                    for (int t = 0; t < n4; ++t) {
                        Intrinsics.checkNotNull(this.randomArray);
                        this.randomArray[newCount] = i3;
                        ++newCount;
                    }
                }
                if (i3 == n3) continue block5;
                ++i3;
            }
        }
        iterator2 = overallNumberRange.iterator();
        while (iterator2.hasNext()) {
            int number = ((Number)iterator2.next()).intValue();
            Intrinsics.checkNotNull(this.randomArray);
            this.randomArray[newCount] = number;
            ++newCount;
        }
    }

    private final int[] parseNumberRange(String range) {
        String string;
        boolean match$iv$iv;
        char it;
        int index$iv$iv;
        String $this$trim$iv;
        String $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        int[] nArray = new int[]{-1, -1};
        int[] results = nArray;
        if (!StringsKt.contains$default((CharSequence)range, "-", false, 2, null)) {
            if (!Utils.INSTANCE.isInteger(range)) {
                return results;
            }
            results[0] = Integer.parseInt(range);
            results[1] = results[0];
            return results;
        }
        Object object = range;
        Regex regex = new Regex("-");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it2 = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it2).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] nums = thisCollection$iv.toArray(new String[0]);
        if (nums.length < 2) {
            return results;
        }
        $this$toTypedArray$iv = nums[0];
        int n2 = 0;
        String[] stringArray = nums;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        stringArray[n2] = string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        $this$trim$iv = nums[1];
        n2 = 1;
        stringArray = nums;
        $i$f$trim = false;
        $this$trim$iv$iv = $this$trim$iv;
        $i$f$trim2 = false;
        startIndex$iv$iv = 0;
        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl3 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        stringArray[n2] = string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        if (((CharSequence)nums[0]).length() > 0 && Utils.INSTANCE.isInteger(nums[0])) {
            results[0] = Integer.parseInt(nums[0]);
        }
        if (((CharSequence)nums[1]).length() > 0 && Utils.INSTANCE.isInteger(nums[1])) {
            results[1] = Integer.parseInt(nums[1]);
        }
        return results;
    }

    private final int getRandomLevel(int minLevel, int maxLevel) {
        int useMinLevel = RangesKt.coerceAtLeast(minLevel, 0);
        int useMaxLevel = RangesKt.coerceAtLeast(maxLevel, useMinLevel);
        return ThreadLocalRandom.current().nextInt(useMinLevel, useMaxLevel + 1);
    }

    @Override
    public void mergeRule(@Nullable LevellingStrategy levellingStrategy) {
        if (!(levellingStrategy instanceof RandomLevellingStrategy)) {
            return;
        }
        if (((RandomLevellingStrategy)levellingStrategy).doMerge && ((RandomLevellingStrategy)levellingStrategy).enabled) {
            this.weightedRandom.putAll(((RandomLevellingStrategy)levellingStrategy).weightedRandom);
        }
    }

    @Override
    @NotNull
    public RandomLevellingStrategy cloneItem() {
        RandomLevellingStrategy copy = null;
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.strategies.RandomLevellingStrategy");
            copy = (RandomLevellingStrategy)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RandomLevellingStrategy randomLevellingStrategy = copy;
        Intrinsics.checkNotNull(randomLevellingStrategy);
        return randomLevellingStrategy;
    }

    @NotNull
    public String toString() {
        if (this.weightedRandom.isEmpty()) {
            return this.autoGenerate ? "Random Levelling (auto generate)" : "Random Levelling";
        }
        if (this.minLevel == 0) {
            return this.weightedRandom.toString();
        }
        return this.minLevel + "-" + this.maxLevel + ": " + this.weightedRandom;
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }
}

