/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.rules.strategies;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.managers.LevelManager;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.result.EvaluationResult;
import io.github.arcaneplugins.levelledmobs.rules.strategies.LevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.StrategyType;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u001c\u001a\u00020\u0001H\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\b\"\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0017\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\b\u00a8\u0006\u001e"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/strategies/CustomStrategy;", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/LevellingStrategy;", "", "customName", "", "<init>", "(Ljava/lang/String;)V", "getCustomName", "()Ljava/lang/String;", "formula", "getFormula", "setFormula", "strategyType", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "getStrategyType", "()Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "generateNumber", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "minLevel", "", "maxLevel", "placeholderName", "getPlaceholderName", "mergeRule", "", "levellingStrategy", "cloneItem", "toString", "levelledmobs-plugin"})
public final class CustomStrategy
implements LevellingStrategy,
Cloneable {
    @Nullable
    private final String customName;
    @Nullable
    private String formula;
    @NotNull
    private final StrategyType strategyType;

    public CustomStrategy(@Nullable String customName) {
        this.customName = customName;
        this.strategyType = StrategyType.CUSTOM;
    }

    @Nullable
    public final String getCustomName() {
        return this.customName;
    }

    @Nullable
    public final String getFormula() {
        return this.formula;
    }

    public final void setFormula(@Nullable String string) {
        this.formula = string;
    }

    @Override
    @NotNull
    public StrategyType getStrategyType() {
        return this.strategyType;
    }

    @Override
    public float generateNumber(@NotNull LivingEntityWrapper lmEntity, int minLevel, int maxLevel) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        CharSequence charSequence = this.formula;
        if (charSequence == null || charSequence.length() == 0) {
            DebugManager.Companion.log(DebugType.CUSTOM_STRATEGY, lmEntity, CustomStrategy::generateNumber$lambda$0);
            return 1.0f;
        }
        LevelManager levelManager = LevelledMobs.Companion.getInstance().getLevelManager();
        String string = this.formula;
        Intrinsics.checkNotNull(string);
        String useFormula = levelManager.replaceStringPlaceholdersForFormulas(string, lmEntity);
        EvaluationResult evalResult = MobDataManager.Companion.evaluateExpression(useFormula);
        double result = evalResult.getResult();
        DebugManager.Companion.log(DebugType.CUSTOM_STRATEGY, lmEntity, () -> CustomStrategy.generateNumber$lambda$1(this, useFormula, result));
        return (float)result;
    }

    @NotNull
    public final String getPlaceholderName() {
        CharSequence charSequence = this.customName;
        return charSequence == null || charSequence.length() == 0 ? "%custom%" : "%custom_" + this.customName + "%";
    }

    @Override
    public void mergeRule(@Nullable LevellingStrategy levellingStrategy) {
        if (!(levellingStrategy instanceof CustomStrategy)) {
            return;
        }
        this.formula = ((CustomStrategy)levellingStrategy).formula;
    }

    @Override
    @NotNull
    public LevellingStrategy cloneItem() {
        CustomStrategy copy = null;
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.strategies.CustomStrategy");
            copy = (CustomStrategy)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CustomStrategy customStrategy = copy;
        Intrinsics.checkNotNull(customStrategy, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.strategies.LevellingStrategy");
        return customStrategy;
    }

    @NotNull
    public String toString() {
        CharSequence charSequence = this.formula;
        return charSequence == null || charSequence.length() == 0 ? "(no formula)" : "'" + this.formula + "'";
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }

    private static final String generateNumber$lambda$0() {
        return "no formula supplied, using 1";
    }

    private static final String generateNumber$lambda$1(CustomStrategy this$0, String $useFormula, double $result) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($useFormula, "$useFormula");
        return "formulaPre: '" + this$0.formula + "', formulaPost: '" + $useFormula + "', result: " + $result;
    }
}

