/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.rules;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.LivingEntityInterface;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.MobCustomNameStatus;
import io.github.arcaneplugins.levelledmobs.enums.MobTamedStatus;
import io.github.arcaneplugins.levelledmobs.enums.NametagVisibilityEnum;
import io.github.arcaneplugins.levelledmobs.enums.VanillaBonusEnum;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.managers.WorldGuardIntegration;
import io.github.arcaneplugins.levelledmobs.misc.CachedModalList;
import io.github.arcaneplugins.levelledmobs.result.RuleCheckResult;
import io.github.arcaneplugins.levelledmobs.rules.ApplicableRulesResult;
import io.github.arcaneplugins.levelledmobs.rules.ChunkKillOptions;
import io.github.arcaneplugins.levelledmobs.rules.CustomDropsRuleSet;
import io.github.arcaneplugins.levelledmobs.rules.DeathMessages;
import io.github.arcaneplugins.levelledmobs.rules.FineTuningAttributes;
import io.github.arcaneplugins.levelledmobs.rules.HealthIndicator;
import io.github.arcaneplugins.levelledmobs.rules.LevelTierMatching;
import io.github.arcaneplugins.levelledmobs.rules.MergeableStringList;
import io.github.arcaneplugins.levelledmobs.rules.RuleInfo;
import io.github.arcaneplugins.levelledmobs.rules.TieredColoringInfo;
import io.github.arcaneplugins.levelledmobs.rules.WithinCoordinates;
import io.github.arcaneplugins.levelledmobs.rules.strategies.CustomStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.LevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.PlayerLevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.StrategyType;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.generator.structure.GeneratedStructure;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 |2\u00020\u0001:\u0001|B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010%\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010'J\u0010\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0006J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020-J\u0015\u00100\u001a\u0004\u0018\u0001012\u0006\u0010,\u001a\u00020-\u00a2\u0006\u0002\u00102J\u000e\u00103\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-J\u000e\u00104\u001a\u0002052\u0006\u0010,\u001a\u00020-J\u000e\u00106\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-J\u000e\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u000209J\u0010\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010,\u001a\u00020-J\u0016\u0010<\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010=2\u0006\u0010,\u001a\u00020-J\u0006\u0010>\u001a\u00020\u0018J\u000e\u0010?\u001a\u0002012\u0006\u0010,\u001a\u00020-J\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u00052\u0006\u0010,\u001a\u00020-J\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u00052\u0006\u0010,\u001a\u00020-J\u0010\u0010D\u001a\u0004\u0018\u00010\u000b2\u0006\u0010,\u001a\u00020-J\u000e\u0010E\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-J\u000e\u0010F\u001a\u00020G2\u0006\u0010,\u001a\u00020-J\u000e\u0010H\u001a\u00020I2\u0006\u0010,\u001a\u00020-J\u000e\u0010J\u001a\u0002012\u0006\u00108\u001a\u000209J\u000e\u0010K\u001a\u0002012\u0006\u00108\u001a\u000209J\u0010\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010,\u001a\u00020-J\u000e\u0010N\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-J\u0010\u0010O\u001a\u0004\u0018\u00010\u000b2\u0006\u0010,\u001a\u00020-J\u000e\u0010P\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-J\u0010\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010,\u001a\u00020-J\u0014\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u00052\u0006\u0010,\u001a\u00020-J\u000e\u0010U\u001a\u00020V2\u0006\u0010,\u001a\u00020-J\u0010\u0010W\u001a\u0004\u0018\u00010\u000b2\u0006\u0010,\u001a\u00020-J\u000e\u0010X\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-J\u0018\u0010Y\u001a\u0004\u0018\u00010\u000b2\u0006\u0010,\u001a\u00020-2\u0006\u0010Z\u001a\u00020\u0018J.\u0010[\u001a\u0004\u0018\u00010\\2\u001a\u0010]\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\\0\u0005\u0018\u00010\n2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010^\u001a\u0004\u0018\u00010_2\u0006\u0010,\u001a\u00020-J\u000e\u0010`\u001a\u0002012\u0006\u0010,\u001a\u00020-J\u0014\u0010a\u001a\b\u0012\u0004\u0012\u00020b0=2\u0006\u0010,\u001a\u00020-J\u000e\u0010c\u001a\u0002012\u0006\u0010,\u001a\u00020-J\u000e\u0010d\u001a\u0002012\u0006\u0010,\u001a\u00020-J\u000e\u0010e\u001a\u0002012\u0006\u0010,\u001a\u00020-J\u0010\u0010f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010,\u001a\u00020-J\u000e\u0010g\u001a\u00020h2\u0006\u00108\u001a\u000209J\u0018\u0010i\u001a\u00020)2\u0006\u0010j\u001a\u00020\u00062\u0006\u00108\u001a\u000209H\u0002J\u0018\u0010k\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020\u0006H\u0002J\u0018\u0010l\u001a\u00020\u00182\u0006\u0010,\u001a\u00020-2\u0006\u0010m\u001a\u00020\u0006H\u0002J\u0018\u0010n\u001a\u00020o2\u0006\u00108\u001a\u0002092\u0006\u0010*\u001a\u00020\u0006H\u0002J\u001e\u0010p\u001a\u00020\u00182\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\u000b0=2\u0006\u0010r\u001a\u00020sH\u0002J\"\u0010t\u001a\u00020)2\u001a\u0010u\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0014\u0018\u00010\nJ\u0006\u0010v\u001a\u00020)J\b\u0010w\u001a\u00020)H\u0002J\u000e\u0010x\u001a\u00020)2\u0006\u0010y\u001a\u00020zJ\u0006\u0010{\u001a\u00020)R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR#\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR#\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u0010\u0010 \u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006}"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/RulesManager;", "", "<init>", "()V", "rulesInEffect", "", "Lio/github/arcaneplugins/levelledmobs/rules/RuleInfo;", "getRulesInEffect", "()Ljava/util/List;", "ruleNameMappings", "", "", "getRuleNameMappings", "()Ljava/util/Map;", "biomeGroupMappings", "getBiomeGroupMappings", "rulesCooldown", "Ljava/time/Instant;", "getRulesCooldown", "allCustomStrategyPlaceholders", "", "getAllCustomStrategyPlaceholders", "()Ljava/util/Set;", "anyRuleHasChance", "", "getAnyRuleHasChance", "()Z", "setAnyRuleHasChance", "(Z)V", "hasAnyWGCondition", "getHasAnyWGCondition", "setHasAnyWGCondition", "lastRulesCheck", "value", "currentRulesHash", "getCurrentRulesHash", "()Ljava/lang/String;", "getRuleIsWorldAllowedInAnyRule", "world", "Lorg/bukkit/World;", "addCustomRule", "", "ri", "getRuleNbtData", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "getRuleSunlightBurnIntensity", "", "getRuleMaxRandomVariance", "", "(Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;)Ljava/lang/Integer;", "getRuleCheckIfNoDropMultiplierEntitiy", "getRuleUseCustomDropsForMob", "Lio/github/arcaneplugins/levelledmobs/rules/CustomDropsRuleSet;", "getRuleDoLockEntity", "getRuleIsMobAllowedInEntityOverride", "lmInterface", "Lio/github/arcaneplugins/levelledmobs/LivingEntityInterface;", "getFineTuningAttributes", "Lio/github/arcaneplugins/levelledmobs/rules/FineTuningAttributes;", "getRuleExternalPlugins", "Lio/github/arcaneplugins/levelledmobs/misc/CachedModalList;", "isPlayerLevellingEnabled", "getRuleCreeperMaxBlastRadius", "getRuleLevellingStrategies", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/LevellingStrategy;", "getRuleCustomStrategies", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/CustomStrategy;", "getRuleConstructLevel", "getRuleMobLevelInheritance", "getRuleMobCustomNameStatus", "Lio/github/arcaneplugins/levelledmobs/enums/MobCustomNameStatus;", "getRuleMobTamedStatus", "Lio/github/arcaneplugins/levelledmobs/enums/MobTamedStatus;", "getRuleMobMinLevel", "getRuleMobMaxLevel", "getRulePlayerLevellingOptions", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/PlayerLevellingStrategy;", "getRuleNametag", "getRuleNametagPlaceholder", "getRuleNametagCreatureDeath", "getRuleNametagIndicator", "Lio/github/arcaneplugins/levelledmobs/rules/HealthIndicator;", "getRuleCreatureNametagVisbility", "Lio/github/arcaneplugins/levelledmobs/enums/NametagVisibilityEnum;", "getRuleNametagVisibleTime", "", "getRuleTieredPlaceholder", "getRulePassengerMatchLevel", "getRuleEntityOverriddenName", "forceCustomName", "getEntityNameOverrideLevel", "Lio/github/arcaneplugins/levelledmobs/rules/LevelTierMatching;", "entityNameOverridesLevel", "getSpawnerParticle", "Lorg/bukkit/Particle;", "getSpawnerParticleCount", "getAllowedVanillaBonuses", "Lio/github/arcaneplugins/levelledmobs/enums/VanillaBonusEnum;", "getMaximumDeathInChunkThreshold", "getMaxChunkCooldownTime", "getAdjacentChunksToCheck", "getDeathMessage", "getApplicableRules", "Lio/github/arcaneplugins/levelledmobs/rules/ApplicableRulesResult;", "checkIfRuleShouldBeTempDisabled", "ruleInfo", "isRuleApplicableEntity", "meetsMaxDistanceCriteria", "rule", "isRuleApplicableInterface", "Lio/github/arcaneplugins/levelledmobs/result/RuleCheckResult;", "doesPlayerPassPermissionChecks", "perms", "player", "Lorg/bukkit/entity/Player;", "buildBiomeGroupMappings", "customBiomeGroups", "clearTempDisabledRulesCounts", "checkTempDisabledRules", "showTempDisabledRules", "sender", "Lorg/bukkit/command/CommandSender;", "updateRulesHash", "Companion", "levelledmobs-plugin"})
public final class RulesManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<RuleInfo> rulesInEffect = new ArrayList();
    @NotNull
    private final Map<String, RuleInfo> ruleNameMappings = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
    @NotNull
    private final Map<String, List<String>> biomeGroupMappings = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
    @NotNull
    private final Map<String, List<Instant>> rulesCooldown = new LinkedHashMap();
    @NotNull
    private final Set<String> allCustomStrategyPlaceholders = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
    private boolean anyRuleHasChance;
    private boolean hasAnyWGCondition;
    @Nullable
    private Instant lastRulesCheck;
    @NotNull
    private String currentRulesHash = "";
    private static RulesManager instance;
    @NotNull
    private static final Object ruleLocker;

    public RulesManager() {
        instance = this;
    }

    @NotNull
    public final List<RuleInfo> getRulesInEffect() {
        return this.rulesInEffect;
    }

    @NotNull
    public final Map<String, RuleInfo> getRuleNameMappings() {
        return this.ruleNameMappings;
    }

    @NotNull
    public final Map<String, List<String>> getBiomeGroupMappings() {
        return this.biomeGroupMappings;
    }

    @NotNull
    public final Map<String, List<Instant>> getRulesCooldown() {
        return this.rulesCooldown;
    }

    @NotNull
    public final Set<String> getAllCustomStrategyPlaceholders() {
        return this.allCustomStrategyPlaceholders;
    }

    public final boolean getAnyRuleHasChance() {
        return this.anyRuleHasChance;
    }

    public final void setAnyRuleHasChance(boolean bl) {
        this.anyRuleHasChance = bl;
    }

    public final boolean getHasAnyWGCondition() {
        return this.hasAnyWGCondition;
    }

    public final void setHasAnyWGCondition(boolean bl) {
        this.hasAnyWGCondition = bl;
    }

    @NotNull
    public final String getCurrentRulesHash() {
        return this.currentRulesHash;
    }

    public final boolean getRuleIsWorldAllowedInAnyRule(@Nullable World world) {
        if (world == null) {
            return false;
        }
        boolean result = false;
        for (RuleInfo ruleInfo : LevelledMobs.Companion.getInstance().getRulesParsingManager().getAllRules()) {
            if (!ruleInfo.getRuleIsEnabled() || ruleInfo.getConditionsWorlds() == null) continue;
            CachedModalList<String> cachedModalList = ruleInfo.getConditionsWorlds();
            Intrinsics.checkNotNull(cachedModalList);
            String string = world.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            if (!cachedModalList.isIncludedInList(string, null)) continue;
            result = true;
            break;
        }
        return result;
    }

    public final void addCustomRule(@Nullable RuleInfo ri) {
        if (ri == null) {
            return;
        }
        LevelledMobs.Companion.getInstance().getRulesParsingManager().getCustomRules().add(ri);
        LevelledMobs.Companion.getInstance().getRulesParsingManager().checkCustomRules();
    }

    @NotNull
    public final List<String> getRuleNbtData(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        List nbtData = new ArrayList();
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            MergeableStringList nbt;
            if (ruleInfo.getMobNBTData() == null) continue;
            MergeableStringList mergeableStringList = nbt = ruleInfo.getMobNBTData();
            Intrinsics.checkNotNull(mergeableStringList);
            if (!mergeableStringList.getDoMerge()) {
                nbtData.clear();
            }
            nbtData.addAll((Collection)nbt.getItems());
        }
        return nbtData;
    }

    public final double getRuleSunlightBurnIntensity(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        double result = 0.0;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getSunlightBurnAmount() == null) continue;
            Double d = ruleInfo.getSunlightBurnAmount();
            Intrinsics.checkNotNull(d);
            result = d;
        }
        return result;
    }

    @Nullable
    public final Integer getRuleMaxRandomVariance(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Integer result = null;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getMaxRandomVariance() == null) continue;
            result = ruleInfo.getMaxRandomVariance();
        }
        return result;
    }

    public final boolean getRuleCheckIfNoDropMultiplierEntitiy(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        CachedModalList<String> entitiesList = null;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getConditionsNoDropEntities() == null) continue;
            entitiesList = ruleInfo.getConditionsNoDropEntities();
        }
        return entitiesList != null && entitiesList.isIncludedInList(lmEntity.getNameIfBaby(), lmEntity);
    }

    @NotNull
    public final CustomDropsRuleSet getRuleUseCustomDropsForMob(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        CustomDropsRuleSet dropRules = new CustomDropsRuleSet();
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getCustomDropsUseForMobs() != null) {
                Boolean bl = ruleInfo.getCustomDropsUseForMobs();
                Intrinsics.checkNotNull(bl);
                dropRules.setUseDrops(bl);
            }
            if (ruleInfo.getChunkKillOptions() != null) {
                if (dropRules.getChunkKillOptions() == null) {
                    dropRules.setChunkKillOptions(ruleInfo.getChunkKillOptions());
                } else {
                    ChunkKillOptions chunkKillOptions = dropRules.getChunkKillOptions();
                    Intrinsics.checkNotNull(chunkKillOptions);
                    chunkKillOptions.merge(ruleInfo.getChunkKillOptions());
                }
            }
            dropRules.getUseDropTableIds().addAll((Collection<String>)ruleInfo.getCustomDropDropTableIds());
        }
        if (lmEntity.getLockedCustomDrops() != null) {
            List<String> list = lmEntity.getLockedCustomDrops();
            Intrinsics.checkNotNull(list);
            if (!((Collection)list).isEmpty()) {
                dropRules.getUseDropTableIds().clear();
                List<String> list2 = dropRules.getUseDropTableIds();
                List<String> list3 = lmEntity.getLockedCustomDrops();
                Intrinsics.checkNotNull(list3);
                list2.addAll((Collection<String>)list3);
                dropRules.setUseDrops(true);
            }
        }
        if (dropRules.getChunkKillOptions() == null) {
            dropRules.setChunkKillOptions(new ChunkKillOptions());
        }
        if (lmEntity.getHasLockedDropsOverride()) {
            ChunkKillOptions chunkKillOptions = dropRules.getChunkKillOptions();
            Intrinsics.checkNotNull(chunkKillOptions);
            chunkKillOptions.setDisableVanillaDrops(true);
        }
        return dropRules;
    }

    public final boolean getRuleDoLockEntity(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        boolean result = false;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getLockEntity() == null) continue;
            Boolean bl = ruleInfo.getLockEntity();
            Intrinsics.checkNotNull(bl);
            result = bl;
        }
        return result;
    }

    public final boolean getRuleIsMobAllowedInEntityOverride(@NotNull LivingEntityInterface lmInterface) {
        Intrinsics.checkNotNullParameter(lmInterface, "lmInterface");
        boolean babyMobsInheritAdultSetting = true;
        CachedModalList<String> allowedEntitiesList = null;
        for (RuleInfo ruleInfo : lmInterface.getApplicableRules()) {
            if (ruleInfo.getConditionsEntities() != null) {
                allowedEntitiesList = ruleInfo.getConditionsEntities();
            }
            if (ruleInfo.getBabyMobsInheritAdultSetting() == null) continue;
            Boolean bl = ruleInfo.getBabyMobsInheritAdultSetting();
            Intrinsics.checkNotNull(bl);
            babyMobsInheritAdultSetting = bl;
        }
        return lmInterface instanceof LivingEntityWrapper ? allowedEntitiesList == null || !babyMobsInheritAdultSetting && ((LivingEntityWrapper)lmInterface).isBabyMob() && Utils.INSTANCE.isLivingEntityInModalList(allowedEntitiesList, (LivingEntityWrapper)lmInterface, true) || Utils.INSTANCE.isLivingEntityInModalList(allowedEntitiesList, (LivingEntityWrapper)lmInterface, babyMobsInheritAdultSetting) : allowedEntitiesList == null || allowedEntitiesList.isIncludedInList(lmInterface.getTypeName(), null);
    }

    @Nullable
    public final FineTuningAttributes getFineTuningAttributes(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        FineTuningAttributes allMobAttribs = null;
        FineTuningAttributes thisMobAttribs = null;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            FineTuningAttributes tempAttribs;
            block13: {
                block12: {
                    if (ruleInfo.getAllMobMultipliers() != null) {
                        FineTuningAttributes multipliers;
                        Intrinsics.checkNotNull(ruleInfo.getAllMobMultipliers());
                        if (allMobAttribs == null || multipliers.getDoNotMerge()) {
                            Object object = multipliers.cloneItem();
                            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.FineTuningAttributes");
                            allMobAttribs = (FineTuningAttributes)object;
                            if (multipliers.getDoNotMerge()) {
                                thisMobAttribs = null;
                            }
                        } else {
                            allMobAttribs.merge(multipliers);
                        }
                    }
                    if (ruleInfo.getSpecificMobMultipliers() == null) continue;
                    Map<String, FineTuningAttributes> map = ruleInfo.getSpecificMobMultipliers();
                    Intrinsics.checkNotNull(map);
                    if (!map.containsKey(lmEntity.getNameIfBaby())) continue;
                    Map<String, FineTuningAttributes> map2 = ruleInfo.getSpecificMobMultipliers();
                    Intrinsics.checkNotNull(map2);
                    tempAttribs = map2.get(lmEntity.getNameIfBaby());
                    if (thisMobAttribs == null) break block12;
                    FineTuningAttributes fineTuningAttributes = tempAttribs;
                    Intrinsics.checkNotNull(fineTuningAttributes);
                    if (!fineTuningAttributes.getDoNotMerge()) break block13;
                }
                FineTuningAttributes fineTuningAttributes = tempAttribs;
                Intrinsics.checkNotNull(fineTuningAttributes);
                Object object = fineTuningAttributes.cloneItem();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.FineTuningAttributes");
                thisMobAttribs = (FineTuningAttributes)object;
                if (tempAttribs.getDoNotMerge()) {
                    allMobAttribs = null;
                    continue;
                }
                FineTuningAttributes fineTuningAttributes2 = allMobAttribs;
                if (fineTuningAttributes2 != null) {
                    fineTuningAttributes2.merge(thisMobAttribs);
                }
                continue;
            }
            thisMobAttribs.merge(tempAttribs);
        }
        if (allMobAttribs != null) {
            if (thisMobAttribs != null) {
                allMobAttribs.merge(thisMobAttribs);
            }
            return allMobAttribs;
        }
        return thisMobAttribs;
    }

    @Nullable
    public final CachedModalList<String> getRuleExternalPlugins(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        CachedModalList result = null;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getConditionsExternalPlugins() == null) continue;
            if (result != null) {
                CachedModalList<String> cachedModalList = ruleInfo.getConditionsExternalPlugins();
                Intrinsics.checkNotNull(cachedModalList);
                result.mergeCachedModal(cachedModalList);
                continue;
            }
            CachedModalList<String> cachedModalList = ruleInfo.getConditionsExternalPlugins();
            Intrinsics.checkNotNull(cachedModalList);
            Object object = cachedModalList.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.misc.CachedModalList<kotlin.String>");
            result = (CachedModalList)object;
        }
        return result;
    }

    public final boolean isPlayerLevellingEnabled() {
        for (RuleInfo ruleInfo : this.rulesInEffect) {
            if (!ruleInfo.getRuleIsEnabled() || !ruleInfo.getLevellingStrategy().containsKey((Object)StrategyType.PLAYER_VARIABLE)) continue;
            return true;
        }
        return false;
    }

    public final int getRuleCreeperMaxBlastRadius(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        int maxBlast = 5;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getCreeperMaxDamageRadius() == null) continue;
            Integer n = ruleInfo.getCreeperMaxDamageRadius();
            Intrinsics.checkNotNull(n);
            maxBlast = n;
        }
        return maxBlast;
    }

    @NotNull
    public final List<LevellingStrategy> getRuleLevellingStrategies(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Map strategies = new LinkedHashMap();
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            Map<StrategyType, LevellingStrategy> theseStrategies = ruleInfo.getLevellingStrategy();
            for (Map.Entry<StrategyType, LevellingStrategy> strategy : theseStrategies.entrySet()) {
                LevellingStrategy existingStrategy = (LevellingStrategy)strategies.get((Object)strategy.getKey());
                if (existingStrategy == null) {
                    strategies.put(strategy.getKey(), strategy.getValue().cloneItem());
                    continue;
                }
                Object v = strategies.get((Object)strategy.getKey());
                Intrinsics.checkNotNull(v);
                ((LevellingStrategy)v).mergeRule(strategy.getValue());
            }
        }
        return CollectionsKt.toMutableList(strategies.values());
    }

    @NotNull
    public final List<CustomStrategy> getRuleCustomStrategies(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        List results = new ArrayList();
        Map<String, CustomStrategy> strategies = null;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (!(!ruleInfo.getCustomStrategy().isEmpty())) continue;
            strategies = ruleInfo.getCustomStrategy();
        }
        if (strategies != null) {
            results.addAll(strategies.values());
        }
        return results;
    }

    @Nullable
    public final String getRuleConstructLevel(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        String result = null;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getConstructLevel() == null) continue;
            result = ruleInfo.getConstructLevel();
        }
        return result;
    }

    public final boolean getRuleMobLevelInheritance(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        boolean result = true;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getMobLevelInheritance() == null) continue;
            Boolean bl = ruleInfo.getMobLevelInheritance();
            Intrinsics.checkNotNull(bl);
            result = bl;
        }
        return result;
    }

    @NotNull
    public final MobCustomNameStatus getRuleMobCustomNameStatus(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        MobCustomNameStatus result = MobCustomNameStatus.NOT_SPECIFIED;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getConditionsMobCustomnameStatus() == MobCustomNameStatus.NOT_SPECIFIED) continue;
            result = ruleInfo.getConditionsMobCustomnameStatus();
        }
        return result;
    }

    @NotNull
    public final MobTamedStatus getRuleMobTamedStatus(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        MobTamedStatus result = MobTamedStatus.NOT_SPECIFIED;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getConditionsMobTamedStatus() == MobTamedStatus.NOT_SPECIFIED) continue;
            result = ruleInfo.getConditionsMobTamedStatus();
        }
        return result;
    }

    public final int getRuleMobMinLevel(@NotNull LivingEntityInterface lmInterface) {
        Intrinsics.checkNotNullParameter(lmInterface, "lmInterface");
        if (lmInterface.getSummonedLevel() != null) {
            Integer n = lmInterface.getSummonedLevel();
            Intrinsics.checkNotNull(n);
            return n;
        }
        int minLevel = 1;
        for (RuleInfo ruleInfo : lmInterface.getApplicableRules()) {
            if (ruleInfo.getRestrictionsMinLevel() == null) continue;
            Integer n = ruleInfo.getRestrictionsMinLevel();
            Intrinsics.checkNotNull(n);
            minLevel = n;
        }
        return minLevel;
    }

    public final int getRuleMobMaxLevel(@NotNull LivingEntityInterface lmInterface) {
        Intrinsics.checkNotNullParameter(lmInterface, "lmInterface");
        int maxLevel = 0;
        int firstMaxLevel = -1;
        for (RuleInfo ruleInfo : lmInterface.getApplicableRules()) {
            if (ruleInfo.getRestrictionsMaxLevel() == null) continue;
            Integer n = ruleInfo.getRestrictionsMaxLevel();
            Intrinsics.checkNotNull(n);
            maxLevel = n;
            if (firstMaxLevel >= 0 || maxLevel <= 0) continue;
            firstMaxLevel = maxLevel;
        }
        if (maxLevel <= 0 && lmInterface.getSummonedLevel() != null) {
            if (maxLevel == 0 && firstMaxLevel > 0) {
                maxLevel = firstMaxLevel;
            }
            Integer n = lmInterface.getSummonedLevel();
            Intrinsics.checkNotNull(n);
            int summonedLevel = n;
            if (summonedLevel > maxLevel) {
                maxLevel = summonedLevel;
            }
        }
        return maxLevel;
    }

    @Nullable
    public final PlayerLevellingStrategy getRulePlayerLevellingOptions(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        PlayerLevellingStrategy levellingOptions = null;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            LevellingStrategy thisPL;
            if (!ruleInfo.getLevellingStrategy().containsKey((Object)StrategyType.PLAYER_VARIABLE)) continue;
            Intrinsics.checkNotNull(ruleInfo.getLevellingStrategy().get((Object)StrategyType.PLAYER_VARIABLE));
            if (levellingOptions == null || !levellingOptions.getDoMerge()) {
                LevellingStrategy levellingStrategy = thisPL.cloneItem();
                Intrinsics.checkNotNull(levellingStrategy, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.strategies.PlayerLevellingStrategy");
                levellingOptions = (PlayerLevellingStrategy)levellingStrategy;
                continue;
            }
            levellingOptions.mergeRule(thisPL);
        }
        return levellingOptions;
    }

    @NotNull
    public final String getRuleNametag(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        String nametag = "";
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            String string;
            CharSequence charSequence = ruleInfo.getNametag();
            if (charSequence == null || charSequence.length() == 0) continue;
            if (StringsKt.equals("disabled", ruleInfo.getNametag(), true)) {
                string = "";
            } else {
                String string2 = ruleInfo.getNametag();
                string = string2;
                Intrinsics.checkNotNull(string2);
            }
            nametag = string;
        }
        return nametag;
    }

    @Nullable
    public final String getRuleNametagPlaceholder(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        String nametag = null;
        boolean isLevelled = lmEntity.isLevelled();
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            String nametagRule = isLevelled ? ruleInfo.getNametagPlaceholderLevelled() : ruleInfo.getNametagPlaceholderUnlevelled();
            if (nametagRule == null) continue;
            nametag = nametagRule;
        }
        return nametag;
    }

    @NotNull
    public final String getRuleNametagCreatureDeath(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        String nametag = "";
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            CharSequence charSequence = ruleInfo.getNametagCreatureDeath();
            if (charSequence == null || charSequence.length() == 0) continue;
            Intrinsics.checkNotNull(ruleInfo.getNametagCreatureDeath());
        }
        return nametag;
    }

    @Nullable
    public final HealthIndicator getRuleNametagIndicator(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        HealthIndicator indicator = null;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            block4: {
                block3: {
                    if (ruleInfo.getHealthIndicator() == null) continue;
                    if (indicator == null) break block3;
                    HealthIndicator healthIndicator = ruleInfo.getHealthIndicator();
                    Intrinsics.checkNotNull(healthIndicator);
                    if (healthIndicator.getDoMerge()) break block4;
                }
                HealthIndicator healthIndicator = ruleInfo.getHealthIndicator();
                Intrinsics.checkNotNull(healthIndicator);
                Object object = healthIndicator.cloneItem();
                Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.HealthIndicator");
                indicator = (HealthIndicator)object;
                continue;
            }
            HealthIndicator healthIndicator = ruleInfo.getHealthIndicator();
            Intrinsics.checkNotNull(healthIndicator);
            Object object = healthIndicator.cloneItem();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.HealthIndicator");
            indicator.merge((HealthIndicator)object);
        }
        return indicator;
    }

    @NotNull
    public final List<NametagVisibilityEnum> getRuleCreatureNametagVisbility(@NotNull LivingEntityWrapper lmEntity) {
        List<NametagVisibilityEnum> list;
        NametagVisibilityEnum[] nametagVisibilityEnumArray;
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        List<NametagVisibilityEnum> result = null;
        try {
            nametagVisibilityEnumArray = lmEntity.getApplicableRules().iterator();
            while (nametagVisibilityEnumArray.hasNext()) {
                RuleInfo ruleInfo = (RuleInfo)nametagVisibilityEnumArray.next();
                if (ruleInfo.getNametagVisibilityEnum() == null) continue;
                result = ruleInfo.getNametagVisibilityEnum();
            }
        }
        catch (ConcurrentModificationException e) {
            Log.INSTANCE.war("Got ConcurrentModificationException in getRule_CreatureNametagVisbility");
        }
        if ((nametagVisibilityEnumArray = (Collection)result) == null || nametagVisibilityEnumArray.isEmpty()) {
            nametagVisibilityEnumArray = new NametagVisibilityEnum[]{NametagVisibilityEnum.MELEE};
            list = CollectionsKt.mutableListOf(nametagVisibilityEnumArray);
        } else {
            list = result;
        }
        return list;
    }

    public final long getRuleNametagVisibleTime(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        long result = 4000L;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getNametagVisibleTime() == null) continue;
            Long l = ruleInfo.getNametagVisibleTime();
            Intrinsics.checkNotNull(l);
            result = l;
        }
        return result;
    }

    @Nullable
    public final String getRuleTieredPlaceholder(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        List<TieredColoringInfo> coloringInfo = null;
        String tieredText = null;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getTieredColoringInfos() == null) continue;
            coloringInfo = ruleInfo.getTieredColoringInfos();
        }
        if (coloringInfo == null) {
            return null;
        }
        int mobLevel = lmEntity.getGetMobLevel();
        for (TieredColoringInfo info : coloringInfo) {
            if (info.isDefault()) {
                tieredText = info.getText();
            }
            if (mobLevel < info.getMinLevel() || mobLevel > info.getMaxLevel()) continue;
            tieredText = info.getText();
            break;
        }
        return tieredText;
    }

    public final boolean getRulePassengerMatchLevel(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        boolean result = false;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getPassengerMatchLevel() == null) continue;
            Boolean bl = ruleInfo.getPassengerMatchLevel();
            Intrinsics.checkNotNull(bl);
            result = bl;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final String getRuleEntityOverriddenName(@NotNull LivingEntityWrapper lmEntity, boolean forceCustomName) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        entityNameOverridesLevel = null;
        entityNameOverrides = null;
        if (lmEntity.getHasOverridenEntityName()) {
            return lmEntity.getOverridenEntityName();
        }
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getMergeEntityNameOverrides() == null) ** GOTO lbl-1000
            v0 = ruleInfo.getMergeEntityNameOverrides();
            Intrinsics.checkNotNull(v0);
            if (v0.booleanValue()) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = doMerge = false;
            }
            if (ruleInfo.getEntityNameOverrides() != null) {
                if (entityNameOverrides != null && doMerge) {
                    v2 = ruleInfo.getEntityNameOverrides();
                    Intrinsics.checkNotNull(v2);
                    entityNameOverrides.putAll(v2);
                } else {
                    entityNameOverrides = ruleInfo.getEntityNameOverrides();
                }
            }
            if (ruleInfo.getEntityNameOverridesLevel() == null) continue;
            if (entityNameOverridesLevel != null && doMerge) {
                v3 = ruleInfo.getEntityNameOverridesLevel();
                Intrinsics.checkNotNull(v3);
                entityNameOverridesLevel.putAll(v3);
                continue;
            }
            entityNameOverridesLevel = ruleInfo.getEntityNameOverridesLevel();
        }
        if (entityNameOverrides == null && entityNameOverridesLevel == null) {
            return null;
        }
        namesInfo = null;
        matchedTiers = this.getEntityNameOverrideLevel(entityNameOverridesLevel, lmEntity);
        if (matchedTiers != null) {
            namesInfo = matchedTiers.getNames();
        } else if (entityNameOverrides != null) {
            if (entityNameOverrides.containsKey("all_entities")) {
                v4 = entityNameOverrides.get("all_entities");
                Intrinsics.checkNotNull(v4);
                namesInfo = v4.getNames();
            } else if (entityNameOverrides.containsKey(lmEntity.getTypeName())) {
                v5 = entityNameOverrides.get(lmEntity.getTypeName());
                Intrinsics.checkNotNull(v5);
                namesInfo = v5.getNames();
            }
        }
        doMerge = namesInfo;
        if (doMerge == null || doMerge.isEmpty() != false) {
            return null;
        }
        if (namesInfo.size() > 1) {
            Collections.shuffle(namesInfo);
        }
        var8_9 = lmEntity.getTypeName();
        var9_10 = new Regex("_");
        var10_11 = " ";
        entityName = Utils.INSTANCE.capitalize(var9_10.replace(var8_9, var10_11));
        result = namesInfo.get(0);
        result = StringsKt.replace$default(result, "%entity-name%", entityName, false, 4, null);
        v6 = lmEntity.getLivingEntity().getCustomName() == null || forceCustomName != false ? entityName : lmEntity.getLivingEntity().getCustomName();
        Intrinsics.checkNotNull(v6);
        result = StringsKt.replace$default(result, "%displayname%", v6, false, 4, null);
        if (namesInfo.size() > 1) {
            lmEntity.setOverridenEntityName(result);
        }
        return result;
    }

    private final LevelTierMatching getEntityNameOverrideLevel(Map<String, List<LevelTierMatching>> entityNameOverridesLevel, LivingEntityWrapper lmEntity) {
        if (entityNameOverridesLevel == null) {
            return null;
        }
        LevelTierMatching allEntities = null;
        LevelTierMatching thisMob = null;
        for (List<LevelTierMatching> tiers : entityNameOverridesLevel.values()) {
            for (LevelTierMatching tier : tiers) {
                if (!tier.isApplicableToMobLevel(lmEntity.getGetMobLevel())) continue;
                if (StringsKt.equals("all_entities", tier.getMobName(), true) && tier.isApplicableToMobLevel(lmEntity.getGetMobLevel())) {
                    allEntities = tier;
                    continue;
                }
                if (!StringsKt.equals(lmEntity.getNameIfBaby(), tier.getMobName(), true) || !tier.isApplicableToMobLevel(lmEntity.getGetMobLevel())) continue;
                thisMob = tier;
            }
        }
        LevelTierMatching levelTierMatching = thisMob;
        if (levelTierMatching == null) {
            levelTierMatching = allEntities;
        }
        return levelTierMatching;
    }

    @Nullable
    public final Particle getSpawnerParticle(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Particle result = Particle.SOUL;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getSpawnerParticle() != null) {
                result = ruleInfo.getSpawnerParticle();
                continue;
            }
            if (!ruleInfo.getUseNoSpawnerParticles()) continue;
            result = null;
        }
        return result;
    }

    public final int getSpawnerParticleCount(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        int result = 10;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getSpawnerParticlesCount() == null) continue;
            Integer n = ruleInfo.getSpawnerParticlesCount();
            Intrinsics.checkNotNull(n);
            result = n;
        }
        if (result > 100) {
            result = 100;
        }
        return result;
    }

    @NotNull
    public final CachedModalList<VanillaBonusEnum> getAllowedVanillaBonuses(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        CachedModalList<Object> result = null;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getVanillaBonuses() == null) continue;
            result = ruleInfo.getVanillaBonuses();
        }
        CachedModalList cachedModalList = result;
        if (cachedModalList == null) {
            cachedModalList = new CachedModalList();
        }
        return cachedModalList;
    }

    public final int getMaximumDeathInChunkThreshold(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        int result = 0;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getMaximumDeathInChunkThreshold() == null) continue;
            Integer n = ruleInfo.getMaximumDeathInChunkThreshold();
            Intrinsics.checkNotNull(n);
            result = n;
        }
        return result;
    }

    public final int getMaxChunkCooldownTime(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        int result = 0;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getChunkMaxCoolDownTime() == null) continue;
            Integer n = ruleInfo.getChunkMaxCoolDownTime();
            Intrinsics.checkNotNull(n);
            result = n;
        }
        return result;
    }

    public final int getAdjacentChunksToCheck(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        int result = 0;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getMaxAdjacentChunks() == null) continue;
            Integer n = ruleInfo.getMaxAdjacentChunks();
            Intrinsics.checkNotNull(n);
            result = n;
        }
        return result;
    }

    @Nullable
    public final String getDeathMessage(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        DeathMessages deathMessages = null;
        for (RuleInfo ruleInfo : lmEntity.getApplicableRules()) {
            if (ruleInfo.getDeathMessages() == null) continue;
            deathMessages = ruleInfo.getDeathMessages();
        }
        DeathMessages deathMessages2 = deathMessages;
        return deathMessages2 != null ? deathMessages2.getDeathMessage() : null;
    }

    @NotNull
    public final ApplicableRulesResult getApplicableRules(@NotNull LivingEntityInterface lmInterface) {
        Intrinsics.checkNotNullParameter(lmInterface, "lmInterface");
        ApplicableRulesResult applicableRules = new ApplicableRulesResult();
        if (this.lastRulesCheck == null || Duration.between(this.lastRulesCheck, Instant.now()).toMillis() > 100L) {
            this.checkTempDisabledRules();
            this.lastRulesCheck = Instant.now();
        }
        for (RuleInfo ruleInfo : this.rulesInEffect) {
            if (!ruleInfo.getRuleIsEnabled() || ruleInfo.isTempDisabled() || lmInterface instanceof LivingEntityWrapper && !this.isRuleApplicableEntity((LivingEntityWrapper)lmInterface, ruleInfo)) continue;
            RuleCheckResult checkResult = this.isRuleApplicableInterface(lmInterface, ruleInfo);
            if (!checkResult.getUseResult()) {
                if (checkResult.getRuleMadeChance() == null) continue;
                Boolean bl = checkResult.getRuleMadeChance();
                Intrinsics.checkNotNull(bl);
                if (bl.booleanValue()) continue;
                applicableRules.getAllApplicableRulesDidNotMakeChance().add(ruleInfo);
                continue;
            }
            if (checkResult.getRuleMadeChance() != null) {
                Boolean bl = checkResult.getRuleMadeChance();
                Intrinsics.checkNotNull(bl);
                if (bl.booleanValue()) {
                    applicableRules.getAllApplicableRulesMadeChance().add(ruleInfo);
                }
            }
            applicableRules.getAllApplicableRules().add(ruleInfo);
            this.checkIfRuleShouldBeTempDisabled(ruleInfo, lmInterface);
            if (ruleInfo.getStopProcessingRules() == null) continue;
            Boolean bl = ruleInfo.getStopProcessingRules();
            Intrinsics.checkNotNull(bl);
            boolean result = bl;
            DebugManager.Companion.log(DebugType.SETTING_STOP_PROCESSING, ruleInfo, lmInterface, result, () -> RulesManager.getApplicableRules$lambda$0(applicableRules));
            if (!result) continue;
        }
        boolean hasWorldListSpecified = false;
        for (RuleInfo ri : applicableRules.getAllApplicableRules()) {
            if (ri.getConditionsWorlds() == null) continue;
            CachedModalList<String> cachedModalList = ri.getConditionsWorlds();
            Intrinsics.checkNotNull(cachedModalList);
            if (cachedModalList.isEmpty()) {
                CachedModalList<String> cachedModalList2 = ri.getConditionsWorlds();
                Intrinsics.checkNotNull(cachedModalList2);
                if (!cachedModalList2.getIncludeAll()) continue;
            }
            hasWorldListSpecified = true;
            break;
        }
        return hasWorldListSpecified ? applicableRules : new ApplicableRulesResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkIfRuleShouldBeTempDisabled(RuleInfo ruleInfo, LivingEntityInterface lmInterface) {
        if (!(lmInterface instanceof LivingEntityWrapper)) {
            return;
        }
        if (!((LivingEntityWrapper)lmInterface).isNewlySpawned() && !((LivingEntityWrapper)lmInterface).isRulesForceAll()) {
            return;
        }
        Object object = ruleLocker;
        synchronized (object) {
            block10: {
                block12: {
                    block11: {
                        block9: {
                            List<Instant> instants;
                            boolean bl = false;
                            if (!this.rulesCooldown.containsKey(ruleInfo.getRuleName$levelledmobs_plugin())) {
                                this.rulesCooldown.put(ruleInfo.getRuleName$levelledmobs_plugin(), new ArrayList());
                            }
                            List<Instant> list = instants = this.rulesCooldown.get(ruleInfo.getRuleName$levelledmobs_plugin());
                            Intrinsics.checkNotNull(list);
                            Instant instant = Instant.now();
                            Intrinsics.checkNotNullExpressionValue(instant, "now(...)");
                            list.add(instant);
                            if (ruleInfo.getConditionsTimesToCooldownActivation() == null) break block9;
                            int n = instants.size();
                            Integer n2 = ruleInfo.getConditionsTimesToCooldownActivation();
                            Intrinsics.checkNotNull(n2);
                            if (n < n2) break block10;
                        }
                        if (ruleInfo.getConditionsCooldownTime() == null) break block11;
                        Long l = ruleInfo.getConditionsCooldownTime();
                        Intrinsics.checkNotNull(l);
                        if (l > 0L) break block12;
                    }
                    return;
                }
                DebugManager.Companion.log(DebugType.SETTING_COOLDOWN, ruleInfo, lmInterface, true, RulesManager::checkIfRuleShouldBeTempDisabled$lambda$2$lambda$1);
                ruleInfo.setTempDisabled(true);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isRuleApplicableEntity(LivingEntityWrapper lmEntity, RuleInfo ri) {
        block42: {
            block41: {
                block40: {
                    if (ri.getConditionsMinLevel() == null) break block40;
                    if (!lmEntity.isLevelled()) ** GOTO lbl-1000
                    v0 = lmEntity.getGetMobLevel();
                    v1 = ri.getConditionsMinLevel();
                    Intrinsics.checkNotNull(v1);
                    if (v0 >= v1) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    result = v2;
                    DebugManager.Companion.log(DebugType.CONDITION_MAXLEVEL, ri, lmEntity, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$3(io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper io.github.arcaneplugins.levelledmobs.rules.RuleInfo ), ()Ljava/lang/String;)((LivingEntityWrapper)lmEntity, (RuleInfo)ri));
                    if (!result) {
                        return false;
                    }
                }
                if (ri.getConditionsMaxLevel() == null) break block41;
                if (!lmEntity.isLevelled()) ** GOTO lbl-1000
                v3 = lmEntity.getGetMobLevel();
                v4 = ri.getConditionsMaxLevel();
                Intrinsics.checkNotNull(v4);
                if (v3 <= v4) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                result = v5;
                DebugManager.Companion.log(DebugType.CONDITION_MAXLEVEL, ri, lmEntity, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$4(io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper io.github.arcaneplugins.levelledmobs.rules.RuleInfo ), ()Ljava/lang/String;)((LivingEntityWrapper)lmEntity, (RuleInfo)ri));
                if (!result) {
                    return false;
                }
            }
            if (ri.getConditionsWithinCoords() != null) {
                v6 = ri.getConditionsWithinCoords();
                Intrinsics.checkNotNull(v6);
                if (!v6.isEmpty() && !this.meetsMaxDistanceCriteria(lmEntity, ri)) {
                    return false;
                }
            }
            if (ri.getConditionsCustomNames() != null) {
                if (lmEntity.getLivingEntity().getCustomName() != null) {
                    v7 = lmEntity.getLivingEntity().getCustomName();
                    Intrinsics.checkNotNull(v7);
                    v8 = StringsKt.replace$default(v7, "\u00a7", "&", false, 4, null);
                } else {
                    v8 = "(none)";
                }
                customName = v8;
                v9 = ri.getConditionsCustomNames();
                Intrinsics.checkNotNull(v9);
                result = v9.isIncludedInList(customName, lmEntity);
                DebugManager.Companion.log(DebugType.CONDITION_CUSTOM_NAME, ri, lmEntity, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$5(java.lang.String ), ()Ljava/lang/String;)((String)customName));
                if (!result) {
                    return false;
                }
            }
            if (ri.getConditionsSpawnReasons() != null) {
                v10 = ri.getConditionsSpawnReasons();
                Intrinsics.checkNotNull(v10);
                result = v10.isIncludedInList(lmEntity.getSpawnReason(), lmEntity);
                DebugManager.Companion.log(DebugType.CONDITION_SPAWN_REASON, ri, lmEntity, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$6(io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper ), ()Ljava/lang/String;)((LivingEntityWrapper)lmEntity));
                if (!result) {
                    return false;
                }
            }
            if (ri.getConditionsExternalPlugins() != null) {
                ExternalCompatibilityManager.Companion.updateAllExternalCompats(lmEntity);
                mobCompats = lmEntity.getMobExternalTypes();
                madeIt = false;
                for (String compat : mobCompats) {
                    v11 = ri.getConditionsExternalPlugins();
                    Intrinsics.checkNotNull(v11);
                    if (!v11.isIncludedInList(compat, lmEntity)) continue;
                    madeIt = true;
                    break;
                }
                DebugManager.Companion.log(DebugType.CONDITION_PLUGIN_COMPAT, ri, lmEntity, madeIt, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$7(java.util.Set ), ()Ljava/lang/String;)(mobCompats));
                if (!madeIt) {
                    return false;
                }
            }
            if (ri.getConditionsMMnames() != null) {
                mmName = ExternalCompatibilityManager.Companion.getMythicMobInternalName(lmEntity);
                if (((CharSequence)mmName).length() == 0) {
                    mmName = "(none)";
                }
                v12 = ri.getConditionsMMnames();
                Intrinsics.checkNotNull(v12);
                result = v12.isIncludedInList(mmName, lmEntity);
                mmNameFinal = mmName;
                DebugManager.Companion.log(DebugType.CONDITION_MYTHICMOBS_INTERNAL_NAME, ri, lmEntity, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$8(java.lang.String ), ()Ljava/lang/String;)((String)mmNameFinal));
                if (!result) {
                    return false;
                }
            }
            if (ri.getConditionsSpawnerNames() != null) {
                checkName = lmEntity.getSourceSpawnerName() != null ? lmEntity.getSourceSpawnerName() : "(none)";
                v13 = ri.getConditionsSpawnerNames();
                Intrinsics.checkNotNull(v13);
                v14 = checkName;
                Intrinsics.checkNotNull(v14);
                result = v13.isIncludedInList(v14, lmEntity);
                DebugManager.Companion.log(DebugType.CONDITION_SPAWNER_NAME, ri, lmEntity, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$9(java.lang.String ), ()Ljava/lang/String;)((String)checkName));
                if (!result) {
                    return false;
                }
            }
            if (ri.getConditionsSpawnegEggNames() != null) {
                checkName = lmEntity.getSourceSpawnEggName() != null ? lmEntity.getSourceSpawnEggName() : "(none)";
                v15 = ri.getConditionsSpawnegEggNames();
                Intrinsics.checkNotNull(v15);
                v16 = checkName;
                Intrinsics.checkNotNull(v16);
                result = v15.isIncludedInList(v16, lmEntity);
                DebugManager.Companion.log(DebugType.CONDITION_SPAWNER_NAME, ri, lmEntity, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$10(java.lang.String ), ()Ljava/lang/String;)((String)checkName));
                if (!result) {
                    return false;
                }
            }
            if (ri.getConditionsPermission() != null) {
                if (lmEntity.getAssociatedPlayer() == null) {
                    DebugManager.Companion.log(DebugType.CONDITION_PERMISSION, ri, lmEntity, false, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$11(), ()Ljava/lang/String;)());
                    return false;
                }
                v17 = ri.getConditionsPermission();
                Intrinsics.checkNotNull(v17);
                v18 = lmEntity.getAssociatedPlayer();
                Intrinsics.checkNotNull(v18);
                if (!this.doesPlayerPassPermissionChecks(v17, v18)) {
                    DebugManager.Companion.log(DebugType.CONDITION_PERMISSION, ri, lmEntity, false, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$12(io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper ), ()Ljava/lang/String;)((LivingEntityWrapper)lmEntity));
                    return false;
                }
                DebugManager.Companion.log(DebugType.CONDITION_PERMISSION, ri, lmEntity, true, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$13(io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper ), ()Ljava/lang/String;)((LivingEntityWrapper)lmEntity));
            }
            if (ri.getConditionsMobCustomnameStatus() != MobCustomNameStatus.NOT_SPECIFIED && ri.getConditionsMobCustomnameStatus() != MobCustomNameStatus.EITHER) {
                v19 = hasCustomName = lmEntity.getLivingEntity().getCustomName() != null;
                if (hasCustomName && ri.getConditionsMobCustomnameStatus() == MobCustomNameStatus.NOT_NAMETAGGED || !hasCustomName && ri.getConditionsMobCustomnameStatus() == MobCustomNameStatus.NAMETAGGED) {
                    DebugManager.Companion.log(DebugType.CONDITION_CUSTOM_NAME, ri, lmEntity, false, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$14(io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper ), ()Ljava/lang/String;)((LivingEntityWrapper)lmEntity));
                    return false;
                }
                DebugManager.Companion.log(DebugType.CONDITION_CUSTOM_NAME, ri, lmEntity, true, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$15(io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper ), ()Ljava/lang/String;)((LivingEntityWrapper)lmEntity));
            }
            if (ri.getConditionsMobTamedStatus() != MobTamedStatus.NOT_SPECIFIED && ri.getConditionsMobTamedStatus() != MobTamedStatus.EITHER) {
                if (lmEntity.isMobTamed() && ri.getConditionsMobTamedStatus() == MobTamedStatus.NOT_TAMED || !lmEntity.isMobTamed() && ri.getConditionsMobTamedStatus() == MobTamedStatus.TAMED) {
                    DebugManager.Companion.log(DebugType.ENTITY_TAME, ri, lmEntity, false, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$16(io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper ), ()Ljava/lang/String;)((LivingEntityWrapper)lmEntity));
                    return false;
                }
                DebugManager.Companion.log(DebugType.ENTITY_TAME, ri, lmEntity, true, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$17(io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper ), ()Ljava/lang/String;)((LivingEntityWrapper)lmEntity));
            }
            if (ri.getConditionsScoreboardTags() != null) {
                v20 = lmEntity.getLivingEntity().getScoreboardTags();
                Intrinsics.checkNotNullExpressionValue(v20, "getScoreboardTags(...)");
                tags = v20;
                if (tags.isEmpty()) {
                    tags.add("(none)");
                }
                madeCriteria = false;
                for (String tag : tags) {
                    v21 = ri.getConditionsScoreboardTags();
                    Intrinsics.checkNotNull(v21);
                    Intrinsics.checkNotNull(tag);
                    if (!v21.isIncludedInList(tag, lmEntity)) continue;
                    madeCriteria = true;
                }
                DebugManager.Companion.log(DebugType.SCOREBOARD_TAGS, ri, lmEntity, madeCriteria, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$18(), ()Ljava/lang/String;)());
                if (!madeCriteria) {
                    return false;
                }
            }
            if (ri.getConditionsStructure() != null) {
                v22 = lmEntity.getLocation().getChunk().getStructures();
                Intrinsics.checkNotNullExpressionValue(v22, "getStructures(...)");
                structures = v22;
                madeCriteria = false;
                for (GeneratedStructure structure : structures) {
                    v23 = ri.getConditionsStructure();
                    Intrinsics.checkNotNull(v23);
                    v24 = structure.getStructure();
                    Intrinsics.checkNotNullExpressionValue(v24, "getStructure(...)");
                    if (!v23.isIncludedInList(v24, lmEntity)) continue;
                    madeCriteria = true;
                    break;
                }
                DebugManager.Companion.log(DebugType.CONDITION_STRUCTURES, ri, lmEntity, madeCriteria, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$19(), ()Ljava/lang/String;)());
                if (!madeCriteria) {
                    return false;
                }
            }
            if (ri.getConditionsSkyLightLevel() == null) break block42;
            lightLevel = lmEntity.getSkylightLevel();
            v25 = lightLevel;
            v26 = ri.getConditionsSkyLightLevel();
            Intrinsics.checkNotNull(v26);
            if (!(v25 >= v26.getMin())) ** GOTO lbl-1000
            v27 = lightLevel;
            v28 = ri.getConditionsSkyLightLevel();
            Intrinsics.checkNotNull(v28);
            if (v27 <= v28.getMax()) {
                v29 = true;
            } else lbl-1000:
            // 2 sources

            {
                v29 = false;
            }
            result = v29;
            DebugManager.Companion.log(DebugType.SKYLIGHT_LEVEL, ri, lmEntity, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableEntity$lambda$20(int io.github.arcaneplugins.levelledmobs.rules.RuleInfo ), ()Ljava/lang/String;)((int)lightLevel, (RuleInfo)ri));
            return result;
        }
        return true;
    }

    private final boolean meetsMaxDistanceCriteria(LivingEntityWrapper lmEntity, RuleInfo rule) {
        WithinCoordinates withinCoordinates = rule.getConditionsWithinCoords();
        Intrinsics.checkNotNull(withinCoordinates);
        WithinCoordinates mdr = withinCoordinates;
        if (mdr.getGetHasX() && !mdr.isLocationWithinRange(lmEntity.getLocation().getBlockX(), WithinCoordinates.Axis.X)) {
            DebugManager.Companion.log(DebugType.CONDITION_WITH_COORDINATES, rule, lmEntity, false, () -> RulesManager.meetsMaxDistanceCriteria$lambda$21(lmEntity, mdr));
            return false;
        }
        if (mdr.getGetHasY() && !mdr.isLocationWithinRange(lmEntity.getLocation().getBlockY(), WithinCoordinates.Axis.Y)) {
            DebugManager.Companion.log(DebugType.CONDITION_WITH_COORDINATES, rule, lmEntity, false, () -> RulesManager.meetsMaxDistanceCriteria$lambda$22(lmEntity, mdr));
            return false;
        }
        if (mdr.getGetHasZ() && !mdr.isLocationWithinRange(lmEntity.getLocation().getBlockZ(), WithinCoordinates.Axis.Z)) {
            DebugManager.Companion.log(DebugType.CONDITION_WITH_COORDINATES, rule, lmEntity, false, () -> RulesManager.meetsMaxDistanceCriteria$lambda$23(lmEntity, mdr));
            return false;
        }
        DebugManager.Companion.log(DebugType.CONDITION_WITH_COORDINATES, rule, lmEntity, true, () -> RulesManager.meetsMaxDistanceCriteria$lambda$24(lmEntity, mdr));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final RuleCheckResult isRuleApplicableInterface(LivingEntityInterface lmInterface, RuleInfo ri) {
        block32: {
            if (ri.getConditionsEntities() != null) {
                if (lmInterface instanceof LivingEntityWrapper) {
                    v0 = ri.getConditionsEntities();
                    Intrinsics.checkNotNull(v0);
                    result = Utils.INSTANCE.isLivingEntityInModalList(v0, (LivingEntityWrapper)lmInterface, true);
                    DebugManager.Companion.log(DebugType.CONDITION_ENTITIES_LIST, ri, lmInterface, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableInterface$lambda$25(), ()Ljava/lang/String;)());
                    if (!result) {
                        return new RuleCheckResult(false);
                    }
                } else {
                    v1 = ri.getConditionsEntities();
                    Intrinsics.checkNotNull(v1);
                    result = v1.isIncludedInList(lmInterface.getTypeName(), null);
                    DebugManager.Companion.log(DebugType.CONDITION_ENTITIES_LIST, ri, lmInterface, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableInterface$lambda$26(), ()Ljava/lang/String;)());
                    if (!result) {
                        return new RuleCheckResult(false);
                    }
                }
            }
            if (ri.getConditionsWorlds() == null) break block32;
            if (lmInterface.getWasSummoned()) ** GOTO lbl-1000
            v2 = ri.getConditionsWorlds();
            Intrinsics.checkNotNull(v2);
            v3 = lmInterface.getWorld();
            Intrinsics.checkNotNull(v3);
            v4 = v3.getName();
            Intrinsics.checkNotNullExpressionValue(v4, "getName(...)");
            if (v2.isIncludedInList(v4, null)) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = false;
            }
            result = v5;
            DebugManager.Companion.log(DebugType.CONDITION_WORLD_LIST, ri, lmInterface, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableInterface$lambda$27(io.github.arcaneplugins.levelledmobs.LivingEntityInterface ), ()Ljava/lang/String;)((LivingEntityInterface)lmInterface));
            if (!result) {
                return new RuleCheckResult(false);
            }
        }
        if (ri.getConditionsBiomes() != null) {
            v6 = ri.getConditionsBiomes();
            Intrinsics.checkNotNull(v6);
            v7 = lmInterface.getLocation();
            Intrinsics.checkNotNull(v7);
            v8 = v7.getBlock().getBiome();
            Intrinsics.checkNotNullExpressionValue(v8, "getBiome(...)");
            result = Utils.INSTANCE.isBiomeInModalList(v6, v8, LevelledMobs.Companion.getInstance().getRulesManager());
            DebugManager.Companion.log(DebugType.CONDITION_BIOME_LIST, ri, lmInterface, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableInterface$lambda$28(io.github.arcaneplugins.levelledmobs.LivingEntityInterface ), ()Ljava/lang/String;)((LivingEntityInterface)lmInterface));
            if (!result) {
                return new RuleCheckResult(false);
            }
        }
        if (ri.getConditionsWGregions() != null && ExternalCompatibilityManager.Companion.getHasWorldGuardInstalled()) {
            isInList = false;
            wgRegions = ExternalCompatibilityManager.Companion.getWGRegionsAtLocation(lmInterface);
            if (wgRegions.isEmpty()) {
                wgRegions.add("(none)");
            }
            for (String regionName : wgRegions) {
                v9 = ri.getConditionsWGregions();
                Intrinsics.checkNotNull(v9);
                if (!v9.isIncludedInList(regionName, null)) continue;
                isInList = true;
                break;
            }
            DebugManager.Companion.log(DebugType.CONDITION_WG_REGION, ri, lmInterface, isInList, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableInterface$lambda$29(java.util.List ), ()Ljava/lang/String;)(wgRegions));
            if (!isInList) {
                return new RuleCheckResult(false);
            }
        }
        if (ri.getConditionsWGregionOwners() != null && ExternalCompatibilityManager.Companion.getHasWorldGuardInstalled()) {
            isInList = false;
            wgRegionOwners = WorldGuardIntegration.INSTANCE.getWorldGuardRegionOwnersForLocation(lmInterface);
            if (wgRegionOwners.isEmpty()) {
                wgRegionOwners.add("(none)");
            }
            for (String ownerName : wgRegionOwners) {
                v10 = ri.getConditionsWGregionOwners();
                Intrinsics.checkNotNull(v10);
                if (!v10.isIncludedInList(ownerName, null)) continue;
                isInList = true;
                break;
            }
            DebugManager.Companion.log(DebugType.CONDITION_WG_REGION_OWNER, ri, lmInterface, isInList, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableInterface$lambda$30(java.util.List ), ()Ljava/lang/String;)(wgRegionOwners));
            if (!isInList) {
                return new RuleCheckResult(false);
            }
        }
        if (ri.getConditionsApplyAboveY() != null) {
            v11 = lmInterface.getLocation();
            Intrinsics.checkNotNull(v11);
            v12 = v11.getBlockY();
            v13 = ri.getConditionsApplyAboveY();
            Intrinsics.checkNotNull(v13);
            result = v12 > v13;
            DebugManager.Companion.log(DebugType.CONDITION_Y_LEVEL, ri, lmInterface, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableInterface$lambda$31(io.github.arcaneplugins.levelledmobs.LivingEntityInterface io.github.arcaneplugins.levelledmobs.rules.RuleInfo ), ()Ljava/lang/String;)((LivingEntityInterface)lmInterface, (RuleInfo)ri));
            if (!result) {
                return new RuleCheckResult(false);
            }
        }
        if (ri.getConditionsApplyBelowY() != null) {
            v14 = lmInterface.getLocation();
            Intrinsics.checkNotNull(v14);
            v15 = v14.getBlockY();
            v16 = ri.getConditionsApplyBelowY();
            Intrinsics.checkNotNull(v16);
            result = v15 < v16;
            DebugManager.Companion.log(DebugType.CONDITION_Y_LEVEL, ri, lmInterface, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableInterface$lambda$32(io.github.arcaneplugins.levelledmobs.LivingEntityInterface io.github.arcaneplugins.levelledmobs.rules.RuleInfo ), ()Ljava/lang/String;)((LivingEntityInterface)lmInterface, (RuleInfo)ri));
            if (!result) {
                return new RuleCheckResult(false);
            }
        }
        if (ri.getConditionsMinDistanceFromSpawn() != null) {
            v17 = lmInterface.getDistanceFromSpawn();
            v18 = ri.getConditionsMinDistanceFromSpawn();
            Intrinsics.checkNotNull(v18);
            result = v17 >= (double)v18.intValue();
            DebugManager.Companion.log(DebugType.CONDITION_MIN_SPAWN_DISTANCE, ri, lmInterface, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableInterface$lambda$33(io.github.arcaneplugins.levelledmobs.LivingEntityInterface io.github.arcaneplugins.levelledmobs.rules.RuleInfo ), ()Ljava/lang/String;)((LivingEntityInterface)lmInterface, (RuleInfo)ri));
            if (!result) {
                return new RuleCheckResult(false);
            }
        }
        if (ri.getConditionsMaxDistanceFromSpawn() != null) {
            v19 = lmInterface.getDistanceFromSpawn();
            v20 = ri.getConditionsMaxDistanceFromSpawn();
            Intrinsics.checkNotNull(v20);
            result = v19 <= (double)v20.intValue();
            DebugManager.Companion.log(DebugType.CONDITION_MAX_SPAWN_DISTANCE, ri, lmInterface, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableInterface$lambda$34(io.github.arcaneplugins.levelledmobs.LivingEntityInterface io.github.arcaneplugins.levelledmobs.rules.RuleInfo ), ()Ljava/lang/String;)((LivingEntityInterface)lmInterface, (RuleInfo)ri));
            if (!result) {
                return new RuleCheckResult(false);
            }
        }
        if (ri.getConditionsWorldTickTime() != null) {
            currentWorldTickTime = lmInterface.getSpawnedTimeOfDay();
            v21 = ri.getConditionsWorldTickTime();
            Intrinsics.checkNotNull(v21);
            result = Utils.INSTANCE.isIntegerInModalList(v21, currentWorldTickTime);
            DebugManager.Companion.log(DebugType.CONDITION_WORLD_TIME_TICK, ri, lmInterface, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableInterface$lambda$35(int ), ()Ljava/lang/String;)((int)currentWorldTickTime));
            if (!result) {
                return new RuleCheckResult(false, false);
            }
        }
        ruleMadeChance = null;
        if (ri.getConditionsChance() != null) {
            v22 = ri.getConditionsChance();
            Intrinsics.checkNotNull(v22);
            if ((double)v22.floatValue() < 1.0) {
                if (lmInterface instanceof LivingEntityWrapper && (prevChanceResults = ((LivingEntityWrapper)lmInterface).getPrevChanceRuleResults()) != null && prevChanceResults.containsKey(ri.getRuleName$levelledmobs_plugin())) {
                    v23 = prevChanceResults.get(ri.getRuleName$levelledmobs_plugin());
                    Intrinsics.checkNotNull(v23);
                    prevResult = v23;
                    return new RuleCheckResult(prevResult);
                }
                chanceRole = (float)ThreadLocalRandom.current().nextInt(0, 100001) * 1.0E-5f;
                v24 = ri.getConditionsChance();
                Intrinsics.checkNotNull(v24);
                result = chanceRole >= 1.0f - v24.floatValue();
                DebugManager.Companion.log(DebugType.CONDITION_CHANCE, ri, lmInterface, result, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isRuleApplicableInterface$lambda$36(io.github.arcaneplugins.levelledmobs.rules.RuleInfo float ), ()Ljava/lang/String;)((RuleInfo)ri, (float)chanceRole));
                if (!result) {
                    return new RuleCheckResult(false, false);
                }
                ruleMadeChance = true;
            }
        }
        return new RuleCheckResult(true, ruleMadeChance);
    }

    private final boolean doesPlayerPassPermissionChecks(CachedModalList<String> perms, Player player) {
        String permCheck;
        if (perms.getIncludeAll()) {
            return true;
        }
        if (perms.getExcludeAll()) {
            return false;
        }
        if (perms.isEmpty()) {
            return true;
        }
        for (String perm : perms.getExcludedList()) {
            permCheck = "levelledmobs.permission." + perm;
            if (!player.hasPermission(permCheck)) continue;
            return false;
        }
        for (String perm : perms.getIncludedList()) {
            permCheck = "levelledmobs.permission." + perm;
            if (!player.hasPermission(permCheck)) continue;
            return true;
        }
        return perms.isBlacklist();
    }

    public final void buildBiomeGroupMappings(@Nullable Map<String, Set<String>> customBiomeGroups) {
        this.biomeGroupMappings.clear();
        if (customBiomeGroups == null) {
            return;
        }
        for (Map.Entry<String, Set<String>> entry : customBiomeGroups.entrySet()) {
            String key = entry.getKey();
            Set<String> groupMembers = entry.getValue();
            List newList = new ArrayList(groupMembers.size());
            newList.addAll((Collection)groupMembers);
            this.biomeGroupMappings.put(key, newList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearTempDisabledRulesCounts() {
        Object object = ruleLocker;
        synchronized (object) {
            boolean bl = false;
            this.rulesCooldown.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkTempDisabledRules() {
        Object object = ruleLocker;
        synchronized (object) {
            boolean bl = false;
            if (this.rulesCooldown.isEmpty()) {
                return;
            }
            Iterator<String> iterator2 = this.rulesCooldown.keySet().iterator();
            while (iterator2.hasNext()) {
                List<Instant> instants;
                RuleInfo rule;
                String ruleName;
                block10: {
                    block9: {
                        ruleName = iterator2.next();
                        RuleInfo ruleInfo = rule = this.ruleNameMappings.get(ruleName);
                        if ((ruleInfo != null ? ruleInfo.getConditionsCooldownTime() : null) == null) break block9;
                        Long l = rule.getConditionsCooldownTime();
                        Intrinsics.checkNotNull(l);
                        if (l > 0L) break block10;
                    }
                    if (rule != null) {
                        rule.setTempDisabled(false);
                    }
                    iterator2.remove();
                    continue;
                }
                List<Instant> list = instants = this.rulesCooldown.get(ruleName);
                Intrinsics.checkNotNull(list);
                int preCount = list.size();
                if (!instants.removeIf(arg_0 -> RulesManager.checkTempDisabledRules$lambda$41$lambda$39(arg_0 -> RulesManager.checkTempDisabledRules$lambda$41$lambda$38(rule, arg_0), arg_0))) continue;
                DebugManager.Companion.log(DebugType.SETTING_COOLDOWN, () -> RulesManager.checkTempDisabledRules$lambda$41$lambda$40(preCount, instants));
                if (!instants.isEmpty()) continue;
                rule.setTempDisabled(false);
                iterator2.remove();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void showTempDisabledRules(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Object object = ruleLocker;
        synchronized (object) {
            boolean bl = false;
            if (this.rulesCooldown.isEmpty()) {
                sender.sendMessage("No rules are currently temporarily disabled");
                return;
            }
            this.checkTempDisabledRules();
            StringBuilder sb = new StringBuilder();
            sb.append(" " + this.rulesCooldown.size() + " rule(s) currently disabled:");
            for (String ruleName : this.rulesCooldown.keySet()) {
                RuleInfo rule;
                RuleInfo ruleInfo = rule = this.ruleNameMappings.get(ruleName);
                if ((ruleInfo != null ? ruleInfo.getConditionsCooldownTime() : null) == null) continue;
                sb.append(System.lineSeparator());
                sb.append(ruleName);
                sb.append(": seconds left: ");
                List<Instant> list = this.rulesCooldown.get(ruleName);
                Intrinsics.checkNotNull(list);
                Instant instant = list.get(0);
                long millisecondsSince = Duration.between(instant, Instant.now()).toMillis();
                Long l = rule.getConditionsCooldownTime();
                Intrinsics.checkNotNull(l);
                Duration duration = Duration.ofMillis(l - millisecondsSince);
                sb.append(duration.toSeconds());
            }
            sender.sendMessage(sb.toString());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateRulesHash() {
        Object object;
        StringBuilder sb = new StringBuilder();
        Object object2 = ruleLocker;
        synchronized (object2) {
            boolean bl = false;
            for (RuleInfo rule : this.rulesInEffect) {
                if (!rule.getRuleIsEnabled()) continue;
                if (((CharSequence)sb).length() > 0) {
                    sb.append("\n");
                }
                String[] stringArray = new String[]{"id"};
                sb.append(rule.formatRulesVisually(true, CollectionsKt.mutableListOf(stringArray)));
            }
            object = Unit.INSTANCE;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA3-256");
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            object = string;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue(charset, "UTF_8");
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
            byte[] hashbytes = digest.digest(byArray);
            Intrinsics.checkNotNull(hashbytes);
            this.currentRulesHash = RulesManager.Companion.bytesToHex(hashbytes);
        }
        catch (NoSuchAlgorithmException e) {
            Log.INSTANCE.war("Unable to run SHA-256 hash: " + e.getMessage());
            this.currentRulesHash = "1234";
        }
    }

    private static final String getApplicableRules$lambda$0(ApplicableRulesResult $applicableRules) {
        Intrinsics.checkNotNullParameter($applicableRules, "$applicableRules");
        return "rule count: &b" + $applicableRules.getAllApplicableRules().size() + "&r";
    }

    private static final String checkIfRuleShouldBeTempDisabled$lambda$2$lambda$1() {
        return "cooldown reached, disabling rule";
    }

    private static final String isRuleApplicableEntity$lambda$3(LivingEntityWrapper $lmEntity, RuleInfo $ri) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($ri, "$ri");
        return "mob lvl: &b" + $lmEntity.getGetMobLevel() + "&7, rule minlvl: &b" + $ri.getConditionsMinLevel() + "&7";
    }

    private static final String isRuleApplicableEntity$lambda$4(LivingEntityWrapper $lmEntity, RuleInfo $ri) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($ri, "$ri");
        return "mob lvl: &b" + $lmEntity.getGetMobLevel() + "&7, rule maxlvl: &b" + $ri.getConditionsMaxLevel() + "&7";
    }

    private static final String isRuleApplicableEntity$lambda$5(String $customName) {
        Intrinsics.checkNotNullParameter($customName, "$customName");
        return "name: &b" + $customName + "&7";
    }

    private static final String isRuleApplicableEntity$lambda$6(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "spawn reason: &b" + $lmEntity.getSpawnReason() + "&7";
    }

    private static final String isRuleApplicableEntity$lambda$7(Set $mobCompats) {
        Intrinsics.checkNotNullParameter($mobCompats, "$mobCompats");
        return "mob plugins: &b" + $mobCompats + "&7";
    }

    private static final String isRuleApplicableEntity$lambda$8(String $mmNameFinal) {
        Intrinsics.checkNotNullParameter($mmNameFinal, "$mmNameFinal");
        return "mm_name: &b" + $mmNameFinal + "&7";
    }

    private static final String isRuleApplicableEntity$lambda$9(String $checkName) {
        return "spawner: &b" + $checkName + "&7";
    }

    private static final String isRuleApplicableEntity$lambda$10(String $checkName) {
        return "spawn_egg: &b" + $checkName + "&7";
    }

    private static final String isRuleApplicableEntity$lambda$11() {
        return "no player was provided";
    }

    private static final String isRuleApplicableEntity$lambda$12(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Player player = $lmEntity.getAssociatedPlayer();
        Intrinsics.checkNotNull(player);
        return "player: &b" + player.getName() + "&7, permission denied";
    }

    private static final String isRuleApplicableEntity$lambda$13(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Player player = $lmEntity.getAssociatedPlayer();
        Intrinsics.checkNotNull(player);
        return "player: &b" + player.getName() + "&7, permission granted";
    }

    private static final String isRuleApplicableEntity$lambda$14(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "nametag: " + $lmEntity.getLivingEntity().getCustomName();
    }

    private static final String isRuleApplicableEntity$lambda$15(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "nametag: " + $lmEntity.getLivingEntity().getCustomName();
    }

    private static final String isRuleApplicableEntity$lambda$16(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "tamed: " + $lmEntity.isMobTamed();
    }

    private static final String isRuleApplicableEntity$lambda$17(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "tamed: " + $lmEntity.isMobTamed();
    }

    private static final String isRuleApplicableEntity$lambda$18() {
        return "";
    }

    private static final String isRuleApplicableEntity$lambda$19() {
        return "";
    }

    private static final String isRuleApplicableEntity$lambda$20(int $lightLevel, RuleInfo $ri) {
        Intrinsics.checkNotNullParameter($ri, "$ri");
        return "skylight: " + $lightLevel + ", criteria: " + $ri.getConditionsSkyLightLevel();
    }

    private static final String meetsMaxDistanceCriteria$lambda$21(LivingEntityWrapper $lmEntity, WithinCoordinates $mdr) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($mdr, "$mdr");
        return "xCoord: " + $lmEntity.getLocation().getBlockX() + ", startX: " + $mdr.getStartX() + ", endX: " + $mdr.getEndX();
    }

    private static final String meetsMaxDistanceCriteria$lambda$22(LivingEntityWrapper $lmEntity, WithinCoordinates $mdr) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($mdr, "$mdr");
        return "yCoord: " + $lmEntity.getLocation().getBlockY() + ", startY: " + $mdr.getStartY() + ", endY: " + $mdr.getEndY();
    }

    private static final String meetsMaxDistanceCriteria$lambda$23(LivingEntityWrapper $lmEntity, WithinCoordinates $mdr) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($mdr, "$mdr");
        return "zCoord: " + $lmEntity.getLocation().getBlockZ() + ", startZ: " + $mdr.getStartZ() + ", endZ: " + $mdr.getEndZ();
    }

    private static final String meetsMaxDistanceCriteria$lambda$24(LivingEntityWrapper $lmEntity, WithinCoordinates $mdr) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($mdr, "$mdr");
        return "zCoord: " + $lmEntity.getLocation().getBlockZ() + ", startZ: " + $mdr.getStartZ() + ", endZ: " + $mdr.getEndZ();
    }

    private static final String isRuleApplicableInterface$lambda$25() {
        return "";
    }

    private static final String isRuleApplicableInterface$lambda$26() {
        return "";
    }

    private static final String isRuleApplicableInterface$lambda$27(LivingEntityInterface $lmInterface) {
        Intrinsics.checkNotNullParameter($lmInterface, "$lmInterface");
        World world = $lmInterface.getWorld();
        Intrinsics.checkNotNull(world);
        return "mob world: &b" + world.getName() + "&7";
    }

    private static final String isRuleApplicableInterface$lambda$28(LivingEntityInterface $lmInterface) {
        Intrinsics.checkNotNullParameter($lmInterface, "$lmInterface");
        Location location = $lmInterface.getLocation();
        Intrinsics.checkNotNull(location);
        return "mob biome: &b" + location.getBlock().getBiome().name() + "&7";
    }

    private static final String isRuleApplicableInterface$lambda$29(List $wgRegions) {
        Intrinsics.checkNotNullParameter($wgRegions, "$wgRegions");
        return "wg_regions: &b" + $wgRegions + "&7";
    }

    private static final String isRuleApplicableInterface$lambda$30(List $wgRegionOwners) {
        Intrinsics.checkNotNullParameter($wgRegionOwners, "$wgRegionOwners");
        return "wg_owners: &b" + $wgRegionOwners + "&7";
    }

    private static final String isRuleApplicableInterface$lambda$31(LivingEntityInterface $lmInterface, RuleInfo $ri) {
        Intrinsics.checkNotNullParameter($lmInterface, "$lmInterface");
        Intrinsics.checkNotNullParameter($ri, "$ri");
        Location location = $lmInterface.getLocation();
        Intrinsics.checkNotNull(location);
        return "y-level: &b" + location.getBlockY() + "&7, max-y: &b" + $ri.getConditionsApplyAboveY() + "&7";
    }

    private static final String isRuleApplicableInterface$lambda$32(LivingEntityInterface $lmInterface, RuleInfo $ri) {
        Intrinsics.checkNotNullParameter($lmInterface, "$lmInterface");
        Intrinsics.checkNotNullParameter($ri, "$ri");
        Location location = $lmInterface.getLocation();
        Intrinsics.checkNotNull(location);
        return "y-level: &b" + location.getBlockY() + "&7, min-y: &b" + $ri.getConditionsApplyBelowY() + "&7";
    }

    private static final String isRuleApplicableInterface$lambda$33(LivingEntityInterface $lmInterface, RuleInfo $ri) {
        Intrinsics.checkNotNullParameter($lmInterface, "$lmInterface");
        Intrinsics.checkNotNullParameter($ri, "$ri");
        return "spawn-distance: &b" + Utils.INSTANCE.round($lmInterface.getDistanceFromSpawn()) + "&7, min-sd: &b" + $ri.getConditionsMinDistanceFromSpawn() + "&7";
    }

    private static final String isRuleApplicableInterface$lambda$34(LivingEntityInterface $lmInterface, RuleInfo $ri) {
        Intrinsics.checkNotNullParameter($lmInterface, "$lmInterface");
        Intrinsics.checkNotNullParameter($ri, "$ri");
        return "spawn-distance: &b" + Utils.INSTANCE.round($lmInterface.getDistanceFromSpawn()) + "&7, min-sd: &b" + $ri.getConditionsMaxDistanceFromSpawn() + "&7";
    }

    private static final String isRuleApplicableInterface$lambda$35(int $currentWorldTickTime) {
        return "tick time: &b" + $currentWorldTickTime + "&7";
    }

    private static final String isRuleApplicableInterface$lambda$36(RuleInfo $ri, float $chanceRole) {
        Intrinsics.checkNotNullParameter($ri, "$ri");
        return "chance: &b" + $ri.getConditionsChance() + "&7, chance role: &b" + Utils.INSTANCE.round($chanceRole, 4) + "&7";
    }

    private static final boolean checkTempDisabledRules$lambda$41$lambda$38(RuleInfo $rule, Instant k) {
        long l = Duration.between(k, Instant.now()).toMillis();
        Long l2 = $rule.getConditionsCooldownTime();
        Intrinsics.checkNotNull(l2);
        return l > l2;
    }

    private static final boolean checkTempDisabledRules$lambda$41$lambda$39(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String checkTempDisabledRules$lambda$41$lambda$40(int $preCount, List $instants) {
        return "removed cooldown entries, pre: " + $preCount + ", post: " + $instants.size();
    }

    @NotNull
    public static final RulesManager getInstance() {
        return Companion.getInstance();
    }

    static {
        ruleLocker = new Object();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R&\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058\u0006@BX\u0087.\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/RulesManager$Companion;", "", "<init>", "()V", "value", "Lio/github/arcaneplugins/levelledmobs/rules/RulesManager;", "instance", "getInstance$annotations", "getInstance", "()Lio/github/arcaneplugins/levelledmobs/rules/RulesManager;", "ruleLocker", "getRuleLocker", "()Ljava/lang/Object;", "bytesToHex", "", "hash", "", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RulesManager getInstance() {
            RulesManager rulesManager = instance;
            if (rulesManager != null) {
                return rulesManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final Object getRuleLocker() {
            return ruleLocker;
        }

        private final String bytesToHex(byte[] hash) {
            StringBuilder hexString = new StringBuilder(2 * hash.length);
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            String string = hexString.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

