/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.rules;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.enums.ExternalCompatibility;
import io.github.arcaneplugins.levelledmobs.enums.NametagVisibilityEnum;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.rules.LevelTierMatching;
import io.github.arcaneplugins.levelledmobs.rules.MergeableStringList;
import io.github.arcaneplugins.levelledmobs.rules.RuleInfo;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0002J\u0006\u0010\f\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u0005J\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u0017J\u0006\u0010\u0019\u001a\u00020\u0005R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/MetricsInfo;", "", "<init>", "()V", "convertBooleanToString", "", "result", "", "isCustomDropsEnabed", "getUsesCustomDrops", "getGetUsesCustomDrops", "()Ljava/lang/String;", "getUsesHealthIndicator", "getMaxLevelRange", "getCustomRulesUsed", "getLevellingStrategy", "usesPlayerLevelling", "usesAutoUpdateChecker", "levelMobsUponSpawn", "checkMobsOnChunkLoad", "customEntityNamesCount", "usesNbtData", "enabledCompats", "", "", "nametagVisibility", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nMetricsInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsInfo.kt\nio/github/arcaneplugins/levelledmobs/rules/MetricsInfo\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,225:1\n37#2,2:226\n*S KotlinDebug\n*F\n+ 1 MetricsInfo.kt\nio/github/arcaneplugins/levelledmobs/rules/MetricsInfo\n*L\n181#1:226,2\n*E\n"})
public final class MetricsInfo {
    private final String convertBooleanToString(boolean result) {
        return result ? "Yes" : "No";
    }

    private final boolean isCustomDropsEnabed() {
        for (RuleInfo ruleInfo : LevelledMobs.Companion.getInstance().getRulesManager().getRulesInEffect()) {
            if (ruleInfo.getCustomDropsUseForMobs() == null) continue;
            Boolean bl = ruleInfo.getCustomDropsUseForMobs();
            Intrinsics.checkNotNull(bl);
            if (!bl.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final String getGetUsesCustomDrops() {
        return this.convertBooleanToString(this.isCustomDropsEnabed());
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String getUsesHealthIndicator() {
        main = LevelledMobs.Companion.getInstance();
        v0 = main.getRulesParsingManager().getDefaultRule();
        Intrinsics.checkNotNull(v0);
        if (v0.getHealthIndicator() == null) ** GOTO lbl-1000
        v1 = main.getRulesParsingManager().getDefaultRule();
        Intrinsics.checkNotNull(v1);
        if (v1.getNametag() == null) ** GOTO lbl-1000
        v2 = main.getRulesParsingManager().getDefaultRule();
        Intrinsics.checkNotNull(v2);
        v3 = v2.getNametag();
        Intrinsics.checkNotNull(v3);
        var3_2 = v3;
        v4 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(v4, "getDefault(...)");
        v5 = var3_2.toLowerCase(v4);
        Intrinsics.checkNotNullExpressionValue(v5, "toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)v5, "%health-indicator%", false, 2, null)) {
            v6 = true;
        } else lbl-1000:
        // 3 sources

        {
            v6 = false;
        }
        usesHealthIndicator = v6;
        return this.convertBooleanToString(usesHealthIndicator);
    }

    @NotNull
    public final String getMaxLevelRange() {
        int maxLevel;
        RuleInfo ruleInfo = LevelledMobs.Companion.getInstance().getRulesParsingManager().getDefaultRule();
        Intrinsics.checkNotNull(ruleInfo);
        if (ruleInfo.getRestrictionsMaxLevel() == null) {
            v1 = 1;
        } else {
            RuleInfo ruleInfo2 = LevelledMobs.Companion.getInstance().getRulesParsingManager().getDefaultRule();
            Intrinsics.checkNotNull(ruleInfo2);
            Integer n = ruleInfo2.getRestrictionsMaxLevel();
            Intrinsics.checkNotNull(n);
            v1 = maxLevel = n.intValue();
        }
        return maxLevel >= 500 ? "500+" : (maxLevel > 100 ? "101-499" : (maxLevel > 50 ? "51-100" : (maxLevel > 24 ? "25-50" : (maxLevel > 10 ? "11-24" : "1-10"))));
    }

    @NotNull
    public final String getCustomRulesUsed() {
        int rulesEnabledCount = 0;
        for (RuleInfo ruleInfo : LevelledMobs.Companion.getInstance().getRulesParsingManager().getCustomRules()) {
            if (!ruleInfo.getRuleIsEnabled()) continue;
            ++rulesEnabledCount;
        }
        return rulesEnabledCount > 4 ? "5+" : (rulesEnabledCount > 2 ? "3-4" : (rulesEnabledCount > 0 ? "1-2" : "0"));
    }

    @NotNull
    public final String getLevellingStrategy() {
        RuleInfo ruleInfo = LevelledMobs.Companion.getInstance().getRulesParsingManager().getDefaultRule();
        Intrinsics.checkNotNull(ruleInfo);
        RuleInfo defaultRule = ruleInfo;
        return "Random";
    }

    @NotNull
    public final String usesPlayerLevelling() {
        return this.convertBooleanToString(LevelledMobs.Companion.getInstance().getRulesManager().isPlayerLevellingEnabled());
    }

    @NotNull
    public final String usesAutoUpdateChecker() {
        return this.convertBooleanToString(LevelledMobs.Companion.getInstance().getHelperSettings().getBoolean("use-update-checker", true));
    }

    @NotNull
    public final String levelMobsUponSpawn() {
        return this.convertBooleanToString(LevelledMobs.Companion.getInstance().getHelperSettings().getBoolean("level-mobs-upon-spawn", true));
    }

    @NotNull
    public final String checkMobsOnChunkLoad() {
        return this.convertBooleanToString(LevelledMobs.Companion.getInstance().getHelperSettings().getBoolean("ensure-mobs-are-levelled-on-chunk-load", true));
    }

    @NotNull
    public final String customEntityNamesCount() {
        int count = 0;
        RuleInfo ruleInfo = LevelledMobs.Companion.getInstance().getRulesParsingManager().getDefaultRule();
        Intrinsics.checkNotNull(ruleInfo);
        if (ruleInfo.getEntityNameOverrides() != null) {
            RuleInfo ruleInfo2 = LevelledMobs.Companion.getInstance().getRulesParsingManager().getDefaultRule();
            Intrinsics.checkNotNull(ruleInfo2);
            Map<String, LevelTierMatching> map = ruleInfo2.getEntityNameOverrides();
            Intrinsics.checkNotNull(map);
            count += map.size();
        }
        RuleInfo ruleInfo3 = LevelledMobs.Companion.getInstance().getRulesParsingManager().getDefaultRule();
        Intrinsics.checkNotNull(ruleInfo3);
        if (ruleInfo3.getEntityNameOverridesLevel() != null) {
            RuleInfo ruleInfo4 = LevelledMobs.Companion.getInstance().getRulesParsingManager().getDefaultRule();
            Intrinsics.checkNotNull(ruleInfo4);
            Map<String, List<LevelTierMatching>> map = ruleInfo4.getEntityNameOverridesLevel();
            Intrinsics.checkNotNull(map);
            count += map.size();
        }
        return count > 12 ? "13+" : (count > 8 ? "9-12" : (count > 3 ? "4-8" : (count > 0 ? "1-3" : "0")));
    }

    @NotNull
    public final String usesNbtData() {
        if (!ExternalCompatibilityManager.Companion.getHasNbtApiInstalled()) {
            return "No";
        }
        for (RuleInfo ruleInfo : LevelledMobs.Companion.getInstance().getRulesParsingManager().getAllRules()) {
            if (!ruleInfo.getRuleIsEnabled() || ruleInfo.getMobNBTData() == null) continue;
            MergeableStringList mergeableStringList = ruleInfo.getMobNBTData();
            Intrinsics.checkNotNull(mergeableStringList);
            if (!mergeableStringList.isNotEmpty()) continue;
            return "Yes";
        }
        if (this.isCustomDropsEnabed() && LevelledMobs.Companion.getInstance().getCustomDropsHandler().getCustomDropsParser().getDropsUtilizeNBTAPI()) {
            return "Yes";
        }
        return "No";
    }

    @NotNull
    public final Map<String, Integer> enabledCompats() {
        Map results = new LinkedHashMap();
        Collection $this$toTypedArray$iv = ExternalCompatibility.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        for (ExternalCompatibility compat : thisCollection$iv.toArray(new ExternalCompatibility[0])) {
            if (compat == ExternalCompatibility.NOT_APPLICABLE || compat == ExternalCompatibility.PLACEHOLDER_API) continue;
            results.put(compat.toString(), 0);
        }
        for (RuleInfo ruleInfo : LevelledMobs.Companion.getInstance().getRulesParsingManager().getAllRules()) {
            if (!ruleInfo.getRuleIsEnabled() || ruleInfo.getEnabledExtCompats() == null) continue;
            Map<ExternalCompatibility, Boolean> map = ruleInfo.getEnabledExtCompats();
            Intrinsics.checkNotNull(map);
            for (Map.Entry<ExternalCompatibility, Boolean> entry : map.entrySet()) {
                ExternalCompatibility compat = entry.getKey();
                boolean enabled = entry.getValue();
                if (compat == ExternalCompatibility.NOT_APPLICABLE || !enabled) continue;
                results.put(compat.toString(), 1);
            }
        }
        return results;
    }

    @NotNull
    public final String nametagVisibility() {
        block3: {
            block2: {
                RuleInfo ruleInfo = LevelledMobs.Companion.getInstance().getRulesParsingManager().getDefaultRule();
                Intrinsics.checkNotNull(ruleInfo);
                if (ruleInfo.getNametagVisibilityEnum() == null) break block2;
                RuleInfo ruleInfo2 = LevelledMobs.Companion.getInstance().getRulesParsingManager().getDefaultRule();
                Intrinsics.checkNotNull(ruleInfo2);
                List<NametagVisibilityEnum> list = ruleInfo2.getNametagVisibilityEnum();
                Intrinsics.checkNotNull(list);
                if (!list.isEmpty()) break block3;
            }
            return "Undefined";
        }
        RuleInfo ruleInfo = LevelledMobs.Companion.getInstance().getRulesParsingManager().getDefaultRule();
        Intrinsics.checkNotNull(ruleInfo);
        List<NametagVisibilityEnum> list = ruleInfo.getNametagVisibilityEnum();
        Intrinsics.checkNotNull(list);
        return StringsKt.replace$default(StringsKt.replace$default(SequencesKt.sorted(CollectionsKt.asSequence((Iterable)list)).toString(), "[", "", false, 4, null), "]", "", false, 4, null);
    }
}

