/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.rules;

import io.github.arcaneplugins.levelledmobs.enums.Addition;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.rules.LMMultiplier;
import io.github.arcaneplugins.levelledmobs.rules.MergableRule;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0002'(B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\nJ\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0016J\u0016\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\bJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u0007J\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0016J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\b\u0010%\u001a\u00020&H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u0014\u0010\u001c\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\f\u00a8\u0006)"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/FineTuningAttributes;", "Lio/github/arcaneplugins/levelledmobs/rules/MergableRule;", "", "<init>", "()V", "multipliers", "", "Lio/github/arcaneplugins/levelledmobs/enums/Addition;", "Lio/github/arcaneplugins/levelledmobs/rules/FineTuningAttributes$Multiplier;", "doNotMerge", "", "getDoNotMerge", "()Z", "setDoNotMerge", "(Z)V", "useStacked", "getUseStacked", "()Ljava/lang/Boolean;", "setUseStacked", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "isEmpty", "merge", "", "mergableRule", "addItem", "addition", "multiplier", "doMerge", "getDoMerge", "getItem", "getAdditionFromLMMultiplier", "lmMultiplier", "Lio/github/arcaneplugins/levelledmobs/rules/LMMultiplier;", "cloneItem", "", "copyMultipliers", "toString", "", "Companion", "Multiplier", "levelledmobs-plugin"})
public final class FineTuningAttributes
implements MergableRule,
Cloneable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<Addition, Multiplier> multipliers = new LinkedHashMap();
    private boolean doNotMerge;
    @Nullable
    private Boolean useStacked;

    public final boolean getDoNotMerge() {
        return this.doNotMerge;
    }

    public final void setDoNotMerge(boolean bl) {
        this.doNotMerge = bl;
    }

    @Nullable
    public final Boolean getUseStacked() {
        return this.useStacked;
    }

    public final void setUseStacked(@Nullable Boolean bl) {
        this.useStacked = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getUseStacked() {
        if (this.useStacked == null) return false;
        Boolean bl = this.useStacked;
        Intrinsics.checkNotNull(bl);
        if (bl == false) return false;
        return true;
    }

    public final boolean isEmpty() {
        return this.multipliers.isEmpty() && !this.doNotMerge && this.useStacked == null;
    }

    @Override
    public void merge(@Nullable MergableRule mergableRule) {
        if (!(mergableRule instanceof FineTuningAttributes)) {
            return;
        }
        this.multipliers.putAll(((FineTuningAttributes)mergableRule).copyMultipliers());
    }

    public final void addItem(@NotNull Addition addition, @NotNull Multiplier multiplier) {
        Intrinsics.checkNotNullParameter((Object)addition, "addition");
        Intrinsics.checkNotNullParameter(multiplier, "multiplier");
        this.multipliers.put(addition, multiplier);
    }

    @Override
    public boolean getDoMerge() {
        return !this.doNotMerge;
    }

    @Nullable
    public final Multiplier getItem(@NotNull Addition addition) {
        Intrinsics.checkNotNullParameter((Object)addition, "addition");
        return this.multipliers.get((Object)addition);
    }

    @NotNull
    public final Addition getAdditionFromLMMultiplier(@NotNull LMMultiplier lmMultiplier) {
        Intrinsics.checkNotNullParameter((Object)lmMultiplier, "lmMultiplier");
        return switch (WhenMappings.$EnumSwitchMapping$0[lmMultiplier.ordinal()]) {
            case 1 -> Addition.ATTRIBUTE_ATTACK_DAMAGE;
            case 2 -> Addition.CREEPER_BLAST_DAMAGE;
            case 3 -> Addition.ATTRIBUTE_MAX_HEALTH;
            case 4 -> Addition.ATTRIBUTE_MOVEMENT_SPEED;
            case 5 -> Addition.CUSTOM_RANGED_ATTACK_DAMAGE;
            case 6 -> Addition.CUSTOM_ITEM_DROP;
            case 7 -> Addition.ATTRIBUTE_ARMOR_BONUS;
            case 8 -> Addition.ATTRIBUTE_ARMOR_TOUGHNESS;
            case 9 -> Addition.ATTRIBUTE_ATTACK_KNOCKBACK;
            case 10 -> Addition.ATTRIBUTE_FLYING_SPEED;
            case 11 -> Addition.ATTRIBUTE_KNOCKBACK_RESISTANCE;
            case 12 -> Addition.ATTRIBUTE_HORSE_JUMP_STRENGTH;
            case 13 -> Addition.ATTRIBUTE_ZOMBIE_SPAWN_REINFORCEMENTS;
            case 14 -> Addition.ATTRIBUTE_FOLLOW_RANGE;
            case 15 -> Addition.CUSTOM_XP_DROP;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public Object cloneItem() {
        FineTuningAttributes copy = null;
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.rules.FineTuningAttributes");
            copy = (FineTuningAttributes)object;
            copy.multipliers = this.copyMultipliers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FineTuningAttributes fineTuningAttributes = copy;
        Intrinsics.checkNotNull(fineTuningAttributes);
        return fineTuningAttributes;
    }

    private final Map<Addition, Multiplier> copyMultipliers() {
        Map copy = new LinkedHashMap(this.multipliers.size());
        for (Addition addition : this.multipliers.keySet()) {
            Multiplier old;
            Multiplier multiplier = old = this.multipliers.get((Object)addition);
            Intrinsics.checkNotNull(multiplier);
            copy.put(addition, new Multiplier(addition, multiplier.useStacked(), old.value(), old.formula(), old.isAddition()));
        }
        return copy;
    }

    @NotNull
    public String toString() {
        if (this.isEmpty()) {
            return "No items";
        }
        StringBuilder sb = new StringBuilder();
        if (this.getUseStacked()) {
            sb.append("(all stk)");
        }
        for (Multiplier multiplier : this.multipliers.values()) {
            if (((CharSequence)sb).length() > 0) {
                sb.append(", ");
            }
            sb.append(Companion.getShortName(multiplier.addition()));
            sb.append(": ").append(multiplier.value());
            if (multiplier.hasFormula()) {
                sb.append(multiplier.formula());
                continue;
            }
            if (!multiplier.useStacked()) continue;
            sb.append(" (stk)");
        }
        if (this.doNotMerge) {
            if (((CharSequence)sb).length() > 0) {
                sb.append(", ");
            }
            sb.append("noMerge");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/FineTuningAttributes$Companion;", "", "<init>", "()V", "getShortName", "", "addition", "Lio/github/arcaneplugins/levelledmobs/enums/Addition;", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getShortName(@NotNull Addition addition) {
            Intrinsics.checkNotNullParameter((Object)addition, "addition");
            return switch (WhenMappings.$EnumSwitchMapping$0[addition.ordinal()]) {
                case 1 -> "attkDmg";
                case 2 -> "creeperDmg";
                case 3 -> "maxHlth";
                case 4 -> "moveSpd";
                case 5 -> "rangdAtkDmg";
                case 6 -> "itemDrp";
                case 7 -> "armrBns";
                case 8 -> "armrTuf";
                case 9 -> "attkKnbk";
                case 10 -> "flySpd";
                case 11 -> "knbkRst";
                case 12 -> "horseJump";
                case 13 -> "zmbRnfrce";
                case 14 -> "flwRng";
                case 15 -> "xpDrp";
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Addition.values().length];
                try {
                    nArray[Addition.ATTRIBUTE_ATTACK_DAMAGE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.CREEPER_BLAST_DAMAGE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_MAX_HEALTH.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_MOVEMENT_SPEED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.CUSTOM_RANGED_ATTACK_DAMAGE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.CUSTOM_ITEM_DROP.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_ARMOR_BONUS.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_ARMOR_TOUGHNESS.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_ATTACK_KNOCKBACK.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_FLYING_SPEED.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_KNOCKBACK_RESISTANCE.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_HORSE_JUMP_STRENGTH.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_ZOMBIE_SPAWN_REINFORCEMENTS.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.ATTRIBUTE_FOLLOW_RANGE.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Addition.CUSTOM_XP_DROP.ordinal()] = 15;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0012\u001a\u00020\tH\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lio/github/arcaneplugins/levelledmobs/rules/FineTuningAttributes$Multiplier;", "Ljava/lang/Record;", "addition", "Lio/github/arcaneplugins/levelledmobs/enums/Addition;", "useStacked", "", "value", "", "formula", "", "isAddition", "<init>", "(Lio/github/arcaneplugins/levelledmobs/enums/Addition;ZFLjava/lang/String;Z)V", "()Lio/github/arcaneplugins/levelledmobs/enums/Addition;", "()Z", "()F", "()Ljava/lang/String;", "hasFormula", "toString", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "levelledmobs-plugin"})
    public static final class Multiplier
    extends Record {
        @NotNull
        private final Addition addition;
        private final boolean useStacked;
        private final float value;
        @Nullable
        private final String formula;
        private final boolean isAddition;

        public Multiplier(@NotNull Addition addition, boolean useStacked, float value, @Nullable String formula, boolean isAddition) {
            Intrinsics.checkNotNullParameter((Object)addition, "addition");
            this.addition = addition;
            this.useStacked = useStacked;
            this.value = value;
            this.formula = formula;
            this.isAddition = isAddition;
        }

        @NotNull
        public final Addition addition() {
            return this.addition;
        }

        public final boolean useStacked() {
            return this.useStacked;
        }

        public final float value() {
            return this.value;
        }

        @Nullable
        public final String formula() {
            return this.formula;
        }

        public final boolean isAddition() {
            return this.isAddition;
        }

        public final boolean hasFormula() {
            CharSequence charSequence = this.formula;
            return !(charSequence == null || charSequence.length() == 0);
        }

        @Override
        @NotNull
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(Companion.getShortName(this.addition));
            if (this.hasFormula()) {
                sb.append(" formula: '");
                sb.append(this.formula).append("'");
                v0 = this.isAddition ? sb.append(" (add)") : sb.append(" (multiply)");
            } else {
                StringBuilder stringBuilder = this.useStacked ? sb.append(" (stkd): ") : sb.append(": ");
                v0 = sb.append(this.value);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        @NotNull
        public final Addition component1() {
            return this.addition;
        }

        public final boolean component2() {
            return this.useStacked;
        }

        public final float component3() {
            return this.value;
        }

        @Nullable
        public final String component4() {
            return this.formula;
        }

        public final boolean component5() {
            return this.isAddition;
        }

        @NotNull
        public final Multiplier copy(@NotNull Addition addition, boolean useStacked, float value, @Nullable String formula, boolean isAddition) {
            Intrinsics.checkNotNullParameter((Object)addition, "addition");
            return new Multiplier(addition, useStacked, value, formula, isAddition);
        }

        public static /* synthetic */ Multiplier copy$default(Multiplier multiplier, Addition addition, boolean bl, float f, String string, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                addition = multiplier.addition;
            }
            if ((n & 2) != 0) {
                bl = multiplier.useStacked;
            }
            if ((n & 4) != 0) {
                f = multiplier.value;
            }
            if ((n & 8) != 0) {
                string = multiplier.formula;
            }
            if ((n & 0x10) != 0) {
                bl2 = multiplier.isAddition;
            }
            return multiplier.copy(addition, bl, f, string, bl2);
        }

        @Override
        public int hashCode() {
            int result = this.addition.hashCode();
            result = result * 31 + Boolean.hashCode(this.useStacked);
            result = result * 31 + Float.hashCode(this.value);
            result = result * 31 + (this.formula == null ? 0 : this.formula.hashCode());
            result = result * 31 + Boolean.hashCode(this.isAddition);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Multiplier)) {
                return false;
            }
            Multiplier multiplier = (Multiplier)other;
            if (this.addition != multiplier.addition) {
                return false;
            }
            if (this.useStacked != multiplier.useStacked) {
                return false;
            }
            if (Float.compare(this.value, multiplier.value) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual(this.formula, multiplier.formula)) {
                return false;
            }
            return this.isAddition == multiplier.isAddition;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LMMultiplier.values().length];
            try {
                nArray[LMMultiplier.ATTACK_DAMAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.CREEPER_BLAST_DAMAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.MAX_HEALTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.MOVEMENT_SPEED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.RANGED_ATTACK_DAMAGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.ITEM_DROP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.ARMOR_BONUS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.ARMOR_TOUGHNESS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.ATTACK_KNOCKBACK.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.FLYING_SPEED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.KNOCKBACK_RESISTANCE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.HORSE_JUMP_STRENGTH.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.ZOMBIE_SPAWN_REINFORCEMENTS.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.FOLLOW_RANGE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LMMultiplier.XP_DROP.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

