/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.nametag;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u00010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010%\u001a\u00020\u0005H\u0002J\b\u0010&\u001a\u00020\u0005H\u0002J\b\u0010'\u001a\u00020\u0005H\u0002J\b\u0010(\u001a\u00020\u0005H\u0002J\b\u0010/\u001a\u00020\u001eH\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u001e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b+\u0010*R\u0011\u0010,\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u0011\u0010-\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b-\u0010*R\u0011\u0010.\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b.\u0010*\u00a8\u00061"}, d2={"Lio/github/arcaneplugins/levelledmobs/nametag/ServerVersionInfo;", "", "<init>", "()V", "load", "", "value", "", "majorVersion", "getMajorVersion", "()I", "Lio/github/arcaneplugins/levelledmobs/nametag/ServerVersionInfo$MinecraftMajorVersion;", "majorVersionEnum", "getMajorVersionEnum", "()Lio/github/arcaneplugins/levelledmobs/nametag/ServerVersionInfo$MinecraftMajorVersion;", "minorVersion", "getMinorVersion", "revision", "getRevision", "", "minecraftVersion", "getMinecraftVersion", "()D", "isOneTwentyFiveOrNewer", "", "_isRunningFabric", "Ljava/lang/Boolean;", "_isRunningSpigot", "_isRunningPaper", "_isRunningFolia", "", "nmsVersion", "getNmsVersion", "()Ljava/lang/String;", "versionPattern", "Ljava/util/regex/Pattern;", "versionShortPattern", "parseServerVersion", "parsePaperVersion", "parseBukkitVersion", "parseNMSVersion", "isRunningFabric", "()Z", "isRunningSpigot", "isRunningPaper", "isRunningFolia", "isNMSVersionValid", "toString", "MinecraftMajorVersion", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nServerVersionInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerVersionInfo.kt\nio/github/arcaneplugins/levelledmobs/nametag/ServerVersionInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,194:1\n739#2,9:195\n37#3,2:204\n*S KotlinDebug\n*F\n+ 1 ServerVersionInfo.kt\nio/github/arcaneplugins/levelledmobs/nametag/ServerVersionInfo\n*L\n76#1:195,9\n77#1:204,2\n*E\n"})
public final class ServerVersionInfo {
    private int majorVersion;
    @Nullable
    private MinecraftMajorVersion majorVersionEnum;
    private int minorVersion;
    private int revision;
    private double minecraftVersion;
    private boolean isOneTwentyFiveOrNewer;
    @Nullable
    private Boolean _isRunningFabric;
    @Nullable
    private Boolean _isRunningSpigot;
    @Nullable
    private Boolean _isRunningPaper;
    @Nullable
    private Boolean _isRunningFolia;
    @NotNull
    private String nmsVersion = "unknown";
    @NotNull
    private final Pattern versionPattern;
    @NotNull
    private final Pattern versionShortPattern;

    public ServerVersionInfo() {
        Pattern pattern = Pattern.compile(".*\\.(v\\d+_\\d+_R\\d+)(?:.+)?");
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        this.versionPattern = pattern;
        Pattern pattern2 = Pattern.compile(".*\\.(v\\d+_\\d+)(?:.+)?");
        Intrinsics.checkNotNullExpressionValue(pattern2, "compile(...)");
        this.versionShortPattern = pattern2;
    }

    public final void load() {
        this.parseServerVersion();
        this.parseNMSVersion();
    }

    public final int getMajorVersion() {
        return this.majorVersion;
    }

    @Nullable
    public final MinecraftMajorVersion getMajorVersionEnum() {
        return this.majorVersionEnum;
    }

    public final int getMinorVersion() {
        return this.minorVersion;
    }

    public final int getRevision() {
        return this.revision;
    }

    public final double getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @NotNull
    public final String getNmsVersion() {
        return this.nmsVersion;
    }

    private final void parseServerVersion() {
        if (this.isRunningPaper()) {
            this.parsePaperVersion();
        }
        boolean bl = this.isOneTwentyFiveOrNewer = this.minorVersion == 20 && this.revision >= 5 || this.minorVersion >= 21;
        if (!this.isRunningPaper() || !this.isOneTwentyFiveOrNewer) {
            this.parseBukkitVersion();
        }
    }

    private final void parsePaperVersion() {
        String string = Bukkit.getServer().getMinecraftVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getMinecraftVersion(...)");
        String minecraftVersion = string;
        String[] stringArray = new String[]{"."};
        List versions = StringsKt.split$default((CharSequence)minecraftVersion, stringArray, false, 0, 6, null);
        int n = ((Collection)versions).size();
        block5: for (int i = 0; i < n; ++i) {
            switch (i) {
                case 0: {
                    this.majorVersion = Integer.parseInt((String)versions.get(i));
                    continue block5;
                }
                case 1: {
                    this.minorVersion = Integer.parseInt((String)versions.get(i));
                    continue block5;
                }
                case 2: {
                    this.revision = Integer.parseInt((String)versions.get(i));
                }
            }
        }
        this.majorVersionEnum = MinecraftMajorVersion.valueOf("V" + this.majorVersion + "_" + this.minorVersion);
        this.minecraftVersion = Double.parseDouble(this.majorVersion + "." + this.minorVersion);
    }

    /*
     * WARNING - void declaration
     */
    private final void parseBukkitVersion() {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        String string = Bukkit.getBukkitVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getBukkitVersion(...)");
        String bukkitVersion = string;
        int firstDash = StringsKt.indexOf$default((CharSequence)bukkitVersion, "-", 0, false, 6, null);
        String string2 = bukkitVersion.substring(0, firstDash);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        Object object = string2;
        Regex regex = new Regex("\\.");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] versions = thisCollection$iv.toArray(new String[0]);
        int n2 = versions.length;
        block6: for (int i = 0; i < n2; ++i) {
            switch (i) {
                case 0: {
                    this.majorVersion = Integer.parseInt(versions[i]);
                    continue block6;
                }
                case 1: {
                    this.minorVersion = Integer.parseInt(versions[i]);
                    continue block6;
                }
                case 2: {
                    this.revision = Integer.parseInt(versions[i]);
                }
            }
        }
    }

    private final void parseNMSVersion() {
        if (this.isRunningFabric()) {
            return;
        }
        Matcher matcher = this.versionPattern.matcher(Bukkit.getServer().getClass().getCanonicalName());
        Intrinsics.checkNotNullExpressionValue(matcher, "matcher(...)");
        Matcher nmsRegex = matcher;
        Matcher matcher2 = this.versionShortPattern.matcher(Bukkit.getServer().getClass().getCanonicalName());
        Intrinsics.checkNotNullExpressionValue(matcher2, "matcher(...)");
        Matcher nmsShortRegex = matcher2;
        if (nmsShortRegex.find()) {
            String string = nmsShortRegex.group(1);
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
            String versionStr = string3;
            try {
                string2 = versionStr;
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
                String string4 = string2.toUpperCase(locale2);
                Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
                this.majorVersionEnum = MinecraftMajorVersion.valueOf(string4);
                versionStr = StringsKt.replace$default(StringsKt.replace$default(versionStr, "_", ".", false, 4, null), "V", "", false, 4, null);
                this.minecraftVersion = Double.parseDouble(versionStr);
            }
            catch (Exception e) {
                Logger logger = LevelledMobs.Companion.getInstance().getLogger();
                String string5 = "LevelledMobs: Could not extract the minecraft version from '%s'. %s";
                Object[] objectArray = new Object[]{Bukkit.getServer().getClass().getCanonicalName(), e.getMessage()};
                String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string6, "format(...)");
                logger.warning(string6);
            }
        }
        if (nmsRegex.find()) {
            this.nmsVersion = nmsRegex.group(1);
        } else if (!this.isRunningPaper()) {
            LevelledMobs.Companion.getInstance().getLogger().warning("LevelledMobs: NMSHandler, Could not match regex for bukkit version: " + Bukkit.getServer().getClass().getCanonicalName());
        }
    }

    public final boolean isRunningFabric() {
        if (this._isRunningFabric == null) {
            try {
                Class.forName("net.fabricmc.loader.api.FabricLoader");
                this._isRunningFabric = true;
            }
            catch (ClassNotFoundException ignored) {
                this._isRunningFabric = false;
            }
        }
        Boolean bl = this._isRunningFabric;
        Intrinsics.checkNotNull(bl);
        return bl;
    }

    public final boolean isRunningSpigot() {
        if (this._isRunningSpigot == null) {
            try {
                Class.forName("net.md_5.bungee.api.ChatColor");
                this._isRunningSpigot = true;
            }
            catch (ClassNotFoundException ignored) {
                this._isRunningSpigot = false;
            }
        }
        Boolean bl = this._isRunningSpigot;
        Intrinsics.checkNotNull(bl);
        return bl;
    }

    public final boolean isRunningPaper() {
        if (this._isRunningPaper == null) {
            try {
                Class.forName("com.destroystokyo.paper.ParticleBuilder");
                this._isRunningPaper = true;
            }
            catch (ClassNotFoundException ignored) {
                this._isRunningPaper = false;
            }
        }
        Boolean bl = this._isRunningPaper;
        Intrinsics.checkNotNull(bl);
        return bl;
    }

    public final boolean isRunningFolia() {
        if (this._isRunningFolia == null) {
            try {
                Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
                this._isRunningFolia = true;
            }
            catch (ClassNotFoundException ignored) {
                this._isRunningFolia = false;
            }
        }
        Boolean bl = this._isRunningFolia;
        Intrinsics.checkNotNull(bl);
        return bl;
    }

    public final boolean isNMSVersionValid() {
        return this.isOneTwentyFiveOrNewer && this.isRunningPaper() || !Intrinsics.areEqual("unknown", this.nmsVersion);
    }

    @NotNull
    public String toString() {
        return this.majorVersion + "." + this.minorVersion + "." + this.revision + " - " + this.nmsVersion;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/arcaneplugins/levelledmobs/nametag/ServerVersionInfo$MinecraftMajorVersion;", "", "<init>", "(Ljava/lang/String;I)V", "V1_19", "V1_20", "V1_21", "levelledmobs-plugin"})
    public static final class MinecraftMajorVersion
    extends Enum<MinecraftMajorVersion> {
        public static final /* enum */ MinecraftMajorVersion V1_19 = new MinecraftMajorVersion();
        public static final /* enum */ MinecraftMajorVersion V1_20 = new MinecraftMajorVersion();
        public static final /* enum */ MinecraftMajorVersion V1_21 = new MinecraftMajorVersion();
        private static final /* synthetic */ MinecraftMajorVersion[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MinecraftMajorVersion[] values() {
            return (MinecraftMajorVersion[])$VALUES.clone();
        }

        public static MinecraftMajorVersion valueOf(String value) {
            return Enum.valueOf(MinecraftMajorVersion.class, value);
        }

        @NotNull
        public static EnumEntries<MinecraftMajorVersion> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = minecraftMajorVersionArray = new MinecraftMajorVersion[]{MinecraftMajorVersion.V1_19, MinecraftMajorVersion.V1_20, MinecraftMajorVersion.V1_21};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

