/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.nametag;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.nametag.Definitions;
import io.github.arcaneplugins.levelledmobs.nametag.ServerVersionInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001J\u0006\u0010\f\u001a\u00020\u0001J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u000fJ'\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u000f2\u0010\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/github/arcaneplugins/levelledmobs/nametag/ComponentUtils;", "", "<init>", "()V", "def", "Lio/github/arcaneplugins/levelledmobs/nametag/Definitions;", "ver", "Lio/github/arcaneplugins/levelledmobs/nametag/ServerVersionInfo;", "appendComponents", "", "component", "appendingComponent", "getEmptyComponent", "getTextComponent", "text", "", "getTranslatableComponent", "key", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "levelledmobs-plugin"})
public final class ComponentUtils {
    @NotNull
    public static final ComponentUtils INSTANCE = new ComponentUtils();
    @NotNull
    private static final Definitions def = LevelledMobs.Companion.getInstance().getDefinitions();
    @NotNull
    private static final ServerVersionInfo ver = LevelledMobs.Companion.getInstance().getVer();

    private ComponentUtils() {
    }

    public final void appendComponents(@NotNull Object component, @Nullable Object appendingComponent) {
        Intrinsics.checkNotNullParameter(component, "component");
        if (appendingComponent == null) {
            return;
        }
        try {
            Method method = def.getMethodComponentAppend();
            Intrinsics.checkNotNull(method);
            Object[] objectArray = new Object[]{appendingComponent};
            method.invoke(component, objectArray);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @NotNull
    public final Object getEmptyComponent() {
        Object object = this.getTextComponent(null);
        Intrinsics.checkNotNull(object);
        return object;
    }

    @Nullable
    public final Object getTextComponent(@Nullable String text) {
        try {
            Method method = def.getMethodTextComponent();
            Intrinsics.checkNotNull(method);
            Object[] objectArray = new Object[]{text};
            return method.invoke(null, objectArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public final Object getTranslatableComponent(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.getTranslatableComponent(key, null);
    }

    @Nullable
    public final Object getTranslatableComponent(@NotNull String key, @Nullable Object[] args2) {
        Intrinsics.checkNotNullParameter(key, "key");
        try {
            Object obj;
            if (ver.getMinecraftVersion() >= 1.19) {
                Object[] objectArray = args2;
                if (objectArray == null || objectArray.length == 0 || args2[0] == null) {
                    Method method = def.getMethodTranslatable();
                    Intrinsics.checkNotNull(method);
                    objectArray = new Object[]{key};
                    return method.invoke(null, objectArray);
                }
                Method method = def.getMethodTranslatableWithArgs();
                Intrinsics.checkNotNull(method);
                objectArray = new Object[]{key, args2};
                return method.invoke(null, objectArray);
            }
            Object[] objectArray = args2;
            if (objectArray == null || objectArray.length == 0) {
                Class<?> clazz = def.getClazzTranslatableComponent();
                Intrinsics.checkNotNull(clazz);
                objectArray = new Class[]{String.class};
                Constructor<?> constructor = clazz.getConstructor((Class<?>[])objectArray);
                objectArray = new Object[]{key};
                obj = constructor.newInstance(objectArray);
            } else {
                Class<?> clazz = def.getClazzTranslatableComponent();
                Intrinsics.checkNotNull(clazz);
                objectArray = new Class[]{String.class, Object[].class};
                Constructor<?> constructor = clazz.getConstructor((Class<?>[])objectArray);
                objectArray = new Object[]{key, args2};
                obj = constructor.newInstance(objectArray);
            }
            return obj;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

