/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.misc;

import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\b\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u001f\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014J\u001f\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001f\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001cJ\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010!\u00a2\u0006\u0002\u0010\"J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0$2\u0006\u0010%\u001a\u00020\fJ\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0$2\u0006\u0010%\u001a\u00020\fJ\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0$2\u0006\u0010%\u001a\u00020\fJ\u000e\u0010(\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fJ\u0010\u0010)\u001a\u0004\u0018\u00010\u00032\u0006\u0010*\u001a\u00020\fJ\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0$2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010%\u001a\u00020\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006,"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/YmlParsingHelper;", "", "cs", "Lorg/bukkit/configuration/ConfigurationSection;", "<init>", "(Lorg/bukkit/configuration/ConfigurationSection;)V", "getCs", "()Lorg/bukkit/configuration/ConfigurationSection;", "setCs", "getBoolean", "", "name", "", "defaultValue", "getBoolean2", "(Ljava/lang/String;Ljava/lang/Boolean;)Ljava/lang/Boolean;", "getString", "getStringSet", "", "getInt", "", "getInt2", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/Integer;", "getDouble", "", "getDouble2", "(Ljava/lang/String;Ljava/lang/Double;)Ljava/lang/Double;", "getFloat", "", "getFloat2", "(Ljava/lang/String;Ljava/lang/Float;)Ljava/lang/Float;", "getIntTimeUnit", "getIntTimeUnitMS", "", "(Ljava/lang/String;Ljava/lang/Long;)Ljava/lang/Long;", "getStringOrList", "", "key", "getStringList", "getListFromConfigItem", "getKeyNameFromConfig", "objToCS", "path", "Companion", "levelledmobs-plugin"})
public final class YmlParsingHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ConfigurationSection cs;

    public YmlParsingHelper(@NotNull ConfigurationSection cs) {
        Intrinsics.checkNotNullParameter(cs, "cs");
        this.cs = cs;
    }

    @NotNull
    public final ConfigurationSection getCs() {
        return this.cs;
    }

    public final void setCs(@NotNull ConfigurationSection configurationSection) {
        Intrinsics.checkNotNullParameter(configurationSection, "<set-?>");
        this.cs = configurationSection;
    }

    public final boolean getBoolean(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.getBoolean(name, false);
    }

    public final boolean getBoolean(@NotNull String name, boolean defaultValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Companion.getBoolean(this.cs, name, defaultValue);
    }

    @Nullable
    public final Boolean getBoolean2(@NotNull String name, @Nullable Boolean defaultValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        String useName = Companion.getKeyNameFromConfig(this.cs, name);
        return this.cs.get(useName) != null ? Boolean.valueOf(this.cs.getBoolean(useName)) : defaultValue;
    }

    @Nullable
    public final String getString(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.getString(name, null);
    }

    @Nullable
    public final String getString(@NotNull String name, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Companion.getString(this.cs, name, defaultValue);
    }

    @NotNull
    public final Set<String> getStringSet(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Companion.getStringSet(this.cs, name);
    }

    public final int getInt(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.getInt(name, 0);
    }

    public final int getInt(@NotNull String name, int defaultValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        String useName = Companion.getKeyNameFromConfig(this.cs, name);
        return this.cs.getInt(useName, defaultValue);
    }

    @Nullable
    public final Integer getInt2(@NotNull String name, @Nullable Integer defaultValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        String useName = Companion.getKeyNameFromConfig(this.cs, name);
        return this.cs.get(useName) != null ? Integer.valueOf(this.cs.getInt(useName)) : defaultValue;
    }

    private final double getDouble(String name) {
        String useName = Companion.getKeyNameFromConfig(this.cs, name);
        return this.cs.getDouble(useName, 0.0);
    }

    @Nullable
    public final Double getDouble2(@NotNull String name, @Nullable Double defaultValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Companion.getDouble2(this.cs, name, defaultValue);
    }

    public final float getFloat(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.getFloat(name, 0.0f);
    }

    public final float getFloat(@NotNull String name, float defaultValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        String useName = Companion.getKeyNameFromConfig(this.cs, name);
        return (float)this.cs.getDouble(useName, (double)defaultValue);
    }

    @Nullable
    public final Float getFloat2(@NotNull String name, @Nullable Float defaultValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Companion.getFloat2(this.cs, name, defaultValue);
    }

    @Nullable
    public final Integer getIntTimeUnit(@NotNull String name, @Nullable Integer defaultValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        String useName = Companion.getKeyNameFromConfig(this.cs, name);
        if (this.cs.get(useName) != null) {
            if (this.cs.getInt(useName) > 0) {
                return this.cs.getInt(useName);
            }
            String temp = this.cs.getString(useName);
            Integer n = defaultValue;
            Long useDefaultValue = n != null ? Long.valueOf(n.intValue()) : null;
            Long result = Utils.INSTANCE.parseTimeUnit(temp, useDefaultValue, false, null);
            return result != null ? Integer.valueOf(Math.toIntExact(result)) : defaultValue;
        }
        return defaultValue;
    }

    @Nullable
    public final Long getIntTimeUnitMS(@NotNull String name, @Nullable Long defaultValue) {
        Intrinsics.checkNotNullParameter(name, "name");
        String useName = Companion.getKeyNameFromConfig(this.cs, name);
        if (this.cs.get(useName) != null) {
            if (this.cs.getLong(useName) > 0L) {
                return this.cs.getLong(useName);
            }
            String temp = this.cs.getString(useName);
            Long l = Utils.INSTANCE.parseTimeUnit(temp, defaultValue, true, null);
            if (l == null) {
                l = defaultValue;
            }
            return l;
        }
        return defaultValue;
    }

    @NotNull
    public final List<String> getStringOrList(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.getStringOrList(this.cs, key);
    }

    @NotNull
    public final List<String> getStringList(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        String useKey = Companion.getKeyNameFromConfig(this.cs, key);
        List list = this.cs.getStringList(useKey);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        return list;
    }

    @NotNull
    public final List<String> getListFromConfigItem(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return Companion.getListFromConfigItem(this.cs, key);
    }

    @NotNull
    public final String getKeyNameFromConfig(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return Companion.getKeyNameFromConfig(this.cs, key);
    }

    @Nullable
    public final ConfigurationSection objToCS(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return Companion.objToCS(this.cs, path);
    }

    @NotNull
    public final List<String> getStringOrList(@Nullable ConfigurationSection cs, @NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        List results = new ArrayList();
        if (cs == null) {
            return results;
        }
        String foundKeyName = Companion.getKeyNameFromConfig(cs, key);
        List list = cs.getStringList(foundKeyName);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List lst = list;
        if (!((Collection)lst).isEmpty()) {
            for (String item : lst) {
                if (!(((CharSequence)item.toString()).length() > 0)) continue;
                results.add(item.toString());
            }
            return results;
        }
        String temp = cs.getString(foundKeyName);
        String[] stringArray = (String[])temp;
        if (!(stringArray == null || stringArray.length() == 0)) {
            stringArray = new String[]{","};
            results.addAll(StringsKt.split$default((CharSequence)temp, stringArray, false, 0, 6, null));
        }
        return results;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010!\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\u000e\u001a\u00020\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fJ)\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ$\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tJ\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\tJ\u0016\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\tJ\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\t\u00a8\u0006\u001a"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/YmlParsingHelper$Companion;", "", "<init>", "()V", "getFloat2", "", "cs", "Lorg/bukkit/configuration/ConfigurationSection;", "name", "", "defaultValue", "(Lorg/bukkit/configuration/ConfigurationSection;Ljava/lang/String;Ljava/lang/Float;)Ljava/lang/Float;", "getStringSet", "", "getBoolean", "", "getDouble2", "", "(Lorg/bukkit/configuration/ConfigurationSection;Ljava/lang/String;Ljava/lang/Double;)Ljava/lang/Double;", "getString", "objToCS", "path", "getKeyNameFromConfig", "key", "getListFromConfigItem", "", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Float getFloat2(@Nullable ConfigurationSection cs, @NotNull String name, @Nullable Float defaultValue) {
            Intrinsics.checkNotNullParameter(name, "name");
            if (cs == null) {
                return defaultValue;
            }
            String useName = this.getKeyNameFromConfig(cs, name);
            return cs.get(useName) instanceof Float || cs.get(useName) instanceof Double || cs.get(useName) instanceof Integer ? Float.valueOf((float)cs.getDouble(useName)) : defaultValue;
        }

        @NotNull
        public final Set<String> getStringSet(@Nullable ConfigurationSection cs, @NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            if (cs == null) {
                return new LinkedHashSet();
            }
            String useName = this.getKeyNameFromConfig(cs, name);
            Set results = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
            for (String item : cs.getStringList(useName)) {
                Intrinsics.checkNotNull(item);
                if (!(((CharSequence)item).length() > 0)) continue;
                results.add(item);
            }
            return results;
        }

        public final boolean getBoolean(@Nullable ConfigurationSection cs, @NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return this.getBoolean(cs, name, false);
        }

        public final boolean getBoolean(@Nullable ConfigurationSection cs, @NotNull String name, boolean defaultValue) {
            Intrinsics.checkNotNullParameter(name, "name");
            if (cs == null) {
                return defaultValue;
            }
            String useName = this.getKeyNameFromConfig(cs, name);
            return cs.getBoolean(useName, defaultValue);
        }

        @Nullable
        public final Double getDouble2(@Nullable ConfigurationSection cs, @NotNull String name, @Nullable Double defaultValue) {
            Intrinsics.checkNotNullParameter(name, "name");
            if (cs == null) {
                return defaultValue;
            }
            String useName = this.getKeyNameFromConfig(cs, name);
            return cs.get(useName) != null ? Double.valueOf(cs.getDouble(useName)) : defaultValue;
        }

        @Nullable
        public final String getString(@Nullable ConfigurationSection cs, @NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return this.getString(cs, name, null);
        }

        @Nullable
        public final String getString(@Nullable ConfigurationSection cs, @NotNull String name, @Nullable String defaultValue) {
            Intrinsics.checkNotNullParameter(name, "name");
            if (cs == null) {
                return defaultValue;
            }
            String useName = this.getKeyNameFromConfig(cs, name);
            return cs.getString(useName, defaultValue);
        }

        @Nullable
        public final ConfigurationSection objToCS(@NotNull ConfigurationSection cs, @NotNull String path) {
            Intrinsics.checkNotNullParameter(cs, "cs");
            Intrinsics.checkNotNullParameter(path, "path");
            String useKey = this.getKeyNameFromConfig(cs, path);
            Object object = cs.get(useKey);
            if (object == null) {
                return null;
            }
            Object obj = object;
            Object object2 = obj;
            if (object2 instanceof ConfigurationSection) {
                return (ConfigurationSection)obj;
            }
            if (object2 instanceof Map) {
                MemoryConfiguration result = new MemoryConfiguration();
                Map tempList = new LinkedHashMap();
                for (Map.Entry entry : TypeIntrinsics.asMutableMap(obj).entrySet()) {
                    tempList.put(entry.getKey().toString(), entry.getValue());
                }
                result.addDefaults(tempList);
                return result.getDefaultSection();
            }
            CharSequence charSequence = cs.getCurrentPath();
            String currentPath = charSequence == null || charSequence.length() == 0 ? path : cs.getCurrentPath() + "." + path;
            Log.INSTANCE.war(currentPath + ": couldn't parse Config of type: " + obj.getClass().getSimpleName() + ", value: " + obj + " (did you put enough spaces?)");
            return null;
        }

        @NotNull
        public final String getKeyNameFromConfig(@NotNull ConfigurationSection cs, @NotNull String key) {
            Intrinsics.checkNotNullParameter(cs, "cs");
            Intrinsics.checkNotNullParameter(key, "key");
            if (!StringsKt.contains$default((CharSequence)key, ".", false, 2, null)) {
                for (String enumeratedKey : cs.getKeys(false)) {
                    if (!StringsKt.equals(key, enumeratedKey, true)) continue;
                    Intrinsics.checkNotNull(enumeratedKey);
                    return enumeratedKey;
                }
                return key;
            }
            String[] enumeratedKey = new String[]{"\\."};
            List periodSplit = StringsKt.split$default((CharSequence)key, enumeratedKey, false, 0, 6, null);
            StringBuilder sb = new StringBuilder(periodSplit.size());
            int keysFound = 0;
            for (String thisKey : periodSplit) {
                ConfigurationSection useCS;
                String string;
                boolean foundKey = false;
                if (((CharSequence)sb).length() == 0) {
                    string = thisKey;
                } else {
                    String string2 = sb.toString();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                }
                String checkKeyName = string;
                ConfigurationSection configurationSection = useCS = keysFound == 0 ? cs : this.objToCS(cs, checkKeyName);
                if (useCS == null) break;
                for (String enumeratedKey2 : useCS.getKeys(false)) {
                    if (!StringsKt.equals(thisKey, enumeratedKey2, true)) continue;
                    if (((CharSequence)sb).length() > 0) {
                        sb.append(".");
                    }
                    sb.append(enumeratedKey2);
                    foundKey = true;
                    ++keysFound;
                    break;
                }
                if (foundKey) continue;
            }
            int n = periodSplit.size();
            for (int i = keysFound; i < n; ++i) {
                if (((CharSequence)sb).length() > 0) {
                    sb.append(".");
                }
                sb.append((String)periodSplit.get(i));
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        @NotNull
        public final List<String> getListFromConfigItem(@NotNull ConfigurationSection cs, @NotNull String key) {
            Intrinsics.checkNotNullParameter(cs, "cs");
            Intrinsics.checkNotNullParameter(key, "key");
            String foundKeyName = null;
            for (String enumeratedKey : cs.getKeys(false)) {
                if (!StringsKt.equals(key, enumeratedKey, true)) continue;
                foundKeyName = enumeratedKey;
                break;
            }
            if (foundKeyName == null) {
                return new ArrayList();
            }
            List list = cs.getStringList(foundKeyName);
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            List result = list;
            if (result.isEmpty() && cs.getString(foundKeyName) != null && !Intrinsics.areEqual("", cs.getString(foundKeyName))) {
                result.add(cs.getString(foundKeyName));
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

