/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.misc;

import io.github.arcaneplugins.levelledmobs.enums.ExternalCompatibility;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002*+B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010(\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%J\b\u0010)\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\"\u00a8\u0006,"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/ExternalPluginDetection;", "", "pluginName", "", "friendlyName", "keyName", "requirement", "Lio/github/arcaneplugins/levelledmobs/misc/ExternalPluginDetection$RequirementTypes;", "keyType", "Lio/github/arcaneplugins/levelledmobs/misc/ExternalPluginDetection$KeyTypes;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/github/arcaneplugins/levelledmobs/misc/ExternalPluginDetection$RequirementTypes;Lio/github/arcaneplugins/levelledmobs/misc/ExternalPluginDetection$KeyTypes;)V", "getFriendlyName", "()Ljava/lang/String;", "setFriendlyName", "(Ljava/lang/String;)V", "requirementValue", "getRequirementValue", "setRequirementValue", "externalCompatibility", "Lio/github/arcaneplugins/levelledmobs/enums/ExternalCompatibility;", "getExternalCompatibility", "()Lio/github/arcaneplugins/levelledmobs/enums/ExternalCompatibility;", "setExternalCompatibility", "(Lio/github/arcaneplugins/levelledmobs/enums/ExternalCompatibility;)V", "placeholderName", "getPlaceholderName", "setPlaceholderName", "cachedPlugin", "Lorg/bukkit/plugin/Plugin;", "cachedMamespaceKey", "Lorg/bukkit/NamespacedKey;", "isBuiltIn", "", "()Z", "isMobOfType", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "checkPDCkey", "checkMetadataKey", "getPlaceholder", "toString", "KeyTypes", "RequirementTypes", "levelledmobs-plugin"})
public final class ExternalPluginDetection {
    @NotNull
    private final String pluginName;
    @NotNull
    private String friendlyName;
    @NotNull
    private final String keyName;
    @NotNull
    private final RequirementTypes requirement;
    @NotNull
    private final KeyTypes keyType;
    @Nullable
    private String requirementValue;
    @Nullable
    private ExternalCompatibility externalCompatibility;
    @Nullable
    private String placeholderName;
    @Nullable
    private Plugin cachedPlugin;
    @Nullable
    private NamespacedKey cachedMamespaceKey;

    public ExternalPluginDetection(@NotNull String pluginName, @NotNull String friendlyName, @NotNull String keyName, @NotNull RequirementTypes requirement, @NotNull KeyTypes keyType) {
        Intrinsics.checkNotNullParameter(pluginName, "pluginName");
        Intrinsics.checkNotNullParameter(friendlyName, "friendlyName");
        Intrinsics.checkNotNullParameter(keyName, "keyName");
        Intrinsics.checkNotNullParameter((Object)requirement, "requirement");
        Intrinsics.checkNotNullParameter((Object)keyType, "keyType");
        this.pluginName = pluginName;
        this.friendlyName = friendlyName;
        this.keyName = keyName;
        this.requirement = requirement;
        this.keyType = keyType;
    }

    @NotNull
    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final void setFriendlyName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.friendlyName = string;
    }

    @Nullable
    public final String getRequirementValue() {
        return this.requirementValue;
    }

    public final void setRequirementValue(@Nullable String string) {
        this.requirementValue = string;
    }

    @Nullable
    public final ExternalCompatibility getExternalCompatibility() {
        return this.externalCompatibility;
    }

    public final void setExternalCompatibility(@Nullable ExternalCompatibility externalCompatibility) {
        this.externalCompatibility = externalCompatibility;
    }

    @Nullable
    public final String getPlaceholderName() {
        return this.placeholderName;
    }

    public final void setPlaceholderName(@Nullable String string) {
        this.placeholderName = string;
    }

    public final boolean isBuiltIn() {
        return this.externalCompatibility != null;
    }

    public final boolean isMobOfType(@NotNull LivingEntityWrapper lmEntity) {
        boolean result;
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (this.isBuiltIn()) {
            throw new Exception("External plugin definition for " + this.friendlyName + " is built-in. Use it's corresponding internal methods");
        }
        Plugin plugin = this.cachedPlugin;
        if (plugin == null) {
            plugin = Bukkit.getPluginManager().getPlugin(this.pluginName);
            if (plugin == null || !plugin.isEnabled()) {
                return false;
            }
            this.cachedPlugin = plugin;
        }
        boolean bl = result = this.keyType == KeyTypes.PDC ? this.checkPDCkey(lmEntity) : this.checkMetadataKey(lmEntity);
        if (result) {
            lmEntity.setMobExternalType(this.friendlyName);
        }
        return result;
    }

    private final boolean checkPDCkey(LivingEntityWrapper lmEntity) {
        boolean keyExists = false;
        NamespacedKey namespaceKey = this.cachedMamespaceKey;
        if (namespaceKey == null) {
            Plugin plugin = this.cachedPlugin;
            Intrinsics.checkNotNull(plugin);
            this.cachedMamespaceKey = namespaceKey = new NamespacedKey(plugin, this.keyName);
            keyExists = lmEntity.getPdc().has(namespaceKey, PersistentDataType.STRING);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.requirement.ordinal()]) {
            case 1: {
                return keyExists;
            }
            case 2: {
                return !keyExists;
            }
            case 3: 
            case 4: {
                CharSequence charSequence = this.requirementValue;
                if (charSequence == null || charSequence.length() == 0) {
                    return false;
                }
                if (!keyExists) {
                    return false;
                }
                String keyValue = (String)lmEntity.getPdc().get(namespaceKey, PersistentDataType.STRING);
                CharSequence charSequence2 = keyValue;
                if (charSequence2 == null || charSequence2.length() == 0) {
                    return this.requirement != RequirementTypes.CONTAINS;
                }
                CharSequence charSequence3 = keyValue;
                String string = this.requirementValue;
                Intrinsics.checkNotNull(string);
                boolean itContains = StringsKt.contains(charSequence3, string, true);
                return this.requirement == RequirementTypes.CONTAINS ? itContains : !itContains;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final boolean checkMetadataKey(LivingEntityWrapper lmEntity) {
        boolean keyExists = lmEntity.getLivingEntity().hasMetadata(this.keyName);
        switch (WhenMappings.$EnumSwitchMapping$0[this.requirement.ordinal()]) {
            case 1: {
                return keyExists;
            }
            case 2: {
                return !keyExists;
            }
            case 3: 
            case 4: {
                CharSequence charSequence = this.requirementValue;
                if (charSequence == null || charSequence.length() == 0) {
                    return false;
                }
                if (!keyExists) {
                    return false;
                }
                List list = lmEntity.getLivingEntity().getMetadata(this.keyName);
                Intrinsics.checkNotNullExpressionValue(list, "getMetadata(...)");
                List keyValues = list;
                if (keyValues.isEmpty()) {
                    return this.requirement != RequirementTypes.CONTAINS;
                }
                for (MetadataValue value : keyValues) {
                    if (value == null) continue;
                    CharSequence charSequence2 = String.valueOf(value.value());
                    String string = this.requirementValue;
                    Intrinsics.checkNotNull(string);
                    boolean itContains = StringsKt.contains(charSequence2, string, true);
                    if (!itContains || this.requirement != RequirementTypes.CONTAINS) continue;
                    return true;
                }
                return this.requirement != RequirementTypes.CONTAINS;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public final String getPlaceholder(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        CharSequence charSequence = this.placeholderName;
        if (charSequence == null || charSequence.length() == 0) {
            return "";
        }
        if (this.keyType == KeyTypes.PDC) {
            NamespacedKey namespaceKey;
            Plugin plugin = this.cachedPlugin;
            if (plugin == null) {
                plugin = Bukkit.getPluginManager().getPlugin(this.pluginName);
                if (plugin == null || !plugin.isEnabled()) {
                    return "";
                }
                this.cachedPlugin = plugin;
            }
            if ((namespaceKey = this.cachedMamespaceKey) == null) {
                Plugin plugin2 = this.cachedPlugin;
                Intrinsics.checkNotNull(plugin2);
                this.cachedMamespaceKey = namespaceKey = new NamespacedKey(plugin2, this.keyName);
            }
            if (!lmEntity.getPdc().has(namespaceKey, PersistentDataType.STRING)) {
                return "";
            }
            String result = (String)lmEntity.getPdc().get(namespaceKey, PersistentDataType.STRING);
            String string = result;
            if (string == null) {
                string = "";
            }
            return string;
        }
        if (!lmEntity.getLivingEntity().hasMetadata(this.keyName)) {
            return "";
        }
        List list = lmEntity.getLivingEntity().getMetadata(this.keyName);
        Intrinsics.checkNotNullExpressionValue(list, "getMetadata(...)");
        List result = list;
        if (result.isEmpty()) {
            return "";
        }
        return String.valueOf(((MetadataValue)CollectionsKt.first(result)).value());
    }

    @NotNull
    public String toString() {
        String string = this.requirement.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String msg = this.friendlyName + ": " + this.keyName + ", keytype: " + string;
        CharSequence charSequence = this.placeholderName;
        if (!(charSequence == null || charSequence.length() == 0)) {
            msg = msg + " placeholder: " + this.placeholderName;
        }
        return msg;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/ExternalPluginDetection$KeyTypes;", "", "<init>", "(Ljava/lang/String;I)V", "METADATA", "PDC", "levelledmobs-plugin"})
    public static final class KeyTypes
    extends Enum<KeyTypes> {
        public static final /* enum */ KeyTypes METADATA = new KeyTypes();
        public static final /* enum */ KeyTypes PDC = new KeyTypes();
        private static final /* synthetic */ KeyTypes[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static KeyTypes[] values() {
            return (KeyTypes[])$VALUES.clone();
        }

        public static KeyTypes valueOf(String value) {
            return Enum.valueOf(KeyTypes.class, value);
        }

        @NotNull
        public static EnumEntries<KeyTypes> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = keyTypesArray = new KeyTypes[]{KeyTypes.METADATA, KeyTypes.PDC};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lio/github/arcaneplugins/levelledmobs/misc/ExternalPluginDetection$RequirementTypes;", "", "<init>", "(Ljava/lang/String;I)V", "EXISTS", "NOT_EXISTS", "CONTAINS", "NOT_CONTAINS", "levelledmobs-plugin"})
    public static final class RequirementTypes
    extends Enum<RequirementTypes> {
        public static final /* enum */ RequirementTypes EXISTS = new RequirementTypes();
        public static final /* enum */ RequirementTypes NOT_EXISTS = new RequirementTypes();
        public static final /* enum */ RequirementTypes CONTAINS = new RequirementTypes();
        public static final /* enum */ RequirementTypes NOT_CONTAINS = new RequirementTypes();
        private static final /* synthetic */ RequirementTypes[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RequirementTypes[] values() {
            return (RequirementTypes[])$VALUES.clone();
        }

        public static RequirementTypes valueOf(String value) {
            return Enum.valueOf(RequirementTypes.class, value);
        }

        @NotNull
        public static EnumEntries<RequirementTypes> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = requirementTypesArray = new RequirementTypes[]{RequirementTypes.EXISTS, RequirementTypes.NOT_EXISTS, RequirementTypes.CONTAINS, RequirementTypes.NOT_CONTAINS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequirementTypes.values().length];
            try {
                nArray[RequirementTypes.EXISTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequirementTypes.NOT_EXISTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequirementTypes.CONTAINS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequirementTypes.NOT_CONTAINS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

