/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.managers;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.misc.LastMobKilledInfo;
import io.github.arcaneplugins.levelledmobs.misc.StringReplacer;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u001f\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/PlaceholderApiIntegration;", "Lme/clip/placeholderapi/expansion/PlaceholderExpansion;", "<init>", "()V", "mobsByPlayerTracking", "", "Ljava/util/UUID;", "Lio/github/arcaneplugins/levelledmobs/misc/LastMobKilledInfo;", "playerDeathInfo", "putPlayerOrMobDeath", "", "player", "Lorg/bukkit/entity/Player;", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "isPlayerDeath", "", "putPlayerKillerInfo", "playedLoggedOut", "removePlayer", "persist", "canRegister", "getIdentifier", "", "getAuthor", "getVersion", "onPlaceholderRequest", "identifier", "getLevelFromPlayer", "getDisplaynameFromPlayer", "getKilledByInfo", "getMobNametagWithinPlayerSight", "getMobBeingLookedAt", "Lorg/bukkit/entity/LivingEntity;", "levelledmobs-plugin"})
public final class PlaceholderApiIntegration
extends PlaceholderExpansion {
    @NotNull
    private final Map<UUID, LastMobKilledInfo> mobsByPlayerTracking = new LinkedHashMap();
    @NotNull
    private final Map<UUID, LastMobKilledInfo> playerDeathInfo = new LinkedHashMap();

    public final void putPlayerOrMobDeath(@NotNull Player player, @Nullable LivingEntityWrapper lmEntity, boolean isPlayerDeath) {
        Intrinsics.checkNotNullParameter(player, "player");
        LastMobKilledInfo lastMobKilledInfo = this.mobsByPlayerTracking.computeIfAbsent(player.getUniqueId(), arg_0 -> PlaceholderApiIntegration.putPlayerOrMobDeath$lambda$1(PlaceholderApiIntegration::putPlayerOrMobDeath$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(lastMobKilledInfo, "computeIfAbsent(...)");
        LastMobKilledInfo mobInfo = lastMobKilledInfo;
        mobInfo.setEntityLevel(lmEntity != null && lmEntity.isLevelled() ? Integer.valueOf(lmEntity.getGetMobLevel()) : null);
        mobInfo.setEntityName(lmEntity != null ? LevelledMobs.Companion.getInstance().getLevelManager().getNametag(lmEntity, false).getNametag() : null);
        if (isPlayerDeath) {
            this.putPlayerKillerInfo(player, lmEntity);
        }
    }

    private final void putPlayerKillerInfo(Player player, LivingEntityWrapper lmEntity) {
        LastMobKilledInfo mobInfo = new LastMobKilledInfo();
        this.playerDeathInfo.put(player.getUniqueId(), mobInfo);
        mobInfo.setEntityLevel(lmEntity != null && lmEntity.isLevelled() ? Integer.valueOf(lmEntity.getGetMobLevel()) : null);
        mobInfo.setEntityName(lmEntity != null ? LevelledMobs.Companion.getInstance().getLevelManager().getNametag(lmEntity, false).getNametag() : null);
    }

    public final void playedLoggedOut(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.mobsByPlayerTracking.remove(player.getUniqueId());
    }

    public final void removePlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.mobsByPlayerTracking.remove(player.getUniqueId());
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getIdentifier() {
        String string = LevelledMobs.Companion.getInstance().getDescription().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }

    @NotNull
    public String getAuthor() {
        return LevelledMobs.Companion.getInstance().getDescription().getAuthors().toString();
    }

    @NotNull
    public String getVersion() {
        String string = LevelledMobs.Companion.getInstance().getDescription().getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        return string;
    }

    @Nullable
    public String onPlaceholderRequest(@Nullable Player player, @NotNull String identifier) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        if (player == null) {
            return "";
        }
        if (StringsKt.equals("mob-lvl", identifier, true)) {
            return this.getLevelFromPlayer(player);
        }
        if (StringsKt.equals("displayname", identifier, true)) {
            return this.getDisplaynameFromPlayer(player);
        }
        if (StringsKt.equals("mob-target", identifier, true)) {
            return this.getMobNametagWithinPlayerSight(player);
        }
        if (StringsKt.equals("killed-by", identifier, true)) {
            return this.getKilledByInfo(player);
        }
        return null;
    }

    private final String getLevelFromPlayer(Player player) {
        LastMobKilledInfo mobInfo;
        if (!this.mobsByPlayerTracking.containsKey(player.getUniqueId())) {
            return "";
        }
        LastMobKilledInfo lastMobKilledInfo = mobInfo = this.mobsByPlayerTracking.get(player.getUniqueId());
        Intrinsics.checkNotNull(lastMobKilledInfo);
        return lastMobKilledInfo.getEntityLevel() == null ? "" : String.valueOf(mobInfo.getEntityLevel());
    }

    private final String getDisplaynameFromPlayer(Player player) {
        LastMobKilledInfo mobInfo;
        if (!this.mobsByPlayerTracking.containsKey(player.getUniqueId())) {
            return "";
        }
        LastMobKilledInfo lastMobKilledInfo = mobInfo = this.mobsByPlayerTracking.get(player.getUniqueId());
        return (lastMobKilledInfo != null ? lastMobKilledInfo.getEntityName() : null) == null ? "" : mobInfo.getEntityName() + "&r";
    }

    private final String getKilledByInfo(Player player) {
        LastMobKilledInfo mobInfo;
        if (!this.playerDeathInfo.containsKey(player.getUniqueId())) {
            return "";
        }
        LastMobKilledInfo lastMobKilledInfo = mobInfo = this.playerDeathInfo.get(player.getUniqueId());
        return (lastMobKilledInfo != null ? lastMobKilledInfo.getEntityName() : null) == null ? "" : MessageUtils.INSTANCE.colorizeAll(mobInfo.getEntityName() + "&r");
    }

    private final String getMobNametagWithinPlayerSight(Player player) {
        if (player == null) {
            return "";
        }
        LivingEntity livingEntity = this.getMobBeingLookedAt(player);
        if (livingEntity == null) {
            return "";
        }
        LivingEntity targetMob = livingEntity;
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(targetMob);
        Object nametag = lmEntity.getMain().getRulesManager().getRuleNametagPlaceholder(lmEntity);
        CharSequence charSequence = (CharSequence)nametag;
        if (!(charSequence == null || charSequence.length() == 0)) {
            boolean useCustomNameForNametags = lmEntity.getMain().getHelperSettings().getBoolean("use-customname-for-mob-nametags");
            nametag = lmEntity.getMain().getLevelManager().updateNametag(lmEntity, new StringReplacer((String)nametag), useCustomNameForNametags, null).getNametagNonNull();
            if (StringsKt.equals("disabled", (String)nametag, true)) {
                return "";
            }
        }
        if (((charSequence = (CharSequence)nametag) == null || charSequence.length() == 0) && lmEntity.isLevelled()) {
            nametag = lmEntity.getMain().getLevelManager().getNametag(lmEntity, false).getNametag() + "&r";
        }
        lmEntity.free();
        if (nametag != null) {
            if (StringsKt.endsWith$default((String)nametag, "&r", false, 2, null)) {
                String string = ((String)nametag).substring(0, ((String)nametag).length() - 2);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                nametag = string;
            }
            return nametag;
        }
        return "";
    }

    private final LivingEntity getMobBeingLookedAt(Player player) {
        LivingEntity livingEntity = null;
        Location location = player.getEyeLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getEyeLocation(...)");
        Location eye = location;
        int maxBlocks = LevelledMobs.Companion.getInstance().getHelperSettings().getInt("nametag-placeholder-maxblocks", 30);
        for (Entity entity : player.getNearbyEntities((double)maxBlocks, (double)maxBlocks, (double)maxBlocks)) {
            Vector toEntity;
            if (!(entity instanceof LivingEntity)) continue;
            Intrinsics.checkNotNullExpressionValue(((LivingEntity)entity).getEyeLocation().toVector().subtract(eye.toVector()), "subtract(...)");
            double dot = toEntity.normalize().dot(eye.getDirection());
            if (!(dot >= 0.975)) continue;
            livingEntity = (LivingEntity)entity;
            break;
        }
        return livingEntity;
    }

    private static final LastMobKilledInfo putPlayerOrMobDeath$lambda$0(UUID uUID) {
        return new LastMobKilledInfo();
    }

    private static final LastMobKilledInfo putPlayerOrMobDeath$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (LastMobKilledInfo)$tmp0.invoke(p0);
    }
}

