/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.managers;

import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tJ\b\u0010\u0015\u001a\u00020\u000eH\u0002J\u0006\u0010\u0016\u001a\u00020\u0013R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000e8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/NotifyManager;", "", "<init>", "()V", "lastNotification", "Ljava/time/Instant;", "MIN_NOTIFY_SECONDS", "", "value", "", "pendingMessage", "getPendingMessage", "()Ljava/lang/String;", "opGotNotified", "", "opHasMessage", "getOpHasMessage", "()Z", "notifyOfError", "", "message", "canNotify", "clearLastError", "levelledmobs-plugin"})
public final class NotifyManager {
    @NotNull
    public static final NotifyManager INSTANCE = new NotifyManager();
    @Nullable
    private static Instant lastNotification;
    private static final long MIN_NOTIFY_SECONDS = 30L;
    @Nullable
    private static String pendingMessage;
    private static boolean opGotNotified;
    private static boolean opHasMessage;

    private NotifyManager() {
    }

    @Nullable
    public final String getPendingMessage() {
        return pendingMessage;
    }

    public final boolean getOpHasMessage() {
        return pendingMessage != null && !opGotNotified;
    }

    public final void notifyOfError(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (!this.canNotify()) {
            return;
        }
        Log.INSTANCE.sev(message);
        lastNotification = Instant.now();
        pendingMessage = null;
        opGotNotified = false;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.isOp()) continue;
            opGotNotified = true;
            player.sendMessage(MessageUtils.INSTANCE.colorizeStandardCodes("Severe: &c" + message + "&r"));
        }
        if (!opGotNotified) {
            pendingMessage = message;
        }
    }

    private final boolean canNotify() {
        if (lastNotification == null) {
            return true;
        }
        long duration = Duration.between(lastNotification, Instant.now()).toSeconds();
        return duration > 30L;
    }

    public final void clearLastError() {
        lastNotification = null;
        pendingMessage = null;
    }
}

