/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.managers;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.enums.NametagVisibilityEnum;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.NametagTimerChecker;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.nametag.NametagSender;
import io.github.arcaneplugins.levelledmobs.nametag.NametagSenderHandler;
import io.github.arcaneplugins.levelledmobs.result.NametagResult;
import io.github.arcaneplugins.levelledmobs.util.LibsDisguisesUtils;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.time.Instant;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0012J\u0006\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\fJ\b\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\fH\u0002J&\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J\u0018\u0010%\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020&H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/NametagQueueManager;", "", "<init>", "()V", "isRunning", "", "doThread", "nametagSender", "Lio/github/arcaneplugins/levelledmobs/nametag/NametagSender;", "hasLibsDisguisesInstalled", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lio/github/arcaneplugins/levelledmobs/misc/QueueItem;", "nametagSenderHandler", "Lio/github/arcaneplugins/levelledmobs/nametag/NametagSenderHandler;", "getNametagSenderHandler", "()Lio/github/arcaneplugins/levelledmobs/nametag/NametagSenderHandler;", "load", "", "hasNametagSupport", "getHasNametagSupport", "()Z", "start", "stop", "addToQueue", "item", "mainThread", "preProcessItem", "processItem", "updateNametag", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "nametag", "Lio/github/arcaneplugins/levelledmobs/result/NametagResult;", "players", "", "Lorg/bukkit/entity/Player;", "updateNametagCustomName", "", "levelledmobs-plugin"})
public final class NametagQueueManager {
    private boolean isRunning;
    private boolean doThread;
    @Nullable
    private NametagSender nametagSender;
    private boolean hasLibsDisguisesInstalled;
    @NotNull
    private final LinkedBlockingQueue<QueueItem> queue = new LinkedBlockingQueue();
    @NotNull
    private final NametagSenderHandler nametagSenderHandler = new NametagSenderHandler();

    @NotNull
    public final NametagSenderHandler getNametagSenderHandler() {
        return this.nametagSenderHandler;
    }

    public final void load() {
        this.hasLibsDisguisesInstalled = ExternalCompatibilityManager.Companion.getHasLibsDisguisesInstalled();
        this.nametagSender = this.nametagSenderHandler.getCurrentUtil();
    }

    public final boolean getHasNametagSupport() {
        return this.nametagSender != null;
    }

    public final void start() {
        if (this.isRunning) {
            return;
        }
        this.doThread = true;
        this.isRunning = true;
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> NametagQueueManager.start$lambda$0(this));
        scheduler.run();
    }

    public final void stop() {
        this.doThread = false;
    }

    public final void addToQueue(@NotNull QueueItem item) {
        Intrinsics.checkNotNullParameter(item, "item");
        if (!item.getLmEntity().getShouldShowLMNametag()) {
            return;
        }
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            return;
        }
        if (LevelledMobs.Companion.getInstance().getRulesManager().getRuleCreatureNametagVisbility(item.getLmEntity()).contains((Object)NametagVisibilityEnum.DISABLED)) {
            return;
        }
        item.getLmEntity().getInUseCount().getAndIncrement();
        this.queue.offer(item);
    }

    private final void mainThread() throws InterruptedException {
        while (this.doThread) {
            QueueItem item;
            if (this.queue.poll(200L, TimeUnit.MILLISECONDS) == null) continue;
            SchedulerWrapper scheduler = new SchedulerWrapper((Entity)item.getLmEntity().getLivingEntity(), () -> NametagQueueManager.mainThread$lambda$1(this, item));
            scheduler.setRunDirectlyInBukkit(true);
            scheduler.setEntity((Entity)item.getLmEntity().getLivingEntity());
            item.getLmEntity().getInUseCount().getAndIncrement();
            scheduler.run();
        }
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void preProcessItem(QueueItem item) {
        if (!item.getLmEntity().isPopulated()) {
            item.getLmEntity().free();
            return;
        }
        String lastEntityType = null;
        try {
            lastEntityType = item.getLmEntity().getNameIfBaby();
            this.processItem(item);
        }
        catch (Exception ex) {
            String string = lastEntityType;
            if (string == null) {
                string = "Unknown Entity";
            }
            String entityName = string;
            Log.INSTANCE.sev("Unable to process nametag update for '" + entityName + "'. ");
            ex.printStackTrace();
        }
        finally {
            item.getLmEntity().free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processItem(QueueItem item) {
        Object object;
        if (this.nametagSender == null) {
            return;
        }
        long nametagTimerResetTime = item.getLmEntity().getNametagCooldownTime();
        if (nametagTimerResetTime > 0L) {
            NametagResult nametagResult = item.getNametag();
            Intrinsics.checkNotNull(nametagResult);
            if (!nametagResult.isNullOrEmpty()) {
                Object object2 = NametagTimerChecker.Companion.getNametagTimer_Lock();
                synchronized (object2) {
                    boolean bl = false;
                    Map<Player, WeakHashMap<LivingEntity, Instant>> nametagCooldownQueue = LevelledMobs.Companion.getInstance().getNametagTimerChecker().getNametagCooldownQueue();
                    if (item.getLmEntity().getPlayersNeedingNametagCooldownUpdate() != null) {
                        Set<Player> set = item.getLmEntity().getPlayersNeedingNametagCooldownUpdate();
                        Intrinsics.checkNotNull(set);
                        for (Player entry : set) {
                            if (!nametagCooldownQueue.containsKey(entry)) continue;
                            WeakHashMap<LivingEntity, Instant> weakHashMap = nametagCooldownQueue.get(entry);
                            if (weakHashMap != null) {
                                ((Map)weakHashMap).put(item.getLmEntity().getLivingEntity(), Instant.now());
                            }
                            ((Map)LevelledMobs.Companion.getInstance().getNametagTimerChecker().getCooldownTimes()).put(item.getLmEntity().getLivingEntity(), item.getLmEntity().getNametagCooldownTime());
                        }
                        for (Map.Entry entry : nametagCooldownQueue.entrySet()) {
                            Player player = (Player)entry.getKey();
                            WeakHashMap value = (WeakHashMap)entry.getValue();
                            Set<Player> set2 = item.getLmEntity().getPlayersNeedingNametagCooldownUpdate();
                            Intrinsics.checkNotNull(set2);
                            if (set2.contains(player) || !value.containsKey(item.getLmEntity().getLivingEntity())) continue;
                            Set<Player> set3 = item.getLmEntity().getPlayersNeedingNametagCooldownUpdate();
                            Intrinsics.checkNotNull(set3);
                            set3.add(player);
                        }
                    } else {
                        for (Map.Entry<Player, WeakHashMap<LivingEntity, Instant>> entry : nametagCooldownQueue.entrySet()) {
                            Player key = entry.getKey();
                            WeakHashMap<LivingEntity, Instant> value = entry.getValue();
                            if (!value.containsKey(item.getLmEntity().getLivingEntity())) continue;
                            if (item.getLmEntity().getPlayersNeedingNametagCooldownUpdate() == null) {
                                item.getLmEntity().setPlayersNeedingNametagCooldownUpdate(new HashSet());
                            }
                            Set<Player> set = item.getLmEntity().getPlayersNeedingNametagCooldownUpdate();
                            Intrinsics.checkNotNull(set);
                            set.add(key);
                        }
                    }
                    object = Unit.INSTANCE;
                }
            }
        }
        if (item.getLmEntity().getPlayersNeedingNametagCooldownUpdate() != null) {
            item.getLmEntity().setPlayersNeedingNametagCooldownUpdate(null);
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        object = NametagTimerChecker.Companion.getEntityTarget_Lock();
        synchronized (object) {
            boolean bl = false;
            if (main.getNametagTimerChecker().getEntityTargetMap().containsKey(item.getLmEntity().getLivingEntity())) {
                if (item.getLmEntity().getPlayersNeedingNametagCooldownUpdate() == null) {
                    item.getLmEntity().setPlayersNeedingNametagCooldownUpdate(new LinkedHashSet());
                }
                Set<Player> set = item.getLmEntity().getPlayersNeedingNametagCooldownUpdate();
                Intrinsics.checkNotNull(set);
                Player player = main.getNametagTimerChecker().getEntityTargetMap().get(item.getLmEntity().getLivingEntity());
                Intrinsics.checkNotNull(player);
                set.add(player);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (!item.getLmEntity().isPopulated()) {
            return;
        }
        if (main.getHelperSettings().getBoolean("use-customname-for-mob-nametags")) {
            LivingEntityWrapper livingEntityWrapper = item.getLmEntity();
            NametagResult nametagResult = item.getNametag();
            Intrinsics.checkNotNull(nametagResult);
            this.updateNametagCustomName(livingEntityWrapper, nametagResult.getNametagNonNull());
            return;
        }
        if (main.getHelperSettings().getBoolean("assert-entity-validity-with-nametag-packets") && !item.getLmEntity().getLivingEntity().isValid()) {
            return;
        }
        LivingEntityWrapper livingEntityWrapper = item.getLmEntity();
        NametagResult nametagResult = item.getNametag();
        Intrinsics.checkNotNull(nametagResult);
        List<Player> list = item.getPlayers();
        Intrinsics.checkNotNull(list);
        this.updateNametag(livingEntityWrapper, nametagResult, list);
    }

    private final void updateNametag(LivingEntityWrapper lmEntity, NametagResult nametag, List<Player> players) {
        int loopCount = lmEntity.getPlayersNeedingNametagCooldownUpdate() == null ? 1 : 2;
        for (int i = 0; i < loopCount; ++i) {
            boolean doAlwaysVisible;
            List<NametagVisibilityEnum> nametagVisibilityEnum = LevelledMobs.Companion.getInstance().getRulesManager().getRuleCreatureNametagVisbility(lmEntity);
            boolean bl = doAlwaysVisible = i == 1 || !nametag.isNullOrEmpty() && lmEntity.getLivingEntity().isCustomNameVisible() || nametagVisibilityEnum.contains((Object)NametagVisibilityEnum.ALWAYS_ON);
            if (i == 0) {
                for (Player player : players) {
                    if (lmEntity.getPlayersNeedingNametagCooldownUpdate() != null) {
                        Set<Player> set = lmEntity.getPlayersNeedingNametagCooldownUpdate();
                        Intrinsics.checkNotNull(set);
                        if (set.contains(player)) continue;
                    }
                    NametagSender nametagSender = this.nametagSender;
                    Intrinsics.checkNotNull(nametagSender);
                    nametagSender.sendNametag(lmEntity.getLivingEntity(), nametag, player, doAlwaysVisible);
                }
            } else {
                Set<Player> set = lmEntity.getPlayersNeedingNametagCooldownUpdate();
                Intrinsics.checkNotNull(set);
                for (Player player : set) {
                    NametagSender nametagSender = this.nametagSender;
                    Intrinsics.checkNotNull(nametagSender);
                    nametagSender.sendNametag(lmEntity.getLivingEntity(), nametag, player, true);
                }
            }
            if (!this.hasLibsDisguisesInstalled || !LibsDisguisesUtils.INSTANCE.isMobUsingLibsDisguises(lmEntity)) continue;
            String useNametag = nametag.getNametag() != null ? MessageUtils.INSTANCE.colorizeAll(nametag.getNametag()) : null;
            LibsDisguisesUtils.INSTANCE.updateLibsDisguiseNametag(lmEntity, useNametag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateNametagCustomName(LivingEntityWrapper lmEntity, String nametag) {
        PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        synchronized (persistentDataContainer2) {
            boolean bl = false;
            if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getHasCustomNameTag(), PersistentDataType.INTEGER)) {
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        boolean hadCustomName = lmEntity.getLivingEntity().getCustomName() != null;
        lmEntity.getLivingEntity().setCustomName(nametag);
        lmEntity.getLivingEntity().setCustomNameVisible(true);
        boolean isTamable = lmEntity.getLivingEntity() instanceof Tameable;
        if (!(hadCustomName || isTamable || StringsKt.equals(lmEntity.getTypeName(), "Axolotl", true))) {
            lmEntity.getLivingEntity().setRemoveWhenFarAway(true);
        }
    }

    private static final void start$lambda$0(NametagQueueManager this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            this$0.mainThread();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Log.INSTANCE.inf("Nametag update queue Manager has exited");
    }

    private static final void mainThread$lambda$1(NametagQueueManager this$0, QueueItem $item) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($item, "$item");
        this$0.preProcessItem($item);
        $item.getLmEntity().free();
    }
}

