/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.managers;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.misc.EvaluationException;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\tJ\b\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/MobsQueueManager;", "", "<init>", "()V", "isRunning", "", "doThread", "queue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lio/github/arcaneplugins/levelledmobs/misc/QueueItem;", "processingList", "", "Ljava/util/UUID;", "maxThreads", "", "threadsCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "queueLock", "start", "", "clearQueue", "doneWithThread", "stop", "addToQueue", "item", "mainThread", "processItem", "levelledmobs-plugin"})
public final class MobsQueueManager {
    private boolean isRunning;
    private boolean doThread;
    @NotNull
    private final LinkedBlockingQueue<QueueItem> queue = new LinkedBlockingQueue();
    @NotNull
    private final List<UUID> processingList = new ArrayList();
    private final int maxThreads;
    @NotNull
    private final AtomicInteger threadsCount = new AtomicInteger();
    @NotNull
    private final Object queueLock = new Object();

    public MobsQueueManager() {
        this.maxThreads = 3;
    }

    public final void start() {
        if (this.isRunning) {
            return;
        }
        this.doThread = true;
        this.isRunning = true;
        if (!LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            Runnable bgThread = () -> MobsQueueManager.start$lambda$0(this);
            int n = this.maxThreads;
            for (int i = 0; i < n; ++i) {
                this.threadsCount.getAndIncrement();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)LevelledMobs.Companion.getInstance(), bgThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearQueue() {
        Object object = this.queueLock;
        synchronized (object) {
            boolean bl = false;
            this.queue.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void doneWithThread() {
        this.threadsCount.getAndDecrement();
        if (this.threadsCount.get() == 0) {
            this.isRunning = false;
            Log.INSTANCE.inf("Mob processing queue Manager has exited");
        }
    }

    public final void stop() {
        this.doThread = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addToQueue(@NotNull QueueItem item) {
        Intrinsics.checkNotNullParameter(item, "item");
        item.getLmEntity().getInUseCount().getAndIncrement();
        if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            SchedulerWrapper wrapper = new SchedulerWrapper((Entity)item.getLmEntity().getLivingEntity(), () -> MobsQueueManager.addToQueue$lambda$2(this, item));
            wrapper.run();
        } else {
            boolean offeredItem = false;
            Object object = this.queueLock;
            synchronized (object) {
                boolean bl = false;
                if (!this.processingList.contains(item.getEntityId())) {
                    this.queue.offer(item);
                    offeredItem = true;
                }
                Unit unit = Unit.INSTANCE;
            }
            if (!offeredItem) {
                item.getLmEntity().free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mainThread() {
        while (this.doThread) {
            QueueItem item = null;
            Object object = this.queueLock;
            synchronized (object) {
                boolean $i$a$-synchronized-MobsQueueManager$mainThread$32 = false;
                item = this.queue.poll();
                if (item != null) {
                    this.processingList.add(item.getEntityId());
                }
                Unit $i$a$-synchronized-MobsQueueManager$mainThread$32 = Unit.INSTANCE;
            }
            if (item == null) {
                Thread.sleep(2L);
                continue;
            }
            try {
                this.processItem(item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                object = this.queueLock;
                synchronized (object) {
                    boolean bl = false;
                    boolean bl2 = this.processingList.remove(item.getEntityId());
                }
                item.getLmEntity().free();
            }
        }
        this.doneWithThread();
    }

    private final void processItem(QueueItem item) {
        if (!item.getLmEntity().isPopulated()) {
            return;
        }
        if (!item.getLmEntity().getShouldShowLMNametag()) {
            return;
        }
        try {
            LevelledMobs.Companion.getInstance().getLevelManager().getEntitySpawnListener().preprocessMob(item.getLmEntity(), item.getEvent());
        }
        catch (EvaluationException evaluationException) {
        }
        catch (TimeoutException e) {
            DebugManager.Companion.log(DebugType.APPLY_LEVEL_RESULT, item.getLmEntity(), false, MobsQueueManager::processItem$lambda$6);
        }
    }

    private static final void start$lambda$0(MobsQueueManager this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            this$0.mainThread();
        }
        catch (InterruptedException ignored) {
            this$0.isRunning = false;
        }
        this$0.doneWithThread();
    }

    private static final void addToQueue$lambda$2(MobsQueueManager this$0, QueueItem $item) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($item, "$item");
        this$0.processItem($item);
        $item.getLmEntity().free();
    }

    private static final String processItem$lambda$6() {
        return "Timed out applying level to mob";
    }
}

