/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.managers;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.Addition;
import io.github.arcaneplugins.levelledmobs.enums.VanillaBonusEnum;
import io.github.arcaneplugins.levelledmobs.libs.crunch.Crunch;
import io.github.arcaneplugins.levelledmobs.libs.crunch.functional.EvaluationEnvironment;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.misc.CachedModalList;
import io.github.arcaneplugins.levelledmobs.misc.StringReplacer;
import io.github.arcaneplugins.levelledmobs.result.AttributePreMod;
import io.github.arcaneplugins.levelledmobs.result.EvaluationResult;
import io.github.arcaneplugins.levelledmobs.result.MultiplierResult;
import io.github.arcaneplugins.levelledmobs.rules.FineTuningAttributes;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0010\b\u0002\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0019J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006$"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/MobDataManager;", "", "<init>", "()V", "vanillaMultiplierNames", "", "", "Lio/github/arcaneplugins/levelledmobs/enums/VanillaBonusEnum;", "getVanillaMultiplierNames", "()Ljava/util/Map;", "isLevelledDropManaged", "", "material", "Lorg/bukkit/Material;", "prepareSetAttributes", "Lio/github/arcaneplugins/levelledmobs/result/AttributePreMod;", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "attribute", "Lorg/bukkit/attribute/Attribute;", "addition", "Lio/github/arcaneplugins/levelledmobs/enums/Addition;", "setAttributeMods", "", "attribInfos", "", "removeExistingMultipliers", "attrib", "Lorg/bukkit/attribute/AttributeInstance;", "getAllAttributeValues", "whichOnes", "getAdditionsForLevel", "Lio/github/arcaneplugins/levelledmobs/result/MultiplierResult;", "defaultValue", "", "Companion", "levelledmobs-plugin"})
public final class MobDataManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, VanillaBonusEnum> vanillaMultiplierNames = new LinkedHashMap();
    private static MobDataManager instance;
    @NotNull
    private static final EvaluationEnvironment crunchEvalEnv;

    public MobDataManager() {
        instance = this;
        Pair[] pairArray = new Pair[]{TuplesKt.to("Armor modifier", VanillaBonusEnum.ARMOR_MODIFIER), TuplesKt.to("Armor toughness", VanillaBonusEnum.ARMOR_TOUGHNESS), TuplesKt.to("Attacking speed boost", VanillaBonusEnum.ATTACKING_SPEED_BOOST), TuplesKt.to("Baby speed boost", VanillaBonusEnum.BABY_SPEED_BOOST), TuplesKt.to("Covered armor bonus", VanillaBonusEnum.COVERED_ARMOR_BONUS), TuplesKt.to("Drinking speed penalty", VanillaBonusEnum.DRINKING_SPEED_PENALTY), TuplesKt.to("Fleeing speed boost", VanillaBonusEnum.FLEEING_SPEED_BOOST), TuplesKt.to("Horse armor bonus", VanillaBonusEnum.HORSE_ARMOR_BONUS), TuplesKt.to("Knockback resistance", VanillaBonusEnum.KNOCKBACK_RESISTANCE), TuplesKt.to("Leader zombie bonus", VanillaBonusEnum.LEADER_ZOMBIE_BONUS), TuplesKt.to("Random spawn bonus", VanillaBonusEnum.RANDOM_SPAWN_BONUS), TuplesKt.to("Random zombie-spawn bonus", VanillaBonusEnum.RANDOM_ZOMBIE_SPAWN_BONUS), TuplesKt.to("Sprinting speed boost", VanillaBonusEnum.SPRINTING_SPEED_BOOST), TuplesKt.to("Tool modifier", VanillaBonusEnum.TOOL_MODIFIER), TuplesKt.to("Weapon modifier", VanillaBonusEnum.WEAPON_MODIFIER), TuplesKt.to("Zombie reinforcement caller charge", VanillaBonusEnum.ZOMBIE_REINFORCE_CALLER), TuplesKt.to("Zombie reinforcement callee charge", VanillaBonusEnum.ZOMBIE_REINFORCE_CALLEE)};
        this.vanillaMultiplierNames.putAll(MapsKt.mapOf(pairArray));
        crunchEvalEnv.addFunction("between", 3, MobDataManager::_init_$lambda$0);
        crunchEvalEnv.addFunction("clamp", 3, MobDataManager::_init_$lambda$1);
    }

    @NotNull
    public final Map<String, VanillaBonusEnum> getVanillaMultiplierNames() {
        return this.vanillaMultiplierNames;
    }

    public final boolean isLevelledDropManaged(@NotNull Material material) {
        Intrinsics.checkNotNullParameter(material, "material");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (StringsKt.endsWith$default(material.toString(), "_HEAD", false, 2, null) || StringsKt.endsWith$default(material.toString(), "_SKULL", false, 2, null)) {
            return main.getHelperSettings().getBoolean("mobs-multiply-head-drops");
        }
        return false;
    }

    @Nullable
    public final AttributePreMod prepareSetAttributes(@NotNull LivingEntityWrapper lmEntity, @NotNull Attribute attribute, @NotNull Addition addition) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        Intrinsics.checkNotNullParameter((Object)addition, "addition");
        AttributeInstance attributeInstance = lmEntity.getAttributeValuesCache();
        if (attributeInstance == null || (attributeInstance = attributeInstance.get(attribute)) == null) {
            return null;
        }
        AttributeInstance attribInstance = attributeInstance;
        float defaultValue = (float)attribInstance.getBaseValue();
        MultiplierResult multiplierResult = this.getAdditionsForLevel(lmEntity, addition, defaultValue);
        float additionValue = multiplierResult.getAmount();
        if (additionValue == 0.0f) {
            return null;
        }
        AttributeModifier.Operation modifierOperation = multiplierResult.isAddition() ? AttributeModifier.Operation.ADD_NUMBER : AttributeModifier.Operation.MULTIPLY_SCALAR_1;
        AttributeModifier mod = new AttributeModifier(attribute.name(), (double)additionValue, modifierOperation);
        if (attribute == Attribute.ZOMBIE_SPAWN_REINFORCEMENTS && lmEntity.getEntityType() == EntityType.ZOMBIFIED_PIGLIN) {
            return null;
        }
        return new AttributePreMod(mod, multiplierResult, attribute);
    }

    public final void setAttributeMods(@NotNull LivingEntityWrapper lmEntity, @NotNull List<AttributePreMod> attribInfos) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(attribInfos, "attribInfos");
        for (AttributePreMod info : attribInfos) {
            AttributeInstance attrib;
            double existingDamage;
            AttributeInstance maxHealth;
            float additionValue = info.getMultiplierResult().getAmount();
            if (additionValue == 0.0f) {
                return;
            }
            if (lmEntity.getLivingEntity().getAttribute(info.getAttribute()) == null) {
                return;
            }
            if (info.getAttribute() == Attribute.ZOMBIE_SPAWN_REINFORCEMENTS && lmEntity.getEntityType() == EntityType.ZOMBIFIED_PIGLIN) {
                return;
            }
            boolean hasExistingDamage = false;
            float existingDamagePercent = 0.0f;
            if (info.getAttribute() == Attribute.GENERIC_MAX_HEALTH && (maxHealth = lmEntity.getLivingEntity().getAttribute(info.getAttribute())) != null && (existingDamage = maxHealth.getValue() - lmEntity.getLivingEntity().getHealth()) > 0.0) {
                existingDamagePercent = ((float)maxHealth.getValue() - (float)existingDamage) / (float)maxHealth.getValue();
                hasExistingDamage = true;
            }
            this.removeExistingMultipliers(lmEntity, attrib);
            attrib.addModifier(info.getAttributeModifier());
            DebugManager.Companion.log(DebugType.APPLY_MULTIPLIERS, lmEntity, () -> MobDataManager.setAttributeMods$lambda$2(lmEntity, info, attrib, additionValue));
            if (info.getAttribute() != Attribute.GENERIC_MAX_HEALTH) continue;
            float newHealth = hasExistingDamage ? (float)(attrib.getValue() * (double)existingDamagePercent) : (float)attrib.getValue();
            try {
                if (lmEntity.getLivingEntity().getHealth() <= 0.0) {
                    return;
                }
                lmEntity.getLivingEntity().setHealth(RangesKt.coerceAtLeast((double)newHealth, 1.0));
            }
            catch (IllegalArgumentException e) {
                DebugManager.Companion.log(DebugType.APPLY_MULTIPLIERS, lmEntity, () -> MobDataManager.setAttributeMods$lambda$3(newHealth, e));
            }
        }
    }

    private final void removeExistingMultipliers(LivingEntityWrapper lmEntity, AttributeInstance attrib) {
        CachedModalList<VanillaBonusEnum> allowedVanillaBonusEnums = LevelledMobs.Companion.getInstance().getRulesManager().getAllowedVanillaBonuses(lmEntity);
        Enumeration existingMods = Collections.enumeration(attrib.getModifiers());
        while (existingMods.hasMoreElements()) {
            AttributeModifier existingMod = (AttributeModifier)existingMods.nextElement();
            VanillaBonusEnum vanillaBonusEnum = this.vanillaMultiplierNames.get(existingMod.getName());
            if (vanillaBonusEnum != null && (allowedVanillaBonusEnums.isEmpty() || allowedVanillaBonusEnums.isIncludedInList(vanillaBonusEnum, lmEntity))) continue;
            String string = existingMod.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            if (!StringsKt.startsWith$default(string, "GENERIC_", false, 2, null)) {
                DebugManager.Companion.log(DebugType.REMOVED_MULTIPLIERS, lmEntity, () -> MobDataManager.removeExistingMultipliers$lambda$4(existingMod, lmEntity));
            }
            attrib.removeModifier(existingMod);
        }
    }

    public final void getAllAttributeValues(@NotNull LivingEntityWrapper lmEntity, @Nullable List<Attribute> whichOnes) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (!LevelledMobs.Companion.getInstance().getVer().isRunningFolia() && Bukkit.isPrimaryThread()) {
            Companion.populateAttributeCache(lmEntity, whichOnes);
            return;
        }
        CompletableFuture completableFuture = new CompletableFuture();
        SchedulerWrapper scheduler = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> MobDataManager.getAllAttributeValues$lambda$5(lmEntity, whichOnes, completableFuture));
        lmEntity.getInUseCount().getAndIncrement();
        scheduler.setEntity((Entity)lmEntity.getLivingEntity());
        scheduler.run();
        completableFuture.get(5000L, TimeUnit.MILLISECONDS);
    }

    public static /* synthetic */ void getAllAttributeValues$default(MobDataManager mobDataManager, LivingEntityWrapper livingEntityWrapper, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        mobDataManager.getAllAttributeValues(livingEntityWrapper, list);
    }

    @NotNull
    public final MultiplierResult getAdditionsForLevel(@NotNull LivingEntityWrapper lmEntity, @NotNull Addition addition, float defaultValue) {
        boolean isAddition;
        Ref.FloatRef multiplierValue;
        float attributeMax;
        Ref.ObjectRef multiplier;
        float maxLevel;
        block18: {
            block17: {
                Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
                Intrinsics.checkNotNullParameter((Object)addition, "addition");
                maxLevel = LevelledMobs.Companion.getInstance().getRulesManager().getRuleMobMaxLevel(lmEntity);
                FineTuningAttributes fineTuning = lmEntity.getFineTuningAttributes();
                multiplier = new Ref.ObjectRef();
                attributeMax = 0.0f;
                multiplierValue = new Ref.FloatRef();
                isAddition = true;
                if (fineTuning != null) {
                    multiplier.element = fineTuning.getItem(addition);
                    FineTuningAttributes.Multiplier multiplier2 = (FineTuningAttributes.Multiplier)multiplier.element;
                    boolean bl = multiplier2 != null ? multiplier2.hasFormula() : false;
                    if (bl) {
                        isAddition = ((FineTuningAttributes.Multiplier)multiplier.element).isAddition();
                        String string = ((FineTuningAttributes.Multiplier)multiplier.element).formula();
                        Intrinsics.checkNotNull(string);
                        StringReplacer formulaStr = new StringReplacer(string);
                        formulaStr.replaceIfExists("%level%", () -> MobDataManager.getAdditionsForLevel$lambda$6(lmEntity));
                        formulaStr.setText(LevelledMobs.Companion.getInstance().getLevelManager().replaceStringPlaceholdersForFormulas(formulaStr.getText(), lmEntity));
                        EvaluationResult evalResult = Companion.evaluateExpression(formulaStr.getText());
                        multiplierValue.element = (float)evalResult.getResult();
                        if (evalResult.getHadError()) {
                            Log.INSTANCE.war("Error evaluating formula for " + lmEntity.getNameIfBaby() + ": '" + formulaStr + "', " + evalResult.getError());
                        }
                        DebugManager.Companion.log(DebugType.APPLY_MULTIPLIERS, lmEntity, !evalResult.getHadError(), () -> MobDataManager.getAdditionsForLevel$lambda$7(lmEntity, multiplier, formulaStr, multiplierValue));
                    } else if (multiplier.element != null) {
                        multiplierValue.element = ((FineTuningAttributes.Multiplier)multiplier.element).value();
                    }
                    switch (WhenMappings.$EnumSwitchMapping$0[addition.ordinal()]) {
                        case 1: {
                            float f = 30.0f;
                            break;
                        }
                        case 2: {
                            float f = 50.0f;
                            break;
                        }
                        case 3: {
                            float f = 5.0f;
                            break;
                        }
                        case 4: 
                        case 5: {
                            float f = 1.0f;
                            break;
                        }
                        default: {
                            float f = attributeMax = 0.0f;
                        }
                    }
                }
                if (maxLevel == 0.0f || multiplierValue.element == 0.0f) {
                    DebugManager.Companion.log(DebugType.APPLY_MULTIPLIERS, lmEntity, () -> MobDataManager.getAdditionsForLevel$lambda$8(maxLevel, addition));
                    return new MultiplierResult(0.0f, isAddition);
                }
                FineTuningAttributes.Multiplier multiplier3 = (FineTuningAttributes.Multiplier)multiplier.element;
                boolean bl = multiplier3 != null ? multiplier3.hasFormula() : false;
                if (bl) {
                    return new MultiplierResult(multiplierValue.element, isAddition);
                }
                if ((addition == Addition.CUSTOM_ITEM_DROP || addition == Addition.CUSTOM_XP_DROP) && multiplierValue.element == -1.0f) {
                    return new MultiplierResult(Float.MIN_VALUE, isAddition);
                }
                FineTuningAttributes fineTuningAttributes = fineTuning;
                Intrinsics.checkNotNull(fineTuningAttributes);
                if (fineTuningAttributes.getUseStacked()) break block17;
                Object t = multiplier.element;
                Intrinsics.checkNotNull(t);
                if (!((FineTuningAttributes.Multiplier)t).useStacked()) break block18;
            }
            DebugManager.Companion.log(DebugType.APPLY_MULTIPLIERS, lmEntity, () -> MobDataManager.getAdditionsForLevel$lambda$9(lmEntity, addition, multiplier));
            return new MultiplierResult((float)lmEntity.getGetMobLevel() * multiplierValue.element, isAddition);
        }
        DebugManager.Companion.log(DebugType.APPLY_MULTIPLIERS, lmEntity, () -> MobDataManager.getAdditionsForLevel$lambda$10(lmEntity, addition, multiplier));
        multiplierValue.element = (double)attributeMax > 0.0 ? (float)lmEntity.getGetMobLevel() / maxLevel * (attributeMax * multiplierValue.element) : defaultValue * multiplierValue.element * ((float)lmEntity.getGetMobLevel() / maxLevel);
        return new MultiplierResult(multiplierValue.element, isAddition);
    }

    private static final double _init_$lambda$0(double[] d) {
        Intrinsics.checkNotNullParameter(d, "d");
        return d[0] >= d[1] && d[0] <= d[2] ? 1.0 : 0.0;
    }

    private static final double _init_$lambda$1(double[] d) {
        Intrinsics.checkNotNullParameter(d, "d");
        return Math.min(d[2], Math.max(d[0], d[1]));
    }

    private static final String setAttributeMods$lambda$2(LivingEntityWrapper $lmEntity, AttributePreMod $info, AttributeInstance $attrib, float $additionValue) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($info, "$info");
        Intrinsics.checkNotNullParameter($attrib, "$attrib");
        String string = "lvl: %s, attrib: %s, base: %s, addtion: %s";
        Object[] objectArray = new Object[]{$lmEntity.getGetMobLevel(), $info.getAttribute().name(), Utils.INSTANCE.round($attrib.getBaseValue(), 3), Utils.INSTANCE.round($additionValue, 3)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private static final String setAttributeMods$lambda$3(float $newHealth, IllegalArgumentException $e) {
        Intrinsics.checkNotNullParameter($e, "$e");
        return "Error setting maxhealth = " + $newHealth + ", " + $e.getMessage();
    }

    private static final String removeExistingMultipliers$lambda$4(AttributeModifier $existingMod, LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        String string = "Removing %s from (lvl %s) at %s,%s,%s";
        Object[] objectArray = new Object[]{$existingMod.getName(), $lmEntity.getGetMobLevel(), $lmEntity.getLocation().getBlockX(), $lmEntity.getLocation().getBlockY(), $lmEntity.getLocation().getBlockZ()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private static final void getAllAttributeValues$lambda$5(LivingEntityWrapper $lmEntity, List $whichOnes, CompletableFuture $completableFuture) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($completableFuture, "$completableFuture");
        Companion.populateAttributeCache($lmEntity, $whichOnes);
        $completableFuture.complete(true);
        $lmEntity.free();
    }

    private static final String getAdditionsForLevel$lambda$6(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return String.valueOf($lmEntity.getGetMobLevel());
    }

    private static final String getAdditionsForLevel$lambda$7(LivingEntityWrapper $lmEntity, Ref.ObjectRef $multiplier, StringReplacer $formulaStr, Ref.FloatRef $multiplierValue) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($multiplier, "$multiplier");
        Intrinsics.checkNotNullParameter($formulaStr, "$formulaStr");
        Intrinsics.checkNotNullParameter($multiplierValue, "$multiplierValue");
        return "lvl: " + $lmEntity.getGetMobLevel() + ", " + ((FineTuningAttributes.Multiplier)$multiplier.element).addition().name() + ", formulaPre: '" + ((FineTuningAttributes.Multiplier)$multiplier.element).formula() + "'\nformula: '" + $formulaStr + "', result: '" + $multiplierValue.element + "'";
    }

    private static final String getAdditionsForLevel$lambda$8(float $maxLevel, Addition $addition) {
        Intrinsics.checkNotNullParameter((Object)$addition, "$addition");
        String msg = $maxLevel == 0.0f ? "maxLevel was 0" : "multiplier was 0";
        return msg + "; returning 0 for " + $addition;
    }

    private static final String getAdditionsForLevel$lambda$9(LivingEntityWrapper $lmEntity, Addition $addition, Ref.ObjectRef $multiplier) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter((Object)$addition, "$addition");
        Intrinsics.checkNotNullParameter($multiplier, "$multiplier");
        int n = $lmEntity.getGetMobLevel();
        String string = $addition.name();
        Object t = $multiplier.element;
        Intrinsics.checkNotNull(t);
        return "lvl: " + n + ", attrib: " + string + ", stkd formula, " + ((FineTuningAttributes.Multiplier)t).value();
    }

    private static final String getAdditionsForLevel$lambda$10(LivingEntityWrapper $lmEntity, Addition $addition, Ref.ObjectRef $multiplier) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter((Object)$addition, "$addition");
        Intrinsics.checkNotNullParameter($multiplier, "$multiplier");
        return "lvl: " + $lmEntity.getGetMobLevel() + ", attrib: " + $addition.name() + ", std formula, " + ((FineTuningAttributes.Multiplier)$multiplier.element).value();
    }

    static {
        crunchEvalEnv = new EvaluationEnvironment();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/MobDataManager$Companion;", "", "<init>", "()V", "value", "Lio/github/arcaneplugins/levelledmobs/managers/MobDataManager;", "instance", "getInstance", "()Lio/github/arcaneplugins/levelledmobs/managers/MobDataManager;", "crunchEvalEnv", "Lio/github/arcaneplugins/levelledmobs/libs/crunch/functional/EvaluationEnvironment;", "evaluateExpression", "Lio/github/arcaneplugins/levelledmobs/result/EvaluationResult;", "expression", "", "populateAttributeCache", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "whichOnes", "", "Lorg/bukkit/attribute/Attribute;", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MobDataManager getInstance() {
            MobDataManager mobDataManager = instance;
            if (mobDataManager != null) {
                return mobDataManager;
            }
            Intrinsics.throwUninitializedPropertyAccessException("instance");
            return null;
        }

        @NotNull
        public final EvaluationResult evaluateExpression(@NotNull String expression) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            double numberResult = 0.0;
            String error = null;
            try {
                numberResult = Crunch.compileExpression(expression, crunchEvalEnv).evaluate();
            }
            catch (Exception e) {
                error = e.getMessage();
            }
            if (Double.isInfinite(numberResult)) {
                error = "Result was infinite";
                numberResult = 0.0;
            } else if (Double.isNaN(numberResult)) {
                error = "Result was NaN (not a number)";
                numberResult = 0.0;
            }
            return new EvaluationResult(numberResult, error);
        }

        public final void populateAttributeCache(@NotNull LivingEntityWrapper lmEntity, @Nullable List<Attribute> whichOnes) {
            Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
            Map result = new LinkedHashMap();
            List list = whichOnes;
            if (list == null) {
                list = EntriesMappings.entries$0;
            }
            List useList = list;
            for (Attribute attribute : useList) {
                AttributeInstance attribInstance = lmEntity.getLivingEntity().getAttribute(attribute);
                if (attribInstance == null) continue;
                result.put(attribute, attribInstance);
            }
            lmEntity.setAttributeValuesCache(result);
        }

        public static /* synthetic */ void populateAttributeCache$default(Companion companion, LivingEntityWrapper livingEntityWrapper, List list, int n, Object object) {
            if ((n & 2) != 0) {
                list = null;
            }
            companion.populateAttributeCache(livingEntityWrapper, list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<Attribute> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Attribute.values()));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Addition.values().length];
            try {
                nArray[Addition.ATTRIBUTE_ARMOR_BONUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_ARMOR_TOUGHNESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_ATTACK_KNOCKBACK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_KNOCKBACK_RESISTANCE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_ZOMBIE_SPAWN_REINFORCEMENTS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

