/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.managers;

import io.github.arcaneplugins.levelledmobs.LevelInterface2;
import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.LivingEntityInterface;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropItem;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropResult;
import io.github.arcaneplugins.levelledmobs.customdrops.EquippedItemsInfo;
import io.github.arcaneplugins.levelledmobs.customdrops.GroupLimits;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.Addition;
import io.github.arcaneplugins.levelledmobs.enums.LevellableState;
import io.github.arcaneplugins.levelledmobs.enums.LevelledMobSpawnReason;
import io.github.arcaneplugins.levelledmobs.enums.MobCustomNameStatus;
import io.github.arcaneplugins.levelledmobs.enums.MobTamedStatus;
import io.github.arcaneplugins.levelledmobs.enums.NametagVisibilityEnum;
import io.github.arcaneplugins.levelledmobs.events.MobPostLevelEvent;
import io.github.arcaneplugins.levelledmobs.events.MobPreLevelEvent;
import io.github.arcaneplugins.levelledmobs.events.SummonedMobPreLevelEvent;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.listeners.EntitySpawnListener;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.managers.NBTManager;
import io.github.arcaneplugins.levelledmobs.managers.NotifyManager;
import io.github.arcaneplugins.levelledmobs.misc.EvaluationException;
import io.github.arcaneplugins.levelledmobs.misc.ExternalPluginDetection;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.PickedUpEquipment;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.misc.StringReplacer;
import io.github.arcaneplugins.levelledmobs.result.AdditionalLevelInformation;
import io.github.arcaneplugins.levelledmobs.result.AttributePreMod;
import io.github.arcaneplugins.levelledmobs.result.EvaluationResult;
import io.github.arcaneplugins.levelledmobs.result.MinAndMaxHolder;
import io.github.arcaneplugins.levelledmobs.result.MythicMobsMobInfo;
import io.github.arcaneplugins.levelledmobs.result.NBTApplyResult;
import io.github.arcaneplugins.levelledmobs.result.NametagResult;
import io.github.arcaneplugins.levelledmobs.result.PlayerHomeCheckResult;
import io.github.arcaneplugins.levelledmobs.result.PlayerLevelSourceResult;
import io.github.arcaneplugins.levelledmobs.result.PlayerNetherOrWorldSpawnResult;
import io.github.arcaneplugins.levelledmobs.rules.ChunkKillOptions;
import io.github.arcaneplugins.levelledmobs.rules.CustomDropsRuleSet;
import io.github.arcaneplugins.levelledmobs.rules.FineTuningAttributes;
import io.github.arcaneplugins.levelledmobs.rules.HealthIndicator;
import io.github.arcaneplugins.levelledmobs.rules.RulesManager;
import io.github.arcaneplugins.levelledmobs.rules.strategies.CustomStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.LevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.PlayerLevellingStrategy;
import io.github.arcaneplugins.levelledmobs.rules.strategies.RandomVarianceGenerator;
import io.github.arcaneplugins.levelledmobs.rules.strategies.StrategyType;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MythicMobUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerResult;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.inventory.AbstractHorseInventory;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00f4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u008e\u00012\u00020\u0001:\u0002\u008e\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J \u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002032\u0006\u00107\u001a\u000203H\u0016J\u0018\u00108\u001a\u0002032\u0006\u00109\u001a\u00020:2\u0006\u00104\u001a\u000205H\u0002J \u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010!2\u0006\u00104\u001a\u0002052\u0006\u0010>\u001a\u00020%J\u000e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BJ$\u0010C\u001a\u0002012\u0006\u00104\u001a\u0002052\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u00052\u0006\u0010F\u001a\u00020\u000eJ\u001e\u0010G\u001a\u0002012\u0006\u00104\u001a\u0002052\u0006\u0010H\u001a\u00020E2\u0006\u0010I\u001a\u00020:J$\u0010J\u001a\b\u0012\u0004\u0012\u00020E0\u00052\u0006\u00104\u001a\u0002052\f\u0010K\u001a\b\u0012\u0004\u0012\u00020E0\u0005H\u0002J\u001c\u0010L\u001a\u0002012\u0006\u00104\u001a\u0002052\f\u0010K\u001a\b\u0012\u0004\u0012\u00020E0\u0005J\u0016\u0010M\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010N\u001a\u00020OJ\u0016\u0010P\u001a\u00020Q2\u0006\u00104\u001a\u0002052\u0006\u0010R\u001a\u00020\u000eJ\u001e\u0010P\u001a\u00020Q2\u0006\u00104\u001a\u0002052\u0006\u0010R\u001a\u00020\u000e2\u0006\u0010S\u001a\u00020\u000eJ(\u0010T\u001a\u00020Q2\u0006\u00104\u001a\u0002052\u0006\u0010U\u001a\u00020V2\u0006\u0010S\u001a\u00020\u000e2\b\u0010W\u001a\u0004\u0018\u00010%J\u0010\u0010X\u001a\u0002012\u0006\u00104\u001a\u000205H\u0002J\u0018\u0010Y\u001a\u0002012\u0006\u00104\u001a\u0002052\u0006\u0010Z\u001a\u00020VH\u0002J\u0016\u0010[\u001a\u00020%2\u0006\u0010\\\u001a\u00020%2\u0006\u00104\u001a\u000205J0\u0010]\u001a\u00020%2\u0006\u0010\\\u001a\u00020%2\u0006\u00104\u001a\u0002052\u0006\u0010^\u001a\u00020\u000e2\b\u0010=\u001a\u0004\u0018\u00010!2\u0006\u0010S\u001a\u00020\u000eJ2\u0010]\u001a\u00020%2\u0006\u0010\\\u001a\u00020V2\u0006\u00104\u001a\u0002052\u0006\u0010^\u001a\u00020\u000e2\b\u0010=\u001a\u0004\u0018\u00010!2\u0006\u0010S\u001a\u00020\u000eH\u0002J\u000e\u0010_\u001a\u0002012\u0006\u00104\u001a\u000205J\u000e\u0010T\u001a\u0002012\u0006\u00104\u001a\u000205J$\u0010T\u001a\u0002012\u0006\u00104\u001a\u0002052\u0006\u0010U\u001a\u00020Q2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020!0\u0005J\u0006\u0010a\u001a\u000201J\b\u0010b\u001a\u000201H\u0002J\b\u0010c\u001a\u000201H\u0002J\u0006\u0010d\u001a\u000201J\b\u0010e\u001a\u000201H\u0002J2\u0010f\u001a\u0002012\u0006\u0010g\u001a\u00020\"2\u0006\u0010=\u001a\u00020!2\u0018\u0010h\u001a\u0014\u0012\u0004\u0012\u000205\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u00050 H\u0002J\u0010\u0010i\u001a\u00020\u000e2\u0006\u00104\u001a\u000205H\u0002J\u001e\u0010j\u001a\u0002012\u0006\u00104\u001a\u0002052\f\u0010`\u001a\b\u0012\u0004\u0012\u00020!0kH\u0002J\u0018\u0010l\u001a\u0002012\u0006\u00104\u001a\u0002052\u0006\u0010=\u001a\u00020!H\u0002J\u0018\u0010m\u001a\u00020\u000e2\u0006\u00104\u001a\u0002052\u0006\u0010=\u001a\u00020!H\u0002J\u0006\u0010n\u001a\u000201J\u001e\u0010o\u001a\u0002012\u0006\u00104\u001a\u0002052\f\u0010p\u001a\b\u0012\u0004\u0012\u00020q0\u0005H\u0002J\u0010\u0010r\u001a\u0002012\u0006\u00104\u001a\u000205H\u0002J\u0018\u0010s\u001a\u0002012\u0006\u00104\u001a\u0002052\u0006\u0010t\u001a\u000203H\u0002J\u0018\u0010u\u001a\u0002012\u0006\u00104\u001a\u0002052\u0006\u0010v\u001a\u00020wH\u0002J\u0010\u0010x\u001a\u00020O2\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010y\u001a\u00020O2\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010z\u001a\u00020{2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020\tH\u0016J:\u0010}\u001a\u0002012\u0006\u00104\u001a\u0002052\u0006\u0010t\u001a\u0002032\u0006\u0010~\u001a\u00020\u000e2\u0006\u0010\u007f\u001a\u00020\u000e2\u0010\u0010\u0080\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u0081\u0001\u0018\u00010*H\u0016J)\u0010\u0082\u0001\u001a\u0002012\u0006\u00104\u001a\u0002052\r\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020%0\u00052\u0007\u0010\u0084\u0001\u001a\u00020\u000eH\u0002J \u0010\u0085\u0001\u001a\u0002012\u0006\u00104\u001a\u0002052\r\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020%0\u0005H\u0002J \u0010\u0086\u0001\u001a\u0002012\u0006\u00104\u001a\u0002052\r\u0010\u0083\u0001\u001a\b\u0012\u0004\u0012\u00020%0\u0005H\u0002J\u0019\u0010\u0087\u0001\u001a\u00020%2\u000e\u0010\u0088\u0001\u001a\t\u0012\u0005\u0012\u00030\u0089\u00010\u0005H\u0002J\u0011\u0010\u008a\u0001\u001a\u00020\u000e2\u0006\u0010|\u001a\u00020\tH\u0016J\u0011\u0010\u008b\u0001\u001a\u0002032\u0006\u0010|\u001a\u00020\tH\u0016J\u0011\u0010\u008c\u0001\u001a\u0002012\u0006\u00104\u001a\u000205H\u0016J\u0011\u0010\u008c\u0001\u001a\u0002012\u0006\u0010|\u001a\u00020\tH\u0016J\u0013\u0010\u008d\u0001\u001a\u0004\u0018\u00010%2\u0006\u0010|\u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00050 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006\u008f\u0001"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/LevelManager;", "Lio/github/arcaneplugins/levelledmobs/LevelInterface2;", "<init>", "()V", "vehicleNoMultiplierItems", "", "Lorg/bukkit/Material;", "summonedOrSpawnEggs", "Ljava/util/WeakHashMap;", "Lorg/bukkit/entity/LivingEntity;", "", "getSummonedOrSpawnEggs", "()Ljava/util/WeakHashMap;", "hasMentionedNBTAPIMissing", "", "doCheckMobHash", "getDoCheckMobHash", "()Z", "setDoCheckMobHash", "(Z)V", "lastLEWCacheClearing", "Ljava/time/Instant;", "entitySpawnListener", "Lio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener;", "getEntitySpawnListener", "()Lio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener;", "nametagAutoUpdateTask", "Lio/github/arcaneplugins/levelledmobs/wrappers/SchedulerResult;", "nametagTimerTask", "asyncRunningCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "entitiesPerPlayer", "", "Lorg/bukkit/entity/Player;", "Lorg/bukkit/entity/Entity;", "entitiesPerPlayerLock", "attributeStringList", "", "Lorg/bukkit/attribute/Attribute;", "strategyPlaceholders", "Lio/github/arcaneplugins/levelledmobs/rules/strategies/StrategyType;", "forcedBlockedEntityTypes", "", "Lorg/bukkit/entity/EntityType;", "getForcedBlockedEntityTypes", "()Ljava/util/Set;", "setForcedBlockedEntityTypes", "(Ljava/util/Set;)V", "load", "", "generateLevel", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "minLevel", "maxLevel", "constructLevel", "input", "", "getPlayerLevelSourceNumber", "Lio/github/arcaneplugins/levelledmobs/result/PlayerLevelSourceResult;", "player", "variableToUse", "getMinAndMaxLevels", "Lio/github/arcaneplugins/levelledmobs/result/MinAndMaxHolder;", "lmInterface", "Lio/github/arcaneplugins/levelledmobs/LivingEntityInterface;", "setLevelledItemDrops", "currentDrops", "Lorg/bukkit/inventory/ItemStack;", "disableItemBoost", "multiplyDrop", "currentDrop", "addition", "getDropsToMultiply", "drops", "removeVanillaDrops", "getLevelledExpDrops", "xp", "", "getNametag", "Lio/github/arcaneplugins/levelledmobs/result/NametagResult;", "isDeathNametag", "preserveMobName", "updateNametag", "nametag", "Lio/github/arcaneplugins/levelledmobs/misc/StringReplacer;", "customDeathMessage", "checkLockedNametag", "getAttributesCache", "str", "replaceStringPlaceholdersForFormulas", "text", "replaceStringPlaceholders", "usePAPI", "updateNametagWithDelay", "players", "startNametagAutoUpdateTask", "checkLEWCache", "enumerateNearbyEntities", "startNametagTimer", "runNametagCheckASync", "checkEntity", "entity", "entityToPlayer", "checkIfReadyForRelevelling", "checkEntityForPlayerLevelling", "", "checkLevelledEntity", "doesMobNeedRelevelling", "stopNametagAutoUpdateTask", "applyLevelledAttributes", "additions", "Lio/github/arcaneplugins/levelledmobs/enums/Addition;", "applyCreeperBlastRadius", "applyLevelledEquipment", "level", "applyLevelledEquipmentNonAsync", "customDropsRuleSet", "Lio/github/arcaneplugins/levelledmobs/rules/CustomDropsRuleSet;", "getMobAttributeValue", "getMobHealth", "getLevellableState", "Lio/github/arcaneplugins/levelledmobs/enums/LevellableState;", "livingEntity", "applyLevelToMob", "isSummoned", "bypassLimits", "additionalLevelInformation", "Lio/github/arcaneplugins/levelledmobs/result/AdditionalLevelInformation;", "applyLevelToMob2", "nbtDatas", "doSkipLMNametag", "applyAttribs", "applyNbtData", "getNBTDebugMessage", "results", "Lio/github/arcaneplugins/levelledmobs/result/NBTApplyResult;", "isLevelled", "getLevelOfMob", "removeLevel", "getMobNametag", "Companion", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nLevelManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LevelManager.kt\nio/github/arcaneplugins/levelledmobs/managers/LevelManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,2251:1\n607#2:2252\n*S KotlinDebug\n*F\n+ 1 LevelManager.kt\nio/github/arcaneplugins/levelledmobs/managers/LevelManager\n*L\n1286#1:2252\n*E\n"})
public final class LevelManager
implements LevelInterface2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<Material> vehicleNoMultiplierItems = new ArrayList();
    @NotNull
    private final WeakHashMap<LivingEntity, Object> summonedOrSpawnEggs = new WeakHashMap();
    private boolean hasMentionedNBTAPIMissing;
    private boolean doCheckMobHash;
    @Nullable
    private Instant lastLEWCacheClearing;
    @NotNull
    private final EntitySpawnListener entitySpawnListener = new EntitySpawnListener();
    @Nullable
    private SchedulerResult nametagAutoUpdateTask;
    @Nullable
    private SchedulerResult nametagTimerTask;
    @NotNull
    private final AtomicInteger asyncRunningCount = new AtomicInteger();
    @NotNull
    private final Map<Player, List<Entity>> entitiesPerPlayer = new LinkedHashMap();
    @NotNull
    private final Object entitiesPerPlayerLock = new Object();
    @NotNull
    private final Map<String, Attribute> attributeStringList = new LinkedHashMap();
    @NotNull
    private final Map<String, StrategyType> strategyPlaceholders = new LinkedHashMap();
    @NotNull
    private Set<EntityType> forcedBlockedEntityTypes = new LinkedHashSet();
    @NotNull
    private static final Object summonedOrSpawnEggs_Lock = new Object();

    @NotNull
    public final WeakHashMap<LivingEntity, Object> getSummonedOrSpawnEggs() {
        return this.summonedOrSpawnEggs;
    }

    public final boolean getDoCheckMobHash() {
        return this.doCheckMobHash;
    }

    public final void setDoCheckMobHash(boolean bl) {
        this.doCheckMobHash = bl;
    }

    @NotNull
    public final EntitySpawnListener getEntitySpawnListener() {
        return this.entitySpawnListener;
    }

    @NotNull
    public final Set<EntityType> getForcedBlockedEntityTypes() {
        return this.forcedBlockedEntityTypes;
    }

    public final void setForcedBlockedEntityTypes(@NotNull Set<EntityType> set) {
        Intrinsics.checkNotNullParameter(set, "<set-?>");
        this.forcedBlockedEntityTypes = set;
    }

    public final void load() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("%max-health%", Attribute.GENERIC_MAX_HEALTH), TuplesKt.to("%movement-speed%", Attribute.GENERIC_MOVEMENT_SPEED), TuplesKt.to("%attack-damage%", Attribute.GENERIC_ATTACK_DAMAGE), TuplesKt.to("%follow-range%", Attribute.GENERIC_FOLLOW_RANGE), TuplesKt.to("%armor-bonus%", Attribute.GENERIC_ARMOR), TuplesKt.to("%armor-toughness%", Attribute.GENERIC_ARMOR_TOUGHNESS), TuplesKt.to("%attack-knockback%", Attribute.GENERIC_ATTACK_KNOCKBACK), TuplesKt.to("%knockback-resistance%", Attribute.GENERIC_KNOCKBACK_RESISTANCE), TuplesKt.to("%zombie-spawn-reinforcements%", Attribute.ZOMBIE_SPAWN_REINFORCEMENTS)};
        this.attributeStringList.putAll(MapsKt.mutableMapOf(pairArray));
        pairArray = new Pair[]{TuplesKt.to("%random%", StrategyType.RANDOM), TuplesKt.to("%weighted-random%", StrategyType.WEIGHTED_RANDOM), TuplesKt.to("%random-variance-mod%", StrategyType.RANDOM_VARIANCE), TuplesKt.to("%custom-strategy%", StrategyType.CUSTOM), TuplesKt.to("%distance-from-origin%", StrategyType.SPAWN_DISTANCE), TuplesKt.to("%y-coordinate%", StrategyType.Y_COORDINATE), TuplesKt.to("%player-variable-mod%", StrategyType.PLAYER_VARIABLE)};
        this.strategyPlaceholders.putAll(MapsKt.mutableMapOf(pairArray));
        pairArray = new Material[]{Material.SADDLE, Material.LEATHER_HORSE_ARMOR, Material.IRON_HORSE_ARMOR, Material.GOLDEN_HORSE_ARMOR, Material.DIAMOND_HORSE_ARMOR};
        this.vehicleNoMultiplierItems.addAll((Collection<Material>)CollectionsKt.mutableListOf(pairArray));
        pairArray = new EntityType[]{EntityType.AREA_EFFECT_CLOUD, EntityType.ARMOR_STAND, EntityType.ARROW, EntityType.BOAT, EntityType.DRAGON_FIREBALL, EntityType.DROPPED_ITEM, EntityType.EGG, EntityType.ENDER_CRYSTAL, EntityType.ENDER_PEARL, EntityType.ENDER_SIGNAL, EntityType.EXPERIENCE_ORB, EntityType.FALLING_BLOCK, EntityType.FIREBALL, EntityType.FIREWORK, EntityType.FISHING_HOOK, EntityType.ITEM_FRAME, EntityType.LEASH_HITCH, EntityType.LIGHTNING, EntityType.LLAMA_SPIT, EntityType.MINECART, EntityType.MINECART_CHEST, EntityType.MINECART_COMMAND, EntityType.MINECART_FURNACE, EntityType.MINECART_HOPPER, EntityType.MINECART_MOB_SPAWNER, EntityType.MINECART_TNT, EntityType.PAINTING, EntityType.PRIMED_TNT, EntityType.SMALL_FIREBALL, EntityType.SNOWBALL, EntityType.SPECTRAL_ARROW, EntityType.SPLASH_POTION, EntityType.THROWN_EXP_BOTTLE, EntityType.TRIDENT, EntityType.UNKNOWN, EntityType.WITHER_SKULL, EntityType.SHULKER_BULLET, EntityType.PLAYER};
        this.forcedBlockedEntityTypes.addAll((Collection<EntityType>)CollectionsKt.mutableListOf(pairArray));
    }

    @Override
    public int generateLevel(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        return this.generateLevel(lmEntity, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generateLevel(@NotNull LivingEntityWrapper lmEntity, int minLevel, int maxLevel) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        int useMinLevel = minLevel;
        int useMaxLevel = maxLevel;
        if (useMinLevel == -1 || useMaxLevel == -1) {
            MinAndMaxHolder levels = this.getMinAndMaxLevels(lmEntity);
            if (useMinLevel == -1) {
                useMinLevel = levels.getMinAsInt();
            }
            if (useMaxLevel == -1) {
                useMaxLevel = levels.getMaxAsInt();
            }
        }
        List<LevellingStrategy> levellingStrategies = LevelledMobs.Companion.getInstance().getRulesManager().getRuleLevellingStrategies(lmEntity);
        List<CustomStrategy> customStrategies = LevelledMobs.Companion.getInstance().getRulesManager().getRuleCustomStrategies(lmEntity);
        float numberResult = 0.0f;
        UUID debugId = DebugManager.Companion.startLongDebugMessage();
        try {
            Float f;
            float result;
            LevellingStrategy strategy;
            int count;
            Iterator iterator2 = ((Iterable)levellingStrategies).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                count = n++;
                strategy = (LevellingStrategy)iterator2.next();
                result = strategy.generateNumber(lmEntity, useMinLevel, useMaxLevel);
                f = Float.valueOf(result);
                lmEntity.getStrategyResults().put(strategy.getStrategyType(), f);
                DebugManager.Companion.logLongMessage(debugId, () -> LevelManager.generateLevel$lambda$0(count, strategy, result));
                numberResult += result;
            }
            iterator2 = ((Iterable)customStrategies).iterator();
            n = 0;
            while (iterator2.hasNext()) {
                count = n++;
                strategy = (CustomStrategy)iterator2.next();
                result = ((CustomStrategy)strategy).generateNumber(lmEntity, useMinLevel, useMaxLevel);
                f = Float.valueOf(result);
                lmEntity.getCustomStrategyResults().put(((CustomStrategy)strategy).getPlaceholderName(), f);
                DebugManager.Companion.logLongMessage(debugId, () -> LevelManager.generateLevel$lambda$1(count, (CustomStrategy)strategy, result));
                numberResult += result;
            }
        }
        finally {
            DebugManager.Companion.endLongMessage(debugId, DebugType.STRATEGY_RESULT, lmEntity);
        }
        if (useMinLevel == useMaxLevel) {
            return useMinLevel;
        }
        int generatedLevel = RangesKt.coerceAtLeast(RangesKt.coerceAtMost(this.constructLevel(numberResult, lmEntity), useMaxLevel), useMinLevel);
        return generatedLevel;
    }

    private final int constructLevel(float input, LivingEntityWrapper lmEntity) {
        String string = LevelledMobs.Companion.getInstance().getRulesManager().getRuleConstructLevel(lmEntity);
        if (string == null) {
            return (int)input;
        }
        String formulaPre = string;
        String formula = this.replaceStringPlaceholdersForFormulas(formulaPre, lmEntity);
        EvaluationResult evalResult = MobDataManager.Companion.evaluateExpression(formula);
        if (evalResult.getHadError()) {
            NotifyManager.INSTANCE.notifyOfError("Error evaluating formula for construct-level on mob: " + lmEntity.getNameIfBaby() + ", " + evalResult.getError());
            throw new EvaluationException();
        }
        int result = (int)evalResult.getResult();
        DebugManager.Companion.log(DebugType.CONSTRUCT_LEVEL, lmEntity, () -> LevelManager.constructLevel$lambda$2(result, formulaPre, formula));
        return result;
    }

    @NotNull
    public final PlayerLevelSourceResult getPlayerLevelSourceNumber(@Nullable Player player, @NotNull LivingEntityWrapper lmEntity, @NotNull String variableToUse) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(variableToUse, "variableToUse");
        if (player == null) {
            return new PlayerLevelSourceResult(1.0f);
        }
        float origLevelSource = 0.0f;
        String homeNameUsed = "spawn";
        if (StringsKt.equals("%level%", variableToUse, true)) {
            origLevelSource = player.getLevel();
        } else if (StringsKt.equals("%exp%", variableToUse, true)) {
            origLevelSource = player.getExp();
        } else if (StringsKt.equals("%exp-to-level%", variableToUse, true)) {
            origLevelSource = player.getExpToLevel();
        } else if (StringsKt.equals("%total-exp%", variableToUse, true)) {
            origLevelSource = player.getTotalExperience();
        } else if (StringsKt.equals("%world-time-ticks%", variableToUse, true)) {
            origLevelSource = player.getWorld().getTime();
        } else if (StringsKt.equals("%home-distance%", variableToUse, true) || StringsKt.equals("%home-distance-with-bed%", variableToUse, true)) {
            Location useLocation2;
            boolean allowBed = StringsKt.equals("%home-distance-with-bed%", variableToUse, true);
            PlayerNetherOrWorldSpawnResult netherOrWorldSpawnResult = null;
            PlayerHomeCheckResult result = ExternalCompatibilityManager.Companion.getPlayerHomeLocation(player, allowBed);
            if (result.getHomeNameUsed() != null) {
                String string = result.getHomeNameUsed();
                Intrinsics.checkNotNull(string);
                homeNameUsed = string;
            }
            if ((useLocation2 = result.getLocation()) == null || !Intrinsics.areEqual(useLocation2.getWorld(), player.getWorld())) {
                netherOrWorldSpawnResult = Utils.INSTANCE.getPortalOrWorldSpawn(player);
                useLocation2 = netherOrWorldSpawnResult.getLocation();
                String string = netherOrWorldSpawnResult.isWorldPortalLocation() ? "world-portal" : (homeNameUsed = netherOrWorldSpawnResult.isNetherPortalLocation() ? "nether-portal" : "spawn");
            }
            if (result.getResultMessage() != null) {
                DebugManager.Companion.log(DebugType.PLAYER_LEVELLING, lmEntity, () -> LevelManager.getPlayerLevelSourceNumber$lambda$3(result));
            }
            Location location = useLocation2;
            Intrinsics.checkNotNull(location);
            origLevelSource = (float)location.distance(player.getLocation());
        } else if (StringsKt.equals("%bed-distance%", variableToUse, true)) {
            Location useLocation = player.getRespawnLocation();
            homeNameUsed = "bed";
            if (useLocation == null || useLocation.getWorld() != player.getWorld()) {
                PlayerNetherOrWorldSpawnResult result = Utils.INSTANCE.getPortalOrWorldSpawn(player);
                useLocation = result.getLocation();
                homeNameUsed = result.isWorldPortalLocation() ? "world-portal" : (result.isNetherPortalLocation() ? "nether-portal" : "spawn");
            }
            Location location = useLocation;
            Intrinsics.checkNotNull(location);
            origLevelSource = (float)location.distance(player.getLocation());
        } else {
            Location l;
            boolean usePlayerLevel = false;
            String papiResult = null;
            if (ExternalCompatibilityManager.Companion.getHasPapiInstalled()) {
                papiResult = ExternalCompatibilityManager.Companion.getPapiPlaceholder(player, variableToUse);
                if (((CharSequence)papiResult).length() == 0) {
                    Location location = player.getLocation();
                    Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                    l = location;
                    DebugManager.Companion.log(DebugType.PLAYER_LEVELLING, lmEntity, () -> LevelManager.getPlayerLevelSourceNumber$lambda$4(variableToUse, player, l));
                    usePlayerLevel = true;
                }
            } else {
                Log.INSTANCE.war("PlaceHolderAPI is not installed, unable to get variable " + variableToUse);
                usePlayerLevel = true;
            }
            if (usePlayerLevel) {
                origLevelSource = player.getLevel();
            } else {
                Location location = player.getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                l = location;
                CharSequence useLocation2 = papiResult;
                if (useLocation2 == null || useLocation2.length() == 0) {
                    origLevelSource = player.getLevel();
                    DebugManager.Companion.log(DebugType.PLAYER_LEVELLING, lmEntity, () -> LevelManager.getPlayerLevelSourceNumber$lambda$5(variableToUse, player, l));
                } else if (Utils.INSTANCE.isDouble(papiResult)) {
                    float useLocation2;
                    try {
                        useLocation2 = Float.parseFloat(papiResult);
                    }
                    catch (Exception ignored) {
                        useLocation2 = player.getLevel();
                    }
                    origLevelSource = useLocation2;
                } else {
                    PlayerLevelSourceResult result = new PlayerLevelSourceResult(papiResult);
                    result.setHomeNameUsed(homeNameUsed);
                    return result;
                }
            }
        }
        PlayerLevelSourceResult sourceResult = new PlayerLevelSourceResult(origLevelSource);
        Integer maxRandomVariance = LevelledMobs.Companion.getInstance().getRulesManager().getRuleMaxRandomVariance(lmEntity);
        if (maxRandomVariance != null) {
            sourceResult.setRandomVarianceResult(Float.valueOf(ThreadLocalRandom.current().nextInt(0, maxRandomVariance + 1)));
            if (ThreadLocalRandom.current().nextBoolean()) {
                Float f = sourceResult.getRandomVarianceResult();
                Intrinsics.checkNotNull(f);
                sourceResult.setRandomVarianceResult(Float.valueOf(f.floatValue() * (float)-1));
            }
        }
        sourceResult.setHomeNameUsed(homeNameUsed);
        return sourceResult;
    }

    @NotNull
    public final MinAndMaxHolder getMinAndMaxLevels(@NotNull LivingEntityInterface lmInterface) {
        Intrinsics.checkNotNullParameter(lmInterface, "lmInterface");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        int minLevel = main.getRulesManager().getRuleMobMinLevel(lmInterface);
        int maxLevel = main.getRulesManager().getRuleMobMaxLevel(lmInterface);
        minLevel = (int)Math.max((double)minLevel, 1.0);
        maxLevel = (int)Math.max((double)maxLevel, 1.0);
        minLevel = (int)Math.min((double)minLevel, (double)maxLevel);
        return new MinAndMaxHolder(minLevel, maxLevel);
    }

    public final void setLevelledItemDrops(@NotNull LivingEntityWrapper lmEntity, @NotNull List<ItemStack> currentDrops, boolean disableItemBoost) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(currentDrops, "currentDrops");
        int vanillaDrops = currentDrops.size();
        List<ItemStack> dropsToMultiply = this.getDropsToMultiply(lmEntity, currentDrops);
        List customDrops = new ArrayList();
        currentDrops.clear();
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        boolean doNotMultiplyDrops = disableItemBoost || main.getRulesManager().getRuleCheckIfNoDropMultiplierEntitiy(lmEntity);
        boolean hasOverride = false;
        if (lmEntity.getLockedCustomDrops() != null || main.getRulesManager().getRuleUseCustomDropsForMob(lmEntity).getUseDrops()) {
            CustomDropResult dropResult = main.getCustomDropsHandler().getCustomItemDrops(lmEntity, customDrops, false);
            MythicMobsMobInfo mmInfo = MythicMobUtils.INSTANCE.getMythicMobInfo(lmEntity);
            if (mmInfo != null && mmInfo.getPreventOtherDrops()) {
                hasOverride = true;
            }
            if (dropResult.getHasOverride()) {
                hasOverride = true;
            }
            if (hasOverride) {
                this.removeVanillaDrops(lmEntity, dropsToMultiply);
            }
        }
        int additionUsed = 0;
        if (!doNotMultiplyDrops && !((Collection)dropsToMultiply).isEmpty()) {
            float additionValue = main.getMobDataManager().getAdditionsForLevel(lmEntity, Addition.CUSTOM_ITEM_DROP, 2.0f).getAmount();
            if (additionValue == Float.MIN_VALUE) {
                DebugManager.Companion.log(DebugType.SET_LEVELLED_ITEM_DROPS, lmEntity, () -> LevelManager.setLevelledItemDrops$lambda$6(lmEntity));
                currentDrops.clear();
                return;
            }
            additionUsed = MathKt.roundToInt(additionValue);
            for (ItemStack currentDrop : dropsToMultiply) {
                this.multiplyDrop(lmEntity, currentDrop, additionValue);
            }
        }
        if (!((Collection)customDrops).isEmpty()) {
            currentDrops.addAll(customDrops);
        }
        if (!((Collection)dropsToMultiply).isEmpty()) {
            currentDrops.addAll((Collection<ItemStack>)dropsToMultiply);
        }
        String nameWithOverride = hasOverride ? " (override), " : "";
        int additionUsedFinal = additionUsed;
        DebugManager.Companion.log(DebugType.SET_LEVELLED_ITEM_DROPS, lmEntity, () -> LevelManager.setLevelledItemDrops$lambda$7(nameWithOverride, lmEntity, vanillaDrops, currentDrops, additionUsedFinal));
    }

    public final void multiplyDrop(@NotNull LivingEntityWrapper lmEntity, @NotNull ItemStack currentDrop, float addition) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(currentDrop, "currentDrop");
        MobDataManager mobDataManager = LevelledMobs.Companion.getInstance().getMobDataManager();
        Material material = currentDrop.getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        if (mobDataManager.isLevelledDropManaged(material)) {
            DebugManager.Companion.log(DebugType.SET_LEVELLED_ITEM_DROPS, lmEntity, LevelManager::multiplyDrop$lambda$8);
            return;
        }
        int oldAmount = currentDrop.getAmount();
        int useAmount = MathKt.roundToInt((float)currentDrop.getAmount() + (float)currentDrop.getAmount() * addition);
        if (useAmount > currentDrop.getMaxStackSize()) {
            useAmount = currentDrop.getMaxStackSize();
        }
        currentDrop.setAmount(useAmount);
        DebugManager.Companion.log(DebugType.SET_LEVELLED_ITEM_DROPS, lmEntity, () -> LevelManager.multiplyDrop$lambda$9(currentDrop, oldAmount, addition));
    }

    private final List<ItemStack> getDropsToMultiply(LivingEntityWrapper lmEntity, List<ItemStack> drops) {
        List results = new ArrayList();
        results.addAll((Collection)drops);
        if (lmEntity.getLivingEntity() instanceof ChestedHorse) {
            LivingEntity livingEntity = lmEntity.getLivingEntity();
            Intrinsics.checkNotNull(livingEntity, "null cannot be cast to non-null type org.bukkit.entity.ChestedHorse");
            if (((ChestedHorse)livingEntity).isCarryingChest()) {
                LivingEntity livingEntity2 = lmEntity.getLivingEntity();
                Intrinsics.checkNotNull(livingEntity2, "null cannot be cast to non-null type org.bukkit.entity.ChestedHorse");
                AbstractHorseInventory abstractHorseInventory = ((ChestedHorse)livingEntity2).getInventory();
                Intrinsics.checkNotNullExpressionValue(abstractHorseInventory, "getInventory(...)");
                AbstractHorseInventory inv = abstractHorseInventory;
                ItemStack[] itemStackArray = inv.getContents();
                Intrinsics.checkNotNullExpressionValue(itemStackArray, "getContents(...)");
                for (ItemStack item : itemStackArray) {
                    if (item == null || item.getType() != Material.LEATHER) continue;
                    ItemStack[] itemStackArray2 = new ItemStack[]{item};
                    return CollectionsKt.mutableListOf(itemStackArray2);
                }
                results.clear();
                return results;
            }
        }
        if (!(lmEntity.getLivingEntity() instanceof Vehicle)) {
            return results;
        }
        int n = ((Collection)results).size() + -1;
        if (0 <= n) {
            do {
                int i;
                ItemStack item;
                if (!this.vehicleNoMultiplierItems.contains((item = (ItemStack)results.get(i = n--)).getType())) continue;
                results.remove(i);
            } while (0 <= n);
        }
        return results;
    }

    /*
     * Unable to fully structure code
     */
    public final void removeVanillaDrops(@NotNull LivingEntityWrapper lmEntity, @NotNull List<ItemStack> drops) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(drops, "drops");
        hadSaddle = false;
        itemsToKeep = new ArrayList<E>();
        if (!(lmEntity.getLivingEntity() instanceof ChestedHorse)) ** GOTO lbl-1000
        v0 = lmEntity.getLivingEntity();
        Intrinsics.checkNotNull(v0, "null cannot be cast to non-null type org.bukkit.entity.ChestedHorse");
        if (((ChestedHorse)v0).isCarryingChest()) {
            v1 = lmEntity.getLivingEntity();
            Intrinsics.checkNotNull(v1, "null cannot be cast to non-null type org.bukkit.entity.ChestedHorse");
            v2 = ((ChestedHorse)v1).getInventory();
            Intrinsics.checkNotNullExpressionValue(v2, "getInventory(...)");
            inv = v2;
            v3 = inv.getContents();
            Intrinsics.checkNotNullExpressionValue(v3, "getContents(...)");
            ArraysKt.plus((Object[])v3, itemsToKeep);
            itemsToKeep.add(new ItemStack(Material.CHEST));
        } else if (lmEntity.getLivingEntity() instanceof Vehicle) {
            for (ItemStack itemStack : drops) {
                if (itemStack.getType() != Material.SADDLE) continue;
                hadSaddle = true;
                break;
            }
        }
        if (LevelledMobs.Companion.getInstance().getVer().isRunningPaper()) {
            pickedUpItems = new PickedUpEquipment(lmEntity).getMobPickedUpItems();
            block1: for (ItemStack mobItem : drops) {
                for (ItemStack foundItem : pickedUpItems) {
                    if (!mobItem.isSimilar(foundItem)) continue;
                    itemsToKeep.add(mobItem);
                    continue block1;
                }
            }
        }
        drops.clear();
        drops.addAll(itemsToKeep);
        if (hadSaddle) {
            drops.add(new ItemStack(Material.SADDLE));
        }
    }

    public final int getLevelledExpDrops(@NotNull LivingEntityWrapper lmEntity, double xp) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (lmEntity.isLevelled()) {
            float dropAddition = LevelledMobs.Companion.getInstance().getMobDataManager().getAdditionsForLevel(lmEntity, Addition.CUSTOM_XP_DROP, 3.0f).getAmount();
            double newXp = 0.0;
            if (dropAddition == Float.MIN_VALUE) {
                DebugManager.Companion.log(DebugType.SET_LEVELLED_XP_DROPS, lmEntity, () -> LevelManager.getLevelledExpDrops$lambda$10(lmEntity, xp));
                return 0;
            }
            if (dropAddition > -1.0f) {
                newXp = Math.round(xp + xp * (double)dropAddition);
            }
            int newXpFinal = (int)newXp;
            DebugManager.Companion.log(DebugType.SET_LEVELLED_XP_DROPS, lmEntity, () -> LevelManager.getLevelledExpDrops$lambda$11(lmEntity, xp, newXpFinal));
            return (int)newXp;
        }
        return (int)xp;
    }

    @NotNull
    public final NametagResult getNametag(@NotNull LivingEntityWrapper lmEntity, boolean isDeathNametag) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        return this.getNametag(lmEntity, isDeathNametag, false);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final NametagResult getNametag(@NotNull LivingEntityWrapper lmEntity, boolean isDeathNametag, boolean preserveMobName) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
                usePreserveMobName = preserveMobName;
                nametag = null;
                customDeathMessage = null;
                main = LevelledMobs.Companion.getInstance();
                if (!isDeathNametag) break block6;
                nametag = new StringReplacer(main.getRulesManager().getRuleNametagCreatureDeath(lmEntity));
                break block7;
            }
            this.checkLockedNametag(lmEntity);
            if (lmEntity.getLockedNametag() == null) ** GOTO lbl-1000
            v0 = lmEntity.getLockedNametag();
            Intrinsics.checkNotNull(v0);
            if (((CharSequence)v0).length() == 0) lbl-1000:
            // 2 sources

            {
                v1 = main.getRulesManager().getRuleNametag(lmEntity);
            } else {
                v2 = lmEntity.getLockedNametag();
                v1 = v2;
                Intrinsics.checkNotNull(v2);
            }
            nametagText = v1;
            nametag = new StringReplacer(nametagText);
        }
        if (StringsKt.equals("disabled", nametag.getText(), true) || StringsKt.equals("none", nametag.getText(), true)) {
            return new NametagResult(null);
        }
        if (isDeathNametag && !((var9_10 = (CharSequence)(deathMessage = main.getRulesManager().getDeathMessage(lmEntity))) == null || var9_10.length() == 0)) {
            nametag = new StringReplacer(StringsKt.replace$default(deathMessage, "%death_nametag%", nametag.getText(), false, 4, null));
            v3 = player = lmEntity.getAssociatedPlayer();
            nametag.replace("%player%", (String)(v3 != null ? v3.getName() + "&r" : ""));
            nametag.setText(this.replaceStringPlaceholders(nametag.getText(), lmEntity, true, player, false));
            usePreserveMobName = true;
            v4 = customDeathMessage = nametag.contains("{DisplayName}") != false ? main.getRulesManager().getRuleNametagCreatureDeath(lmEntity) : nametag.getText();
        }
        if (nametag.isEmpty()) {
            useCustomNameForNametags = main.getHelperSettings().getBoolean("use-customname-for-mob-nametags");
            return useCustomNameForNametags != false ? new NametagResult(lmEntity.getTypeName()) : new NametagResult(lmEntity.getLivingEntity().getCustomName());
        }
        if (!lmEntity.isLevelled()) {
            nametag.setText("");
        }
        return this.updateNametag(lmEntity, nametag, usePreserveMobName, customDeathMessage);
    }

    @NotNull
    public final NametagResult updateNametag(@NotNull LivingEntityWrapper lmEntity, @NotNull StringReplacer nametag, boolean preserveMobName, @Nullable String customDeathMessage) {
        HealthIndicator indicator;
        String string;
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(nametag, "nametag");
        if (nametag.isEmpty()) {
            NametagResult result = new NametagResult(nametag.getText());
            result.setCustomDeathMessage(customDeathMessage);
            return result;
        }
        this.checkLockedNametag(lmEntity);
        if (lmEntity.getLockedOverrideName() == null) {
            string = LevelledMobs.Companion.getInstance().getRulesManager().getRuleEntityOverriddenName(lmEntity, false);
        } else {
            String string2 = lmEntity.getLockedOverrideName();
            string = string2;
            Intrinsics.checkNotNull(string2);
        }
        String overridenName = string;
        this.replaceStringPlaceholders(nametag, lmEntity, false, null, preserveMobName);
        Object indicatorStr = "";
        String colorOnly = "";
        if ((StringsKt.contains$default((CharSequence)nametag.getText(), "%health-indicator%", false, 2, null) || StringsKt.contains$default((CharSequence)nametag.getText(), "%health-indicator-color%", false, 2, null)) && (indicator = LevelledMobs.Companion.getInstance().getRulesManager().getRuleNametagIndicator(lmEntity)) != null) {
            HealthIndicator.HealthIndicatorResult result = indicator.formatHealthIndicator(lmEntity);
            indicatorStr = result.getFormattedString() + "&r";
            colorOnly = result.getColorOnly();
        }
        nametag.replace("%health-indicator%", (String)indicatorStr);
        nametag.replace("%health-indicator-color%", colorOnly);
        if (StringsKt.contains$default((CharSequence)nametag.getText(), "%", false, 2, null) && ExternalCompatibilityManager.Companion.getHasPapiInstalled()) {
            nametag.setText(ExternalCompatibilityManager.Companion.getPapiPlaceholder(null, nametag.getText()));
        }
        NametagResult result = new NametagResult(nametag.getText());
        result.setOverriddenName(overridenName);
        result.setCustomDeathMessage(customDeathMessage);
        result.setKillerMob(lmEntity.getLivingEntity());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkLockedNametag(LivingEntityWrapper lmEntity) {
        PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        synchronized (persistentDataContainer2) {
            block9: {
                block7: {
                    block8: {
                        boolean bl = false;
                        Integer doLockSettings = null;
                        if (!lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLockSettings(), PersistentDataType.INTEGER)) break block7;
                        doLockSettings = (Integer)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getLockSettings(), PersistentDataType.INTEGER);
                        if (doLockSettings == null) break block8;
                        int n = 1;
                        if (doLockSettings == n) break block9;
                    }
                    return;
                }
                return;
            }
            if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLockedNametag(), PersistentDataType.STRING)) {
                lmEntity.setLockedNametag((String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getLockedNametag(), PersistentDataType.STRING));
            }
            if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLockedNameOverride(), PersistentDataType.STRING)) {
                lmEntity.setLockedOverrideName((String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getLockedNameOverride(), PersistentDataType.STRING));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void getAttributesCache(LivingEntityWrapper lmEntity, StringReplacer str) {
        if (lmEntity.getAttributeValuesCache() != null) {
            return;
        }
        List whichOnes = new ArrayList();
        for (Map.Entry<String, Attribute> placeholder : this.attributeStringList.entrySet()) {
            if (!StringsKt.contains$default((CharSequence)str.getText(), placeholder.getKey(), false, 2, null)) continue;
            whichOnes.add(placeholder.getValue());
        }
        MobDataManager.Companion.getInstance().getAllAttributeValues(lmEntity, whichOnes);
    }

    @NotNull
    public final String replaceStringPlaceholdersForFormulas(@NotNull String text, @NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        StringReplacer str = new StringReplacer(text);
        if (StringsKt.contains((CharSequence)str.getText(), "%level-ratio%", true)) {
            Integer n = lmEntity.getMobLevel();
            int mobLevel = n != null ? n.intValue() : lmEntity.getGetMobLevel();
            float f = RulesManager.Companion.getInstance().getRuleMobMaxLevel(lmEntity);
            float minLevel = RulesManager.Companion.getInstance().getRuleMobMinLevel(lmEntity);
            if (mobLevel == 0 || f == 0.0f) {
                str.replace("%level-ratio%", "0");
                DebugManager.Companion.log(DebugType.LEVEL_RATIO, lmEntity, LevelManager::replaceStringPlaceholdersForFormulas$lambda$13);
            } else {
                float newValue = 0.0f;
                float part1 = (float)mobLevel - minLevel;
                float part2 = f - minLevel;
                newValue = part2 == 0.0f ? 1.0f : (part1 == 0.0f ? 0.0f : RangesKt.coerceAtLeast(part1 / part2, 0.0f));
                str.replace("%level-ratio%", String.valueOf(newValue));
                DebugManager.Companion.log(DebugType.LEVEL_RATIO, lmEntity, () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$14(mobLevel, minLevel, f, newValue));
            }
        }
        str.replaceIfExists("%ranged-attack-damage%", () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$15(lmEntity));
        for (Map.Entry<String, StrategyType> entry : this.strategyPlaceholders.entrySet()) {
            str.replaceIfExists(entry.getKey(), () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$16(lmEntity, entry));
        }
        for (String string : RulesManager.Companion.getInstance().getAllCustomStrategyPlaceholders()) {
            str.replaceIfExists(string, () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$17(lmEntity, string));
        }
        this.getAttributesCache(lmEntity, str);
        str.replaceIfExists("%distance-from-spawn%", () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$18(lmEntity));
        str.replace("%hotspots-mod%", "0");
        str.replace("%barricades-mod%", "0");
        str.replaceIfExists("%creeper-blast-damage%", () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$19(lmEntity));
        for (Map.Entry entry : this.attributeStringList.entrySet()) {
            str.replaceIfExists((String)entry.getKey(), () -> LevelManager.replaceStringPlaceholdersForFormulas$lambda$20(lmEntity, entry));
        }
        str.replaceIfExists("%item-drop%", LevelManager::replaceStringPlaceholdersForFormulas$lambda$21);
        str.replaceIfExists("%xp-drop%", LevelManager::replaceStringPlaceholdersForFormulas$lambda$22);
        if (!StringsKt.contains$default((CharSequence)str.getText(), "%", false, 2, null)) {
            return str.getText();
        }
        return this.replaceStringPlaceholders(str, lmEntity, true, null, true);
    }

    @NotNull
    public final String replaceStringPlaceholders(@NotNull String text, @NotNull LivingEntityWrapper lmEntity, boolean usePAPI, @Nullable Player player, boolean preserveMobName) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        return this.replaceStringPlaceholders(new StringReplacer(text), lmEntity, usePAPI, player, preserveMobName);
    }

    private final String replaceStringPlaceholders(StringReplacer text, LivingEntityWrapper lmEntity, boolean usePAPI, Player player, boolean preserveMobName) {
        String tieredPlaceholder;
        Object playerName;
        Object object;
        Object playerId;
        double maxHealth = this.getMobAttributeValue(lmEntity);
        double entityHealth = this.getMobHealth(lmEntity);
        int entityHealthRounded = entityHealth < 1.0 && entityHealth > 0.0 ? 1 : (int)Utils.INSTANCE.round(entityHealth);
        String roundedMaxHealth = String.valueOf(Utils.INSTANCE.round(maxHealth));
        String roundedMaxHealthInt = String.valueOf((int)Utils.INSTANCE.round(maxHealth));
        double percentHealthTemp = Math.round(entityHealth / maxHealth * 100.0);
        int percentHealth = percentHealthTemp < 1.0 ? 1 : (int)percentHealthTemp;
        Object object2 = player;
        if (object2 == null || (object2 = object2.getUniqueId()) == null || (object2 = ((UUID)object2).toString()) == null) {
            object2 = playerId = "";
        }
        if ((object = player) == null || (object = object.getName()) == null) {
            object = playerName = "";
        }
        if ((tieredPlaceholder = LevelledMobs.Companion.getInstance().getRulesManager().getRuleTieredPlaceholder(lmEntity)) == null) {
            tieredPlaceholder = "";
        }
        text.replaceIfExists("%displayname%", () -> LevelManager.replaceStringPlaceholders$lambda$23(lmEntity, preserveMobName));
        text.replace("%mob-lvl%", lmEntity.getGetMobLevel());
        text.replace("%entity-name%", Utils.INSTANCE.capitalize(StringsKt.replace$default(lmEntity.getTypeName(), "_", " ", false, 4, null)));
        text.replace("%entity-name-raw%", lmEntity.getTypeName());
        text.replace("%entity-health%", Utils.INSTANCE.round(entityHealth));
        text.replace("%entity-health-rounded%", entityHealthRounded);
        text.replace("%entity-max-health%", roundedMaxHealth);
        text.replace("%entity-max-health-rounded%", roundedMaxHealthInt);
        text.replaceIfExists("%base-health%", () -> LevelManager.replaceStringPlaceholders$lambda$24(lmEntity));
        text.replace("%heart-symbol%", "\u2764");
        text.replace("%tiered%", tieredPlaceholder);
        text.replace("%wg-region%", lmEntity.getWgRegionName());
        text.replace("%world%", lmEntity.getWorldName());
        text.replaceIfExists("%location%", () -> LevelManager.replaceStringPlaceholders$lambda$25(lmEntity));
        text.replace("%health%-percent%", percentHealth);
        text.replace("%x%", lmEntity.getLivingEntity().getLocation().getBlockX());
        text.replace("%y%", lmEntity.getLivingEntity().getLocation().getBlockY());
        text.replace("%z%", lmEntity.getLivingEntity().getLocation().getBlockZ());
        text.replace("%player-uuid%", (String)playerId);
        text.replace("%player%", (String)playerName);
        if (text.contains("%rand_")) {
            RandomVarianceGenerator.INSTANCE.generateVariance(lmEntity, text);
        }
        for (Map.Entry<String, ExternalPluginDetection> placeholder : ExternalCompatibilityManager.Companion.getInstance().getExternalPluginPlaceholders().entrySet()) {
            text.replaceIfExists(placeholder.getKey(), () -> LevelManager.replaceStringPlaceholders$lambda$26(placeholder, lmEntity));
        }
        if (usePAPI && text.contains("%") && ExternalCompatibilityManager.Companion.getHasPapiInstalled()) {
            text.setText(ExternalCompatibilityManager.Companion.getPapiPlaceholder(player, text.getText()));
        }
        return text.getText();
    }

    public final void updateNametagWithDelay(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        SchedulerWrapper scheduler = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> LevelManager.updateNametagWithDelay$lambda$27(this, lmEntity));
        lmEntity.getInUseCount().getAndIncrement();
        scheduler.runDelayed(1L);
    }

    public final void updateNametag(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        NametagResult nametag = this.getNametag(lmEntity, false, true);
        List list = lmEntity.getLivingEntity().getWorld().getPlayers();
        Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
        QueueItem queueItem = new QueueItem(lmEntity, nametag, list);
        LevelledMobs.Companion.getInstance().getNametagQueueManager().addToQueue(queueItem);
    }

    public final void updateNametag(@NotNull LivingEntityWrapper lmEntity, @NotNull NametagResult nametag, @NotNull List<Player> players) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(nametag, "nametag");
        Intrinsics.checkNotNullParameter(players, "players");
        LevelledMobs.Companion.getInstance().getNametagQueueManager().addToQueue(new QueueItem(lmEntity, nametag, players));
    }

    public final void startNametagAutoUpdateTask() {
        Log.INSTANCE.inf("&fTasks: &7Starting async nametag auto update task...");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        long period = main.getHelperSettings().getInt("async-task-update-period", 6);
        this.doCheckMobHash = main.getHelperSettings().getBoolean("check-mob-hash", true);
        Runnable runnable2 = () -> LevelManager.startNametagAutoUpdateTask$lambda$28(this);
        if (main.getVer().isRunningFolia()) {
            Consumer<ScheduledTask> task = arg_0 -> LevelManager.startNametagAutoUpdateTask$lambda$29(runnable2, arg_0);
            this.nametagTimerTask = new SchedulerResult(Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)main, task, 0L, period, TimeUnit.SECONDS));
        } else {
            this.nametagTimerTask = new SchedulerResult(Bukkit.getScheduler().runTaskTimer((Plugin)main, runnable2, 0L, (long)20 * period));
        }
    }

    private final void checkLEWCache() {
        if (this.lastLEWCacheClearing == null) {
            this.lastLEWCacheClearing = Instant.now();
            return;
        }
        Instant instant = this.lastLEWCacheClearing;
        Intrinsics.checkNotNull(instant);
        long duration = instant.until(Instant.now(), ChronoUnit.MILLIS);
        Long l = LevelledMobs.Companion.getInstance().getHelperSettings().getIntTimeUnitMS("lew-cache-clear-period", 180000L);
        Intrinsics.checkNotNull(l);
        long configDuration = l;
        if (duration >= configDuration) {
            DebugManager.Companion.log(DebugType.DEVELOPER_LEW_CACHE, () -> LevelManager.checkLEWCache$lambda$30(configDuration));
            this.lastLEWCacheClearing = Instant.now();
            LivingEntityWrapper.Companion.clearCache();
        }
    }

    private final void enumerateNearbyEntities() {
        this.entitiesPerPlayer.clear();
        this.asyncRunningCount.set(0);
        int checkDistance = LevelledMobs.Companion.getInstance().getHelperSettings().getInt("async-task-max-blocks-from-player", 100);
        for (Player player : Bukkit.getOnlinePlayers()) {
            List entities;
            if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
                Runnable test = () -> LevelManager.enumerateNearbyEntities$lambda$31(this);
                this.asyncRunningCount.getAndIncrement();
                Consumer<ScheduledTask> task = arg_0 -> LevelManager.enumerateNearbyEntities$lambda$33(player, checkDistance, this, arg_0);
                player.getScheduler().run((Plugin)LevelledMobs.Companion.getInstance(), task, test);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(player.getNearbyEntities((double)checkDistance, (double)checkDistance, (double)checkDistance), "getNearbyEntities(...)");
            this.entitiesPerPlayer.put(player, entities);
            this.runNametagCheckASync();
        }
    }

    public final void startNametagTimer() {
        SchedulerWrapper scheduler = new SchedulerWrapper(LevelManager::startNametagTimer$lambda$34);
        scheduler.runTaskTimerAsynchronously(0L, 1000L);
    }

    private final void runNametagCheckASync() {
        Map entityToPlayer = new LinkedHashMap();
        if (LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            for (Player entry : this.entitiesPerPlayer.keySet()) {
                List<Entity> list = this.entitiesPerPlayer.get(entry);
                Intrinsics.checkNotNull(list);
                for (Entity entity : list) {
                    Consumer<ScheduledTask> task = arg_0 -> LevelManager.runNametagCheckASync$lambda$35(this, entity, entry, entityToPlayer, arg_0);
                    entity.getScheduler().run((Plugin)LevelledMobs.Companion.getInstance(), task, null);
                }
            }
        } else {
            for (Player player : this.entitiesPerPlayer.keySet()) {
                List<Entity> list = this.entitiesPerPlayer.get(player);
                Intrinsics.checkNotNull(list);
                for (Entity entity : list) {
                    this.checkEntity(entity, player, entityToPlayer);
                }
            }
        }
        for (Map.Entry entry : entityToPlayer.entrySet()) {
            LivingEntityWrapper lmEntity = (LivingEntityWrapper)entry.getKey();
            List value = (List)entry.getValue();
            if (entityToPlayer.containsKey(lmEntity)) {
                this.checkEntityForPlayerLevelling(lmEntity, value);
            }
            lmEntity.free();
        }
        this.entitiesPerPlayer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkEntity(Entity entity, Player player, Map<LivingEntityWrapper, List<Player>> entityToPlayer) {
        if (!entity.isValid()) {
            return;
        }
        if (!(entity instanceof LivingEntity) || entity instanceof Player || !entity.isValid()) {
            return;
        }
        if (entity.getTicksLived() < 30) {
            return;
        }
        boolean wrapperHasReference = false;
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
        lmEntity.setAssociatedPlayer(player);
        if (this.doCheckMobHash && Utils.INSTANCE.checkIfMobHashChanged(lmEntity)) {
            lmEntity.setReEvaluateLevel(true);
            lmEntity.setRulesForceAll(true);
            lmEntity.setWasPreviouslyLevelled(lmEntity.isLevelled());
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (lmEntity.isLevelled()) {
            boolean skipLevelling;
            boolean bl = skipLevelling = lmEntity.getSpawnReason() == LevelledMobSpawnReason.LM_SPAWNER || lmEntity.getSpawnReason() == LevelledMobSpawnReason.LM_SUMMON;
            if (main.getRulesManager().isPlayerLevellingEnabled() && !lmEntity.isRulesForceAll() && !this.checkIfReadyForRelevelling(lmEntity)) {
                skipLevelling = true;
            }
            if (main.getRulesManager().isPlayerLevellingEnabled() && !skipLevelling) {
                List<Player> list;
                boolean hasKey = entityToPlayer.containsKey(lmEntity);
                if (hasKey) {
                    List<Player> list2 = entityToPlayer.get(lmEntity);
                    Intrinsics.checkNotNull(list2);
                    list = list2;
                } else {
                    list = new ArrayList();
                }
                List<Player> players = list;
                players.add(player);
                if (!hasKey) {
                    entityToPlayer.put(lmEntity, players);
                }
                wrapperHasReference = true;
            }
            if (!lmEntity.isPopulated()) {
                return;
            }
            List<NametagVisibilityEnum> nametagVisibilityEnums = main.getRulesManager().getRuleCreatureNametagVisbility(lmEntity);
            long nametagVisibleTime = lmEntity.getNametagCooldownTime();
            if (nametagVisibleTime > 0L && nametagVisibilityEnums.contains((Object)NametagVisibilityEnum.TARGETED) && lmEntity.getLivingEntity().hasLineOfSight((Entity)player)) {
                if (lmEntity.getPlayersNeedingNametagCooldownUpdate() == null) {
                    lmEntity.setPlayersNeedingNametagCooldownUpdate(new HashSet());
                }
                Set<Player> set = lmEntity.getPlayersNeedingNametagCooldownUpdate();
                Intrinsics.checkNotNull(set);
                set.add(player);
            }
            this.checkLevelledEntity(lmEntity, player);
        } else {
            boolean wasBabyMob = false;
            PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
            PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
            synchronized (persistentDataContainer2) {
                boolean bl = false;
                wasBabyMob = lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getWasBabyMobKey(), PersistentDataType.INTEGER);
                Unit unit = Unit.INSTANCE;
            }
            if (lmEntity.isPopulated()) {
                LevellableState levellableState = main.getLevelInterface().getLevellableState(lmEntity);
                if (!lmEntity.isBabyMob() && wasBabyMob && levellableState == LevellableState.ALLOWED) {
                    DebugManager.Companion.log(DebugType.ENTITY_MISC, lmEntity, () -> LevelManager.checkEntity$lambda$37(lmEntity));
                    main.getMobsQueueManager().addToQueue(new QueueItem(lmEntity, null));
                } else if (levellableState == LevellableState.ALLOWED) {
                    main.getMobsQueueManager().addToQueue(new QueueItem(lmEntity, null));
                }
            }
        }
        if (!wrapperHasReference) {
            lmEntity.free();
        }
    }

    private final boolean checkIfReadyForRelevelling(LivingEntityWrapper lmEntity) {
        PlayerLevellingStrategy opts;
        PlayerLevellingStrategy playerLevellingStrategy = opts = LevelledMobs.Companion.getInstance().getRulesManager().getRulePlayerLevellingOptions(lmEntity);
        if ((playerLevellingStrategy != null ? playerLevellingStrategy.getPreserveEntityTime() : null) == null) {
            return true;
        }
        if (!lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLastDamageTime(), PersistentDataType.LONG)) {
            return true;
        }
        Long l = (Long)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getLastDamageTime(), PersistentDataType.LONG);
        if (l == null) {
            return true;
        }
        long lastLevelledTime = l;
        Instant levelledTime = Instant.ofEpochMilli(lastLevelledTime);
        Intrinsics.checkNotNull(levelledTime);
        long l2 = Utils.INSTANCE.getMillisecondsFromInstant(levelledTime);
        Long l3 = opts.getPreserveEntityTime();
        Intrinsics.checkNotNull(l3);
        return l2 > l3;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEntityForPlayerLevelling(LivingEntityWrapper lmEntity, List<? extends Player> players) {
        void $this$sortedBy$iv;
        LivingEntity mob = lmEntity.getLivingEntity();
        Sequence<Pair> sequence = SequencesKt.map(SequencesKt.filter(SequencesKt.filter(CollectionsKt.asSequence((Iterable)players), arg_0 -> LevelManager.checkEntityForPlayerLevelling$lambda$38(mob, arg_0)), LevelManager::checkEntityForPlayerLevelling$lambda$39), arg_0 -> LevelManager.checkEntityForPlayerLevelling$lambda$40(mob, arg_0));
        boolean $i$f$sortedBy = false;
        Sequence<Player> sortedPlayersSequence = SequencesKt.map(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Double)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Double)it.getFirst()));
            }
        }), LevelManager::checkEntityForPlayerLevelling$lambda$42);
        if (MainCompanion.Companion.getInstance().getExcludePlayersInCreative()) {
            sortedPlayersSequence = SequencesKt.filter(sortedPlayersSequence, LevelManager::checkEntityForPlayerLevelling$lambda$43);
        }
        List<Player> sortedPlayers = SequencesKt.toMutableList(sortedPlayersSequence);
        Player closestPlayer = null;
        for (Player player : sortedPlayers) {
            if (ExternalCompatibilityManager.Companion.isMobOfCitizens((LivingEntity)player)) continue;
            closestPlayer = player;
            break;
        }
        if (closestPlayer == null) {
            return;
        }
        Instant logonTime = MainCompanion.Companion.getInstance().getRecentlyJoinedPlayerLogonTime(closestPlayer);
        if (logonTime != null) {
            if (Utils.INSTANCE.getMillisecondsFromInstant(logonTime) < 5000L) {
                return;
            }
            MainCompanion.Companion.getInstance().removeRecentlyJoinedPlayer(closestPlayer);
        }
        if (this.doesMobNeedRelevelling(lmEntity, closestPlayer)) {
            lmEntity.setPendingPlayerIdToSet(closestPlayer.getUniqueId().toString());
            lmEntity.setPlayerForLevelling(closestPlayer);
            lmEntity.setReEvaluateLevel(true);
            LevelledMobs.Companion.getInstance().getMobsQueueManager().addToQueue(new QueueItem(lmEntity, null));
        }
    }

    private final void checkLevelledEntity(LivingEntityWrapper lmEntity, Player player) {
        if (!lmEntity.getLivingEntity().isValid()) {
            return;
        }
        double maxDistance = Math.pow(128.0, 2.0);
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (lmEntity.isRulesForceAll()) {
            main.getMobsQueueManager().addToQueue(new QueueItem(lmEntity, null));
        } else if (lmEntity.getLivingEntity().getCustomName() != null && main.getRulesManager().getRuleMobCustomNameStatus(lmEntity) == MobCustomNameStatus.NOT_NAMETAGGED) {
            main.getLevelInterface().removeLevel(lmEntity);
        } else if (lmEntity.isMobTamed() && main.getRulesManager().getRuleMobTamedStatus(lmEntity) == MobTamedStatus.NOT_TAMED) {
            main.getLevelInterface().removeLevel(lmEntity);
        } else if (lmEntity.getLivingEntity().isValid() && !main.getHelperSettings().getBoolean("use-customname-for-mob-nametags", false) && location2.getWorld() != null && Intrinsics.areEqual(location2.getWorld(), lmEntity.getWorld()) && lmEntity.getLocation().distanceSquared(location2) <= maxDistance) {
            NametagResult nametag = main.getLevelManager().getNametag(lmEntity, false, true);
            Player[] playerArray = new Player[]{player};
            main.getNametagQueueManager().addToQueue(new QueueItem(lmEntity, nametag, CollectionsKt.mutableListOf(playerArray)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doesMobNeedRelevelling(LivingEntityWrapper lmEntity, Player player) {
        Instant lastCheck;
        Duration duration;
        LivingEntity mob = lmEntity.getLivingEntity();
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (main.getPlayerLevellingMinRelevelTime() > 0L && main.getPlayerLevellingEntities().containsKey(mob) && (duration = Duration.between(lastCheck = main.getPlayerLevellingEntities().get(mob), Instant.now())).toMillis() < main.getPlayerLevellingMinRelevelTime()) {
            return false;
        }
        Object playerId = null;
        if (main.getPlayerLevellingMinRelevelTime() > 0L) {
            ((Map)main.getPlayerLevellingEntities()).put(mob, Instant.now());
        }
        PersistentDataContainer persistentDataContainer = mob.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        synchronized (persistentDataContainer2) {
            block12: {
                boolean bl = false;
                if (mob.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getPlayerLevellingId(), PersistentDataType.STRING)) break block12;
                boolean bl2 = true;
                return bl2;
            }
            playerId = mob.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getPlayerLevellingId(), PersistentDataType.STRING);
            Unit unit = Unit.INSTANCE;
        }
        if (playerId == null && main.getPlayerLevellingMinRelevelTime() <= 0L) {
            return true;
        }
        if (playerId == null || !Intrinsics.areEqual(player.getUniqueId().toString(), playerId)) {
            return true;
        }
        PlayerLevellingStrategy opts = main.getRulesManager().getRulePlayerLevellingOptions(lmEntity);
        if (Intrinsics.areEqual(player.getUniqueId().toString(), playerId) && opts != null && opts.getGetRecheckPlayers()) {
            String string;
            String string2 = (String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getPlayerLevellingSourceNumber(), PersistentDataType.STRING);
            if (string2 == null) {
                return true;
            }
            String previousResult = string2;
            CharSequence charSequence = opts.getVariable();
            if (charSequence == null || charSequence.length() == 0) {
                string = "%level%";
            } else {
                String string3 = opts.getVariable();
                string = string3;
                Intrinsics.checkNotNull(string3);
            }
            String variableToUse = string;
            PlayerLevelSourceResult result = this.getPlayerLevelSourceNumber(player, lmEntity, variableToUse);
            String sourceNumberStr = result.isNumericResult() ? String.valueOf(result.getNumericResult()) : result.getStringResult();
            return !Intrinsics.areEqual(previousResult, sourceNumberStr);
        }
        return !Intrinsics.areEqual(player.getUniqueId().toString(), playerId);
    }

    public final void stopNametagAutoUpdateTask() {
        if (!LevelledMobs.Companion.getInstance().getNametagQueueManager().getHasNametagSupport()) {
            return;
        }
        if (this.nametagAutoUpdateTask != null) {
            SchedulerResult schedulerResult = this.nametagAutoUpdateTask;
            Intrinsics.checkNotNull(schedulerResult);
            if (!schedulerResult.isCancelled()) {
                Log.INSTANCE.inf("&fTasks: &7Stopping async nametag auto update task...");
                SchedulerResult schedulerResult2 = this.nametagAutoUpdateTask;
                Intrinsics.checkNotNull(schedulerResult2);
                schedulerResult2.cancelTask();
            }
        }
        if (this.nametagTimerTask != null) {
            SchedulerResult schedulerResult = this.nametagTimerTask;
            Intrinsics.checkNotNull(schedulerResult);
            if (!schedulerResult.isCancelled()) {
                SchedulerResult schedulerResult3 = this.nametagTimerTask;
                Intrinsics.checkNotNull(schedulerResult3);
                schedulerResult3.cancelTask();
            }
        }
    }

    private final void applyLevelledAttributes(LivingEntityWrapper lmEntity, List<Addition> additions) {
        if (!lmEntity.isLevelled()) {
            return;
        }
        List modInfo = new ArrayList();
        Map<Attribute, AttributeInstance> map = lmEntity.getAttributeValuesCache();
        if (map == null || map.isEmpty()) {
            MobDataManager.getAllAttributeValues$default(MobDataManager.Companion.getInstance(), lmEntity, null, 2, null);
        }
        block13: for (Addition addition : additions) {
            AttributePreMod result;
            Attribute attribute = null;
            switch (WhenMappings.$EnumSwitchMapping$0[addition.ordinal()]) {
                case 1: {
                    attribute = Attribute.GENERIC_MAX_HEALTH;
                    break;
                }
                case 2: {
                    attribute = Attribute.GENERIC_ATTACK_DAMAGE;
                    break;
                }
                case 3: {
                    attribute = Attribute.GENERIC_MOVEMENT_SPEED;
                    break;
                }
                case 4: {
                    attribute = Attribute.HORSE_JUMP_STRENGTH;
                    break;
                }
                case 5: {
                    attribute = Attribute.GENERIC_ARMOR;
                    break;
                }
                case 6: {
                    attribute = Attribute.GENERIC_ARMOR_TOUGHNESS;
                    break;
                }
                case 7: {
                    attribute = Attribute.GENERIC_KNOCKBACK_RESISTANCE;
                    break;
                }
                case 8: {
                    attribute = Attribute.GENERIC_FLYING_SPEED;
                    break;
                }
                case 9: {
                    attribute = Attribute.GENERIC_ATTACK_KNOCKBACK;
                    break;
                }
                case 10: {
                    attribute = Attribute.GENERIC_FOLLOW_RANGE;
                    break;
                }
                case 11: {
                    if (lmEntity.getSpawnReason() == LevelledMobSpawnReason.REINFORCEMENTS) continue block13;
                    attribute = Attribute.ZOMBIE_SPAWN_REINFORCEMENTS;
                    break;
                }
                default: {
                    throw new IllegalStateException("Addition must be an Attribute, if so, it has not been considered in this method");
                }
            }
            if ((result = MobDataManager.Companion.getInstance().prepareSetAttributes(lmEntity, attribute, addition)) == null) continue;
            modInfo.add(result);
        }
        SchedulerWrapper scheduler = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> LevelManager.applyLevelledAttributes$lambda$45(lmEntity, modInfo));
        lmEntity.getInUseCount().getAndIncrement();
        scheduler.run();
    }

    private final void applyCreeperBlastRadius(LivingEntityWrapper lmEntity) {
        LivingEntity livingEntity = lmEntity.getLivingEntity();
        Intrinsics.checkNotNull(livingEntity, "null cannot be cast to non-null type org.bukkit.entity.Creeper");
        Creeper creeper = (Creeper)livingEntity;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        FineTuningAttributes tuning = main.getRulesManager().getFineTuningAttributes(lmEntity);
        if (tuning == null) {
            if (creeper.getExplosionRadius() != 3) {
                creeper.setExplosionRadius(3);
            }
            DebugManager.Companion.log(DebugType.CREEPER_BLAST_RADIUS, lmEntity, () -> LevelManager.applyCreeperBlastRadius$lambda$46(lmEntity));
            return;
        }
        int maxRadius = main.getRulesManager().getRuleCreeperMaxBlastRadius(lmEntity);
        float damage = main.getMobDataManager().getAdditionsForLevel(lmEntity, Addition.CREEPER_BLAST_DAMAGE, 3.0f).getAmount();
        if (damage == 0.0f) {
            return;
        }
        int blastRadius = 3 + (int)Math.floor(damage);
        if (blastRadius > maxRadius) {
            blastRadius = maxRadius;
        } else if (blastRadius < 0) {
            blastRadius = 0;
        }
        int blastRadiusFinal = blastRadius;
        DebugManager.Companion.log(DebugType.CREEPER_BLAST_RADIUS, lmEntity, () -> LevelManager.applyCreeperBlastRadius$lambda$47(lmEntity, damage, maxRadius, blastRadiusFinal));
        if (blastRadius < 0) {
            blastRadius = 0;
        }
        creeper.setExplosionRadius(blastRadius);
    }

    private final void applyLevelledEquipment(LivingEntityWrapper lmEntity, int level) {
        if (!lmEntity.isLevelled()) {
            return;
        }
        if (level < 1) {
            return;
        }
        CustomDropsRuleSet customDropsRuleSet = LevelledMobs.Companion.getInstance().getRulesManager().getRuleUseCustomDropsForMob(lmEntity);
        if (!customDropsRuleSet.getUseDrops()) {
            return;
        }
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> LevelManager.applyLevelledEquipment$lambda$48(this, lmEntity, customDropsRuleSet));
        scheduler.setEntity((Entity)lmEntity.getLivingEntity());
        lmEntity.getInUseCount().getAndIncrement();
        scheduler.run();
    }

    private final void applyLevelledEquipmentNonAsync(LivingEntityWrapper lmEntity, CustomDropsRuleSet customDropsRuleSet) {
        MythicMobsMobInfo mmInfo = MythicMobUtils.INSTANCE.getMythicMobInfo(lmEntity);
        if (mmInfo != null && mmInfo.getPreventRandomEquipment()) {
            return;
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        List items = new ArrayList();
        CustomDropResult dropResult = main.getCustomDropsHandler().getCustomItemDrops(lmEntity, items, true);
        if (items.isEmpty()) {
            return;
        }
        EntityEquipment entityEquipment = lmEntity.getLivingEntity().getEquipment();
        if (entityEquipment == null) {
            return;
        }
        EntityEquipment equipment = entityEquipment;
        if (lmEntity.getLockEntitySettings() && !((Collection)customDropsRuleSet.getUseDropTableIds()).isEmpty()) {
            String customDrops = CollectionsKt.joinToString$default(customDropsRuleSet.getUseDropTableIds(), ";", null, null, 0, null, null, 62, null);
            lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getLockedDropRules(), PersistentDataType.STRING, (Object)customDrops);
            ChunkKillOptions chunkKillOptions = customDropsRuleSet.getChunkKillOptions();
            Intrinsics.checkNotNull(chunkKillOptions);
            if (chunkKillOptions.getDisableVanillaDrops()) {
                lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getLockedDropRulesOverride(), PersistentDataType.INTEGER, (Object)1);
            }
        }
        boolean hadMainItem = false;
        boolean hadPlayerHead = false;
        EquippedItemsInfo equippedItemsInfo = new EquippedItemsInfo();
        Map equippedCountPerGroup = new LinkedHashMap();
        int equippedSoFar = 0;
        Collections.shuffle(dropResult.getStackToItem());
        for (Map.Entry<ItemStack, CustomDropItem> entry : dropResult.getStackToItem()) {
            Material material;
            boolean hasEquipLimits;
            ItemStack itemStack = entry.getKey();
            CustomDropItem item = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(itemStack.getType(), "getType(...)");
            GroupLimits groupLimits = main.getCustomDropsHandler().getGroupLimits(item);
            boolean bl = hasEquipLimits = item.getHasGroupId() && groupLimits != null && groupLimits.getHasCapEquipped();
            if (hasEquipLimits) {
                if (equippedCountPerGroup.containsKey(item.getGroupId())) {
                    Object v = equippedCountPerGroup.get(item.getGroupId());
                    Intrinsics.checkNotNull(v);
                    equippedSoFar = ((Number)v).intValue();
                }
                GroupLimits groupLimits2 = groupLimits;
                Intrinsics.checkNotNull(groupLimits2);
                if (groupLimits2.hasReachedCapEquipped(equippedSoFar)) {
                    DebugManager.Companion.log(DebugType.GROUP_LIMITS, lmEntity, () -> LevelManager.applyLevelledEquipmentNonAsync$lambda$49(groupLimits, material, item));
                    continue;
                }
            }
            if (EnchantmentTarget.ARMOR_FEET.includes(material)) {
                equipment.setBoots(itemStack, true);
                equipment.setBootsDropChance(0.0f);
                equippedItemsInfo.setBoots(item.getItemStack());
            } else if (EnchantmentTarget.ARMOR_LEGS.includes(material)) {
                equipment.setLeggings(itemStack, true);
                equipment.setLeggingsDropChance(0.0f);
                equippedItemsInfo.setLeggings(item.getItemStack());
            } else if (EnchantmentTarget.ARMOR_TORSO.includes(material)) {
                equipment.setChestplate(itemStack, true);
                equipment.setChestplateDropChance(0.0f);
                equippedItemsInfo.setChestplate(item.getItemStack());
            } else if (EnchantmentTarget.ARMOR_HEAD.includes(material) || StringsKt.endsWith$default(material.name(), "_HEAD", false, 2, null) || item.getEquipOnHelmet() && !hadPlayerHead) {
                equipment.setHelmet(itemStack, true);
                equipment.setHelmetDropChance(0.0f);
                equippedItemsInfo.setHelmet(item.getItemStack());
                if (material == Material.PLAYER_HEAD) {
                    hadPlayerHead = true;
                }
            } else if (!hadMainItem) {
                equipment.setItemInMainHand(itemStack);
                equipment.setItemInMainHandDropChance(0.0f);
                equippedItemsInfo.setMainHand(item.getItemStack());
                hadMainItem = true;
            } else if (item.getEquipOffhand()) {
                equipment.setItemInOffHand(itemStack);
                equipment.setItemInOffHandDropChance(0.0f);
                equippedItemsInfo.setOffhand(item.getItemStack());
            }
            ++equippedSoFar;
            if (!hasEquipLimits) continue;
            Integer n = equippedSoFar;
            equippedCountPerGroup.put(item.getGroupId(), n);
        }
        equippedItemsInfo.saveEquipment(lmEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final double getMobAttributeValue(LivingEntityWrapper lmEntity) {
        double result = 0.0;
        Object object = LevelledMobs.Companion.getInstance().getAttributeSyncObject();
        synchronized (object) {
            boolean bl = false;
            AttributeInstance attrib = lmEntity.getLivingEntity().getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (attrib != null) {
                result = attrib.getValue();
            }
            Unit unit = Unit.INSTANCE;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final double getMobHealth(LivingEntityWrapper lmEntity) {
        double result = 0.0;
        Object object = LevelledMobs.Companion.getInstance().getAttributeSyncObject();
        synchronized (object) {
            boolean bl = false;
            result = lmEntity.getLivingEntity().getHealth();
            Unit unit = Unit.INSTANCE;
        }
        return result;
    }

    @Override
    @NotNull
    public LevellableState getLevellableState(@NotNull LivingEntityInterface lmInterface) {
        Intrinsics.checkNotNullParameter(lmInterface, "lmInterface");
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (CollectionsKt.contains((Iterable)this.forcedBlockedEntityTypes, lmInterface.getEntityType())) {
            return LevellableState.DENIED_FORCE_BLOCKED_ENTITY_TYPE;
        }
        if (lmInterface.getApplicableRules().isEmpty()) {
            return LevellableState.DENIED_NO_APPLICABLE_RULES;
        }
        if (!main.getRulesManager().getRuleIsMobAllowedInEntityOverride(lmInterface)) {
            return LevellableState.DENIED_CONFIGURATION_BLOCKED_ENTITY_TYPE;
        }
        if (main.getRulesManager().getRuleMobMaxLevel(lmInterface) < 1) {
            return LevellableState.DENIED_LEVEL_0;
        }
        if (!(lmInterface instanceof LivingEntityWrapper)) {
            return LevellableState.ALLOWED;
        }
        LevellableState externalCompatResult = ExternalCompatibilityManager.Companion.checkAllExternalCompats((LivingEntityWrapper)lmInterface);
        if (externalCompatResult != LevellableState.ALLOWED) {
            return externalCompatResult;
        }
        if (((LivingEntityWrapper)lmInterface).isMobOfExternalType()) {
            ((LivingEntityWrapper)lmInterface).invalidateCache();
            if (!main.getRulesManager().getRuleIsMobAllowedInEntityOverride(lmInterface)) {
                return LevellableState.DENIED_CONFIGURATION_BLOCKED_ENTITY_TYPE;
            }
        }
        if (((LivingEntityWrapper)lmInterface).getLivingEntity().getCustomName() != null && main.getRulesManager().getRuleMobCustomNameStatus((LivingEntityWrapper)lmInterface) == MobCustomNameStatus.NOT_NAMETAGGED) {
            return LevellableState.DENIED_CONFIGURATION_CONDITION_NAMETAGGED;
        }
        return LevellableState.ALLOWED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public LevellableState getLevellableState(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        try {
            LevellableState levellableState = this.getLevellableState(lmEntity);
            return levellableState;
        }
        finally {
            lmEntity.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void applyLevelToMob(@NotNull LivingEntityWrapper lmEntity, int level, boolean isSummoned, boolean bypassLimits, @Nullable Set<AdditionalLevelInformation> additionalLevelInformation) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        main = LevelledMobs.Companion.getInstance();
        if (!main.getVer().isRunningFolia() && Bukkit.isPrimaryThread()) {
            scheduler = new SchedulerWrapper((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, applyLevelToMob$lambda$52(io.github.arcaneplugins.levelledmobs.managers.LevelManager io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper int boolean boolean java.util.Set ), ()V)((LevelManager)this, (LivingEntityWrapper)lmEntity, (int)level, (boolean)isSummoned, (boolean)bypassLimits, additionalLevelInformation));
            lmEntity.getInUseCount().getAndIncrement();
            scheduler.run();
            return;
        }
        useLevel = 0;
        useLevel = level;
        if (useLevel <= 0) {
            useLevel = this.generateLevel(lmEntity);
        }
        lmEntity.setMobPrelevel(useLevel);
        v0 = var8_9 = bypassLimits != false || isSummoned != false || this.getLevellableState(lmEntity) == LevellableState.ALLOWED;
        if (_Assertions.ENABLED && !var8_9) {
            var9_10 = "Assertion failed";
            throw new AssertionError((Object)var9_10);
        }
        skipLMNametag = false;
        if (lmEntity.getLivingEntity().isInsideVehicle() && main.getRulesManager().getRulePassengerMatchLevel(lmEntity) && lmEntity.getLivingEntity().getVehicle() instanceof LivingEntity) {
            v1 = lmEntity.getLivingEntity().getVehicle();
            Intrinsics.checkNotNull(v1, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
            vehicle = LivingEntityWrapper.Companion.getInstance((LivingEntity)v1);
            if (vehicle.isLevelled()) {
                useLevel = vehicle.getGetMobLevel();
                lmEntity.setMobPrelevel(useLevel);
            }
            vehicle.free();
        }
        if (isSummoned) {
            lmEntity.setSpawnReason(LevelledMobSpawnReason.LM_SUMMON, true);
            summonedMobPreLevelEvent = new SummonedMobPreLevelEvent(lmEntity.getLivingEntity(), useLevel);
            Bukkit.getPluginManager().callEvent((Event)summonedMobPreLevelEvent);
            if (summonedMobPreLevelEvent.isCancelled()) {
                return;
            }
        } else {
            mobPreLevelEvent = new MobPreLevelEvent(lmEntity.getLivingEntity(), useLevel, MobPreLevelEvent.LevelCause.NORMAL, additionalLevelInformation);
            Bukkit.getPluginManager().callEvent((Event)mobPreLevelEvent);
            if (mobPreLevelEvent.isCancelled()) {
                return;
            }
            useLevel = mobPreLevelEvent.getLevel();
            lmEntity.setMobPrelevel(useLevel);
            if (!mobPreLevelEvent.getShowLMNametag()) {
                skipLMNametag = true;
                lmEntity.setShouldShowLMNametag(false);
            }
        }
        hasNoLevelKey = false;
        if (!isSummoned) {
            v2 = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(v2, "getPersistentDataContainer(...)");
            var11_13 = v2;
            synchronized (var11_13) {
                $i$a$-synchronized-LevelManager$applyLevelToMob$1 = false;
                hasNoLevelKey = lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getNoLevelKey(), PersistentDataType.STRING);
                $i$a$-synchronized-LevelManager$applyLevelToMob$1 = Unit.INSTANCE;
            }
        }
        if (hasNoLevelKey) {
            DebugManager.Companion.log(DebugType.APPLY_LEVEL_RESULT, lmEntity, false, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, applyLevelToMob$lambda$54(), ()Ljava/lang/String;)());
            return;
        }
        v3 = lmEntity.getLivingEntity().getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(v3, "getPersistentDataContainer(...)");
        var11_13 = v3;
        synchronized (var11_13) {
            $i$a$-synchronized-LevelManager$applyLevelToMob$3 = false;
            lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getLevelKey(), PersistentDataType.INTEGER, (Object)useLevel);
            lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getMobHash(), PersistentDataType.STRING, (Object)main.getRulesManager().getCurrentRulesHash());
            $i$a$-synchronized-LevelManager$applyLevelToMob$3 = Unit.INSTANCE;
        }
        lmEntity.invalidateCache();
        if (lmEntity.getNbtData() == null) ** GOTO lbl-1000
        v4 = lmEntity.getNbtData();
        Intrinsics.checkNotNull(v4);
        if (((Collection)v4).isEmpty() == false) {
            v5 = lmEntity.getNbtData();
        } else lbl-1000:
        // 2 sources

        {
            v5 = main.getRulesManager().getRuleNbtData(lmEntity);
        }
        v6 = nbtDatas = v5;
        Intrinsics.checkNotNull(v6);
        if (((Collection)v6).isEmpty() == false && !ExternalCompatibilityManager.Companion.getHasNbtApiInstalled()) {
            v7 = msg = isSummoned != false ? "NBT Data was supplied but the required plugin NBTAPI is not installed!" : "NBT Data has been specified in customdrops.yml but the required plugin NBTAPI is not installed!";
            if (!this.hasMentionedNBTAPIMissing) {
                Log.INSTANCE.war(msg);
                this.hasMentionedNBTAPIMissing = true;
            }
            nbtDatas.clear();
        }
        lmEntity.setLockEntitySettings(main.getRulesManager().getRuleDoLockEntity(lmEntity));
        if (lmEntity.getLockEntitySettings() && lmEntity.isNewlySpawned()) {
            lmEntity.setLockedNametag(main.getRulesManager().getRuleNametag(lmEntity));
            lmEntity.setLockedOverrideName(main.getRulesManager().getRuleEntityOverriddenName(lmEntity, true));
        }
        doSkipLMNametag = skipLMNametag;
        try {
            this.applyLevelToMob2(lmEntity, nbtDatas, doSkipLMNametag);
            levelCause = isSummoned != false ? MobPostLevelEvent.LevelCause.SUMMONED : MobPostLevelEvent.LevelCause.NORMAL;
            Bukkit.getPluginManager().callEvent((Event)new MobPostLevelEvent(lmEntity, levelCause, additionalLevelInformation));
            sb = new StringBuilder();
            sb.append(", world: ");
            sb.append(lmEntity.getWorldName());
            sb.append(", level: ");
            sb.append(useLevel);
            if (isSummoned) {
                sb.append(" (summoned)");
            }
            if (bypassLimits) {
                sb.append(" (limit bypass)");
            }
            DebugManager.Companion.log(DebugType.APPLY_LEVEL_RESULT, lmEntity, true, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((StringBuilder)sb));
        }
        catch (TimeoutException e) {
            DebugManager.Companion.log(DebugType.APPLY_LEVEL_RESULT, lmEntity, false, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, applyLevelToMob$lambda$56(), ()Ljava/lang/String;)());
        }
    }

    private final void applyLevelToMob2(LivingEntityWrapper lmEntity, List<String> nbtDatas, boolean doSkipLMNametag) {
        this.applyAttribs(lmEntity, nbtDatas);
        if (!doSkipLMNametag) {
            LevelledMobs.Companion.getInstance().getLevelManager().updateNametagWithDelay(lmEntity);
        }
        LevelledMobs.Companion.getInstance().getLevelManager().applyLevelledEquipment(lmEntity, lmEntity.getGetMobLevel());
    }

    private final void applyAttribs(LivingEntityWrapper lmEntity, List<String> nbtDatas) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Addition[] additionArray = new Addition[]{Addition.ATTRIBUTE_ATTACK_DAMAGE, Addition.ATTRIBUTE_MAX_HEALTH, Addition.ATTRIBUTE_MOVEMENT_SPEED, Addition.ATTRIBUTE_ARMOR_BONUS, Addition.ATTRIBUTE_ARMOR_TOUGHNESS, Addition.ATTRIBUTE_ATTACK_KNOCKBACK, Addition.ATTRIBUTE_FLYING_SPEED, Addition.ATTRIBUTE_KNOCKBACK_RESISTANCE, Addition.ATTRIBUTE_FOLLOW_RANGE};
        List<Addition> attribs = CollectionsKt.mutableListOf(additionArray);
        if (lmEntity.getLivingEntity() instanceof Zombie) {
            attribs.add(Addition.ATTRIBUTE_ZOMBIE_SPAWN_REINFORCEMENTS);
        } else if (lmEntity.getLivingEntity() instanceof Horse) {
            attribs.add(Addition.ATTRIBUTE_HORSE_JUMP_STRENGTH);
        }
        main.getLevelManager().applyLevelledAttributes(lmEntity, attribs);
        if (lmEntity.getLockEntitySettings()) {
            lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getLockSettings(), PersistentDataType.INTEGER, (Object)1);
            if (lmEntity.getLockedNametag() != null) {
                PersistentDataContainer persistentDataContainer = lmEntity.getPdc();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getLockedNametag();
                String string = lmEntity.getLockedNametag();
                Intrinsics.checkNotNull(string);
                persistentDataContainer.set(namespacedKey, PersistentDataType.STRING, (Object)string);
            }
            if (lmEntity.getLockedOverrideName() != null) {
                PersistentDataContainer persistentDataContainer = lmEntity.getPdc();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getLockedNameOverride();
                String string = lmEntity.getLockedOverrideName();
                Intrinsics.checkNotNull(string);
                persistentDataContainer.set(namespacedKey, PersistentDataType.STRING, (Object)string);
            }
        }
        this.applyNbtData(lmEntity, nbtDatas);
        if (lmEntity.getLivingEntity() instanceof Creeper) {
            main.getLevelManager().applyCreeperBlastRadius(lmEntity);
        }
    }

    private final void applyNbtData(LivingEntityWrapper lmEntity, List<String> nbtDatas) {
        if (nbtDatas.isEmpty()) {
            return;
        }
        boolean hadSuccess = false;
        List allResults = new ArrayList();
        for (String nbtData : nbtDatas) {
            NBTApplyResult result = NBTManager.INSTANCE.applyNBTDataMob(lmEntity, nbtData);
            if (result.getHadException()) {
                if (lmEntity.getSummonedSender() == null) {
                    String string = "Error applying NBT data '%s' to %s. Exception message: %s";
                    Object[] objectArray = new Object[]{nbtData, lmEntity.getNameIfBaby(), result.getExceptionMessage()};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                    Log.INSTANCE.war(string2);
                    continue;
                }
                CommandSender commandSender = lmEntity.getSummonedSender();
                Intrinsics.checkNotNull(commandSender);
                commandSender.sendMessage("Error applying NBT data to " + lmEntity.getNameIfBaby() + ". Exception message: " + result.getExceptionMessage());
                continue;
            }
            hadSuccess = true;
            allResults.add(result);
        }
        if (hadSuccess) {
            DebugManager.Companion.log(DebugType.NBT_APPLICATION, lmEntity, true, () -> LevelManager.applyNbtData$lambda$57(this, allResults));
        }
    }

    private final String getNBTDebugMessage(List<NBTApplyResult> results) {
        String string;
        int i;
        int n;
        StringBuilder sb = new StringBuilder();
        for (NBTApplyResult result : results) {
            if (result.getObjectsAdded() == null) continue;
            List<String> list = result.getObjectsAdded();
            Intrinsics.checkNotNull(list);
            n = list.size();
            for (i = 0; i < n; ++i) {
                StringBuilder stringBuilder = i > 0 ? sb.append(", ") : sb.append("added: ");
                List<String> list2 = result.getObjectsAdded();
                Intrinsics.checkNotNull(list2);
                sb.append(list2.get(i));
            }
        }
        for (NBTApplyResult result : results) {
            if (result.getObjectsUpdated() == null) continue;
            List<String> list = result.getObjectsUpdated();
            Intrinsics.checkNotNull(list);
            n = list.size();
            for (i = 0; i < n; ++i) {
                if (i > 0 || ((CharSequence)sb).length() > 0) {
                    sb.append(", ");
                }
                if (i == 0) {
                    sb.append("updated: ");
                }
                List<String> list3 = result.getObjectsUpdated();
                Intrinsics.checkNotNull(list3);
                sb.append(list3.get(i));
            }
        }
        for (NBTApplyResult result : results) {
            if (result.getObjectsRemoved() == null) continue;
            List<String> list = result.getObjectsRemoved();
            Intrinsics.checkNotNull(list);
            n = list.size();
            for (i = 0; i < n; ++i) {
                if (i > 0 || ((CharSequence)sb).length() > 0) {
                    sb.append(", ");
                }
                if (i == 0) {
                    sb.append("removed: ");
                }
                List<String> list4 = result.getObjectsRemoved();
                Intrinsics.checkNotNull(list4);
                sb.append(list4.get(i));
            }
        }
        if (((CharSequence)sb).length() == 0) {
            string = "";
        } else {
            String string2 = sb.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLevelled(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
        boolean hadError = false;
        boolean succeeded = false;
        boolean isLevelled = false;
        for (int i = 0; i < 2; ++i) {
            try {
                PersistentDataContainer persistentDataContainer = livingEntity.getPersistentDataContainer();
                Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
                PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
                synchronized (persistentDataContainer2) {
                    boolean bl = false;
                    isLevelled = livingEntity.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getLevelKey(), PersistentDataType.INTEGER);
                    Unit unit = Unit.INSTANCE;
                }
                succeeded = true;
                break;
            }
            catch (ConcurrentModificationException ignored) {
                hadError = true;
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException ignored2) {
                    return false;
                }
            }
        }
        if (hadError) {
            if (succeeded) {
                Log.INSTANCE.war("Got ConcurrentModificationException in LevelManager checking entity isLevelled, succeeded on retry");
            } else {
                Log.INSTANCE.war("Got ConcurrentModificationException (2x) in LevelManager checking entity isLevelled");
            }
        }
        return isLevelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLevelOfMob(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
        PersistentDataContainer persistentDataContainer = livingEntity.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        synchronized (persistentDataContainer2) {
            block4: {
                boolean bl = false;
                if (livingEntity.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getLevelKey(), PersistentDataType.INTEGER)) break block4;
                int n = -1;
                return n;
            }
            Object object = livingEntity.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getLevelKey(), PersistentDataType.INTEGER);
            Intrinsics.checkNotNull(object);
            int n = ((Number)object).intValue();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLevel(@NotNull LivingEntityWrapper lmEntity) {
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        boolean bl = lmEntity.isLevelled();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        Object object = persistentDataContainer;
        synchronized (object) {
            boolean $i$a$-synchronized-LevelManager$removeLevel$32 = false;
            if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLevelKey(), PersistentDataType.INTEGER)) {
                lmEntity.getPdc().remove(NamespacedKeys.INSTANCE.getLevelKey());
            }
            if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getOverridenEntityNameKey(), PersistentDataType.STRING)) {
                lmEntity.getPdc().remove(NamespacedKeys.INSTANCE.getOverridenEntityNameKey());
            }
            Unit $i$a$-synchronized-LevelManager$removeLevel$32 = Unit.INSTANCE;
        }
        object = main.getAttributeSyncObject();
        synchronized (object) {
            boolean bl2 = false;
            for (Attribute attribute : EntriesMappings.entries$0) {
                AttributeInstance attInst = lmEntity.getLivingEntity().getAttribute(attribute);
                if (attInst == null) continue;
                Enumeration existingMods = Collections.enumeration(attInst.getModifiers());
                while (existingMods.hasMoreElements()) {
                    AttributeModifier existingMod = (AttributeModifier)existingMods.nextElement();
                    if (main.getMobDataManager().getVanillaMultiplierNames().containsKey(existingMod.getName())) continue;
                    attInst.removeModifier(existingMod);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        if (lmEntity.getLivingEntity() instanceof Creeper) {
            LivingEntity livingEntity = lmEntity.getLivingEntity();
            Intrinsics.checkNotNull(livingEntity, "null cannot be cast to non-null type org.bukkit.entity.Creeper");
            ((Creeper)livingEntity).setExplosionRadius(3);
        }
        lmEntity.invalidateCache();
        main.getLevelManager().updateNametag(lmEntity);
    }

    @Override
    public void removeLevel(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        this.removeLevel(lmEntity);
        lmEntity.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getMobNametag(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter(livingEntity, "livingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        try {
            String string = this.getNametag(lmEntity, false).getNametag();
            return string;
        }
        finally {
            lmEntity.free();
        }
    }

    private static final String generateLevel$lambda$0(int $count, LevellingStrategy $strategy, float $result) {
        Intrinsics.checkNotNullParameter($strategy, "$strategy");
        return $count > 0 ? ", " + $strategy.getStrategyType() + ": " + $result : $strategy.getStrategyType() + ": " + $result;
    }

    private static final String generateLevel$lambda$1(int $count, CustomStrategy $strategy, float $result) {
        Intrinsics.checkNotNullParameter($strategy, "$strategy");
        return $count > 0 ? ", " + $strategy.getPlaceholderName() + ": " + $result : $strategy.getPlaceholderName() + ": " + $result;
    }

    private static final String constructLevel$lambda$2(int $result, String $formulaPre, String $formula) {
        Intrinsics.checkNotNullParameter($formulaPre, "$formulaPre");
        Intrinsics.checkNotNullParameter($formula, "$formula");
        return "result " + $result + "\n   formulaPre: '" + $formulaPre + "'\n   formula: '" + $formula + "'";
    }

    private static final String getPlayerLevelSourceNumber$lambda$3(PlayerHomeCheckResult $result) {
        Intrinsics.checkNotNullParameter($result, "$result");
        return $result.getResultMessage();
    }

    private static final String getPlayerLevelSourceNumber$lambda$4(String $variableToUse, Player $player, Location $l) {
        Intrinsics.checkNotNullParameter($variableToUse, "$variableToUse");
        Intrinsics.checkNotNullParameter($l, "$l");
        String string = "Got blank result for '%s' from PAPI. Player %s at %s,%s,%s in %s";
        Object[] objectArray = new Object[]{$variableToUse, $player.getName(), $l.getBlockX(), $l.getBlockY(), $l.getBlockZ(), $player.getWorld().getName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private static final String getPlayerLevelSourceNumber$lambda$5(String $variableToUse, Player $player, Location $l) {
        Intrinsics.checkNotNullParameter($variableToUse, "$variableToUse");
        Intrinsics.checkNotNullParameter($l, "$l");
        String string = "Got blank result for '%s' from PAPI. Player %s at %s,%s,%s in %s";
        Object[] objectArray = new Object[]{$variableToUse, $player.getName(), $l.getBlockX(), $l.getBlockY(), $l.getBlockZ(), $player.getWorld().getName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private static final String setLevelledItemDrops$lambda$6(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "mob-lvl: &b" + $lmEntity.getGetMobLevel() + "&7, removing any drops present";
    }

    private static final String setLevelledItemDrops$lambda$7(String $nameWithOverride, LivingEntityWrapper $lmEntity, int $vanillaDrops, List $currentDrops, int $additionUsedFinal) {
        Intrinsics.checkNotNullParameter($nameWithOverride, "$nameWithOverride");
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($currentDrops, "$currentDrops");
        String string = "%smob-lvl: &b%s&7, vanilla drops: &b%s&7, all drops: &b%s&7, addition: &b%s&7.";
        Object[] objectArray = new Object[]{$nameWithOverride, $lmEntity.getGetMobLevel(), $vanillaDrops, $currentDrops.size(), $additionUsedFinal};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private static final String multiplyDrop$lambda$8() {
        return "&7Item was unmanaged.";
    }

    private static final String multiplyDrop$lambda$9(ItemStack $currentDrop, int $oldAmount, float $addition) {
        Intrinsics.checkNotNullParameter($currentDrop, "$currentDrop");
        return "&7Drop: &b" + $currentDrop.getType() + "&7, old amount: &b" + $oldAmount + "&7, addition value: &b" + $addition + "&7, new amount: &b" + $currentDrop.getAmount() + "&7.";
    }

    private static final String getLevelledExpDrops$lambda$10(LivingEntityWrapper $lmEntity, double $xp) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "lvl: &b" + $lmEntity.getGetMobLevel() + "&7, xp-vanilla: &b" + $xp + "&7, new-xp: &b0&7";
    }

    private static final String getLevelledExpDrops$lambda$11(LivingEntityWrapper $lmEntity, double $xp, int $newXpFinal) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "lvl: &b" + $lmEntity.getGetMobLevel() + "&7, xp-vanilla: &b" + $xp + "&7, new-xp: &b" + $newXpFinal + "&7";
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$13() {
        return "mob-lvl was 0 or maxlevel was 0";
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$14(int $mobLevel, float $minLevel, float $maxLevel, float $newValue) {
        return "'(" + (float)$mobLevel + " - " + $minLevel + ") / (" + $maxLevel + " - " + $minLevel + ")', result: " + $newValue;
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$15(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return $lmEntity.getRangedDamage() != null ? String.valueOf($lmEntity.getRangedDamage()) : "0";
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$16(LivingEntityWrapper $lmEntity, Map.Entry $placeholder) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($placeholder, "$placeholder");
        return String.valueOf(((Number)$lmEntity.getStrategyResults().getOrDefault($placeholder.getValue(), Float.valueOf(0.0f))).floatValue());
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$17(LivingEntityWrapper $lmEntity, String $placeholder) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($placeholder, "$placeholder");
        return String.valueOf(((Number)$lmEntity.getCustomStrategyResults().getOrDefault($placeholder, Float.valueOf(0.0f))).floatValue());
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$18(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return String.valueOf($lmEntity.getDistanceFromSpawn());
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$19(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        LivingEntity livingEntity = $lmEntity.getLivingEntity();
        Creeper creeper = livingEntity instanceof Creeper ? (Creeper)livingEntity : null;
        Object object = creeper;
        if (object == null || (object = Integer.valueOf(object.getExplosionRadius()).toString()) == null) {
            object = "0";
        }
        return object;
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$20(LivingEntityWrapper $lmEntity, Map.Entry $placeholder) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($placeholder, "$placeholder");
        AttributeInstance attributeInstance = $lmEntity.getAttributeValuesCache();
        return String.valueOf(attributeInstance != null && (attributeInstance = attributeInstance.get($placeholder.getValue())) != null ? Double.valueOf(attributeInstance.getBaseValue()) : null);
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$21() {
        return "1";
    }

    private static final String replaceStringPlaceholdersForFormulas$lambda$22() {
        return "1";
    }

    private static final String replaceStringPlaceholders$lambda$23(LivingEntityWrapper $lmEntity, boolean $preserveMobName) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        String overridenName = $lmEntity.getLockedOverrideName() == null ? LevelledMobs.Companion.getInstance().getRulesManager().getRuleEntityOverriddenName($lmEntity, false) : $lmEntity.getLockedOverrideName();
        CharSequence charSequence = overridenName;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return overridenName;
        }
        if ($lmEntity.getLivingEntity().getCustomName() != null) {
            return $lmEntity.getLivingEntity().getCustomName();
        }
        return $preserveMobName ? "{DisplayName}" : Utils.INSTANCE.capitalize(StringsKt.replace$default($lmEntity.getTypeName(), "_", " ", false, 4, null));
    }

    private static final String replaceStringPlaceholders$lambda$24(LivingEntityWrapper $lmEntity) {
        Double baseHealth;
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        AttributeInstance attributeInstance = $lmEntity.getLivingEntity().getAttribute(Attribute.GENERIC_MAX_HEALTH);
        Double d = baseHealth = attributeInstance != null ? Double.valueOf(attributeInstance.getBaseValue()) : null;
        if (d != null) {
            return d.toString();
        }
        return "0";
    }

    private static final String replaceStringPlaceholders$lambda$25(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return $lmEntity.getLivingEntity().getLocation().getBlockX() + " " + $lmEntity.getLivingEntity().getLocation().getBlockX() + " " + $lmEntity.getLivingEntity().getLocation().getBlockZ();
    }

    private static final String replaceStringPlaceholders$lambda$26(Map.Entry $placeholder, LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($placeholder, "$placeholder");
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return ((ExternalPluginDetection)$placeholder.getValue()).getPlaceholder($lmEntity);
    }

    private static final void updateNametagWithDelay$lambda$27(LevelManager this$0, LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        this$0.updateNametag($lmEntity);
        $lmEntity.free();
    }

    private static final void startNametagAutoUpdateTask$lambda$28(LevelManager this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.checkLEWCache();
        this$0.enumerateNearbyEntities();
    }

    private static final void startNametagAutoUpdateTask$lambda$29(Runnable $runnable, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter($runnable, "$runnable");
        $runnable.run();
    }

    private static final String checkLEWCache$lambda$30(long $configDuration) {
        return "Reached " + $configDuration + " ms, clearing LEW cache, " + LivingEntityWrapper.Companion.getLEWDebug();
    }

    private static final void enumerateNearbyEntities$lambda$31(LevelManager this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (this$0.asyncRunningCount.get() == 0) {
            this$0.runNametagCheckASync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void enumerateNearbyEntities$lambda$33(Player $player, int $checkDistance, LevelManager this$0, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        List list = $player.getNearbyEntities((double)$checkDistance, (double)$checkDistance, (double)$checkDistance);
        Intrinsics.checkNotNullExpressionValue(list, "getNearbyEntities(...)");
        List entities = list;
        Object object = this$0.entitiesPerPlayerLock;
        synchronized (object) {
            boolean bl = false;
            Map<Player, List<Entity>> map = this$0.entitiesPerPlayer;
            Intrinsics.checkNotNull($player);
            List<Entity> list2 = map.put($player, entities);
        }
        this$0.asyncRunningCount.getAndDecrement();
        if (this$0.asyncRunningCount.get() == 0) {
            this$0.runNametagCheckASync();
        }
    }

    private static final void startNametagTimer$lambda$34() {
        LevelledMobs.Companion.getInstance().getNametagTimerChecker().checkNametags();
    }

    private static final void runNametagCheckASync$lambda$35(LevelManager this$0, Entity $entity, Player $player, Map $entityToPlayer, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($entity, "$entity");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($entityToPlayer, "$entityToPlayer");
        this$0.checkEntity($entity, $player, $entityToPlayer);
    }

    private static final String checkEntity$lambda$37(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "&b" + $lmEntity.getTypeName() + " &7was a baby and is now an adult, applying levelling rules";
    }

    private static final boolean checkEntityForPlayerLevelling$lambda$38(LivingEntity $mob, Player p) {
        Intrinsics.checkNotNullParameter($mob, "$mob");
        Intrinsics.checkNotNullParameter(p, "p");
        return Intrinsics.areEqual(p.getWorld(), $mob.getWorld());
    }

    private static final boolean checkEntityForPlayerLevelling$lambda$39(Player p) {
        Intrinsics.checkNotNullParameter(p, "p");
        return p.getGameMode() != GameMode.SPECTATOR;
    }

    private static final Pair checkEntityForPlayerLevelling$lambda$40(LivingEntity $mob, Player p) {
        Intrinsics.checkNotNullParameter($mob, "$mob");
        Intrinsics.checkNotNullParameter(p, "p");
        return new Pair<Double, Player>($mob.getLocation().distanceSquared(p.getLocation()), p);
    }

    private static final Player checkEntityForPlayerLevelling$lambda$42(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Player)it.getSecond();
    }

    private static final boolean checkEntityForPlayerLevelling$lambda$43(Player p) {
        Intrinsics.checkNotNullParameter(p, "p");
        return p.getGameMode() != GameMode.CREATIVE;
    }

    private static final void applyLevelledAttributes$lambda$45(LivingEntityWrapper $lmEntity, List $modInfo) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($modInfo, "$modInfo");
        MobDataManager.Companion.getInstance().setAttributeMods($lmEntity, $modInfo);
        $lmEntity.free();
    }

    private static final String applyCreeperBlastRadius$lambda$46(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "lvl: " + $lmEntity.getGetMobLevel() + ", mulp: null, result: 3";
    }

    private static final String applyCreeperBlastRadius$lambda$47(LivingEntityWrapper $lmEntity, float $damage, int $maxRadius, int $blastRadiusFinal) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        String string = "lvl: %s, mulp: %s, max: %s, result: %s";
        Object[] objectArray = new Object[]{$lmEntity.getGetMobLevel(), Utils.INSTANCE.round($damage, 3), $maxRadius, $blastRadiusFinal};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private static final void applyLevelledEquipment$lambda$48(LevelManager this$0, LivingEntityWrapper $lmEntity, CustomDropsRuleSet $customDropsRuleSet) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($customDropsRuleSet, "$customDropsRuleSet");
        this$0.applyLevelledEquipmentNonAsync($lmEntity, $customDropsRuleSet);
        $lmEntity.free();
    }

    private static final String applyLevelledEquipmentNonAsync$lambda$49(GroupLimits $groupLimits, Material $material, CustomDropItem $item) {
        Intrinsics.checkNotNullParameter($material, "$material");
        Intrinsics.checkNotNullParameter($item, "$item");
        String string = "Reached equip limit of %s, item: %s, group: %s";
        Object[] objectArray = new Object[]{$groupLimits.getCapEquipped(), $material, $item.getGroupId()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    private static final void applyLevelToMob$lambda$52(LevelManager this$0, LivingEntityWrapper $lmEntity, int $level, boolean $isSummoned, boolean $bypassLimits, Set $additionalLevelInformation) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        this$0.applyLevelToMob($lmEntity, $level, $isSummoned, $bypassLimits, $additionalLevelInformation);
        $lmEntity.free();
    }

    private static final String applyLevelToMob$lambda$54() {
        return "&7 had &bnoLevelKey&7 attached";
    }

    private static final String applyLevelToMob$lambda$56() {
        return "Timed out applying level to mob";
    }

    private static final String applyNbtData$lambda$57(LevelManager this$0, List $allResults) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($allResults, "$allResults");
        return "Applied NBT data, " + this$0.getNBTDebugMessage($allResults);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/arcaneplugins/levelledmobs/managers/LevelManager$Companion;", "", "<init>", "()V", "summonedOrSpawnEggs_Lock", "getSummonedOrSpawnEggs_Lock", "()Ljava/lang/Object;", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getSummonedOrSpawnEggs_Lock() {
            return summonedOrSpawnEggs_Lock;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Attribute> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Attribute.values()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Addition.values().length];
            try {
                nArray[Addition.ATTRIBUTE_MAX_HEALTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_ATTACK_DAMAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_MOVEMENT_SPEED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_HORSE_JUMP_STRENGTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_ARMOR_BONUS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_ARMOR_TOUGHNESS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_KNOCKBACK_RESISTANCE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_FLYING_SPEED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_ATTACK_KNOCKBACK.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_FOLLOW_RANGE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Addition.ATTRIBUTE_ZOMBIE_SPAWN_REINFORCEMENTS.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

