/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.commands.CommandHandler;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.managers.NotifyManager;
import io.github.arcaneplugins.levelledmobs.managers.PlaceholderApiIntegration;
import io.github.arcaneplugins.levelledmobs.misc.FileLoader;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.NametagTimerChecker;
import io.github.arcaneplugins.levelledmobs.misc.PlayerQueueItem;
import io.github.arcaneplugins.levelledmobs.result.NametagResult;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0010H\u0003J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0014H\u0007J\u001e\u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u001e\u0010\u0019\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/PlayerJoinListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "main", "Lio/github/arcaneplugins/levelledmobs/LevelledMobs;", "getMain", "()Lio/github/arcaneplugins/levelledmobs/LevelledMobs;", "onJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "checkForNetherPortalCoords", "player", "Lorg/bukkit/entity/Player;", "onPlayerQuitEvent", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onChangeWorld", "Lorg/bukkit/event/player/PlayerChangedWorldEvent;", "onTeleport", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "updateNametagsInWorldAsync", "entities", "", "Lorg/bukkit/entity/Entity;", "updateNametagsInWorld", "parseUpdateChecker", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nPlayerJoinListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerJoinListener.kt\nio/github/arcaneplugins/levelledmobs/listeners/PlayerJoinListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,201:1\n1863#2,2:202\n*S KotlinDebug\n*F\n+ 1 PlayerJoinListener.kt\nio/github/arcaneplugins/levelledmobs/listeners/PlayerJoinListener\n*L\n198#1:202,2\n*E\n"})
public final class PlayerJoinListener
implements Listener {
    @NotNull
    private final LevelledMobs main = LevelledMobs.Companion.getInstance();

    @NotNull
    public final LevelledMobs getMain() {
        return this.main;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getPlayer().isOp() && this.main.getDebugManager().getPlayerThatEnabledDebug() == null) {
            this.main.getDebugManager().setPlayerThatEnabledDebug(event.getPlayer());
        }
        this.main.getMainCompanion().addRecentlyJoinedPlayer(event.getPlayer());
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        this.checkForNetherPortalCoords(player);
        NametagTimerChecker nametagTimerChecker = this.main.getNametagTimerChecker();
        Player player2 = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
        nametagTimerChecker.addPlayerToQueue(new PlayerQueueItem(player2, true));
        Player player3 = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player3, "getPlayer(...)");
        this.parseUpdateChecker(player3);
        if (!LevelledMobs.Companion.getInstance().getVer().isRunningFolia()) {
            Player player4 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player4, "getPlayer(...)");
            List list = event.getPlayer().getWorld().getEntities();
            Intrinsics.checkNotNullExpressionValue(list, "getEntities(...)");
            this.updateNametagsInWorldAsync(player4, list);
        }
        if (event.getPlayer().isOp()) {
            if (this.main.getMainCompanion().getHadRulesLoadError()) {
                event.getPlayer().sendMessage(FileLoader.INSTANCE.getFileLoadErrorMessage());
            }
            if (this.main.getMigratedFromPre30()) {
                event.getPlayer().sendMessage(MessageUtils.INSTANCE.colorizeStandardCodes("&b&lLevelledMobs: &cWARNING &7You have migrated from an older version.  All settings have been reverted.  Please edit rules.yml"));
            }
            if (NotifyManager.INSTANCE.getOpHasMessage()) {
                Player player5 = event.getPlayer();
                String string = NotifyManager.INSTANCE.getPendingMessage();
                Intrinsics.checkNotNull(string);
                player5.sendMessage(string);
                NotifyManager.INSTANCE.clearLastError();
            }
            if (this.main.getCustomDropsHandler().getCustomDropsParser().getHadParsingError()) {
                event.getPlayer().sendMessage(MessageUtils.INSTANCE.colorizeAll("&b&lLevelledMobs:&r &6There was an error parsing customdrops.yml&r\nCheck the console log for more details"));
            }
            if (CommandHandler.INSTANCE.getHadErrorLoading()) {
                event.getPlayer().sendMessage(MessageUtils.INSTANCE.colorizeAll("&b&lLevelledMobs:&r &6There was an error loading the command framework.&r\nOnly the reload option will be available."));
            }
        }
    }

    private final void checkForNetherPortalCoords(Player player) {
        NamespacedKey[] namespacedKeyArray = new NamespacedKey[]{NamespacedKeys.INSTANCE.getPlayerNetherCoords(), NamespacedKeys.INSTANCE.getPlayerNetherCoordsIntoWorld()};
        List<NamespacedKey> keys2 = CollectionsKt.mutableListOf(namespacedKeyArray);
        try {
            int n = ((Collection)keys2).size();
            for (int i = 0; i < n; ++i) {
                World world;
                String netherCoords;
                NamespacedKey useKey = keys2.get(i);
                if (!player.getPersistentDataContainer().has(useKey, PersistentDataType.STRING) || (netherCoords = (String)player.getPersistentDataContainer().get(useKey, PersistentDataType.STRING)) == null) continue;
                String[] stringArray = new String[]{","};
                List coords = StringsKt.split$default((CharSequence)netherCoords, stringArray, false, 0, 6, null);
                if (coords.size() != 4 || Bukkit.getWorld((String)((String)coords.get(0))) == null) continue;
                Location location = new Location(world, (double)Integer.parseInt((String)coords.get(1)), (double)Integer.parseInt((String)coords.get(2)), (double)Integer.parseInt((String)coords.get(3)));
                if (i == 0) {
                    this.main.getMainCompanion().setPlayerNetherPortalLocation(player, location);
                    continue;
                }
                this.main.getMainCompanion().setPlayerWorldPortalLocation(player, location);
            }
        }
        catch (Exception e) {
            Log.INSTANCE.war("Unable to get player nether portal coords from " + player.getName() + ", " + e.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private final void onPlayerQuitEvent(PlayerQuitEvent event) {
        if (this.main.getPlaceholderApiIntegration() != null) {
            PlaceholderApiIntegration placeholderApiIntegration = this.main.getPlaceholderApiIntegration();
            Intrinsics.checkNotNull((Object)placeholderApiIntegration);
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            placeholderApiIntegration.playedLoggedOut(player);
        }
        this.main.getMainCompanion().getSpawnerCopyIds().remove(event.getPlayer().getUniqueId());
        this.main.getMainCompanion().getSpawnerInfoIds().remove(event.getPlayer().getUniqueId());
        NametagTimerChecker nametagTimerChecker = this.main.getNametagTimerChecker();
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        nametagTimerChecker.addPlayerToQueue(new PlayerQueueItem(player, false));
        if (this.main.getPlaceholderApiIntegration() != null) {
            PlaceholderApiIntegration placeholderApiIntegration = this.main.getPlaceholderApiIntegration();
            Intrinsics.checkNotNull((Object)placeholderApiIntegration);
            Player player2 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
            placeholderApiIntegration.removePlayer(player2);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onChangeWorld(@NotNull PlayerChangedWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        List list = event.getPlayer().getWorld().getEntities();
        Intrinsics.checkNotNullExpressionValue(list, "getEntities(...)");
        this.updateNametagsInWorldAsync(player, list);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onTeleport(@NotNull PlayerTeleportEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getTo() != null && event.getTo().getWorld() != null && event.getFrom().getWorld() != null && event.getFrom().getWorld() != event.getTo().getWorld()) {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            List list = event.getTo().getWorld().getEntities();
            Intrinsics.checkNotNullExpressionValue(list, "getEntities(...)");
            this.updateNametagsInWorldAsync(player, list);
        }
    }

    private final void updateNametagsInWorldAsync(Player player, List<? extends Entity> entities) {
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> PlayerJoinListener.updateNametagsInWorldAsync$lambda$0(this, player, entities));
        scheduler.setRunDirectlyInFolia(true);
        scheduler.run();
    }

    private final void updateNametagsInWorld(Player player, List<? extends Entity> entities) {
        int currentPlayers = Bukkit.getOnlinePlayers().size();
        if (currentPlayers > this.main.getMaxPlayersRecorded()) {
            this.main.setMaxPlayersRecorded(currentPlayers);
        }
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity) || !entity.isValid() || !this.main.getLevelManager().isLevelled((LivingEntity)entity)) continue;
            LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
            NametagResult nametag = this.main.getLevelManager().getNametag(lmEntity, false, false);
            Player[] playerArray = new Player[]{player};
            this.main.getLevelManager().updateNametag(lmEntity, nametag, CollectionsKt.mutableListOf(playerArray));
            lmEntity.free();
        }
    }

    private final void parseUpdateChecker(Player player) {
        if (this.main.getMessagesCfg().getBoolean("other.update-notice.send-on-join", true) && player.hasPermission("levelledmobs.receive-update-notifications")) {
            Iterable $this$forEach$iv = this.main.getMainCompanion().getUpdateResult();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p0 = (String)element$iv;
                boolean bl = false;
                player.sendMessage(p0);
            }
        }
    }

    private static final void updateNametagsInWorldAsync$lambda$0(PlayerJoinListener this$0, Player $player, List $entities) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($player, "$player");
        Intrinsics.checkNotNullParameter($entities, "$entities");
        this$0.updateNametagsInWorld($player, $entities);
    }
}

