/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.LevellableState;
import io.github.arcaneplugins.levelledmobs.enums.LevelledMobSpawnReason;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.managers.LevelManager;
import io.github.arcaneplugins.levelledmobs.result.AdditionalLevelInformation;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006\u000e"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntityTransformListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onTransform", "", "event", "Lorg/bukkit/event/entity/EntityTransformEvent;", "checkForSlimeSplit", "livingEntity", "Lorg/bukkit/entity/LivingEntity;", "transformedEntities", "", "Lorg/bukkit/entity/Entity;", "levelledmobs-plugin"})
public final class EntityTransformListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onTransform(@NotNull EntityTransformEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event.getEntity() instanceof LivingEntity)) {
            DebugManager.Companion.log(DebugType.ENTITY_MISC, event.getEntity(), false, EntityTransformListener::onTransform$lambda$0);
            return;
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        LevelManager levelManager = main.getLevelManager();
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        if (!levelManager.isLevelled((LivingEntity)entity)) {
            DebugManager.Companion.log(DebugType.ENTITY_MISC, event.getEntity(), false, EntityTransformListener::onTransform$lambda$1);
            if (event.getTransformReason() == EntityTransformEvent.TransformReason.SPLIT) {
                Entity entity2 = event.getEntity();
                Intrinsics.checkNotNull(entity2, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
                LivingEntity livingEntity = (LivingEntity)entity2;
                List list = event.getTransformedEntities();
                Intrinsics.checkNotNullExpressionValue(list, "getTransformedEntities(...)");
                this.checkForSlimeSplit(livingEntity, list);
            }
            return;
        }
        Entity entity3 = event.getEntity();
        Intrinsics.checkNotNull(entity3, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity3);
        boolean useInheritance = false;
        int level = 1;
        if (main.getRulesManager().getRuleMobLevelInheritance(lmEntity)) {
            useInheritance = true;
            level = lmEntity.getGetMobLevel();
        }
        for (Entity transformedEntity : event.getTransformedEntities()) {
            if (!(transformedEntity instanceof LivingEntity)) {
                DebugManager.Companion.log(DebugType.ENTITY_MISC, event.getEntity(), false, EntityTransformListener::onTransform$lambda$2);
                continue;
            }
            LivingEntityWrapper transformedLmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)transformedEntity);
            LevellableState levelledState = main.getLevelInterface().getLevellableState(transformedLmEntity);
            if (levelledState != LevellableState.ALLOWED) {
                DebugManager.Companion.log(DebugType.ENTITY_MISC, event.getEntity(), false, () -> EntityTransformListener.onTransform$lambda$3(levelledState));
                main.getLevelManager().updateNametagWithDelay(transformedLmEntity);
                transformedLmEntity.free();
                continue;
            }
            DebugManager.Companion.log(DebugType.ENTITY_MISC, transformedEntity, true, EntityTransformListener::onTransform$lambda$4);
            if (useInheritance) {
                if (lmEntity.getSpawnReason() == LevelledMobSpawnReason.LM_SPAWNER) {
                    transformedLmEntity.setSpawnReason(LevelledMobSpawnReason.SPAWNER);
                }
                AdditionalLevelInformation[] additionalLevelInformationArray = new AdditionalLevelInformation[]{AdditionalLevelInformation.FROM_TRANSFORM_LISTENER};
                main.getLevelInterface().applyLevelToMob(transformedLmEntity, level, false, false, SetsKt.mutableSetOf(additionalLevelInformationArray));
            } else {
                main.getLevelManager().getEntitySpawnListener().preprocessMob(transformedLmEntity, (Event)new EntitySpawnEvent(transformedEntity));
            }
            main.getLevelManager().updateNametagWithDelay(lmEntity);
            transformedLmEntity.free();
        }
        lmEntity.free();
    }

    private final void checkForSlimeSplit(LivingEntity livingEntity, List<? extends Entity> transformedEntities) {
        LivingEntityWrapper parent = LivingEntityWrapper.Companion.getInstance(livingEntity);
        if (parent.getSpawnReason() == LevelledMobSpawnReason.DEFAULT || parent.getSpawnReason() == LevelledMobSpawnReason.SLIME_SPLIT) {
            parent.free();
            return;
        }
        for (Entity entity : transformedEntities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntityWrapper lew = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
            lew.setSpawnReason(parent.getSpawnReason());
            lew.free();
        }
        parent.free();
    }

    private static final String onTransform$lambda$0() {
        return "entity was &bnot&7 an instance of LivingEntity";
    }

    private static final String onTransform$lambda$1() {
        return "original entity was &bnot&7 levelled";
    }

    private static final String onTransform$lambda$2() {
        return "entity was&b not&7 an instance of LivingEntity (loop)";
    }

    private static final String onTransform$lambda$3(LevellableState $levelledState) {
        Intrinsics.checkNotNullParameter((Object)$levelledState, "$levelledState");
        return "transformed entity was &bnot&7 levellable, reason: &b" + $levelledState;
    }

    private static final String onTransform$lambda$4() {
        return "entity was transformed";
    }
}

