/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.LevellableState;
import io.github.arcaneplugins.levelledmobs.enums.LevelledMobSpawnReason;
import io.github.arcaneplugins.levelledmobs.enums.NametagVisibilityEnum;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.listeners.EntitySpawnListener$Companion$getPlayersNearMob$;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.managers.LevelManager;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.result.AdditionalLevelInformation;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\u0011J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\u0011H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "processMobSpawns", "", "getProcessMobSpawns", "()Z", "setProcessMobSpawns", "(Z)V", "onEntitySpawn", "", "event", "Lorg/bukkit/event/entity/EntitySpawnEvent;", "delayedAddToQueue", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "Lorg/bukkit/event/Event;", "delay", "", "lmSpawnerSpawn", "Lorg/bukkit/event/entity/SpawnerSpawnEvent;", "createParticleEffect", "location", "Lorg/bukkit/Location;", "particle", "Lorg/bukkit/Particle;", "count", "preprocessMob", "shouldDenyLevel", "levelAssignment", "getLevellableState", "Lio/github/arcaneplugins/levelledmobs/enums/LevellableState;", "Companion", "levelledmobs-plugin"})
public final class EntitySpawnListener
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean processMobSpawns;

    public final boolean getProcessMobSpawns() {
        return this.processMobSpawns;
    }

    public final void setProcessMobSpawns(boolean bl) {
        this.processMobSpawns = bl;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onEntitySpawn(@NotNull EntitySpawnEvent event) {
        int mobProcessDelay;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
        lmEntity.setSkylightLevel(lmEntity.getCurrentSkyLightLevel());
        lmEntity.setNewlySpawned(true);
        lmEntity.populateShowShowLMNametag();
        MobDataManager.Companion.populateAttributeCache(lmEntity, null);
        if (event instanceof CreatureSpawnEvent) {
            CreatureSpawnEvent.SpawnReason spawnReason = ((CreatureSpawnEvent)event).getSpawnReason();
            Intrinsics.checkNotNullExpressionValue(spawnReason, "getSpawnReason(...)");
            CreatureSpawnEvent.SpawnReason spawnReason2 = spawnReason;
            lmEntity.setSpawnReason(Utils.INSTANCE.adaptVanillaSpawnReason(spawnReason2));
            if (!(spawnReason2 != CreatureSpawnEvent.SpawnReason.CUSTOM && spawnReason2 != CreatureSpawnEvent.SpawnReason.SPAWNER_EGG || lmEntity.isLevelled())) {
                if (main.getRulesManager().isPlayerLevellingEnabled() && lmEntity.getPlayerForLevelling() == null) {
                    Companion.updateMobForPlayerLevelling(lmEntity);
                }
                this.delayedAddToQueue(lmEntity, (Event)event, 20);
                lmEntity.free();
                return;
            }
        } else if (event instanceof SpawnerSpawnEvent) {
            lmEntity.setSpawnReason(LevelledMobSpawnReason.SPAWNER);
        }
        if (!this.processMobSpawns) {
            lmEntity.free();
            return;
        }
        if (main.getRulesManager().isPlayerLevellingEnabled() && lmEntity.getPlayerForLevelling() == null) {
            Companion.updateMobForPlayerLevelling(lmEntity);
        }
        if ((mobProcessDelay = main.getHelperSettings().getInt("mob-process-delay", 0)) > 0) {
            this.delayedAddToQueue(lmEntity, (Event)event, mobProcessDelay);
        } else {
            main.getMobsQueueManager().addToQueue(new QueueItem(lmEntity, (Event)event));
        }
        lmEntity.free();
    }

    private final void delayedAddToQueue(LivingEntityWrapper lmEntity, Event event, int delay) {
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> EntitySpawnListener.delayedAddToQueue$lambda$0(lmEntity, event));
        lmEntity.getInUseCount().getAndIncrement();
        scheduler.runDelayed(delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void lmSpawnerSpawn(LivingEntityWrapper lmEntity, SpawnerSpawnEvent event) {
        AdditionalLevelInformation[] additionalLevelInformationArray;
        CharSequence charSequence;
        CreatureSpawner cs = event.getSpawner();
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (cs == null) {
            return;
        }
        Particle useParticle = main.getRulesManager().getSpawnerParticle(lmEntity);
        int particleCount = main.getRulesManager().getSpawnerParticleCount(lmEntity);
        if (useParticle != null && particleCount > 0) {
            Location location = cs.getLocation().add(0.5, 1.0, 0.5);
            Intrinsics.checkNotNullExpressionValue(location, "add(...)");
            this.createParticleEffect(location, useParticle, particleCount);
        }
        Integer minLevel = (Integer)cs.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getKeySpawnerMinLevel(), PersistentDataType.INTEGER);
        Integer maxLevel = (Integer)cs.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getKeySpawnerMaxLevel(), PersistentDataType.INTEGER);
        Integer n = minLevel;
        int useMinLevel = n != null ? n : -1;
        Integer n2 = maxLevel;
        int useMaxLevel = n2 != null ? n2 : -1;
        int generatedLevel = main.getLevelInterface().generateLevel(lmEntity, useMinLevel, useMaxLevel);
        String spawnerName = cs.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getKeySpawnerCustomName(), PersistentDataType.STRING) ? (String)cs.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getKeySpawnerCustomName(), PersistentDataType.STRING) : null;
        Object customDropId = null;
        if (cs.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), PersistentDataType.STRING) && !((charSequence = (CharSequence)(customDropId = cs.getPersistentDataContainer().get(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), PersistentDataType.STRING))) == null || charSequence.length() == 0)) {
            AdditionalLevelInformation[] additionalLevelInformationArray2 = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(additionalLevelInformationArray2, "getPersistentDataContainer(...)");
            additionalLevelInformationArray = additionalLevelInformationArray2;
            synchronized (additionalLevelInformationArray) {
                boolean bl = false;
                lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), PersistentDataType.STRING, customDropId);
                Unit unit = Unit.INSTANCE;
            }
        }
        lmEntity.setSourceSpawnerName(spawnerName);
        lmEntity.setSpawnReason(LevelledMobSpawnReason.LM_SPAWNER, true);
        String customDropIdFinal = (String)customDropId;
        DebugManager.Companion.log(DebugType.LM_MOB_SPAWNER, lmEntity, () -> EntitySpawnListener.lmSpawnerSpawn$lambda$2(useMinLevel, useMaxLevel, generatedLevel, customDropIdFinal));
        additionalLevelInformationArray = new AdditionalLevelInformation[]{AdditionalLevelInformation.NOT_APPLICABLE};
        main.getLevelInterface().applyLevelToMob(lmEntity, generatedLevel, false, true, SetsKt.mutableSetOf(additionalLevelInformationArray));
    }

    private final void createParticleEffect(Location location, Particle particle, int count) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        World world2 = world;
        SchedulerWrapper scheduler = new SchedulerWrapper(() -> EntitySpawnListener.createParticleEffect$lambda$3(count, world2, particle, location));
        scheduler.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void preprocessMob(@NotNull LivingEntityWrapper lmEntity, @Nullable Event event) {
        AdditionalLevelInformation[] additionalLevelInformationArray;
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        if (!lmEntity.getReEvaluateLevel() && lmEntity.isLevelled()) {
            return;
        }
        if (!lmEntity.isPopulated()) {
            return;
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        AdditionalLevelInformation additionalInfo = AdditionalLevelInformation.NOT_APPLICABLE;
        lmEntity.setSpawnedTimeOfDay((int)lmEntity.getWorld().getTime());
        if (event instanceof SpawnerSpawnEvent) {
            if (((SpawnerSpawnEvent)event).getSpawner() != null) {
                CreatureSpawner creatureSpawner = ((SpawnerSpawnEvent)event).getSpawner();
                Intrinsics.checkNotNull(creatureSpawner, "null cannot be cast to non-null type org.bukkit.block.CreatureSpawner");
                if (creatureSpawner.getPersistentDataContainer().has(NamespacedKeys.INSTANCE.getKeySpawner(), PersistentDataType.INTEGER)) {
                    lmEntity.setSpawnReason(LevelledMobSpawnReason.LM_SPAWNER);
                    this.lmSpawnerSpawn(lmEntity, (SpawnerSpawnEvent)event);
                    return;
                }
            }
            DebugManager.Companion.log(DebugType.LM_MOB_SPAWNER, lmEntity, EntitySpawnListener::preprocessMob$lambda$4);
        } else if (event instanceof CreatureSpawnEvent) {
            if (((CreatureSpawnEvent)event).getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER || ((CreatureSpawnEvent)event).getSpawnReason() == CreatureSpawnEvent.SpawnReason.SLIME_SPLIT) {
                return;
            }
            if (((CreatureSpawnEvent)event).getSpawnReason() == CreatureSpawnEvent.SpawnReason.CUSTOM || ((CreatureSpawnEvent)event).getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) {
                additionalLevelInformationArray = LevelManager.Companion.getSummonedOrSpawnEggs_Lock();
                synchronized (additionalLevelInformationArray) {
                    boolean bl = false;
                    if (main.getLevelManager().getSummonedOrSpawnEggs().containsKey(lmEntity.getLivingEntity())) {
                        return;
                    }
                    Unit $i$a$-synchronized-EntitySpawnListener$preprocessMob$4 = Unit.INSTANCE;
                }
            }
            if (!lmEntity.getReEvaluateLevel()) {
                CreatureSpawnEvent.SpawnReason spawnReason = ((CreatureSpawnEvent)event).getSpawnReason();
                Intrinsics.checkNotNullExpressionValue(spawnReason, "getSpawnReason(...)");
                lmEntity.setSpawnReason(Utils.INSTANCE.adaptVanillaSpawnReason(spawnReason));
            }
        } else if (event instanceof ChunkLoadEvent) {
            additionalInfo = AdditionalLevelInformation.FROM_CHUNK_LISTENER;
        }
        if (lmEntity.getReEvaluateLevel() && main.getRulesManager().isPlayerLevellingEnabled() && lmEntity.isRulesForceAll()) {
            AdditionalLevelInformation[] additionalLevelInformationArray2 = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(additionalLevelInformationArray2, "getPersistentDataContainer(...)");
            additionalLevelInformationArray = additionalLevelInformationArray2;
            synchronized (additionalLevelInformationArray) {
                boolean $i$a$-synchronized-EntitySpawnListener$preprocessMob$52 = false;
                if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getPlayerLevellingId(), PersistentDataType.STRING)) {
                    lmEntity.getPdc().remove(NamespacedKeys.INSTANCE.getPlayerLevellingId());
                }
                Unit $i$a$-synchronized-EntitySpawnListener$preprocessMob$52 = Unit.INSTANCE;
            }
        }
        additionalLevelInformationArray = new AdditionalLevelInformation[]{additionalInfo};
        Set<AdditionalLevelInformation> additionalLevelInfo = SetsKt.mutableSetOf(additionalLevelInformationArray);
        LevellableState levellableState = this.getLevellableState(lmEntity, event);
        if (levellableState == LevellableState.ALLOWED) {
            int levelAssignment = main.getLevelInterface().generateLevel(lmEntity);
            if (this.shouldDenyLevel(lmEntity, levelAssignment)) {
                DebugManager.Companion.log(DebugType.PLAYER_LEVELLING, lmEntity, () -> EntitySpawnListener.preprocessMob$lambda$7(lmEntity, levelAssignment));
            } else {
                SchedulerWrapper scheduler;
                if (lmEntity.getReEvaluateLevel() && main.getRulesManager().isPlayerLevellingEnabled()) {
                    scheduler = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> EntitySpawnListener.preprocessMob$lambda$8(lmEntity));
                    scheduler.setRunDirectlyInBukkit(true);
                    lmEntity.getInUseCount().getAndIncrement();
                    scheduler.run();
                }
                scheduler = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> EntitySpawnListener.preprocessMob$lambda$9(main, lmEntity, levelAssignment, additionalLevelInfo));
                scheduler.setRunDirectlyInBukkit(true);
                lmEntity.getInUseCount().getAndIncrement();
                scheduler.run();
            }
        } else {
            DebugManager.Companion.log(DebugType.APPLY_LEVEL_RESULT, lmEntity, false, () -> EntitySpawnListener.preprocessMob$lambda$10(lmEntity, levellableState));
            if (lmEntity.isLevelled()) {
                main.getLevelInterface().removeLevel(lmEntity);
            } else if (lmEntity.isBabyMob()) {
                PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
                Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
                PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
                synchronized (persistentDataContainer2) {
                    boolean bl = false;
                    lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getWasBabyMobKey(), PersistentDataType.INTEGER, (Object)1);
                    Unit unit = Unit.INSTANCE;
                }
            }
            if (lmEntity.getWasPreviouslyLevelled()) {
                main.getLevelManager().updateNametag(lmEntity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final boolean shouldDenyLevel(LivingEntityWrapper lmEntity, int levelAssignment) {
        result = false;
        if (!lmEntity.getReEvaluateLevel() || lmEntity.isRulesForceAll() || lmEntity.getPlayerLevellingAllowDecrease() == null) ** GOTO lbl-1000
        v0 = lmEntity.getPlayerLevellingAllowDecrease();
        Intrinsics.checkNotNull(v0);
        if (!v0.booleanValue() && lmEntity.isLevelled() && levelAssignment < lmEntity.getGetMobLevel()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = result = false;
        }
        if (result) {
            v2 = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(v2, "getPersistentDataContainer(...)");
            var4_4 = v2;
            synchronized (var4_4) {
                $i$a$-synchronized-EntitySpawnListener$shouldDenyLevel$1 = false;
                result = lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getPlayerLevellingId(), PersistentDataType.STRING);
                $i$a$-synchronized-EntitySpawnListener$shouldDenyLevel$1 = Unit.INSTANCE;
            }
        }
        if (!result && lmEntity.getPendingPlayerIdToSet() != null) {
            v3 = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(v3, "getPersistentDataContainer(...)");
            var4_4 = v3;
            synchronized (var4_4) {
                $i$a$-synchronized-EntitySpawnListener$shouldDenyLevel$2 = false;
                v4 = lmEntity.getPdc();
                v5 = NamespacedKeys.INSTANCE.getPlayerLevellingId();
                v6 = lmEntity.getPendingPlayerIdToSet();
                Intrinsics.checkNotNull(v6);
                v4.set(v5, PersistentDataType.STRING, (Object)v6);
                var5_9 = Unit.INSTANCE;
            }
        }
        return result;
    }

    private final LevellableState getLevellableState(LivingEntityWrapper lmEntity, Event event) {
        LevellableState levellableState = LevelledMobs.Companion.getInstance().getLevelInterface().getLevellableState(lmEntity);
        if (levellableState != LevellableState.ALLOWED) {
            return levellableState;
        }
        if (event instanceof CreatureSpawnEvent) {
            if (((CreatureSpawnEvent)event).getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
                return LevellableState.DENIED_OTHER;
            }
            DebugManager.Companion.log(DebugType.ENTITY_SPAWN, lmEntity, () -> EntitySpawnListener.getLevellableState$lambda$14(event));
        } else if (event instanceof EntitySpawnEvent) {
            DebugManager.Companion.log(DebugType.ENTITY_SPAWN, lmEntity, () -> EntitySpawnListener.getLevellableState$lambda$15(event));
        }
        return LevellableState.ALLOWED;
    }

    private static final void delayedAddToQueue$lambda$0(LivingEntityWrapper $lmEntity, Event $event) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($event, "$event");
        LevelledMobs.Companion.getInstance().getMobsQueueManager().addToQueue(new QueueItem($lmEntity, $event));
        $lmEntity.free();
    }

    private static final String lmSpawnerSpawn$lambda$2(int $useMinLevel, int $useMaxLevel, int $generatedLevel, String $customDropIdFinal) {
        String string = "Spawned mob from LM spawner: minLevel:&b %s&7, maxLevel: &b%s&7, generatedLevel: &b%s&b%s";
        Object[] objectArray = new Object[4];
        objectArray[0] = $useMinLevel;
        objectArray[1] = $useMaxLevel;
        objectArray[2] = $generatedLevel;
        String string2 = $customDropIdFinal;
        objectArray[3] = string2 == null ? "" : ", dropid: " + string2;
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        return string3;
    }

    private static final void createParticleEffect$lambda$3(int $count, World $world, Particle $particle, Location $location) {
        Intrinsics.checkNotNullParameter($world, "$world");
        Intrinsics.checkNotNullParameter($particle, "$particle");
        Intrinsics.checkNotNullParameter($location, "$location");
        try {
            for (int i = 0; i < $count; ++i) {
                $world.spawnParticle($particle, $location, 20, 0.0, 0.0, 0.0, 0.1);
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static final String preprocessMob$lambda$4() {
        return "Spawned mob from vanilla spawner";
    }

    private static final String preprocessMob$lambda$7(LivingEntityWrapper $lmEntity, int $levelAssignment) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        return "lvl: " + $lmEntity.getGetMobLevel() + "&r, denied relevelling to &b" + $levelAssignment + "&r due to decrease-level disabled";
    }

    private static final void preprocessMob$lambda$8(LivingEntityWrapper $lmEntity) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Companion.updateMobForPlayerLevelling($lmEntity);
        $lmEntity.free();
    }

    private static final void preprocessMob$lambda$9(LevelledMobs $main, LivingEntityWrapper $lmEntity, int $levelAssignment, Set $additionalLevelInfo) {
        Intrinsics.checkNotNullParameter((Object)$main, "$main");
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($additionalLevelInfo, "$additionalLevelInfo");
        $main.getLevelInterface().applyLevelToMob($lmEntity, $levelAssignment, false, false, $additionalLevelInfo);
        $lmEntity.free();
    }

    private static final String preprocessMob$lambda$10(LivingEntityWrapper $lmEntity, LevellableState $levellableState) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter((Object)$levellableState, "$levellableState");
        return "world: &b" + $lmEntity.getWorldName() + "&7 was not levelled -> levellable state: &b" + $levellableState;
    }

    private static final String getLevellableState$lambda$14(Event $event) {
        return "instanceof CreatureSpawnListener: &b" + ((CreatureSpawnEvent)$event).getEntityType() + "&7, with spawnReason &b" + ((CreatureSpawnEvent)$event).getSpawnReason() + "&7.";
    }

    private static final String getLevellableState$lambda$15(Event $event) {
        return "not instanceof CreatureSpawnListener: &b" + ((EntitySpawnEvent)$event).getEntityType();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener$Companion;", "", "<init>", "()V", "updateMobForPlayerLevelling", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "updateMobForPlayerLevellingNonAsync", "checkDistance", "", "onlinePlayerCount", "getPlayersOnServerNearMob", "", "Lorg/bukkit/entity/Player;", "mob", "Lorg/bukkit/entity/LivingEntity;", "getPlayersNearMob", "levelledmobs-plugin"})
    @SourceDebugExtension(value={"SMAP\nEntitySpawnListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntitySpawnListener.kt\nio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,493:1\n477#2:494\n607#2:495\n*S KotlinDebug\n*F\n+ 1 EntitySpawnListener.kt\nio/github/arcaneplugins/levelledmobs/listeners/EntitySpawnListener$Companion\n*L\n480#1:494\n483#1:495\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void updateMobForPlayerLevelling(@NotNull LivingEntityWrapper lmEntity) {
            Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
            int onlinePlayerCount = lmEntity.getWorld().getPlayers().size();
            int checkDistance = LevelledMobs.Companion.getInstance().getHelperSettings().getInt("async-task-max-blocks-from-player", 100);
            if (!LevelledMobs.Companion.getInstance().getVer().isRunningFolia() && Bukkit.isPrimaryThread()) {
                this.updateMobForPlayerLevellingNonAsync(lmEntity, checkDistance, onlinePlayerCount);
                return;
            }
            SchedulerWrapper wrapper = new SchedulerWrapper((Entity)lmEntity.getLivingEntity(), () -> Companion.updateMobForPlayerLevelling$lambda$0(lmEntity, checkDistance, onlinePlayerCount));
            lmEntity.getInUseCount().getAndIncrement();
            wrapper.run();
        }

        private final void updateMobForPlayerLevellingNonAsync(LivingEntityWrapper lmEntity, int checkDistance, int onlinePlayerCount) {
            LevelledMobs main = LevelledMobs.Companion.getInstance();
            List<Player> playerList = onlinePlayerCount <= 10 ? this.getPlayersOnServerNearMob(lmEntity.getLivingEntity(), checkDistance) : this.getPlayersNearMob(lmEntity.getLivingEntity(), checkDistance);
            Player closestPlayer = null;
            for (Player player : playerList) {
                if (ExternalCompatibilityManager.Companion.isMobOfCitizens((LivingEntity)player)) continue;
                closestPlayer = player;
                break;
            }
            if (closestPlayer == null) {
                return;
            }
            Instant logonTime = main.getMainCompanion().getRecentlyJoinedPlayerLogonTime(closestPlayer);
            if (logonTime != null) {
                if (Utils.INSTANCE.getMillisecondsFromInstant(logonTime) < 5000L) {
                    return;
                }
                main.getMainCompanion().removeRecentlyJoinedPlayer(closestPlayer);
            }
            lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getPlayerLevellingId(), PersistentDataType.STRING, (Object)closestPlayer.getUniqueId().toString());
            lmEntity.setPlayerForLevelling(closestPlayer);
            List<NametagVisibilityEnum> nametagVisibilityEnums = main.getRulesManager().getRuleCreatureNametagVisbility(lmEntity);
            if (nametagVisibilityEnums.contains((Object)NametagVisibilityEnum.TARGETED) && lmEntity.getLivingEntity().hasLineOfSight((Entity)closestPlayer)) {
                main.getLevelManager().updateNametag(lmEntity);
            }
        }

        private final List<Player> getPlayersOnServerNearMob(LivingEntity mob, int checkDistance) {
            List list = mob.getWorld().getPlayers();
            Intrinsics.checkNotNullExpressionValue(list, "getPlayers(...)");
            return Utils.INSTANCE.filterPlayersList(list, mob, Double.valueOf(checkDistance * 4));
        }

        /*
         * WARNING - void declaration
         */
        private final List<Player> getPlayersNearMob(LivingEntity mob, int checkDistance) {
            void $this$sortedBy$iv;
            Sequence<Pair> $this$filterIsInstance$iv;
            List list = mob.getNearbyEntities((double)checkDistance, (double)checkDistance, (double)checkDistance);
            Intrinsics.checkNotNullExpressionValue(list, "getNearbyEntities(...)");
            Sequence sequence = CollectionsKt.asSequence(list);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, Companion$getPlayersNearMob$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = SequencesKt.map(SequencesKt.filter(sequence2, Companion::getPlayersNearMob$lambda$1), arg_0 -> Companion.getPlayersNearMob$lambda$2(mob, arg_0));
            boolean $i$f$sortedBy = false;
            Sequence<Player> temp = SequencesKt.map(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getFirst();
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Double)it.getFirst()));
                }
            }), Companion::getPlayersNearMob$lambda$4);
            if (MainCompanion.Companion.getInstance().getExcludePlayersInCreative()) {
                temp = SequencesKt.filter(temp, Companion::getPlayersNearMob$lambda$5);
            }
            return SequencesKt.toMutableList(temp);
        }

        private static final void updateMobForPlayerLevelling$lambda$0(LivingEntityWrapper $lmEntity, int $checkDistance, int $onlinePlayerCount) {
            Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
            Companion.updateMobForPlayerLevellingNonAsync($lmEntity, $checkDistance, $onlinePlayerCount);
            $lmEntity.free();
        }

        private static final boolean getPlayersNearMob$lambda$1(Entity e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return ((Player)e).getGameMode() != GameMode.SPECTATOR;
        }

        private static final Pair getPlayersNearMob$lambda$2(LivingEntity $mob, Entity e) {
            Intrinsics.checkNotNullParameter($mob, "$mob");
            Intrinsics.checkNotNullParameter(e, "e");
            return new Pair<Double, Player>($mob.getLocation().distanceSquared(e.getLocation()), (Player)e);
        }

        private static final Player getPlayersNearMob$lambda$4(Pair it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return (Player)it.getSecond();
        }

        private static final boolean getPlayersNearMob$lambda$5(Entity e) {
            Intrinsics.checkNotNullParameter(e, "e");
            return ((Player)e).getGameMode() != GameMode.CREATIVE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

