/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.NametagTimerChecker;
import io.github.arcaneplugins.levelledmobs.result.AdjacentChunksResult;
import io.github.arcaneplugins.levelledmobs.result.ChunkKillInfo;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Chunk;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntityDeathListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "damageMappings", "", "Ljava/util/UUID;", "Lorg/bukkit/entity/Player;", "getDamageMappings", "()Ljava/util/Map;", "bypassEntity", "", "Lorg/bukkit/entity/EntityType;", "onDeath", "", "event", "Lorg/bukkit/event/entity/EntityDeathEvent;", "hasReachedEntityDeathChunkMax", "", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "player", "getNumberOfEntityDeathsInAdjacentChunks", "Lio/github/arcaneplugins/levelledmobs/result/AdjacentChunksResult;", "levelledmobs-plugin"})
public final class EntityDeathListener
implements Listener {
    @NotNull
    private final Map<UUID, Player> damageMappings = new LinkedHashMap();
    @NotNull
    private final List<EntityType> bypassEntity;

    public EntityDeathListener() {
        EntityType[] entityTypeArray = new EntityType[]{EntityType.ARMOR_STAND, EntityType.ITEM_FRAME, EntityType.DROPPED_ITEM, EntityType.PAINTING};
        this.bypassEntity = CollectionsKt.mutableListOf(entityTypeArray);
    }

    @NotNull
    public final Map<UUID, Player> getDamageMappings() {
        return this.damageMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public final void onDeath(@NotNull EntityDeathEvent event) {
        block23: {
            Intrinsics.checkNotNullParameter(event, "event");
            damagingPlayer = null;
            if (this.damageMappings.containsKey(event.getEntity().getUniqueId())) {
                damagingPlayer = this.damageMappings.get(event.getEntity().getUniqueId());
                this.damageMappings.remove(event.getEntity().getUniqueId());
            }
            if (event.getEntity() instanceof Player) {
                return;
            }
            if (this.bypassEntity.contains(event.getEntityType())) {
                return;
            }
            main = LevelledMobs.Companion.getInstance();
            v0 = damagingPlayer;
            if (v0 == null) {
                v0 = event.getEntity().getKiller();
            }
            killer = v0;
            var6_5 = NametagTimerChecker.Companion.getEntityTarget_Lock();
            synchronized (var6_5) {
                $i$a$-synchronized-EntityDeathListener$onDeath$1 = false;
                $i$a$-synchronized-EntityDeathListener$onDeath$1 = main.getNametagTimerChecker().getEntityTargetMap().remove(event.getEntity());
            }
            v1 = event.getEntity();
            Intrinsics.checkNotNullExpressionValue(v1, "getEntity(...)");
            lmEntity = LivingEntityWrapper.Companion.getInstance(v1);
            lmEntity.setAssociatedPlayer(killer);
            damage = lmEntity.getLivingEntity().getLastDamageCause();
            if (damage != null) {
                lmEntity.setDeathCause(damage.getCause());
            }
            if (killer != null && main.getPlaceholderApiIntegration() != null) {
                v2 = main.getPlaceholderApiIntegration();
                Intrinsics.checkNotNull((Object)v2);
                v2.putPlayerOrMobDeath(killer, lmEntity, false);
            }
            doNotMultiplyDrops = false;
            doNotBoostXp = false;
            disableXpDrops = false;
            if (lmEntity.isLevelled() && killer != null && main.getRulesManager().getMaximumDeathInChunkThreshold(lmEntity) > 0 && this.hasReachedEntityDeathChunkMax(lmEntity, killer)) {
                v3 = main.getRulesManager().getRuleUseCustomDropsForMob(lmEntity).getChunkKillOptions();
                Intrinsics.checkNotNull(v3);
                opts = v3;
                if (opts.getDisableVanillaDrops()) {
                    event.getDrops().clear();
                    disableXpDrops = true;
                }
                if (opts.getDisableItemBoost()) {
                    doNotMultiplyDrops = true;
                }
                if (opts.getDisableXpDrops()) {
                    doNotBoostXp = true;
                }
            }
            if (!lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLockSettings(), PersistentDataType.INTEGER) || !lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLockedDropRules(), PersistentDataType.STRING)) break block23;
            lockedDropRules = (String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getLockedDropRules(), PersistentDataType.STRING);
            if (lockedDropRules != null) {
                var11_14 = new String[]{";"};
                lmEntity.setLockedCustomDrops(CollectionsKt.toMutableList(StringsKt.split$default((CharSequence)lockedDropRules, var11_14, false, 0, 6, null)));
            }
            if (!lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getLockedDropRulesOverride(), PersistentDataType.INTEGER)) break block23;
            lockedOverride = (Integer)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getLockedDropRulesOverride(), PersistentDataType.INTEGER);
            if (lockedOverride == null) ** GOTO lbl-1000
            var12_15 = 1;
            if (lockedOverride == var12_15) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            lmEntity.setHasLockedDropsOverride(v4);
        }
        if (lmEntity.isLevelled()) {
            MobDataManager.Companion.populateAttributeCache$default(MobDataManager.Companion, lmEntity, null, 2, null);
            v5 = main.getLevelManager();
            v6 = event.getDrops();
            Intrinsics.checkNotNullExpressionValue(v6, "getDrops(...)");
            v5.setLevelledItemDrops(lmEntity, v6, doNotMultiplyDrops);
            if (disableXpDrops) {
                event.setDroppedExp(0);
            } else if (!doNotBoostXp && event.getDroppedExp() > 0) {
                event.setDroppedExp(main.getLevelManager().getLevelledExpDrops(lmEntity, event.getDroppedExp()));
            }
        } else if (lmEntity.getLockedCustomDrops() != null || main.getRulesManager().getRuleUseCustomDropsForMob(lmEntity).getUseDrops()) {
            drops = new ArrayList<E>();
            result = main.getCustomDropsHandler().getCustomItemDrops(lmEntity, drops, false);
            if (result.getHasOverride()) {
                v7 = main.getLevelManager();
                v8 = event.getDrops();
                Intrinsics.checkNotNullExpressionValue(v8, "getDrops(...)");
                v7.removeVanillaDrops(lmEntity, v8);
            }
            event.getDrops().addAll(drops);
        }
        lmEntity.free();
    }

    private final boolean hasReachedEntityDeathChunkMax(LivingEntityWrapper lmEntity, Player player) {
        int n;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Chunk chunk = lmEntity.getLocation().getChunk();
        Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
        long chunkKey = Utils.INSTANCE.getChunkKey(chunk);
        Map<EntityType, ChunkKillInfo> pairList = main.getMainCompanion().getorAddPairForSpecifiedChunk(chunkKey);
        if (pairList.containsKey(lmEntity.getEntityType())) {
            ChunkKillInfo chunkKillInfo = pairList.get(lmEntity.getEntityType());
            Intrinsics.checkNotNull(chunkKillInfo);
            n = chunkKillInfo.getCount();
        } else {
            n = 0;
        }
        int numberOfEntityDeathInChunk = n;
        AdjacentChunksResult adjacentChunksResult = this.getNumberOfEntityDeathsInAdjacentChunks(lmEntity);
        if (adjacentChunksResult != null) {
            numberOfEntityDeathInChunk += adjacentChunksResult.getEntities();
            adjacentChunksResult.getChunkKeys().add(chunkKey);
        }
        lmEntity.setChunkKillcount(numberOfEntityDeathInChunk);
        int maximumDeathInChunkThreshold = main.getRulesManager().getMaximumDeathInChunkThreshold(lmEntity);
        int maxCooldownTime = main.getRulesManager().getMaxChunkCooldownTime(lmEntity);
        if (numberOfEntityDeathInChunk < maximumDeathInChunkThreshold) {
            ChunkKillInfo chunkKillInfo = pairList.computeIfAbsent(lmEntity.getEntityType(), arg_0 -> EntityDeathListener.hasReachedEntityDeathChunkMax$lambda$2(EntityDeathListener::hasReachedEntityDeathChunkMax$lambda$1, arg_0));
            Intrinsics.checkNotNullExpressionValue(chunkKillInfo, "computeIfAbsent(...)");
            ChunkKillInfo chunkKillInfo2 = chunkKillInfo;
            Integer n2 = maxCooldownTime;
            chunkKillInfo2.getEntityCounts().put(Instant.now(), n2);
            return false;
        }
        if (main.getHelperSettings().getBoolean("exceed-kill-in-chunk-message", true)) {
            Object object = adjacentChunksResult;
            if (object == null || (object = ((AdjacentChunksResult)object).getChunkKeys()) == null) {
                Long[] longArray = new Long[]{chunkKey};
                object = CollectionsKt.mutableListOf(longArray);
            }
            List<Long> chunkKeys = object;
            MainCompanion mainCompanion = main.getMainCompanion();
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            if (mainCompanion.doesUserHaveCooldown(chunkKeys, uUID)) {
                return true;
            }
            DebugManager.Companion.log(DebugType.CHUNK_KILL_COUNT, lmEntity, () -> EntityDeathListener.hasReachedEntityDeathChunkMax$lambda$3(lmEntity, player, maximumDeathInChunkThreshold));
            String prefix = main.getConfigUtils().getPrefix();
            String msg = main.getMessagesCfg().getString("other.no-drop-in-chunk");
            if (msg != null) {
                player.sendMessage(MessageUtils.INSTANCE.colorizeAll(StringsKt.replace$default(msg, "%prefix%", prefix, false, 4, null)));
            }
            MainCompanion mainCompanion2 = main.getMainCompanion();
            UUID uUID2 = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            mainCompanion2.addUserCooldown(chunkKeys, uUID2);
        }
        return true;
    }

    private final AdjacentChunksResult getNumberOfEntityDeathsInAdjacentChunks(LivingEntityWrapper lmEntity) {
        int adjacentChunksToCheck = LevelledMobs.Companion.getInstance().getRulesManager().getAdjacentChunksToCheck(lmEntity);
        if (adjacentChunksToCheck <= 0) {
            return null;
        }
        Chunk chunk = lmEntity.getLocation().getChunk();
        Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
        Chunk startingChunk = chunk;
        AdjacentChunksResult result = new AdjacentChunksResult();
        for (int x = -adjacentChunksToCheck; x < adjacentChunksToCheck; ++x) {
            for (int z = -adjacentChunksToCheck; z < adjacentChunksToCheck; ++z) {
                Chunk chunk2;
                if (x == 0 && z == 0) continue;
                Intrinsics.checkNotNullExpressionValue(lmEntity.getWorld().getChunkAt(startingChunk.getX() + x, startingChunk.getZ() + z), "getChunkAt(...)");
                if (!chunk2.isLoaded()) continue;
                result.getChunkKeys().add(Utils.INSTANCE.getChunkKey(chunk2));
            }
        }
        List<Map<EntityType, ChunkKillInfo>> pairLists = MainCompanion.Companion.getInstance().getorAddPairForSpecifiedChunks(result.getChunkKeys());
        for (Map<EntityType, ChunkKillInfo> pairList : pairLists) {
            int n;
            int n2 = result.getEntities();
            if (pairList.containsKey(lmEntity.getEntityType())) {
                ChunkKillInfo chunkKillInfo = pairList.get(lmEntity.getEntityType());
                Intrinsics.checkNotNull(chunkKillInfo);
                n = chunkKillInfo.getCount();
            } else {
                n = 0;
            }
            result.setEntities(n2 + n);
        }
        return result;
    }

    private static final ChunkKillInfo hasReachedEntityDeathChunkMax$lambda$1(EntityType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ChunkKillInfo();
    }

    private static final ChunkKillInfo hasReachedEntityDeathChunkMax$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (ChunkKillInfo)$tmp0.invoke(p0);
    }

    private static final String hasReachedEntityDeathChunkMax$lambda$3(LivingEntityWrapper $lmEntity, Player $player, int $maximumDeathInChunkThreshold) {
        Intrinsics.checkNotNullParameter($lmEntity, "$lmEntity");
        Intrinsics.checkNotNullParameter($player, "$player");
        String string = "%s: player: %s, reached chunk kill limit, max: %s";
        Object[] objectArray = new Object[]{Utils.INSTANCE.displayChunkLocation($lmEntity.getLocation()), $player.getName(), $maximumDeathInChunkThreshold};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }
}

