/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.Addition;
import io.github.arcaneplugins.levelledmobs.enums.NametagVisibilityEnum;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wither;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.projectiles.ProjectileSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/EntityDamageListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onEntityDamageEvent", "", "event", "Lorg/bukkit/event/entity/EntityDamageEvent;", "onEntityDamageByEntityEvent", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "processRangedDamage", "processRangedDamage2", "shooter", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "processOtherRangedDamage", "levelledmobs-plugin"})
public final class EntityDamageListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onEntityDamageEvent(@NotNull EntityDamageEvent event) {
        boolean isCritical;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        boolean bl = isCritical = event.getFinalDamage() == 0.0;
        if (event instanceof EntityDamageByEntityEvent && isCritical && ((EntityDamageByEntityEvent)event).getDamager() instanceof Player) {
            Map<UUID, Player> map = LevelledMobs.Companion.getInstance().getEntityDeathListener().getDamageMappings();
            UUID uUID = event.getEntity().getUniqueId();
            Entity entity = ((EntityDamageByEntityEvent)event).getDamager();
            Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.Player");
            Player player = (Player)entity;
            map.put(uUID, player);
            return;
        }
        if (isCritical) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            if (!(event instanceof EntityDamageByEntityEvent)) {
                return;
            }
            if (!(((EntityDamageByEntityEvent)event).getDamager() instanceof LivingEntity) || ((EntityDamageByEntityEvent)event).getDamager() instanceof Player) {
                return;
            }
            Entity entity = ((EntityDamageByEntityEvent)event).getDamager();
            Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
            LivingEntityWrapper theHitter = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
            List<NametagVisibilityEnum> nametagVisibilityEnums = LevelledMobs.Companion.getInstance().getRulesManager().getRuleCreatureNametagVisbility(theHitter);
            long nametagVisibleTime = theHitter.getNametagCooldownTime();
            if (nametagVisibleTime > 0L && nametagVisibilityEnums.contains((Object)NametagVisibilityEnum.ATTACKED)) {
                if (theHitter.getPlayersNeedingNametagCooldownUpdate() == null) {
                    theHitter.setPlayersNeedingNametagCooldownUpdate(new HashSet());
                }
                Set<Player> set = theHitter.getPlayersNeedingNametagCooldownUpdate();
                Intrinsics.checkNotNull(set);
                Entity entity2 = event.getEntity();
                Intrinsics.checkNotNull(entity2, "null cannot be cast to non-null type org.bukkit.entity.Player");
                set.add((Player)entity2);
                LevelledMobs.Companion.getInstance().getLevelManager().updateNametagWithDelay(theHitter);
            }
            theHitter.free();
            return;
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
        if (!lmEntity.isLevelled()) {
            if (lmEntity.getMain().getLevelManager().getEntitySpawnListener().getProcessMobSpawns()) {
                lmEntity.free();
                return;
            }
            if (lmEntity.getGetMobLevel() < 0) {
                lmEntity.setReEvaluateLevel(true);
            }
        }
        boolean wasDamagedByEntity = false;
        if (event instanceof EntityDamageByEntityEvent) {
            wasDamagedByEntity = true;
            if (((EntityDamageByEntityEvent)event).getDamager() instanceof Player) {
                Entity entity3 = ((EntityDamageByEntityEvent)event).getDamager();
                Intrinsics.checkNotNull(entity3, "null cannot be cast to non-null type org.bukkit.entity.Player");
                lmEntity.setAssociatedPlayer((Player)entity3);
            }
        }
        List<NametagVisibilityEnum> nametagVisibilityEnums = lmEntity.getMain().getRulesManager().getRuleCreatureNametagVisbility(lmEntity);
        long nametagVisibleTime = lmEntity.getNametagCooldownTime();
        if (nametagVisibleTime > 0L && wasDamagedByEntity && nametagVisibilityEnums.contains((Object)NametagVisibilityEnum.ATTACKED) && lmEntity.getAssociatedPlayer() != null) {
            if (lmEntity.getPlayersNeedingNametagCooldownUpdate() == null) {
                lmEntity.setPlayersNeedingNametagCooldownUpdate(new HashSet());
            }
            Set<Player> set = lmEntity.getPlayersNeedingNametagCooldownUpdate();
            Intrinsics.checkNotNull(set);
            Player player = lmEntity.getAssociatedPlayer();
            Intrinsics.checkNotNull(player);
            set.add(player);
        }
        lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getLastDamageTime(), PersistentDataType.LONG, (Object)Instant.now().toEpochMilli());
        lmEntity.getMain().getLevelManager().updateNametagWithDelay(lmEntity);
        lmEntity.free();
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public final void onEntityDamageByEntityEvent(@NotNull EntityDamageByEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getFinalDamage() == 0.0) {
            return;
        }
        this.processRangedDamage(event);
        this.processOtherRangedDamage(event);
    }

    private final void processRangedDamage(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() == EntityType.AREA_EFFECT_CLOUD) {
            Entity entity = event.getDamager();
            Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.AreaEffectCloud");
            AreaEffectCloud aec = (AreaEffectCloud)entity;
            if (!(aec.getSource() instanceof EnderDragon)) {
                return;
            }
            ProjectileSource projectileSource = aec.getSource();
            Intrinsics.checkNotNull(projectileSource, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
            LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)projectileSource);
            MobDataManager.Companion.populateAttributeCache$default(MobDataManager.Companion, lmEntity, null, 2, null);
            this.processRangedDamage2(lmEntity, event);
            lmEntity.free();
            return;
        }
        if (!(event.getDamager() instanceof Projectile)) {
            return;
        }
        Entity entity = event.getDamager();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.Projectile");
        Projectile projectile = (Projectile)entity;
        if (projectile.getShooter() == null) {
            return;
        }
        if (projectile.getShooter() instanceof Player && event.getEntity() instanceof LivingEntity) {
            Entity entity2 = event.getEntity();
            Intrinsics.checkNotNull(entity2, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
            LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity2);
            MobDataManager.Companion.populateAttributeCache$default(MobDataManager.Companion, lmEntity, null, 2, null);
            if (lmEntity.isLevelled() && lmEntity.getMain().getRulesManager().getRuleCreatureNametagVisbility(lmEntity).contains((Object)NametagVisibilityEnum.ATTACKED)) {
                if (lmEntity.getPlayersNeedingNametagCooldownUpdate() == null) {
                    lmEntity.setPlayersNeedingNametagCooldownUpdate(new HashSet());
                }
                Set<Player> set = lmEntity.getPlayersNeedingNametagCooldownUpdate();
                Intrinsics.checkNotNull(set);
                ProjectileSource projectileSource = projectile.getShooter();
                Intrinsics.checkNotNull(projectileSource, "null cannot be cast to non-null type org.bukkit.entity.Player");
                set.add((Player)projectileSource);
                lmEntity.getMain().getLevelManager().updateNametagWithDelay(lmEntity);
            }
            lmEntity.free();
            return;
        }
        if (!(projectile.getShooter() instanceof LivingEntity)) {
            return;
        }
        ProjectileSource projectileSource = projectile.getShooter();
        Intrinsics.checkNotNull(projectileSource, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntityWrapper shooter = LivingEntityWrapper.Companion.getInstance((LivingEntity)projectileSource);
        MobDataManager.Companion.populateAttributeCache$default(MobDataManager.Companion, shooter, null, 2, null);
        this.processRangedDamage2(shooter, event);
        shooter.free();
    }

    private final void processRangedDamage2(LivingEntityWrapper shooter, EntityDamageByEntityEvent event) {
        if (!shooter.getLivingEntity().isValid()) {
            return;
        }
        if (!shooter.isLevelled()) {
            if (shooter.getMain().getLevelManager().getEntitySpawnListener().getProcessMobSpawns()) {
                return;
            }
            shooter.getMain().getMobsQueueManager().addToQueue(new QueueItem(shooter, (Event)event));
        }
        shooter.setRangedDamage(Float.valueOf((float)event.getDamage()));
        float newDamage = (float)event.getDamage() + shooter.getMain().getMobDataManager().getAdditionsForLevel(shooter, Addition.CUSTOM_RANGED_ATTACK_DAMAGE, (float)event.getDamage()).getAmount();
        DebugManager.Companion.log(DebugType.RANGED_DAMAGE_MODIFICATION, shooter, () -> EntityDamageListener.processRangedDamage2$lambda$0(shooter, event, newDamage));
        event.setDamage((double)newDamage);
    }

    private final void processOtherRangedDamage(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof LivingEntity)) {
            return;
        }
        Entity entity = event.getDamager();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!(livingEntity instanceof Guardian || livingEntity instanceof Ghast || livingEntity instanceof Wither)) {
            return;
        }
        if (!((Entity)livingEntity).isValid()) {
            return;
        }
        if (!LevelledMobs.Companion.getInstance().getLevelInterface().isLevelled(livingEntity)) {
            return;
        }
        double oldDamage = event.getDamage();
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance(livingEntity);
        event.setDamage((double)lmEntity.getMain().getMobDataManager().getAdditionsForLevel(lmEntity, Addition.CUSTOM_RANGED_ATTACK_DAMAGE, (float)event.getDamage()).getAmount());
        DebugManager.Companion.log(DebugType.RANGED_DAMAGE_MODIFICATION, (Entity)livingEntity, () -> EntityDamageListener.processOtherRangedDamage$lambda$1(oldDamage, event));
        lmEntity.free();
    }

    private static final String processRangedDamage2$lambda$0(LivingEntityWrapper $shooter, EntityDamageByEntityEvent $event, float $newDamage) {
        Intrinsics.checkNotNullParameter($shooter, "$shooter");
        Intrinsics.checkNotNullParameter($event, "$event");
        return "lvl: &b" + $shooter.getGetMobLevel() + "&7, damage: &b" + $event.getDamage() + "&7, new damage: &b" + $newDamage + "&7";
    }

    private static final String processOtherRangedDamage$lambda$1(double $oldDamage, EntityDamageByEntityEvent $event) {
        Intrinsics.checkNotNullParameter($event, "$event");
        return "old damage: &b: " + $oldDamage + "&r, new damage: &b" + $event.getDamage() + "&r";
    }
}

