/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.inventory.EntityEquipment;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/CombustListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onCombust", "", "event", "Lorg/bukkit/event/entity/EntityCombustEvent;", "levelledmobs-plugin"})
public final class CombustListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onCombust(@NotNull EntityCombustEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event instanceof EntityCombustByBlockEvent || event instanceof EntityCombustByEntityEvent) {
            return;
        }
        if (event.getEntity().getWorld().getEnvironment() == World.Environment.NETHER || event.getEntity().getWorld().getEnvironment() == World.Environment.THE_END) {
            return;
        }
        EntityType[] entityTypeArray = new EntityType[]{EntityType.SKELETON, EntityType.ZOMBIE, EntityType.ZOMBIE_VILLAGER, EntityType.STRAY, EntityType.DROWNED, EntityType.PHANTOM};
        List<EntityType> entityTypesCanBurnInSunlight2 = CollectionsKt.mutableListOf(entityTypeArray);
        if (!entityTypesCanBurnInSunlight2.contains(event.getEntity().getType())) {
            return;
        }
        if (event.getEntity() instanceof LivingEntity) {
            Entity entity = event.getEntity();
            Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
            EntityEquipment equipment = ((LivingEntity)entity).getEquipment();
            if (equipment != null && equipment.getHelmet() != null && equipment.getHelmet().getType() != Material.AIR) {
                return;
            }
        }
        Entity entity = event.getEntity();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.LivingEntity");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
        double multiplier = LevelledMobs.Companion.getInstance().getRulesManager().getRuleSunlightBurnIntensity(lmEntity);
        if (multiplier == 0.0) {
            lmEntity.free();
            return;
        }
        double newHealth = lmEntity.getLivingEntity().getHealth() - multiplier;
        if (newHealth < 0.0) {
            newHealth = 0.0;
        }
        if (lmEntity.getLivingEntity().getHealth() <= 0.0) {
            lmEntity.free();
            return;
        }
        lmEntity.getLivingEntity().setHealth(newHealth);
        if (lmEntity.isLevelled()) {
            LevelledMobs.Companion.getInstance().getLevelManager().updateNametag(lmEntity);
        }
        lmEntity.free();
    }
}

