/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.listeners;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.misc.QueueItem;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lio/github/arcaneplugins/levelledmobs/listeners/ChunkLoadListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onChunkLoad", "", "event", "Lorg/bukkit/event/world/ChunkLoadEvent;", "checkEntity", "livingEntity", "Lorg/bukkit/entity/LivingEntity;", "levelledmobs-plugin"})
public final class ChunkLoadListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onChunkLoad(@NotNull ChunkLoadEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!LevelledMobs.Companion.getInstance().getHelperSettings().getBoolean("ensure-mobs-are-levelled-on-chunk-load", true)) {
            return;
        }
        Iterator<Entity> iterator2 = ArrayIteratorKt.iterator(event.getChunk().getEntities());
        while (iterator2.hasNext()) {
            Entity entity;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (!(entity instanceof LivingEntity)) continue;
            this.checkEntity((LivingEntity)entity, event);
        }
    }

    private final void checkEntity(LivingEntity livingEntity, ChunkLoadEvent event) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        SchedulerWrapper wrapper = new SchedulerWrapper((Entity)livingEntity, () -> ChunkLoadListener.checkEntity$lambda$0(livingEntity, main, event));
        wrapper.setRunDirectlyInBukkit(true);
        wrapper.run();
    }

    private static final void checkEntity$lambda$0(LivingEntity $livingEntity, LevelledMobs $main, ChunkLoadEvent $event) {
        Intrinsics.checkNotNullParameter($livingEntity, "$livingEntity");
        Intrinsics.checkNotNullParameter((Object)$main, "$main");
        Intrinsics.checkNotNullParameter($event, "$event");
        LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance($livingEntity);
        if ($main.getLevelManager().getDoCheckMobHash() && Utils.INSTANCE.checkIfMobHashChanged(lmEntity)) {
            lmEntity.setReEvaluateLevel(true);
            lmEntity.setRulesForceAll(true);
            lmEntity.setWasPreviouslyLevelled(lmEntity.isLevelled());
        } else if (lmEntity.isLevelled()) {
            lmEntity.free();
            return;
        }
        $main.getMobsQueueManager().addToQueue(new QueueItem(lmEntity, (Event)$event));
        lmEntity.free();
    }
}

