/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.libs.crunch.functional;

import io.github.arcaneplugins.levelledmobs.libs.crunch.functional.Function;
import io.github.arcaneplugins.levelledmobs.libs.crunch.token.TokenType;
import io.github.arcaneplugins.levelledmobs.libs.crunch.token.Value;

public class FunctionCall
implements Value {
    private final Value[] values;
    private final Function function;
    private final double[] numbers;

    public FunctionCall(Function function, Value[] values2) {
        this.function = function;
        this.values = values2;
        this.numbers = new double[function.getArgCount()];
    }

    @Override
    public TokenType getType() {
        return TokenType.FUNCTION_CALL;
    }

    @Override
    public double getValue(double[] variableValues) {
        for (int i = 0; i < this.values.length; ++i) {
            this.numbers[i] = this.values[i].getValue(variableValues);
        }
        return this.function.call(this.numbers);
    }

    @Override
    public Value getClone() {
        Value[] clone = new Value[this.values.length];
        System.arraycopy(this.values, 0, clone, 0, this.values.length);
        return new FunctionCall(this.function, this.values);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.function.getName()).append('(');
        for (int i = 0; i < this.values.length; ++i) {
            Value arg = this.values[i];
            builder.append(arg.toString());
            if (i == this.values.length - 1) continue;
            builder.append(", ");
        }
        return builder.append(')').toString();
    }
}

