/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.libs.commandapi;

import com.mojang.brigadier.Message;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.IStringTooltip;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.Tooltip;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class StringTooltip
implements IStringTooltip {
    private final String suggestion;
    private final Message tooltip;

    public static StringTooltip ofString(String suggestion, String tooltip) {
        return StringTooltip.ofMessage(suggestion, Tooltip.messageFromString(tooltip));
    }

    public static StringTooltip ofMessage(String suggestion, Message tooltip) {
        return tooltip == null ? StringTooltip.none(suggestion) : new StringTooltip(suggestion, tooltip);
    }

    public static StringTooltip none(String suggestion) {
        return new StringTooltip(suggestion, null);
    }

    public static Collection<StringTooltip> none(String ... suggestions) {
        return StringTooltip.generate(String::toString, (String s, T t) -> StringTooltip.none(s), suggestions);
    }

    public static Collection<StringTooltip> none(Collection<String> suggestions) {
        return StringTooltip.generate(String::toString, (String s, T t) -> StringTooltip.none(s), suggestions);
    }

    public static Collection<StringTooltip> generateStrings(UnaryOperator<String> tooltipGenerator, String ... suggestions) {
        return StringTooltip.generate(tooltipGenerator, StringTooltip::ofString, suggestions);
    }

    public static Collection<StringTooltip> generateStrings(UnaryOperator<String> tooltipGenerator, Collection<String> suggestions) {
        return StringTooltip.generate(tooltipGenerator, StringTooltip::ofString, suggestions);
    }

    public static Collection<StringTooltip> generateMessages(Function<String, Message> tooltipGenerator, String ... suggestions) {
        return StringTooltip.generate(tooltipGenerator, StringTooltip::ofMessage, suggestions);
    }

    public static Collection<StringTooltip> generateMessages(Function<String, Message> tooltipGenerator, Collection<String> suggestions) {
        return StringTooltip.generate(tooltipGenerator, StringTooltip::ofMessage, suggestions);
    }

    protected static <T> Collection<StringTooltip> generate(Function<String, T> tooltipGenerator, BiFunction<String, T, StringTooltip> tooltipWrapper, String ... suggestions) {
        return StringTooltip.generate(tooltipGenerator, tooltipWrapper, Arrays.stream(suggestions));
    }

    protected static <T> Collection<StringTooltip> generate(Function<String, T> tooltipGenerator, BiFunction<String, T, StringTooltip> tooltipWrapper, Collection<String> suggestions) {
        return StringTooltip.generate(tooltipGenerator, tooltipWrapper, suggestions.stream());
    }

    protected static <T> Collection<StringTooltip> generate(Function<String, T> tooltipGenerator, BiFunction<String, T, StringTooltip> tooltipWrapper, Stream<String> suggestions) {
        Function<String, StringTooltip> builder = suggestion -> (StringTooltip)tooltipWrapper.apply((String)suggestion, (Object)tooltipGenerator.apply((String)suggestion));
        return suggestions.map(builder).toList();
    }

    protected StringTooltip(String suggestion, Message tooltip) {
        this.suggestion = suggestion;
        this.tooltip = tooltip;
    }

    @Override
    public String getSuggestion() {
        return this.suggestion;
    }

    @Override
    public Message getTooltip() {
        return this.tooltip;
    }
}

