/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.libs.commandapi;

import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.BukkitTooltip;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.CommandAPI;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.CommandAPIBukkit;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.exceptions.WrapperCommandSyntaxException;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.nms.NMS;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class PaperImplementations {
    private final boolean isPaperPresent;
    private final boolean isFoliaPresent;
    private final NMS<?> nmsInstance;
    private final Class<? extends CommandSender> feedbackForwardingCommandSender;

    public PaperImplementations(boolean isPaperPresent, boolean isFoliaPresent, NMS<?> nmsInstance) {
        this.isPaperPresent = isPaperPresent;
        this.isFoliaPresent = isFoliaPresent;
        this.nmsInstance = nmsInstance;
        Class<?> tempFeedbackForwardingCommandSender = null;
        try {
            tempFeedbackForwardingCommandSender = Class.forName("io.papermc.paper.commands.FeedbackForwardingSender");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.feedbackForwardingCommandSender = tempFeedbackForwardingCommandSender;
    }

    public void registerReloadHandler(Plugin plugin) {
        if (this.isPaperPresent) {
            Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onServerReloadResources(ServerResourcesReloadedEvent event) {
                    CommandAPIBukkit.get().getCommandRegistrationStrategy().preReloadDataPacks();
                    if (!CommandAPIBukkit.getConfiguration().shouldHookPaperReload()) {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            player.updateCommands();
                        }
                        return;
                    }
                    CommandAPI.logNormal("/minecraft:reload detected. Reloading CommandAPI commands!");
                    PaperImplementations.this.nmsInstance.reloadDataPacks();
                }
            }, plugin);
            CommandAPI.logNormal("Hooked into Paper ServerResourcesReloadedEvent");
        } else {
            CommandAPI.logNormal("Did not hook into Paper ServerResourcesReloadedEvent");
        }
    }

    public CommandMap getCommandMap() {
        if (this.isPaperPresent) {
            return Bukkit.getServer().getCommandMap();
        }
        return this.nmsInstance.getSimpleCommandMap();
    }

    public boolean isPaperPresent() {
        return this.isPaperPresent;
    }

    public boolean isFoliaPresent() {
        return this.isFoliaPresent;
    }

    public Class<? extends CommandSender> getFeedbackForwardingCommandSender() {
        return this.feedbackForwardingCommandSender;
    }

    public WrapperCommandSyntaxException getExceptionFromString(String message) {
        if (this.isPaperPresent) {
            TextComponent adventureComponent = LegacyComponentSerializer.legacySection().deserialize(message);
            return new WrapperCommandSyntaxException(new SimpleCommandExceptionType(BukkitTooltip.messageFromAdventureComponent((Component)adventureComponent)).create());
        }
        return new WrapperCommandSyntaxException(new SimpleCommandExceptionType(BukkitTooltip.messageFromBaseComponents(net.md_5.bungee.api.chat.TextComponent.fromLegacyText((String)message))).create());
    }
}

