/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.debug;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.LivingEntityInterface;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.rules.RuleInfo;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerResult;
import io.github.arcaneplugins.levelledmobs.wrappers.SchedulerWrapper;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 p2\u00020\u0001:\u0003pqrB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u00072\u0006\u0010U\u001a\u00020\u0007J\u0006\u0010V\u001a\u00020QJ\b\u0010W\u001a\u00020QH\u0002J\u0010\u0010X\u001a\u00020Q2\u0006\u0010Y\u001a\u00020\u0007H\u0002JE\u0010Z\u001a\u00020Q2\u0006\u0010[\u001a\u00020\u00132\b\u0010\\\u001a\u0004\u0018\u00010]2\b\u0010^\u001a\u0004\u0018\u00010_2\b\u0010`\u001a\u0004\u0018\u00010a2\b\u0010b\u001a\u0004\u0018\u00010\u00072\u0006\u0010c\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010dJ\u0010\u0010e\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010\u001fH\u0002J\u0006\u0010f\u001a\u00020\u001aJ\b\u0010g\u001a\u00020\u0007H\u0002J\u0006\u0010h\u001a\u00020QJ\u000e\u0010i\u001a\u00020\u00072\u0006\u0010[\u001a\u00020\u0013J\b\u0010j\u001a\u00020QH\u0002J\u000e\u0010k\u001a\u00020Q2\u0006\u0010Y\u001a\u00020\u0007J\n\u0010l\u001a\u0004\u0018\u00010\u001aH\u0002J\u000e\u0010m\u001a\u00020Q2\u0006\u0010n\u001a\u00020\u0007J\b\u0010o\u001a\u00020QH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001e\u00106\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010;\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001e\u0010<\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010;\u001a\u0004\b=\u00108\"\u0004\b>\u0010:R\u001e\u0010?\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010;\u001a\u0004\b@\u00108\"\u0004\bA\u0010:R\u001e\u0010B\u001a\u0004\u0018\u00010CX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010H\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001c\u0010I\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR\u001e\u0010N\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\t\u00a8\u0006s"}, d2={"Lio/github/arcaneplugins/levelledmobs/debug/DebugManager;", "", "<init>", "()V", "defaultPlayerDistance", "", "value", "", "isEnabled", "()Z", "isTimerEnabled", "bypassAllFilters", "getBypassAllFilters", "timerEndTime", "Ljava/time/Instant;", "timerTask", "Lio/github/arcaneplugins/levelledmobs/wrappers/SchedulerResult;", "filterDebugTypes", "", "Lio/github/arcaneplugins/levelledmobs/debug/DebugType;", "getFilterDebugTypes", "()Ljava/util/Set;", "filterEntityTypes", "Lorg/bukkit/entity/EntityType;", "getFilterEntityTypes", "filterRuleNames", "", "getFilterRuleNames", "filterPlayerNames", "getFilterPlayerNames", "excludedEntityTypes", "", "getExcludedEntityTypes", "()Ljava/util/List;", "setExcludedEntityTypes", "(Ljava/util/List;)V", "playerThatEnabledDebug", "Lorg/bukkit/entity/Player;", "getPlayerThatEnabledDebug", "()Lorg/bukkit/entity/Player;", "setPlayerThatEnabledDebug", "(Lorg/bukkit/entity/Player;)V", "listenFor", "Lio/github/arcaneplugins/levelledmobs/debug/DebugManager$ListenFor;", "getListenFor", "()Lio/github/arcaneplugins/levelledmobs/debug/DebugManager$ListenFor;", "setListenFor", "(Lio/github/arcaneplugins/levelledmobs/debug/DebugManager$ListenFor;)V", "outputType", "Lio/github/arcaneplugins/levelledmobs/debug/DebugManager$OutputTypes;", "getOutputType", "()Lio/github/arcaneplugins/levelledmobs/debug/DebugManager$OutputTypes;", "setOutputType", "(Lio/github/arcaneplugins/levelledmobs/debug/DebugManager$OutputTypes;)V", "maxPlayerDistance", "getMaxPlayerDistance", "()Ljava/lang/Integer;", "setMaxPlayerDistance", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "minYLevel", "getMinYLevel", "setMinYLevel", "maxYLevel", "getMaxYLevel", "setMaxYLevel", "disableAfter", "", "getDisableAfter", "()Ljava/lang/Long;", "setDisableAfter", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "disableAfterStr", "getDisableAfterStr", "()Ljava/lang/String;", "setDisableAfterStr", "(Ljava/lang/String;)V", "damageDebugOutputIsEnabled", "getDamageDebugOutputIsEnabled", "enableDebug", "", "sender", "Lorg/bukkit/command/CommandSender;", "usetimer", "bypassFilters", "disableDebug", "disableTimer", "checkTimerSettings", "useTimer", "logInstance", "debugType", "ruleInfo", "Lio/github/arcaneplugins/levelledmobs/rules/RuleInfo;", "lmInterface", "Lio/github/arcaneplugins/levelledmobs/LivingEntityInterface;", "entity", "Lorg/bukkit/entity/Entity;", "ruleResult", "origMsg", "(Lio/github/arcaneplugins/levelledmobs/debug/DebugType;Lio/github/arcaneplugins/levelledmobs/rules/RuleInfo;Lio/github/arcaneplugins/levelledmobs/LivingEntityInterface;Lorg/bukkit/entity/Entity;Ljava/lang/Boolean;Ljava/lang/String;)V", "getPlayers", "getDebugStatus", "hasFiltering", "resetFilters", "isDebugTypeEnabled", "timerLoop", "timerWasChanged", "getTimeRemaining", "toggleDamageDebugOutput", "doEnable", "buildExcludedEntityTypes", "Companion", "ListenFor", "OutputTypes", "levelledmobs-plugin"})
public final class DebugManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int defaultPlayerDistance;
    private boolean isEnabled;
    private boolean isTimerEnabled;
    private boolean bypassAllFilters;
    @Nullable
    private Instant timerEndTime;
    @Nullable
    private SchedulerResult timerTask;
    @NotNull
    private final Set<DebugType> filterDebugTypes = new LinkedHashSet();
    @NotNull
    private final Set<EntityType> filterEntityTypes = new LinkedHashSet();
    @NotNull
    private final Set<String> filterRuleNames = new LinkedHashSet();
    @NotNull
    private final Set<String> filterPlayerNames = new LinkedHashSet();
    @NotNull
    private List<String> excludedEntityTypes = new ArrayList();
    @Nullable
    private Player playerThatEnabledDebug;
    @NotNull
    private ListenFor listenFor = ListenFor.BOTH;
    @NotNull
    private OutputTypes outputType = OutputTypes.TO_CONSOLE;
    @Nullable
    private Integer maxPlayerDistance;
    @Nullable
    private Integer minYLevel;
    @Nullable
    private Integer maxYLevel;
    @Nullable
    private Long disableAfter;
    @Nullable
    private String disableAfterStr;
    private boolean damageDebugOutputIsEnabled;
    private static DebugManager instance;
    @NotNull
    private static final Map<UUID, List<Supplier<String>>> longMessagesMap;
    @NotNull
    private static final Object lock;

    public DebugManager() {
        this.defaultPlayerDistance = 16;
        instance = this;
        this.maxPlayerDistance = this.defaultPlayerDistance;
        this.buildExcludedEntityTypes();
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final boolean isTimerEnabled() {
        return this.isTimerEnabled;
    }

    public final boolean getBypassAllFilters() {
        return this.bypassAllFilters;
    }

    @NotNull
    public final Set<DebugType> getFilterDebugTypes() {
        return this.filterDebugTypes;
    }

    @NotNull
    public final Set<EntityType> getFilterEntityTypes() {
        return this.filterEntityTypes;
    }

    @NotNull
    public final Set<String> getFilterRuleNames() {
        return this.filterRuleNames;
    }

    @NotNull
    public final Set<String> getFilterPlayerNames() {
        return this.filterPlayerNames;
    }

    @NotNull
    public final List<String> getExcludedEntityTypes() {
        return this.excludedEntityTypes;
    }

    public final void setExcludedEntityTypes(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.excludedEntityTypes = list;
    }

    @Nullable
    public final Player getPlayerThatEnabledDebug() {
        return this.playerThatEnabledDebug;
    }

    public final void setPlayerThatEnabledDebug(@Nullable Player player) {
        this.playerThatEnabledDebug = player;
    }

    @NotNull
    public final ListenFor getListenFor() {
        return this.listenFor;
    }

    public final void setListenFor(@NotNull ListenFor listenFor) {
        Intrinsics.checkNotNullParameter((Object)listenFor, "<set-?>");
        this.listenFor = listenFor;
    }

    @NotNull
    public final OutputTypes getOutputType() {
        return this.outputType;
    }

    public final void setOutputType(@NotNull OutputTypes outputTypes) {
        Intrinsics.checkNotNullParameter((Object)outputTypes, "<set-?>");
        this.outputType = outputTypes;
    }

    @Nullable
    public final Integer getMaxPlayerDistance() {
        return this.maxPlayerDistance;
    }

    public final void setMaxPlayerDistance(@Nullable Integer n) {
        this.maxPlayerDistance = n;
    }

    @Nullable
    public final Integer getMinYLevel() {
        return this.minYLevel;
    }

    public final void setMinYLevel(@Nullable Integer n) {
        this.minYLevel = n;
    }

    @Nullable
    public final Integer getMaxYLevel() {
        return this.maxYLevel;
    }

    public final void setMaxYLevel(@Nullable Integer n) {
        this.maxYLevel = n;
    }

    @Nullable
    public final Long getDisableAfter() {
        return this.disableAfter;
    }

    public final void setDisableAfter(@Nullable Long l) {
        this.disableAfter = l;
    }

    @Nullable
    public final String getDisableAfterStr() {
        return this.disableAfterStr;
    }

    public final void setDisableAfterStr(@Nullable String string) {
        this.disableAfterStr = string;
    }

    public final boolean getDamageDebugOutputIsEnabled() {
        return this.damageDebugOutputIsEnabled;
    }

    public final void enableDebug(@NotNull CommandSender sender, boolean usetimer, boolean bypassFilters) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        if (sender instanceof Player) {
            this.playerThatEnabledDebug = (Player)sender;
        }
        this.bypassAllFilters = bypassFilters;
        this.isEnabled = true;
        this.checkTimerSettings(usetimer);
    }

    public final void disableDebug() {
        this.isEnabled = false;
        this.isTimerEnabled = false;
        this.toggleDamageDebugOutput(false);
        this.disableTimer();
    }

    private final void disableTimer() {
        this.isTimerEnabled = false;
        if (this.timerTask == null) {
            return;
        }
        SchedulerResult schedulerResult = this.timerTask;
        Intrinsics.checkNotNull(schedulerResult);
        schedulerResult.cancelTask();
        this.timerTask = null;
    }

    /*
     * Unable to fully structure code
     */
    private final void checkTimerSettings(boolean useTimer) {
        if (!this.isEnabled) {
            return;
        }
        if (this.disableAfter == null) ** GOTO lbl-1000
        v0 = this.disableAfter;
        Intrinsics.checkNotNull(v0);
        if (v0 > 0L) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = canUseTimer = false;
        }
        if (!useTimer || !canUseTimer) {
            this.disableTimer();
            return;
        }
        v2 = Instant.now();
        v3 = this.disableAfter;
        Intrinsics.checkNotNull(v3);
        this.timerEndTime = v2.plusMillis(v3);
        if (!this.isTimerEnabled) {
            this.isTimerEnabled = true;
            wrapper = new SchedulerWrapper((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, checkTimerSettings$lambda$0(io.github.arcaneplugins.levelledmobs.debug.DebugManager ), ()V)((DebugManager)this));
            this.timerTask = wrapper.runTaskTimerAsynchronously(20L, 20L);
        }
    }

    private final void logInstance(DebugType debugType, RuleInfo ruleInfo, LivingEntityInterface lmInterface, Entity entity, Boolean ruleResult, String origMsg) {
        if (!this.isEnabled) {
            return;
        }
        Object msg = origMsg;
        if (!this.bypassAllFilters) {
            if (!((Collection)this.filterDebugTypes).isEmpty() && !this.filterDebugTypes.contains((Object)debugType)) {
                return;
            }
            if (ruleInfo != null && !((Collection)this.filterRuleNames).isEmpty() && !this.filterRuleNames.contains(StringsKt.replace$default(ruleInfo.getRuleName$levelledmobs_plugin(), " ", "_", false, 4, null)) || ruleInfo == null && !((Collection)this.filterRuleNames).isEmpty()) {
                return;
            }
            if (!((Collection)this.filterEntityTypes).isEmpty()) {
                EntityType et = null;
                Entity entity2 = entity;
                if (entity2 != null) {
                    et = entity2.getType();
                } else if (lmInterface != null) {
                    et = lmInterface.getEntityType();
                }
                if (!CollectionsKt.contains((Iterable)this.filterEntityTypes, et)) {
                    return;
                }
            }
            Entity useEntity = entity;
            if (lmInterface instanceof LivingEntityWrapper) {
                useEntity = (Entity)((LivingEntityWrapper)lmInterface).getLivingEntity();
            }
            if (this.maxPlayerDistance != null) {
                Integer n = this.maxPlayerDistance;
                Intrinsics.checkNotNull(n);
                if (n > 0 && useEntity != null) {
                    List<Player> players = this.getPlayers();
                    boolean foundMatch = false;
                    if (players != null) {
                        for (Player player : players) {
                            if (!Intrinsics.areEqual(player.getWorld(), useEntity.getWorld())) continue;
                            double dist = player.getLocation().distance(useEntity.getLocation());
                            Integer n2 = this.maxPlayerDistance;
                            Intrinsics.checkNotNull(n2);
                            if (!(dist <= (double)n2.intValue())) continue;
                            foundMatch = true;
                            break;
                        }
                    }
                    if (!foundMatch) {
                        return;
                    }
                }
            }
            if (ruleResult != null && this.listenFor != ListenFor.BOTH) {
                if (ruleResult.booleanValue() && this.listenFor == ListenFor.FAILURE) {
                    return;
                }
                if (!ruleResult.booleanValue() && this.listenFor == ListenFor.SUCCESS) {
                    return;
                }
            }
            if (useEntity != null) {
                if (this.minYLevel != null) {
                    int n = useEntity.getLocation().getBlockY();
                    Integer n3 = this.minYLevel;
                    Intrinsics.checkNotNull(n3);
                    if (n < n3) {
                        return;
                    }
                }
                if (this.maxYLevel != null) {
                    int n = useEntity.getLocation().getBlockY();
                    Integer n4 = this.maxYLevel;
                    Intrinsics.checkNotNull(n4);
                    if (n > n4) {
                        return;
                    }
                }
            }
        }
        if (ruleInfo != null) {
            Object object = msg = ((CharSequence)origMsg).length() == 0 ? "(" + ruleInfo.getRuleName$levelledmobs_plugin() + ")" : "(" + ruleInfo.getRuleName$levelledmobs_plugin() + ") " + (String)msg;
        }
        if (lmInterface != null) {
            String useName = lmInterface instanceof LivingEntityWrapper ? ((LivingEntityWrapper)lmInterface).getNameIfBaby() : lmInterface.getTypeName();
            msg = ((CharSequence)msg).length() == 0 ? "mob: &b" + useName + "&7" : "mob: &b" + useName + "&7, " + (String)msg;
        } else if (entity != null) {
            Object object = msg = ((CharSequence)msg).length() == 0 ? "mob: &b" + entity.getType() + "&7" : "mob: &b" + entity.getType() + "&7, " + (String)msg;
        }
        if (ruleResult != null) {
            msg = ((CharSequence)msg).length() == 0 ? "result: " + ruleResult : (String)msg + ", result: " + ruleResult;
        }
        if (this.outputType == OutputTypes.TO_BOTH || this.outputType == OutputTypes.TO_CONSOLE) {
            Log.INSTANCE.inf("&8[&bDebug: " + debugType + "&8]&7 " + (String)msg);
        }
        if (this.outputType == OutputTypes.TO_BOTH || this.outputType == OutputTypes.TO_CHAT) {
            if (this.playerThatEnabledDebug == null) {
                Log.INSTANCE.inf("No player to send chat messages to");
            } else {
                Player player = this.playerThatEnabledDebug;
                Intrinsics.checkNotNull(player);
                player.sendMessage(MessageUtils.INSTANCE.colorizeAll("&8[&bDebug: " + debugType + "&8]&7 " + (String)msg));
            }
        }
    }

    private final List<Player> getPlayers() {
        if (this.filterPlayerNames.isEmpty()) {
            Collection collection = Bukkit.getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            return CollectionsKt.toMutableList(collection);
        }
        List players = new ArrayList();
        for (String playerName : this.filterPlayerNames) {
            Player player = Bukkit.getPlayer((String)playerName);
            if (player == null) continue;
            players.add(player);
        }
        return players.isEmpty() ? null : players;
    }

    @NotNull
    public final String getDebugStatus() {
        String string;
        StringBuilder sb = new StringBuilder("\nDebug Status: ");
        if (this.isEnabled) {
            sb.append("ENABLED");
            if (this.isTimerEnabled) {
                sb.append("-(Time Left: ");
                sb.append(this.getTimeRemaining()).append(")");
            }
        } else {
            sb.append("DISABLED");
        }
        if (!this.bypassAllFilters && !this.hasFiltering()) {
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            return string2;
        }
        sb.append("\n--------------------------\n").append("Current Filter Options:");
        if (this.bypassAllFilters) {
            sb.append("\n- All filters bypassed");
            String string3 = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
            return string3;
        }
        if (!((Collection)this.filterDebugTypes).isEmpty()) {
            sb.append("\n- Debug types: ");
            sb.append(this.filterDebugTypes);
        }
        if (!((Collection)this.filterEntityTypes).isEmpty()) {
            sb.append("\n- Entity types: ");
            sb.append(this.filterEntityTypes);
        }
        if (!((Collection)this.filterRuleNames).isEmpty()) {
            sb.append("\n- Rule names: ");
            sb.append(this.filterRuleNames);
        }
        if (!((Collection)this.filterPlayerNames).isEmpty()) {
            sb.append("\n- Player names: ");
            sb.append(this.filterPlayerNames);
        }
        if (this.listenFor != ListenFor.BOTH) {
            sb.append("\n- Listen for: ");
            string = this.listenFor.name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string4 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
            sb.append(string4);
        }
        if (this.maxPlayerDistance != null) {
            sb.append("\n- Max player distance: ");
            sb.append(this.maxPlayerDistance);
        }
        if (this.minYLevel != null) {
            sb.append("\n- Min y level: ");
            sb.append(this.minYLevel);
        }
        if (this.maxYLevel != null) {
            StringBuilder stringBuilder = this.minYLevel != null ? sb.append(", Max y level: ") : sb.append("\n- Max y level: ");
            sb.append(this.maxYLevel);
        }
        if (this.outputType != OutputTypes.TO_CONSOLE) {
            sb.append("\n- Output to: ");
            string = this.outputType.name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string5 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string5, "toLowerCase(...)");
            sb.append(string5);
        }
        String string6 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string6, "toString(...)");
        return string6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasFiltering() {
        if (!((Collection)this.filterDebugTypes).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        if (!((Collection)this.filterEntityTypes).isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        if (!((Collection)this.filterRuleNames).isEmpty()) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        if (!((Collection)this.filterPlayerNames).isEmpty()) {
            return true;
        }
        boolean bl4 = false;
        if (bl4) return true;
        if (this.listenFor != ListenFor.BOTH) return true;
        if (this.outputType != OutputTypes.TO_CONSOLE) return true;
        if (this.maxPlayerDistance == null) return true;
        Integer n = this.maxPlayerDistance;
        if (n == null) return true;
        if (n != 0) return true;
        if (this.minYLevel != null) return true;
        if (this.maxYLevel == null) return false;
        return true;
    }

    public final void resetFilters() {
        this.filterDebugTypes.clear();
        this.filterEntityTypes.clear();
        this.filterRuleNames.clear();
        this.filterPlayerNames.clear();
        this.listenFor = ListenFor.BOTH;
        this.outputType = OutputTypes.TO_CONSOLE;
        this.maxPlayerDistance = this.defaultPlayerDistance;
        this.minYLevel = null;
        this.maxYLevel = null;
        this.disableAfter = null;
        this.disableAfterStr = null;
    }

    public final boolean isDebugTypeEnabled(@NotNull DebugType debugType) {
        Intrinsics.checkNotNullParameter((Object)debugType, "debugType");
        if (!this.isEnabled) {
            return false;
        }
        return this.filterDebugTypes.isEmpty() || this.filterDebugTypes.contains((Object)debugType);
    }

    private final void timerLoop() {
        if (Instant.now().isAfter(this.timerEndTime)) {
            this.disableDebug();
            String msg = "Debug timer has elapsed, debugging is now disabled";
            if (this.outputType == OutputTypes.TO_CONSOLE || this.outputType == OutputTypes.TO_BOTH) {
                Log.INSTANCE.inf(msg);
            }
            if ((this.outputType == OutputTypes.TO_CHAT || this.outputType == OutputTypes.TO_BOTH) && this.playerThatEnabledDebug != null) {
                Player player = this.playerThatEnabledDebug;
                Intrinsics.checkNotNull(player);
                player.sendMessage(msg);
            }
        }
    }

    public final void timerWasChanged(boolean useTimer) {
        this.checkTimerSettings(this.isTimerEnabled || useTimer);
    }

    private final String getTimeRemaining() {
        block6: {
            block5: {
                if (!this.isEnabled || this.disableAfter == null) break block5;
                Long l = this.disableAfter;
                Intrinsics.checkNotNull(l);
                if (l > 0L && this.timerEndTime != null) break block6;
            }
            return null;
        }
        Duration duration = Duration.between(Instant.now(), this.timerEndTime);
        int secondsLeft = (int)duration.getSeconds();
        if (secondsLeft < 60) {
            return secondsLeft == 1 ? "1 second" : secondsLeft + " seconds";
        }
        if (secondsLeft < 3600) {
            int minutes = (int)Math.floor((double)secondsLeft / 60.0);
            int newSeconds = secondsLeft % 60;
            StringBuilder sb = new StringBuilder();
            sb.append(minutes).append(minutes == 1 ? " minute, " : " minutes, ").append(newSeconds).append(newSeconds == 1 ? " second" : " seconds");
            return sb.toString();
        }
        return String.valueOf(secondsLeft);
    }

    public final void toggleDamageDebugOutput(boolean doEnable) {
        if (doEnable) {
            if (this.damageDebugOutputIsEnabled) {
                return;
            }
            this.damageDebugOutputIsEnabled = true;
            Bukkit.getPluginManager().registerEvents((Listener)LevelledMobs.Companion.getInstance().getEntityDamageDebugListener(), (Plugin)LevelledMobs.Companion.getInstance());
        } else {
            if (!this.damageDebugOutputIsEnabled) {
                return;
            }
            this.damageDebugOutputIsEnabled = false;
            HandlerList.unregisterAll((Listener)LevelledMobs.Companion.getInstance().getEntityDamageDebugListener());
        }
    }

    private final void buildExcludedEntityTypes() {
        String[] stringArray = new String[]{"AREA_EFFECT_CLOUD", "ARMOR_STAND", "ARROW", "BLOCK_DISPLAY", "CHEST_BOAT", "DRAGON_FIREBALL", "DROPPED_ITEM", "EGG", "ENDER_CRYSTAL", "ENDER_PEARL", "ENDER_SIGNAL", "EVOKER_FANGS", "EXPERIENCE_ORB", "FALLING_BLOCK", "FIREWORK", "FISHING_HOOK", "GIANT", "INTERACTION", "ITEM_DISPLAY", "ITEM_FRAME", "LEASH_HITCH", "LIGHTNING", "LLAMA_SPIT", "MARKER", "MINECART", "MINECART_CHEST", "MINECART_COMMAND", "MINECART_FURNACE", "MINECART_HOPPER", "MINECART_MOB_SPAWNER", "MINECART_TNT", "PAINTING", "PLAYER", "PRIMED_TNT", "SHULKER_BULLET", "SMALL_FIREBALL", "SPECTRAL_ARROW", "SPLASH_POTION", "TEXT_DISPLAY", "THROWN_EXP_BOTTLE", "TRIDENT", "UNKNOWN", "BOAT", "FIREBALL", "GLOW_ITEM_FRAME", "TROPICAL_FISH", "WIND_CHARGE", "WITHER_SKULL"};
        this.excludedEntityTypes = CollectionsKt.mutableListOf(stringArray);
    }

    private static final void checkTimerSettings$lambda$0(DebugManager this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.timerLoop();
    }

    static {
        longMessagesMap = new LinkedHashMap();
        lock = new Object();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nJ8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nJ(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nJ0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\u00192\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nJ0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001a\u001a\u00020\u00192\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nJ(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nJ\u0006\u0010\u001d\u001a\u00020\bJ\u001c\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ \u0010!\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/github/arcaneplugins/levelledmobs/debug/DebugManager$Companion;", "", "<init>", "()V", "instance", "Lio/github/arcaneplugins/levelledmobs/debug/DebugManager;", "longMessagesMap", "", "Ljava/util/UUID;", "", "Ljava/util/function/Supplier;", "", "lock", "log", "", "debugType", "Lio/github/arcaneplugins/levelledmobs/debug/DebugType;", "ruleInfo", "Lio/github/arcaneplugins/levelledmobs/rules/RuleInfo;", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "msg", "lmInterface", "Lio/github/arcaneplugins/levelledmobs/LivingEntityInterface;", "ruleResult", "", "result", "entity", "Lorg/bukkit/entity/Entity;", "startLongDebugMessage", "logLongMessage", "id", "message", "endLongMessage", "levelledmobs-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final void log(@NotNull DebugType debugType, @NotNull RuleInfo ruleInfo, @Nullable LivingEntityWrapper lmEntity, @NotNull Supplier<String> msg) {
            Intrinsics.checkNotNullParameter((Object)debugType, "debugType");
            Intrinsics.checkNotNullParameter(ruleInfo, "ruleInfo");
            Intrinsics.checkNotNullParameter(msg, "msg");
            DebugManager debugManager = instance;
            if (debugManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException("instance");
                debugManager = null;
            }
            LivingEntityInterface livingEntityInterface = lmEntity;
            String string = msg.get();
            Intrinsics.checkNotNull(string);
            debugManager.logInstance(debugType, ruleInfo, livingEntityInterface, null, null, string);
        }

        public final void log(@NotNull DebugType debugType, @NotNull RuleInfo ruleInfo, @Nullable LivingEntityInterface lmInterface, boolean ruleResult, @NotNull Supplier<String> msg) {
            Intrinsics.checkNotNullParameter((Object)debugType, "debugType");
            Intrinsics.checkNotNullParameter(ruleInfo, "ruleInfo");
            Intrinsics.checkNotNullParameter(msg, "msg");
            DebugManager debugManager = instance;
            if (debugManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException("instance");
                debugManager = null;
            }
            Boolean bl = ruleResult;
            String string = msg.get();
            Intrinsics.checkNotNull(string);
            debugManager.logInstance(debugType, ruleInfo, lmInterface, null, bl, string);
        }

        public final void log(@NotNull DebugType debugType, @Nullable LivingEntityWrapper lmEntity, @NotNull Supplier<String> msg) {
            Intrinsics.checkNotNullParameter((Object)debugType, "debugType");
            Intrinsics.checkNotNullParameter(msg, "msg");
            DebugManager debugManager = instance;
            if (debugManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException("instance");
                debugManager = null;
            }
            LivingEntityInterface livingEntityInterface = lmEntity;
            String string = msg.get();
            Intrinsics.checkNotNull(string);
            debugManager.logInstance(debugType, null, livingEntityInterface, null, null, string);
        }

        public final void log(@NotNull DebugType debugType, @Nullable LivingEntityWrapper lmEntity, boolean result, @NotNull Supplier<String> msg) {
            Intrinsics.checkNotNullParameter((Object)debugType, "debugType");
            Intrinsics.checkNotNullParameter(msg, "msg");
            DebugManager debugManager = instance;
            if (debugManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException("instance");
                debugManager = null;
            }
            LivingEntityInterface livingEntityInterface = lmEntity;
            Boolean bl = result;
            String string = msg.get();
            Intrinsics.checkNotNull(string);
            debugManager.logInstance(debugType, null, livingEntityInterface, null, bl, string);
        }

        public final void log(@NotNull DebugType debugType, @Nullable Entity entity, boolean result, @NotNull Supplier<String> msg) {
            Intrinsics.checkNotNullParameter((Object)debugType, "debugType");
            Intrinsics.checkNotNullParameter(msg, "msg");
            DebugManager debugManager = instance;
            if (debugManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException("instance");
                debugManager = null;
            }
            Boolean bl = result;
            String string = msg.get();
            Intrinsics.checkNotNull(string);
            debugManager.logInstance(debugType, null, null, entity, bl, string);
        }

        public final void log(@NotNull DebugType debugType, @Nullable Entity entity, @NotNull Supplier<String> msg) {
            Intrinsics.checkNotNullParameter((Object)debugType, "debugType");
            Intrinsics.checkNotNullParameter(msg, "msg");
            DebugManager debugManager = instance;
            if (debugManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException("instance");
                debugManager = null;
            }
            String string = msg.get();
            Intrinsics.checkNotNull(string);
            debugManager.logInstance(debugType, null, null, entity, null, string);
        }

        public final void log(@NotNull DebugType debugType, @NotNull Supplier<String> msg) {
            Intrinsics.checkNotNullParameter((Object)debugType, "debugType");
            Intrinsics.checkNotNullParameter(msg, "msg");
            DebugManager debugManager = instance;
            if (debugManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException("instance");
                debugManager = null;
            }
            String string = msg.get();
            Intrinsics.checkNotNull(string);
            debugManager.logInstance(debugType, null, null, null, null, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final UUID startLongDebugMessage() {
            UUID id = UUID.randomUUID();
            Object object = lock;
            synchronized (object) {
                boolean bl = false;
                longMessagesMap.put(id, (List)new ArrayList());
                Unit unit = Unit.INSTANCE;
            }
            Intrinsics.checkNotNull(id);
            return id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void logLongMessage(@NotNull UUID id, @NotNull Supplier<String> message) {
            Intrinsics.checkNotNullParameter(id, "id");
            Intrinsics.checkNotNullParameter(message, "message");
            DebugManager debugManager = instance;
            if (debugManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException("instance");
                debugManager = null;
            }
            if (!debugManager.isEnabled()) {
                return;
            }
            Object object = lock;
            synchronized (object) {
                boolean bl = false;
                List list = (List)longMessagesMap.get(id);
                Boolean bl2 = list != null ? Boolean.valueOf(list.add(message)) : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void endLongMessage(@NotNull UUID id, @NotNull DebugType debugType, @Nullable LivingEntityWrapper lmEntity) {
            Intrinsics.checkNotNullParameter(id, "id");
            Intrinsics.checkNotNullParameter((Object)debugType, "debugType");
            Object messages = null;
            Iterator iterator2 = lock;
            synchronized (iterator2) {
                boolean $i$a$-synchronized-DebugManager$Companion$endLongMessage$22 = false;
                messages = longMessagesMap.remove(id);
                Unit $i$a$-synchronized-DebugManager$Companion$endLongMessage$22 = Unit.INSTANCE;
            }
            if (messages == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            for (Supplier message : (List)messages) {
                sb.append((String)message.get());
            }
            this.log(debugType, lmEntity, () -> Companion.endLongMessage$lambda$3(sb));
        }

        private static final String endLongMessage$lambda$3(StringBuilder $sb) {
            Intrinsics.checkNotNullParameter($sb, "$sb");
            return $sb.toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/arcaneplugins/levelledmobs/debug/DebugManager$ListenFor;", "", "<init>", "(Ljava/lang/String;I)V", "FAILURE", "SUCCESS", "BOTH", "levelledmobs-plugin"})
    public static final class ListenFor
    extends Enum<ListenFor> {
        public static final /* enum */ ListenFor FAILURE = new ListenFor();
        public static final /* enum */ ListenFor SUCCESS = new ListenFor();
        public static final /* enum */ ListenFor BOTH = new ListenFor();
        private static final /* synthetic */ ListenFor[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ListenFor[] values() {
            return (ListenFor[])$VALUES.clone();
        }

        public static ListenFor valueOf(String value) {
            return Enum.valueOf(ListenFor.class, value);
        }

        @NotNull
        public static EnumEntries<ListenFor> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = listenForArray = new ListenFor[]{ListenFor.FAILURE, ListenFor.SUCCESS, ListenFor.BOTH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/arcaneplugins/levelledmobs/debug/DebugManager$OutputTypes;", "", "<init>", "(Ljava/lang/String;I)V", "TO_CONSOLE", "TO_CHAT", "TO_BOTH", "levelledmobs-plugin"})
    public static final class OutputTypes
    extends Enum<OutputTypes> {
        public static final /* enum */ OutputTypes TO_CONSOLE = new OutputTypes();
        public static final /* enum */ OutputTypes TO_CHAT = new OutputTypes();
        public static final /* enum */ OutputTypes TO_BOTH = new OutputTypes();
        private static final /* synthetic */ OutputTypes[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OutputTypes[] values() {
            return (OutputTypes[])$VALUES.clone();
        }

        public static OutputTypes valueOf(String value) {
            return Enum.valueOf(OutputTypes.class, value);
        }

        @NotNull
        public static EnumEntries<OutputTypes> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = outputTypesArray = new OutputTypes[]{OutputTypes.TO_CONSOLE, OutputTypes.TO_CHAT, OutputTypes.TO_BOTH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

