/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.customdrops;

import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.rules.MinAndMax;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eJ\u001f\u0010\u001f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0000H\u0002\u00a2\u0006\u0002\u0010!J \u0010\"\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\fH\u0002J\u0010\u0010%\u001a\u00020&2\b\u0010 \u001a\u0004\u0018\u00010\u0000J\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020(H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR(\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006,"}, d2={"Lio/github/arcaneplugins/levelledmobs/customdrops/SlidingChance;", "", "<init>", "()V", "chance", "", "getChance", "()F", "setChance", "(F)V", "changeRange", "", "Lio/github/arcaneplugins/levelledmobs/rules/MinAndMax;", "getChangeRange", "()Ljava/util/Map;", "setChangeRange", "(Ljava/util/Map;)V", "lastMatchedTier", "lastResult", "defaults", "getDefaults", "()Lio/github/arcaneplugins/levelledmobs/customdrops/SlidingChance;", "setDefaults", "(Lio/github/arcaneplugins/levelledmobs/customdrops/SlidingChance;)V", "isDefault", "", "()Z", "isAssuredChance", "getSlidingChance", "mobLevel", "", "getSlidingChance2", "slidingChance", "(ILio/github/arcaneplugins/levelledmobs/customdrops/SlidingChance;)Ljava/lang/Float;", "calculateChanceFromRange", "levelRanges", "assignments", "setFromInstance", "", "showMatchedChance", "", "clone", "", "toString", "levelledmobs-plugin"})
public final class SlidingChance
implements Cloneable {
    private float chance;
    @Nullable
    private Map<MinAndMax, MinAndMax> changeRange;
    @Nullable
    private MinAndMax lastMatchedTier;
    private float lastResult;
    @Nullable
    private SlidingChance defaults;

    public final float getChance() {
        return this.chance;
    }

    public final void setChance(float f) {
        this.chance = f;
    }

    @Nullable
    public final Map<MinAndMax, MinAndMax> getChangeRange() {
        return this.changeRange;
    }

    public final void setChangeRange(@Nullable Map<MinAndMax, MinAndMax> map) {
        this.changeRange = map;
    }

    @Nullable
    public final SlidingChance getDefaults() {
        return this.defaults;
    }

    public final void setDefaults(@Nullable SlidingChance slidingChance) {
        this.defaults = slidingChance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isDefault() {
        if (this.chance != 0.0f) return false;
        boolean bl = true;
        if (!bl) return false;
        if (this.changeRange == null) return true;
        Map<MinAndMax, MinAndMax> map = this.changeRange;
        Intrinsics.checkNotNull(map);
        if (!map.isEmpty()) return false;
        return true;
    }

    public final boolean isAssuredChance() {
        return this.chance >= 1.0f && !this.isDefault();
    }

    public final float getSlidingChance(int mobLevel) {
        Float result = null;
        for (int i = 0; i < 2; ++i) {
            SlidingChance slidingChance;
            SlidingChance slidingChance2 = slidingChance = i == 0 ? this : this.defaults;
            if (slidingChance != null && (result = this.getSlidingChance2(mobLevel, slidingChance)) != null) break;
        }
        Float f = result;
        return f != null ? f.floatValue() : 0.0f;
    }

    private final Float getSlidingChance2(int mobLevel, SlidingChance slidingChance) {
        block7: {
            block6: {
                this.lastMatchedTier = null;
                if (slidingChance.changeRange == null) break block6;
                Map<MinAndMax, MinAndMax> map = slidingChance.changeRange;
                Intrinsics.checkNotNull(map);
                if (!map.isEmpty()) break block7;
            }
            return Float.valueOf(slidingChance.chance);
        }
        Map<MinAndMax, MinAndMax> map = slidingChance.changeRange;
        Intrinsics.checkNotNull(map);
        for (MinAndMax levelRanges : map.keySet()) {
            if (mobLevel < levelRanges.getMinAsInt() || mobLevel > levelRanges.getMaxAsInt()) continue;
            Map<MinAndMax, MinAndMax> map2 = slidingChance.changeRange;
            Intrinsics.checkNotNull(map2);
            MinAndMax minAndMax = map2.get(levelRanges);
            Intrinsics.checkNotNull(minAndMax);
            MinAndMax assignments = minAndMax;
            if (mobLevel == levelRanges.getMinAsInt()) {
                this.lastMatchedTier = assignments;
                this.lastResult = assignments.getMin();
                return Float.valueOf(assignments.getMin());
            }
            if (mobLevel == levelRanges.getMaxAsInt()) {
                this.lastMatchedTier = assignments;
                this.lastResult = assignments.getMax();
                return Float.valueOf(assignments.getMax());
            }
            return Float.valueOf(this.calculateChanceFromRange(mobLevel, levelRanges, assignments));
        }
        return null;
    }

    private final float calculateChanceFromRange(int mobLevel, MinAndMax levelRanges, MinAndMax assignments) {
        float result;
        this.lastMatchedTier = assignments;
        if (assignments.getMin() == assignments.getMax()) {
            this.lastResult = assignments.getMin();
            return assignments.getMin();
        }
        float levelsRangePercent = 1.0f - (levelRanges.getMax() - (float)mobLevel) / levelRanges.getMax();
        float assignmentsDiff = assignments.getMax() - assignments.getMin();
        this.lastResult = result = levelsRangePercent * assignmentsDiff + assignments.getMin();
        return result;
    }

    public final void setFromInstance(@Nullable SlidingChance slidingChance) {
        if (slidingChance == null) {
            return;
        }
        Object object = slidingChance.clone();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.customdrops.SlidingChance");
        SlidingChance copy = (SlidingChance)object;
        this.chance = copy.chance;
        this.changeRange = copy.changeRange;
    }

    @NotNull
    public final String showMatchedChance() {
        Object object;
        if (this.lastMatchedTier != null) {
            MinAndMax minAndMax = this.lastMatchedTier;
            Intrinsics.checkNotNull(minAndMax);
            float f = minAndMax.getMin();
            MinAndMax minAndMax2 = this.lastMatchedTier;
            Intrinsics.checkNotNull(minAndMax2);
            object = f == minAndMax2.getMax() ? String.valueOf(this.lastResult) : this.lastMatchedTier + ": " + this.lastResult;
        } else {
            object = String.valueOf(this.chance);
        }
        return object;
    }

    @NotNull
    public Object clone() {
        SlidingChance copy = null;
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.customdrops.SlidingChance");
            copy = (SlidingChance)object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SlidingChance slidingChance = copy;
        Intrinsics.checkNotNull(slidingChance, "null cannot be cast to non-null type kotlin.Any");
        return slidingChance;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String toString() {
        String string;
        if (this.changeRange != null) {
            Map<MinAndMax, MinAndMax> map = this.changeRange;
            Intrinsics.checkNotNull(map);
            if (!map.isEmpty()) {
                string = String.valueOf(this.changeRange);
                return string;
            }
        }
        string = String.valueOf(this.chance);
        return string;
    }
}

