/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.customdrops;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.compatibility.Compat119;
import io.github.arcaneplugins.levelledmobs.compatibility.Compat120;
import io.github.arcaneplugins.levelledmobs.compatibility.Compat121;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomCommand;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropBase;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropInstance;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropItem;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropsDefaults;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropsHandler;
import io.github.arcaneplugins.levelledmobs.customdrops.EnchantmentChances;
import io.github.arcaneplugins.levelledmobs.customdrops.GroupLimits;
import io.github.arcaneplugins.levelledmobs.customdrops.LMItemsParser;
import io.github.arcaneplugins.levelledmobs.customdrops.SlidingChance;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.DeathCause;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.managers.NBTManager;
import io.github.arcaneplugins.levelledmobs.misc.CachedModalList;
import io.github.arcaneplugins.levelledmobs.misc.CustomUniversalGroups;
import io.github.arcaneplugins.levelledmobs.misc.YmlParsingHelper;
import io.github.arcaneplugins.levelledmobs.result.NBTApplyResult;
import io.github.arcaneplugins.levelledmobs.rules.MinAndMax;
import io.github.arcaneplugins.levelledmobs.rules.RuleInfo;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010&\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0014H\u0002J\u0012\u0010$\u001a\u00020\u001e2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020&H\u0002J\u0016\u0010)\u001a\u00020\u001e2\f\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010+H\u0002J\u001e\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0001\u0018\u00010-2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J$\u00103\u001a\u0004\u0018\u0001042\u0006\u00101\u001a\u0002022\u0006\u00105\u001a\u00020\u00142\b\u00106\u001a\u0004\u0018\u000104H\u0002J\u0018\u00107\u001a\u00020\u001e2\u0006\u00101\u001a\u0002022\u0006\u00108\u001a\u000209H\u0002J\u0018\u0010:\u001a\u00020\u001e2\u0006\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020&H\u0002J\u0018\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020?2\u0006\u00101\u001a\u000202H\u0002J(\u0010@\u001a\n\u0012\u0004\u0012\u00020B\u0018\u00010A2\u0006\u00101\u001a\u0002022\u000e\u00106\u001a\n\u0012\u0004\u0012\u00020B\u0018\u00010AH\u0002J\u001a\u0010C\u001a\u00020\u001e2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u00108\u001a\u000209H\u0002J,\u0010D\u001a\u00020\u001e2\u0006\u0010E\u001a\u00020F2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010H2\u0006\u00108\u001a\u000209H\u0002J\u0018\u0010I\u001a\u00020\u001e2\u0006\u0010J\u001a\u00020?2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010K\u001a\u00020\u001e2\u0006\u00108\u001a\u000209H\u0002J\u0018\u0010L\u001a\u00020\u001e2\u0006\u00108\u001a\u0002092\u0006\u00101\u001a\u000202H\u0002J\u0018\u0010M\u001a\u00020\u001e2\u0006\u00108\u001a\u0002092\u0006\u00101\u001a\u000202H\u0002J\u001c\u0010N\u001a\u0004\u0018\u00010&2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010O\u001a\u00020\u0014H\u0002J\u0014\u0010P\u001a\u0004\u0018\u00010&2\b\u0010Q\u001a\u0004\u0018\u00010\u0001H\u0002J\u0018\u0010R\u001a\u00020\f2\u0006\u0010S\u001a\u00020\u00142\u0006\u00108\u001a\u000209H\u0002J\u001c\u0010T\u001a\u00020\f2\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00010VH\u0002J\u0010\u0010W\u001a\u00020\u001e2\b\u0010X\u001a\u0004\u0018\u00010YJ\u0010\u0010Z\u001a\u00020\u00142\u0006\u0010[\u001a\u000200H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000f\u00a8\u0006\\"}, d2={"Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsParser;", "", "handler", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsHandler;", "<init>", "(Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsHandler;)V", "value", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsDefaults;", "defaults", "getDefaults", "()Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsDefaults;", "hasMentionedNBTAPIMissing", "", "dropsUtilizeNBTAPI", "getDropsUtilizeNBTAPI", "()Z", "setDropsUtilizeNBTAPI", "(Z)V", "invalidExternalItems", "", "", "getInvalidExternalItems", "()Ljava/util/List;", "dropInstance", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropInstance;", "defaultName", "invalidEntityTypesToIgnore", "hadParsingError", "getHadParsingError", "buildInvalidEntityTypesToIgnore", "", "loadDrops", "customDropsCfg", "Lorg/bukkit/configuration/file/YamlConfiguration;", "hadError", "message", "processDefaults", "cs", "Lorg/bukkit/configuration/ConfigurationSection;", "parseCustomDrops", "config", "parseCustomDrops2", "itemConfigurations", "", "parseExternalExtras", "", "parseCustomDropsAttributes", "dropBase", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropBase;", "ymlHelper", "Lio/github/arcaneplugins/levelledmobs/misc/YmlParsingHelper;", "parseSlidingChance", "Lio/github/arcaneplugins/levelledmobs/customdrops/SlidingChance;", "keyName", "defaultValue", "parseCustomItem", "item", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropItem;", "parseGroupLimits", "base", "csParent", "parseCustomCommand", "customCommand", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomCommand;", "buildCachedModalListOfDamageCause", "Lio/github/arcaneplugins/levelledmobs/misc/CachedModalList;", "Lio/github/arcaneplugins/levelledmobs/enums/DeathCause;", "parseEnchantments", "parseEnchantmentChances", "enchantment", "Lorg/bukkit/enchantments/Enchantment;", "enchantmentsMap", "", "parseRangedVariables", "cc", "applyMetaAttributes", "parseItemFlags", "checkEquippedChance", "objectToConfigurationSection2", "path", "objectToConfigurationSectionOld", "obj", "addMaterialToDrop", "materialName", "checkForMobOverride", "itemEntry", "", "showCustomDropsDebugInfo", "sender", "Lorg/bukkit/command/CommandSender;", "showCustomDropsDebugInfo2", "baseItem", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nCustomDropsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomDropsParser.kt\nio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsParser\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,1363:1\n108#2:1364\n80#2,22:1365\n108#2:1387\n80#2,22:1388\n108#2:1410\n80#2,22:1411\n108#2:1433\n80#2,22:1434\n108#2:1456\n80#2,22:1457\n108#2:1479\n80#2,22:1480\n108#2:1502\n80#2,22:1503\n108#2:1525\n80#2,22:1526\n108#2:1548\n80#2,22:1549\n*S KotlinDebug\n*F\n+ 1 CustomDropsParser.kt\nio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsParser\n*L\n157#1:1364\n157#1:1365,22\n587#1:1387\n587#1:1388,22\n686#1:1410\n686#1:1411,22\n689#1:1433\n689#1:1434,22\n694#1:1456\n694#1:1457,22\n705#1:1479\n705#1:1480,22\n708#1:1502\n708#1:1503,22\n713#1:1525\n713#1:1526,22\n922#1:1548\n922#1:1549,22\n*E\n"})
public final class CustomDropsParser {
    @NotNull
    private final CustomDropsHandler handler;
    @NotNull
    private CustomDropsDefaults defaults;
    private boolean hasMentionedNBTAPIMissing;
    private boolean dropsUtilizeNBTAPI;
    @NotNull
    private final List<String> invalidExternalItems;
    @Nullable
    private CustomDropInstance dropInstance;
    @NotNull
    private final String defaultName;
    @NotNull
    private final List<String> invalidEntityTypesToIgnore;
    private boolean hadParsingError;

    public CustomDropsParser(@NotNull CustomDropsHandler handler) {
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.handler = handler;
        this.defaults = new CustomDropsDefaults();
        this.invalidExternalItems = new ArrayList();
        this.defaultName = "default";
        this.invalidEntityTypesToIgnore = new ArrayList();
        this.defaults.setGroupId(this.defaultName);
        this.buildInvalidEntityTypesToIgnore();
    }

    @NotNull
    public final CustomDropsDefaults getDefaults() {
        return this.defaults;
    }

    public final boolean getDropsUtilizeNBTAPI() {
        return this.dropsUtilizeNBTAPI;
    }

    public final void setDropsUtilizeNBTAPI(boolean bl) {
        this.dropsUtilizeNBTAPI = bl;
    }

    @NotNull
    public final List<String> getInvalidExternalItems() {
        return this.invalidExternalItems;
    }

    public final boolean getHadParsingError() {
        return this.hadParsingError;
    }

    private final void buildInvalidEntityTypesToIgnore() {
        this.invalidEntityTypesToIgnore.addAll((Collection<String>)Compat119.INSTANCE.all19Mobs());
        this.invalidEntityTypesToIgnore.addAll((Collection<String>)Compat120.INSTANCE.all20Mobs());
        this.invalidEntityTypesToIgnore.addAll((Collection<String>)Compat121.INSTANCE.all21Mobs());
    }

    public final void loadDrops(@Nullable YamlConfiguration customDropsCfg) {
        this.dropsUtilizeNBTAPI = false;
        if (customDropsCfg == null) {
            return;
        }
        boolean isDropsEnabledForAnyRule = false;
        this.hadParsingError = false;
        for (RuleInfo ruleInfo : LevelledMobs.Companion.getInstance().getRulesManager().getRulesInEffect()) {
            if (ruleInfo.getCustomDropsUseForMobs() == null) continue;
            Boolean bl = ruleInfo.getCustomDropsUseForMobs();
            Intrinsics.checkNotNull(bl);
            if (!bl.booleanValue()) continue;
            isDropsEnabledForAnyRule = true;
            break;
        }
        this.handler.clearDrops();
        if (isDropsEnabledForAnyRule) {
            this.handler.clearGroupIdMappings();
            this.parseCustomDrops((ConfigurationSection)customDropsCfg);
        }
        DebugManager.Companion.log(DebugType.CUSTOM_DROPS, () -> CustomDropsParser.loadDrops$lambda$0(this));
    }

    private final void hadError(String message) {
        Log.INSTANCE.war(message);
        this.hadParsingError = true;
    }

    private final void processDefaults(ConfigurationSection cs) {
        if (cs == null) {
            this.hadError("Defaults section was null");
            return;
        }
        YmlParsingHelper ymlParser = new YmlParsingHelper(cs);
        CustomDropItem drop = new CustomDropItem(this.defaults);
        drop.setMaterial(Material.AIR);
        drop.setDefaultDrop(true);
        CustomDropInstance customDropInstance = this.dropInstance = new CustomDropInstance(EntityType.AREA_EFFECT_CLOUD);
        Intrinsics.checkNotNull(customDropInstance);
        customDropInstance.getCustomItems().add(drop);
        this.parseCustomDropsAttributes(drop, ymlParser);
        this.defaults.setDefaultsFromDropItem(drop);
        CustomDropInstance customDropInstance2 = this.dropInstance;
        Intrinsics.checkNotNull(customDropInstance2);
        this.defaults.setOverride(customDropInstance2.getGetOverrideStockDrops());
        CustomDropInstance customDropInstance3 = this.dropInstance;
        Intrinsics.checkNotNull(customDropInstance3);
        this.defaults.setOverallChance(customDropInstance3.getOverallChance());
        List<String> list = this.defaults.getOverallPermissions();
        CustomDropInstance customDropInstance4 = this.dropInstance;
        Intrinsics.checkNotNull(customDropInstance4);
        list.addAll((Collection<String>)customDropInstance4.getOverallPermissions());
        Map<String, CustomDropInstance> map = this.handler.getCustomDropIDs();
        String string = this.defaults.getGroupId();
        Intrinsics.checkNotNull(string);
        CustomDropInstance customDropInstance5 = this.dropInstance;
        Intrinsics.checkNotNull(customDropInstance5);
        map.put(string, customDropInstance5);
    }

    private final void parseCustomDrops(ConfigurationSection config) {
        MemorySection ms;
        this.handler.setCustomItemGroups(new LinkedHashMap());
        this.processDefaults(this.objectToConfigurationSection2(config, "defaults"));
        String dropTableKey = YmlParsingHelper.Companion.getKeyNameFromConfig(config, "drop-table");
        if (config.get(dropTableKey) != null && (ms = (MemorySection)config.get(dropTableKey)) != null) {
            Map map = ms.getValues(true);
            Intrinsics.checkNotNullExpressionValue(map, "getValues(...)");
            Map itemGroups = map;
            for (Map.Entry entry : itemGroups.entrySet()) {
                String itemGroupName = (String)entry.getKey();
                Object value = entry.getValue();
                this.dropInstance = new CustomDropInstance(EntityType.AREA_EFFECT_CLOUD);
                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.collections.List<*>");
                this.parseCustomDrops2((List)value);
                CustomDropInstance customDropInstance = this.dropInstance;
                Intrinsics.checkNotNull(customDropInstance);
                if (!(!((Collection)customDropInstance.getCustomItems()).isEmpty())) {
                    CustomDropInstance customDropInstance2 = this.dropInstance;
                    Intrinsics.checkNotNull(customDropInstance2);
                    if (!customDropInstance2.getGetOverrideStockDrops()) continue;
                }
                Map<String, CustomDropInstance> map2 = this.handler.getCustomItemGroups();
                CustomDropInstance customDropInstance3 = this.dropInstance;
                Intrinsics.checkNotNull(customDropInstance3);
                map2.put(itemGroupName, customDropInstance3);
                Map<String, CustomDropInstance> map3 = this.handler.getCustomDropIDs();
                CustomDropInstance customDropInstance4 = this.dropInstance;
                Intrinsics.checkNotNull(customDropInstance4);
                map3.put(itemGroupName, customDropInstance4);
            }
        }
        for (String item : config.getKeys(false)) {
            EntityType entityType = null;
            Intrinsics.checkNotNull(item);
            Object object = new String[]{";"};
            List mobTypeOrGroups = StringsKt.split$default((CharSequence)item, (String[])object, false, 0, 6, null);
            object = mobTypeOrGroups.iterator();
            while (object.hasNext()) {
                Map<EntityType, CustomDropInstance> dropMap;
                String mobTypeOrGroup;
                String mobTypeOrGroupPre;
                String $this$trim$iv = mobTypeOrGroupPre = (String)object.next();
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim22 = false;
                int startIndex$iv$iv2 = 0;
                int endIndex$iv$iv2 = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv2 : endIndex$iv$iv2;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv2;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv2;
                }
                if (((CharSequence)(mobTypeOrGroup = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString())).length() == 0) continue;
                $this$trim$iv = mobTypeOrGroup;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string = $this$trim$iv.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                if (StringsKt.startsWith$default(string, "file-version", false, 2, null)) continue;
                CustomUniversalGroups universalGroup = null;
                boolean isEntityTable = StringsKt.equals(mobTypeOrGroup, "drop-table", true);
                String $i$f$trim22 = mobTypeOrGroup;
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
                String string2 = $i$f$trim22.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                boolean isUniversalGroup = StringsKt.startsWith$default(string2, "all_", false, 2, null);
                if (isUniversalGroup) {
                    try {
                        $i$f$trim22 = mobTypeOrGroup;
                        Locale locale3 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue(locale3, "getDefault(...)");
                        String string3 = $i$f$trim22.toUpperCase(locale3);
                        Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
                        universalGroup = CustomUniversalGroups.valueOf(string3);
                    }
                    catch (Exception e) {
                        this.hadError("invalid universal group in customdrops.yml: " + mobTypeOrGroup);
                        continue;
                    }
                    this.dropInstance = new CustomDropInstance(universalGroup);
                } else {
                    if (isEntityTable || StringsKt.equals(mobTypeOrGroup, "defaults", true)) continue;
                    boolean isBabyMob = false;
                    String startIndex$iv$iv2 = mobTypeOrGroup;
                    Locale locale4 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue(locale4, "getDefault(...)");
                    String string4 = startIndex$iv$iv2.toLowerCase(locale4);
                    Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                    if (StringsKt.startsWith$default(string4, "baby_", false, 2, null)) {
                        isBabyMob = true;
                        String string5 = mobTypeOrGroup.substring(5);
                        Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                        mobTypeOrGroup = string5;
                    }
                    try {
                        startIndex$iv$iv2 = mobTypeOrGroup;
                        Locale locale5 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue(locale5, "getDefault(...)");
                        String string6 = startIndex$iv$iv2.toUpperCase(locale5);
                        Intrinsics.checkNotNullExpressionValue(string6, "toUpperCase(...)");
                        entityType = EntityType.valueOf((String)string6);
                    }
                    catch (Exception e) {
                        String endIndex$iv$iv2 = mobTypeOrGroup;
                        Locale locale6 = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue(locale6, "getDefault(...)");
                        String string7 = endIndex$iv$iv2.toUpperCase(locale6);
                        Intrinsics.checkNotNullExpressionValue(string7, "toUpperCase(...)");
                        if (this.invalidEntityTypesToIgnore.contains(string7)) continue;
                        this.hadError("invalid mob type in customdrops.yml: " + mobTypeOrGroup);
                        continue;
                    }
                    this.dropInstance = new CustomDropInstance(entityType, isBabyMob);
                }
                CustomDropInstance customDropInstance = this.dropInstance;
                Intrinsics.checkNotNull(customDropInstance);
                customDropInstance.setOverrideStockDrops(this.defaults.getOverride());
                CustomDropInstance customDropInstance5 = this.dropInstance;
                Intrinsics.checkNotNull(customDropInstance5);
                customDropInstance5.setOverallChance(this.defaults.getOverallChance());
                if (!isEntityTable) {
                    if (config.getList(item) != null) {
                        this.parseCustomDrops2(config.getList(item));
                    } else if (config.get(item) instanceof MemorySection) {
                        ConfigurationSection csItem;
                        if (this.objectToConfigurationSection2(config, item) == null) continue;
                        String useEntityDropId = YmlParsingHelper.Companion.getString(csItem, "usedroptable");
                        if (useEntityDropId != null && !this.handler.getCustomItemGroups().containsKey(useEntityDropId)) {
                            this.hadError("Did not find droptable id match for name: " + useEntityDropId);
                        } else if (useEntityDropId == null) {
                            this.hadError("Found a drop-table reference with no id!");
                        } else {
                            CustomDropInstance refDrop;
                            CustomDropInstance customDropInstance6 = refDrop = this.handler.getCustomItemGroups().get(useEntityDropId);
                            Intrinsics.checkNotNull(customDropInstance6);
                            for (CustomDropBase itemDrop : customDropInstance6.getCustomItems()) {
                                CustomDropBase customDropBase;
                                CustomDropInstance customDropInstance7 = this.dropInstance;
                                Intrinsics.checkNotNull(customDropInstance7);
                                List<CustomDropBase> list = customDropInstance7.getCustomItems();
                                if (itemDrop instanceof CustomDropItem) {
                                    customDropBase = ((CustomDropItem)itemDrop).cloneItem();
                                } else {
                                    Intrinsics.checkNotNull(itemDrop, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.customdrops.CustomCommand");
                                    customDropBase = ((CustomCommand)itemDrop).cloneItem();
                                }
                                Intrinsics.checkNotNull(customDropBase);
                                list.add(customDropBase);
                            }
                            if (refDrop.getUtilizesGroupIds()) {
                                CustomDropInstance customDropInstance8 = this.dropInstance;
                                Intrinsics.checkNotNull(customDropInstance8);
                                customDropInstance8.setUtilizesGroupIds(true);
                            }
                            if (refDrop.getGetOverrideStockDrops()) {
                                CustomDropInstance customDropInstance9 = this.dropInstance;
                                Intrinsics.checkNotNull(customDropInstance9);
                                customDropInstance9.setOverrideStockDrops(true);
                            }
                        }
                    }
                }
                CustomDropInstance customDropInstance10 = this.dropInstance;
                Intrinsics.checkNotNull(customDropInstance10);
                if (!(!((Collection)customDropInstance10.getCustomItems()).isEmpty())) {
                    CustomDropInstance customDropInstance11 = this.dropInstance;
                    Intrinsics.checkNotNull(customDropInstance11);
                    if (!customDropInstance11.getGetOverrideStockDrops()) continue;
                }
                if (isUniversalGroup) {
                    if (this.handler.getCustomDropsitemsGroups().containsKey(String.valueOf((Object)universalGroup))) {
                        CustomDropInstance csItem = this.handler.getCustomDropsitemsGroups().get(String.valueOf((Object)universalGroup));
                        if (csItem == null) continue;
                        csItem.combineDrop(this.dropInstance);
                        continue;
                    }
                    String string8 = String.valueOf((Object)universalGroup);
                    CustomDropInstance customDropInstance12 = this.dropInstance;
                    Intrinsics.checkNotNull(customDropInstance12);
                    this.handler.addCustomDropGroup(string8, customDropInstance12);
                    continue;
                }
                CustomDropInstance customDropInstance13 = this.dropInstance;
                Intrinsics.checkNotNull(customDropInstance13);
                Map<EntityType, CustomDropInstance> map = dropMap = customDropInstance13.isBabyMob() ? this.handler.getCustomDropsitemsBabies() : this.handler.getCustomDropsitems();
                if (dropMap.containsKey(entityType)) {
                    CustomDropInstance customDropInstance14 = dropMap.get(entityType);
                    Intrinsics.checkNotNull(customDropInstance14);
                    customDropInstance14.combineDrop(this.dropInstance);
                    continue;
                }
                EntityType entityType2 = entityType;
                Intrinsics.checkNotNull(entityType2);
                CustomDropInstance customDropInstance15 = this.dropInstance;
                Intrinsics.checkNotNull(customDropInstance15);
                dropMap.put(entityType2, customDropInstance15);
                CustomDropInstance customDropInstance16 = this.dropInstance;
                Intrinsics.checkNotNull(customDropInstance16);
                this.handler.addCustomDropItem(entityType, customDropInstance16);
            }
        }
    }

    private final void parseCustomDrops2(List<?> itemConfigurations) {
        if (itemConfigurations == null) {
            return;
        }
        for (Object itemObject : itemConfigurations) {
            if (itemObject instanceof String) {
                CustomDropItem item = new CustomDropItem(this.defaults);
                if (StringsKt.equals("override", (String)itemObject, true)) {
                    CustomDropInstance customDropInstance = this.dropInstance;
                    Intrinsics.checkNotNull(customDropInstance);
                    customDropInstance.setOverrideStockDrops(true);
                    continue;
                }
                this.addMaterialToDrop((String)itemObject, item);
                continue;
            }
            ConfigurationSection itemConfiguration = this.objectToConfigurationSectionOld(itemObject);
            if (itemConfiguration == null) continue;
            Set itemsToCheck = itemConfiguration.getValues(false).entrySet();
            if (itemsToCheck.isEmpty()) {
                Object obj = itemObject;
                Intrinsics.checkNotNull(obj);
                if (Intrinsics.areEqual(obj.getClass(), LinkedHashMap.class)) {
                    LinkedHashMap materials = (LinkedHashMap)itemObject;
                    boolean needsContinue = false;
                    for (Object k : materials.keySet()) {
                        Intrinsics.checkNotNullExpressionValue(k, "next(...)");
                        String materialName = (String)k;
                        CustomDropItem item = new CustomDropItem(this.defaults);
                        if (!this.addMaterialToDrop(materialName, item)) continue;
                        needsContinue = true;
                        break;
                    }
                    if (needsContinue) continue;
                }
            }
            for (Map.Entry itemEntry : itemsToCheck) {
                ConfigurationSection itemInfoConfiguration;
                String materialName = (String)itemEntry.getKey();
                if (this.checkForMobOverride(itemEntry)) continue;
                if (StringsKt.equals("overall_chance", materialName, true)) {
                    CustomDropInstance customDropInstance = this.dropInstance;
                    Intrinsics.checkNotNull(customDropInstance);
                    customDropInstance.setOverallChance(this.parseSlidingChance(new YmlParsingHelper(itemConfiguration), "overall_chance", this.defaults.getOverallChance()));
                    continue;
                }
                if (StringsKt.equals("overall_permission", materialName, true)) {
                    if (itemEntry.getValue() instanceof String) {
                        CustomDropInstance customDropInstance = this.dropInstance;
                        Intrinsics.checkNotNull(customDropInstance);
                        List<String> list = customDropInstance.getOverallPermissions();
                        String string = (String)itemEntry.getValue();
                        Intrinsics.checkNotNull(string);
                        list.add(string);
                        continue;
                    }
                    if (!(itemEntry.getValue() instanceof ArrayList)) continue;
                    CustomDropInstance customDropInstance = this.dropInstance;
                    Intrinsics.checkNotNull(customDropInstance);
                    List<String> list = customDropInstance.getOverallPermissions();
                    Object v = itemEntry.getValue();
                    Intrinsics.checkNotNull(v, "null cannot be cast to non-null type java.util.ArrayList<kotlin.String>");
                    list.addAll((ArrayList)v);
                    continue;
                }
                if (StringsKt.equals("usedroptable", materialName, true)) {
                    CustomDropInstance refDrop;
                    if (itemEntry.getValue() == null) {
                        this.hadError("Found a drop-table reference with no id!");
                        continue;
                    }
                    String useEntityDropId = itemEntry.getValue().toString();
                    if (!this.handler.getCustomItemGroups().containsKey(useEntityDropId)) {
                        this.hadError("Did not find droptable id match for name: " + useEntityDropId);
                        continue;
                    }
                    CustomDropInstance customDropInstance = refDrop = this.handler.getCustomItemGroups().get(useEntityDropId);
                    Intrinsics.checkNotNull(customDropInstance);
                    for (CustomDropBase itemDrop : customDropInstance.getCustomItems()) {
                        CustomDropBase customDropBase;
                        CustomDropInstance customDropInstance2 = this.dropInstance;
                        Intrinsics.checkNotNull(customDropInstance2);
                        List<CustomDropBase> list = customDropInstance2.getCustomItems();
                        if (itemDrop instanceof CustomDropItem) {
                            customDropBase = ((CustomDropItem)itemDrop).cloneItem();
                        } else {
                            Intrinsics.checkNotNull(itemDrop, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.customdrops.CustomCommand");
                            customDropBase = ((CustomCommand)itemDrop).cloneItem();
                        }
                        Intrinsics.checkNotNull(customDropBase);
                        list.add(customDropBase);
                    }
                    if (refDrop.getUtilizesGroupIds()) {
                        CustomDropInstance customDropInstance3 = this.dropInstance;
                        Intrinsics.checkNotNull(customDropInstance3);
                        customDropInstance3.setUtilizesGroupIds(true);
                    }
                    if (!refDrop.getGetOverrideStockDrops()) continue;
                    CustomDropInstance customDropInstance4 = this.dropInstance;
                    Intrinsics.checkNotNull(customDropInstance4);
                    customDropInstance4.setOverrideStockDrops(true);
                    continue;
                }
                if (this.objectToConfigurationSectionOld(itemEntry.getValue()) == null) continue;
                YmlParsingHelper ymlHelper = new YmlParsingHelper(itemInfoConfiguration);
                CustomDropBase dropBase = null;
                if (StringsKt.equals("customCommand", materialName, true)) {
                    dropBase = new CustomCommand(this.defaults);
                } else {
                    CustomDropItem item = new CustomDropItem(this.defaults);
                    item.setExternalType(ymlHelper.getString("type", this.defaults.getExternalType()));
                    item.setExternalAmount(ymlHelper.getDouble2("external-amount", this.defaults.getExternalAmount()));
                    item.setExternalExtras(this.parseExternalExtras(itemInfoConfiguration));
                    Intrinsics.checkNotNull(materialName);
                    if (!this.addMaterialToDrop(materialName, item)) continue;
                    dropBase = item;
                }
                this.parseCustomDropsAttributes(dropBase, ymlHelper);
            }
        }
    }

    private final Map<String, Object> parseExternalExtras(ConfigurationSection cs) {
        ConfigurationSection configurationSection = YmlParsingHelper.Companion.objToCS(cs, "extras");
        if (configurationSection == null) {
            return null;
        }
        ConfigurationSection cs2 = configurationSection;
        Map results = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        for (String name : cs2.getKeys(false)) {
            Object value = cs2.get(name);
            if (value == null) continue;
            results.put(name, value);
        }
        return results.isEmpty() ? null : results;
    }

    private final void parseCustomDropsAttributes(CustomDropBase dropBase, YmlParsingHelper ymlHelper) {
        CharSequence charSequence;
        dropBase.setChance(this.parseSlidingChance(ymlHelper, "chance", this.defaults.getChance()));
        dropBase.setUseChunkKillMax(ymlHelper.getBoolean("use-chunk-kill-max", this.defaults.getUseChunkKillMax()));
        dropBase.getPermissions().addAll((Collection<String>)this.defaults.getPermissions());
        dropBase.getPermissions().addAll((Collection<String>)ymlHelper.getStringSet("permission"));
        dropBase.setMinLevel(ymlHelper.getInt("minlevel", this.defaults.getMinLevel()));
        dropBase.setMaxLevel(ymlHelper.getInt("maxlevel", this.defaults.getMaxLevel()));
        dropBase.setMinPlayerLevel(ymlHelper.getInt("min-player-level", this.defaults.getMinPlayerLevel()));
        dropBase.setMaxPlayerLevel(ymlHelper.getInt("max-player-level", this.defaults.getMaxPlayerLevel()));
        dropBase.setPlayerLevelVariable(ymlHelper.getString("player-level-variable", this.defaults.getPlayerLevelVariable()));
        dropBase.getPlayeerVariableMatches().addAll((Collection<String>)ymlHelper.getStringOrList("player-variable-match-value"));
        dropBase.setPlayerCausedOnly(ymlHelper.getBoolean("player-caused", this.defaults.getPlayerCausedOnly()));
        dropBase.setMaxDropGroup(ymlHelper.getInt("maxdropgroup", this.defaults.getMaxDropGroup()));
        if (!dropBase.isDefaultDrop()) {
            dropBase.setGroupId(ymlHelper.getString("groupid"));
        }
        if (dropBase.getHasGroupId()) {
            String string = dropBase.getGroupId();
            Intrinsics.checkNotNull(string);
            CustomDropInstance customDropInstance = this.dropInstance;
            Intrinsics.checkNotNull(customDropInstance);
            this.handler.setDropInstanceFromId(string, customDropInstance);
        }
        CustomDropInstance customDropInstance = this.dropInstance;
        Intrinsics.checkNotNull(customDropInstance);
        customDropInstance.setUtilizesGroupIds(dropBase.getHasGroupId());
        this.parseGroupLimits(dropBase, ymlHelper.getCs());
        CharSequence charSequence2 = ymlHelper.getString("amount");
        if (!(charSequence2 == null || charSequence2.length() == 0) && !dropBase.setAmountRangeFromString(ymlHelper.getString("amount"))) {
            charSequence = "Invalid number or number range for amount on %s, %s";
            Object[] objectArray = new Object[2];
            CustomDropInstance customDropInstance2 = this.dropInstance;
            Intrinsics.checkNotNull(customDropInstance2);
            objectArray[0] = customDropInstance2.getMobOrGroupName();
            objectArray[1] = ymlHelper.getString("amount");
            String string = String.format((String)charSequence, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string, "format(...)");
            this.hadError(string);
        }
        SlidingChance overallChance = this.parseSlidingChance(ymlHelper, "overall_chance", null);
        charSequence = ymlHelper.getString("overall_chance");
        if (!(charSequence == null || charSequence.length() == 0 || overallChance != null && overallChance.isDefault())) {
            CustomDropInstance customDropInstance3 = this.dropInstance;
            Intrinsics.checkNotNull(customDropInstance3);
            customDropInstance3.setOverallChance(null);
        }
        if (ymlHelper.getCs().get(YmlParsingHelper.Companion.getKeyNameFromConfig(ymlHelper.getCs(), "overall_permission")) != null) {
            CustomDropInstance customDropInstance4 = this.dropInstance;
            Intrinsics.checkNotNull(customDropInstance4);
            customDropInstance4.getOverallPermissions().addAll((Collection<String>)ymlHelper.getStringSet("overall_permission"));
        }
        dropBase.setCauseOfDeathReqs(this.buildCachedModalListOfDamageCause(ymlHelper, this.defaults.getCauseOfDeathReqs()));
        if (dropBase instanceof CustomCommand) {
            this.parseCustomCommand((CustomCommand)dropBase, ymlHelper);
            return;
        }
        Intrinsics.checkNotNull(dropBase, "null cannot be cast to non-null type io.github.arcaneplugins.levelledmobs.customdrops.CustomDropItem");
        this.parseCustomItem(ymlHelper, (CustomDropItem)dropBase);
    }

    private final SlidingChance parseSlidingChance(YmlParsingHelper ymlHelper, String keyName, SlidingChance defaultValue) {
        Object chanceOptsMap = ymlHelper.getCs().get(keyName);
        ConfigurationSection chanceOpts = null;
        if (chanceOptsMap instanceof LinkedHashMap || chanceOptsMap instanceof MemorySection) {
            chanceOpts = YmlParsingHelper.Companion.objToCS(ymlHelper.getCs(), keyName);
        }
        if (chanceOpts == null) {
            Float parsedValue = ymlHelper.getFloat2(keyName, null);
            if (defaultValue == null && parsedValue == null) {
                return null;
            }
            SlidingChance result = new SlidingChance();
            if (parsedValue != null) {
                result.setChance(parsedValue.floatValue());
            } else {
                result.setFromInstance(defaultValue);
            }
            result.setDefaults(defaultValue);
            return result;
        }
        Map chanceRange = new LinkedHashMap();
        Map map = chanceOpts.getValues(false);
        Intrinsics.checkNotNullExpressionValue(map, "getValues(...)");
        Map values2 = map;
        for (String str : values2.keySet()) {
            Object value = values2.get(str);
            if (str == null || value == null) continue;
            MinAndMax mobLvl = MinAndMax.Companion.setAmountRangeFromString(str);
            MinAndMax assignment = MinAndMax.Companion.setAmountRangeFromString(value.toString());
            if (mobLvl == null || assignment == null) continue;
            mobLvl.setShowAsInt(true);
            chanceRange.put(mobLvl, assignment);
        }
        SlidingChance result = null;
        if (chanceRange.isEmpty()) {
            if (defaultValue == null) {
                return null;
            }
            result = new SlidingChance();
            result.setFromInstance(defaultValue);
        } else {
            result = new SlidingChance();
            result.setFromInstance(defaultValue);
            result.setChangeRange(chanceRange);
        }
        result.setDefaults(defaultValue);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final void parseCustomItem(YmlParsingHelper ymlHelper, CustomDropItem item) {
        Object[] objectArray;
        Object excludes;
        Object object;
        Object object2;
        this.checkEquippedChance(item, ymlHelper);
        this.parseItemFlags(item, ymlHelper);
        item.setOnlyDropIfEquipped(ymlHelper.getBoolean("only-drop-if-equipped", this.defaults.getOnlyDropIfEquipped()));
        item.setEquipOnHelmet(ymlHelper.getBoolean("equip-on-helmet", this.defaults.getEquipOnHelmet()));
        item.setEquipOffhand(ymlHelper.getBoolean("equip-offhand", this.defaults.getEquipOffhand()));
        item.setPriority(ymlHelper.getInt("priority", this.defaults.getPriority()));
        item.setNoMultiplier(ymlHelper.getBoolean("nomultiplier", this.defaults.getNoMultiplier()));
        item.setNoSpawner(ymlHelper.getBoolean("nospawner", this.defaults.getNoSpawner()));
        item.setCustomModelDataId(ymlHelper.getInt("custommodeldata", this.defaults.getCustomModelData()));
        item.setExternalType(ymlHelper.getString("type", this.defaults.getExternalType()));
        item.setExternalAmount(ymlHelper.getDouble2("external-amount", this.defaults.getExternalAmount()));
        item.setMinItems(ymlHelper.getInt("min-items", 1));
        item.setMaxItems(ymlHelper.getInt("max-items", 1));
        item.setAllowedList(ymlHelper.getStringOrList("allowed-list"));
        item.setExcludedList(ymlHelper.getStringOrList("excluded-list"));
        CustomDropInstance customDropInstance = this.dropInstance;
        Intrinsics.checkNotNull(customDropInstance);
        customDropInstance.setOverrideStockDrops(ymlHelper.getBoolean2("override", this.defaults.getOverride()));
        CharSequence charSequence = ymlHelper.getString("damage");
        if (!(charSequence == null || charSequence.length() == 0) && !item.setDamageRangeFromString(ymlHelper.getString("damage"))) {
            object2 = "Invalid number range for damage on %s, %s";
            object = new Object[2];
            CustomDropInstance customDropInstance2 = this.dropInstance;
            Intrinsics.checkNotNull(customDropInstance2);
            object[0] = customDropInstance2.getMobOrGroupName();
            object[1] = ymlHelper.getString("damage");
            String string = String.format((String)object2, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue(string, "format(...)");
            this.hadError(string);
        }
        item.setLore(ymlHelper.getStringOrList("lore"));
        item.setCustomName(ymlHelper.getString("name", item.getCustomName()));
        charSequence = ymlHelper.getString("excludemobs");
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string = ymlHelper.getString("excludemobs");
            Intrinsics.checkNotNull(string);
            object2 = new String[]{";"};
            excludes = StringsKt.split$default((CharSequence)string, (String[])object2, false, 0, 6, null);
            item.getExcludedMobs().clear();
            object2 = excludes.iterator();
            while (object2.hasNext()) {
                void $this$trim$iv;
                Object[] exclude;
                objectArray = exclude = (Object[])object2.next();
                Set<String> set = item.getExcludedMobs();
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                set.add(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
            }
        }
        this.parseEnchantments(this.objectToConfigurationSection2(ymlHelper.getCs(), "enchantments"), item);
        item.setNbtData(ymlHelper.getString("nbt-data", this.defaults.getNbtData()));
        if (item.getMaterial() != Material.AIR && !((excludes = (CharSequence)item.getNbtData()) == null || excludes.length() == 0)) {
            if (ExternalCompatibilityManager.Companion.getHasNbtApiInstalled()) {
                String string = item.getNbtData();
                Intrinsics.checkNotNull(string);
                NBTApplyResult result = NBTManager.INSTANCE.applyNBTDataItem(item, string);
                if (result.getHadException()) {
                    object = "custom drop %s for %s has invalid NBT data: %s";
                    objectArray = new Object[3];
                    objectArray[0] = item.getMaterial();
                    CustomDropInstance customDropInstance3 = this.dropInstance;
                    Intrinsics.checkNotNull(customDropInstance3);
                    objectArray[1] = customDropInstance3.getMobOrGroupName();
                    objectArray[2] = result.getExceptionMessage();
                    Intrinsics.checkNotNullExpressionValue(String.format((String)object, Arrays.copyOf(objectArray, objectArray.length)), "format(...)");
                } else if (result.getItemStack() != null) {
                    item.setItemStack(result.getItemStack());
                    this.dropsUtilizeNBTAPI = true;
                }
            } else if (!this.hasMentionedNBTAPIMissing) {
                this.hadError("NBT Data has been specified in customdrops.yml but required plugin NBTAPI is not installed!");
                this.hasMentionedNBTAPIMissing = true;
            }
        }
        this.applyMetaAttributes(item);
    }

    private final void parseGroupLimits(CustomDropBase base, ConfigurationSection csParent) {
        ConfigurationSection configurationSection = YmlParsingHelper.Companion.objToCS(csParent, "group-limits");
        if (configurationSection == null) {
            return;
        }
        ConfigurationSection cs = configurationSection;
        if (!base.getHasGroupId()) {
            return;
        }
        YmlParsingHelper ymlHelper = new YmlParsingHelper(cs);
        GroupLimits limits = new GroupLimits();
        limits.setCapPerItem(ymlHelper.getInt("cap-per-item"));
        limits.setCapTotal(ymlHelper.getInt("cap-total"));
        limits.setCapEquipped(ymlHelper.getInt("cap-equipped"));
        limits.setCapSelect(ymlHelper.getInt("cap-select"));
        limits.setRetries(ymlHelper.getInt("retries"));
        if (!limits.isEmpty() || base.isDefaultDrop()) {
            Map<String, GroupLimits> map = this.handler.getGroupLimitsMap();
            String string = base.getGroupId();
            Intrinsics.checkNotNull(string);
            map.put(string, limits);
        }
    }

    private final void parseCustomCommand(CustomCommand customCommand, YmlParsingHelper ymlHelper) {
        customCommand.getCommands().addAll((Collection<String>)ymlHelper.getStringOrList("command"));
        customCommand.setCommandName(ymlHelper.getString("name"));
        customCommand.setDelay(ymlHelper.getInt("delay", 0));
        customCommand.setRunOnSpawn(ymlHelper.getBoolean("run-on-spawn", false));
        customCommand.setRunOnDeath(ymlHelper.getBoolean("run-on-death", true));
        customCommand.setMobScale(ymlHelper.getDouble2("mob-scale", null));
        this.parseRangedVariables(customCommand, ymlHelper.getCs());
        if (customCommand.getCommands().isEmpty()) {
            this.hadError("no command was specified for custom command");
        } else {
            CustomDropInstance customDropInstance = this.dropInstance;
            Intrinsics.checkNotNull(customDropInstance);
            customDropInstance.getCustomItems().add(customCommand);
        }
    }

    private final CachedModalList<DeathCause> buildCachedModalListOfDamageCause(YmlParsingHelper ymlHelper, CachedModalList<DeathCause> defaultValue) {
        DeathCause cause;
        boolean match$iv$iv;
        char it;
        int index$iv$iv;
        boolean startFound$iv$iv;
        int endIndex$iv$iv;
        int startIndex$iv$iv;
        boolean $i$f$trim;
        String string;
        boolean match$iv$iv2;
        char it2;
        int index$iv$iv2;
        boolean startFound$iv$iv2;
        int endIndex$iv$iv2;
        int startIndex$iv$iv2;
        String $this$trim$iv;
        String item;
        Object object;
        CachedModalList<DeathCause> cachedModalList = new CachedModalList<DeathCause>();
        String useKeyName = ymlHelper.getKeyNameFromConfig("cause-of-death");
        Object simpleStringOrArray = ymlHelper.getCs().get(useKeyName);
        ConfigurationSection cs2 = null;
        List<Object> useList = null;
        if (simpleStringOrArray instanceof ArrayList) {
            useList = CollectionsKt.toMutableList((ArrayList)simpleStringOrArray);
        } else if (simpleStringOrArray instanceof String) {
            object = new String[]{simpleStringOrArray};
            useList = CollectionsKt.mutableListOf(object);
        }
        if (useList == null) {
            cs2 = YmlParsingHelper.Companion.objToCS(ymlHelper.getCs(), useKeyName);
        }
        if (cs2 == null && useList == null) {
            return defaultValue;
        }
        cachedModalList.setDoMerge(YmlParsingHelper.Companion.getBoolean(cs2, "merge"));
        if (cs2 != null) {
            useList = YmlParsingHelper.Companion.getListFromConfigItem(cs2, "allowed-list");
        }
        List<Object> list = useList;
        Intrinsics.checkNotNull(list);
        object = list.iterator();
        while (object.hasNext()) {
            $this$trim$iv = item = (String)object.next();
            boolean $i$f$trim2 = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim3 = false;
            startIndex$iv$iv2 = 0;
            endIndex$iv$iv2 = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                index$iv$iv2 = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                it2 = $this$trim$iv$iv.charAt(index$iv$iv2);
                boolean bl = false;
                boolean bl2 = match$iv$iv2 = Intrinsics.compare(it2, 32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv2) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv2) break;
                --endIndex$iv$iv2;
            }
            if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString()).length() == 0) continue;
            $this$trim$iv = item;
            string = "*";
            $i$f$trim2 = false;
            $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim3 = false;
            startIndex$iv$iv2 = 0;
            endIndex$iv$iv2 = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                index$iv$iv2 = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                it2 = $this$trim$iv$iv.charAt(index$iv$iv2);
                boolean bl = false;
                boolean bl3 = match$iv$iv2 = Intrinsics.compare(it2, 32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv2) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv2) break;
                --endIndex$iv$iv2;
            }
            if (Intrinsics.areEqual(string, ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString())) {
                cachedModalList.setIncludeAll(true);
                continue;
            }
            try {
                String $this$trim$iv2 = item;
                boolean $i$f$trim4 = false;
                CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv2.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv2.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl4 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                $this$trim$iv2 = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string2 = $this$trim$iv2.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
                cause = DeathCause.valueOf(string2);
                cachedModalList.getIncludedList().add(cause);
            }
            catch (IllegalArgumentException ignored) {
                this.hadError("Invalid damage cause: " + item);
            }
        }
        if (cs2 == null) {
            return cachedModalList;
        }
        object = YmlParsingHelper.Companion.getListFromConfigItem(cs2, "excluded-list").iterator();
        while (object.hasNext()) {
            $this$trim$iv = item = (String)object.next();
            boolean $i$f$trim5 = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim6 = false;
            startIndex$iv$iv2 = 0;
            endIndex$iv$iv2 = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                index$iv$iv2 = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                it2 = $this$trim$iv$iv.charAt(index$iv$iv2);
                boolean bl = false;
                boolean bl5 = match$iv$iv2 = Intrinsics.compare(it2, 32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv2) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv2) break;
                --endIndex$iv$iv2;
            }
            if (((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString()).length() == 0) continue;
            $this$trim$iv = item;
            string = "*";
            $i$f$trim5 = false;
            $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim6 = false;
            startIndex$iv$iv2 = 0;
            endIndex$iv$iv2 = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                index$iv$iv2 = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                it2 = $this$trim$iv$iv.charAt(index$iv$iv2);
                boolean bl = false;
                boolean bl6 = match$iv$iv2 = Intrinsics.compare(it2, 32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv2) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv2) break;
                --endIndex$iv$iv2;
            }
            if (Intrinsics.areEqual(string, ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString())) {
                cachedModalList.setExcludeAll(true);
                continue;
            }
            try {
                String $this$trim$iv3 = item;
                boolean $i$f$trim7 = false;
                CharSequence $this$trim$iv$iv3 = $this$trim$iv3;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv3.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv3.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl7 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                $this$trim$iv3 = ((Object)$this$trim$iv$iv3.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string3 = $this$trim$iv3.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
                cause = DeathCause.valueOf(string3);
                cachedModalList.getExcludedList().add(cause);
            }
            catch (IllegalArgumentException ignored) {
                this.hadError("Invalid damage cause: " + item);
            }
        }
        if (cachedModalList.isEmpty() && !cachedModalList.getIncludeAll() && !cachedModalList.getExcludeAll()) {
            return defaultValue;
        }
        return cachedModalList;
    }

    private final void parseEnchantments(ConfigurationSection cs, CustomDropItem item) {
        if (cs == null) {
            return;
        }
        Map map = cs.getValues(false);
        Intrinsics.checkNotNullExpressionValue(map, "getValues(...)");
        Map enchantMap = map;
        for (Map.Entry entry : enchantMap.entrySet()) {
            String enchantName = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof LinkedHashMap) {
                Intrinsics.checkNotNull(enchantName);
                String string = enchantName;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                Enchantment en = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)string2));
                if (en == null) {
                    this.hadError("Invalid enchantment: " + enchantName);
                    continue;
                }
                Map enchantments = (Map)value;
                this.parseEnchantmentChances(en, enchantments, item);
                continue;
            }
            int enchantLevel = 1;
            if (value != null && Utils.INSTANCE.isInteger(value.toString())) {
                enchantLevel = Integer.parseInt(value.toString());
            }
            Intrinsics.checkNotNull(enchantName);
            String string = enchantName;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            Enchantment en = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKey.minecraft((String)string3));
            if (en != null) {
                if (item.getMaterial() == Material.ENCHANTED_BOOK) {
                    ItemStack itemStack = item.getItemStack();
                    ItemMeta itemMeta = itemStack != null ? itemStack.getItemMeta() : null;
                    Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.EnchantmentStorageMeta");
                    EnchantmentStorageMeta meta = (EnchantmentStorageMeta)itemMeta;
                    meta.addStoredEnchant(en, enchantLevel, true);
                    ItemStack itemStack2 = item.getItemStack();
                    Intrinsics.checkNotNull(itemStack2);
                    itemStack2.setItemMeta((ItemMeta)meta);
                    continue;
                }
                ItemStack itemStack = item.getItemStack();
                Intrinsics.checkNotNull(itemStack);
                itemStack.addUnsafeEnchantment(en, enchantLevel);
                continue;
            }
            this.hadError("Invalid enchantment: " + enchantName);
        }
    }

    private final void parseEnchantmentChances(Enchantment enchantment, Map<Object, ? extends Object> enchantmentsMap, CustomDropItem item) {
        Map items = new LinkedHashMap();
        Integer defaultLevel = null;
        Boolean doShuttle = null;
        for (Map.Entry<Object, ? extends Object> object : enchantmentsMap.entrySet()) {
            Object key = object.getKey();
            Object value = object.getValue();
            if (StringsKt.equals("shuffle", key.toString(), true)) {
                if (!StringsKt.equals("false", value.toString(), true)) continue;
                doShuttle = false;
                continue;
            }
            boolean isDefault = StringsKt.equals(this.defaultName, key.toString(), true);
            int enchantmentLevel = 0;
            if (!isDefault) {
                if (!Utils.INSTANCE.isInteger(key.toString())) {
                    String string = "Enchantment: %s, invalid enchantment level %s";
                    Object[] objectArray = new Object[]{enchantment, key};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                    this.hadError(string2);
                    continue;
                }
                enchantmentLevel = Integer.parseInt(key.toString());
            }
            double chanceValue = 0.0;
            try {
                chanceValue = Double.parseDouble(value.toString());
            }
            catch (Exception ignored) {
                String string = "Enchantment: %s, invalid chance specified: %s";
                Object[] objectArray = new Object[]{enchantment, value};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                this.hadError(string3);
                continue;
            }
            if (isDefault) {
                defaultLevel = (int)chanceValue;
                continue;
            }
            Integer n = enchantmentLevel;
            items.put(n, Float.valueOf((float)chanceValue));
        }
        if (items.isEmpty()) {
            return;
        }
        if (item.getEnchantmentChances() == null) {
            item.setEnchantmentChances(new EnchantmentChances());
        }
        if (doShuttle != null || defaultLevel != null) {
            EnchantmentChances enchantmentChances = item.getEnchantmentChances();
            Intrinsics.checkNotNull(enchantmentChances);
            EnchantmentChances.ChanceOptions chanceOptions = enchantmentChances.getOptions().computeIfAbsent(enchantment, arg_0 -> CustomDropsParser.parseEnchantmentChances$lambda$10(CustomDropsParser::parseEnchantmentChances$lambda$9, arg_0));
            Intrinsics.checkNotNullExpressionValue(chanceOptions, "computeIfAbsent(...)");
            EnchantmentChances.ChanceOptions opts = chanceOptions;
            if (defaultLevel != null) {
                opts.setDefaultLevel(defaultLevel);
            }
            if (doShuttle != null) {
                opts.setDoShuffle(false);
            }
        }
        EnchantmentChances enchantmentChances = item.getEnchantmentChances();
        Intrinsics.checkNotNull(enchantmentChances);
        enchantmentChances.getItems().put(enchantment, items);
    }

    private final void parseRangedVariables(CustomCommand cc, ConfigurationSection cs) {
        for (String key : cs.getKeys(false)) {
            String value;
            CharSequence charSequence;
            Intrinsics.checkNotNull(key);
            String string = key;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            if (!StringsKt.startsWith$default(string2, "ranged", false, 2, null) || (charSequence = (CharSequence)(value = cs.getString(key))) == null || charSequence.length() == 0) continue;
            cc.getRangedEntries().put(key, value);
        }
    }

    private final void applyMetaAttributes(CustomDropItem item) {
        ItemStack itemStack = item.getItemStack();
        Intrinsics.checkNotNull(itemStack);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        ItemMeta meta = itemMeta;
        boolean madeChanges = false;
        if (item.getCustomModelDataId() != this.defaults.getCustomModelData()) {
            meta.setCustomModelData(Integer.valueOf(item.getCustomModelDataId()));
            ItemStack itemStack2 = item.getItemStack();
            Intrinsics.checkNotNull(itemStack2);
            itemStack2.setItemMeta(meta);
            madeChanges = true;
        }
        if (item.getItemFlags() != null) {
            List<ItemFlag> list = item.getItemFlags();
            Intrinsics.checkNotNull(list);
            if (!((Collection)list).isEmpty()) {
                List<ItemFlag> list2 = item.getItemFlags();
                Intrinsics.checkNotNull(list2);
                for (ItemFlag flag : list2) {
                    ItemFlag[] itemFlagArray = new ItemFlag[]{flag};
                    meta.addItemFlags(itemFlagArray);
                }
                madeChanges = true;
            }
        }
        if (madeChanges) {
            ItemStack itemStack3 = item.getItemStack();
            Intrinsics.checkNotNull(itemStack3);
            itemStack3.setItemMeta(meta);
        }
    }

    private final void parseItemFlags(CustomDropItem item, YmlParsingHelper ymlHelper) {
        List list;
        CharSequence charSequence;
        item.setItemFlagsStrings(ymlHelper.getStringList("item_flags"));
        List<String> list2 = item.getItemFlagsStrings();
        Intrinsics.checkNotNull(list2);
        if (list2.isEmpty() && this.defaults.getItemFlagsStrings() != null) {
            item.setItemFlagsStrings(this.defaults.getItemFlagsStrings());
        }
        String itemFlags = null;
        List<String> list3 = item.getItemFlagsStrings();
        Intrinsics.checkNotNull(list3);
        if (list3.isEmpty()) {
            itemFlags = ymlHelper.getString("itemflags");
            charSequence = itemFlags;
            if (charSequence == null || charSequence.length() == 0) {
                itemFlags = ymlHelper.getString("item_flags");
            }
            if ((charSequence = (CharSequence)itemFlags) == null || charSequence.length() == 0) {
                itemFlags = ymlHelper.getString("item-flags");
            }
        }
        List<String> list4 = item.getItemFlagsStrings();
        Intrinsics.checkNotNull(list4);
        if (list4.isEmpty() && ((charSequence = (CharSequence)itemFlags) == null || charSequence.length() == 0)) {
            return;
        }
        List results = new ArrayList();
        List<String> list5 = item.getItemFlagsStrings();
        Intrinsics.checkNotNull(list5);
        if (list5.isEmpty()) {
            String string = itemFlags;
            Intrinsics.checkNotNull(string);
            String[] stringArray = new String[]{";"};
            List list6 = StringsKt.split$default((CharSequence)StringsKt.replace$default(string, ",", ";", false, 4, null), stringArray, false, 0, 6, null);
            Intrinsics.checkNotNull(list6, "null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.String>");
            list = TypeIntrinsics.asMutableList(list6);
        } else {
            list = item.getItemFlagsStrings();
        }
        item.setItemFlagsStrings(list);
        List<String> list7 = item.getItemFlagsStrings();
        Intrinsics.checkNotNull(list7);
        for (String flag : list7) {
            try {
                String $this$trim$iv = flag;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string = $this$trim$iv.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                ItemFlag newFlag = ItemFlag.valueOf((String)string);
                results.add(newFlag);
            }
            catch (Exception e) {
                String string = "Invalid itemflag: %s, item: %s, mobOrGroup: %s";
                Object[] objectArray = new Object[3];
                objectArray[0] = flag;
                objectArray[1] = item.getMaterial().name();
                CustomDropInstance customDropInstance = this.dropInstance;
                Intrinsics.checkNotNull(customDropInstance);
                objectArray[2] = customDropInstance.getMobOrGroupName();
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                this.hadError(string2);
            }
        }
        if (!((Collection)results).isEmpty()) {
            item.setItemFlags(results);
        }
    }

    private final void checkEquippedChance(CustomDropItem item, YmlParsingHelper ymlHelper) {
        String temp;
        CharSequence charSequence;
        block8: {
            block7: {
                item.setEquippedChance(this.parseSlidingChance(ymlHelper, "equipped", this.defaults.getEquippedChance()));
                if (this.defaults.getEquippedChance() == null) break block7;
                if (item.getEquippedChance() == null) break block8;
                SlidingChance slidingChance = item.getEquippedChance();
                Intrinsics.checkNotNull(slidingChance);
                if (slidingChance.isDefault()) break block8;
            }
            return;
        }
        if ((charSequence = (CharSequence)(temp = ymlHelper.getString("equipped"))) == null || charSequence.length() == 0) {
            return;
        }
        if (StringsKt.equals("false", temp, true)) {
            SlidingChance slidingChance = item.getEquippedChance();
            Intrinsics.checkNotNull(slidingChance);
            slidingChance.setChance(0.0f);
        } else if (StringsKt.equals("true", temp, true)) {
            SlidingChance slidingChance = item.getEquippedChance();
            Intrinsics.checkNotNull(slidingChance);
            slidingChance.setChance(1.0f);
        }
    }

    private final ConfigurationSection objectToConfigurationSection2(ConfigurationSection cs, String path) {
        if (cs == null) {
            return null;
        }
        String useKey = YmlParsingHelper.Companion.getKeyNameFromConfig(cs, path);
        Object object = cs.get(useKey);
        if (object == null) {
            return null;
        }
        Object obj = object;
        Object object2 = obj;
        if (object2 instanceof ConfigurationSection) {
            return (ConfigurationSection)obj;
        }
        if (object2 instanceof Map) {
            MemoryConfiguration result = new MemoryConfiguration();
            result.addDefaults((Map)obj);
            return result.getDefaultSection();
        }
        CharSequence charSequence = cs.getCurrentPath();
        String currentPath = charSequence == null || charSequence.length() == 0 ? path : cs.getCurrentPath() + "." + path;
        String string = "%s: couldn't parse Config of type: %s, value: %s";
        Object[] objectArray = new Object[]{currentPath, obj.getClass().getSimpleName(), obj};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        this.hadError(string2);
        return null;
    }

    private final ConfigurationSection objectToConfigurationSectionOld(Object obj) {
        if (obj == null) {
            return null;
        }
        Object object = obj;
        if (object instanceof ConfigurationSection) {
            return (ConfigurationSection)obj;
        }
        if (object instanceof Map) {
            MemoryConfiguration result = new MemoryConfiguration();
            result.addDefaults((Map)obj);
            return result.getDefaultSection();
        }
        this.hadError("couldn't parse Config of type: " + obj.getClass().getSimpleName() + ", value: " + obj);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean addMaterialToDrop(String materialName, CustomDropItem item) {
        block8: {
            String useMaterialName = materialName;
            useMaterialName = Utils.INSTANCE.replaceEx(useMaterialName, "mob_head", "player_head");
            if (StringsKt.contains$default((CharSequence)(useMaterialName = Utils.INSTANCE.replaceEx(useMaterialName, "mobhead", "player_head")), ":", false, 2, null)) {
                if (ExternalCompatibilityManager.Companion.getInstance().doesLMIMeetVersionRequirement()) {
                    LMItemsParser lMItemsParser = this.handler.getLmItemsParser();
                    Intrinsics.checkNotNull(lMItemsParser);
                    if (!lMItemsParser.parseExternalItemAttributes(useMaterialName, item)) {
                        return false;
                    }
                    break block8;
                } else {
                    if (ExternalCompatibilityManager.Companion.getHasLMItemsInstalled()) {
                        this.hadError("Custom drop '" + useMaterialName + "' requires plugin LM_Items but it is an old version");
                        return false;
                    }
                    this.hadError("Custom drop '" + useMaterialName + "' requires plugin LM_Items but it is not installed");
                    return false;
                }
            }
            Material material = null;
            if (StringsKt.equals("override", useMaterialName, true)) {
                CustomDropInstance customDropInstance = this.dropInstance;
                Intrinsics.checkNotNull(customDropInstance);
                customDropInstance.setOverrideStockDrops(true);
                return true;
            }
            try {
                String string = useMaterialName;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string2 = string.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
                material = Material.valueOf((String)string2);
            }
            catch (Exception e) {
                String string = "Invalid material type specified in customdrops.yml for: %s, %s";
                Object[] objectArray = new Object[2];
                CustomDropInstance customDropInstance = this.dropInstance;
                Intrinsics.checkNotNull(customDropInstance);
                objectArray[0] = customDropInstance.getMobOrGroupName();
                objectArray[1] = useMaterialName;
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                this.hadError(string3);
                return false;
            }
            item.setMaterial(material);
        }
        CustomDropInstance customDropInstance = this.dropInstance;
        Intrinsics.checkNotNull(customDropInstance);
        customDropInstance.getCustomItems().add(item);
        return true;
    }

    private final boolean checkForMobOverride(Map.Entry<String, ? extends Object> itemEntry) {
        Object value;
        if (StringsKt.equals(itemEntry.getKey(), "override", true) && Intrinsics.areEqual((value = itemEntry.getValue()).getClass(), Boolean.TYPE)) {
            CustomDropInstance customDropInstance = this.dropInstance;
            Intrinsics.checkNotNull(customDropInstance);
            Intrinsics.checkNotNull(value, "null cannot be cast to non-null type kotlin.Boolean");
            customDropInstance.setOverrideStockDrops((Boolean)value);
            return true;
        }
        return false;
    }

    public final void showCustomDropsDebugInfo(@Nullable CommandSender sender) {
        StringBuilder sbMain = new StringBuilder();
        int dropsCount = 0;
        int commandsCount = 0;
        for (CustomDropInstance cdi : this.handler.getCustomDropsitems().values()) {
            for (CustomDropBase customDropBase : cdi.getCustomItems()) {
                if (customDropBase instanceof CustomDropItem) {
                    ++dropsCount;
                    continue;
                }
                if (!(customDropBase instanceof CustomCommand)) continue;
                ++commandsCount;
            }
        }
        Map<String, CustomDropInstance> allGroups = this.handler.getCustomDropsitemsGroups();
        int itemsCount = allGroups.size() + this.handler.getCustomDropsitemsBabies().size();
        int customItemGroupCount = this.handler.getCustomItemGroups().size();
        sbMain.append("drop instances: " + this.handler.getCustomDropsitems().size() + ", custom groups: " + itemsCount + ", item groups: " + customItemGroupCount + ", items: " + dropsCount + ", commands: " + commandsCount);
        for (String msg : this.invalidExternalItems) {
            sbMain.append("\n&4").append(msg).append("&r");
        }
        SortedMap sortedMap = new TreeMap();
        for (EntityType entityType : this.handler.getCustomDropsitems().keySet()) {
            ((Map)sortedMap).put(entityType.toString(), entityType);
        }
        for (EntityType entityType : this.handler.getCustomDropsitemsBabies().keySet()) {
            ((Map)sortedMap).put(entityType + "_2", entityType);
        }
        for (String string : sortedMap.keySet()) {
            CustomDropInstance customDropInstance;
            String string2;
            Intrinsics.checkNotNull(string);
            boolean isBaby = StringsKt.endsWith$default(string, "_2", false, 2, null);
            if (isBaby) {
                String string3 = string.substring(0, string.length() - 2);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            } else {
                string2 = string;
            }
            String string4 = string2;
            Intrinsics.checkNotNull(string4);
            EntityType ent = EntityType.valueOf((String)string4);
            if (isBaby) {
                CustomDropInstance customDropInstance2 = this.handler.getCustomDropsitemsBabies().get(ent);
                Intrinsics.checkNotNull(customDropInstance2);
                customDropInstance = customDropInstance2;
            } else {
                CustomDropInstance customDropInstance3 = this.handler.getCustomDropsitems().get(ent);
                Intrinsics.checkNotNull(customDropInstance3);
                customDropInstance = customDropInstance3;
            }
            CustomDropInstance dropInstance = customDropInstance;
            String override = dropInstance.getGetOverrideStockDrops() ? " (override)" : "";
            String overallChance = dropInstance.getOverallChance() != null ? " (overall_chance: " + dropInstance.getOverallChance() + ")" : "";
            sbMain.append("\nmob: &b");
            if (isBaby) {
                sbMain.append("(baby) ");
            }
            sbMain.append(ent.name()).append("&r");
            sbMain.append(override).append(overallChance);
            if (!((Collection)dropInstance.getOverallPermissions()).isEmpty()) {
                sbMain.append(" (overall perms: ");
                sbMain.append(dropInstance.getOverallPermissions()).append(")");
            }
            for (CustomDropBase baseItem : dropInstance.getCustomItems()) {
                String result = this.showCustomDropsDebugInfo2(baseItem);
                if (!(((CharSequence)result).length() > 0)) continue;
                sbMain.append("\n").append(result);
            }
        }
        for (Map.Entry entry : allGroups.entrySet()) {
            String key = (String)entry.getKey();
            CustomDropInstance value = (CustomDropInstance)entry.getValue();
            String override = value.getGetOverrideStockDrops() ? " (override)" : "";
            String overallChance = value.getOverallChance() != null ? " (overall_chance: " + value.getOverallChance() + ")" : "";
            if (((CharSequence)sbMain).length() > 0) {
                sbMain.append("\n");
            }
            sbMain.append("group: ").append(key);
            sbMain.append(override).append(overallChance);
            for (CustomDropBase baseItem : value.getCustomItems()) {
                String result = this.showCustomDropsDebugInfo2(baseItem);
                if (!(((CharSequence)result).length() > 0)) continue;
                sbMain.append("\n").append(result);
            }
        }
        if (sender != null) {
            sender.sendMessage(MessageUtils.INSTANCE.colorizeAll(sbMain.toString()));
        } else {
            Log.INSTANCE.inf(sbMain.toString());
        }
    }

    private final String showCustomDropsDebugInfo2(CustomDropBase baseItem) {
        CharSequence itemMaterial;
        CustomCommand command = baseItem instanceof CustomCommand ? (CustomCommand)baseItem : null;
        CustomDropItem item = baseItem instanceof CustomDropItem ? (CustomDropItem)baseItem : null;
        StringBuilder sb = new StringBuilder();
        if (item != null) {
            itemMaterial = item.getMaterial().toString();
            var7_6 = "  &b%s&r, amount: &b%s&r, chance: &b%s&r";
            Object[] objectArray = new Object[]{itemMaterial, item.getAmountAsString(), baseItem.getChance()};
            String string = String.format((String)var7_6, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string, "format(...)");
            sb.append(string);
        } else if (baseItem instanceof CustomCommand) {
            String string = "  COMMAND, chance: &b%s&r, run-on-spawn: %s, run-on-death: %s";
            var7_6 = new Object[]{baseItem.getChance(), ((CustomCommand)baseItem).getRunOnSpawn(), ((CustomCommand)baseItem).getRunOnDeath()};
            String string2 = String.format(string, Arrays.copyOf(var7_6, ((Object[])var7_6).length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            sb.append(string2);
        }
        if (baseItem.getMinLevel() > -1) {
            sb.append(", minL: &b");
            sb.append(baseItem.getMinLevel()).append("&r");
        }
        if (baseItem.getMaxLevel() > -1) {
            sb.append(", maxL: &b");
            sb.append(baseItem.getMaxLevel()).append("&r");
        }
        if (baseItem.getMinPlayerLevel() > -1) {
            sb.append(", minPL: &b");
            sb.append(baseItem.getMinPlayerLevel()).append("&r");
        }
        if (baseItem.getMaxPlayerLevel() > -1) {
            sb.append(", maxPL: &b");
            sb.append(baseItem.getMaxPlayerLevel()).append("&r");
        }
        if (!((Collection)baseItem.getPermissions()).isEmpty()) {
            sb.append(", perms: &b");
            sb.append(baseItem.getPermissions()).append("&r");
        }
        if (baseItem.getNoSpawner()) {
            sb.append(", nospn");
        }
        if (baseItem.getCauseOfDeathReqs() != null) {
            sb.append(", ").append(baseItem.getCauseOfDeathReqs());
        }
        if (baseItem.getHasGroupId()) {
            sb.append(", gId: &b");
            sb.append(baseItem.getGroupId()).append("&r");
            if (baseItem.getMaxDropGroup() > 0 && !this.handler.getGroupLimitsMap().containsKey(baseItem.getGroupId())) {
                sb.append(", maxDropGroup: &b");
                sb.append(baseItem.getMaxDropGroup()).append("&r");
            }
        }
        if (baseItem.getPriority() > 0) {
            sb.append(", pri: &b");
            sb.append(baseItem.getPriority()).append("&r");
        }
        if (command != null) {
            itemMaterial = command.getCommandName();
            if (!(itemMaterial == null || itemMaterial.length() == 0)) {
                sb.append(", name: &b");
                sb.append(command.getCommandName()).append("&r");
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }
        if (item == null) {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }
        if (item.getNoMultiplier()) {
            sb.append(", nomultp");
        }
        if (item.getLore() != null) {
            List<String> list = item.getLore();
            Intrinsics.checkNotNull(list);
            if (!((Collection)list).isEmpty()) {
                sb.append(", hasLore");
            }
        }
        if (item.getCustomName() != null) {
            String string = item.getCustomName();
            Intrinsics.checkNotNull(string);
            if (((CharSequence)string).length() > 0) {
                sb.append(", hasName");
            }
        }
        if (item.getDamage() != 0 || item.getHasDamageRange()) {
            sb.append(", dmg: &b");
            sb.append(item.getDamageAsString()).append("&r");
        }
        if (!((Collection)item.getExcludedMobs()).isEmpty()) {
            sb.append(", hasExcludes");
        }
        if (item.getEquippedChance() != null) {
            SlidingChance slidingChance = item.getEquippedChance();
            Intrinsics.checkNotNull(slidingChance);
            if (!slidingChance.isDefault()) {
                sb.append(", equipChance: &b");
                sb.append(item.getEquippedChance()).append("&r");
            }
        }
        if (item.getOnlyDropIfEquipped()) {
            sb.append(", &bonlyDropIfEquipped&r");
        }
        if (item.getEquipOnHelmet()) {
            sb.append(", &bequipHelmet&r");
        }
        if (item.getItemFlags() != null) {
            List<ItemFlag> list = item.getItemFlags();
            Intrinsics.checkNotNull(list);
            if (!((Collection)list).isEmpty()) {
                sb.append(", itemflags: &b");
                List<ItemFlag> list2 = item.getItemFlags();
                Intrinsics.checkNotNull(list2);
                sb.append(list2.size()).append("&r");
            }
        }
        if (item.isExternalItem()) {
            sb.append(", ext: ");
            sb.append(item.getExternalPluginName());
            if (item.getExternalType() != null) {
                sb.append(", ex-type: ");
                sb.append(item.getExternalType());
            }
            if (item.getExternalItemId() != null) {
                sb.append(", ex-id: ");
                sb.append(item.getExternalItemId());
            }
            if (item.getExternalAmount() != null) {
                sb.append(", ex-amt: ");
                sb.append(item.getExternalAmount());
            }
            if (item.getExternalExtras() != null) {
                sb.append(", ex-xtras: ");
                Map<String, Object> map = item.getExternalExtras();
                Intrinsics.checkNotNull(map);
                sb.append(map.size());
            }
        }
        if (item.getEnchantmentChances() != null) {
            EnchantmentChances enchantmentChances = item.getEnchantmentChances();
            Intrinsics.checkNotNull(enchantmentChances);
            if (!enchantmentChances.isEmpty()) {
                StringBuilder enchantmentLevels = new StringBuilder();
                enchantmentLevels.append("encht-lvls: ");
                EnchantmentChances enchantmentChances2 = item.getEnchantmentChances();
                Intrinsics.checkNotNull(enchantmentChances2);
                for (Enchantment enchantment : enchantmentChances2.getItems().keySet()) {
                    EnchantmentChances.ChanceOptions opts;
                    if (enchantmentLevels.length() > 12) {
                        enchantmentLevels.append("; ");
                    }
                    enchantmentLevels.append("&b");
                    enchantmentLevels.append(enchantment.getKey().value());
                    enchantmentLevels.append("&r: ");
                    boolean isFirst = true;
                    EnchantmentChances enchantmentChances3 = item.getEnchantmentChances();
                    Intrinsics.checkNotNull(enchantmentChances3);
                    Map<Integer, Float> map = enchantmentChances3.getItems().get(enchantment);
                    Set<Map.Entry<Integer, Float>> set = map != null ? map.entrySet() : null;
                    Intrinsics.checkNotNull(set);
                    for (Map.Entry<Integer, Float> object : set) {
                        int key = ((Number)object.getKey()).intValue();
                        float value = ((Number)object.getValue()).floatValue();
                        if (!isFirst) {
                            enchantmentLevels.append(", ");
                        }
                        enchantmentLevels.append(key + "-&b" + value + "&r");
                        isFirst = false;
                    }
                    EnchantmentChances enchantmentChances4 = item.getEnchantmentChances();
                    Intrinsics.checkNotNull(enchantmentChances4);
                    if (!enchantmentChances4.getOptions().containsKey(enchantment)) continue;
                    EnchantmentChances enchantmentChances5 = item.getEnchantmentChances();
                    Intrinsics.checkNotNull(enchantmentChances5);
                    EnchantmentChances.ChanceOptions chanceOptions = opts = enchantmentChances5.getOptions().get(enchantment);
                    Intrinsics.checkNotNull(chanceOptions);
                    if (chanceOptions.getDefaultLevel() != null) {
                        enchantmentLevels.append(", dflt: ").append(opts.getDefaultLevel());
                    }
                    if (opts.getDoShuffle()) continue;
                    enchantmentLevels.append(", no shfl");
                }
                sb.append(System.lineSeparator());
                sb.append("    ");
                sb.append((CharSequence)enchantmentLevels);
            }
        }
        if (item.getItemStack() != null) {
            ItemStack itemStack = item.getItemStack();
            Intrinsics.checkNotNull(itemStack);
            ItemMeta meta = itemStack.getItemMeta();
            StringBuilder sb2 = new StringBuilder();
            if (meta != null) {
                for (Enchantment enchant : meta.getEnchants().keySet()) {
                    if (((CharSequence)sb2).length() > 0) {
                        sb2.append(", ");
                    }
                    String string = "&b%s&r (%s)";
                    Object[] objectArray = new Object[2];
                    objectArray[0] = enchant.getKey().getKey();
                    ItemStack itemStack2 = item.getItemStack();
                    Intrinsics.checkNotNull(itemStack2);
                    objectArray[1] = itemStack2.getItemMeta().getEnchants().get(enchant);
                    String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                    sb2.append(string3);
                }
            }
            if (((CharSequence)sb2).length() > 0) {
                sb.append("\n    ").append((CharSequence)sb2);
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private static final String loadDrops$lambda$0(CustomDropsParser this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "Group Limits: " + this$0.handler.getGroupLimitsMap();
    }

    private static final EnchantmentChances.ChanceOptions parseEnchantmentChances$lambda$9(Enchantment enchantment) {
        Intrinsics.checkNotNullParameter(enchantment, "<unused var>");
        return new EnchantmentChances.ChanceOptions();
    }

    private static final EnchantmentChances.ChanceOptions parseEnchantmentChances$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (EnchantmentChances.ChanceOptions)$tmp0.invoke(p0);
    }
}

