/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.customdrops;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomCommand;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropBase;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropInstance;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropItem;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropProcessingInfo;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropResult;
import io.github.arcaneplugins.levelledmobs.customdrops.CustomDropsParser;
import io.github.arcaneplugins.levelledmobs.customdrops.EnchantmentChances;
import io.github.arcaneplugins.levelledmobs.customdrops.EquippedItemsInfo;
import io.github.arcaneplugins.levelledmobs.customdrops.ExternalCustomDrops;
import io.github.arcaneplugins.levelledmobs.customdrops.ExternalCustomDropsImpl;
import io.github.arcaneplugins.levelledmobs.customdrops.GroupLimits;
import io.github.arcaneplugins.levelledmobs.customdrops.LMItemsParser;
import io.github.arcaneplugins.levelledmobs.customdrops.SlidingChance;
import io.github.arcaneplugins.levelledmobs.debug.DebugManager;
import io.github.arcaneplugins.levelledmobs.debug.DebugType;
import io.github.arcaneplugins.levelledmobs.enums.Addition;
import io.github.arcaneplugins.levelledmobs.enums.DeathCause;
import io.github.arcaneplugins.levelledmobs.enums.DropInstanceBuildResult;
import io.github.arcaneplugins.levelledmobs.enums.LevelledMobSpawnReason;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.Nullable;
import io.github.arcaneplugins.levelledmobs.managers.ExternalCompatibilityManager;
import io.github.arcaneplugins.levelledmobs.managers.LevelManager;
import io.github.arcaneplugins.levelledmobs.misc.CachedModalList;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.result.PlayerLevelSourceResult;
import io.github.arcaneplugins.levelledmobs.rules.CustomDropsRuleSet;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.PaperUtils;
import io.github.arcaneplugins.levelledmobs.util.SpigotUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020%J\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u0005J\u0016\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0007J\u0016\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u0007J$\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u00105\u001a\u000206J&\u00107\u001a\u0002082\f\u00109\u001a\b\u0012\u0004\u0012\u00020\f032\u0006\u0010*\u001a\u00020\u00062\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u0002062\u0006\u0010:\u001a\u00020;H\u0002J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\f032\u0006\u0010>\u001a\u00020;H\u0002J\u0018\u0010?\u001a\u00020%2\u0006\u0010@\u001a\u00020A2\u0006\u0010>\u001a\u00020;H\u0002J\u0010\u0010B\u001a\u00020%2\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010C\u001a\u00020%2\u0006\u0010:\u001a\u00020;2\u0006\u0010D\u001a\u00020AH\u0002J\u0018\u0010E\u001a\u0002062\u0006\u0010:\u001a\u00020;2\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u0002062\u0006\u0010:\u001a\u00020;H\u0002J \u0010I\u001a\u00020%2\u0006\u0010F\u001a\u00020G2\u0006\u0010J\u001a\u0002042\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010K\u001a\u0002062\u0006\u00100\u001a\u000201H\u0002J\u0018\u0010L\u001a\u0002062\u0006\u0010D\u001a\u00020A2\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010M\u001a\u0002062\u0006\u0010:\u001a\u00020;2\u0006\u0010D\u001a\u00020AH\u0002J\u0018\u0010N\u001a\u0002062\u0006\u0010:\u001a\u00020;2\u0006\u0010O\u001a\u00020GH\u0002J\u0018\u0010P\u001a\u0002062\u0006\u0010:\u001a\u00020;2\u0006\u0010Q\u001a\u00020GH\u0002J\u0018\u0010R\u001a\u0002062\u0006\u0010:\u001a\u00020;2\u0006\u0010D\u001a\u00020AH\u0002J\u0018\u0010S\u001a\u00020%2\u0006\u0010T\u001a\u00020U2\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u0010V\u001a\u00020%2\u0006\u0010W\u001a\u00020\f2\u0006\u0010X\u001a\u00020YH\u0002J\u0018\u0010Z\u001a\u00020\f2\u0006\u0010W\u001a\u00020\f2\u0006\u0010[\u001a\u00020UH\u0002J\u0010\u0010\\\u001a\u0002042\u0006\u0010J\u001a\u000204H\u0002J\u0016\u0010]\u001a\u00020%2\u0006\u0010^\u001a\u00020\f2\u0006\u0010_\u001a\u00020\u0007J\u0010\u0010`\u001a\u0004\u0018\u00010\u00152\u0006\u0010D\u001a\u00020AJ\u0006\u0010a\u001a\u00020%R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00150\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\"\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u001f\u001a\u0004\u0018\u00010 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006b"}, d2={"Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsHandler;", "", "<init>", "()V", "customDropsitems", "", "Lorg/bukkit/entity/EntityType;", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropInstance;", "customDropsitemsBabies", "getCustomDropsitemsBabies", "()Ljava/util/Map;", "customDropsitemsGroups", "", "customDropIDs", "getCustomDropIDs", "groupIdToInstance", "customItemGroups", "getCustomItemGroups", "setCustomItemGroups", "(Ljava/util/Map;)V", "groupLimitsMap", "Lio/github/arcaneplugins/levelledmobs/customdrops/GroupLimits;", "getGroupLimitsMap", "customDropsParser", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsParser;", "getCustomDropsParser", "()Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsParser;", "externalCustomDrops", "Lio/github/arcaneplugins/levelledmobs/customdrops/ExternalCustomDrops;", "getExternalCustomDrops", "()Lio/github/arcaneplugins/levelledmobs/customdrops/ExternalCustomDrops;", "value", "Lio/github/arcaneplugins/levelledmobs/customdrops/LMItemsParser;", "lmItemsParser", "getLmItemsParser", "()Lio/github/arcaneplugins/levelledmobs/customdrops/LMItemsParser;", "load", "", "clearDrops", "getCustomDropsitems", "getCustomDropsitemsGroups", "addCustomDropItem", "entityType", "customDropInstance", "addCustomDropGroup", "groupName", "getCustomItemDrops", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropResult;", "lmEntity", "Lio/github/arcaneplugins/levelledmobs/wrappers/LivingEntityWrapper;", "drops", "", "Lorg/bukkit/inventory/ItemStack;", "equippedOnly", "", "buildDropsListFromGroupsAndEntity", "Lio/github/arcaneplugins/levelledmobs/enums/DropInstanceBuildResult;", "groups", "info", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropProcessingInfo;", "checkOverallPermissions", "getDropIds", "processingInfo", "processDropPriorities", "baseItem", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropBase;", "getCustomItemsFromDropInstance", "getDropsFromCustomDropItem", "dropBase", "checkEquippedChances", "dropItem", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomDropItem;", "checkOverallChance", "processEnchantmentChances", "itemStack", "hasReachedChunkKillLimit", "shouldDenyDeathCause", "checkDropPermissions", "checkIfMadeEquippedDropChance", "item", "isMobWearingItem", "customDropItem", "madePlayerLevelRequirement", "executeCommand", "customCommand", "Lio/github/arcaneplugins/levelledmobs/customdrops/CustomCommand;", "executeTheCommand", "command", "timesToRun", "", "processRangedCommand", "cc", "getCookedVariantOfMeat", "setDropInstanceFromId", "groupId", "dropInstance", "getGroupLimits", "clearGroupIdMappings", "levelledmobs-plugin"})
@SourceDebugExtension(value={"SMAP\nCustomDropsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomDropsHandler.kt\nio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsHandler\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1419:1\n108#2:1420\n80#2,22:1421\n108#2:1454\n80#2,22:1455\n108#2:1477\n80#2,22:1478\n108#2:1500\n80#2,22:1501\n108#2:1523\n80#2,22:1524\n739#3,9:1443\n37#4,2:1452\n*S KotlinDebug\n*F\n+ 1 CustomDropsHandler.kt\nio/github/arcaneplugins/levelledmobs/customdrops/CustomDropsHandler\n*L\n299#1:1420\n299#1:1421,22\n1371#1:1454\n1371#1:1455,22\n1372#1:1477\n1372#1:1478,22\n1376#1:1500\n1376#1:1501,22\n1377#1:1523\n1377#1:1524,22\n1366#1:1443,9\n1366#1:1452,2\n*E\n"})
public final class CustomDropsHandler {
    @NotNull
    private final Map<EntityType, CustomDropInstance> customDropsitems = new LinkedHashMap();
    @NotNull
    private final Map<EntityType, CustomDropInstance> customDropsitemsBabies = new LinkedHashMap();
    @NotNull
    private final Map<String, CustomDropInstance> customDropsitemsGroups = new LinkedHashMap();
    @NotNull
    private final Map<String, CustomDropInstance> customDropIDs = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
    @NotNull
    private final Map<String, CustomDropInstance> groupIdToInstance = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
    @NotNull
    private Map<String, CustomDropInstance> customItemGroups = new LinkedHashMap();
    @NotNull
    private final Map<String, GroupLimits> groupLimitsMap = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
    @NotNull
    private final CustomDropsParser customDropsParser = new CustomDropsParser(this);
    @NotNull
    private final ExternalCustomDrops externalCustomDrops = new ExternalCustomDropsImpl();
    @Nullable
    private LMItemsParser lmItemsParser;

    @NotNull
    public final Map<EntityType, CustomDropInstance> getCustomDropsitemsBabies() {
        return this.customDropsitemsBabies;
    }

    @NotNull
    public final Map<String, CustomDropInstance> getCustomDropIDs() {
        return this.customDropIDs;
    }

    @NotNull
    public final Map<String, CustomDropInstance> getCustomItemGroups() {
        return this.customItemGroups;
    }

    public final void setCustomItemGroups(@NotNull Map<String, CustomDropInstance> map) {
        Intrinsics.checkNotNullParameter(map, "<set-?>");
        this.customItemGroups = map;
    }

    @NotNull
    public final Map<String, GroupLimits> getGroupLimitsMap() {
        return this.groupLimitsMap;
    }

    @NotNull
    public final CustomDropsParser getCustomDropsParser() {
        return this.customDropsParser;
    }

    @NotNull
    public final ExternalCustomDrops getExternalCustomDrops() {
        return this.externalCustomDrops;
    }

    @Nullable
    public final LMItemsParser getLmItemsParser() {
        return this.lmItemsParser;
    }

    public final void load() {
        if (ExternalCompatibilityManager.Companion.getInstance().doesLMIMeetVersionRequirement()) {
            this.lmItemsParser = new LMItemsParser();
        }
    }

    public final void clearDrops() {
        this.customDropsitems.clear();
        this.customDropsitemsBabies.clear();
        this.customDropsitemsGroups.clear();
        this.customDropIDs.clear();
        this.groupIdToInstance.clear();
        this.customItemGroups.clear();
        this.groupLimitsMap.clear();
    }

    @NotNull
    public final Map<EntityType, CustomDropInstance> getCustomDropsitems() {
        Map drops = new LinkedHashMap();
        drops.putAll(this.customDropsitems);
        for (EntityType entityType : this.externalCustomDrops.getCustomDrops().keySet()) {
            CustomDropInstance currentDropInstance;
            CustomDropInstance dropInstance;
            Intrinsics.checkNotNull(this.externalCustomDrops.getCustomDrops().get(entityType));
            if (!drops.containsKey(entityType)) {
                drops.put(entityType, dropInstance);
                continue;
            }
            CustomDropInstance customDropInstance = currentDropInstance = (CustomDropInstance)drops.get(entityType);
            Intrinsics.checkNotNull(customDropInstance);
            customDropInstance.combineDrop(dropInstance);
            if (dropInstance.getOverallChance() != null) {
                currentDropInstance.setOverallChance(dropInstance.getOverallChance());
            }
            currentDropInstance.getOverallPermissions().addAll((Collection<String>)dropInstance.getOverallPermissions());
        }
        return drops;
    }

    @NotNull
    public final Map<String, CustomDropInstance> getCustomDropsitemsGroups() {
        Map drops = new LinkedHashMap();
        drops.putAll(this.customItemGroups);
        drops.putAll(this.customDropsitemsGroups);
        for (String groupName : this.externalCustomDrops.getCustomDropTables().keySet()) {
            CustomDropInstance currentDropInstance;
            CustomDropInstance dropInstance;
            Intrinsics.checkNotNull(this.externalCustomDrops.getCustomDropTables().get(groupName));
            if (!drops.containsKey(groupName)) {
                drops.put(groupName, dropInstance);
                continue;
            }
            CustomDropInstance customDropInstance = currentDropInstance = (CustomDropInstance)drops.get(groupName);
            Intrinsics.checkNotNull(customDropInstance);
            customDropInstance.combineDrop(dropInstance);
            if (dropInstance.getOverallChance() != null) {
                currentDropInstance.setOverallChance(dropInstance.getOverallChance());
            }
            currentDropInstance.getOverallPermissions().addAll((Collection<String>)dropInstance.getOverallPermissions());
        }
        return drops;
    }

    public final void addCustomDropItem(@NotNull EntityType entityType, @NotNull CustomDropInstance customDropInstance) {
        Intrinsics.checkNotNullParameter(entityType, "entityType");
        Intrinsics.checkNotNullParameter(customDropInstance, "customDropInstance");
        this.customDropsitems.put(entityType, customDropInstance);
    }

    public final void addCustomDropGroup(@NotNull String groupName, @NotNull CustomDropInstance customDropInstance) {
        Intrinsics.checkNotNullParameter(groupName, "groupName");
        Intrinsics.checkNotNullParameter(customDropInstance, "customDropInstance");
        this.customDropsitemsGroups.put(groupName, customDropInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CustomDropResult getCustomItemDrops(@NotNull LivingEntityWrapper lmEntity, @NotNull List<ItemStack> drops, boolean equippedOnly) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(lmEntity, "lmEntity");
        Intrinsics.checkNotNullParameter(drops, "drops");
        CustomDropProcessingInfo processingInfo = new CustomDropProcessingInfo();
        processingInfo.setLmEntity(lmEntity);
        processingInfo.setEquippedOnly(equippedOnly);
        processingInfo.setNewDrops(drops);
        processingInfo.setEquippedItemsInfo(EquippedItemsInfo.Companion.getEntityEquippedItems(lmEntity));
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        processingInfo.setDropRules(main.getRulesManager().getRuleUseCustomDropsForMob(lmEntity));
        PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        synchronized (persistentDataContainer2) {
            boolean $i$a$-synchronized-CustomDropsHandler$getCustomItemDrops$22 = false;
            processingInfo.setSpawner(lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getSpawnReasonKey(), PersistentDataType.STRING) && Intrinsics.areEqual(LevelledMobSpawnReason.SPAWNER.toString(), lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getSpawnReasonKey(), PersistentDataType.STRING)));
            if (lmEntity.getPdc().has(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), PersistentDataType.STRING)) {
                processingInfo.setCustomDropId((String)lmEntity.getPdc().get(NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId(), PersistentDataType.STRING));
                charSequence = processingInfo.getCustomDropId();
                processingInfo.setHasCustomDropId(!(charSequence == null || charSequence.length() == 0));
            }
            Unit $i$a$-synchronized-CustomDropsHandler$getCustomItemDrops$22 = Unit.INSTANCE;
        }
        if (lmEntity.getAssociatedPlayer() != null) {
            processingInfo.setWasKilledByPlayer(true);
            processingInfo.setMobKiller(lmEntity.getAssociatedPlayer());
        } else {
            processingInfo.setWasKilledByPlayer(false);
        }
        if (lmEntity.getLivingEntity().getLastDamageCause() != null) {
            EntityDamageEvent entityDamageEvent = lmEntity.getLivingEntity().getLastDamageCause();
            Intrinsics.checkNotNull(entityDamageEvent);
            String string = entityDamageEvent.getCause().toString();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            processingInfo.setDeathCause(DeathCause.valueOf(string2));
        }
        processingInfo.setAddition(main.getMobDataManager().getAdditionsForLevel(lmEntity, Addition.CUSTOM_ITEM_DROP, 2.0f).getAmount());
        processingInfo.setDoNotMultiplyDrops(main.getRulesManager().getRuleCheckIfNoDropMultiplierEntitiy(lmEntity));
        if (lmEntity.getLivingEntity().getLastDamageCause() != null) {
            EntityDamageEvent entityDamageEvent = lmEntity.getLivingEntity().getLastDamageCause();
            Intrinsics.checkNotNull(entityDamageEvent);
            EntityDamageEvent.DamageCause damageCause = entityDamageEvent.getCause();
            Intrinsics.checkNotNullExpressionValue(damageCause, "getCause(...)");
            EntityDamageEvent.DamageCause damageCause2 = damageCause;
            processingInfo.setDeathByFire(damageCause2 == EntityDamageEvent.DamageCause.FIRE || damageCause2 == EntityDamageEvent.DamageCause.FIRE_TICK || damageCause2 == EntityDamageEvent.DamageCause.LAVA);
        }
        if (!equippedOnly) {
            String mobLevel = lmEntity.getGetMobLevel() > 0 ? "&r (level " + lmEntity.getGetMobLevel() + ")" : "";
            processingInfo.addDebugMessage(DebugType.CUSTOM_DROPS, "&7Custom drops for &b" + lmEntity.getNameIfBaby() + " " + mobLevel);
            processingInfo.addDebugMessage(DebugType.MOB_GROUPS, "&8- &7Groups: &b" + CollectionsKt.joinToString$default(lmEntity.getApplicableGroups(), "&7, &b", null, null, 0, null, null, 62, null) + "&7.");
        }
        List groupsList = new ArrayList();
        for (String group : lmEntity.getApplicableGroups()) {
            if (!this.getCustomDropsitemsGroups().containsKey(group)) continue;
            groupsList.add(group);
        }
        DropInstanceBuildResult buildResult = this.buildDropsListFromGroupsAndEntity(groupsList, lmEntity.getEntityType(), processingInfo);
        if (buildResult != DropInstanceBuildResult.SUCCESSFUL) {
            if (buildResult == DropInstanceBuildResult.DID_NOT_MAKE_CHANCE) {
                processingInfo.addDebugMessage(DebugType.CUSTOM_DROPS, "&7" + lmEntity.getTypeName() + " (" + lmEntity.getGetMobLevel() + ") - didn't make overall chance");
            } else {
                String string;
                charSequence = "lvl: %s, didn't make overall chance permission for player: &b%s &r";
                Object[] objectArray = new Object[2];
                objectArray[0] = lmEntity.getGetMobLevel();
                if (processingInfo.getMobKiller() == null) {
                    string = "(null)";
                } else {
                    Player player = processingInfo.getMobKiller();
                    Intrinsics.checkNotNull(player);
                    String string3 = player.getName();
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                }
                objectArray[1] = string;
                String string4 = String.format((String)charSequence, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
                processingInfo.addDebugMessage(DebugType.CUSTOM_DROPS, string4);
            }
            processingInfo.writeAnyDebugMessages();
            return new CustomDropResult(processingInfo.getStackToItem(), processingInfo.getHasOverride(), false);
        }
        this.getCustomItemsFromDropInstance(processingInfo);
        int postCount = drops.size();
        boolean showCustomEquips = main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_EQUIPS);
        boolean showCustomDrops = main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS);
        if (showCustomDrops || showCustomEquips) {
            if (equippedOnly && !((Collection)drops).isEmpty() && showCustomEquips) {
                if (lmEntity.getGetMobLevel() > -1) {
                    processingInfo.addDebugMessage("&7Custom equipment for &b" + lmEntity.getTypeName() + " &r(" + lmEntity.getGetMobLevel() + ")");
                } else {
                    processingInfo.addDebugMessage("&7Custom equipment for &b" + lmEntity.getTypeName() + "&r");
                }
                StringBuilder sb = new StringBuilder();
                for (ItemStack drop : drops) {
                    if (((CharSequence)sb).length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(drop.getType().name());
                }
                processingInfo.addDebugMessage("   " + sb);
            } else if (!equippedOnly && showCustomDrops) {
                processingInfo.addDebugMessage("&8 --- &7Custom items added: &b" + postCount + "&7.");
            }
            processingInfo.writeAnyDebugMessages();
        }
        return new CustomDropResult(processingInfo.getStackToItem(), processingInfo.getHasOverride(), postCount > 0);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final DropInstanceBuildResult buildDropsListFromGroupsAndEntity(List<String> groups, EntityType entityType, CustomDropProcessingInfo info) {
        info.setPrioritizedDrops((Map<Integer, List<CustomDropBase>>)new LinkedHashMap<K, V>());
        info.setHasOverride(false);
        usesGroupIds = false;
        if (info.getDropRules() == null) ** GOTO lbl-1000
        v0 = info.getDropRules();
        Intrinsics.checkNotNull(v0);
        v1 = v0.getChunkKillOptions();
        Intrinsics.checkNotNull(v1);
        if (v1.getDisableVanillaDrops()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        overrideNonDropTableDrops = v2;
        for (String id : this.getDropIds(info)) {
            if (!this.customItemGroups.containsKey(StringsKt.trim((CharSequence)id).toString())) {
                Log.INSTANCE.war("rule specified an invalid value for use-droptable-id: " + id);
                continue;
            }
            var9_9 = id;
            var19_21 = this.customItemGroups;
            $i$f$trim = false;
            $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            $i$f$trim = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = startFound$iv$iv == false ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                $i$a$-trim-CustomDropsHandler$buildDropsListFromGroupsAndEntity$dropInstance$1 = false;
                v3 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            dropInstance = var19_21.get($this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1).toString());
            v4 = info.getAllDropInstances();
            v5 = dropInstance;
            Intrinsics.checkNotNull(v5);
            v4.add(v5);
            $this$trim$iv = dropInstance.getCustomItems().iterator();
            while ($this$trim$iv.hasNext()) {
                baseItem = $this$trim$iv.next();
                this.processDropPriorities(baseItem, info);
            }
            if (dropInstance.getUtilizesGroupIds()) {
                usesGroupIds = true;
            }
            if (!dropInstance.getGetOverrideStockDrops()) continue;
            info.setHasOverride(true);
        }
        if (!overrideNonDropTableDrops) {
            for (String group : groups) {
                dropInstance = this.getCustomDropsitemsGroups().get(group);
                v6 = info.getAllDropInstances();
                v7 = dropInstance;
                Intrinsics.checkNotNull(v7);
                v6.add(v7);
                for (CustomDropBase baseItem : dropInstance.getCustomItems()) {
                    this.processDropPriorities(baseItem, info);
                }
                if (dropInstance.getUtilizesGroupIds()) {
                    usesGroupIds = true;
                }
                if (!dropInstance.getGetOverrideStockDrops()) continue;
                info.setHasOverride(true);
            }
            v8 = info.getLmEntity();
            Intrinsics.checkNotNull(v8);
            v9 = dropMap = v8.isBabyMob() != false && this.customDropsitemsBabies.containsKey(entityType) != false ? this.customDropsitemsBabies : this.getCustomDropsitems();
            if (dropMap.containsKey(entityType)) {
                dropInstance = dropMap.get(entityType);
                v10 = info.getAllDropInstances();
                v11 = dropInstance;
                Intrinsics.checkNotNull(v11);
                v10.add(v11);
                for (CustomDropBase baseItem : dropInstance.getCustomItems()) {
                    this.processDropPriorities(baseItem, info);
                }
                if (dropInstance.getUtilizesGroupIds()) {
                    usesGroupIds = true;
                }
                if (dropInstance.getGetOverrideStockDrops()) {
                    info.setHasOverride(true);
                }
            }
        }
        if (usesGroupIds) {
            v12 = info.getPrioritizedDrops();
            Intrinsics.checkNotNull(v12);
            for (List customDropBases : v12.values()) {
                CollectionsKt.shuffled(customDropBases);
            }
        }
        if (!this.checkOverallPermissions(info)) {
            return DropInstanceBuildResult.PERMISSION_DENIED;
        }
        if (info.getEquippedOnly() && !info.getHasEquippedItems()) {
            return DropInstanceBuildResult.SUCCESSFUL;
        }
        return this.checkOverallChance(info) != false ? DropInstanceBuildResult.SUCCESSFUL : DropInstanceBuildResult.DID_NOT_MAKE_CHANCE;
    }

    private final boolean checkOverallPermissions(CustomDropProcessingInfo info) {
        boolean hadAnyPerms = false;
        for (CustomDropInstance dropInstance : info.getAllDropInstances()) {
            if (dropInstance.getOverallPermissions().isEmpty()) continue;
            hadAnyPerms = true;
            for (String perm : dropInstance.getOverallPermissions()) {
                if (info.getMobKiller() == null) continue;
                String checkPerm = "LevelledMobs.permission." + perm;
                Player player = info.getMobKiller();
                Intrinsics.checkNotNull(player);
                if (!player.hasPermission(checkPerm)) continue;
                return true;
            }
        }
        return !hadAnyPerms;
    }

    private final List<String> getDropIds(CustomDropProcessingInfo processingInfo) {
        List dropIds = new ArrayList();
        if (processingInfo.getDropRules() != null) {
            CustomDropsRuleSet customDropsRuleSet = processingInfo.getDropRules();
            Intrinsics.checkNotNull(customDropsRuleSet);
            for (String id : customDropsRuleSet.getUseDropTableIds()) {
                String[] stringArray = new String[]{","};
                dropIds.addAll(StringsKt.split$default((CharSequence)id, stringArray, false, 0, 6, null));
            }
        }
        if (processingInfo.getHasCustomDropId() && !CollectionsKt.contains(dropIds, processingInfo.getCustomDropId())) {
            String string = processingInfo.getCustomDropId();
            Intrinsics.checkNotNull(string);
            dropIds.add(string);
        }
        return dropIds;
    }

    private final void processDropPriorities(CustomDropBase baseItem, CustomDropProcessingInfo processingInfo) {
        int priority = -baseItem.getPriority();
        Map<Integer, List<CustomDropBase>> map = processingInfo.getPrioritizedDrops();
        Intrinsics.checkNotNull(map);
        if (map.containsKey(priority)) {
            Map<Integer, List<CustomDropBase>> map2 = processingInfo.getPrioritizedDrops();
            Intrinsics.checkNotNull(map2);
            List<CustomDropBase> list = map2.get(priority);
            Intrinsics.checkNotNull(list);
            list.add(baseItem);
        } else {
            List items = new ArrayList();
            items.add(baseItem);
            Integer n = priority;
            Map<Integer, List<CustomDropBase>> map3 = processingInfo.getPrioritizedDrops();
            Intrinsics.checkNotNull(map3);
            map3.put(n, items);
        }
        if (baseItem instanceof CustomDropItem && ((CustomDropItem)baseItem).getEquippedChance() != null) {
            SlidingChance slidingChance = ((CustomDropItem)baseItem).getEquippedChance();
            Intrinsics.checkNotNull(slidingChance);
            if (!slidingChance.isDefault()) {
                processingInfo.setHasEquippedItems(true);
            }
        }
    }

    private final void getCustomItemsFromDropInstance(CustomDropProcessingInfo info) {
        List dropLimitsReached = new ArrayList();
        GroupLimits defaultLimits = this.groupLimitsMap.getOrDefault("default", null);
        Map<Integer, List<CustomDropBase>> map = info.getPrioritizedDrops();
        Intrinsics.checkNotNull(map);
        for (List<CustomDropBase> items : map.values()) {
            int retriesHardcodedMax = 10;
            int maxRetries = 1;
            for (int i = 0; i < maxRetries; ++i) {
                info.setRetryNumber(i);
                for (CustomDropBase drop : items) {
                    if (drop.getHasGroupId()) {
                        info.setDropInstance(this.groupIdToInstance.get(drop.getGroupId()));
                        info.setGroupLimits(this.groupLimitsMap.getOrDefault(drop.getGroupId(), defaultLimits));
                        GroupLimits groupLimits = info.getGroupLimits();
                        Intrinsics.checkNotNull(groupLimits);
                        maxRetries = RangesKt.coerceAtMost(groupLimits.getRetries(), retriesHardcodedMax);
                    } else {
                        info.setDropInstance(null);
                        info.setGroupLimits(null);
                    }
                    if (info.getGroupLimits() != null) {
                        GroupLimits groupLimits;
                        Intrinsics.checkNotNull(info.getGroupLimits());
                        int itemDroppedCount = info.getItemsDropsById(drop);
                        if (groupLimits.hasReachedCapPerItem(itemDroppedCount)) {
                            if (dropLimitsReached.contains(drop.getUid())) continue;
                            dropLimitsReached.add(drop.getUid());
                            String itemDescription = drop instanceof CustomDropItem ? ((CustomDropItem)drop).getMaterial().name() : "CustomCommand";
                            DebugManager.Companion.log(DebugType.GROUP_LIMITS, info.getLmEntity(), () -> CustomDropsHandler.getCustomItemsFromDropInstance$lambda$2(groupLimits, itemDescription));
                            continue;
                        }
                        int groupDroppedCount = info.getDropItemsCountForGroup(drop);
                        if (groupLimits.hasReachedCapTotal(groupDroppedCount)) {
                            DebugManager.Companion.log(DebugType.GROUP_LIMITS, info.getLmEntity(), () -> CustomDropsHandler.getCustomItemsFromDropInstance$lambda$3(groupLimits, drop));
                            return;
                        }
                    }
                    this.getDropsFromCustomDropItem(info, drop);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void getDropsFromCustomDropItem(CustomDropProcessingInfo info, CustomDropBase dropBase) {
        block101: {
            block102: {
                block100: {
                    block99: {
                        block98: {
                            if (!(dropBase instanceof CustomCommand)) break block98;
                            v0 = info.getLmEntity();
                            Intrinsics.checkNotNull(v0);
                            if (v0.getLivingEntity().hasMetadata("noCommands")) break block99;
                        }
                        v1 = info.getLmEntity();
                        Intrinsics.checkNotNull(v1);
                        if (v1.getDeathCause() != EntityDamageEvent.DamageCause.VOID) break block100;
                    }
                    return;
                }
                if (info.getEquippedOnly() && dropBase instanceof CustomCommand && !((CustomCommand)dropBase).getRunOnSpawn()) {
                    return;
                }
                if (info.getEquippedOnly() || !dropBase.getPlayerCausedOnly()) break block101;
                if (dropBase.getCauseOfDeathReqs() == null) break block102;
                v2 = dropBase.getCauseOfDeathReqs();
                Intrinsics.checkNotNull(v2);
                if (!v2.isEmpty()) break block101;
            }
            if (!info.getWasKilledByPlayer()) {
                return;
            }
        }
        if (dropBase.getNoSpawner() && info.isSpawner()) {
            return;
        }
        if (this.shouldDenyDeathCause(dropBase, info)) {
            return;
        }
        if (!this.madePlayerLevelRequirement(info, dropBase)) {
            return;
        }
        v3 = dropBase.getExcludedMobs();
        v4 = info.getLmEntity();
        Intrinsics.checkNotNull(v4);
        if (v3.contains(v4.getTypeName())) {
            if (dropBase instanceof CustomDropItem && !info.getEquippedOnly()) {
                info.addDebugMessage("item: " + ((CustomDropItem)dropBase).getMaterial().name() + ", mob was excluded");
            }
            return;
        }
        main = LevelledMobs.Companion.getInstance();
        if (dropBase.getMaxLevel() <= -1) ** GOTO lbl-1000
        v5 = info.getLmEntity();
        Intrinsics.checkNotNull(v5);
        if (v5.getGetMobLevel() <= dropBase.getMaxLevel()) lbl-1000:
        // 2 sources

        {
            v6 = true;
        } else {
            v6 = doDrop = false;
        }
        if (dropBase.getMinLevel() > -1) {
            v7 = info.getLmEntity();
            Intrinsics.checkNotNull(v7);
            if (v7.getGetMobLevel() < dropBase.getMinLevel()) {
                doDrop = false;
            }
        }
        if (!doDrop) {
            if (dropBase instanceof CustomDropItem) {
                if (!info.getEquippedOnly() && main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS)) {
                    if (info.getDeathByFire()) {
                        v8 = ((CustomDropItem)dropBase).getItemStack();
                        Intrinsics.checkNotNull(v8);
                        v9 = this.getCookedVariantOfMeat(v8);
                    } else {
                        v10 = ((CustomDropItem)dropBase).getItemStack();
                        v9 = v10;
                        Intrinsics.checkNotNull(v10);
                    }
                    itemStack = v9;
                    var7_7 = "&8- &7level: &b%s&7, fromSpawner: &b%s&7, item: &b%s&7, minL: &b%s&7, maxL: &b%s&7, nospawner: &b%s&7, dropped: &bfalse";
                    var8_10 = new Object[6];
                    v11 = info.getLmEntity();
                    var8_10[0] = v11 != null ? Integer.valueOf(v11.getGetMobLevel()) : null;
                    var8_10[1] = info.isSpawner();
                    var8_10[2] = itemStack.getType().name();
                    var8_10[3] = dropBase.getMinLevel();
                    var8_10[4] = dropBase.getMaxLevel();
                    var8_10[5] = dropBase.getNoSpawner();
                    v12 = String.format(var7_7, Arrays.copyOf(var8_10, var8_10.length));
                    Intrinsics.checkNotNullExpressionValue(v12, "format(...)");
                    info.addDebugMessage(v12);
                }
            } else if (dropBase instanceof CustomCommand) {
                var6_12 = "&8- custom-cmd: &7level: &b%s&7, fromSpawner: &b%s&7, minL: &b%s&7, maxL: &b%s&7, nospawner: &b%s&7, executed: &bfalse";
                var7_8 = new Object[5];
                v13 = info.getLmEntity();
                var7_8[0] = v13 != null ? Integer.valueOf(v13.getGetMobLevel()) : null;
                var7_8[1] = info.isSpawner();
                var7_8[2] = dropBase.getMinLevel();
                var7_8[3] = dropBase.getMaxLevel();
                var7_8[4] = dropBase.getNoSpawner();
                v14 = String.format(var6_12, Arrays.copyOf(var7_8, var7_8.length));
                Intrinsics.checkNotNullExpressionValue(v14, "format(...)");
                info.addDebugMessage(DebugType.CUSTOM_DROPS, v14);
            }
            return;
        }
        if (!info.getEquippedOnly() && dropBase instanceof CustomDropItem) {
            info.setItemWasEquipped(this.isMobWearingItem(info, (CustomDropItem)dropBase));
        }
        if (!info.getEquippedOnly() && dropBase instanceof CustomDropItem && !this.checkIfMadeEquippedDropChance(info, (CustomDropItem)dropBase)) {
            if (main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS)) {
                v15 = ((CustomDropItem)dropBase).getItemStack();
                info.addDebugMessage("&8 - &7item: &b" + (v15 != null && (v15 = v15.getType()) != null ? v15.name() : null) + "&7, was not equipped on mob, dropped: &bfalse&7.");
            }
            return;
        }
        if (!info.getEquippedOnly() && !this.checkDropPermissions(info, dropBase)) {
            return;
        }
        runOnSpawn = dropBase instanceof CustomCommand != false && ((CustomCommand)dropBase).getRunOnSpawn() != false;
        didNotMakeChance = false;
        chanceRole = 0.0f;
        if (!info.getEquippedOnly() && dropBase.getUseChunkKillMax() && info.getWasKilledByPlayer()) {
            v16 = info.getLmEntity();
            Intrinsics.checkNotNull(v16);
            if (this.hasReachedChunkKillLimit(v16)) {
                if (dropBase instanceof CustomDropItem) {
                    var9_14 = "&8- &7level: &b%s&7, item: &b%s&7, gId: &b%s&7, chunk kill count reached";
                    var10_18 = new Object[3];
                    v17 = info.getLmEntity();
                    var10_18[0] = v17 != null ? Integer.valueOf(v17.getGetMobLevel()) : null;
                    var10_18[1] = ((CustomDropItem)dropBase).getMaterial().name();
                    var10_18[2] = dropBase.getGroupId();
                    v18 = String.format(var9_14, Arrays.copyOf(var10_18, var10_18.length));
                    Intrinsics.checkNotNullExpressionValue(v18, "format(...)");
                    info.addDebugMessage(DebugType.CUSTOM_DROPS, v18);
                } else {
                    var9_15 = "&8- &7level: &b%s&7, item: custom command, gId: &b%s&7, chunk kill count reached";
                    var10_19 = new Object[2];
                    v19 = info.getLmEntity();
                    var10_19[0] = v19 != null ? Integer.valueOf(v19.getGetMobLevel()) : null;
                    var10_19[1] = dropBase.getGroupId();
                    v20 = String.format(var9_15, Arrays.copyOf(var10_19, var10_19.length));
                    Intrinsics.checkNotNullExpressionValue(v20, "format(...)");
                    info.addDebugMessage(DebugType.CUSTOM_DROPS, v20);
                }
                return;
            }
        }
        if (dropBase.getChance() != null) {
            v21 = dropBase.getChance();
            Intrinsics.checkNotNull(v21);
            v22 = info.getLmEntity();
            Intrinsics.checkNotNull(v22);
            v23 = v21.getSlidingChance(v22.getGetMobLevel());
        } else {
            v23 = dropChance = 0.0f;
        }
        if ((!info.getEquippedOnly() || runOnSpawn) && dropChance < 1.0f) {
            v24 = chanceRole = dropChance > 0.0f ? (float)ThreadLocalRandom.current().nextInt(0, 100001) * 1.0E-5f : 0.0f;
            if (1.0f - chanceRole >= dropChance) {
                didNotMakeChance = true;
            }
        }
        if (didNotMakeChance && (!info.getEquippedOnly() || runOnSpawn) && main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS)) {
            if (dropBase instanceof CustomDropItem) {
                if (info.getDeathByFire()) {
                    v25 = ((CustomDropItem)dropBase).getItemStack();
                    Intrinsics.checkNotNull(v25);
                    v26 = this.getCookedVariantOfMeat(v25);
                } else {
                    v27 = ((CustomDropItem)dropBase).getItemStack();
                    v26 = v27;
                    Intrinsics.checkNotNull(v27);
                }
                itemStack = v26;
                var11_25 /* !! */  = "&8 - &7item: &b%s&7, amount: &b%s&7, chance: &b%s&7, chanceRole: &b%s&7, dropped: &bfalse&7.";
                var12_29 /* !! */  = new Object[4];
                var12_29 /* !! */ [0] = itemStack.getType().name();
                var12_29 /* !! */ [1] = dropBase.getAmountAsString();
                v28 = dropBase.getChance();
                var12_29 /* !! */ [2] = v28 != null ? v28.showMatchedChance() : null;
                var12_29 /* !! */ [3] = Utils.INSTANCE.round(chanceRole, 4);
                v29 = String.format((String)var11_25 /* !! */ , Arrays.copyOf(var12_29 /* !! */ , var12_29 /* !! */ .length));
                Intrinsics.checkNotNullExpressionValue(v29, "format(...)");
                info.addDebugMessage(DebugType.CUSTOM_DROPS, v29);
            } else {
                var10_20 = "&8 - &7Custom command&7, chance: &b%s&7, chanceRole: &b%s&7, executed: &bfalse&7.";
                var11_25 /* !! */  = new Object[2];
                v30 = dropBase.getChance();
                var11_25 /* !! */ [0] = v30 != null ? v30.showMatchedChance() : null;
                var11_25 /* !! */ [1] = Utils.INSTANCE.round(chanceRole, 4);
                v31 = String.format(var10_20, Arrays.copyOf(var11_25 /* !! */ , var11_25 /* !! */ .length));
                Intrinsics.checkNotNullExpressionValue(v31, "format(...)");
                info.addDebugMessage(DebugType.CUSTOM_DROPS, v31);
            }
        }
        if ((!info.getEquippedOnly() || runOnSpawn) && didNotMakeChance) {
            return;
        }
        maxDropGroup = 0;
        if (info.getGroupLimits() == null) ** GOTO lbl-1000
        v32 = info.getGroupLimits();
        Intrinsics.checkNotNull(v32);
        if (v32.getHasCapSelect()) {
            v33 = info.getGroupLimits();
            Intrinsics.checkNotNull(v33);
            maxDropGroup = RangesKt.coerceAtLeast(v33.getCapSelect(), 0);
        } else if (info.getGroupLimits() == null) {
            maxDropGroup = dropBase.getMaxDropGroup();
        }
        if (!info.getEquippedOnly() && dropBase.getHasGroupId()) {
            groupDroppedCount = info.getItemsDropsByGroup(dropBase);
            v34 = 1 <= maxDropGroup ? maxDropGroup <= groupDroppedCount : false;
            if (v34 || info.getGroupLimits() == null && maxDropGroup == 0 && groupDroppedCount > 0) {
                if (main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS)) {
                    if (dropBase instanceof CustomDropItem) {
                        var12_29 /* !! */  = "&8- &7level: &b%s&7, item: &b%s&7, gId: &b%s&7, maxDropGroup: &b%s&7, groupDropCount: &b%s&7, dropped: &bfalse";
                        var13_32 = new Object[5];
                        v35 = info.getLmEntity();
                        var13_32[0] = v35 != null ? Integer.valueOf(v35.getGetMobLevel()) : null;
                        var13_32[1] = ((CustomDropItem)dropBase).getMaterial().name();
                        var13_32[2] = dropBase.getGroupId();
                        var13_32[3] = info.getItemsDropsByGroup(dropBase);
                        var13_32[4] = groupDroppedCount;
                        v36 = String.format((String)var12_29 /* !! */ , Arrays.copyOf(var13_32, var13_32.length));
                        Intrinsics.checkNotNullExpressionValue(v36, "format(...)");
                        info.addDebugMessage(v36);
                    } else {
                        var12_29 /* !! */  = "&8- &7level: &b%s&7, item: custom command, gId: &b%s&7, maxDropGroup: &b%s&7, groupDropCount: &b%s&7, executed: &bfalse";
                        var13_33 = new Object[4];
                        v37 = info.getLmEntity();
                        var13_33[0] = v37 != null ? Integer.valueOf(v37.getGetMobLevel()) : null;
                        var13_33[1] = info.getItemsDropsByGroup(dropBase);
                        var13_33[2] = dropBase.getMaxDropGroup();
                        var13_33[3] = groupDroppedCount;
                        v38 = String.format((String)var12_29 /* !! */ , Arrays.copyOf(var13_33, var13_33.length));
                        Intrinsics.checkNotNullExpressionValue(v38, "format(...)");
                        info.addDebugMessage(v38);
                    }
                }
                return;
            }
        }
        if (dropBase instanceof CustomCommand) {
            this.executeCommand((CustomCommand)dropBase, info);
            if (dropBase.getHasGroupId()) {
                if (main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS)) {
                    count = info.getItemsDropsByGroup(dropBase);
                    var13_34 = "&8- &7level: &b%s&7, item: command, gId: &b%s&7, maxDropGroup: &b%s&7, groupDropCount: &b%s&7, executed: &btrue";
                    var14_37 = new Object[4];
                    v39 = info.getLmEntity();
                    var14_37[0] = v39 != null ? Integer.valueOf(v39.getGetMobLevel()) : null;
                    var14_37[1] = dropBase.getGroupId();
                    var14_37[2] = dropBase.getMaxDropGroup();
                    var14_37[3] = count;
                    v40 = String.format(var13_34, Arrays.copyOf(var14_37, var14_37.length));
                    Intrinsics.checkNotNullExpressionValue(v40, "format(...)");
                    msg = v40;
                    if (info.getRetryNumber() > 0) {
                        msg = (String)msg + ", retry: " + info.getRetryNumber();
                    }
                    info.addDebugMessage((String)msg);
                }
            } else if (main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS)) {
                var12_29 /* !! */  = "&8- &7level: &b%s&7, item: custom command, gId: &b%s&7, maxDropGroup: &b%s&7, executed: &btrue";
                var13_35 = new Object[3];
                v41 = info.getLmEntity();
                var13_35[0] = v41 != null ? Integer.valueOf(v41.getGetMobLevel()) : null;
                var13_35[1] = dropBase.getGroupId();
                var13_35[2] = dropBase.getMaxDropGroup();
                v42 = String.format((String)var12_29 /* !! */ , Arrays.copyOf(var13_35, var13_35.length));
                Intrinsics.checkNotNullExpressionValue(v42, "format(...)");
                msg = v42;
                if (info.getRetryNumber() > 0) {
                    msg = (String)msg + ", retry: " + info.getRetryNumber();
                }
                info.addDebugMessage((String)msg);
            }
            return;
        }
        if (!(dropBase instanceof CustomDropItem)) {
            Log.INSTANCE.war("Unsupported drop type: " + dropBase.getClass().getName());
            return;
        }
        if (!this.checkEquippedChances(info, (CustomDropItem)dropBase)) {
            return;
        }
        newDropAmount = dropBase.getAmount();
        if (dropBase.getHasAmountRange()) {
            change = ThreadLocalRandom.current().nextInt(0, dropBase.getAmountRangeMax() - dropBase.getAmountRangeMin() + 1);
            newDropAmount = dropBase.getAmountRangeMin() + change;
        }
        if (dropBase.getHasGroupId() && info.getGroupLimits() != null) {
            v43 = info.getGroupLimits();
            Intrinsics.checkNotNull(v43);
            gl = v43;
            if (gl.getHasCapPerItem()) {
                newDropAmount = RangesKt.coerceAtMost(newDropAmount, gl.getCapPerItem());
            }
            if (gl.getHasCapTotal() && dropBase.getHasGroupId()) {
                hasDroppedSoFar = info.getDropItemsCountForGroup(dropBase);
                if (gl.getCapTotal() - hasDroppedSoFar > gl.getCapTotal()) {
                    newDropAmount = gl.getCapTotal();
                }
            }
        }
        if (((CustomDropItem)dropBase).isExternalItem() && !main.getMainCompanion().getExternalCompatibilityManager().doesLMIMeetVersionRequirement()) {
            Log.INSTANCE.war("Could not get external custom item - LM_Items is not installed");
        }
        if (((CustomDropItem)dropBase).isExternalItem() && main.getMainCompanion().getExternalCompatibilityManager().doesLMIMeetVersionRequirement()) {
            v44 = this.lmItemsParser;
            Intrinsics.checkNotNull(v44);
            v44.getExternalItem((CustomDropItem)dropBase, info);
        }
        if (((CustomDropItem)dropBase).getItemStacks() == null) {
            return;
        }
        v45 = ((CustomDropItem)dropBase).getItemStacks();
        Intrinsics.checkNotNull(v45);
        for (ItemStack newItemPre : v45) {
            Intrinsics.checkNotNullExpressionValue(newItemPre.clone(), "clone(...)");
            this.processEnchantmentChances((CustomDropItem)dropBase, newItem, info);
            if (info.getDeathByFire()) {
                v46 = ((CustomDropItem)dropBase).getItemStack();
                Intrinsics.checkNotNull(v46);
                newItem = this.getCookedVariantOfMeat(v46);
            }
            if (newDropAmount > 1) {
                newItem.setAmount(newDropAmount);
            }
            if (!((CustomDropItem)dropBase).getNoMultiplier() && !info.getDoNotMultiplyDrops()) {
                v47 = main.getLevelManager();
                v48 = info.getLmEntity();
                Intrinsics.checkNotNull(v48);
                v47.multiplyDrop(v48, newItem, info.getAddition());
                newDropAmount = newItem.getAmount();
            } else if (newDropAmount > newItem.getMaxStackSize()) {
                newDropAmount = newItem.getMaxStackSize();
            }
            if (newItem.getAmount() != newDropAmount) {
                newItem.setAmount(newDropAmount);
            }
            if (info.getEquippedOnly() && main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_EQUIPS)) {
                if (((CustomDropItem)dropBase).getEquippedChance() != null) {
                    v49 = ((CustomDropItem)dropBase).getEquippedChance();
                    Intrinsics.checkNotNull(v49);
                    v50 = v49.showMatchedChance();
                } else {
                    v50 = "0.0";
                }
                equippedChance = v50;
                var16_42 = "&8 - &7item: &b%s&7, equipChance: &b%s&7, chanceRole: &b%s&7, equipped: &btrue&7.";
                var17_43 = new Object[]{newItem.getType().name(), equippedChance, Utils.INSTANCE.round(info.getEquippedChanceRole(), 4)};
                v51 = String.format(var16_42, Arrays.copyOf(var17_43, ((Object[])var17_43).length));
                Intrinsics.checkNotNullExpressionValue(v51, "format(...)");
                info.addDebugMessage(v51);
            } else if (!info.getEquippedOnly() && main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS)) {
                retryMsg = info.getRetryNumber() > 0 ? ", retry: " + info.getRetryNumber() : "";
                var16_42 = "&8 - &7item: &b%s&7, amount: &b%s&7, newAmount: &b%s&7, chance: &b%s&7, chanceRole: &b%s&7, dropped: &btrue&7%s.";
                var17_43 = new Object[6];
                var17_43[0] = newItem.getType().name();
                var17_43[1] = dropBase.getAmountAsString();
                var17_43[2] = newDropAmount;
                v52 = dropBase.getChance();
                var17_43[3] = v52 != null ? v52.showMatchedChance() : null;
                var17_43[4] = Utils.INSTANCE.round(chanceRole, 4);
                var17_43[5] = retryMsg;
                v53 = String.format(var16_42, Arrays.copyOf(var17_43, ((Object)var17_43).length));
                Intrinsics.checkNotNullExpressionValue(v53, "format(...)");
                info.addDebugMessage(v53);
            }
            damage = ((CustomDropItem)dropBase).getDamage();
            if (((CustomDropItem)dropBase).getHasDamageRange()) {
                damage = ThreadLocalRandom.current().nextInt(((CustomDropItem)dropBase).getDamageRangeMin(), ((CustomDropItem)dropBase).getDamageRangeMax() + 1);
            }
            if (damage > 0 || ((CustomDropItem)dropBase).getLore() != null || ((CustomDropItem)dropBase).getCustomName() != null) {
                meta = newItem.getItemMeta();
                if (damage > 0 && meta instanceof Damageable) {
                    ((Damageable)meta).setDamage(damage);
                }
                if (meta != null && ((CustomDropItem)dropBase).getLore() != null) {
                    v54 = ((CustomDropItem)dropBase).getLore();
                    Intrinsics.checkNotNull(v54);
                    if (((Collection)v54).isEmpty() == false) {
                        v55 = ((CustomDropItem)dropBase).getLore();
                        Intrinsics.checkNotNull(v55);
                        newLore = new ArrayList<E>(v55.size());
                        v56 = ((CustomDropItem)dropBase).getLore();
                        Intrinsics.checkNotNull(v56);
                        for (String lorePre : v56) {
                            lore = lorePre;
                            if (StringsKt.contains$default((CharSequence)lore, "%", false, 2, null)) {
                                if (info.getMobKiller() == null) {
                                    v57 = "";
                                } else {
                                    v58 = info.getMobKiller();
                                    Intrinsics.checkNotNull(v58);
                                    v59 = v58.getName();
                                    v57 = v59;
                                    Intrinsics.checkNotNullExpressionValue(v59, "getName(...)");
                                }
                                lore = StringsKt.replace$default(lore, "%player%", v57, false, 4, null);
                                v60 = main.getLevelManager();
                                v61 = info.getLmEntity();
                                Intrinsics.checkNotNull(v61);
                                lore = v60.replaceStringPlaceholders(lore, v61, true, info.getMobKiller(), false);
                            }
                            newLore.add(lore);
                            if (main.getVer().isRunningPaper() && main.getMainCompanion().getUseAdventure()) {
                                PaperUtils.INSTANCE.updateItemMetaLore(meta, newLore);
                                continue;
                            }
                            SpigotUtils.INSTANCE.updateItemMetaLore(meta, newLore);
                        }
                    }
                }
                if (meta != null && ((CustomDropItem)dropBase).getCustomName() != null) {
                    v62 = ((CustomDropItem)dropBase).getCustomName();
                    Intrinsics.checkNotNull(v62);
                    if (((CharSequence)v62).length() > 0) {
                        v63 = ((CustomDropItem)dropBase).getCustomName();
                        Intrinsics.checkNotNull(v63);
                        if (info.getMobKiller() == null) {
                            v64 = "";
                        } else {
                            v65 = info.getMobKiller();
                            Intrinsics.checkNotNull(v65);
                            v66 = v65.getName();
                            v64 = v66;
                            Intrinsics.checkNotNullExpressionValue(v66, "getName(...)");
                        }
                        customName = StringsKt.replace$default(v63, "%player%", v64, false, 4, null);
                        v67 = main.getLevelManager();
                        v68 = info.getLmEntity();
                        Intrinsics.checkNotNull(v68);
                        customName = v67.replaceStringPlaceholders(customName, v68, true, info.getMobKiller(), false);
                        if (main.getVer().isRunningPaper() && main.getMainCompanion().getUseAdventure()) {
                            PaperUtils.INSTANCE.updateItemDisplayName(meta, customName);
                        } else {
                            SpigotUtils.INSTANCE.updateItemDisplayName(meta, MessageUtils.INSTANCE.colorizeAll(customName));
                        }
                    }
                }
                newItem.setItemMeta(meta);
            }
            if (!info.getEquippedOnly()) {
                info.itemGotDropped(dropBase, newDropAmount);
            }
            v69 = info.getNewDrops();
            Intrinsics.checkNotNull(v69);
            v69.add(newItem);
            info.getStackToItem().add(Utils.INSTANCE.getPair(newItem, dropBase));
        }
    }

    private final boolean checkEquippedChances(CustomDropProcessingInfo info, CustomDropItem dropItem) {
        float equippedChance;
        if (!info.getEquippedOnly()) {
            return true;
        }
        if (dropItem.getEquippedChance() != null) {
            SlidingChance slidingChance = dropItem.getEquippedChance();
            Intrinsics.checkNotNull(slidingChance);
            LivingEntityWrapper livingEntityWrapper = info.getLmEntity();
            Intrinsics.checkNotNull(livingEntityWrapper);
            v2 = slidingChance.getSlidingChance(livingEntityWrapper.getGetMobLevel());
        } else {
            v2 = equippedChance = 0.0f;
        }
        if (equippedChance >= 1.0f) {
            return true;
        }
        info.setEquippedChanceRole(equippedChance > 0.0f ? (float)ThreadLocalRandom.current().nextInt(0, 100001) * 1.0E-5f : 0.0f);
        if (equippedChance <= 0.0f || 1.0f - info.getEquippedChanceRole() >= equippedChance) {
            if (LevelledMobs.Companion.getInstance().getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_EQUIPS)) {
                String string = "&7level: &b%s&7, item: &b%s&7, equipchance: &b%s&7, chancerole: &b%s&7, did not make equipped chance";
                Object[] objectArray = new Object[4];
                LivingEntityWrapper livingEntityWrapper = info.getLmEntity();
                objectArray[0] = livingEntityWrapper != null ? Integer.valueOf(livingEntityWrapper.getGetMobLevel()) : null;
                objectArray[1] = dropItem.getMaterial().name();
                SlidingChance slidingChance = dropItem.getEquippedChance();
                objectArray[2] = slidingChance != null ? slidingChance.showMatchedChance() : null;
                objectArray[3] = Utils.INSTANCE.round(info.getEquippedChanceRole(), 4);
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                info.addDebugMessage(string2);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean checkOverallChance(CustomDropProcessingInfo info) {
        for (CustomDropInstance dropInstance : info.getAllDropInstances()) {
            boolean madeChance;
            if (dropInstance.getOverallChance() == null) continue;
            SlidingChance slidingChance = dropInstance.getOverallChance();
            Intrinsics.checkNotNull(slidingChance);
            if (slidingChance.isDefault()) continue;
            SlidingChance slidingChance2 = dropInstance.getOverallChance();
            Intrinsics.checkNotNull(slidingChance2);
            if (slidingChance2.isAssuredChance()) continue;
            LivingEntityWrapper livingEntityWrapper = info.getLmEntity();
            Intrinsics.checkNotNull(livingEntityWrapper);
            PersistentDataContainer persistentDataContainer = livingEntityWrapper.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
            PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
            synchronized (persistentDataContainer2) {
                block9: {
                    Integer value;
                    boolean bl = false;
                    LivingEntityWrapper livingEntityWrapper2 = info.getLmEntity();
                    Intrinsics.checkNotNull(livingEntityWrapper2);
                    if (!livingEntityWrapper2.getPdc().has(NamespacedKeys.INSTANCE.getOverallChanceKey(), PersistentDataType.INTEGER)) break block9;
                    LivingEntityWrapper livingEntityWrapper3 = info.getLmEntity();
                    Intrinsics.checkNotNull(livingEntityWrapper3);
                    Integer n = value = (Integer)livingEntityWrapper3.getPdc().get(NamespacedKeys.INSTANCE.getOverallChanceKey(), PersistentDataType.INTEGER);
                    int n2 = 1;
                    boolean bl2 = n != null && n == n2;
                    return bl2;
                }
                Unit unit = Unit.INSTANCE;
            }
            float chanceRole = (float)ThreadLocalRandom.current().nextInt(0, 100001) * 1.0E-5f;
            SlidingChance slidingChance3 = dropInstance.getOverallChance();
            Intrinsics.checkNotNull(slidingChance3);
            LivingEntityWrapper livingEntityWrapper4 = info.getLmEntity();
            Intrinsics.checkNotNull(livingEntityWrapper4);
            boolean bl = madeChance = 1.0f - chanceRole < slidingChance3.getSlidingChance(livingEntityWrapper4.getGetMobLevel());
            if (info.getEquippedOnly()) {
                LivingEntityWrapper livingEntityWrapper5 = info.getLmEntity();
                Intrinsics.checkNotNull(livingEntityWrapper5);
                PersistentDataContainer persistentDataContainer3 = livingEntityWrapper5.getLivingEntity().getPersistentDataContainer();
                Intrinsics.checkNotNullExpressionValue(persistentDataContainer3, "getPersistentDataContainer(...)");
                PersistentDataContainer persistentDataContainer4 = persistentDataContainer3;
                synchronized (persistentDataContainer4) {
                    boolean bl3 = false;
                    LivingEntityWrapper livingEntityWrapper6 = info.getLmEntity();
                    Intrinsics.checkNotNull(livingEntityWrapper6);
                    livingEntityWrapper6.getPdc().set(NamespacedKeys.INSTANCE.getOverallChanceKey(), PersistentDataType.INTEGER, (Object)(madeChance ? 1 : 0));
                    Unit unit = Unit.INSTANCE;
                }
            }
            return madeChance;
        }
        return true;
    }

    private final void processEnchantmentChances(CustomDropItem dropItem, ItemStack itemStack, CustomDropProcessingInfo info) {
        block16: {
            block15: {
                if (dropItem.getEnchantmentChances() == null) break block15;
                EnchantmentChances enchantmentChances = dropItem.getEnchantmentChances();
                Intrinsics.checkNotNull(enchantmentChances);
                if (!enchantmentChances.isEmpty()) break block16;
            }
            return;
        }
        EnchantmentChances enchantmentChances = dropItem.getEnchantmentChances();
        Intrinsics.checkNotNull(enchantmentChances);
        EnchantmentChances chances = enchantmentChances;
        UUID debugId = DebugManager.Companion.startLongDebugMessage();
        DebugManager.Companion.logLongMessage(debugId, () -> CustomDropsHandler.processEnchantmentChances$lambda$6(itemStack));
        boolean isFirstEnchantment = true;
        for (Enchantment enchantment : chances.getItems().keySet()) {
            EnchantmentChances.ChanceOptions opts = chances.getOptions().get(enchantment);
            boolean madeAnyChance = false;
            if (!isFirstEnchantment) {
                DebugManager.Companion.logLongMessage(debugId, CustomDropsHandler::processEnchantmentChances$lambda$7);
            }
            DebugManager.Companion.logLongMessage(debugId, () -> CustomDropsHandler.processEnchantmentChances$lambda$8(enchantment));
            if (isFirstEnchantment) {
                isFirstEnchantment = false;
            }
            int enchantmentNumber = 0;
            List levelsList = new ArrayList();
            Map<Integer, Float> map = chances.getItems().get(enchantment);
            Intrinsics.checkNotNull(map);
            levelsList.addAll((Collection)map.keySet());
            if (opts == null || opts.getDoShuffle()) {
                CollectionsKt.shuffled(levelsList);
            }
            Iterator iterator2 = levelsList.iterator();
            while (iterator2.hasNext()) {
                boolean madeChance;
                int enchantLevel = ((Number)iterator2.next()).intValue();
                Map<Integer, Float> map2 = chances.getItems().get(enchantment);
                Intrinsics.checkNotNull(map2);
                Float f = map2.get(enchantLevel);
                Intrinsics.checkNotNull(f);
                float chanceValue = ((Number)f).floatValue();
                if (chanceValue <= 0.0f) continue;
                ++enchantmentNumber;
                float chanceRole = (float)ThreadLocalRandom.current().nextInt(0, 100001) * 1.0E-5f;
                boolean bl = madeChance = 1.0f - chanceRole < chanceValue;
                if (!madeChance) {
                    if (enchantmentNumber > 1) {
                        DebugManager.Companion.logLongMessage(debugId, CustomDropsHandler::processEnchantmentChances$lambda$9);
                    }
                    DebugManager.Companion.logLongMessage(debugId, () -> CustomDropsHandler.processEnchantmentChances$lambda$10(enchantLevel, chanceRole, chanceValue));
                    continue;
                }
                if (enchantmentNumber > 1) {
                    DebugManager.Companion.logLongMessage(debugId, CustomDropsHandler::processEnchantmentChances$lambda$11);
                }
                DebugManager.Companion.logLongMessage(debugId, () -> CustomDropsHandler.processEnchantmentChances$lambda$12(chanceValue, chanceRole, enchantLevel));
                if (itemStack.getType() == Material.ENCHANTED_BOOK) {
                    ItemMeta itemMeta = itemStack.getItemMeta();
                    Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.EnchantmentStorageMeta");
                    EnchantmentStorageMeta meta = (EnchantmentStorageMeta)itemMeta;
                    meta.addStoredEnchant(enchantment, enchantLevel, true);
                    itemStack.setItemMeta((ItemMeta)meta);
                } else {
                    itemStack.addUnsafeEnchantment(enchantment, enchantLevel);
                }
                madeAnyChance = true;
                break;
            }
            if (madeAnyChance || opts == null || opts.getDefaultLevel() == null) continue;
            Integer n = opts.getDefaultLevel();
            Intrinsics.checkNotNull(n);
            if (n <= 0) continue;
            if (itemStack.getType() == Material.ENCHANTED_BOOK) {
                ItemMeta itemMeta = itemStack.getItemMeta();
                Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.EnchantmentStorageMeta");
                EnchantmentStorageMeta meta = (EnchantmentStorageMeta)itemMeta;
                Integer n2 = opts.getDefaultLevel();
                Intrinsics.checkNotNull(n2);
                meta.addStoredEnchant(enchantment, n2.intValue(), true);
                itemStack.setItemMeta((ItemMeta)meta);
            } else {
                Integer n3 = opts.getDefaultLevel();
                Intrinsics.checkNotNull(n3);
                itemStack.addUnsafeEnchantment(enchantment, n3.intValue());
            }
            DebugManager.Companion.logLongMessage(debugId, () -> CustomDropsHandler.processEnchantmentChances$lambda$13(opts));
        }
        DebugManager.Companion.endLongMessage(debugId, DebugType.ENCHANTMENT_CHANCES, info.getLmEntity());
    }

    private final boolean hasReachedChunkKillLimit(LivingEntityWrapper lmEntity) {
        int maximumDeathInChunkThreshold = LevelledMobs.Companion.getInstance().getRulesManager().getMaximumDeathInChunkThreshold(lmEntity);
        if (maximumDeathInChunkThreshold <= 0) {
            return false;
        }
        return lmEntity.getChunkKillcount() >= maximumDeathInChunkThreshold;
    }

    private final boolean shouldDenyDeathCause(CustomDropBase dropBase, CustomDropProcessingInfo info) {
        if (dropBase.getCauseOfDeathReqs() == null || info.getDeathCause() == null) {
            return false;
        }
        if (info.getWasKilledByPlayer()) {
            CachedModalList<DeathCause> cachedModalList = dropBase.getCauseOfDeathReqs();
            Intrinsics.checkNotNull(cachedModalList);
            if (Utils.INSTANCE.isDamageCauseInModalList(cachedModalList, DeathCause.PLAYER_CAUSED)) {
                return false;
            }
        }
        CachedModalList<DeathCause> cachedModalList = dropBase.getCauseOfDeathReqs();
        Intrinsics.checkNotNull(cachedModalList);
        DeathCause deathCause = info.getDeathCause();
        Intrinsics.checkNotNull((Object)deathCause);
        if (!Utils.INSTANCE.isDamageCauseInModalList(cachedModalList, deathCause)) {
            if (LevelledMobs.Companion.getInstance().getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS)) {
                String itemName = dropBase instanceof CustomDropItem ? ((CustomDropItem)dropBase).getMaterial().name() : "(command)";
                String string = "&8 - &7item: &b%s&7, death-cause: &b%s&7, death-cause-req: &b%s&7, dropped: &bfalse&7.";
                Object[] objectArray = new Object[]{itemName, info.getDeathCause(), dropBase.getCauseOfDeathReqs()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                info.addDebugMessage(string2);
            }
            return true;
        }
        return false;
    }

    private final boolean checkDropPermissions(CustomDropProcessingInfo info, CustomDropBase dropBase) {
        if (info.getEquippedOnly() || dropBase.getPermissions().isEmpty()) {
            return true;
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        if (info.getMobKiller() == null) {
            if (main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS)) {
                ItemStack itemStack;
                String itemDescription = dropBase instanceof CustomDropItem ? ((itemStack = ((CustomDropItem)dropBase).getItemStack()) != null && (itemStack = itemStack.getType()) != null ? itemStack.name() : null) : "custom command";
                info.addDebugMessage("&8 - &7item: &b" + itemDescription + "&7, not player was provided for item permissions");
            }
            return false;
        }
        boolean hadPermission = false;
        for (String perm : dropBase.getPermissions()) {
            String permCheck = "levelledmobs.permission." + perm;
            Player player = info.getMobKiller();
            Intrinsics.checkNotNull(player);
            if (!player.hasPermission(permCheck)) continue;
            hadPermission = true;
            break;
        }
        if (!hadPermission) {
            if (main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS)) {
                ItemStack itemStack;
                String string = "&8 - &7item: &b%s&7, player: &b%s&7 didn't have permission: &b%s&7";
                Object[] objectArray = new Object[3];
                objectArray[0] = dropBase instanceof CustomDropItem ? ((itemStack = ((CustomDropItem)dropBase).getItemStack()) != null && (itemStack = itemStack.getType()) != null ? itemStack.name() : null) : "custom command";
                Player player = info.getMobKiller();
                objectArray[1] = player != null ? player.getName() : null;
                objectArray[2] = dropBase.getPermissions();
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                info.addDebugMessage(string2);
            }
            return false;
        }
        return true;
    }

    private final boolean checkIfMadeEquippedDropChance(CustomDropProcessingInfo info, CustomDropItem item) {
        block7: {
            block6: {
                block5: {
                    if (item.getOnlyDropIfEquipped() && !info.getItemWasEquipped()) {
                        return false;
                    }
                    if (info.getEquippedItemsInfo() != null && info.getEquipmentClass() != null && CollectionsKt.contains((Iterable)EquippedItemsInfo.Companion.getDroppedEquipmentByClass(), info.getEquipmentClass())) {
                        return false;
                    }
                    if (item.getEquippedChance() == null) break block5;
                    SlidingChance slidingChance = item.getEquippedChance();
                    Intrinsics.checkNotNull(slidingChance);
                    if (slidingChance.isAssuredChance()) break block6;
                }
                if (item.getOnlyDropIfEquipped()) break block7;
            }
            return true;
        }
        return info.getItemWasEquipped();
    }

    private final boolean isMobWearingItem(CustomDropProcessingInfo info, CustomDropItem customDropItem) {
        ItemStack itemStack = customDropItem.getItemStack();
        if (itemStack == null) {
            return false;
        }
        ItemStack item = itemStack;
        if (info.getLmEntity() == null) {
            return false;
        }
        LivingEntityWrapper livingEntityWrapper = info.getLmEntity();
        Intrinsics.checkNotNull(livingEntityWrapper);
        EntityEquipment entityEquipment = livingEntityWrapper.getLivingEntity().getEquipment();
        if (entityEquipment == null) {
            return false;
        }
        EntityEquipment equipment = entityEquipment;
        if (customDropItem.getEquipOnHelmet() && item.isSimilar(equipment.getHelmet())) {
            return true;
        }
        if (EnchantmentTarget.ARMOR_HEAD.includes(item.getType())) {
            EquippedItemsInfo equippedItemsInfo = info.getEquippedItemsInfo();
            if (item.isSimilar((ItemStack)(equippedItemsInfo != null ? equippedItemsInfo.getHelmet() : null))) {
                return true;
            }
            return item.isSimilar(equipment.getHelmet());
        }
        if (EnchantmentTarget.ARMOR_TORSO.includes(item.getType())) {
            EquippedItemsInfo equippedItemsInfo = info.getEquippedItemsInfo();
            if (item.isSimilar((ItemStack)(equippedItemsInfo != null ? equippedItemsInfo.getChestplate() : null))) {
                return true;
            }
            return item.isSimilar(equipment.getChestplate());
        }
        if (EnchantmentTarget.ARMOR_LEGS.includes(item.getType())) {
            EquippedItemsInfo equippedItemsInfo = info.getEquippedItemsInfo();
            if (item.isSimilar((ItemStack)(equippedItemsInfo != null ? equippedItemsInfo.getLeggings() : null))) {
                return true;
            }
            return item.isSimilar(equipment.getLeggings());
        }
        if (EnchantmentTarget.ARMOR_FEET.includes(item.getType())) {
            EquippedItemsInfo equippedItemsInfo = info.getEquippedItemsInfo();
            if (item.isSimilar((ItemStack)(equippedItemsInfo != null ? equippedItemsInfo.getBoots() : null))) {
                return true;
            }
            return item.isSimilar(equipment.getBoots());
        }
        EquippedItemsInfo equippedItemsInfo = info.getEquippedItemsInfo();
        if (item.isSimilar((ItemStack)(equippedItemsInfo != null ? equippedItemsInfo.getMainHand() : null))) {
            return true;
        }
        if (item.isSimilar(equipment.getItemInMainHand())) {
            return true;
        }
        EquippedItemsInfo equippedItemsInfo2 = info.getEquippedItemsInfo();
        if (item.isSimilar((ItemStack)(equippedItemsInfo2 != null ? equippedItemsInfo2.getOffhand() : null))) {
            return true;
        }
        return item.isSimilar(equipment.getItemInOffHand());
    }

    private final boolean madePlayerLevelRequirement(CustomDropProcessingInfo info, CustomDropBase dropBase) {
        block17: {
            Object[] objectArray;
            int levelToUse;
            String string;
            LevelledMobs main;
            block18: {
                String string2;
                main = LevelledMobs.Companion.getInstance();
                if (dropBase.getPlayerLevelVariable() != null && !info.getEquippedOnly() && !((Collection)dropBase.getPlayeerVariableMatches()).isEmpty()) {
                    String papiResult = Utils.INSTANCE.removeColorCodes(ExternalCompatibilityManager.Companion.getPapiPlaceholder(info.getMobKiller(), dropBase.getPlayerLevelVariable()));
                    boolean foundMatch = false;
                    for (String resultStr : dropBase.getPlayeerVariableMatches()) {
                        if (!Utils.INSTANCE.matchWildcardString(papiResult, resultStr)) continue;
                        foundMatch = true;
                        if (!main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS)) break;
                        if (dropBase instanceof CustomDropItem) {
                            String string3 = "&8 - &7Mob: &b%s&7, item: %s, PAPI val: %s, matched: %s";
                            Object[] objectArray2 = new Object[4];
                            LivingEntityWrapper livingEntityWrapper = info.getLmEntity();
                            objectArray2[0] = livingEntityWrapper != null ? livingEntityWrapper.getTypeName() : null;
                            objectArray2[1] = ((CustomDropItem)dropBase).getMaterial();
                            objectArray2[2] = papiResult;
                            objectArray2[3] = resultStr;
                            String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
                            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
                            info.addDebugMessage(string4);
                            break;
                        }
                        String string5 = "&8 - &7Mob: &b%s&7, (customCommand), PAPI val: %s, matched: %s";
                        Object[] objectArray3 = new Object[3];
                        LivingEntityWrapper livingEntityWrapper = info.getLmEntity();
                        objectArray3[0] = livingEntityWrapper != null ? livingEntityWrapper.getTypeName() : null;
                        objectArray3[1] = papiResult;
                        objectArray3[2] = resultStr;
                        String string6 = String.format(string5, Arrays.copyOf(objectArray3, objectArray3.length));
                        Intrinsics.checkNotNullExpressionValue(string6, "format(...)");
                        info.addDebugMessage(string6);
                        break;
                    }
                    if (!foundMatch) {
                        if (main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS)) {
                            if (dropBase instanceof CustomDropItem) {
                                string = "&8 - &7Mob: &b%s&7, item: %s, PAPI val: %s, no matches found";
                                Object[] objectArray4 = new Object[3];
                                LivingEntityWrapper livingEntityWrapper = info.getLmEntity();
                                objectArray4[0] = livingEntityWrapper != null ? livingEntityWrapper.getTypeName() : null;
                                objectArray4[1] = ((CustomDropItem)dropBase).getMaterial();
                                objectArray4[2] = papiResult;
                                String string7 = String.format(string, Arrays.copyOf(objectArray4, objectArray4.length));
                                Intrinsics.checkNotNullExpressionValue(string7, "format(...)");
                                info.addDebugMessage(string7);
                            } else {
                                string = "&8 - &7Mob: &b%s&7, (customCommand), PAPI val: %s, no matches found";
                                Object[] objectArray5 = new Object[2];
                                LivingEntityWrapper livingEntityWrapper = info.getLmEntity();
                                objectArray5[0] = livingEntityWrapper != null ? livingEntityWrapper.getTypeName() : null;
                                objectArray5[1] = papiResult;
                                String string8 = String.format(string, Arrays.copyOf(objectArray5, objectArray5.length));
                                Intrinsics.checkNotNullExpressionValue(string8, "format(...)");
                                info.addDebugMessage(string8);
                            }
                        }
                        return false;
                    }
                }
                if (info.getEquippedOnly() || dropBase.getMinPlayerLevel() <= -1 && dropBase.getMaxPlayerLevel() <= -1) break block17;
                CharSequence foundMatch = dropBase.getPlayerLevelVariable();
                if (foundMatch == null || foundMatch.length() == 0) {
                    string2 = "%level%";
                } else {
                    String string9 = dropBase.getPlayerLevelVariable();
                    string2 = string9;
                    Intrinsics.checkNotNull(string9);
                }
                String variableToUse = string2;
                levelToUse = 0;
                if (info.getPlayerLevelVariableCache().containsKey(variableToUse)) {
                    Integer n = info.getPlayerLevelVariableCache().get(variableToUse);
                    Intrinsics.checkNotNull(n);
                    levelToUse = ((Number)n).intValue();
                } else {
                    LevelManager levelManager = main.getLevelManager();
                    Player player = info.getMobKiller();
                    LivingEntityWrapper livingEntityWrapper = info.getLmEntity();
                    Intrinsics.checkNotNull(livingEntityWrapper);
                    PlayerLevelSourceResult result = levelManager.getPlayerLevelSourceNumber(player, livingEntityWrapper, variableToUse);
                    levelToUse = result.isNumericResult() ? (int)result.getNumericResult() : 1;
                    objectArray = Integer.valueOf(levelToUse);
                    info.getPlayerLevelVariableCache().put(variableToUse, (Integer)objectArray);
                }
                if (dropBase.getMinPlayerLevel() > 0 && levelToUse < dropBase.getMinPlayerLevel()) break block18;
                int n = dropBase.getMaxPlayerLevel();
                boolean bl = 1 <= n ? n < levelToUse : false;
                if (!bl) break block17;
            }
            if (main.getDebugManager().isDebugTypeEnabled(DebugType.CUSTOM_DROPS)) {
                if (dropBase instanceof CustomDropItem) {
                    string = "&8 - &7Mob: &b%s&7, item: %s, lvl-src: %s, minlvl: %s, maxlvl: %s player level criteria not met";
                    objectArray = new Object[5];
                    LivingEntityWrapper livingEntityWrapper = info.getLmEntity();
                    objectArray[0] = livingEntityWrapper != null ? livingEntityWrapper.getTypeName() : null;
                    objectArray[1] = ((CustomDropItem)dropBase).getMaterial();
                    objectArray[2] = levelToUse;
                    objectArray[3] = dropBase.getMinPlayerLevel();
                    objectArray[4] = dropBase.getMaxPlayerLevel();
                    String string10 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string10, "format(...)");
                    info.addDebugMessage(string10);
                } else {
                    string = "&8 - &7Mob: &b%s&7, (customCommand), lvl-src: %s, minlvl: %s, maxlvl: %s player level criteria not met";
                    objectArray = new Object[4];
                    LivingEntityWrapper livingEntityWrapper = info.getLmEntity();
                    objectArray[0] = livingEntityWrapper != null ? livingEntityWrapper.getTypeName() : null;
                    objectArray[1] = levelToUse;
                    objectArray[2] = dropBase.getMinPlayerLevel();
                    objectArray[3] = dropBase.getMaxPlayerLevel();
                    String string11 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string11, "format(...)");
                    info.addDebugMessage(string11);
                }
            }
            return false;
        }
        return true;
    }

    private final void executeCommand(CustomCommand customCommand, CustomDropProcessingInfo info) {
        if (info.getEquippedOnly() && !customCommand.getRunOnSpawn()) {
            return;
        }
        if (!info.getEquippedOnly() && !customCommand.getRunOnDeath()) {
            return;
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        for (String commandPre : customCommand.getCommands()) {
            String string;
            String string2;
            String command = this.processRangedCommand(commandPre, customCommand);
            LevelManager levelManager = main.getLevelManager();
            LivingEntityWrapper livingEntityWrapper = info.getLmEntity();
            Intrinsics.checkNotNull(livingEntityWrapper);
            LivingEntityWrapper livingEntityWrapper2 = info.getLmEntity();
            Intrinsics.checkNotNull(livingEntityWrapper2);
            command = levelManager.replaceStringPlaceholders(command, livingEntityWrapper, false, livingEntityWrapper2.getAssociatedPlayer(), false);
            String mobScale = "";
            String mobScaleRounded = "";
            if (customCommand.getMobScale() != null) {
                LivingEntityWrapper livingEntityWrapper3 = info.getLmEntity();
                Intrinsics.checkNotNull(livingEntityWrapper3);
                float f = livingEntityWrapper3.getGetMobLevel();
                Double d = customCommand.getMobScale();
                Intrinsics.checkNotNull(d);
                float newScale = f * (float)d.doubleValue();
                mobScale = String.valueOf(newScale);
                mobScaleRounded = String.valueOf((int)Utils.INSTANCE.round(newScale));
            }
            command = StringsKt.replace$default(command, "%mob-scale%", mobScale, false, 4, null);
            if (StringsKt.contains$default((CharSequence)(command = StringsKt.replace$default(command, "%mob-scale-rounded%", mobScaleRounded, false, 4, null)), "%", false, 2, null) && ExternalCompatibilityManager.Companion.getHasPapiInstalled()) {
                command = ExternalCompatibilityManager.Companion.getPapiPlaceholder(info.getMobKiller(), command);
            }
            int maxAllowedTimesToRun = LevelledMobs.Companion.getInstance().getHelperSettings().getInt("customcommand-amount-limit", 10);
            int timesToRun = customCommand.getAmount();
            if (customCommand.getHasAmountRange()) {
                timesToRun = main.getRandom().nextInt(customCommand.getAmountRangeMax() - customCommand.getAmountRangeMin() + 1) + customCommand.getAmountRangeMin();
            }
            if (timesToRun > maxAllowedTimesToRun) {
                timesToRun = maxAllowedTimesToRun;
            }
            if (timesToRun > 1) {
                string2 = "Command (%sx): ";
                Object[] objectArray = new Object[]{timesToRun};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            } else {
                string = "Command: ";
            }
            String debugCommand = string;
            String commandFinal = command;
            DebugManager.Companion.log(DebugType.CUSTOM_COMMANDS, info.getLmEntity(), () -> CustomDropsHandler.executeCommand$lambda$14(debugCommand, commandFinal));
            if (customCommand.getDelay() > 0) {
                String commandToRun = command;
                int finalTimesToRun = timesToRun;
                BukkitRunnable runnable2 = new BukkitRunnable(this, commandToRun, finalTimesToRun){
                    final /* synthetic */ CustomDropsHandler this$0;
                    final /* synthetic */ String $commandToRun;
                    final /* synthetic */ int $finalTimesToRun;
                    {
                        this.this$0 = $receiver;
                        this.$commandToRun = $commandToRun;
                        this.$finalTimesToRun = $finalTimesToRun;
                    }

                    public void run() {
                        CustomDropsHandler.access$executeTheCommand(this.this$0, this.$commandToRun, this.$finalTimesToRun);
                    }
                };
                string2 = runnable2.runTaskLater((Plugin)main, (long)customCommand.getDelay());
                Intrinsics.checkNotNull(string2);
                continue;
            }
            this.executeTheCommand(command, timesToRun);
        }
    }

    private final void executeTheCommand(String command, int timesToRun) {
        for (int i = 0; i < timesToRun; ++i) {
            Bukkit.dispatchCommand((CommandSender)((CommandSender)Bukkit.getConsoleSender()), (String)command);
        }
    }

    private final String processRangedCommand(String command, CustomCommand cc) {
        if (cc.getRangedEntries().isEmpty()) {
            return command;
        }
        String newCommand = command;
        for (Map.Entry<String, String> entry : cc.getRangedEntries().entrySet()) {
            int max;
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            String $this$trim$iv;
            String $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            String rangedKey = entry.getKey();
            String rangedValue = entry.getValue();
            if (!StringsKt.contains$default((CharSequence)rangedValue, "-", false, 2, null)) {
                newCommand = StringsKt.replace$default(newCommand, "%" + rangedKey + "%", rangedValue, false, 4, null);
                continue;
            }
            Object object = rangedValue;
            Regex regex = new Regex("-");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it2 = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it2).length() == 0) continue;
                    list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] nums = thisCollection$iv.toArray(new String[0]);
            if (nums.length != 2) continue;
            $this$toTypedArray$iv = nums[0];
            Utils utils = Utils.INSTANCE;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (!utils.isInteger(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) continue;
            $this$trim$iv = nums[1];
            utils = Utils.INSTANCE;
            $i$f$trim = false;
            $this$trim$iv$iv = $this$trim$iv;
            $i$f$trim2 = false;
            startIndex$iv$iv = 0;
            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (!utils.isInteger(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())) continue;
            String $this$trim$iv2 = nums[0];
            boolean $i$f$trim3 = false;
            CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
            boolean $i$f$trim4 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv2;
                int index$iv$iv2 = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it3 = $this$trim$iv$iv2.charAt(index$iv$iv2);
                boolean bl = false;
                boolean bl4 = match$iv$iv2 = Intrinsics.compare(it3, 32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv2) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv2) break;
                --endIndex$iv$iv2;
            }
            int min = Integer.parseInt(((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString());
            String $this$trim$iv3 = nums[1];
            $i$f$trim = false;
            CharSequence $this$trim$iv$iv3 = $this$trim$iv3;
            boolean $i$f$trim5 = false;
            int startIndex$iv$iv3 = 0;
            int endIndex$iv$iv3 = $this$trim$iv$iv3.length() - 1;
            boolean startFound$iv$iv3 = false;
            while (startIndex$iv$iv3 <= endIndex$iv$iv3) {
                boolean match$iv$iv3;
                int index$iv$iv3 = !startFound$iv$iv3 ? startIndex$iv$iv3 : endIndex$iv$iv3;
                char it4 = $this$trim$iv$iv3.charAt(index$iv$iv3);
                boolean bl = false;
                boolean bl5 = match$iv$iv3 = Intrinsics.compare(it4, 32) <= 0;
                if (!startFound$iv$iv3) {
                    if (!match$iv$iv3) {
                        startFound$iv$iv3 = true;
                        continue;
                    }
                    ++startIndex$iv$iv3;
                    continue;
                }
                if (!match$iv$iv3) break;
                --endIndex$iv$iv3;
            }
            if ((max = Integer.parseInt(((Object)$this$trim$iv$iv3.subSequence(startIndex$iv$iv3, endIndex$iv$iv3 + 1)).toString())) < min) {
                min = max;
            }
            int rangedNum = LevelledMobs.Companion.getInstance().getRandom().nextInt(max - min + 1) + min;
            newCommand = StringsKt.replace$default(newCommand, "%" + rangedKey + "%", String.valueOf(rangedNum), false, 4, null);
        }
        return newCommand;
    }

    private final ItemStack getCookedVariantOfMeat(ItemStack itemStack) {
        return switch (WhenMappings.$EnumSwitchMapping$0[itemStack.getType().ordinal()]) {
            case 1 -> new ItemStack(Material.COOKED_BEEF);
            case 2 -> new ItemStack(Material.COOKED_CHICKEN);
            case 3 -> new ItemStack(Material.COOKED_COD);
            case 4 -> new ItemStack(Material.COOKED_MUTTON);
            case 5 -> new ItemStack(Material.COOKED_PORKCHOP);
            case 6 -> new ItemStack(Material.COOKED_RABBIT);
            case 7 -> new ItemStack(Material.COOKED_SALMON);
            default -> itemStack;
        };
    }

    public final void setDropInstanceFromId(@NotNull String groupId, @NotNull CustomDropInstance dropInstance) {
        Intrinsics.checkNotNullParameter(groupId, "groupId");
        Intrinsics.checkNotNullParameter(dropInstance, "dropInstance");
        this.groupIdToInstance.put(groupId, dropInstance);
    }

    @Nullable
    public final GroupLimits getGroupLimits(@NotNull CustomDropBase dropBase) {
        Intrinsics.checkNotNullParameter(dropBase, "dropBase");
        GroupLimits limitsDefault = this.groupLimitsMap.get("default");
        if (!dropBase.getHasGroupId() || !this.groupLimitsMap.containsKey(dropBase.getGroupId())) {
            return limitsDefault;
        }
        return this.groupLimitsMap.get(dropBase.getGroupId());
    }

    public final void clearGroupIdMappings() {
        this.groupIdToInstance.clear();
    }

    private static final String getCustomItemsFromDropInstance$lambda$2(GroupLimits $groupLimits, String $itemDescription) {
        Intrinsics.checkNotNullParameter($groupLimits, "$groupLimits");
        Intrinsics.checkNotNullParameter($itemDescription, "$itemDescription");
        return "Reached cap-per-item limit of " + $groupLimits.getCapPerItem() + " for " + $itemDescription;
    }

    private static final String getCustomItemsFromDropInstance$lambda$3(GroupLimits $groupLimits, CustomDropBase $drop) {
        Intrinsics.checkNotNullParameter($groupLimits, "$groupLimits");
        Intrinsics.checkNotNullParameter($drop, "$drop");
        return "Reached cap-total of " + $groupLimits.getCapTotal() + " for group: " + $drop.getGroupId();
    }

    private static final String processEnchantmentChances$lambda$6(ItemStack $itemStack) {
        Intrinsics.checkNotNullParameter($itemStack, "$itemStack");
        return "&7item: &b" + $itemStack.getType().name() + "&r, enchts";
    }

    private static final String processEnchantmentChances$lambda$7() {
        return "; ";
    }

    private static final String processEnchantmentChances$lambda$8(Enchantment $enchantment) {
        Intrinsics.checkNotNullParameter($enchantment, "$enchantment");
        return "\n  " + $enchantment.getKey().value() + " ";
    }

    private static final String processEnchantmentChances$lambda$9() {
        return ", ";
    }

    private static final String processEnchantmentChances$lambda$10(int $enchantLevel, float $chanceRole, float $chanceValue) {
        return "(l-" + $enchantLevel + "): &4" + $chanceRole + "&r &b(" + $chanceValue + ")&r";
    }

    private static final String processEnchantmentChances$lambda$11() {
        return ", ";
    }

    private static final String processEnchantmentChances$lambda$12(float $chanceValue, float $chanceRole, int $enchantLevel) {
        String msg = $chanceValue >= 1.0f ? "&b(" + $chanceValue + " chance)" : "&2" + $chanceRole + "&r &b(" + $chanceValue + ")";
        return "(l-" + $enchantLevel + "): " + msg + "&r";
    }

    private static final String processEnchantmentChances$lambda$13(EnchantmentChances.ChanceOptions $opts) {
        return ", used dflt: &2" + $opts.getDefaultLevel() + "&r";
    }

    private static final String executeCommand$lambda$14(String $debugCommand, String $commandFinal) {
        Intrinsics.checkNotNullParameter($debugCommand, "$debugCommand");
        Intrinsics.checkNotNullParameter($commandFinal, "$commandFinal");
        return $debugCommand + $commandFinal;
    }

    public static final /* synthetic */ void access$executeTheCommand(CustomDropsHandler $this, String command, int timesToRun) {
        $this.executeTheCommand(command, timesToRun);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Material.values().length];
            try {
                nArray[Material.BEEF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.CHICKEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.COD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.MUTTON.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.PORKCHOP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.RABBIT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.SALMON.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

