/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands.subcommands;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.commands.MessagesHelper;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.SummonMobOptions;
import io.github.arcaneplugins.levelledmobs.enums.LevellableState;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.AbstractCommandAPICommand;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.CommandAPICommand;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.SuggestionInfo;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.Argument;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.ArgumentSuggestions;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.IntegerArgument;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.ListArgumentBuilder;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.StringArgument;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.executors.CommandArguments;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.executors.ExecutorType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.managers.LevelManager;
import io.github.arcaneplugins.levelledmobs.managers.MobDataManager;
import io.github.arcaneplugins.levelledmobs.misc.LivingEntityPlaceholder;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.misc.RequestedLevel;
import io.github.arcaneplugins.levelledmobs.result.AdditionalLevelInformation;
import io.github.arcaneplugins.levelledmobs.result.MinAndMaxHolder;
import io.github.arcaneplugins.levelledmobs.util.PaperUtils;
import io.github.arcaneplugins.levelledmobs.util.SpigotUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import io.github.arcaneplugins.levelledmobs.wrappers.LivingEntityWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001'B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J2\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0015H\u0002J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006("}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SummonSubcommand;", "", "<init>", "()V", "createInstance", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/CommandAPICommand;", "processCmd", "", "sender", "Lorg/bukkit/command/CommandSender;", "args", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/executors/CommandArguments;", "buildTabSuggestions", "", "", "info", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/SuggestionInfo;", "summonMobs", "options", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SummonMobOptions;", "getSpawnLocation", "Lorg/bukkit/Location;", "player", "Lorg/bukkit/entity/Player;", "location", "entityType", "Lorg/bukkit/entity/EntityType;", "getLocationNearPlayer", "useDistFromPlayer", "", "getRelativeLocation", "xStr", "yStr", "zStr", "world", "Lorg/bukkit/World;", "addVarianceToLocation", "oldLocation", "getEntityNames", "SummonType", "levelledmobs-plugin"})
public final class SummonSubcommand {
    @NotNull
    public static final SummonSubcommand INSTANCE = new SummonSubcommand();

    private SummonSubcommand() {
    }

    @NotNull
    public final CommandAPICommand createInstance() {
        Argument[] argumentArray = new Argument[]{new IntegerArgument("number").replaceSuggestions(ArgumentSuggestions.strings((Collection<String>)Utils.INSTANCE.getOneToNine()))};
        CommandAPICommand commandAPICommand = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("summon").withPermission("levelledmobs.command.summon")).withShortDescription("Various commands for summoning mobs.")).withFullDescription("Various commands for summoning mobs.")).executes(SummonSubcommand::createInstance$lambda$0, new ExecutorType[0])).withOptionalArguments(argumentArray);
        argumentArray = new Argument[]{new StringArgument("mobtype").replaceSuggestions(ArgumentSuggestions.strings((Collection<String>)this.getEntityNames()))};
        CommandAPICommand commandAPICommand2 = (CommandAPICommand)commandAPICommand.withOptionalArguments(argumentArray);
        argumentArray = new Argument[]{new IntegerArgument("moblevel").replaceSuggestions(ArgumentSuggestions.strings((Collection<String>)Utils.INSTANCE.getOneToNine()))};
        CommandAPICommand commandAPICommand3 = (CommandAPICommand)commandAPICommand2.withOptionalArguments(argumentArray);
        argumentArray = new Argument[1];
        String[] stringArray = new String[]{"here", "at-player", "at-location"};
        argumentArray[0] = new StringArgument("designator").replaceSuggestions(ArgumentSuggestions.strings(stringArray));
        CommandAPICommand commandAPICommand4 = (CommandAPICommand)commandAPICommand3.withOptionalArguments(argumentArray);
        argumentArray = new Argument[]{new ListArgumentBuilder("values").skipListValidation(true).withList(SummonSubcommand::createInstance$lambda$1).withStringMapper().buildGreedy()};
        AbstractCommandAPICommand abstractCommandAPICommand = commandAPICommand4.withOptionalArguments(argumentArray);
        Intrinsics.checkNotNullExpressionValue(abstractCommandAPICommand, "withOptionalArguments(...)");
        return (CommandAPICommand)abstractCommandAPICommand;
    }

    private final void processCmd(CommandSender sender, CommandArguments args2) {
        Object object = args2.get("number");
        Integer amount = object instanceof Integer ? (Integer)object : null;
        Object object2 = args2.get("moblevel");
        Integer mobLevel = object2 instanceof Integer ? (Integer)object2 : null;
        Object object3 = args2.get("mobtype");
        String mobType = object3 instanceof String ? (String)object3 : null;
        Object object4 = args2.get("designator");
        String string = object4 instanceof String ? (String)object4 : null;
        if (string == null) {
            string = "here";
        }
        String designator = string;
        String values2 = args2.rawArgsMap().get("values");
        if (amount == null || mobLevel == null || mobType == null) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.usage");
            return;
        }
        EntityType entityType = null;
        try {
            String string2 = mobType;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
            entityType = EntityType.valueOf((String)string3);
        }
        catch (IllegalArgumentException ex) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.invalid-entity-type", "%entityType%", mobType);
            return;
        }
        RequestedLevel requestedLevel = new RequestedLevel();
        requestedLevel.setLevel(mobLevel);
        CommandSender commandSender = sender;
        Location location = commandSender instanceof Player ? ((Player)sender).getLocation() : (commandSender instanceof CommandBlock ? ((BlockState)sender).getLocation() : null);
        String nbtData = null;
        String string4 = values2;
        List miscArgs = string4 != null ? Utils.INSTANCE.splitStringWithQuotes(string4) : (List)new ArrayList();
        int n = miscArgs.size();
        for (int i = 0; i < n; ++i) {
            String arg = (String)miscArgs.get(i);
            if (!StringsKt.startsWith$default(arg, "{", false, 2, null) || !StringsKt.endsWith$default(arg, "}", false, 2, null)) continue;
            nbtData = arg;
        }
        String string5 = designator.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string5, "toLowerCase(...)");
        switch (string5) {
            case "here": {
                if (location == null) {
                    MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.here.usage");
                    return;
                }
                LivingEntityPlaceholder lmPlaceHolder = LivingEntityPlaceholder.Companion.getInstance(entityType, location);
                SummonMobOptions options = new SummonMobOptions(lmPlaceHolder, sender);
                options.setAmount(amount);
                options.setRequestedLevel(requestedLevel);
                options.setSummonType(SummonType.HERE);
                options.setOverride(true);
                options.setNbtData(nbtData);
                this.summonMobs(options);
                lmPlaceHolder.free();
                break;
            }
            case "at-location": {
                String xStr = "";
                String yStr = "";
                String zStr = "";
                World world = null;
                int n2 = miscArgs.size();
                block19: for (int i = 0; i < n2; ++i) {
                    String arg = (String)miscArgs.get(i);
                    if (StringsKt.startsWith$default(arg, "{", false, 2, null)) continue;
                    switch (i) {
                        case 0: {
                            xStr = arg;
                            continue block19;
                        }
                        case 1: {
                            yStr = arg;
                            continue block19;
                        }
                        case 2: {
                            zStr = arg;
                            continue block19;
                        }
                        case 3: {
                            world = Bukkit.getWorld((String)arg);
                            if (world != null) continue block19;
                            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.atLocation.invalid-world", "%world%", arg);
                            return;
                        }
                    }
                }
                if (world == null) {
                    MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.atLocation.usage-console");
                    return;
                }
                location = this.getRelativeLocation(sender, xStr, yStr, zStr, world);
                if (location == null) {
                    sender.sendMessage("Invalid location");
                    return;
                }
                LivingEntityPlaceholder lmPlaceHolder = LivingEntityPlaceholder.Companion.getInstance(entityType, location);
                SummonMobOptions options = new SummonMobOptions(lmPlaceHolder, sender);
                options.setAmount(amount);
                options.setRequestedLevel(requestedLevel);
                options.setSummonType(SummonType.AT_LOCATION);
                options.setOverride(true);
                options.setNbtData(nbtData);
                this.summonMobs(options);
                lmPlaceHolder.free();
                break;
            }
            case "at-player": {
                boolean didSummon = false;
                int n3 = miscArgs.size();
                for (int i = 0; i < n3; ++i) {
                    String arg = (String)miscArgs.get(i);
                    if (StringsKt.startsWith$default(arg, "{", false, 2, null)) continue;
                    boolean offline = false;
                    World world = null;
                    Player target = Bukkit.getPlayer((String)arg);
                    if (target == null) {
                        offline = true;
                    } else if (sender instanceof Player) {
                        if (!((Player)sender).canSee(target) && !((Player)sender).isOp()) {
                            offline = true;
                        }
                        location = target.getLocation();
                        world = location.getWorld();
                    } else {
                        location = target.getLocation();
                        world = target.getWorld();
                    }
                    if (offline || world == null) {
                        MessagesHelper.INSTANCE.showMessage(sender, "common.player-offline", "%player%", arg);
                        return;
                    }
                    Location location2 = location;
                    Intrinsics.checkNotNull(location2);
                    LivingEntityPlaceholder lmPlaceHolder = LivingEntityPlaceholder.Companion.getInstance(entityType, location2);
                    SummonMobOptions options = new SummonMobOptions(lmPlaceHolder, sender);
                    options.setAmount(amount);
                    options.setRequestedLevel(requestedLevel);
                    options.setSummonType(SummonType.AT_PLAYER);
                    options.setPlayer(target);
                    options.setOverride(true);
                    options.setNbtData(nbtData);
                    this.summonMobs(options);
                    lmPlaceHolder.free();
                    didSummon = true;
                    break;
                }
                if (didSummon) break;
                MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.atPlayer.usage");
                break;
            }
            default: {
                MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.usage");
            }
        }
    }

    private final List<String> buildTabSuggestions(SuggestionInfo<CommandSender> info) {
        String string = info.currentInput();
        Intrinsics.checkNotNullExpressionValue(string, "currentInput(...)");
        List<String> args2 = Utils.INSTANCE.splitStringWithQuotes(string);
        String string2 = args2.get(5).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        switch (string2) {
            case "here": {
                return new ArrayList();
            }
            case "at-player": {
                List suggestions = new ArrayList();
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    if (info.sender() instanceof Player) {
                        CommandSender commandSender = info.sender();
                        Intrinsics.checkNotNull(commandSender, "null cannot be cast to non-null type org.bukkit.entity.Player");
                        Player player = (Player)commandSender;
                        if (!player.canSee(onlinePlayer) && !player.isOp()) continue;
                        String string3 = onlinePlayer.getName();
                        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                        suggestions.add(string3);
                        continue;
                    }
                    String string4 = onlinePlayer.getName();
                    Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
                    suggestions.add(string4);
                }
                return suggestions;
            }
            case "at-location": {
                int suggestions = args2.size();
                boolean bl = 6 <= suggestions ? suggestions < 9 : false;
                if (bl) {
                    return Utils.INSTANCE.getOneToNine();
                }
                if (args2.size() != 9) break;
                List worlds = new ArrayList();
                for (World world : Bukkit.getWorlds()) {
                    String string5 = world.getName();
                    Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
                    worlds.add(string5);
                }
                return worlds;
            }
            default: {
                return new ArrayList();
            }
        }
        return new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void summonMobs(SummonMobOptions options) {
        String[] entity;
        List<String> messages;
        CommandSender sender = options.getSender();
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Player target = options.getPlayer();
        Location location = options.getLmPlaceholder().getLocation();
        if (CollectionsKt.contains((Iterable)main.getLevelManager().getForcedBlockedEntityTypes(), options.getLmPlaceholder().getEntityType())) {
            List<String> list = main.getMessagesCfg().getStringList("command.levelledmobs.summon.not-levellable");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            List<String> messages2 = list;
            messages2 = Utils.INSTANCE.replaceAllInList(messages2, "%prefix%", main.getConfigUtils().getPrefix());
            messages2 = Utils.INSTANCE.replaceAllInList(messages2, "%entity%", options.getLmPlaceholder().getTypeName());
            messages2 = Utils.INSTANCE.colorizeAllInList(messages2);
            messages2.forEach(arg_0 -> SummonSubcommand.summonMobs$lambda$2(sender, arg_0));
            return;
        }
        if (!sender.isOp() && !options.getOverride() && main.getLevelInterface().getLevellableState(options.getLmPlaceholder()) != LevellableState.ALLOWED) {
            List<String> list = main.getMessagesCfg().getStringList("command.levelledmobs.summon.not-levellable");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            List<String> messages3 = list;
            messages3 = Utils.INSTANCE.replaceAllInList(messages3, "%prefix%", main.getConfigUtils().getPrefix());
            messages3 = Utils.INSTANCE.replaceAllInList(messages3, "%entity%", options.getLmPlaceholder().getTypeName());
            messages3 = Utils.INSTANCE.colorizeAllInList(messages3);
            messages3.forEach(arg_0 -> SummonSubcommand.summonMobs$lambda$3(sender, arg_0));
            return;
        }
        if (options.getAmount() < 1) {
            List<String> list = main.getMessagesCfg().getStringList("command.levelledmobs.summon.amount-limited.min");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            List<String> messages4 = list;
            messages4 = Utils.INSTANCE.replaceAllInList(messages4, "%prefix%", main.getConfigUtils().getPrefix());
            messages4 = Utils.INSTANCE.colorizeAllInList(messages4);
            messages4.forEach(arg_0 -> SummonSubcommand.summonMobs$lambda$4(sender, arg_0));
        }
        int maxAmount = main.getHelperSettings().getInt("customize-summon-command-limit", 100);
        if (options.getAmount() > maxAmount) {
            options.setAmount(maxAmount);
            List<String> list = main.getMessagesCfg().getStringList("command.levelledmobs.summon.amount-limited.max");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            List<String> messages5 = list;
            messages5 = Utils.INSTANCE.replaceAllInList(messages5, "%prefix%", main.getConfigUtils().getPrefix());
            messages5 = Utils.INSTANCE.replaceAllInList(messages5, "%maxAmount%", String.valueOf(maxAmount));
            messages5 = Utils.INSTANCE.colorizeAllInList(messages5);
            messages5.forEach(arg_0 -> SummonSubcommand.summonMobs$lambda$5(sender, arg_0));
        }
        MinAndMaxHolder levels = main.getLevelManager().getMinAndMaxLevels(options.getLmPlaceholder());
        RequestedLevel requestedLevel = options.getRequestedLevel();
        Intrinsics.checkNotNull(requestedLevel);
        if ((float)requestedLevel.getLevelMin() < levels.getMin() && !sender.hasPermission("levelledmobs.command.summon.bypass-level-limit") && !options.getOverride()) {
            RequestedLevel requestedLevel2 = options.getRequestedLevel();
            Intrinsics.checkNotNull(requestedLevel2);
            requestedLevel2.setMinAllowedLevel(levels.getMinAsInt());
            List<String> list = main.getMessagesCfg().getStringList("command.levelledmobs.summon.level-limited.min");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            messages = list;
            messages = Utils.INSTANCE.replaceAllInList(messages, "%prefix%", main.getConfigUtils().getPrefix());
            messages = Utils.INSTANCE.replaceAllInList(messages, "%minLevel%", String.valueOf(levels.getMin()));
            messages = Utils.INSTANCE.colorizeAllInList(messages);
            messages.forEach(arg_0 -> SummonSubcommand.summonMobs$lambda$6(sender, arg_0));
        }
        RequestedLevel requestedLevel3 = options.getRequestedLevel();
        Intrinsics.checkNotNull(requestedLevel3);
        if ((float)requestedLevel3.getLevelMax() > levels.getMax() && !sender.hasPermission("levelledmobs.command.summon.bypass-level-limit") && !options.getOverride()) {
            RequestedLevel requestedLevel4 = options.getRequestedLevel();
            Intrinsics.checkNotNull(requestedLevel4);
            requestedLevel4.setMaxAllowedLevel(levels.getMaxAsInt());
            List<String> list = main.getMessagesCfg().getStringList("command.levelledmobs.summon.level-limited.max");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            messages = list;
            messages = Utils.INSTANCE.replaceAllInList(messages, "%prefix%", main.getConfigUtils().getPrefix());
            messages = Utils.INSTANCE.replaceAllInList(messages, "%maxLevel%", String.valueOf(levels.getMax()));
            messages = Utils.INSTANCE.colorizeAllInList(messages);
            messages.forEach(arg_0 -> SummonSubcommand.summonMobs$lambda$7(sender, arg_0));
        }
        if (options.getSummonType() == SummonType.HERE) {
            location = this.addVarianceToLocation(location);
        }
        if (options.getSummonType() == SummonType.HERE || options.getSummonType() == SummonType.AT_PLAYER) {
            int distFromPlayer = main.getHelperSettings().getInt("summon-command-spawn-distance-from-player", 5);
            int minDistFromPlayer = main.getHelperSettings().getInt("summon-command-spawn-min-distance-from-player", 0);
            if (distFromPlayer > 0 && target != null) {
                EntityType entityType = options.getLmPlaceholder().getEntityType();
                Intrinsics.checkNotNull(entityType);
                Location locationTemp = this.getSpawnLocation(target, location, entityType);
                if (locationTemp == null) {
                    sender.sendMessage("Unable to find a suitable spawn location");
                    return;
                }
                location = locationTemp;
            } else if (target == null && sender instanceof BlockCommandSender) {
                location = new Location(location.getWorld(), (double)location.getBlockX(), (double)(location.getBlockY() + 2), (double)location.getBlockZ());
            }
        }
        int n = options.getAmount();
        for (int i = 0; i < n; ++i) {
            int n2;
            boolean locationTemp;
            boolean bl = locationTemp = location.getWorld() != null;
            if (_Assertions.ENABLED && !locationTemp) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            RequestedLevel requestedLevel5 = options.getRequestedLevel();
            Intrinsics.checkNotNull(requestedLevel5);
            if (requestedLevel5.getHasLevelRange()) {
                ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                RequestedLevel requestedLevel6 = options.getRequestedLevel();
                Intrinsics.checkNotNull(requestedLevel6);
                int n3 = requestedLevel6.getLevelRangeMin();
                RequestedLevel requestedLevel7 = options.getRequestedLevel();
                Intrinsics.checkNotNull(requestedLevel7);
                n2 = threadLocalRandom.nextInt(n3, requestedLevel7.getLevelRangeMax() + 1);
            } else {
                RequestedLevel requestedLevel8 = options.getRequestedLevel();
                Intrinsics.checkNotNull(requestedLevel8);
                n2 = requestedLevel8.getLevel();
            }
            int useLevel = n2;
            World world = location.getWorld();
            EntityType entityType = options.getLmPlaceholder().getEntityType();
            Intrinsics.checkNotNull(entityType);
            Intrinsics.checkNotNullExpressionValue(world.spawnEntity(location, entityType), "spawnEntity(...)");
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntityWrapper lmEntity = LivingEntityWrapper.Companion.getInstance((LivingEntity)entity);
            lmEntity.setSummonedLevel(useLevel);
            lmEntity.setNewlySpawned(true);
            Object object = LevelManager.Companion.getSummonedOrSpawnEggs_Lock();
            synchronized (object) {
                boolean $i$a$-synchronized-SummonSubcommand$summonMobs$92 = false;
                Object $i$a$-synchronized-SummonSubcommand$summonMobs$92 = main.getLevelManager().getSummonedOrSpawnEggs().put(lmEntity.getLivingEntity(), null);
            }
            Object[] objectArray = (String[])options.getNbtData();
            if (!(objectArray == null || objectArray.length() == 0)) {
                objectArray = new String[1];
                Intrinsics.checkNotNull(options.getNbtData());
                lmEntity.setNbtData(CollectionsKt.mutableListOf(objectArray));
            }
            lmEntity.setSummonedSender(sender);
            PersistentDataContainer persistentDataContainer = lmEntity.getLivingEntity().getPersistentDataContainer();
            Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
            object = persistentDataContainer;
            synchronized (object) {
                boolean bl2 = false;
                lmEntity.getPdc().set(NamespacedKeys.INSTANCE.getWasSummoned(), PersistentDataType.INTEGER, (Object)1);
                Unit unit = Unit.INSTANCE;
            }
            MobDataManager.Companion.populateAttributeCache$default(MobDataManager.Companion, lmEntity, null, 2, null);
            objectArray = new AdditionalLevelInformation[]{AdditionalLevelInformation.NOT_APPLICABLE};
            main.getLevelInterface().applyLevelToMob(lmEntity, useLevel, true, options.getOverride(), SetsKt.mutableSetOf(objectArray));
            lmEntity.free();
        }
        boolean printResults = main.getHelperSettings().getBoolean("print-lm-summon-results", true);
        SummonType summonType = options.getSummonType();
        switch (summonType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[summonType.ordinal()]) {
            case 1: {
                if (!printResults) break;
                entity = new String[]{"%amount%", "%level%", "%entity%"};
                String[] stringArray = entity;
                entity = new String[]{String.valueOf(options.getAmount()), String.valueOf(options.getRequestedLevel()), options.getLmPlaceholder().getTypeName()};
                MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.here.success", stringArray, entity);
                break;
            }
            case 2: {
                String string;
                if (!printResults) break;
                entity = new String[]{"%amount%", "%level%", "%entity%", "%x%", "%y%", "%z%", "%world%"};
                String[] stringArray = entity;
                entity = new String[7];
                entity[0] = String.valueOf(options.getAmount());
                entity[1] = String.valueOf(options.getRequestedLevel());
                entity[2] = options.getLmPlaceholder().getTypeName();
                entity[3] = String.valueOf(location.getBlockX());
                entity[4] = String.valueOf(location.getBlockY());
                entity[5] = String.valueOf(location.getBlockZ());
                if (location.getWorld() == null) {
                    string = "(null)";
                } else {
                    String string2 = location.getWorld().getName();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                }
                entity[6] = string;
                MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.atLocation.success", stringArray, entity);
                break;
            }
            case 3: {
                if (!printResults) break;
                String playerName = main.getVer().isRunningPaper() ? PaperUtils.INSTANCE.getPlayerDisplayName(target) : SpigotUtils.INSTANCE.getPlayerDisplayName(target);
                String[] stringArray = new String[]{"%amount%", "%level%", "%entity%", "%targetUsername%", "%targetDisplayname%"};
                String[] stringArray2 = stringArray;
                stringArray = new String[5];
                stringArray[0] = String.valueOf(options.getAmount());
                stringArray[1] = String.valueOf(options.getRequestedLevel());
                stringArray[2] = options.getLmPlaceholder().getTypeName();
                Object object = target;
                if (object == null || (object = object.getName()) == null) {
                    object = "(null)";
                }
                stringArray[3] = object;
                stringArray[4] = target == null ? "(null)" : playerName;
                MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.summon.atPlayer.success", stringArray2, stringArray);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected SummonType value of " + options.getSummonType() + "!");
            }
        }
    }

    private final Location getSpawnLocation(Player player, Location location, EntityType entityType) {
        if (location.getWorld() == null) {
            return null;
        }
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Integer maxDistFromPlayer = main.getHelperSettings().getInt2("summon-command-spawn-max-distance-from-player", null);
        if (maxDistFromPlayer == null) {
            maxDistFromPlayer = main.getHelperSettings().getInt2("summon-command-spawn-distance-from-player", null);
        }
        if (maxDistFromPlayer == null) {
            maxDistFromPlayer = 5;
        }
        int minDistFromPlayer = (int)Math.min((double)main.getHelperSettings().getInt("summon-command-spawn-min-distance-from-player", 3), (double)maxDistFromPlayer.intValue());
        List blockCandidates = new ArrayList();
        int blocksNeeded = entityType == EntityType.ENDERMAN || entityType == EntityType.RAVAGER ? 3 : 2;
        for (int i = 0; i < 10; ++i) {
            Block block;
            Location tempLocation;
            int y;
            Integer n = maxDistFromPlayer;
            int useDistance = n == null || minDistFromPlayer != n ? ThreadLocalRandom.current().nextInt(minDistFromPlayer, maxDistFromPlayer) : maxDistFromPlayer.intValue();
            Location startingLocation = this.getLocationNearPlayer(player, location, useDistance);
            Intrinsics.checkNotNullExpressionValue(startingLocation.clone(), "clone(...)");
            boolean foundBlock = false;
            int maxYVariance = (int)Math.max((double)(maxDistFromPlayer - useDistance), 10.0);
            for (y = 0; y < maxYVariance; ++y) {
                Intrinsics.checkNotNullExpressionValue(tempLocation.add(0.0, Math.min((double)y, 1.0), 0.0).getBlock(), "getBlock(...)");
                if (!block.getType().isSolid()) continue;
                blockCandidates.add(block);
                foundBlock = true;
                break;
            }
            if (!foundBlock) {
                tempLocation = startingLocation.clone();
                y = 1;
                if (y <= maxYVariance) {
                    while (true) {
                        Intrinsics.checkNotNullExpressionValue(tempLocation.add(0.0, -1.0, 0.0).getBlock(), "getBlock(...)");
                        if (block.getType().isSolid()) {
                            blockCandidates.add(block);
                            break;
                        }
                        if (y == maxYVariance) break;
                        ++y;
                    }
                }
            }
            if (blockCandidates.size() >= 10) break;
        }
        if (blockCandidates.isEmpty()) {
            return null;
        }
        Collections.shuffle(blockCandidates);
        for (Block block : blockCandidates) {
            boolean notGoodSpot = false;
            int n = blocksNeeded + 1;
            for (int i = 1; i < n; ++i) {
                Block temp;
                Intrinsics.checkNotNullExpressionValue(location.getWorld().getBlockAt(block.getX(), block.getY() + i, block.getZ()), "getBlockAt(...)");
                if (temp.isPassable()) continue;
                notGoodSpot = true;
                break;
            }
            if (notGoodSpot) continue;
            return block.getLocation().add(0.5, (double)(blocksNeeded - 1), 0.5);
        }
        return null;
    }

    private final Location getLocationNearPlayer(Player player, Location location, int useDistFromPlayer) {
        int newX = location.getBlockX();
        int newZ = location.getBlockZ();
        double rotation = (player.getLocation().getYaw() - (float)180) % (float)360;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        if (0.0 <= rotation && rotation < 22.5) {
            newZ -= useDistFromPlayer;
        } else if (22.5 <= rotation && rotation < 67.5) {
            newX += useDistFromPlayer;
            newZ -= useDistFromPlayer;
        } else if (67.5 <= rotation && rotation < 112.5) {
            newX += useDistFromPlayer;
        } else if (112.5 <= rotation && rotation < 157.5) {
            newX += useDistFromPlayer;
            newZ += useDistFromPlayer;
        } else if (157.5 <= rotation && rotation < 202.5) {
            newZ += useDistFromPlayer;
        } else if (202.5 <= rotation && rotation < 247.5) {
            newX -= useDistFromPlayer;
            newZ += useDistFromPlayer;
        } else if (247.5 <= rotation && rotation < 292.5) {
            newX -= useDistFromPlayer;
        } else if (292.5 <= rotation && rotation < 337.5) {
            newX -= useDistFromPlayer;
            newZ -= useDistFromPlayer;
        } else {
            newZ -= useDistFromPlayer;
        }
        return new Location(location.getWorld(), (double)newX, (double)location.getBlockY(), (double)newZ);
    }

    private final Location getRelativeLocation(CommandSender sender, String xStr, String yStr, String zStr, World world) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        boolean xRelative = false;
        boolean yRelative = false;
        boolean zRelative = false;
        if (sender instanceof Player || sender instanceof BlockCommandSender) {
            double addition;
            if (xStr.charAt(0) == '~') {
                double d = x = sender instanceof Player ? ((Player)sender).getLocation().getX() : (double)((BlockCommandSender)sender).getBlock().getX();
                if (xStr.length() > 1) {
                    addition = 0.0;
                    try {
                        String string = xStr.substring(1);
                        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                        addition = Double.parseDouble(string);
                    }
                    catch (NumberFormatException ex) {
                        return null;
                    }
                    x += addition;
                }
                xRelative = true;
            }
            if (yStr.charAt(0) == '~') {
                double d = y = sender instanceof Player ? ((Player)sender).getLocation().getY() : (double)((BlockCommandSender)sender).getBlock().getY();
                if (yStr.length() > 1) {
                    addition = 0.0;
                    try {
                        String string = yStr.substring(1);
                        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                        addition = Double.parseDouble(string);
                    }
                    catch (NumberFormatException ex) {
                        return null;
                    }
                    y += addition;
                }
                yRelative = true;
            }
            if (zStr.charAt(0) == '~') {
                double d = z = sender instanceof Player ? ((Player)sender).getLocation().getZ() : (double)((BlockCommandSender)sender).getBlock().getZ();
                if (zStr.length() > 1) {
                    addition = 0.0;
                    try {
                        String string = zStr.substring(1);
                        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                        addition = Double.parseDouble(string);
                    }
                    catch (NumberFormatException ex) {
                        return null;
                    }
                    z += addition;
                }
                zRelative = true;
            }
        }
        if (!xRelative) {
            try {
                x = Double.parseDouble(xStr);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (!yRelative) {
            try {
                y = Double.parseDouble(yStr);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (!zRelative) {
            try {
                z = Double.parseDouble(zStr);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return new Location(world, x, y, z);
    }

    private final Location addVarianceToLocation(Location oldLocation) {
        double min = 0.5;
        double max = 2.5;
        Random random1 = new Random();
        Random random2 = new Random();
        for (int i = 0; i < 20; ++i) {
            double x = oldLocation.getX() + min + (max - min) * random1.nextDouble();
            double z = oldLocation.getZ() + min + (max - min) * random2.nextDouble();
            Location newLocation = new Location(oldLocation.getWorld(), x, oldLocation.getY(), z);
            if (!newLocation.getBlock().isPassable() || !newLocation.add(0.0, 1.0, 0.0).getBlock().isPassable()) continue;
            return newLocation;
        }
        return oldLocation;
    }

    private final List<String> getEntityNames() {
        List entityNames = new ArrayList();
        for (EntityType entityType : EntriesMappings.entries$0) {
            String string = entityType.toString();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            entityNames.add(string2);
        }
        return entityNames;
    }

    private static final void createInstance$lambda$0(CommandSender sender, CommandArguments args2) {
        Intrinsics.checkNotNull(sender);
        Intrinsics.checkNotNull(args2);
        INSTANCE.processCmd(sender, args2);
    }

    private static final Collection createInstance$lambda$1(SuggestionInfo info) {
        Intrinsics.checkNotNull(info);
        return INSTANCE.buildTabSuggestions(info);
    }

    private static final void summonMobs$lambda$2(CommandSender $sender, String s) {
        Intrinsics.checkNotNullParameter($sender, "$sender");
        String string = s;
        Intrinsics.checkNotNull(string);
        $sender.sendMessage(string);
    }

    private static final void summonMobs$lambda$3(CommandSender $sender, String s) {
        Intrinsics.checkNotNullParameter($sender, "$sender");
        String string = s;
        Intrinsics.checkNotNull(string);
        $sender.sendMessage(string);
    }

    private static final void summonMobs$lambda$4(CommandSender $sender, String s) {
        Intrinsics.checkNotNullParameter($sender, "$sender");
        String string = s;
        Intrinsics.checkNotNull(string);
        $sender.sendMessage(string);
    }

    private static final void summonMobs$lambda$5(CommandSender $sender, String s) {
        Intrinsics.checkNotNullParameter($sender, "$sender");
        String string = s;
        Intrinsics.checkNotNull(string);
        $sender.sendMessage(string);
    }

    private static final void summonMobs$lambda$6(CommandSender $sender, String s) {
        Intrinsics.checkNotNullParameter($sender, "$sender");
        String string = s;
        Intrinsics.checkNotNull(string);
        $sender.sendMessage(string);
    }

    private static final void summonMobs$lambda$7(CommandSender $sender, String s) {
        Intrinsics.checkNotNullParameter($sender, "$sender");
        String string = s;
        Intrinsics.checkNotNull(string);
        $sender.sendMessage(string);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EntityType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EntityType.values()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SummonSubcommand$SummonType;", "", "<init>", "(Ljava/lang/String;I)V", "HERE", "AT_PLAYER", "AT_LOCATION", "levelledmobs-plugin"})
    public static final class SummonType
    extends Enum<SummonType> {
        public static final /* enum */ SummonType HERE = new SummonType();
        public static final /* enum */ SummonType AT_PLAYER = new SummonType();
        public static final /* enum */ SummonType AT_LOCATION = new SummonType();
        private static final /* synthetic */ SummonType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SummonType[] values() {
            return (SummonType[])$VALUES.clone();
        }

        public static SummonType valueOf(String value) {
            return Enum.valueOf(SummonType.class, value);
        }

        @NotNull
        public static EnumEntries<SummonType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = summonTypeArray = new SummonType[]{SummonType.HERE, SummonType.AT_PLAYER, SummonType.AT_LOCATION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SummonType.values().length];
            try {
                nArray[SummonType.HERE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SummonType.AT_LOCATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SummonType.AT_PLAYER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

