/*
 * Decompiled with CFR 0.152.
 */
package io.github.arcaneplugins.levelledmobs.commands.subcommands;

import io.github.arcaneplugins.levelledmobs.LevelledMobs;
import io.github.arcaneplugins.levelledmobs.MainCompanion;
import io.github.arcaneplugins.levelledmobs.commands.MessagesBase;
import io.github.arcaneplugins.levelledmobs.commands.MessagesHelper;
import io.github.arcaneplugins.levelledmobs.commands.subcommands.SpawnerBaseClass;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.AbstractCommandAPICommand;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.CommandAPICommand;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.SuggestionInfo;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.Argument;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.ArgumentSuggestions;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.ListArgumentBuilder;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.arguments.StringArgument;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.executors.CommandArguments;
import io.github.arcaneplugins.levelledmobs.libs.commandapi.executors.ExecutorType;
import io.github.arcaneplugins.levelledmobs.libs.jetbrains.annotations.NotNull;
import io.github.arcaneplugins.levelledmobs.misc.NamespacedKeys;
import io.github.arcaneplugins.levelledmobs.util.Log;
import io.github.arcaneplugins.levelledmobs.util.MessageUtils;
import io.github.arcaneplugins.levelledmobs.util.PaperUtils;
import io.github.arcaneplugins.levelledmobs.util.SpigotUtils;
import io.github.arcaneplugins.levelledmobs.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0016\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerSubcommand;", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerBaseClass;", "<init>", "()V", "createInstance", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/CommandAPICommand;", "processResults", "", "sender", "Lorg/bukkit/command/CommandSender;", "input", "Lio/github/arcaneplugins/levelledmobs/libs/commandapi/executors/CommandArguments;", "operation", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerSubcommand$OperationEnum;", "parseInfoCommand", "allSpawnerOptions", "", "", "parseCopyCommand", "copyGotDisabled", "playerId", "Ljava/util/UUID;", "infoGotDisabled", "parseCreateCommand", "args", "generateSpawner", "info", "Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerBaseClass$CustomSpawnerInfo;", "OperationEnum", "levelledmobs-plugin"})
public final class SpawnerSubcommand
extends SpawnerBaseClass {
    @NotNull
    public static final SpawnerSubcommand INSTANCE = new SpawnerSubcommand();
    @NotNull
    private static final List<String> allSpawnerOptions;

    private SpawnerSubcommand() {
    }

    @NotNull
    public final CommandAPICommand createInstance() {
        CommandAPICommand[] commandAPICommandArray = new CommandAPICommand[1];
        Argument[] argumentArray = new Argument[]{new ListArgumentBuilder("values").skipListValidation(true).withList(SpawnerSubcommand::createInstance$lambda$2).withStringMapper().buildGreedy()};
        commandAPICommandArray[0] = ((CommandAPICommand)new CommandAPICommand("create").executes(SpawnerSubcommand::createInstance$lambda$1, new ExecutorType[0])).withOptionalArguments(argumentArray);
        CommandAPICommand commandAPICommand = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("spawner").withPermission("levelledmobs.command.spawner")).withShortDescription("Various commands for creating spawner cubes.")).withFullDescription("Various commands for creating spawner cubes.")).executes(SpawnerSubcommand::createInstance$lambda$0, new ExecutorType[0])).withSubcommands(commandAPICommandArray);
        commandAPICommandArray = new CommandAPICommand[1];
        argumentArray = new Argument[1];
        String[] stringArray = new String[]{"on", "off"};
        argumentArray[0] = new StringArgument("value").replaceSuggestions(ArgumentSuggestions.strings(stringArray));
        commandAPICommandArray[0] = ((CommandAPICommand)new CommandAPICommand("copy").executes(SpawnerSubcommand::createInstance$lambda$3, new ExecutorType[0])).withOptionalArguments(argumentArray);
        CommandAPICommand commandAPICommand2 = (CommandAPICommand)commandAPICommand.withSubcommands(commandAPICommandArray);
        commandAPICommandArray = new CommandAPICommand[1];
        argumentArray = new Argument[1];
        stringArray = new String[]{"on", "off"};
        argumentArray[0] = new StringArgument("value").replaceSuggestions(ArgumentSuggestions.strings(stringArray));
        commandAPICommandArray[0] = ((CommandAPICommand)new CommandAPICommand("info").executes(SpawnerSubcommand::createInstance$lambda$4, new ExecutorType[0])).withOptionalArguments(argumentArray);
        AbstractCommandAPICommand abstractCommandAPICommand = commandAPICommand2.withSubcommands(commandAPICommandArray);
        Intrinsics.checkNotNullExpressionValue(abstractCommandAPICommand, "withSubcommands(...)");
        return (CommandAPICommand)abstractCommandAPICommand;
    }

    private final void processResults(CommandSender sender, CommandArguments input, OperationEnum operation) {
        String[] stringArray = input.rawArgs();
        Intrinsics.checkNotNullExpressionValue(stringArray, "rawArgs(...)");
        if (((Object[])stringArray).length == 0) {
            switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
                case 1: {
                    MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.usage");
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull(sender, "null cannot be cast to non-null type org.bukkit.entity.Player");
                    UUID uUID = ((Player)sender).getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    UUID playerId = uUID;
                    MessagesHelper.INSTANCE.showMessage(sender, MainCompanion.Companion.getInstance().getSpawnerCopyIds().contains(playerId) ? "command.levelledmobs.spawner.copy.status-enabled" : "command.levelledmobs.spawner.copy.status-not-enabled");
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNull(sender, "null cannot be cast to non-null type org.bukkit.entity.Player");
                    UUID uUID = ((Player)sender).getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    UUID playerId = uUID;
                    MessagesHelper.INSTANCE.showMessage(sender, MainCompanion.Companion.getInstance().getSpawnerInfoIds().contains(playerId) ? "command.levelledmobs.spawner.info.status-enabled" : "command.levelledmobs.spawner.info.status-not-enabled");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return;
        }
        String string = input.rawArgs()[0];
        Intrinsics.checkNotNullExpressionValue(string, "get(...)");
        List<String> args2 = Utils.INSTANCE.splitStringWithQuotes(string);
        boolean hasGivePlayer = false;
        int n = args2.size();
        for (int i = 0; i < n; ++i) {
            if (!StringsKt.equals("/giveplayer", args2.get(i), true)) continue;
            hasGivePlayer = true;
            break;
        }
        if (!(hasGivePlayer && operation == OperationEnum.CREATE || sender instanceof Player)) {
            String messageName = operation != OperationEnum.CREATE ? "common.players-only" : "command.levelledmobs.spawner.no-player";
            MessagesHelper.INSTANCE.showMessage(sender, messageName);
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
            case 1: {
                this.parseCreateCommand(sender, args2);
                break;
            }
            case 2: {
                this.parseCopyCommand(sender, input);
                break;
            }
            case 3: {
                this.parseInfoCommand(sender, input);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void parseInfoCommand(CommandSender sender, CommandArguments input) {
        Intrinsics.checkNotNull(sender, "null cannot be cast to non-null type org.bukkit.entity.Player");
        UUID uUID = ((Player)sender).getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Object object = input.get("value");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
        String value = (String)object;
        if (StringsKt.equals("on", value, true)) {
            if (main.getMainCompanion().getSpawnerCopyIds().contains(playerId)) {
                this.copyGotDisabled(sender, playerId);
            }
            main.getMainCompanion().getSpawnerInfoIds().add(playerId);
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.info.enabled");
        } else if (StringsKt.equals("off", value, true)) {
            this.infoGotDisabled(sender, playerId);
        }
    }

    private final void parseCopyCommand(CommandSender sender, CommandArguments input) {
        LevelledMobs main = LevelledMobs.Companion.getInstance();
        Intrinsics.checkNotNull(sender, "null cannot be cast to non-null type org.bukkit.entity.Player");
        UUID uUID = ((Player)sender).getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        Object object = input.get("value");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
        String value = (String)object;
        if (StringsKt.equals("on", value, true)) {
            if (main.getMainCompanion().getSpawnerInfoIds().contains(playerId)) {
                this.infoGotDisabled(sender, playerId);
            }
            main.getMainCompanion().getSpawnerCopyIds().add(playerId);
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.copy.enabled");
        } else if (StringsKt.equals("off", value, true)) {
            this.copyGotDisabled(sender, playerId);
        }
    }

    private final void copyGotDisabled(CommandSender sender, UUID playerId) {
        MainCompanion.Companion.getInstance().getSpawnerCopyIds().remove(playerId);
        MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.copy.disabled");
    }

    private final void infoGotDisabled(CommandSender sender, UUID playerId) {
        MainCompanion.Companion.getInstance().getSpawnerInfoIds().remove(playerId);
        MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.info.disabled");
    }

    private final void parseCreateCommand(CommandSender sender, List<String> args2) {
        int i;
        this.setHadInvalidArg(false);
        SpawnerBaseClass.CustomSpawnerInfo info = new SpawnerBaseClass.CustomSpawnerInfo();
        if (sender instanceof Player) {
            info.setPlayer((Player)sender);
        }
        int n = args2.size();
        for (i = 1; i < n; ++i) {
            String arg = args2.get(i);
            if (!StringsKt.equals("/nolore", arg, true)) continue;
            info.setNoLore(true);
            break;
        }
        n = allSpawnerOptions.size() - 1;
        block37: for (i = 0; i < n; ++i) {
            boolean mustBeANumber = i > 4;
            String command = allSpawnerOptions.get(i);
            String foundValue = this.getArgValue(command, args2, mustBeANumber);
            if (this.getHadInvalidArg()) {
                return;
            }
            CharSequence charSequence = foundValue;
            if (charSequence == null || charSequence.length() == 0) continue;
            switch (command) {
                case "/name": {
                    info.setCustomName(foundValue);
                    continue block37;
                }
                case "/customdropid": {
                    info.setCustomDropId(foundValue);
                    continue block37;
                }
                case "/lore": {
                    info.setCustomLore(foundValue);
                    continue block37;
                }
                case "/spawntype": {
                    try {
                        String string = foundValue;
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                        String string2 = string.toUpperCase(locale);
                        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
                        info.setSpawnType(EntityType.valueOf((String)string2));
                        continue block37;
                    }
                    catch (Exception ignored) {
                        sender.sendMessage("Invalid spawn type: " + foundValue);
                        return;
                    }
                }
                case "/minlevel": {
                    info.setMinLevel(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/maxlevel": {
                    info.setMaxLevel(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/delay": {
                    info.setDelay(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/maxnearbyentities": {
                    info.setMaxNearbyEntities(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/minspawndelay": {
                    info.setMinSpawnDelay(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/maxspawndelay": {
                    info.setMaxSpawnDelay(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/requiredplayerrange": {
                    info.setRequiredPlayerRange(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/spawncount": {
                    info.setSpawnCount(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/spawnrange": {
                    info.setSpawnRange(Integer.parseInt(foundValue));
                    continue block37;
                }
                case "/giveplayer": {
                    if (((CharSequence)foundValue).length() == 0) {
                        MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.no-player-specified");
                        return;
                    }
                    try {
                        info.setPlayer(Bukkit.getPlayer((String)foundValue));
                    }
                    catch (Exception e) {
                        MessagesHelper.INSTANCE.showMessage(sender, "common.player-offline", "%player%", foundValue);
                        return;
                    }
                    if (info.getPlayer() != null) continue block37;
                    MessagesHelper.INSTANCE.showMessage(sender, "common.player-offline", "%player%", foundValue);
                    return;
                }
            }
        }
        if (info.getMinLevel() == -1 && info.getMaxLevel() == -1) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.no-level-specified");
            return;
        }
        if (info.getPlayer() == null) {
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.no-player-specified");
            return;
        }
        this.generateSpawner(sender, info);
    }

    public final void generateSpawner(@NotNull CommandSender sender, @NotNull SpawnerBaseClass.CustomSpawnerInfo info) {
        ItemStack item;
        ItemMeta meta;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(info, "info");
        if (info.getCustomName() != null) {
            info.setCustomName(MessageUtils.INSTANCE.colorizeAll(info.getCustomName()));
        }
        if ((meta = (item = new ItemStack(Material.SPAWNER)).getItemMeta()) != null) {
            SpawnerBaseClass.Companion.setMetaItems(meta, info, "LM Spawner");
            meta.getPersistentDataContainer().set(NamespacedKeys.INSTANCE.getKeySpawner(), PersistentDataType.INTEGER, (Object)1);
            meta.getPersistentDataContainer().set(NamespacedKeys.INSTANCE.getKeySpawnerMinLevel(), PersistentDataType.INTEGER, (Object)info.getMinLevel());
            meta.getPersistentDataContainer().set(NamespacedKeys.INSTANCE.getKeySpawnerMaxLevel(), PersistentDataType.INTEGER, (Object)info.getMaxLevel());
            CharSequence charSequence = info.getCustomDropId();
            if (!(charSequence == null || charSequence.length() == 0)) {
                PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getKeySpawnerCustomDropId();
                String string = info.getCustomDropId();
                Intrinsics.checkNotNull(string);
                persistentDataContainer.set(namespacedKey, PersistentDataType.STRING, (Object)string);
            }
            if (info.getSpawnType() != EntityType.UNKNOWN) {
                meta.getPersistentDataContainer().set(NamespacedKeys.INSTANCE.getKeySpawnerSpawnType(), PersistentDataType.STRING, (Object)info.getSpawnType().toString());
            }
            if (info.getSpawnRange() != null) {
                PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getKeySpawnerSpawnRange();
                Integer n = info.getSpawnRange();
                Intrinsics.checkNotNull(n);
                persistentDataContainer.set(namespacedKey, PersistentDataType.INTEGER, (Object)n);
            }
            if (info.getMinSpawnDelay() != null) {
                PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getKeySpawnerMinSpawnDelay();
                Integer n = info.getMinSpawnDelay();
                Intrinsics.checkNotNull(n);
                persistentDataContainer.set(namespacedKey, PersistentDataType.INTEGER, (Object)n);
            }
            if (info.getMaxSpawnDelay() != null) {
                PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getKeySpawnerMaxSpawnDelay();
                Integer n = info.getMaxSpawnDelay();
                Intrinsics.checkNotNull(n);
                persistentDataContainer.set(namespacedKey, PersistentDataType.INTEGER, (Object)n);
            }
            if (info.getSpawnCount() != null) {
                PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getKeySpawnerSpawnCount();
                Integer n = info.getSpawnCount();
                Intrinsics.checkNotNull(n);
                persistentDataContainer.set(namespacedKey, PersistentDataType.INTEGER, (Object)n);
            }
            if (info.getRequiredPlayerRange() != null) {
                PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getKeySpawnerRequiredPlayerRange();
                Integer n = info.getRequiredPlayerRange();
                Intrinsics.checkNotNull(n);
                persistentDataContainer.set(namespacedKey, PersistentDataType.INTEGER, (Object)n);
            }
            if (info.getMaxNearbyEntities() != null) {
                PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getKeySpawnerMaxNearbyEntities();
                Integer n = info.getMaxNearbyEntities();
                Intrinsics.checkNotNull(n);
                persistentDataContainer.set(namespacedKey, PersistentDataType.INTEGER, (Object)n);
            }
            if (info.getDelay() != null) {
                PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getKeySpawnerDelay();
                Integer n = info.getDelay();
                Intrinsics.checkNotNull(n);
                persistentDataContainer.set(namespacedKey, PersistentDataType.INTEGER, (Object)n);
            }
            if (info.getCustomName() != null) {
                PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
                NamespacedKey namespacedKey = NamespacedKeys.INSTANCE.getKeySpawnerCustomName();
                String string = info.getCustomName();
                Intrinsics.checkNotNull(string);
                persistentDataContainer.set(namespacedKey, PersistentDataType.STRING, (Object)string);
            }
            item.setItemMeta(meta);
        }
        Player player = info.getPlayer();
        Intrinsics.checkNotNull(player);
        int useInvSlotNum = player.getInventory().getHeldItemSlot();
        Player player2 = info.getPlayer();
        Intrinsics.checkNotNull(player2);
        if (player2.getInventory().getItem(useInvSlotNum) != null) {
            useInvSlotNum = -1;
        }
        if (useInvSlotNum == -1) {
            for (int i = 0; i < 36; ++i) {
                Player player3 = info.getPlayer();
                Intrinsics.checkNotNull(player3);
                if (player3.getInventory().getItem(i) != null) continue;
                useInvSlotNum = i;
                break;
            }
        }
        if (useInvSlotNum == -1) {
            Player player4 = info.getPlayer();
            Intrinsics.checkNotNull(player4);
            String string = player4.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.inventory-full", string, "");
            return;
        }
        Player player5 = info.getPlayer();
        Intrinsics.checkNotNull(player5);
        player5.getInventory().setItem(useInvSlotNum, item);
        String playerName = LevelledMobs.Companion.getInstance().getVer().isRunningPaper() ? PaperUtils.INSTANCE.getPlayerDisplayName(info.getPlayer()) : SpigotUtils.INSTANCE.getPlayerDisplayName(info.getPlayer());
        String[] stringArray = new String[]{"%minlevel%", "%maxlevel%", "%playername%"};
        String[] stringArray2 = stringArray;
        stringArray = new String[]{String.valueOf(info.getMinLevel()), String.valueOf(info.getMaxLevel()), playerName};
        List<String> message = MessagesBase.getMessage("command.levelledmobs.spawner.spawner-give-message-console", stringArray2, stringArray);
        if (!((Collection)message).isEmpty()) {
            Log.INSTANCE.inf(StringsKt.replace$default(message.get(0), LevelledMobs.Companion.getInstance().getConfigUtils().getPrefix() + " ", "", false, 4, null));
        }
        Player player6 = info.getPlayer();
        Intrinsics.checkNotNull(player6);
        String string = player6.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.spawner-give-message", string, "");
    }

    private static final void createInstance$lambda$0(CommandSender sender, CommandArguments commandArguments) {
        Intrinsics.checkNotNull(sender);
        MessagesHelper.INSTANCE.showMessage(sender, "command.levelledmobs.spawner.usage");
    }

    private static final void createInstance$lambda$1(CommandSender sender, CommandArguments args2) {
        Intrinsics.checkNotNull(sender);
        Intrinsics.checkNotNull(args2);
        INSTANCE.processResults(sender, args2, OperationEnum.CREATE);
    }

    private static final Collection createInstance$lambda$2(SuggestionInfo info) {
        Intrinsics.checkNotNull(info);
        return INSTANCE.buildTabSuggestions(allSpawnerOptions, info);
    }

    private static final void createInstance$lambda$3(CommandSender sender, CommandArguments args2) {
        if (!(sender instanceof Player)) {
            Intrinsics.checkNotNull(sender);
            MessagesHelper.INSTANCE.showMessage(sender, "common.players-only");
        } else {
            Intrinsics.checkNotNull(args2);
            INSTANCE.processResults(sender, args2, OperationEnum.COPY);
        }
    }

    private static final void createInstance$lambda$4(CommandSender sender, CommandArguments args2) {
        if (!(sender instanceof Player)) {
            Intrinsics.checkNotNull(sender);
            MessagesHelper.INSTANCE.showMessage(sender, "common.players-only");
        } else {
            Intrinsics.checkNotNull(args2);
            INSTANCE.processResults(sender, args2, OperationEnum.INFO);
        }
    }

    static {
        String[] stringArray = new String[]{"/name", "/customdropid", "/spawntype", "/giveplayer", "/lore", "/minlevel", "/maxlevel", "/delay", "/maxnearbyentities", "/minspawndelay", "/maxspawndelay", "/requiredplayerrange", "/spawncount", "/spawnrange", "/nolore"};
        allSpawnerOptions = CollectionsKt.mutableListOf(stringArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/arcaneplugins/levelledmobs/commands/subcommands/SpawnerSubcommand$OperationEnum;", "", "<init>", "(Ljava/lang/String;I)V", "CREATE", "COPY", "INFO", "levelledmobs-plugin"})
    private static final class OperationEnum
    extends Enum<OperationEnum> {
        public static final /* enum */ OperationEnum CREATE = new OperationEnum();
        public static final /* enum */ OperationEnum COPY = new OperationEnum();
        public static final /* enum */ OperationEnum INFO = new OperationEnum();
        private static final /* synthetic */ OperationEnum[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OperationEnum[] values() {
            return (OperationEnum[])$VALUES.clone();
        }

        public static OperationEnum valueOf(String value) {
            return Enum.valueOf(OperationEnum.class, value);
        }

        @NotNull
        public static EnumEntries<OperationEnum> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = operationEnumArray = new OperationEnum[]{OperationEnum.CREATE, OperationEnum.COPY, OperationEnum.INFO};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OperationEnum.values().length];
            try {
                nArray[OperationEnum.CREATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperationEnum.COPY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperationEnum.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

